package software.amazon.awscdk.services.ssmquicksetup;

/**
 * Creates a Quick Setup configuration manager resource.
 * <p>
 * This object is a collection of desired state configurations for multiple configuration definitions and summaries describing the deployments of those definitions.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ssmquicksetup.*;
 * CfnConfigurationManager cfnConfigurationManager = CfnConfigurationManager.Builder.create(this, "MyCfnConfigurationManager")
 *         .configurationDefinitions(List.of(ConfigurationDefinitionProperty.builder()
 *                 .parameters(Map.of(
 *                         "parametersKey", "parameters"))
 *                 .type("type")
 *                 // the properties below are optional
 *                 .id("id")
 *                 .localDeploymentAdministrationRoleArn("localDeploymentAdministrationRoleArn")
 *                 .localDeploymentExecutionRoleName("localDeploymentExecutionRoleName")
 *                 .typeVersion("typeVersion")
 *                 .build()))
 *         // the properties below are optional
 *         .description("description")
 *         .name("name")
 *         .tags(Map.of(
 *                 "tagsKey", "tags"))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssmquicksetup-configurationmanager.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssmquicksetup-configurationmanager.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-24T11:33:23.689Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ssmquicksetup.CfnConfigurationManager")
public class CfnConfigurationManager extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.ITaggableV2 {

    protected CfnConfigurationManager(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnConfigurationManager(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ssmquicksetup.CfnConfigurationManager.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnConfigurationManager(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ssmquicksetup.CfnConfigurationManagerProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The datetime stamp when the configuration manager was created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrCreatedAt() {
        return software.amazon.jsii.Kernel.get(this, "attrCreatedAt", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The datetime stamp when the configuration manager was last updated.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrLastModifiedAt() {
        return software.amazon.jsii.Kernel.get(this, "attrLastModifiedAt", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ARN of the Quick Setup configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrManagerArn() {
        return software.amazon.jsii.Kernel.get(this, "attrManagerArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Summaries of the state of the configuration manager.
     * <p>
     * These summaries include an aggregate of the statuses from the configuration definition associated with the configuration manager. This includes deployment statuses, association statuses, drift statuses, health checks, and more.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable getAttrStatusSummaries() {
        return software.amazon.jsii.Kernel.get(this, "attrStatusSummaries", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.IResolvable.class));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getCdkTagManager() {
        return software.amazon.jsii.Kernel.get(this, "cdkTagManager", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The definition of the Quick Setup configuration that the configuration manager deploys.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getConfigurationDefinitions() {
        return software.amazon.jsii.Kernel.get(this, "configurationDefinitions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The definition of the Quick Setup configuration that the configuration manager deploys.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setConfigurationDefinitions(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "configurationDefinitions", java.util.Objects.requireNonNull(value, "configurationDefinitions is required"));
    }

    /**
     * The definition of the Quick Setup configuration that the configuration manager deploys.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setConfigurationDefinitions(final @org.jetbrains.annotations.NotNull java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.ssmquicksetup.CfnConfigurationManager.ConfigurationDefinitionProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.ssmquicksetup.CfnConfigurationManager.ConfigurationDefinitionProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "configurationDefinitions", java.util.Objects.requireNonNull(value, "configurationDefinitions is required"));
    }

    /**
     * The description of the configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The description of the configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDescription(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "description", value);
    }

    /**
     * The name of the configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "name", value);
    }

    /**
     * Key-value pairs of metadata to assign to the configuration manager.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getTags() {
        return java.util.Optional.ofNullable((java.util.Map<java.lang.String, java.lang.String>)(software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableMap).orElse(null);
    }

    /**
     * Key-value pairs of metadata to assign to the configuration manager.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTags(final @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "tags", value);
    }
    /**
     * The definition of a Quick Setup configuration.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ssmquicksetup.*;
     * ConfigurationDefinitionProperty configurationDefinitionProperty = ConfigurationDefinitionProperty.builder()
     *         .parameters(Map.of(
     *                 "parametersKey", "parameters"))
     *         .type("type")
     *         // the properties below are optional
     *         .id("id")
     *         .localDeploymentAdministrationRoleArn("localDeploymentAdministrationRoleArn")
     *         .localDeploymentExecutionRoleName("localDeploymentExecutionRoleName")
     *         .typeVersion("typeVersion")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssmquicksetup-configurationmanager-configurationdefinition.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssmquicksetup-configurationmanager-configurationdefinition.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ssmquicksetup.CfnConfigurationManager.ConfigurationDefinitionProperty")
    @software.amazon.jsii.Jsii.Proxy(ConfigurationDefinitionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ConfigurationDefinitionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The parameters for the configuration definition type.
         * <p>
         * Parameters for configuration definitions vary based the configuration type. The following lists outline the parameters for each configuration type.
         * <p>
         * <ul>
         * <li><strong>AWS Config Recording (Type: AWS QuickSetupType-CFGRecording)</strong> - - <code>RecordAllResources</code></li>
         * <li>Description: (Optional) A boolean value that determines whether all supported resources are recorded. The default value is " <code>true</code> ".</li>
         * <li><code>ResourceTypesToRecord</code></li>
         * <li>Description: (Optional) A comma separated list of resource types you want to record.</li>
         * <li><code>RecordGlobalResourceTypes</code></li>
         * <li>Description: (Optional) A boolean value that determines whether global resources are recorded with all resource configurations. The default value is " <code>false</code> ".</li>
         * <li><code>GlobalResourceTypesRegion</code></li>
         * <li>Description: (Optional) Determines the AWS Region where global resources are recorded.</li>
         * <li><code>UseCustomBucket</code></li>
         * <li>Description: (Optional) A boolean value that determines whether a custom Amazon S3 bucket is used for delivery. The default value is " <code>false</code> ".</li>
         * <li><code>DeliveryBucketName</code></li>
         * <li>Description: (Optional) The name of the Amazon S3 bucket you want AWS Config to deliver configuration snapshots and configuration history files to.</li>
         * <li><code>DeliveryBucketPrefix</code></li>
         * <li>Description: (Optional) The key prefix you want to use in the custom Amazon S3 bucket.</li>
         * <li><code>NotificationOptions</code></li>
         * <li>Description: (Optional) Determines the notification configuration for the recorder. The valid values are <code>NoStreaming</code> , <code>UseExistingTopic</code> , and <code>CreateTopic</code> . The default value is <code>NoStreaming</code> .</li>
         * <li><code>CustomDeliveryTopicAccountId</code></li>
         * <li>Description: (Optional) The ID of the AWS account where the Amazon SNS topic you want to use for notifications resides. You must specify a value for this parameter if you use the <code>UseExistingTopic</code> notification option.</li>
         * <li><code>CustomDeliveryTopicName</code></li>
         * <li>Description: (Optional) The name of the Amazon SNS topic you want to use for notifications. You must specify a value for this parameter if you use the <code>UseExistingTopic</code> notification option.</li>
         * <li><code>RemediationSchedule</code></li>
         * <li>Description: (Optional) A rate expression that defines the schedule for drift remediation. The valid values are <code>rate(30 days)</code> , <code>rate(7 days)</code> , <code>rate(1 days)</code> , and <code>none</code> . The default value is " <code>none</code> ".</li>
         * <li><code>TargetAccounts</code></li>
         * <li>Description: (Optional) The ID of the AWS account initiating the configuration deployment. You only need to provide a value for this parameter if you want to deploy the configuration locally. A value must be provided for either <code>TargetAccounts</code> or <code>TargetOrganizationalUnits</code> .</li>
         * <li><code>TargetOrganizationalUnits</code></li>
         * <li>Description: (Optional) The ID of the root of your Organization. This configuration type doesn't currently support choosing specific OUs. The configuration will be deployed to all the OUs in the Organization.</li>
         * <li><code>TargetRegions</code></li>
         * <li>Description: (Required) A comma separated list of AWS Regions you want to deploy the configuration to.</li>
         * <li><strong>Change Manager (Type: AWS QuickSetupType-SSMChangeMgr)</strong> - - <code>DelegatedAccountId</code></li>
         * <li>Description: (Required) The ID of the delegated administrator account.</li>
         * <li><code>JobFunction</code></li>
         * <li>Description: (Required) The name for the Change Manager job function.</li>
         * <li><code>PermissionType</code></li>
         * <li>Description: (Optional) Specifies whether you want to use default administrator permissions for the job function role, or provide a custom IAM policy. The valid values are <code>CustomPermissions</code> and <code>AdminPermissions</code> . The default value for the parameter is <code>CustomerPermissions</code> .</li>
         * <li><code>CustomPermissions</code></li>
         * <li>Description: (Optional) A JSON string containing the IAM policy you want your job function to use. You must provide a value for this parameter if you specify <code>CustomPermissions</code> for the <code>PermissionType</code> parameter.</li>
         * <li><code>TargetOrganizationalUnits</code></li>
         * <li>Description: (Required) A comma separated list of organizational units (OUs) you want to deploy the configuration to.</li>
         * <li><code>TargetRegions</code></li>
         * <li>Description: (Required) A comma separated list of AWS Regions you want to deploy the configuration to.</li>
         * <li><strong>Conformance Packs (Type: AWS QuickSetupType-CFGCPacks)</strong> - - <code>DelegatedAccountId</code></li>
         * <li>Description: (Optional) The ID of the delegated administrator account. This parameter is required for Organization deployments.</li>
         * <li><code>RemediationSchedule</code></li>
         * <li>Description: (Optional) A rate expression that defines the schedule for drift remediation. The valid values are <code>rate(30 days)</code> , <code>rate(14 days)</code> , <code>rate(2 days)</code> , and <code>none</code> . The default value is " <code>none</code> ".</li>
         * <li><code>CPackNames</code></li>
         * <li>Description: (Required) A comma separated list of AWS Config conformance packs.</li>
         * <li><code>TargetAccounts</code></li>
         * <li>Description: (Optional) The ID of the AWS account initiating the configuration deployment. You only need to provide a value for this parameter if you want to deploy the configuration locally. A value must be provided for either <code>TargetAccounts</code> or <code>TargetOrganizationalUnits</code> .</li>
         * <li><code>TargetOrganizationalUnits</code></li>
         * <li>Description: (Optional) The ID of the root of your Organization. This configuration type doesn't currently support choosing specific OUs. The configuration will be deployed to all the OUs in the Organization.</li>
         * <li><code>TargetRegions</code></li>
         * <li>Description: (Required) A comma separated list of AWS Regions you want to deploy the configuration to.</li>
         * <li><strong>Default Host Management Configuration (Type: AWS QuickSetupType-DHMC)</strong> - - <code>UpdateSSMAgent</code></li>
         * <li>Description: (Optional) A boolean value that determines whether the SSM Agent is updated on the target instances every 2 weeks. The default value is " <code>true</code> ".</li>
         * <li><code>TargetOrganizationalUnits</code></li>
         * <li>Description: (Required) A comma separated list of organizational units (OUs) you want to deploy the configuration to.</li>
         * <li><code>TargetRegions</code></li>
         * <li>Description: (Required) The AWS Regions to deploy the configuration to. For this type, the parameter only accepts a value of <code>AllRegions</code> .</li>
         * <li><strong>DevOps Guru (Type: AWS QuickSetupType-DevOpsGuru)</strong> - - <code>AnalyseAllResources</code></li>
         * <li>Description: (Optional) A boolean value that determines whether DevOps Guru analyzes all AWS CloudFormation stacks in the account. The default value is " <code>false</code> ".</li>
         * <li><code>EnableSnsNotifications</code></li>
         * <li>Description: (Optional) A boolean value that determines whether DevOps Guru sends notifications when an insight is created. The default value is " <code>true</code> ".</li>
         * <li><code>EnableSsmOpsItems</code></li>
         * <li>Description: (Optional) A boolean value that determines whether DevOps Guru creates an OpsCenter OpsItem when an insight is created. The default value is " <code>true</code> ".</li>
         * <li><code>EnableDriftRemediation</code></li>
         * <li>Description: (Optional) A boolean value that determines whether a drift remediation schedule is used. The default value is " <code>false</code> ".</li>
         * <li><code>RemediationSchedule</code></li>
         * <li>Description: (Optional) A rate expression that defines the schedule for drift remediation. The valid values are <code>rate(30 days)</code> , <code>rate(14 days)</code> , <code>rate(1 days)</code> , and <code>none</code> . The default value is " <code>none</code> ".</li>
         * <li><code>TargetAccounts</code></li>
         * <li>Description: (Optional) The ID of the AWS account initiating the configuration deployment. You only need to provide a value for this parameter if you want to deploy the configuration locally. A value must be provided for either <code>TargetAccounts</code> or <code>TargetOrganizationalUnits</code> .</li>
         * <li><code>TargetOrganizationalUnits</code></li>
         * <li>Description: (Optional) A comma separated list of organizational units (OUs) you want to deploy the configuration to.</li>
         * <li><code>TargetRegions</code></li>
         * <li>Description: (Required) A comma separated list of AWS Regions you want to deploy the configuration to.</li>
         * <li><strong>Distributor (Type: AWS QuickSetupType-Distributor)</strong> - - <code>PackagesToInstall</code></li>
         * <li>Description: (Required) A comma separated list of packages you want to install on the target instances. The valid values are <code>AWSEFSTools</code> , <code>AWSCWAgent</code> , and <code>AWSEC2LaunchAgent</code> .</li>
         * <li><code>RemediationSchedule</code></li>
         * <li>Description: (Optional) A rate expression that defines the schedule for drift remediation. The valid values are <code>rate(30 days)</code> , <code>rate(14 days)</code> , <code>rate(2 days)</code> , and <code>none</code> . The default value is " <code>rate(30 days)</code> ".</li>
         * <li><code>IsPolicyAttachAllowed</code></li>
         * <li>Description: (Optional) A boolean value that determines whether Quick Setup attaches policies to instances profiles already associated with the target instances. The default value is " <code>false</code> ".</li>
         * <li><code>TargetType</code></li>
         * <li>Description: (Optional) Determines how instances are targeted for local account deployments. Don't specify a value for this parameter if you're deploying to OUs. The valid values are <code>*</code> , <code>InstanceIds</code> , <code>ResourceGroups</code> , and <code>Tags</code> . Use <code>*</code> to target all instances in the account.</li>
         * <li><code>TargetInstances</code></li>
         * <li>Description: (Optional) A comma separated list of instance IDs. You must provide a value for this parameter if you specify <code>InstanceIds</code> for the <code>TargetType</code> parameter.</li>
         * <li><code>TargetTagKey</code></li>
         * <li>Description: (Required) The tag key assigned to the instances you want to target. You must provide a value for this parameter if you specify <code>Tags</code> for the <code>TargetType</code> parameter.</li>
         * <li><code>TargetTagValue</code></li>
         * <li>Description: (Required) The value of the tag key assigned to the instances you want to target. You must provide a value for this parameter if you specify <code>Tags</code> for the <code>TargetType</code> parameter.</li>
         * <li><code>ResourceGroupName</code></li>
         * <li>Description: (Required) The name of the resource group associated with the instances you want to target. You must provide a value for this parameter if you specify <code>ResourceGroups</code> for the <code>TargetType</code> parameter.</li>
         * <li><code>TargetAccounts</code></li>
         * <li>Description: (Optional) The ID of the AWS account initiating the configuration deployment. You only need to provide a value for this parameter if you want to deploy the configuration locally. A value must be provided for either <code>TargetAccounts</code> or <code>TargetOrganizationalUnits</code> .</li>
         * <li><code>TargetOrganizationalUnits</code></li>
         * <li>Description: (Optional) A comma separated list of organizational units (OUs) you want to deploy the configuration to.</li>
         * <li><code>TargetRegions</code></li>
         * <li>Description: (Required) A comma separated list of AWS Regions you want to deploy the configuration to.</li>
         * <li><strong>Host Management (Type: AWS QuickSetupType-SSMHostMgmt)</strong> - - <code>UpdateSSMAgent</code></li>
         * <li>Description: (Optional) A boolean value that determines whether the SSM Agent is updated on the target instances every 2 weeks. The default value is " <code>true</code> ".</li>
         * <li><code>UpdateEc2LaunchAgent</code></li>
         * <li>Description: (Optional) A boolean value that determines whether the EC2 Launch agent is updated on the target instances every month. The default value is " <code>false</code> ".</li>
         * <li><code>CollectInventory</code></li>
         * <li>Description: (Optional) A boolean value that determines whether instance metadata is collected on the target instances every 30 minutes. The default value is " <code>true</code> ".</li>
         * <li><code>ScanInstances</code></li>
         * <li>Description: (Optional) A boolean value that determines whether the target instances are scanned daily for available patches. The default value is " <code>true</code> ".</li>
         * <li><code>InstallCloudWatchAgent</code></li>
         * <li>Description: (Optional) A boolean value that determines whether the Amazon CloudWatch agent is installed on the target instances. The default value is " <code>false</code> ".</li>
         * <li><code>UpdateCloudWatchAgent</code></li>
         * <li>Description: (Optional) A boolean value that determines whether the Amazon CloudWatch agent is updated on the target instances every month. The default value is " <code>false</code> ".</li>
         * <li><code>IsPolicyAttachAllowed</code></li>
         * <li>Description: (Optional) A boolean value that determines whether Quick Setup attaches policies to instances profiles already associated with the target instances. The default value is " <code>false</code> ".</li>
         * <li><code>TargetType</code></li>
         * <li>Description: (Optional) Determines how instances are targeted for local account deployments. Don't specify a value for this parameter if you're deploying to OUs. The valid values are <code>*</code> , <code>InstanceIds</code> , <code>ResourceGroups</code> , and <code>Tags</code> . Use <code>*</code> to target all instances in the account.</li>
         * <li><code>TargetInstances</code></li>
         * <li>Description: (Optional) A comma separated list of instance IDs. You must provide a value for this parameter if you specify <code>InstanceIds</code> for the <code>TargetType</code> parameter.</li>
         * <li><code>TargetTagKey</code></li>
         * <li>Description: (Optional) The tag key assigned to the instances you want to target. You must provide a value for this parameter if you specify <code>Tags</code> for the <code>TargetType</code> parameter.</li>
         * <li><code>TargetTagValue</code></li>
         * <li>Description: (Optional) The value of the tag key assigned to the instances you want to target. You must provide a value for this parameter if you specify <code>Tags</code> for the <code>TargetType</code> parameter.</li>
         * <li><code>ResourceGroupName</code></li>
         * <li>Description: (Optional) The name of the resource group associated with the instances you want to target. You must provide a value for this parameter if you specify <code>ResourceGroups</code> for the <code>TargetType</code> parameter.</li>
         * <li><code>TargetAccounts</code></li>
         * <li>Description: (Optional) The ID of the AWS account initiating the configuration deployment. You only need to provide a value for this parameter if you want to deploy the configuration locally. A value must be provided for either <code>TargetAccounts</code> or <code>TargetOrganizationalUnits</code> .</li>
         * <li><code>TargetOrganizationalUnits</code></li>
         * <li>Description: (Optional) A comma separated list of organizational units (OUs) you want to deploy the configuration to.</li>
         * <li><code>TargetRegions</code></li>
         * <li>Description: (Required) A comma separated list of AWS Regions you want to deploy the configuration to.</li>
         * <li><strong>OpsCenter (Type: AWS QuickSetupType-SSMOpsCenter)</strong> - - <code>DelegatedAccountId</code></li>
         * <li>Description: (Required) The ID of the delegated administrator account.</li>
         * <li><code>TargetOrganizationalUnits</code></li>
         * <li>Description: (Required) A comma separated list of organizational units (OUs) you want to deploy the configuration to.</li>
         * <li><code>TargetRegions</code></li>
         * <li>Description: (Required) A comma separated list of AWS Regions you want to deploy the configuration to.</li>
         * <li><strong>Patch Policy (Type: AWS QuickSetupType-PatchPolicy)</strong> - - <code>PatchPolicyName</code></li>
         * <li>Description: (Required) A name for the patch policy. The value you provide is applied to target Amazon EC2 instances as a tag.</li>
         * <li><code>SelectedPatchBaselines</code></li>
         * <li>Description: (Required) An array of JSON objects containing the information for the patch baselines to include in your patch policy.</li>
         * <li><code>PatchBaselineUseDefault</code></li>
         * <li>Description: (Optional) A value that determines whether the selected patch baselines are all AWS provided. Supported values are <code>default</code> and <code>custom</code> .</li>
         * <li><code>PatchBaselineRegion</code></li>
         * <li>Description: (Required) The AWS Region where the patch baseline exist.</li>
         * <li><code>ConfigurationOptionsPatchOperation</code></li>
         * <li>Description: (Optional) Determines whether target instances scan for available patches, or scan and install available patches. The valid values are <code>Scan</code> and <code>ScanAndInstall</code> . The default value for the parameter is <code>Scan</code> .</li>
         * <li><code>ConfigurationOptionsScanValue</code></li>
         * <li>Description: (Optional) A cron expression that is used as the schedule for when instances scan for available patches.</li>
         * <li><code>ConfigurationOptionsInstallValue</code></li>
         * <li>Description: (Optional) A cron expression that is used as the schedule for when instances install available patches.</li>
         * <li><code>ConfigurationOptionsScanNextInterval</code></li>
         * <li>Description: (Optional) A boolean value that determines whether instances should scan for available patches at the next cron interval. The default value is " <code>false</code> ".</li>
         * <li><code>ConfigurationOptionsInstallNextInterval</code></li>
         * <li>Description: (Optional) A boolean value that determines whether instances should scan for available patches at the next cron interval. The default value is " <code>false</code> ".</li>
         * <li><code>RebootOption</code></li>
         * <li>Description: (Optional) Determines whether instances are rebooted after patches are installed. Valid values are <code>RebootIfNeeded</code> and <code>NoReboot</code> .</li>
         * <li><code>IsPolicyAttachAllowed</code></li>
         * <li>Description: (Optional) A boolean value that determines whether Quick Setup attaches policies to instances profiles already associated with the target instances. The default value is " <code>false</code> ".</li>
         * <li><code>OutputLogEnableS3</code></li>
         * <li>Description: (Optional) A boolean value that determines whether command output logs are sent to Amazon S3.</li>
         * <li><code>OutputS3Location</code></li>
         * <li>Description: (Optional) Information about the Amazon S3 bucket where you want to store the output details of the request.</li>
         * <li><code>OutputBucketRegion</code></li>
         * <li>Description: (Optional) The AWS Region where the Amazon S3 bucket you want to deliver command output to is located.</li>
         * <li><code>OutputS3BucketName</code></li>
         * <li>Description: (Optional) The name of the Amazon S3 bucket you want to deliver command output to.</li>
         * <li><code>OutputS3KeyPrefix</code></li>
         * <li>Description: (Optional) The key prefix you want to use in the custom Amazon S3 bucket.</li>
         * <li><code>TargetType</code></li>
         * <li>Description: (Optional) Determines how instances are targeted for local account deployments. Don't specify a value for this parameter if you're deploying to OUs. The valid values are <code>*</code> , <code>InstanceIds</code> , <code>ResourceGroups</code> , and <code>Tags</code> . Use <code>*</code> to target all instances in the account.</li>
         * <li><code>TargetInstances</code></li>
         * <li>Description: (Optional) A comma separated list of instance IDs. You must provide a value for this parameter if you specify <code>InstanceIds</code> for the <code>TargetType</code> parameter.</li>
         * <li><code>TargetTagKey</code></li>
         * <li>Description: (Required) The tag key assigned to the instances you want to target. You must provide a value for this parameter if you specify <code>Tags</code> for the <code>TargetType</code> parameter.</li>
         * <li><code>TargetTagValue</code></li>
         * <li>Description: (Required) The value of the tag key assigned to the instances you want to target. You must provide a value for this parameter if you specify <code>Tags</code> for the <code>TargetType</code> parameter.</li>
         * <li><code>ResourceGroupName</code></li>
         * <li>Description: (Required) The name of the resource group associated with the instances you want to target. You must provide a value for this parameter if you specify <code>ResourceGroups</code> for the <code>TargetType</code> parameter.</li>
         * <li><code>TargetAccounts</code></li>
         * <li>Description: (Optional) The ID of the AWS account initiating the configuration deployment. You only need to provide a value for this parameter if you want to deploy the configuration locally. A value must be provided for either <code>TargetAccounts</code> or <code>TargetOrganizationalUnits</code> .</li>
         * <li><code>TargetOrganizationalUnits</code></li>
         * <li>Description: (Optional) A comma separated list of organizational units (OUs) you want to deploy the configuration to.</li>
         * <li><code>TargetRegions</code></li>
         * <li>Description: (Required) A comma separated list of AWS Regions you want to deploy the configuration to.</li>
         * <li><strong>Resource Explorer (Type: AWS QuickSetupType-ResourceExplorer)</strong> - - <code>SelectedAggregatorRegion</code></li>
         * <li>Description: (Required) The AWS Region where you want to create the aggregator index.</li>
         * <li><code>ReplaceExistingAggregator</code></li>
         * <li>Description: (Required) A boolean value that determines whether to demote an existing aggregator if it is in a Region that differs from the value you specify for the <code>SelectedAggregatorRegion</code> .</li>
         * <li><code>TargetOrganizationalUnits</code></li>
         * <li>Description: (Required) A comma separated list of organizational units (OUs) you want to deploy the configuration to.</li>
         * <li><code>TargetRegions</code></li>
         * <li>Description: (Required) A comma separated list of AWS Regions you want to deploy the configuration to.</li>
         * <li><strong>Resource Scheduler (Type: AWS QuickSetupType-Scheduler)</strong> - - <code>TargetTagKey</code></li>
         * <li>Description: (Required) The tag key assigned to the instances you want to target.</li>
         * <li><code>TargetTagValue</code></li>
         * <li>Description: (Required) The value of the tag key assigned to the instances you want to target.</li>
         * <li><code>ICalendarString</code></li>
         * <li>Description: (Required) An iCalendar formatted string containing the schedule you want Change Manager to use.</li>
         * <li><code>TargetAccounts</code></li>
         * <li>Description: (Optional) The ID of the AWS account initiating the configuration deployment. You only need to provide a value for this parameter if you want to deploy the configuration locally. A value must be provided for either <code>TargetAccounts</code> or <code>TargetOrganizationalUnits</code> .</li>
         * <li><code>TargetOrganizationalUnits</code></li>
         * <li>Description: (Optional) A comma separated list of organizational units (OUs) you want to deploy the configuration to.</li>
         * <li><code>TargetRegions</code></li>
         * <li>Description: (Required) A comma separated list of AWS Regions you want to deploy the configuration to.</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssmquicksetup-configurationmanager-configurationdefinition.html#cfn-ssmquicksetup-configurationmanager-configurationdefinition-parameters">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssmquicksetup-configurationmanager-configurationdefinition.html#cfn-ssmquicksetup-configurationmanager-configurationdefinition-parameters</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getParameters();

        /**
         * The type of the Quick Setup configuration.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssmquicksetup-configurationmanager-configurationdefinition.html#cfn-ssmquicksetup-configurationmanager-configurationdefinition-type">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssmquicksetup-configurationmanager-configurationdefinition.html#cfn-ssmquicksetup-configurationmanager-configurationdefinition-type</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getType();

        /**
         * The ID of the configuration definition.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssmquicksetup-configurationmanager-configurationdefinition.html#cfn-ssmquicksetup-configurationmanager-configurationdefinition-id">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssmquicksetup-configurationmanager-configurationdefinition.html#cfn-ssmquicksetup-configurationmanager-configurationdefinition-id</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getId() {
            return null;
        }

        /**
         * The ARN of the IAM role used to administrate local configuration deployments.
         * <p>
         * <blockquote>
         * <p>
         * Although this element is listed as "Required: No", a value can be omitted only for organizational deployments of types other than <code>AWSQuickSetupType-PatchPolicy</code> . A value must be provided when you are running an organizational deployment for a patch policy or running any type of deployment for a single account.
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssmquicksetup-configurationmanager-configurationdefinition.html#cfn-ssmquicksetup-configurationmanager-configurationdefinition-localdeploymentadministrationrolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssmquicksetup-configurationmanager-configurationdefinition.html#cfn-ssmquicksetup-configurationmanager-configurationdefinition-localdeploymentadministrationrolearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getLocalDeploymentAdministrationRoleArn() {
            return null;
        }

        /**
         * The name of the IAM role used to deploy local configurations.
         * <p>
         * <blockquote>
         * <p>
         * Although this element is listed as "Required: No", a value can be omitted only for organizational deployments of types other than <code>AWSQuickSetupType-PatchPolicy</code> . A value must be provided when you are running an organizational deployment for a patch policy or running any type of deployment for a single account.
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssmquicksetup-configurationmanager-configurationdefinition.html#cfn-ssmquicksetup-configurationmanager-configurationdefinition-localdeploymentexecutionrolename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssmquicksetup-configurationmanager-configurationdefinition.html#cfn-ssmquicksetup-configurationmanager-configurationdefinition-localdeploymentexecutionrolename</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getLocalDeploymentExecutionRoleName() {
            return null;
        }

        /**
         * The version of the Quick Setup type used.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssmquicksetup-configurationmanager-configurationdefinition.html#cfn-ssmquicksetup-configurationmanager-configurationdefinition-typeversion">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssmquicksetup-configurationmanager-configurationdefinition.html#cfn-ssmquicksetup-configurationmanager-configurationdefinition-typeversion</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTypeVersion() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ConfigurationDefinitionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ConfigurationDefinitionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ConfigurationDefinitionProperty> {
            java.lang.Object parameters;
            java.lang.String type;
            java.lang.String id;
            java.lang.String localDeploymentAdministrationRoleArn;
            java.lang.String localDeploymentExecutionRoleName;
            java.lang.String typeVersion;

            /**
             * Sets the value of {@link ConfigurationDefinitionProperty#getParameters}
             * @param parameters The parameters for the configuration definition type. This parameter is required.
             *                   Parameters for configuration definitions vary based the configuration type. The following lists outline the parameters for each configuration type.
             *                   <p>
             *                   <ul>
             *                   <li><strong>AWS Config Recording (Type: AWS QuickSetupType-CFGRecording)</strong> - - <code>RecordAllResources</code></li>
             *                   <li>Description: (Optional) A boolean value that determines whether all supported resources are recorded. The default value is " <code>true</code> ".</li>
             *                   <li><code>ResourceTypesToRecord</code></li>
             *                   <li>Description: (Optional) A comma separated list of resource types you want to record.</li>
             *                   <li><code>RecordGlobalResourceTypes</code></li>
             *                   <li>Description: (Optional) A boolean value that determines whether global resources are recorded with all resource configurations. The default value is " <code>false</code> ".</li>
             *                   <li><code>GlobalResourceTypesRegion</code></li>
             *                   <li>Description: (Optional) Determines the AWS Region where global resources are recorded.</li>
             *                   <li><code>UseCustomBucket</code></li>
             *                   <li>Description: (Optional) A boolean value that determines whether a custom Amazon S3 bucket is used for delivery. The default value is " <code>false</code> ".</li>
             *                   <li><code>DeliveryBucketName</code></li>
             *                   <li>Description: (Optional) The name of the Amazon S3 bucket you want AWS Config to deliver configuration snapshots and configuration history files to.</li>
             *                   <li><code>DeliveryBucketPrefix</code></li>
             *                   <li>Description: (Optional) The key prefix you want to use in the custom Amazon S3 bucket.</li>
             *                   <li><code>NotificationOptions</code></li>
             *                   <li>Description: (Optional) Determines the notification configuration for the recorder. The valid values are <code>NoStreaming</code> , <code>UseExistingTopic</code> , and <code>CreateTopic</code> . The default value is <code>NoStreaming</code> .</li>
             *                   <li><code>CustomDeliveryTopicAccountId</code></li>
             *                   <li>Description: (Optional) The ID of the AWS account where the Amazon SNS topic you want to use for notifications resides. You must specify a value for this parameter if you use the <code>UseExistingTopic</code> notification option.</li>
             *                   <li><code>CustomDeliveryTopicName</code></li>
             *                   <li>Description: (Optional) The name of the Amazon SNS topic you want to use for notifications. You must specify a value for this parameter if you use the <code>UseExistingTopic</code> notification option.</li>
             *                   <li><code>RemediationSchedule</code></li>
             *                   <li>Description: (Optional) A rate expression that defines the schedule for drift remediation. The valid values are <code>rate(30 days)</code> , <code>rate(7 days)</code> , <code>rate(1 days)</code> , and <code>none</code> . The default value is " <code>none</code> ".</li>
             *                   <li><code>TargetAccounts</code></li>
             *                   <li>Description: (Optional) The ID of the AWS account initiating the configuration deployment. You only need to provide a value for this parameter if you want to deploy the configuration locally. A value must be provided for either <code>TargetAccounts</code> or <code>TargetOrganizationalUnits</code> .</li>
             *                   <li><code>TargetOrganizationalUnits</code></li>
             *                   <li>Description: (Optional) The ID of the root of your Organization. This configuration type doesn't currently support choosing specific OUs. The configuration will be deployed to all the OUs in the Organization.</li>
             *                   <li><code>TargetRegions</code></li>
             *                   <li>Description: (Required) A comma separated list of AWS Regions you want to deploy the configuration to.</li>
             *                   <li><strong>Change Manager (Type: AWS QuickSetupType-SSMChangeMgr)</strong> - - <code>DelegatedAccountId</code></li>
             *                   <li>Description: (Required) The ID of the delegated administrator account.</li>
             *                   <li><code>JobFunction</code></li>
             *                   <li>Description: (Required) The name for the Change Manager job function.</li>
             *                   <li><code>PermissionType</code></li>
             *                   <li>Description: (Optional) Specifies whether you want to use default administrator permissions for the job function role, or provide a custom IAM policy. The valid values are <code>CustomPermissions</code> and <code>AdminPermissions</code> . The default value for the parameter is <code>CustomerPermissions</code> .</li>
             *                   <li><code>CustomPermissions</code></li>
             *                   <li>Description: (Optional) A JSON string containing the IAM policy you want your job function to use. You must provide a value for this parameter if you specify <code>CustomPermissions</code> for the <code>PermissionType</code> parameter.</li>
             *                   <li><code>TargetOrganizationalUnits</code></li>
             *                   <li>Description: (Required) A comma separated list of organizational units (OUs) you want to deploy the configuration to.</li>
             *                   <li><code>TargetRegions</code></li>
             *                   <li>Description: (Required) A comma separated list of AWS Regions you want to deploy the configuration to.</li>
             *                   <li><strong>Conformance Packs (Type: AWS QuickSetupType-CFGCPacks)</strong> - - <code>DelegatedAccountId</code></li>
             *                   <li>Description: (Optional) The ID of the delegated administrator account. This parameter is required for Organization deployments.</li>
             *                   <li><code>RemediationSchedule</code></li>
             *                   <li>Description: (Optional) A rate expression that defines the schedule for drift remediation. The valid values are <code>rate(30 days)</code> , <code>rate(14 days)</code> , <code>rate(2 days)</code> , and <code>none</code> . The default value is " <code>none</code> ".</li>
             *                   <li><code>CPackNames</code></li>
             *                   <li>Description: (Required) A comma separated list of AWS Config conformance packs.</li>
             *                   <li><code>TargetAccounts</code></li>
             *                   <li>Description: (Optional) The ID of the AWS account initiating the configuration deployment. You only need to provide a value for this parameter if you want to deploy the configuration locally. A value must be provided for either <code>TargetAccounts</code> or <code>TargetOrganizationalUnits</code> .</li>
             *                   <li><code>TargetOrganizationalUnits</code></li>
             *                   <li>Description: (Optional) The ID of the root of your Organization. This configuration type doesn't currently support choosing specific OUs. The configuration will be deployed to all the OUs in the Organization.</li>
             *                   <li><code>TargetRegions</code></li>
             *                   <li>Description: (Required) A comma separated list of AWS Regions you want to deploy the configuration to.</li>
             *                   <li><strong>Default Host Management Configuration (Type: AWS QuickSetupType-DHMC)</strong> - - <code>UpdateSSMAgent</code></li>
             *                   <li>Description: (Optional) A boolean value that determines whether the SSM Agent is updated on the target instances every 2 weeks. The default value is " <code>true</code> ".</li>
             *                   <li><code>TargetOrganizationalUnits</code></li>
             *                   <li>Description: (Required) A comma separated list of organizational units (OUs) you want to deploy the configuration to.</li>
             *                   <li><code>TargetRegions</code></li>
             *                   <li>Description: (Required) The AWS Regions to deploy the configuration to. For this type, the parameter only accepts a value of <code>AllRegions</code> .</li>
             *                   <li><strong>DevOps Guru (Type: AWS QuickSetupType-DevOpsGuru)</strong> - - <code>AnalyseAllResources</code></li>
             *                   <li>Description: (Optional) A boolean value that determines whether DevOps Guru analyzes all AWS CloudFormation stacks in the account. The default value is " <code>false</code> ".</li>
             *                   <li><code>EnableSnsNotifications</code></li>
             *                   <li>Description: (Optional) A boolean value that determines whether DevOps Guru sends notifications when an insight is created. The default value is " <code>true</code> ".</li>
             *                   <li><code>EnableSsmOpsItems</code></li>
             *                   <li>Description: (Optional) A boolean value that determines whether DevOps Guru creates an OpsCenter OpsItem when an insight is created. The default value is " <code>true</code> ".</li>
             *                   <li><code>EnableDriftRemediation</code></li>
             *                   <li>Description: (Optional) A boolean value that determines whether a drift remediation schedule is used. The default value is " <code>false</code> ".</li>
             *                   <li><code>RemediationSchedule</code></li>
             *                   <li>Description: (Optional) A rate expression that defines the schedule for drift remediation. The valid values are <code>rate(30 days)</code> , <code>rate(14 days)</code> , <code>rate(1 days)</code> , and <code>none</code> . The default value is " <code>none</code> ".</li>
             *                   <li><code>TargetAccounts</code></li>
             *                   <li>Description: (Optional) The ID of the AWS account initiating the configuration deployment. You only need to provide a value for this parameter if you want to deploy the configuration locally. A value must be provided for either <code>TargetAccounts</code> or <code>TargetOrganizationalUnits</code> .</li>
             *                   <li><code>TargetOrganizationalUnits</code></li>
             *                   <li>Description: (Optional) A comma separated list of organizational units (OUs) you want to deploy the configuration to.</li>
             *                   <li><code>TargetRegions</code></li>
             *                   <li>Description: (Required) A comma separated list of AWS Regions you want to deploy the configuration to.</li>
             *                   <li><strong>Distributor (Type: AWS QuickSetupType-Distributor)</strong> - - <code>PackagesToInstall</code></li>
             *                   <li>Description: (Required) A comma separated list of packages you want to install on the target instances. The valid values are <code>AWSEFSTools</code> , <code>AWSCWAgent</code> , and <code>AWSEC2LaunchAgent</code> .</li>
             *                   <li><code>RemediationSchedule</code></li>
             *                   <li>Description: (Optional) A rate expression that defines the schedule for drift remediation. The valid values are <code>rate(30 days)</code> , <code>rate(14 days)</code> , <code>rate(2 days)</code> , and <code>none</code> . The default value is " <code>rate(30 days)</code> ".</li>
             *                   <li><code>IsPolicyAttachAllowed</code></li>
             *                   <li>Description: (Optional) A boolean value that determines whether Quick Setup attaches policies to instances profiles already associated with the target instances. The default value is " <code>false</code> ".</li>
             *                   <li><code>TargetType</code></li>
             *                   <li>Description: (Optional) Determines how instances are targeted for local account deployments. Don't specify a value for this parameter if you're deploying to OUs. The valid values are <code>*</code> , <code>InstanceIds</code> , <code>ResourceGroups</code> , and <code>Tags</code> . Use <code>*</code> to target all instances in the account.</li>
             *                   <li><code>TargetInstances</code></li>
             *                   <li>Description: (Optional) A comma separated list of instance IDs. You must provide a value for this parameter if you specify <code>InstanceIds</code> for the <code>TargetType</code> parameter.</li>
             *                   <li><code>TargetTagKey</code></li>
             *                   <li>Description: (Required) The tag key assigned to the instances you want to target. You must provide a value for this parameter if you specify <code>Tags</code> for the <code>TargetType</code> parameter.</li>
             *                   <li><code>TargetTagValue</code></li>
             *                   <li>Description: (Required) The value of the tag key assigned to the instances you want to target. You must provide a value for this parameter if you specify <code>Tags</code> for the <code>TargetType</code> parameter.</li>
             *                   <li><code>ResourceGroupName</code></li>
             *                   <li>Description: (Required) The name of the resource group associated with the instances you want to target. You must provide a value for this parameter if you specify <code>ResourceGroups</code> for the <code>TargetType</code> parameter.</li>
             *                   <li><code>TargetAccounts</code></li>
             *                   <li>Description: (Optional) The ID of the AWS account initiating the configuration deployment. You only need to provide a value for this parameter if you want to deploy the configuration locally. A value must be provided for either <code>TargetAccounts</code> or <code>TargetOrganizationalUnits</code> .</li>
             *                   <li><code>TargetOrganizationalUnits</code></li>
             *                   <li>Description: (Optional) A comma separated list of organizational units (OUs) you want to deploy the configuration to.</li>
             *                   <li><code>TargetRegions</code></li>
             *                   <li>Description: (Required) A comma separated list of AWS Regions you want to deploy the configuration to.</li>
             *                   <li><strong>Host Management (Type: AWS QuickSetupType-SSMHostMgmt)</strong> - - <code>UpdateSSMAgent</code></li>
             *                   <li>Description: (Optional) A boolean value that determines whether the SSM Agent is updated on the target instances every 2 weeks. The default value is " <code>true</code> ".</li>
             *                   <li><code>UpdateEc2LaunchAgent</code></li>
             *                   <li>Description: (Optional) A boolean value that determines whether the EC2 Launch agent is updated on the target instances every month. The default value is " <code>false</code> ".</li>
             *                   <li><code>CollectInventory</code></li>
             *                   <li>Description: (Optional) A boolean value that determines whether instance metadata is collected on the target instances every 30 minutes. The default value is " <code>true</code> ".</li>
             *                   <li><code>ScanInstances</code></li>
             *                   <li>Description: (Optional) A boolean value that determines whether the target instances are scanned daily for available patches. The default value is " <code>true</code> ".</li>
             *                   <li><code>InstallCloudWatchAgent</code></li>
             *                   <li>Description: (Optional) A boolean value that determines whether the Amazon CloudWatch agent is installed on the target instances. The default value is " <code>false</code> ".</li>
             *                   <li><code>UpdateCloudWatchAgent</code></li>
             *                   <li>Description: (Optional) A boolean value that determines whether the Amazon CloudWatch agent is updated on the target instances every month. The default value is " <code>false</code> ".</li>
             *                   <li><code>IsPolicyAttachAllowed</code></li>
             *                   <li>Description: (Optional) A boolean value that determines whether Quick Setup attaches policies to instances profiles already associated with the target instances. The default value is " <code>false</code> ".</li>
             *                   <li><code>TargetType</code></li>
             *                   <li>Description: (Optional) Determines how instances are targeted for local account deployments. Don't specify a value for this parameter if you're deploying to OUs. The valid values are <code>*</code> , <code>InstanceIds</code> , <code>ResourceGroups</code> , and <code>Tags</code> . Use <code>*</code> to target all instances in the account.</li>
             *                   <li><code>TargetInstances</code></li>
             *                   <li>Description: (Optional) A comma separated list of instance IDs. You must provide a value for this parameter if you specify <code>InstanceIds</code> for the <code>TargetType</code> parameter.</li>
             *                   <li><code>TargetTagKey</code></li>
             *                   <li>Description: (Optional) The tag key assigned to the instances you want to target. You must provide a value for this parameter if you specify <code>Tags</code> for the <code>TargetType</code> parameter.</li>
             *                   <li><code>TargetTagValue</code></li>
             *                   <li>Description: (Optional) The value of the tag key assigned to the instances you want to target. You must provide a value for this parameter if you specify <code>Tags</code> for the <code>TargetType</code> parameter.</li>
             *                   <li><code>ResourceGroupName</code></li>
             *                   <li>Description: (Optional) The name of the resource group associated with the instances you want to target. You must provide a value for this parameter if you specify <code>ResourceGroups</code> for the <code>TargetType</code> parameter.</li>
             *                   <li><code>TargetAccounts</code></li>
             *                   <li>Description: (Optional) The ID of the AWS account initiating the configuration deployment. You only need to provide a value for this parameter if you want to deploy the configuration locally. A value must be provided for either <code>TargetAccounts</code> or <code>TargetOrganizationalUnits</code> .</li>
             *                   <li><code>TargetOrganizationalUnits</code></li>
             *                   <li>Description: (Optional) A comma separated list of organizational units (OUs) you want to deploy the configuration to.</li>
             *                   <li><code>TargetRegions</code></li>
             *                   <li>Description: (Required) A comma separated list of AWS Regions you want to deploy the configuration to.</li>
             *                   <li><strong>OpsCenter (Type: AWS QuickSetupType-SSMOpsCenter)</strong> - - <code>DelegatedAccountId</code></li>
             *                   <li>Description: (Required) The ID of the delegated administrator account.</li>
             *                   <li><code>TargetOrganizationalUnits</code></li>
             *                   <li>Description: (Required) A comma separated list of organizational units (OUs) you want to deploy the configuration to.</li>
             *                   <li><code>TargetRegions</code></li>
             *                   <li>Description: (Required) A comma separated list of AWS Regions you want to deploy the configuration to.</li>
             *                   <li><strong>Patch Policy (Type: AWS QuickSetupType-PatchPolicy)</strong> - - <code>PatchPolicyName</code></li>
             *                   <li>Description: (Required) A name for the patch policy. The value you provide is applied to target Amazon EC2 instances as a tag.</li>
             *                   <li><code>SelectedPatchBaselines</code></li>
             *                   <li>Description: (Required) An array of JSON objects containing the information for the patch baselines to include in your patch policy.</li>
             *                   <li><code>PatchBaselineUseDefault</code></li>
             *                   <li>Description: (Optional) A value that determines whether the selected patch baselines are all AWS provided. Supported values are <code>default</code> and <code>custom</code> .</li>
             *                   <li><code>PatchBaselineRegion</code></li>
             *                   <li>Description: (Required) The AWS Region where the patch baseline exist.</li>
             *                   <li><code>ConfigurationOptionsPatchOperation</code></li>
             *                   <li>Description: (Optional) Determines whether target instances scan for available patches, or scan and install available patches. The valid values are <code>Scan</code> and <code>ScanAndInstall</code> . The default value for the parameter is <code>Scan</code> .</li>
             *                   <li><code>ConfigurationOptionsScanValue</code></li>
             *                   <li>Description: (Optional) A cron expression that is used as the schedule for when instances scan for available patches.</li>
             *                   <li><code>ConfigurationOptionsInstallValue</code></li>
             *                   <li>Description: (Optional) A cron expression that is used as the schedule for when instances install available patches.</li>
             *                   <li><code>ConfigurationOptionsScanNextInterval</code></li>
             *                   <li>Description: (Optional) A boolean value that determines whether instances should scan for available patches at the next cron interval. The default value is " <code>false</code> ".</li>
             *                   <li><code>ConfigurationOptionsInstallNextInterval</code></li>
             *                   <li>Description: (Optional) A boolean value that determines whether instances should scan for available patches at the next cron interval. The default value is " <code>false</code> ".</li>
             *                   <li><code>RebootOption</code></li>
             *                   <li>Description: (Optional) Determines whether instances are rebooted after patches are installed. Valid values are <code>RebootIfNeeded</code> and <code>NoReboot</code> .</li>
             *                   <li><code>IsPolicyAttachAllowed</code></li>
             *                   <li>Description: (Optional) A boolean value that determines whether Quick Setup attaches policies to instances profiles already associated with the target instances. The default value is " <code>false</code> ".</li>
             *                   <li><code>OutputLogEnableS3</code></li>
             *                   <li>Description: (Optional) A boolean value that determines whether command output logs are sent to Amazon S3.</li>
             *                   <li><code>OutputS3Location</code></li>
             *                   <li>Description: (Optional) Information about the Amazon S3 bucket where you want to store the output details of the request.</li>
             *                   <li><code>OutputBucketRegion</code></li>
             *                   <li>Description: (Optional) The AWS Region where the Amazon S3 bucket you want to deliver command output to is located.</li>
             *                   <li><code>OutputS3BucketName</code></li>
             *                   <li>Description: (Optional) The name of the Amazon S3 bucket you want to deliver command output to.</li>
             *                   <li><code>OutputS3KeyPrefix</code></li>
             *                   <li>Description: (Optional) The key prefix you want to use in the custom Amazon S3 bucket.</li>
             *                   <li><code>TargetType</code></li>
             *                   <li>Description: (Optional) Determines how instances are targeted for local account deployments. Don't specify a value for this parameter if you're deploying to OUs. The valid values are <code>*</code> , <code>InstanceIds</code> , <code>ResourceGroups</code> , and <code>Tags</code> . Use <code>*</code> to target all instances in the account.</li>
             *                   <li><code>TargetInstances</code></li>
             *                   <li>Description: (Optional) A comma separated list of instance IDs. You must provide a value for this parameter if you specify <code>InstanceIds</code> for the <code>TargetType</code> parameter.</li>
             *                   <li><code>TargetTagKey</code></li>
             *                   <li>Description: (Required) The tag key assigned to the instances you want to target. You must provide a value for this parameter if you specify <code>Tags</code> for the <code>TargetType</code> parameter.</li>
             *                   <li><code>TargetTagValue</code></li>
             *                   <li>Description: (Required) The value of the tag key assigned to the instances you want to target. You must provide a value for this parameter if you specify <code>Tags</code> for the <code>TargetType</code> parameter.</li>
             *                   <li><code>ResourceGroupName</code></li>
             *                   <li>Description: (Required) The name of the resource group associated with the instances you want to target. You must provide a value for this parameter if you specify <code>ResourceGroups</code> for the <code>TargetType</code> parameter.</li>
             *                   <li><code>TargetAccounts</code></li>
             *                   <li>Description: (Optional) The ID of the AWS account initiating the configuration deployment. You only need to provide a value for this parameter if you want to deploy the configuration locally. A value must be provided for either <code>TargetAccounts</code> or <code>TargetOrganizationalUnits</code> .</li>
             *                   <li><code>TargetOrganizationalUnits</code></li>
             *                   <li>Description: (Optional) A comma separated list of organizational units (OUs) you want to deploy the configuration to.</li>
             *                   <li><code>TargetRegions</code></li>
             *                   <li>Description: (Required) A comma separated list of AWS Regions you want to deploy the configuration to.</li>
             *                   <li><strong>Resource Explorer (Type: AWS QuickSetupType-ResourceExplorer)</strong> - - <code>SelectedAggregatorRegion</code></li>
             *                   <li>Description: (Required) The AWS Region where you want to create the aggregator index.</li>
             *                   <li><code>ReplaceExistingAggregator</code></li>
             *                   <li>Description: (Required) A boolean value that determines whether to demote an existing aggregator if it is in a Region that differs from the value you specify for the <code>SelectedAggregatorRegion</code> .</li>
             *                   <li><code>TargetOrganizationalUnits</code></li>
             *                   <li>Description: (Required) A comma separated list of organizational units (OUs) you want to deploy the configuration to.</li>
             *                   <li><code>TargetRegions</code></li>
             *                   <li>Description: (Required) A comma separated list of AWS Regions you want to deploy the configuration to.</li>
             *                   <li><strong>Resource Scheduler (Type: AWS QuickSetupType-Scheduler)</strong> - - <code>TargetTagKey</code></li>
             *                   <li>Description: (Required) The tag key assigned to the instances you want to target.</li>
             *                   <li><code>TargetTagValue</code></li>
             *                   <li>Description: (Required) The value of the tag key assigned to the instances you want to target.</li>
             *                   <li><code>ICalendarString</code></li>
             *                   <li>Description: (Required) An iCalendar formatted string containing the schedule you want Change Manager to use.</li>
             *                   <li><code>TargetAccounts</code></li>
             *                   <li>Description: (Optional) The ID of the AWS account initiating the configuration deployment. You only need to provide a value for this parameter if you want to deploy the configuration locally. A value must be provided for either <code>TargetAccounts</code> or <code>TargetOrganizationalUnits</code> .</li>
             *                   <li><code>TargetOrganizationalUnits</code></li>
             *                   <li>Description: (Optional) A comma separated list of organizational units (OUs) you want to deploy the configuration to.</li>
             *                   <li><code>TargetRegions</code></li>
             *                   <li>Description: (Required) A comma separated list of AWS Regions you want to deploy the configuration to.</li>
             *                   </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder parameters(java.util.Map<java.lang.String, java.lang.String> parameters) {
                this.parameters = parameters;
                return this;
            }

            /**
             * Sets the value of {@link ConfigurationDefinitionProperty#getParameters}
             * @param parameters The parameters for the configuration definition type. This parameter is required.
             *                   Parameters for configuration definitions vary based the configuration type. The following lists outline the parameters for each configuration type.
             *                   <p>
             *                   <ul>
             *                   <li><strong>AWS Config Recording (Type: AWS QuickSetupType-CFGRecording)</strong> - - <code>RecordAllResources</code></li>
             *                   <li>Description: (Optional) A boolean value that determines whether all supported resources are recorded. The default value is " <code>true</code> ".</li>
             *                   <li><code>ResourceTypesToRecord</code></li>
             *                   <li>Description: (Optional) A comma separated list of resource types you want to record.</li>
             *                   <li><code>RecordGlobalResourceTypes</code></li>
             *                   <li>Description: (Optional) A boolean value that determines whether global resources are recorded with all resource configurations. The default value is " <code>false</code> ".</li>
             *                   <li><code>GlobalResourceTypesRegion</code></li>
             *                   <li>Description: (Optional) Determines the AWS Region where global resources are recorded.</li>
             *                   <li><code>UseCustomBucket</code></li>
             *                   <li>Description: (Optional) A boolean value that determines whether a custom Amazon S3 bucket is used for delivery. The default value is " <code>false</code> ".</li>
             *                   <li><code>DeliveryBucketName</code></li>
             *                   <li>Description: (Optional) The name of the Amazon S3 bucket you want AWS Config to deliver configuration snapshots and configuration history files to.</li>
             *                   <li><code>DeliveryBucketPrefix</code></li>
             *                   <li>Description: (Optional) The key prefix you want to use in the custom Amazon S3 bucket.</li>
             *                   <li><code>NotificationOptions</code></li>
             *                   <li>Description: (Optional) Determines the notification configuration for the recorder. The valid values are <code>NoStreaming</code> , <code>UseExistingTopic</code> , and <code>CreateTopic</code> . The default value is <code>NoStreaming</code> .</li>
             *                   <li><code>CustomDeliveryTopicAccountId</code></li>
             *                   <li>Description: (Optional) The ID of the AWS account where the Amazon SNS topic you want to use for notifications resides. You must specify a value for this parameter if you use the <code>UseExistingTopic</code> notification option.</li>
             *                   <li><code>CustomDeliveryTopicName</code></li>
             *                   <li>Description: (Optional) The name of the Amazon SNS topic you want to use for notifications. You must specify a value for this parameter if you use the <code>UseExistingTopic</code> notification option.</li>
             *                   <li><code>RemediationSchedule</code></li>
             *                   <li>Description: (Optional) A rate expression that defines the schedule for drift remediation. The valid values are <code>rate(30 days)</code> , <code>rate(7 days)</code> , <code>rate(1 days)</code> , and <code>none</code> . The default value is " <code>none</code> ".</li>
             *                   <li><code>TargetAccounts</code></li>
             *                   <li>Description: (Optional) The ID of the AWS account initiating the configuration deployment. You only need to provide a value for this parameter if you want to deploy the configuration locally. A value must be provided for either <code>TargetAccounts</code> or <code>TargetOrganizationalUnits</code> .</li>
             *                   <li><code>TargetOrganizationalUnits</code></li>
             *                   <li>Description: (Optional) The ID of the root of your Organization. This configuration type doesn't currently support choosing specific OUs. The configuration will be deployed to all the OUs in the Organization.</li>
             *                   <li><code>TargetRegions</code></li>
             *                   <li>Description: (Required) A comma separated list of AWS Regions you want to deploy the configuration to.</li>
             *                   <li><strong>Change Manager (Type: AWS QuickSetupType-SSMChangeMgr)</strong> - - <code>DelegatedAccountId</code></li>
             *                   <li>Description: (Required) The ID of the delegated administrator account.</li>
             *                   <li><code>JobFunction</code></li>
             *                   <li>Description: (Required) The name for the Change Manager job function.</li>
             *                   <li><code>PermissionType</code></li>
             *                   <li>Description: (Optional) Specifies whether you want to use default administrator permissions for the job function role, or provide a custom IAM policy. The valid values are <code>CustomPermissions</code> and <code>AdminPermissions</code> . The default value for the parameter is <code>CustomerPermissions</code> .</li>
             *                   <li><code>CustomPermissions</code></li>
             *                   <li>Description: (Optional) A JSON string containing the IAM policy you want your job function to use. You must provide a value for this parameter if you specify <code>CustomPermissions</code> for the <code>PermissionType</code> parameter.</li>
             *                   <li><code>TargetOrganizationalUnits</code></li>
             *                   <li>Description: (Required) A comma separated list of organizational units (OUs) you want to deploy the configuration to.</li>
             *                   <li><code>TargetRegions</code></li>
             *                   <li>Description: (Required) A comma separated list of AWS Regions you want to deploy the configuration to.</li>
             *                   <li><strong>Conformance Packs (Type: AWS QuickSetupType-CFGCPacks)</strong> - - <code>DelegatedAccountId</code></li>
             *                   <li>Description: (Optional) The ID of the delegated administrator account. This parameter is required for Organization deployments.</li>
             *                   <li><code>RemediationSchedule</code></li>
             *                   <li>Description: (Optional) A rate expression that defines the schedule for drift remediation. The valid values are <code>rate(30 days)</code> , <code>rate(14 days)</code> , <code>rate(2 days)</code> , and <code>none</code> . The default value is " <code>none</code> ".</li>
             *                   <li><code>CPackNames</code></li>
             *                   <li>Description: (Required) A comma separated list of AWS Config conformance packs.</li>
             *                   <li><code>TargetAccounts</code></li>
             *                   <li>Description: (Optional) The ID of the AWS account initiating the configuration deployment. You only need to provide a value for this parameter if you want to deploy the configuration locally. A value must be provided for either <code>TargetAccounts</code> or <code>TargetOrganizationalUnits</code> .</li>
             *                   <li><code>TargetOrganizationalUnits</code></li>
             *                   <li>Description: (Optional) The ID of the root of your Organization. This configuration type doesn't currently support choosing specific OUs. The configuration will be deployed to all the OUs in the Organization.</li>
             *                   <li><code>TargetRegions</code></li>
             *                   <li>Description: (Required) A comma separated list of AWS Regions you want to deploy the configuration to.</li>
             *                   <li><strong>Default Host Management Configuration (Type: AWS QuickSetupType-DHMC)</strong> - - <code>UpdateSSMAgent</code></li>
             *                   <li>Description: (Optional) A boolean value that determines whether the SSM Agent is updated on the target instances every 2 weeks. The default value is " <code>true</code> ".</li>
             *                   <li><code>TargetOrganizationalUnits</code></li>
             *                   <li>Description: (Required) A comma separated list of organizational units (OUs) you want to deploy the configuration to.</li>
             *                   <li><code>TargetRegions</code></li>
             *                   <li>Description: (Required) The AWS Regions to deploy the configuration to. For this type, the parameter only accepts a value of <code>AllRegions</code> .</li>
             *                   <li><strong>DevOps Guru (Type: AWS QuickSetupType-DevOpsGuru)</strong> - - <code>AnalyseAllResources</code></li>
             *                   <li>Description: (Optional) A boolean value that determines whether DevOps Guru analyzes all AWS CloudFormation stacks in the account. The default value is " <code>false</code> ".</li>
             *                   <li><code>EnableSnsNotifications</code></li>
             *                   <li>Description: (Optional) A boolean value that determines whether DevOps Guru sends notifications when an insight is created. The default value is " <code>true</code> ".</li>
             *                   <li><code>EnableSsmOpsItems</code></li>
             *                   <li>Description: (Optional) A boolean value that determines whether DevOps Guru creates an OpsCenter OpsItem when an insight is created. The default value is " <code>true</code> ".</li>
             *                   <li><code>EnableDriftRemediation</code></li>
             *                   <li>Description: (Optional) A boolean value that determines whether a drift remediation schedule is used. The default value is " <code>false</code> ".</li>
             *                   <li><code>RemediationSchedule</code></li>
             *                   <li>Description: (Optional) A rate expression that defines the schedule for drift remediation. The valid values are <code>rate(30 days)</code> , <code>rate(14 days)</code> , <code>rate(1 days)</code> , and <code>none</code> . The default value is " <code>none</code> ".</li>
             *                   <li><code>TargetAccounts</code></li>
             *                   <li>Description: (Optional) The ID of the AWS account initiating the configuration deployment. You only need to provide a value for this parameter if you want to deploy the configuration locally. A value must be provided for either <code>TargetAccounts</code> or <code>TargetOrganizationalUnits</code> .</li>
             *                   <li><code>TargetOrganizationalUnits</code></li>
             *                   <li>Description: (Optional) A comma separated list of organizational units (OUs) you want to deploy the configuration to.</li>
             *                   <li><code>TargetRegions</code></li>
             *                   <li>Description: (Required) A comma separated list of AWS Regions you want to deploy the configuration to.</li>
             *                   <li><strong>Distributor (Type: AWS QuickSetupType-Distributor)</strong> - - <code>PackagesToInstall</code></li>
             *                   <li>Description: (Required) A comma separated list of packages you want to install on the target instances. The valid values are <code>AWSEFSTools</code> , <code>AWSCWAgent</code> , and <code>AWSEC2LaunchAgent</code> .</li>
             *                   <li><code>RemediationSchedule</code></li>
             *                   <li>Description: (Optional) A rate expression that defines the schedule for drift remediation. The valid values are <code>rate(30 days)</code> , <code>rate(14 days)</code> , <code>rate(2 days)</code> , and <code>none</code> . The default value is " <code>rate(30 days)</code> ".</li>
             *                   <li><code>IsPolicyAttachAllowed</code></li>
             *                   <li>Description: (Optional) A boolean value that determines whether Quick Setup attaches policies to instances profiles already associated with the target instances. The default value is " <code>false</code> ".</li>
             *                   <li><code>TargetType</code></li>
             *                   <li>Description: (Optional) Determines how instances are targeted for local account deployments. Don't specify a value for this parameter if you're deploying to OUs. The valid values are <code>*</code> , <code>InstanceIds</code> , <code>ResourceGroups</code> , and <code>Tags</code> . Use <code>*</code> to target all instances in the account.</li>
             *                   <li><code>TargetInstances</code></li>
             *                   <li>Description: (Optional) A comma separated list of instance IDs. You must provide a value for this parameter if you specify <code>InstanceIds</code> for the <code>TargetType</code> parameter.</li>
             *                   <li><code>TargetTagKey</code></li>
             *                   <li>Description: (Required) The tag key assigned to the instances you want to target. You must provide a value for this parameter if you specify <code>Tags</code> for the <code>TargetType</code> parameter.</li>
             *                   <li><code>TargetTagValue</code></li>
             *                   <li>Description: (Required) The value of the tag key assigned to the instances you want to target. You must provide a value for this parameter if you specify <code>Tags</code> for the <code>TargetType</code> parameter.</li>
             *                   <li><code>ResourceGroupName</code></li>
             *                   <li>Description: (Required) The name of the resource group associated with the instances you want to target. You must provide a value for this parameter if you specify <code>ResourceGroups</code> for the <code>TargetType</code> parameter.</li>
             *                   <li><code>TargetAccounts</code></li>
             *                   <li>Description: (Optional) The ID of the AWS account initiating the configuration deployment. You only need to provide a value for this parameter if you want to deploy the configuration locally. A value must be provided for either <code>TargetAccounts</code> or <code>TargetOrganizationalUnits</code> .</li>
             *                   <li><code>TargetOrganizationalUnits</code></li>
             *                   <li>Description: (Optional) A comma separated list of organizational units (OUs) you want to deploy the configuration to.</li>
             *                   <li><code>TargetRegions</code></li>
             *                   <li>Description: (Required) A comma separated list of AWS Regions you want to deploy the configuration to.</li>
             *                   <li><strong>Host Management (Type: AWS QuickSetupType-SSMHostMgmt)</strong> - - <code>UpdateSSMAgent</code></li>
             *                   <li>Description: (Optional) A boolean value that determines whether the SSM Agent is updated on the target instances every 2 weeks. The default value is " <code>true</code> ".</li>
             *                   <li><code>UpdateEc2LaunchAgent</code></li>
             *                   <li>Description: (Optional) A boolean value that determines whether the EC2 Launch agent is updated on the target instances every month. The default value is " <code>false</code> ".</li>
             *                   <li><code>CollectInventory</code></li>
             *                   <li>Description: (Optional) A boolean value that determines whether instance metadata is collected on the target instances every 30 minutes. The default value is " <code>true</code> ".</li>
             *                   <li><code>ScanInstances</code></li>
             *                   <li>Description: (Optional) A boolean value that determines whether the target instances are scanned daily for available patches. The default value is " <code>true</code> ".</li>
             *                   <li><code>InstallCloudWatchAgent</code></li>
             *                   <li>Description: (Optional) A boolean value that determines whether the Amazon CloudWatch agent is installed on the target instances. The default value is " <code>false</code> ".</li>
             *                   <li><code>UpdateCloudWatchAgent</code></li>
             *                   <li>Description: (Optional) A boolean value that determines whether the Amazon CloudWatch agent is updated on the target instances every month. The default value is " <code>false</code> ".</li>
             *                   <li><code>IsPolicyAttachAllowed</code></li>
             *                   <li>Description: (Optional) A boolean value that determines whether Quick Setup attaches policies to instances profiles already associated with the target instances. The default value is " <code>false</code> ".</li>
             *                   <li><code>TargetType</code></li>
             *                   <li>Description: (Optional) Determines how instances are targeted for local account deployments. Don't specify a value for this parameter if you're deploying to OUs. The valid values are <code>*</code> , <code>InstanceIds</code> , <code>ResourceGroups</code> , and <code>Tags</code> . Use <code>*</code> to target all instances in the account.</li>
             *                   <li><code>TargetInstances</code></li>
             *                   <li>Description: (Optional) A comma separated list of instance IDs. You must provide a value for this parameter if you specify <code>InstanceIds</code> for the <code>TargetType</code> parameter.</li>
             *                   <li><code>TargetTagKey</code></li>
             *                   <li>Description: (Optional) The tag key assigned to the instances you want to target. You must provide a value for this parameter if you specify <code>Tags</code> for the <code>TargetType</code> parameter.</li>
             *                   <li><code>TargetTagValue</code></li>
             *                   <li>Description: (Optional) The value of the tag key assigned to the instances you want to target. You must provide a value for this parameter if you specify <code>Tags</code> for the <code>TargetType</code> parameter.</li>
             *                   <li><code>ResourceGroupName</code></li>
             *                   <li>Description: (Optional) The name of the resource group associated with the instances you want to target. You must provide a value for this parameter if you specify <code>ResourceGroups</code> for the <code>TargetType</code> parameter.</li>
             *                   <li><code>TargetAccounts</code></li>
             *                   <li>Description: (Optional) The ID of the AWS account initiating the configuration deployment. You only need to provide a value for this parameter if you want to deploy the configuration locally. A value must be provided for either <code>TargetAccounts</code> or <code>TargetOrganizationalUnits</code> .</li>
             *                   <li><code>TargetOrganizationalUnits</code></li>
             *                   <li>Description: (Optional) A comma separated list of organizational units (OUs) you want to deploy the configuration to.</li>
             *                   <li><code>TargetRegions</code></li>
             *                   <li>Description: (Required) A comma separated list of AWS Regions you want to deploy the configuration to.</li>
             *                   <li><strong>OpsCenter (Type: AWS QuickSetupType-SSMOpsCenter)</strong> - - <code>DelegatedAccountId</code></li>
             *                   <li>Description: (Required) The ID of the delegated administrator account.</li>
             *                   <li><code>TargetOrganizationalUnits</code></li>
             *                   <li>Description: (Required) A comma separated list of organizational units (OUs) you want to deploy the configuration to.</li>
             *                   <li><code>TargetRegions</code></li>
             *                   <li>Description: (Required) A comma separated list of AWS Regions you want to deploy the configuration to.</li>
             *                   <li><strong>Patch Policy (Type: AWS QuickSetupType-PatchPolicy)</strong> - - <code>PatchPolicyName</code></li>
             *                   <li>Description: (Required) A name for the patch policy. The value you provide is applied to target Amazon EC2 instances as a tag.</li>
             *                   <li><code>SelectedPatchBaselines</code></li>
             *                   <li>Description: (Required) An array of JSON objects containing the information for the patch baselines to include in your patch policy.</li>
             *                   <li><code>PatchBaselineUseDefault</code></li>
             *                   <li>Description: (Optional) A value that determines whether the selected patch baselines are all AWS provided. Supported values are <code>default</code> and <code>custom</code> .</li>
             *                   <li><code>PatchBaselineRegion</code></li>
             *                   <li>Description: (Required) The AWS Region where the patch baseline exist.</li>
             *                   <li><code>ConfigurationOptionsPatchOperation</code></li>
             *                   <li>Description: (Optional) Determines whether target instances scan for available patches, or scan and install available patches. The valid values are <code>Scan</code> and <code>ScanAndInstall</code> . The default value for the parameter is <code>Scan</code> .</li>
             *                   <li><code>ConfigurationOptionsScanValue</code></li>
             *                   <li>Description: (Optional) A cron expression that is used as the schedule for when instances scan for available patches.</li>
             *                   <li><code>ConfigurationOptionsInstallValue</code></li>
             *                   <li>Description: (Optional) A cron expression that is used as the schedule for when instances install available patches.</li>
             *                   <li><code>ConfigurationOptionsScanNextInterval</code></li>
             *                   <li>Description: (Optional) A boolean value that determines whether instances should scan for available patches at the next cron interval. The default value is " <code>false</code> ".</li>
             *                   <li><code>ConfigurationOptionsInstallNextInterval</code></li>
             *                   <li>Description: (Optional) A boolean value that determines whether instances should scan for available patches at the next cron interval. The default value is " <code>false</code> ".</li>
             *                   <li><code>RebootOption</code></li>
             *                   <li>Description: (Optional) Determines whether instances are rebooted after patches are installed. Valid values are <code>RebootIfNeeded</code> and <code>NoReboot</code> .</li>
             *                   <li><code>IsPolicyAttachAllowed</code></li>
             *                   <li>Description: (Optional) A boolean value that determines whether Quick Setup attaches policies to instances profiles already associated with the target instances. The default value is " <code>false</code> ".</li>
             *                   <li><code>OutputLogEnableS3</code></li>
             *                   <li>Description: (Optional) A boolean value that determines whether command output logs are sent to Amazon S3.</li>
             *                   <li><code>OutputS3Location</code></li>
             *                   <li>Description: (Optional) Information about the Amazon S3 bucket where you want to store the output details of the request.</li>
             *                   <li><code>OutputBucketRegion</code></li>
             *                   <li>Description: (Optional) The AWS Region where the Amazon S3 bucket you want to deliver command output to is located.</li>
             *                   <li><code>OutputS3BucketName</code></li>
             *                   <li>Description: (Optional) The name of the Amazon S3 bucket you want to deliver command output to.</li>
             *                   <li><code>OutputS3KeyPrefix</code></li>
             *                   <li>Description: (Optional) The key prefix you want to use in the custom Amazon S3 bucket.</li>
             *                   <li><code>TargetType</code></li>
             *                   <li>Description: (Optional) Determines how instances are targeted for local account deployments. Don't specify a value for this parameter if you're deploying to OUs. The valid values are <code>*</code> , <code>InstanceIds</code> , <code>ResourceGroups</code> , and <code>Tags</code> . Use <code>*</code> to target all instances in the account.</li>
             *                   <li><code>TargetInstances</code></li>
             *                   <li>Description: (Optional) A comma separated list of instance IDs. You must provide a value for this parameter if you specify <code>InstanceIds</code> for the <code>TargetType</code> parameter.</li>
             *                   <li><code>TargetTagKey</code></li>
             *                   <li>Description: (Required) The tag key assigned to the instances you want to target. You must provide a value for this parameter if you specify <code>Tags</code> for the <code>TargetType</code> parameter.</li>
             *                   <li><code>TargetTagValue</code></li>
             *                   <li>Description: (Required) The value of the tag key assigned to the instances you want to target. You must provide a value for this parameter if you specify <code>Tags</code> for the <code>TargetType</code> parameter.</li>
             *                   <li><code>ResourceGroupName</code></li>
             *                   <li>Description: (Required) The name of the resource group associated with the instances you want to target. You must provide a value for this parameter if you specify <code>ResourceGroups</code> for the <code>TargetType</code> parameter.</li>
             *                   <li><code>TargetAccounts</code></li>
             *                   <li>Description: (Optional) The ID of the AWS account initiating the configuration deployment. You only need to provide a value for this parameter if you want to deploy the configuration locally. A value must be provided for either <code>TargetAccounts</code> or <code>TargetOrganizationalUnits</code> .</li>
             *                   <li><code>TargetOrganizationalUnits</code></li>
             *                   <li>Description: (Optional) A comma separated list of organizational units (OUs) you want to deploy the configuration to.</li>
             *                   <li><code>TargetRegions</code></li>
             *                   <li>Description: (Required) A comma separated list of AWS Regions you want to deploy the configuration to.</li>
             *                   <li><strong>Resource Explorer (Type: AWS QuickSetupType-ResourceExplorer)</strong> - - <code>SelectedAggregatorRegion</code></li>
             *                   <li>Description: (Required) The AWS Region where you want to create the aggregator index.</li>
             *                   <li><code>ReplaceExistingAggregator</code></li>
             *                   <li>Description: (Required) A boolean value that determines whether to demote an existing aggregator if it is in a Region that differs from the value you specify for the <code>SelectedAggregatorRegion</code> .</li>
             *                   <li><code>TargetOrganizationalUnits</code></li>
             *                   <li>Description: (Required) A comma separated list of organizational units (OUs) you want to deploy the configuration to.</li>
             *                   <li><code>TargetRegions</code></li>
             *                   <li>Description: (Required) A comma separated list of AWS Regions you want to deploy the configuration to.</li>
             *                   <li><strong>Resource Scheduler (Type: AWS QuickSetupType-Scheduler)</strong> - - <code>TargetTagKey</code></li>
             *                   <li>Description: (Required) The tag key assigned to the instances you want to target.</li>
             *                   <li><code>TargetTagValue</code></li>
             *                   <li>Description: (Required) The value of the tag key assigned to the instances you want to target.</li>
             *                   <li><code>ICalendarString</code></li>
             *                   <li>Description: (Required) An iCalendar formatted string containing the schedule you want Change Manager to use.</li>
             *                   <li><code>TargetAccounts</code></li>
             *                   <li>Description: (Optional) The ID of the AWS account initiating the configuration deployment. You only need to provide a value for this parameter if you want to deploy the configuration locally. A value must be provided for either <code>TargetAccounts</code> or <code>TargetOrganizationalUnits</code> .</li>
             *                   <li><code>TargetOrganizationalUnits</code></li>
             *                   <li>Description: (Optional) A comma separated list of organizational units (OUs) you want to deploy the configuration to.</li>
             *                   <li><code>TargetRegions</code></li>
             *                   <li>Description: (Required) A comma separated list of AWS Regions you want to deploy the configuration to.</li>
             *                   </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder parameters(software.amazon.awscdk.IResolvable parameters) {
                this.parameters = parameters;
                return this;
            }

            /**
             * Sets the value of {@link ConfigurationDefinitionProperty#getType}
             * @param type The type of the Quick Setup configuration. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Sets the value of {@link ConfigurationDefinitionProperty#getId}
             * @param id The ID of the configuration definition.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder id(java.lang.String id) {
                this.id = id;
                return this;
            }

            /**
             * Sets the value of {@link ConfigurationDefinitionProperty#getLocalDeploymentAdministrationRoleArn}
             * @param localDeploymentAdministrationRoleArn The ARN of the IAM role used to administrate local configuration deployments.
             *                                             <blockquote>
             *                                             <p>
             *                                             Although this element is listed as "Required: No", a value can be omitted only for organizational deployments of types other than <code>AWSQuickSetupType-PatchPolicy</code> . A value must be provided when you are running an organizational deployment for a patch policy or running any type of deployment for a single account.
             *                                             <p>
             *                                             </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder localDeploymentAdministrationRoleArn(java.lang.String localDeploymentAdministrationRoleArn) {
                this.localDeploymentAdministrationRoleArn = localDeploymentAdministrationRoleArn;
                return this;
            }

            /**
             * Sets the value of {@link ConfigurationDefinitionProperty#getLocalDeploymentExecutionRoleName}
             * @param localDeploymentExecutionRoleName The name of the IAM role used to deploy local configurations.
             *                                         <blockquote>
             *                                         <p>
             *                                         Although this element is listed as "Required: No", a value can be omitted only for organizational deployments of types other than <code>AWSQuickSetupType-PatchPolicy</code> . A value must be provided when you are running an organizational deployment for a patch policy or running any type of deployment for a single account.
             *                                         <p>
             *                                         </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder localDeploymentExecutionRoleName(java.lang.String localDeploymentExecutionRoleName) {
                this.localDeploymentExecutionRoleName = localDeploymentExecutionRoleName;
                return this;
            }

            /**
             * Sets the value of {@link ConfigurationDefinitionProperty#getTypeVersion}
             * @param typeVersion The version of the Quick Setup type used.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder typeVersion(java.lang.String typeVersion) {
                this.typeVersion = typeVersion;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ConfigurationDefinitionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ConfigurationDefinitionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ConfigurationDefinitionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ConfigurationDefinitionProperty {
            private final java.lang.Object parameters;
            private final java.lang.String type;
            private final java.lang.String id;
            private final java.lang.String localDeploymentAdministrationRoleArn;
            private final java.lang.String localDeploymentExecutionRoleName;
            private final java.lang.String typeVersion;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.parameters = software.amazon.jsii.Kernel.get(this, "parameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.id = software.amazon.jsii.Kernel.get(this, "id", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.localDeploymentAdministrationRoleArn = software.amazon.jsii.Kernel.get(this, "localDeploymentAdministrationRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.localDeploymentExecutionRoleName = software.amazon.jsii.Kernel.get(this, "localDeploymentExecutionRoleName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.typeVersion = software.amazon.jsii.Kernel.get(this, "typeVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.parameters = java.util.Objects.requireNonNull(builder.parameters, "parameters is required");
                this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
                this.id = builder.id;
                this.localDeploymentAdministrationRoleArn = builder.localDeploymentAdministrationRoleArn;
                this.localDeploymentExecutionRoleName = builder.localDeploymentExecutionRoleName;
                this.typeVersion = builder.typeVersion;
            }

            @Override
            public final java.lang.Object getParameters() {
                return this.parameters;
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            public final java.lang.String getId() {
                return this.id;
            }

            @Override
            public final java.lang.String getLocalDeploymentAdministrationRoleArn() {
                return this.localDeploymentAdministrationRoleArn;
            }

            @Override
            public final java.lang.String getLocalDeploymentExecutionRoleName() {
                return this.localDeploymentExecutionRoleName;
            }

            @Override
            public final java.lang.String getTypeVersion() {
                return this.typeVersion;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("parameters", om.valueToTree(this.getParameters()));
                data.set("type", om.valueToTree(this.getType()));
                if (this.getId() != null) {
                    data.set("id", om.valueToTree(this.getId()));
                }
                if (this.getLocalDeploymentAdministrationRoleArn() != null) {
                    data.set("localDeploymentAdministrationRoleArn", om.valueToTree(this.getLocalDeploymentAdministrationRoleArn()));
                }
                if (this.getLocalDeploymentExecutionRoleName() != null) {
                    data.set("localDeploymentExecutionRoleName", om.valueToTree(this.getLocalDeploymentExecutionRoleName()));
                }
                if (this.getTypeVersion() != null) {
                    data.set("typeVersion", om.valueToTree(this.getTypeVersion()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ssmquicksetup.CfnConfigurationManager.ConfigurationDefinitionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ConfigurationDefinitionProperty.Jsii$Proxy that = (ConfigurationDefinitionProperty.Jsii$Proxy) o;

                if (!parameters.equals(that.parameters)) return false;
                if (!type.equals(that.type)) return false;
                if (this.id != null ? !this.id.equals(that.id) : that.id != null) return false;
                if (this.localDeploymentAdministrationRoleArn != null ? !this.localDeploymentAdministrationRoleArn.equals(that.localDeploymentAdministrationRoleArn) : that.localDeploymentAdministrationRoleArn != null) return false;
                if (this.localDeploymentExecutionRoleName != null ? !this.localDeploymentExecutionRoleName.equals(that.localDeploymentExecutionRoleName) : that.localDeploymentExecutionRoleName != null) return false;
                return this.typeVersion != null ? this.typeVersion.equals(that.typeVersion) : that.typeVersion == null;
            }

            @Override
            public final int hashCode() {
                int result = this.parameters.hashCode();
                result = 31 * result + (this.type.hashCode());
                result = 31 * result + (this.id != null ? this.id.hashCode() : 0);
                result = 31 * result + (this.localDeploymentAdministrationRoleArn != null ? this.localDeploymentAdministrationRoleArn.hashCode() : 0);
                result = 31 * result + (this.localDeploymentExecutionRoleName != null ? this.localDeploymentExecutionRoleName.hashCode() : 0);
                result = 31 * result + (this.typeVersion != null ? this.typeVersion.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A summarized description of the status.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ssmquicksetup.*;
     * StatusSummaryProperty statusSummaryProperty = StatusSummaryProperty.builder()
     *         .lastUpdatedAt("lastUpdatedAt")
     *         .statusType("statusType")
     *         // the properties below are optional
     *         .status("status")
     *         .statusDetails(Map.of(
     *                 "statusDetailsKey", "statusDetails"))
     *         .statusMessage("statusMessage")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssmquicksetup-configurationmanager-statussummary.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssmquicksetup-configurationmanager-statussummary.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ssmquicksetup.CfnConfigurationManager.StatusSummaryProperty")
    @software.amazon.jsii.Jsii.Proxy(StatusSummaryProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface StatusSummaryProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The datetime stamp when the status was last updated.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssmquicksetup-configurationmanager-statussummary.html#cfn-ssmquicksetup-configurationmanager-statussummary-lastupdatedat">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssmquicksetup-configurationmanager-statussummary.html#cfn-ssmquicksetup-configurationmanager-statussummary-lastupdatedat</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getLastUpdatedAt();

        /**
         * The type of a status summary.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssmquicksetup-configurationmanager-statussummary.html#cfn-ssmquicksetup-configurationmanager-statussummary-statustype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssmquicksetup-configurationmanager-statussummary.html#cfn-ssmquicksetup-configurationmanager-statussummary-statustype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getStatusType();

        /**
         * The current status.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssmquicksetup-configurationmanager-statussummary.html#cfn-ssmquicksetup-configurationmanager-statussummary-status">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssmquicksetup-configurationmanager-statussummary.html#cfn-ssmquicksetup-configurationmanager-statussummary-status</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getStatus() {
            return null;
        }

        /**
         * Details about the status.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssmquicksetup-configurationmanager-statussummary.html#cfn-ssmquicksetup-configurationmanager-statussummary-statusdetails">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssmquicksetup-configurationmanager-statussummary.html#cfn-ssmquicksetup-configurationmanager-statussummary-statusdetails</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getStatusDetails() {
            return null;
        }

        /**
         * When applicable, returns an informational message relevant to the current status and status type of the status summary object.
         * <p>
         * We don't recommend implementing parsing logic around this value since the messages returned can vary in format.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssmquicksetup-configurationmanager-statussummary.html#cfn-ssmquicksetup-configurationmanager-statussummary-statusmessage">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssmquicksetup-configurationmanager-statussummary.html#cfn-ssmquicksetup-configurationmanager-statussummary-statusmessage</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getStatusMessage() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link StatusSummaryProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link StatusSummaryProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<StatusSummaryProperty> {
            java.lang.String lastUpdatedAt;
            java.lang.String statusType;
            java.lang.String status;
            java.lang.Object statusDetails;
            java.lang.String statusMessage;

            /**
             * Sets the value of {@link StatusSummaryProperty#getLastUpdatedAt}
             * @param lastUpdatedAt The datetime stamp when the status was last updated. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder lastUpdatedAt(java.lang.String lastUpdatedAt) {
                this.lastUpdatedAt = lastUpdatedAt;
                return this;
            }

            /**
             * Sets the value of {@link StatusSummaryProperty#getStatusType}
             * @param statusType The type of a status summary. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder statusType(java.lang.String statusType) {
                this.statusType = statusType;
                return this;
            }

            /**
             * Sets the value of {@link StatusSummaryProperty#getStatus}
             * @param status The current status.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder status(java.lang.String status) {
                this.status = status;
                return this;
            }

            /**
             * Sets the value of {@link StatusSummaryProperty#getStatusDetails}
             * @param statusDetails Details about the status.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder statusDetails(java.util.Map<java.lang.String, java.lang.String> statusDetails) {
                this.statusDetails = statusDetails;
                return this;
            }

            /**
             * Sets the value of {@link StatusSummaryProperty#getStatusDetails}
             * @param statusDetails Details about the status.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder statusDetails(software.amazon.awscdk.IResolvable statusDetails) {
                this.statusDetails = statusDetails;
                return this;
            }

            /**
             * Sets the value of {@link StatusSummaryProperty#getStatusMessage}
             * @param statusMessage When applicable, returns an informational message relevant to the current status and status type of the status summary object.
             *                      We don't recommend implementing parsing logic around this value since the messages returned can vary in format.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder statusMessage(java.lang.String statusMessage) {
                this.statusMessage = statusMessage;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link StatusSummaryProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public StatusSummaryProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link StatusSummaryProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements StatusSummaryProperty {
            private final java.lang.String lastUpdatedAt;
            private final java.lang.String statusType;
            private final java.lang.String status;
            private final java.lang.Object statusDetails;
            private final java.lang.String statusMessage;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.lastUpdatedAt = software.amazon.jsii.Kernel.get(this, "lastUpdatedAt", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.statusType = software.amazon.jsii.Kernel.get(this, "statusType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.status = software.amazon.jsii.Kernel.get(this, "status", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.statusDetails = software.amazon.jsii.Kernel.get(this, "statusDetails", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.statusMessage = software.amazon.jsii.Kernel.get(this, "statusMessage", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.lastUpdatedAt = java.util.Objects.requireNonNull(builder.lastUpdatedAt, "lastUpdatedAt is required");
                this.statusType = java.util.Objects.requireNonNull(builder.statusType, "statusType is required");
                this.status = builder.status;
                this.statusDetails = builder.statusDetails;
                this.statusMessage = builder.statusMessage;
            }

            @Override
            public final java.lang.String getLastUpdatedAt() {
                return this.lastUpdatedAt;
            }

            @Override
            public final java.lang.String getStatusType() {
                return this.statusType;
            }

            @Override
            public final java.lang.String getStatus() {
                return this.status;
            }

            @Override
            public final java.lang.Object getStatusDetails() {
                return this.statusDetails;
            }

            @Override
            public final java.lang.String getStatusMessage() {
                return this.statusMessage;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("lastUpdatedAt", om.valueToTree(this.getLastUpdatedAt()));
                data.set("statusType", om.valueToTree(this.getStatusType()));
                if (this.getStatus() != null) {
                    data.set("status", om.valueToTree(this.getStatus()));
                }
                if (this.getStatusDetails() != null) {
                    data.set("statusDetails", om.valueToTree(this.getStatusDetails()));
                }
                if (this.getStatusMessage() != null) {
                    data.set("statusMessage", om.valueToTree(this.getStatusMessage()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ssmquicksetup.CfnConfigurationManager.StatusSummaryProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                StatusSummaryProperty.Jsii$Proxy that = (StatusSummaryProperty.Jsii$Proxy) o;

                if (!lastUpdatedAt.equals(that.lastUpdatedAt)) return false;
                if (!statusType.equals(that.statusType)) return false;
                if (this.status != null ? !this.status.equals(that.status) : that.status != null) return false;
                if (this.statusDetails != null ? !this.statusDetails.equals(that.statusDetails) : that.statusDetails != null) return false;
                return this.statusMessage != null ? this.statusMessage.equals(that.statusMessage) : that.statusMessage == null;
            }

            @Override
            public final int hashCode() {
                int result = this.lastUpdatedAt.hashCode();
                result = 31 * result + (this.statusType.hashCode());
                result = 31 * result + (this.status != null ? this.status.hashCode() : 0);
                result = 31 * result + (this.statusDetails != null ? this.statusDetails.hashCode() : 0);
                result = 31 * result + (this.statusMessage != null ? this.statusMessage.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.ssmquicksetup.CfnConfigurationManager}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.ssmquicksetup.CfnConfigurationManager> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.ssmquicksetup.CfnConfigurationManagerProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.ssmquicksetup.CfnConfigurationManagerProps.Builder();
        }

        /**
         * The definition of the Quick Setup configuration that the configuration manager deploys.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssmquicksetup-configurationmanager.html#cfn-ssmquicksetup-configurationmanager-configurationdefinitions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssmquicksetup-configurationmanager.html#cfn-ssmquicksetup-configurationmanager-configurationdefinitions</a>
         * @param configurationDefinitions The definition of the Quick Setup configuration that the configuration manager deploys. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder configurationDefinitions(final software.amazon.awscdk.IResolvable configurationDefinitions) {
            this.props.configurationDefinitions(configurationDefinitions);
            return this;
        }
        /**
         * The definition of the Quick Setup configuration that the configuration manager deploys.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssmquicksetup-configurationmanager.html#cfn-ssmquicksetup-configurationmanager-configurationdefinitions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssmquicksetup-configurationmanager.html#cfn-ssmquicksetup-configurationmanager-configurationdefinitions</a>
         * @param configurationDefinitions The definition of the Quick Setup configuration that the configuration manager deploys. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder configurationDefinitions(final java.util.List<? extends java.lang.Object> configurationDefinitions) {
            this.props.configurationDefinitions(configurationDefinitions);
            return this;
        }

        /**
         * The description of the configuration.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssmquicksetup-configurationmanager.html#cfn-ssmquicksetup-configurationmanager-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssmquicksetup-configurationmanager.html#cfn-ssmquicksetup-configurationmanager-description</a>
         * @param description The description of the configuration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * The name of the configuration.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssmquicksetup-configurationmanager.html#cfn-ssmquicksetup-configurationmanager-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssmquicksetup-configurationmanager.html#cfn-ssmquicksetup-configurationmanager-name</a>
         * @param name The name of the configuration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props.name(name);
            return this;
        }

        /**
         * Key-value pairs of metadata to assign to the configuration manager.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssmquicksetup-configurationmanager.html#cfn-ssmquicksetup-configurationmanager-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssmquicksetup-configurationmanager.html#cfn-ssmquicksetup-configurationmanager-tags</a>
         * @param tags Key-value pairs of metadata to assign to the configuration manager. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.Map<java.lang.String, java.lang.String> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.ssmquicksetup.CfnConfigurationManager}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.ssmquicksetup.CfnConfigurationManager build() {
            return new software.amazon.awscdk.services.ssmquicksetup.CfnConfigurationManager(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
