package software.amazon.awscdk.services.stepfunctions;

/**
 * Item Reader configuration for iterating over objects in an S3 bucket.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.s3.*;
 * /**
 *  * Tree view of bucket:
 *  *  my-bucket
 *  *  |
 *  *  +--item1
 *  *  |
 *  *  +--otherItem
 *  *  |
 *  *  +--item2
 *  *  |
 *  *  ...
 *  *&#47;
 * Bucket bucket = Bucket.Builder.create(this, "Bucket")
 *         .bucketName("my-bucket")
 *         .build();
 * DistributedMap distributedMap = DistributedMap.Builder.create(this, "DistributedMap")
 *         .itemReader(S3ObjectsItemReader.Builder.create()
 *                 .bucket(bucket)
 *                 .prefix("item")
 *                 .build())
 *         .build();
 * distributedMap.itemProcessor(new Pass(this, "Pass"));
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-24T11:33:23.854Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_stepfunctions.S3ObjectsItemReader")
public class S3ObjectsItemReader extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.stepfunctions.IItemReader {

    protected S3ObjectsItemReader(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected S3ObjectsItemReader(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public S3ObjectsItemReader(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.S3ObjectsItemReaderProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Compile policy statements to provide relevent permissions to the state machine.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.iam.PolicyStatement> providePolicyStatements() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.call(this, "providePolicyStatements", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.PolicyStatement.class))));
    }

    /**
     * Renders the ItemReader configuration as JSON object.
     * <p>
     * @return <ul>
     * <li>JSON object</li>
     * </ul>
     * @param queryLanguage
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull java.lang.Object render(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.stepfunctions.QueryLanguage queryLanguage) {
        return software.amazon.jsii.Kernel.call(this, "render", software.amazon.jsii.NativeType.forClass(java.lang.Object.class), new Object[] { queryLanguage });
    }

    /**
     * Renders the ItemReader configuration as JSON object.
     * <p>
     * @return <ul>
     * <li>JSON object</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull java.lang.Object render() {
        return software.amazon.jsii.Kernel.call(this, "render", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Validate that ItemReader contains exactly either.
     * <p>
     * @see <a href="bucketNamePath">bucketNamePath</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> validateItemReader() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.call(this, "validateItemReader", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))));
    }

    /**
     * S3 Bucket containing objects to iterate over.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.s3.IBucket getBucket() {
        return software.amazon.jsii.Kernel.get(this, "bucket", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.s3.IBucket.class));
    }

    /**
     * ARN for the <code>listObjectsV2</code> method of the S3 API This API method is used to iterate all objects in the S3 bucket/prefix.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getResource() {
        return software.amazon.jsii.Kernel.get(this, "resource", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * S3 bucket name containing objects to iterate over or a file with a list to iterate over, as JsonPath.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getBucketNamePath() {
        return software.amazon.jsii.Kernel.get(this, "bucketNamePath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Limits the number of items passed to the Distributed Map state.
     * <p>
     * Default: - Distributed Map state will iterate over all items provided by the ItemReader
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getMaxItems() {
        return software.amazon.jsii.Kernel.get(this, "maxItems", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * S3 prefix used to limit objects to iterate over.
     * <p>
     * Default: - No prefix
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getPrefix() {
        return software.amazon.jsii.Kernel.get(this, "prefix", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.stepfunctions.S3ObjectsItemReader}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.stepfunctions.S3ObjectsItemReader> {
        /**
         * @return a new instance of {@link Builder}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create() {
            return new Builder();
        }

        private final software.amazon.awscdk.services.stepfunctions.S3ObjectsItemReaderProps.Builder props;

        private Builder() {
            this.props = new software.amazon.awscdk.services.stepfunctions.S3ObjectsItemReaderProps.Builder();
        }

        /**
         * S3 Bucket containing objects to iterate over or a file with a list to iterate over.
         * <p>
         * Default: - S3 bucket will be determined from
         * <p>
         * @return {@code this}
         * @see <a href="bucketNamePath">bucketNamePath</a>
         * @param bucket S3 Bucket containing objects to iterate over or a file with a list to iterate over. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bucket(final software.amazon.awscdk.services.s3.IBucket bucket) {
            this.props.bucket(bucket);
            return this;
        }

        /**
         * S3 bucket name containing objects to iterate over or a file with a list to iterate over, as JsonPath.
         * <p>
         * Default: - S3 bucket will be determined from
         * <p>
         * @return {@code this}
         * @see <a href="bucket">bucket</a>
         * @param bucketNamePath S3 bucket name containing objects to iterate over or a file with a list to iterate over, as JsonPath. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bucketNamePath(final java.lang.String bucketNamePath) {
            this.props.bucketNamePath(bucketNamePath);
            return this;
        }

        /**
         * Limits the number of items passed to the Distributed Map state.
         * <p>
         * Default: - Distributed Map state will iterate over all items provided by the ItemReader
         * <p>
         * @return {@code this}
         * @param maxItems Limits the number of items passed to the Distributed Map state. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxItems(final java.lang.Number maxItems) {
            this.props.maxItems(maxItems);
            return this;
        }

        /**
         * S3 prefix used to limit objects to iterate over.
         * <p>
         * Default: - No prefix
         * <p>
         * @return {@code this}
         * @param prefix S3 prefix used to limit objects to iterate over. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder prefix(final java.lang.String prefix) {
            this.props.prefix(prefix);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.stepfunctions.S3ObjectsItemReader}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.stepfunctions.S3ObjectsItemReader build() {
            return new software.amazon.awscdk.services.stepfunctions.S3ObjectsItemReader(
                this.props.build()
            );
        }
    }
}
