package software.amazon.awscdk.services.stepfunctions.tasks;

/**
 * A Step Functions Task to create model customization in Bedrock.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.bedrock.*;
 * import software.amazon.awscdk.services.kms.*;
 * IBucket outputBucket;
 * IBucket trainingBucket;
 * IBucket validationBucket;
 * IKey kmsKey;
 * IVpc vpc;
 * FoundationModel model = FoundationModel.fromFoundationModelId(this, "Model", FoundationModelIdentifier.AMAZON_TITAN_TEXT_G1_EXPRESS_V1);
 * BedrockCreateModelCustomizationJob task = BedrockCreateModelCustomizationJob.Builder.create(this, "CreateModelCustomizationJob")
 *         .baseModel(model)
 *         .clientRequestToken("MyToken")
 *         .customizationType(CustomizationType.FINE_TUNING)
 *         .customModelKmsKey(kmsKey)
 *         .customModelName("MyCustomModel") // required
 *         .customModelTags(List.of(CustomModelTag.builder().key("key1").value("value1").build()))
 *         .hyperParameters(Map.of(
 *                 "batchSize", "10"))
 *         .jobName("MyCustomizationJob") // required
 *         .jobTags(List.of(CustomModelTag.builder().key("key2").value("value2").build()))
 *         .outputData(OutputBucketConfiguration.builder()
 *                 .bucket(outputBucket) // required
 *                 .path("output-data/")
 *                 .build())
 *         .trainingData(TrainingBucketConfiguration.builder()
 *                 .bucket(trainingBucket)
 *                 .path("training-data/data.json")
 *                 .build()) // required
 *         // If you don't provide validation data, you have to specify `Evaluation percentage` hyperparameter.
 *         .validationData(List.of(ValidationBucketConfiguration.builder()
 *                 .bucket(validationBucket)
 *                 .path("validation-data/data.json")
 *                 .build()))
 *         .vpcConfig(Map.of(
 *                 "securityGroups", List.of(SecurityGroup.Builder.create(this, "SecurityGroup").vpc(vpc).build()),
 *                 "subnets", vpc.getPrivateSubnets()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-24T11:33:23.970Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_stepfunctions_tasks.BedrockCreateModelCustomizationJob")
public class BedrockCreateModelCustomizationJob extends software.amazon.awscdk.services.stepfunctions.TaskStateBase {

    protected BedrockCreateModelCustomizationJob(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected BedrockCreateModelCustomizationJob(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id Descriptive identifier for this chainable. This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public BedrockCreateModelCustomizationJob(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.tasks.BedrockCreateModelCustomizationJobProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * The IAM role for the bedrock create model customization job.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IRole getRole() {
        return software.amazon.jsii.Kernel.get(this, "role", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.stepfunctions.TaskMetricsConfig getTaskMetrics() {
        return software.amazon.jsii.Kernel.get(this, "taskMetrics", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.TaskMetricsConfig.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.iam.PolicyStatement> getTaskPolicies() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.services.iam.PolicyStatement>)(software.amazon.jsii.Kernel.get(this, "taskPolicies", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.PolicyStatement.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.stepfunctions.tasks.BedrockCreateModelCustomizationJob}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.stepfunctions.tasks.BedrockCreateModelCustomizationJob> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id Descriptive identifier for this chainable. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.stepfunctions.tasks.BedrockCreateModelCustomizationJobProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.stepfunctions.tasks.BedrockCreateModelCustomizationJobProps.Builder();
        }

        /**
         * A comment describing this state.
         * <p>
         * Default: No comment
         * <p>
         * @return {@code this}
         * @param comment A comment describing this state. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder comment(final java.lang.String comment) {
            this.props.comment(comment);
            return this;
        }

        /**
         * The name of the query language used by the state.
         * <p>
         * If the state does not contain a <code>queryLanguage</code> field,
         * then it will use the query language specified in the top-level <code>queryLanguage</code> field.
         * <p>
         * Default: - JSONPath
         * <p>
         * @return {@code this}
         * @param queryLanguage The name of the query language used by the state. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder queryLanguage(final software.amazon.awscdk.services.stepfunctions.QueryLanguage queryLanguage) {
            this.props.queryLanguage(queryLanguage);
            return this;
        }

        /**
         * Optional name for this state.
         * <p>
         * Default: - The construct ID will be used as state name
         * <p>
         * @return {@code this}
         * @param stateName Optional name for this state. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stateName(final java.lang.String stateName) {
            this.props.stateName(stateName);
            return this;
        }

        /**
         * Credentials for an IAM Role that the State Machine assumes for executing the task.
         * <p>
         * This enables cross-account resource invocations.
         * <p>
         * Default: - None (Task is executed using the State Machine's execution role)
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-access-cross-acct-resources.html">https://docs.aws.amazon.com/step-functions/latest/dg/concepts-access-cross-acct-resources.html</a>
         * @param credentials Credentials for an IAM Role that the State Machine assumes for executing the task. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder credentials(final software.amazon.awscdk.services.stepfunctions.Credentials credentials) {
            this.props.credentials(credentials);
            return this;
        }

        /**
         * (deprecated) Timeout for the heartbeat.
         * <p>
         * Default: - None
         * <p>
         * @return {@code this}
         * @deprecated use <code>heartbeatTimeout</code>
         * @param heartbeat Timeout for the heartbeat. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder heartbeat(final software.amazon.awscdk.Duration heartbeat) {
            this.props.heartbeat(heartbeat);
            return this;
        }

        /**
         * Timeout for the heartbeat.
         * <p>
         * [disable-awslint:duration-prop-type] is needed because all props interface in
         * aws-stepfunctions-tasks extend this interface
         * <p>
         * Default: - None
         * <p>
         * @return {@code this}
         * @param heartbeatTimeout Timeout for the heartbeat. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder heartbeatTimeout(final software.amazon.awscdk.services.stepfunctions.Timeout heartbeatTimeout) {
            this.props.heartbeatTimeout(heartbeatTimeout);
            return this;
        }

        /**
         * AWS Step Functions integrates with services directly in the Amazon States Language.
         * <p>
         * You can control these AWS services using service integration patterns.
         * <p>
         * Depending on the AWS Service, the Service Integration Pattern availability will vary.
         * <p>
         * Default: - `IntegrationPattern.REQUEST_RESPONSE` for most tasks.
         * `IntegrationPattern.RUN_JOB` for the following exceptions:
         * `BatchSubmitJob`, `EmrAddStep`, `EmrCreateCluster`, `EmrTerminationCluster`, and `EmrContainersStartJobRun`.
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/step-functions/latest/dg/connect-supported-services.html">https://docs.aws.amazon.com/step-functions/latest/dg/connect-supported-services.html</a>
         * @param integrationPattern AWS Step Functions integrates with services directly in the Amazon States Language. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder integrationPattern(final software.amazon.awscdk.services.stepfunctions.IntegrationPattern integrationPattern) {
            this.props.integrationPattern(integrationPattern);
            return this;
        }

        /**
         * Timeout for the task.
         * <p>
         * [disable-awslint:duration-prop-type] is needed because all props interface in
         * aws-stepfunctions-tasks extend this interface
         * <p>
         * Default: - None
         * <p>
         * @return {@code this}
         * @param taskTimeout Timeout for the task. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder taskTimeout(final software.amazon.awscdk.services.stepfunctions.Timeout taskTimeout) {
            this.props.taskTimeout(taskTimeout);
            return this;
        }

        /**
         * (deprecated) Timeout for the task.
         * <p>
         * Default: - None
         * <p>
         * @return {@code this}
         * @deprecated use <code>taskTimeout</code>
         * @param timeout Timeout for the task. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder timeout(final software.amazon.awscdk.Duration timeout) {
            this.props.timeout(timeout);
            return this;
        }

        /**
         * Workflow variables to store in this step.
         * <p>
         * Using workflow variables, you can store data in a step and retrieve that data in future steps.
         * <p>
         * Default: - Not assign variables
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/step-functions/latest/dg/workflow-variables.html">https://docs.aws.amazon.com/step-functions/latest/dg/workflow-variables.html</a>
         * @param assign Workflow variables to store in this step. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder assign(final java.util.Map<java.lang.String, ? extends java.lang.Object> assign) {
            this.props.assign(assign);
            return this;
        }

        /**
         * JSONPath expression to select part of the state to be the input to this state.
         * <p>
         * May also be the special value JsonPath.DISCARD, which will cause the effective
         * input to be the empty object {}.
         * <p>
         * Default: $
         * <p>
         * @return {@code this}
         * @param inputPath JSONPath expression to select part of the state to be the input to this state. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder inputPath(final java.lang.String inputPath) {
            this.props.inputPath(inputPath);
            return this;
        }

        /**
         * JSONPath expression to select part of the state to be the output to this state.
         * <p>
         * May also be the special value JsonPath.DISCARD, which will cause the effective
         * output to be the empty object {}.
         * <p>
         * Default: $
         * <p>
         * @return {@code this}
         * @param outputPath JSONPath expression to select part of the state to be the output to this state. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder outputPath(final java.lang.String outputPath) {
            this.props.outputPath(outputPath);
            return this;
        }

        /**
         * Used to specify and transform output from the state.
         * <p>
         * When specified, the value overrides the state output default.
         * The output field accepts any JSON value (object, array, string, number, boolean, null).
         * Any string value, including those inside objects or arrays,
         * will be evaluated as JSONata if surrounded by {% %} characters.
         * Output also accepts a JSONata expression directly.
         * <p>
         * Default: - $states.result or $states.errorOutput
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-input-output-filtering.html">https://docs.aws.amazon.com/step-functions/latest/dg/concepts-input-output-filtering.html</a>
         * @param outputs Used to specify and transform output from the state. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder outputs(final java.lang.Object outputs) {
            this.props.outputs(outputs);
            return this;
        }

        /**
         * JSONPath expression to indicate where to inject the state's output.
         * <p>
         * May also be the special value JsonPath.DISCARD, which will cause the state's
         * input to become its output.
         * <p>
         * Default: $
         * <p>
         * @return {@code this}
         * @param resultPath JSONPath expression to indicate where to inject the state's output. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resultPath(final java.lang.String resultPath) {
            this.props.resultPath(resultPath);
            return this;
        }

        /**
         * The JSON that will replace the state's raw result and become the effective result before ResultPath is applied.
         * <p>
         * You can use ResultSelector to create a payload with values that are static
         * or selected from the state's raw result.
         * <p>
         * Default: - None
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/step-functions/latest/dg/input-output-inputpath-params.html#input-output-resultselector">https://docs.aws.amazon.com/step-functions/latest/dg/input-output-inputpath-params.html#input-output-resultselector</a>
         * @param resultSelector The JSON that will replace the state's raw result and become the effective result before ResultPath is applied. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resultSelector(final java.util.Map<java.lang.String, ? extends java.lang.Object> resultSelector) {
            this.props.resultSelector(resultSelector);
            return this;
        }

        /**
         * The base model.
         * <p>
         * @return {@code this}
         * @param baseModel The base model. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder baseModel(final software.amazon.awscdk.services.bedrock.IModel baseModel) {
            this.props.baseModel(baseModel);
            return this;
        }

        /**
         * A name for the resulting custom model.
         * <p>
         * The maximum length is 63 characters.
         * <p>
         * @return {@code this}
         * @param customModelName A name for the resulting custom model. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder customModelName(final java.lang.String customModelName) {
            this.props.customModelName(customModelName);
            return this;
        }

        /**
         * A name for the fine-tuning job.
         * <p>
         * The maximum length is 63 characters.
         * <p>
         * @return {@code this}
         * @param jobName A name for the fine-tuning job. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder jobName(final java.lang.String jobName) {
            this.props.jobName(jobName);
            return this;
        }

        /**
         * The S3 bucket configuration where the output data is stored.
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_OutputDataConfig.html">https://docs.aws.amazon.com/bedrock/latest/APIReference/API_OutputDataConfig.html</a>
         * @param outputData The S3 bucket configuration where the output data is stored. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder outputData(final software.amazon.awscdk.services.stepfunctions.tasks.OutputBucketConfiguration outputData) {
            this.props.outputData(outputData);
            return this;
        }

        /**
         * The S3 bucket configuration where the training data is stored.
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_TrainingDataConfig.html">https://docs.aws.amazon.com/bedrock/latest/APIReference/API_TrainingDataConfig.html</a>
         * @param trainingData The S3 bucket configuration where the training data is stored. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder trainingData(final software.amazon.awscdk.services.stepfunctions.tasks.TrainingBucketConfiguration trainingData) {
            this.props.trainingData(trainingData);
            return this;
        }

        /**
         * A unique, case-sensitive identifier to ensure that the API request completes no more than one time.
         * <p>
         * If this token matches a previous request, Amazon Bedrock ignores the request, but does not return an error.
         * <p>
         * The maximum length is 256 characters.
         * <p>
         * Default: - no client request token
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html</a>
         * @param clientRequestToken A unique, case-sensitive identifier to ensure that the API request completes no more than one time. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder clientRequestToken(final java.lang.String clientRequestToken) {
            this.props.clientRequestToken(clientRequestToken);
            return this;
        }

        /**
         * The customization type.
         * <p>
         * Default: FINE_TUNING
         * <p>
         * @return {@code this}
         * @param customizationType The customization type. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder customizationType(final software.amazon.awscdk.services.stepfunctions.tasks.CustomizationType customizationType) {
            this.props.customizationType(customizationType);
            return this;
        }

        /**
         * The custom model is encrypted at rest using this key.
         * <p>
         * Default: - encrypted with the AWS owned key
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/encryption-custom-job.html">https://docs.aws.amazon.com/bedrock/latest/userguide/encryption-custom-job.html</a>
         * @param customModelKmsKey The custom model is encrypted at rest using this key. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder customModelKmsKey(final software.amazon.awscdk.services.kms.IKey customModelKmsKey) {
            this.props.customModelKmsKey(customModelKmsKey);
            return this;
        }

        /**
         * Tags to attach to the resulting custom model.
         * <p>
         * The maximum number of tags is 200.
         * <p>
         * Default: - no tags
         * <p>
         * @return {@code this}
         * @param customModelTags Tags to attach to the resulting custom model. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder customModelTags(final java.util.List<? extends software.amazon.awscdk.services.stepfunctions.tasks.CustomModelTag> customModelTags) {
            this.props.customModelTags(customModelTags);
            return this;
        }

        /**
         * Parameters related to tuning the model.
         * <p>
         * Default: - use default hyperparameters
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/custom-models-hp.html">https://docs.aws.amazon.com/bedrock/latest/userguide/custom-models-hp.html</a>
         * @param hyperParameters Parameters related to tuning the model. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder hyperParameters(final java.util.Map<java.lang.String, java.lang.String> hyperParameters) {
            this.props.hyperParameters(hyperParameters);
            return this;
        }

        /**
         * Tags to attach to the job.
         * <p>
         * The maximum number of tags is 200.
         * <p>
         * Default: - no tags
         * <p>
         * @return {@code this}
         * @param jobTags Tags to attach to the job. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder jobTags(final java.util.List<? extends software.amazon.awscdk.services.stepfunctions.tasks.CustomModelTag> jobTags) {
            this.props.jobTags(jobTags);
            return this;
        }

        /**
         * The IAM role that Amazon Bedrock can assume to perform tasks on your behalf.
         * <p>
         * For example, during model training, Amazon Bedrock needs your permission to read input data from an S3 bucket,
         * write model artifacts to an S3 bucket.
         * To pass this role to Amazon Bedrock, the caller of this API must have the iam:PassRole permission.
         * <p>
         * Default: - use auto generated role
         * <p>
         * @return {@code this}
         * @param role The IAM role that Amazon Bedrock can assume to perform tasks on your behalf. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder role(final software.amazon.awscdk.services.iam.IRole role) {
            this.props.role(role);
            return this;
        }

        /**
         * The S3 bucket configuration where the validation data is stored.
         * <p>
         * If you don't provide a validation dataset, specify the evaluation percentage by the <code>Evaluation percentage</code> hyperparameter.
         * <p>
         * The maximum number is 10.
         * <p>
         * Default: undefined - validate using a subset of the training data
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_Validator.html">https://docs.aws.amazon.com/bedrock/latest/APIReference/API_Validator.html</a>
         * @param validationData The S3 bucket configuration where the validation data is stored. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder validationData(final java.util.List<? extends software.amazon.awscdk.services.stepfunctions.tasks.ValidationBucketConfiguration> validationData) {
            this.props.validationData(validationData);
            return this;
        }

        /**
         * The VPC configuration.
         * <p>
         * Default: - no VPC configuration
         * <p>
         * @return {@code this}
         * @param vpcConfig The VPC configuration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcConfig(final software.amazon.awscdk.services.stepfunctions.tasks.IBedrockCreateModelCustomizationJobVpcConfig vpcConfig) {
            this.props.vpcConfig(vpcConfig);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.stepfunctions.tasks.BedrockCreateModelCustomizationJob}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.stepfunctions.tasks.BedrockCreateModelCustomizationJob build() {
            return new software.amazon.awscdk.services.stepfunctions.tasks.BedrockCreateModelCustomizationJob(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
