package software.amazon.awscdk.services.verifiedpermissions;

/**
 * Properties for defining a <code>CfnPolicy</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.verifiedpermissions.*;
 * CfnPolicyProps cfnPolicyProps = CfnPolicyProps.builder()
 *         .definition(PolicyDefinitionProperty.builder()
 *                 .static(StaticPolicyDefinitionProperty.builder()
 *                         .statement("statement")
 *                         // the properties below are optional
 *                         .description("description")
 *                         .build())
 *                 .templateLinked(TemplateLinkedPolicyDefinitionProperty.builder()
 *                         .policyTemplateId("policyTemplateId")
 *                         // the properties below are optional
 *                         .principal(EntityIdentifierProperty.builder()
 *                                 .entityId("entityId")
 *                                 .entityType("entityType")
 *                                 .build())
 *                         .resource(EntityIdentifierProperty.builder()
 *                                 .entityId("entityId")
 *                                 .entityType("entityType")
 *                                 .build())
 *                         .build())
 *                 .build())
 *         .policyStoreId("policyStoreId")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-verifiedpermissions-policy.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-verifiedpermissions-policy.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-24T11:33:24.584Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_verifiedpermissions.CfnPolicyProps")
@software.amazon.jsii.Jsii.Proxy(CfnPolicyProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnPolicyProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Specifies the policy type and content to use for the new or updated policy.
     * <p>
     * The definition structure must include either a <code>Static</code> or a <code>TemplateLinked</code> element.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-verifiedpermissions-policy.html#cfn-verifiedpermissions-policy-definition">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-verifiedpermissions-policy.html#cfn-verifiedpermissions-policy-definition</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getDefinition();

    /**
     * Specifies the <code>PolicyStoreId</code> of the policy store you want to store the policy in.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-verifiedpermissions-policy.html#cfn-verifiedpermissions-policy-policystoreid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-verifiedpermissions-policy.html#cfn-verifiedpermissions-policy-policystoreid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getPolicyStoreId();

    /**
     * @return a {@link Builder} of {@link CfnPolicyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnPolicyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnPolicyProps> {
        java.lang.Object definition;
        java.lang.String policyStoreId;

        /**
         * Sets the value of {@link CfnPolicyProps#getDefinition}
         * @param definition Specifies the policy type and content to use for the new or updated policy. This parameter is required.
         *                   The definition structure must include either a <code>Static</code> or a <code>TemplateLinked</code> element.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder definition(software.amazon.awscdk.IResolvable definition) {
            this.definition = definition;
            return this;
        }

        /**
         * Sets the value of {@link CfnPolicyProps#getDefinition}
         * @param definition Specifies the policy type and content to use for the new or updated policy. This parameter is required.
         *                   The definition structure must include either a <code>Static</code> or a <code>TemplateLinked</code> element.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder definition(software.amazon.awscdk.services.verifiedpermissions.CfnPolicy.PolicyDefinitionProperty definition) {
            this.definition = definition;
            return this;
        }

        /**
         * Sets the value of {@link CfnPolicyProps#getPolicyStoreId}
         * @param policyStoreId Specifies the <code>PolicyStoreId</code> of the policy store you want to store the policy in. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder policyStoreId(java.lang.String policyStoreId) {
            this.policyStoreId = policyStoreId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnPolicyProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnPolicyProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnPolicyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnPolicyProps {
        private final java.lang.Object definition;
        private final java.lang.String policyStoreId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.definition = software.amazon.jsii.Kernel.get(this, "definition", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.policyStoreId = software.amazon.jsii.Kernel.get(this, "policyStoreId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.definition = java.util.Objects.requireNonNull(builder.definition, "definition is required");
            this.policyStoreId = java.util.Objects.requireNonNull(builder.policyStoreId, "policyStoreId is required");
        }

        @Override
        public final java.lang.Object getDefinition() {
            return this.definition;
        }

        @Override
        public final java.lang.String getPolicyStoreId() {
            return this.policyStoreId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("definition", om.valueToTree(this.getDefinition()));
            data.set("policyStoreId", om.valueToTree(this.getPolicyStoreId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_verifiedpermissions.CfnPolicyProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnPolicyProps.Jsii$Proxy that = (CfnPolicyProps.Jsii$Proxy) o;

            if (!definition.equals(that.definition)) return false;
            return this.policyStoreId.equals(that.policyStoreId);
        }

        @Override
        public final int hashCode() {
            int result = this.definition.hashCode();
            result = 31 * result + (this.policyStoreId.hashCode());
            return result;
        }
    }
}
