package software.amazon.awscdk.services.waf.regional;

/**
 * Properties for defining a <code>CfnSqlInjectionMatchSet</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.waf.regional.*;
 * CfnSqlInjectionMatchSetProps cfnSqlInjectionMatchSetProps = CfnSqlInjectionMatchSetProps.builder()
 *         .name("name")
 *         // the properties below are optional
 *         .sqlInjectionMatchTuples(List.of(SqlInjectionMatchTupleProperty.builder()
 *                 .fieldToMatch(FieldToMatchProperty.builder()
 *                         .type("type")
 *                         // the properties below are optional
 *                         .data("data")
 *                         .build())
 *                 .textTransformation("textTransformation")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafregional-sqlinjectionmatchset.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafregional-sqlinjectionmatchset.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-24T11:33:24.704Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_wafregional.CfnSqlInjectionMatchSetProps")
@software.amazon.jsii.Jsii.Proxy(CfnSqlInjectionMatchSetProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnSqlInjectionMatchSetProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The name, if any, of the <code>SqlInjectionMatchSet</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafregional-sqlinjectionmatchset.html#cfn-wafregional-sqlinjectionmatchset-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafregional-sqlinjectionmatchset.html#cfn-wafregional-sqlinjectionmatchset-name</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getName();

    /**
     * Specifies the parts of web requests that you want to inspect for snippets of malicious SQL code.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafregional-sqlinjectionmatchset.html#cfn-wafregional-sqlinjectionmatchset-sqlinjectionmatchtuples">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafregional-sqlinjectionmatchset.html#cfn-wafregional-sqlinjectionmatchset-sqlinjectionmatchtuples</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getSqlInjectionMatchTuples() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnSqlInjectionMatchSetProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnSqlInjectionMatchSetProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnSqlInjectionMatchSetProps> {
        java.lang.String name;
        java.lang.Object sqlInjectionMatchTuples;

        /**
         * Sets the value of {@link CfnSqlInjectionMatchSetProps#getName}
         * @param name The name, if any, of the <code>SqlInjectionMatchSet</code> . This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnSqlInjectionMatchSetProps#getSqlInjectionMatchTuples}
         * @param sqlInjectionMatchTuples Specifies the parts of web requests that you want to inspect for snippets of malicious SQL code.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sqlInjectionMatchTuples(software.amazon.awscdk.IResolvable sqlInjectionMatchTuples) {
            this.sqlInjectionMatchTuples = sqlInjectionMatchTuples;
            return this;
        }

        /**
         * Sets the value of {@link CfnSqlInjectionMatchSetProps#getSqlInjectionMatchTuples}
         * @param sqlInjectionMatchTuples Specifies the parts of web requests that you want to inspect for snippets of malicious SQL code.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sqlInjectionMatchTuples(java.util.List<? extends java.lang.Object> sqlInjectionMatchTuples) {
            this.sqlInjectionMatchTuples = sqlInjectionMatchTuples;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnSqlInjectionMatchSetProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnSqlInjectionMatchSetProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnSqlInjectionMatchSetProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnSqlInjectionMatchSetProps {
        private final java.lang.String name;
        private final java.lang.Object sqlInjectionMatchTuples;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.sqlInjectionMatchTuples = software.amazon.jsii.Kernel.get(this, "sqlInjectionMatchTuples", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            this.sqlInjectionMatchTuples = builder.sqlInjectionMatchTuples;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.Object getSqlInjectionMatchTuples() {
            return this.sqlInjectionMatchTuples;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("name", om.valueToTree(this.getName()));
            if (this.getSqlInjectionMatchTuples() != null) {
                data.set("sqlInjectionMatchTuples", om.valueToTree(this.getSqlInjectionMatchTuples()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_wafregional.CfnSqlInjectionMatchSetProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnSqlInjectionMatchSetProps.Jsii$Proxy that = (CfnSqlInjectionMatchSetProps.Jsii$Proxy) o;

            if (!name.equals(that.name)) return false;
            return this.sqlInjectionMatchTuples != null ? this.sqlInjectionMatchTuples.equals(that.sqlInjectionMatchTuples) : that.sqlInjectionMatchTuples == null;
        }

        @Override
        public final int hashCode() {
            int result = this.name.hashCode();
            result = 31 * result + (this.sqlInjectionMatchTuples != null ? this.sqlInjectionMatchTuples.hashCode() : 0);
            return result;
        }
    }
}
