package software.amazon.awscdk.services.wisdom;

/**
 * Properties for defining a <code>CfnAIGuardrailVersion</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.wisdom.*;
 * CfnAIGuardrailVersionProps cfnAIGuardrailVersionProps = CfnAIGuardrailVersionProps.builder()
 *         .aiGuardrailId("aiGuardrailId")
 *         .assistantId("assistantId")
 *         // the properties below are optional
 *         .modifiedTimeSeconds(123)
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-aiguardrailversion.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-aiguardrailversion.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-24T11:33:24.931Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_wisdom.CfnAIGuardrailVersionProps")
@software.amazon.jsii.Jsii.Proxy(CfnAIGuardrailVersionProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnAIGuardrailVersionProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ID of the AI guardrail version.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-aiguardrailversion.html#cfn-wisdom-aiguardrailversion-aiguardrailid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-aiguardrailversion.html#cfn-wisdom-aiguardrailversion-aiguardrailid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getAiGuardrailId();

    /**
     * The ID of the AI guardrail version assistant.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-aiguardrailversion.html#cfn-wisdom-aiguardrailversion-assistantid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-aiguardrailversion.html#cfn-wisdom-aiguardrailversion-assistantid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getAssistantId();

    /**
     * The modified time of the AI guardrail version in seconds.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-aiguardrailversion.html#cfn-wisdom-aiguardrailversion-modifiedtimeseconds">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-aiguardrailversion.html#cfn-wisdom-aiguardrailversion-modifiedtimeseconds</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getModifiedTimeSeconds() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnAIGuardrailVersionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnAIGuardrailVersionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnAIGuardrailVersionProps> {
        java.lang.String aiGuardrailId;
        java.lang.String assistantId;
        java.lang.Number modifiedTimeSeconds;

        /**
         * Sets the value of {@link CfnAIGuardrailVersionProps#getAiGuardrailId}
         * @param aiGuardrailId The ID of the AI guardrail version. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder aiGuardrailId(java.lang.String aiGuardrailId) {
            this.aiGuardrailId = aiGuardrailId;
            return this;
        }

        /**
         * Sets the value of {@link CfnAIGuardrailVersionProps#getAssistantId}
         * @param assistantId The ID of the AI guardrail version assistant. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder assistantId(java.lang.String assistantId) {
            this.assistantId = assistantId;
            return this;
        }

        /**
         * Sets the value of {@link CfnAIGuardrailVersionProps#getModifiedTimeSeconds}
         * @param modifiedTimeSeconds The modified time of the AI guardrail version in seconds.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder modifiedTimeSeconds(java.lang.Number modifiedTimeSeconds) {
            this.modifiedTimeSeconds = modifiedTimeSeconds;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnAIGuardrailVersionProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnAIGuardrailVersionProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnAIGuardrailVersionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnAIGuardrailVersionProps {
        private final java.lang.String aiGuardrailId;
        private final java.lang.String assistantId;
        private final java.lang.Number modifiedTimeSeconds;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.aiGuardrailId = software.amazon.jsii.Kernel.get(this, "aiGuardrailId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.assistantId = software.amazon.jsii.Kernel.get(this, "assistantId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.modifiedTimeSeconds = software.amazon.jsii.Kernel.get(this, "modifiedTimeSeconds", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.aiGuardrailId = java.util.Objects.requireNonNull(builder.aiGuardrailId, "aiGuardrailId is required");
            this.assistantId = java.util.Objects.requireNonNull(builder.assistantId, "assistantId is required");
            this.modifiedTimeSeconds = builder.modifiedTimeSeconds;
        }

        @Override
        public final java.lang.String getAiGuardrailId() {
            return this.aiGuardrailId;
        }

        @Override
        public final java.lang.String getAssistantId() {
            return this.assistantId;
        }

        @Override
        public final java.lang.Number getModifiedTimeSeconds() {
            return this.modifiedTimeSeconds;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("aiGuardrailId", om.valueToTree(this.getAiGuardrailId()));
            data.set("assistantId", om.valueToTree(this.getAssistantId()));
            if (this.getModifiedTimeSeconds() != null) {
                data.set("modifiedTimeSeconds", om.valueToTree(this.getModifiedTimeSeconds()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_wisdom.CfnAIGuardrailVersionProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnAIGuardrailVersionProps.Jsii$Proxy that = (CfnAIGuardrailVersionProps.Jsii$Proxy) o;

            if (!aiGuardrailId.equals(that.aiGuardrailId)) return false;
            if (!assistantId.equals(that.assistantId)) return false;
            return this.modifiedTimeSeconds != null ? this.modifiedTimeSeconds.equals(that.modifiedTimeSeconds) : that.modifiedTimeSeconds == null;
        }

        @Override
        public final int hashCode() {
            int result = this.aiGuardrailId.hashCode();
            result = 31 * result + (this.assistantId.hashCode());
            result = 31 * result + (this.modifiedTimeSeconds != null ? this.modifiedTimeSeconds.hashCode() : 0);
            return result;
        }
    }
}
