package software.amazon.awscdk.services.wisdom;

/**
 * Specifies a knowledge base.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.wisdom.*;
 * CfnKnowledgeBase cfnKnowledgeBase = CfnKnowledgeBase.Builder.create(this, "MyCfnKnowledgeBase")
 *         .knowledgeBaseType("knowledgeBaseType")
 *         .name("name")
 *         // the properties below are optional
 *         .description("description")
 *         .renderingConfiguration(RenderingConfigurationProperty.builder()
 *                 .templateUri("templateUri")
 *                 .build())
 *         .serverSideEncryptionConfiguration(ServerSideEncryptionConfigurationProperty.builder()
 *                 .kmsKeyId("kmsKeyId")
 *                 .build())
 *         .sourceConfiguration(SourceConfigurationProperty.builder()
 *                 .appIntegrations(AppIntegrationsConfigurationProperty.builder()
 *                         .appIntegrationArn("appIntegrationArn")
 *                         // the properties below are optional
 *                         .objectFields(List.of("objectFields"))
 *                         .build())
 *                 .managedSourceConfiguration(ManagedSourceConfigurationProperty.builder()
 *                         .webCrawlerConfiguration(WebCrawlerConfigurationProperty.builder()
 *                                 .urlConfiguration(UrlConfigurationProperty.builder()
 *                                         .seedUrls(List.of(SeedUrlProperty.builder()
 *                                                 .url("url")
 *                                                 .build()))
 *                                         .build())
 *                                 // the properties below are optional
 *                                 .crawlerLimits(CrawlerLimitsProperty.builder()
 *                                         .rateLimit(123)
 *                                         .build())
 *                                 .exclusionFilters(List.of("exclusionFilters"))
 *                                 .inclusionFilters(List.of("inclusionFilters"))
 *                                 .scope("scope")
 *                                 .build())
 *                         .build())
 *                 .build())
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .vectorIngestionConfiguration(VectorIngestionConfigurationProperty.builder()
 *                 .chunkingConfiguration(ChunkingConfigurationProperty.builder()
 *                         .chunkingStrategy("chunkingStrategy")
 *                         // the properties below are optional
 *                         .fixedSizeChunkingConfiguration(FixedSizeChunkingConfigurationProperty.builder()
 *                                 .maxTokens(123)
 *                                 .overlapPercentage(123)
 *                                 .build())
 *                         .hierarchicalChunkingConfiguration(HierarchicalChunkingConfigurationProperty.builder()
 *                                 .levelConfigurations(List.of(HierarchicalChunkingLevelConfigurationProperty.builder()
 *                                         .maxTokens(123)
 *                                         .build()))
 *                                 .overlapTokens(123)
 *                                 .build())
 *                         .semanticChunkingConfiguration(SemanticChunkingConfigurationProperty.builder()
 *                                 .breakpointPercentileThreshold(123)
 *                                 .bufferSize(123)
 *                                 .maxTokens(123)
 *                                 .build())
 *                         .build())
 *                 .parsingConfiguration(ParsingConfigurationProperty.builder()
 *                         .parsingStrategy("parsingStrategy")
 *                         // the properties below are optional
 *                         .bedrockFoundationModelConfiguration(BedrockFoundationModelConfigurationProperty.builder()
 *                                 .modelArn("modelArn")
 *                                 // the properties below are optional
 *                                 .parsingPrompt(ParsingPromptProperty.builder()
 *                                         .parsingPromptText("parsingPromptText")
 *                                         .build())
 *                                 .build())
 *                         .build())
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-knowledgebase.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-knowledgebase.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-24T11:33:24.951Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_wisdom.CfnKnowledgeBase")
public class CfnKnowledgeBase extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.ITaggable {

    protected CfnKnowledgeBase(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnKnowledgeBase(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.wisdom.CfnKnowledgeBase.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnKnowledgeBase(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.wisdom.CfnKnowledgeBaseProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The Amazon Resource Name (ARN) of the knowledge base.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrKnowledgeBaseArn() {
        return software.amazon.jsii.Kernel.get(this, "attrKnowledgeBaseArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ID of the knowledge base.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrKnowledgeBaseId() {
        return software.amazon.jsii.Kernel.get(this, "attrKnowledgeBaseId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * The type of knowledge base.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getKnowledgeBaseType() {
        return software.amazon.jsii.Kernel.get(this, "knowledgeBaseType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The type of knowledge base.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setKnowledgeBaseType(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "knowledgeBaseType", java.util.Objects.requireNonNull(value, "knowledgeBaseType is required"));
    }

    /**
     * The name of the knowledge base.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the knowledge base.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "name", java.util.Objects.requireNonNull(value, "name is required"));
    }

    /**
     * The description.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The description.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDescription(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "description", value);
    }

    /**
     * Information about how to render the content.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getRenderingConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "renderingConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Information about how to render the content.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRenderingConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "renderingConfiguration", value);
    }

    /**
     * Information about how to render the content.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRenderingConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.wisdom.CfnKnowledgeBase.RenderingConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "renderingConfiguration", value);
    }

    /**
     * This customer managed key must have a policy that allows <code>kms:CreateGrant</code> and <code>kms:DescribeKey</code> permissions to the IAM identity using the key to invoke Wisdom.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getServerSideEncryptionConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "serverSideEncryptionConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * This customer managed key must have a policy that allows <code>kms:CreateGrant</code> and <code>kms:DescribeKey</code> permissions to the IAM identity using the key to invoke Wisdom.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setServerSideEncryptionConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "serverSideEncryptionConfiguration", value);
    }

    /**
     * This customer managed key must have a policy that allows <code>kms:CreateGrant</code> and <code>kms:DescribeKey</code> permissions to the IAM identity using the key to invoke Wisdom.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setServerSideEncryptionConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.wisdom.CfnKnowledgeBase.ServerSideEncryptionConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "serverSideEncryptionConfiguration", value);
    }

    /**
     * The source of the knowledge base content.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getSourceConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "sourceConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The source of the knowledge base content.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSourceConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "sourceConfiguration", value);
    }

    /**
     * The source of the knowledge base content.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSourceConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.wisdom.CfnKnowledgeBase.SourceConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "sourceConfiguration", value);
    }

    /**
     * The tags used to organize, track, or control access for this resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTagsRaw() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tagsRaw", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * The tags used to organize, track, or control access for this resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTagsRaw(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tagsRaw", value);
    }

    /**
     * Contains details about how to ingest the documents in a data source.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getVectorIngestionConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "vectorIngestionConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Contains details about how to ingest the documents in a data source.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setVectorIngestionConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "vectorIngestionConfiguration", value);
    }

    /**
     * Contains details about how to ingest the documents in a data source.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setVectorIngestionConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.wisdom.CfnKnowledgeBase.VectorIngestionConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "vectorIngestionConfiguration", value);
    }
    /**
     * Configuration information for Amazon AppIntegrations to automatically ingest content.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.wisdom.*;
     * AppIntegrationsConfigurationProperty appIntegrationsConfigurationProperty = AppIntegrationsConfigurationProperty.builder()
     *         .appIntegrationArn("appIntegrationArn")
     *         // the properties below are optional
     *         .objectFields(List.of("objectFields"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-knowledgebase-appintegrationsconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-knowledgebase-appintegrationsconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_wisdom.CfnKnowledgeBase.AppIntegrationsConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(AppIntegrationsConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AppIntegrationsConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon Resource Name (ARN) of the AppIntegrations DataIntegration to use for ingesting content.
         * <p>
         * <ul>
         * <li>For <a href="https://docs.aws.amazon.com/https://developer.salesforce.com/docs/atlas.en-us.knowledge_dev.meta/knowledge_dev/sforce_api_objects_knowledge__kav.htm">Salesforce</a> , your AppIntegrations DataIntegration must have an ObjectConfiguration if objectFields is not provided, including at least <code>Id</code> , <code>ArticleNumber</code> , <code>VersionNumber</code> , <code>Title</code> , <code>PublishStatus</code> , and <code>IsDeleted</code> as source fields.</li>
         * <li>For <a href="https://docs.aws.amazon.com/https://developer.servicenow.com/dev.do#!/reference/api/rome/rest/knowledge-management-api">ServiceNow</a> , your AppIntegrations DataIntegration must have an ObjectConfiguration if objectFields is not provided, including at least <code>number</code> , <code>short_description</code> , <code>sys_mod_count</code> , <code>workflow_state</code> , and <code>active</code> as source fields.</li>
         * <li>For <a href="https://docs.aws.amazon.com/https://developer.zendesk.com/api-reference/help_center/help-center-api/articles/">Zendesk</a> , your AppIntegrations DataIntegration must have an ObjectConfiguration if <code>objectFields</code> is not provided, including at least <code>id</code> , <code>title</code> , <code>updated_at</code> , and <code>draft</code> as source fields.</li>
         * <li>For <a href="https://docs.aws.amazon.com/https://learn.microsoft.com/en-us/sharepoint/dev/sp-add-ins/sharepoint-net-server-csom-jsom-and-rest-api-index">SharePoint</a> , your AppIntegrations DataIntegration must have a FileConfiguration, including only file extensions that are among <code>docx</code> , <code>pdf</code> , <code>html</code> , <code>htm</code> , and <code>txt</code> .</li>
         * <li>For <a href="https://docs.aws.amazon.com/s3/">Amazon S3</a> , the ObjectConfiguration and FileConfiguration of your AppIntegrations DataIntegration must be null. The <code>SourceURI</code> of your DataIntegration must use the following format: <code>s3://your_s3_bucket_name</code> .</li>
         * </ul>
         * <p>
         * <blockquote>
         * <p>
         * The bucket policy of the corresponding S3 bucket must allow the AWS principal <code>app-integrations.amazonaws.com</code> to perform <code>s3:ListBucket</code> , <code>s3:GetObject</code> , and <code>s3:GetBucketLocation</code> against the bucket.
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-knowledgebase-appintegrationsconfiguration.html#cfn-wisdom-knowledgebase-appintegrationsconfiguration-appintegrationarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-knowledgebase-appintegrationsconfiguration.html#cfn-wisdom-knowledgebase-appintegrationsconfiguration-appintegrationarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getAppIntegrationArn();

        /**
         * The fields from the source that are made available to your agents in Amazon Q in Connect.
         * <p>
         * Optional if ObjectConfiguration is included in the provided DataIntegration.
         * <p>
         * <ul>
         * <li>For <a href="https://docs.aws.amazon.com/https://developer.salesforce.com/docs/atlas.en-us.knowledge_dev.meta/knowledge_dev/sforce_api_objects_knowledge__kav.htm">Salesforce</a> , you must include at least <code>Id</code> , <code>ArticleNumber</code> , <code>VersionNumber</code> , <code>Title</code> , <code>PublishStatus</code> , and <code>IsDeleted</code> .</li>
         * <li>For <a href="https://docs.aws.amazon.com/https://developer.servicenow.com/dev.do#!/reference/api/rome/rest/knowledge-management-api">ServiceNow</a> , you must include at least <code>number</code> , <code>short_description</code> , <code>sys_mod_count</code> , <code>workflow_state</code> , and <code>active</code> .</li>
         * <li>For <a href="https://docs.aws.amazon.com/https://developer.zendesk.com/api-reference/help_center/help-center-api/articles/">Zendesk</a> , you must include at least <code>id</code> , <code>title</code> , <code>updated_at</code> , and <code>draft</code> .</li>
         * </ul>
         * <p>
         * Make sure to include additional fields. These fields are indexed and used to source recommendations.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-knowledgebase-appintegrationsconfiguration.html#cfn-wisdom-knowledgebase-appintegrationsconfiguration-objectfields">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-knowledgebase-appintegrationsconfiguration.html#cfn-wisdom-knowledgebase-appintegrationsconfiguration-objectfields</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getObjectFields() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AppIntegrationsConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AppIntegrationsConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AppIntegrationsConfigurationProperty> {
            java.lang.String appIntegrationArn;
            java.util.List<java.lang.String> objectFields;

            /**
             * Sets the value of {@link AppIntegrationsConfigurationProperty#getAppIntegrationArn}
             * @param appIntegrationArn The Amazon Resource Name (ARN) of the AppIntegrations DataIntegration to use for ingesting content. This parameter is required.
             *                          <ul>
             *                          <li>For <a href="https://docs.aws.amazon.com/https://developer.salesforce.com/docs/atlas.en-us.knowledge_dev.meta/knowledge_dev/sforce_api_objects_knowledge__kav.htm">Salesforce</a> , your AppIntegrations DataIntegration must have an ObjectConfiguration if objectFields is not provided, including at least <code>Id</code> , <code>ArticleNumber</code> , <code>VersionNumber</code> , <code>Title</code> , <code>PublishStatus</code> , and <code>IsDeleted</code> as source fields.</li>
             *                          <li>For <a href="https://docs.aws.amazon.com/https://developer.servicenow.com/dev.do#!/reference/api/rome/rest/knowledge-management-api">ServiceNow</a> , your AppIntegrations DataIntegration must have an ObjectConfiguration if objectFields is not provided, including at least <code>number</code> , <code>short_description</code> , <code>sys_mod_count</code> , <code>workflow_state</code> , and <code>active</code> as source fields.</li>
             *                          <li>For <a href="https://docs.aws.amazon.com/https://developer.zendesk.com/api-reference/help_center/help-center-api/articles/">Zendesk</a> , your AppIntegrations DataIntegration must have an ObjectConfiguration if <code>objectFields</code> is not provided, including at least <code>id</code> , <code>title</code> , <code>updated_at</code> , and <code>draft</code> as source fields.</li>
             *                          <li>For <a href="https://docs.aws.amazon.com/https://learn.microsoft.com/en-us/sharepoint/dev/sp-add-ins/sharepoint-net-server-csom-jsom-and-rest-api-index">SharePoint</a> , your AppIntegrations DataIntegration must have a FileConfiguration, including only file extensions that are among <code>docx</code> , <code>pdf</code> , <code>html</code> , <code>htm</code> , and <code>txt</code> .</li>
             *                          <li>For <a href="https://docs.aws.amazon.com/s3/">Amazon S3</a> , the ObjectConfiguration and FileConfiguration of your AppIntegrations DataIntegration must be null. The <code>SourceURI</code> of your DataIntegration must use the following format: <code>s3://your_s3_bucket_name</code> .</li>
             *                          </ul>
             *                          <p>
             *                          <blockquote>
             *                          <p>
             *                          The bucket policy of the corresponding S3 bucket must allow the AWS principal <code>app-integrations.amazonaws.com</code> to perform <code>s3:ListBucket</code> , <code>s3:GetObject</code> , and <code>s3:GetBucketLocation</code> against the bucket.
             *                          <p>
             *                          </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder appIntegrationArn(java.lang.String appIntegrationArn) {
                this.appIntegrationArn = appIntegrationArn;
                return this;
            }

            /**
             * Sets the value of {@link AppIntegrationsConfigurationProperty#getObjectFields}
             * @param objectFields The fields from the source that are made available to your agents in Amazon Q in Connect.
             *                     Optional if ObjectConfiguration is included in the provided DataIntegration.
             *                     <p>
             *                     <ul>
             *                     <li>For <a href="https://docs.aws.amazon.com/https://developer.salesforce.com/docs/atlas.en-us.knowledge_dev.meta/knowledge_dev/sforce_api_objects_knowledge__kav.htm">Salesforce</a> , you must include at least <code>Id</code> , <code>ArticleNumber</code> , <code>VersionNumber</code> , <code>Title</code> , <code>PublishStatus</code> , and <code>IsDeleted</code> .</li>
             *                     <li>For <a href="https://docs.aws.amazon.com/https://developer.servicenow.com/dev.do#!/reference/api/rome/rest/knowledge-management-api">ServiceNow</a> , you must include at least <code>number</code> , <code>short_description</code> , <code>sys_mod_count</code> , <code>workflow_state</code> , and <code>active</code> .</li>
             *                     <li>For <a href="https://docs.aws.amazon.com/https://developer.zendesk.com/api-reference/help_center/help-center-api/articles/">Zendesk</a> , you must include at least <code>id</code> , <code>title</code> , <code>updated_at</code> , and <code>draft</code> .</li>
             *                     </ul>
             *                     <p>
             *                     Make sure to include additional fields. These fields are indexed and used to source recommendations.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder objectFields(java.util.List<java.lang.String> objectFields) {
                this.objectFields = objectFields;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AppIntegrationsConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AppIntegrationsConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AppIntegrationsConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AppIntegrationsConfigurationProperty {
            private final java.lang.String appIntegrationArn;
            private final java.util.List<java.lang.String> objectFields;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.appIntegrationArn = software.amazon.jsii.Kernel.get(this, "appIntegrationArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.objectFields = software.amazon.jsii.Kernel.get(this, "objectFields", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.appIntegrationArn = java.util.Objects.requireNonNull(builder.appIntegrationArn, "appIntegrationArn is required");
                this.objectFields = builder.objectFields;
            }

            @Override
            public final java.lang.String getAppIntegrationArn() {
                return this.appIntegrationArn;
            }

            @Override
            public final java.util.List<java.lang.String> getObjectFields() {
                return this.objectFields;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("appIntegrationArn", om.valueToTree(this.getAppIntegrationArn()));
                if (this.getObjectFields() != null) {
                    data.set("objectFields", om.valueToTree(this.getObjectFields()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_wisdom.CfnKnowledgeBase.AppIntegrationsConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AppIntegrationsConfigurationProperty.Jsii$Proxy that = (AppIntegrationsConfigurationProperty.Jsii$Proxy) o;

                if (!appIntegrationArn.equals(that.appIntegrationArn)) return false;
                return this.objectFields != null ? this.objectFields.equals(that.objectFields) : that.objectFields == null;
            }

            @Override
            public final int hashCode() {
                int result = this.appIntegrationArn.hashCode();
                result = 31 * result + (this.objectFields != null ? this.objectFields.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The configuration of the Bedrock foundation model.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.wisdom.*;
     * BedrockFoundationModelConfigurationProperty bedrockFoundationModelConfigurationProperty = BedrockFoundationModelConfigurationProperty.builder()
     *         .modelArn("modelArn")
     *         // the properties below are optional
     *         .parsingPrompt(ParsingPromptProperty.builder()
     *                 .parsingPromptText("parsingPromptText")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-knowledgebase-bedrockfoundationmodelconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-knowledgebase-bedrockfoundationmodelconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_wisdom.CfnKnowledgeBase.BedrockFoundationModelConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(BedrockFoundationModelConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface BedrockFoundationModelConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The model ARN of the Bedrock foundation model.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-knowledgebase-bedrockfoundationmodelconfiguration.html#cfn-wisdom-knowledgebase-bedrockfoundationmodelconfiguration-modelarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-knowledgebase-bedrockfoundationmodelconfiguration.html#cfn-wisdom-knowledgebase-bedrockfoundationmodelconfiguration-modelarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getModelArn();

        /**
         * The parsing prompt of the Bedrock foundation model configuration.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-knowledgebase-bedrockfoundationmodelconfiguration.html#cfn-wisdom-knowledgebase-bedrockfoundationmodelconfiguration-parsingprompt">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-knowledgebase-bedrockfoundationmodelconfiguration.html#cfn-wisdom-knowledgebase-bedrockfoundationmodelconfiguration-parsingprompt</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getParsingPrompt() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link BedrockFoundationModelConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link BedrockFoundationModelConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<BedrockFoundationModelConfigurationProperty> {
            java.lang.String modelArn;
            java.lang.Object parsingPrompt;

            /**
             * Sets the value of {@link BedrockFoundationModelConfigurationProperty#getModelArn}
             * @param modelArn The model ARN of the Bedrock foundation model. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder modelArn(java.lang.String modelArn) {
                this.modelArn = modelArn;
                return this;
            }

            /**
             * Sets the value of {@link BedrockFoundationModelConfigurationProperty#getParsingPrompt}
             * @param parsingPrompt The parsing prompt of the Bedrock foundation model configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder parsingPrompt(software.amazon.awscdk.IResolvable parsingPrompt) {
                this.parsingPrompt = parsingPrompt;
                return this;
            }

            /**
             * Sets the value of {@link BedrockFoundationModelConfigurationProperty#getParsingPrompt}
             * @param parsingPrompt The parsing prompt of the Bedrock foundation model configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder parsingPrompt(software.amazon.awscdk.services.wisdom.CfnKnowledgeBase.ParsingPromptProperty parsingPrompt) {
                this.parsingPrompt = parsingPrompt;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link BedrockFoundationModelConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public BedrockFoundationModelConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link BedrockFoundationModelConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BedrockFoundationModelConfigurationProperty {
            private final java.lang.String modelArn;
            private final java.lang.Object parsingPrompt;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.modelArn = software.amazon.jsii.Kernel.get(this, "modelArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.parsingPrompt = software.amazon.jsii.Kernel.get(this, "parsingPrompt", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.modelArn = java.util.Objects.requireNonNull(builder.modelArn, "modelArn is required");
                this.parsingPrompt = builder.parsingPrompt;
            }

            @Override
            public final java.lang.String getModelArn() {
                return this.modelArn;
            }

            @Override
            public final java.lang.Object getParsingPrompt() {
                return this.parsingPrompt;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("modelArn", om.valueToTree(this.getModelArn()));
                if (this.getParsingPrompt() != null) {
                    data.set("parsingPrompt", om.valueToTree(this.getParsingPrompt()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_wisdom.CfnKnowledgeBase.BedrockFoundationModelConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                BedrockFoundationModelConfigurationProperty.Jsii$Proxy that = (BedrockFoundationModelConfigurationProperty.Jsii$Proxy) o;

                if (!modelArn.equals(that.modelArn)) return false;
                return this.parsingPrompt != null ? this.parsingPrompt.equals(that.parsingPrompt) : that.parsingPrompt == null;
            }

            @Override
            public final int hashCode() {
                int result = this.modelArn.hashCode();
                result = 31 * result + (this.parsingPrompt != null ? this.parsingPrompt.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Details about how to chunk the documents in the data source.
     * <p>
     * A chunk refers to an excerpt from a data source that is returned when the knowledge base that it belongs to is queried.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.wisdom.*;
     * ChunkingConfigurationProperty chunkingConfigurationProperty = ChunkingConfigurationProperty.builder()
     *         .chunkingStrategy("chunkingStrategy")
     *         // the properties below are optional
     *         .fixedSizeChunkingConfiguration(FixedSizeChunkingConfigurationProperty.builder()
     *                 .maxTokens(123)
     *                 .overlapPercentage(123)
     *                 .build())
     *         .hierarchicalChunkingConfiguration(HierarchicalChunkingConfigurationProperty.builder()
     *                 .levelConfigurations(List.of(HierarchicalChunkingLevelConfigurationProperty.builder()
     *                         .maxTokens(123)
     *                         .build()))
     *                 .overlapTokens(123)
     *                 .build())
     *         .semanticChunkingConfiguration(SemanticChunkingConfigurationProperty.builder()
     *                 .breakpointPercentileThreshold(123)
     *                 .bufferSize(123)
     *                 .maxTokens(123)
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-knowledgebase-chunkingconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-knowledgebase-chunkingconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_wisdom.CfnKnowledgeBase.ChunkingConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(ChunkingConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ChunkingConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Knowledge base can split your source data into chunks.
         * <p>
         * A chunk refers to an excerpt from a data source that is returned when the knowledge base that it belongs to is queried. You have the following options for chunking your data. If you opt for <code>NONE</code> , then you may want to pre-process your files by splitting them up such that each file corresponds to a chunk.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-knowledgebase-chunkingconfiguration.html#cfn-wisdom-knowledgebase-chunkingconfiguration-chunkingstrategy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-knowledgebase-chunkingconfiguration.html#cfn-wisdom-knowledgebase-chunkingconfiguration-chunkingstrategy</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getChunkingStrategy();

        /**
         * Configurations for when you choose fixed-size chunking.
         * <p>
         * If you set the <code>chunkingStrategy</code> as <code>NONE</code> , exclude this field.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-knowledgebase-chunkingconfiguration.html#cfn-wisdom-knowledgebase-chunkingconfiguration-fixedsizechunkingconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-knowledgebase-chunkingconfiguration.html#cfn-wisdom-knowledgebase-chunkingconfiguration-fixedsizechunkingconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getFixedSizeChunkingConfiguration() {
            return null;
        }

        /**
         * Settings for hierarchical document chunking for a data source.
         * <p>
         * Hierarchical chunking splits documents into layers of chunks where the first layer contains large chunks, and the second layer contains smaller chunks derived from the first layer.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-knowledgebase-chunkingconfiguration.html#cfn-wisdom-knowledgebase-chunkingconfiguration-hierarchicalchunkingconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-knowledgebase-chunkingconfiguration.html#cfn-wisdom-knowledgebase-chunkingconfiguration-hierarchicalchunkingconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getHierarchicalChunkingConfiguration() {
            return null;
        }

        /**
         * Settings for semantic document chunking for a data source.
         * <p>
         * Semantic chunking splits a document into smaller documents based on groups of similar content derived from the text with natural language processing.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-knowledgebase-chunkingconfiguration.html#cfn-wisdom-knowledgebase-chunkingconfiguration-semanticchunkingconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-knowledgebase-chunkingconfiguration.html#cfn-wisdom-knowledgebase-chunkingconfiguration-semanticchunkingconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSemanticChunkingConfiguration() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ChunkingConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ChunkingConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ChunkingConfigurationProperty> {
            java.lang.String chunkingStrategy;
            java.lang.Object fixedSizeChunkingConfiguration;
            java.lang.Object hierarchicalChunkingConfiguration;
            java.lang.Object semanticChunkingConfiguration;

            /**
             * Sets the value of {@link ChunkingConfigurationProperty#getChunkingStrategy}
             * @param chunkingStrategy Knowledge base can split your source data into chunks. This parameter is required.
             *                         A chunk refers to an excerpt from a data source that is returned when the knowledge base that it belongs to is queried. You have the following options for chunking your data. If you opt for <code>NONE</code> , then you may want to pre-process your files by splitting them up such that each file corresponds to a chunk.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder chunkingStrategy(java.lang.String chunkingStrategy) {
                this.chunkingStrategy = chunkingStrategy;
                return this;
            }

            /**
             * Sets the value of {@link ChunkingConfigurationProperty#getFixedSizeChunkingConfiguration}
             * @param fixedSizeChunkingConfiguration Configurations for when you choose fixed-size chunking.
             *                                       If you set the <code>chunkingStrategy</code> as <code>NONE</code> , exclude this field.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fixedSizeChunkingConfiguration(software.amazon.awscdk.IResolvable fixedSizeChunkingConfiguration) {
                this.fixedSizeChunkingConfiguration = fixedSizeChunkingConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link ChunkingConfigurationProperty#getFixedSizeChunkingConfiguration}
             * @param fixedSizeChunkingConfiguration Configurations for when you choose fixed-size chunking.
             *                                       If you set the <code>chunkingStrategy</code> as <code>NONE</code> , exclude this field.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fixedSizeChunkingConfiguration(software.amazon.awscdk.services.wisdom.CfnKnowledgeBase.FixedSizeChunkingConfigurationProperty fixedSizeChunkingConfiguration) {
                this.fixedSizeChunkingConfiguration = fixedSizeChunkingConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link ChunkingConfigurationProperty#getHierarchicalChunkingConfiguration}
             * @param hierarchicalChunkingConfiguration Settings for hierarchical document chunking for a data source.
             *                                          Hierarchical chunking splits documents into layers of chunks where the first layer contains large chunks, and the second layer contains smaller chunks derived from the first layer.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder hierarchicalChunkingConfiguration(software.amazon.awscdk.IResolvable hierarchicalChunkingConfiguration) {
                this.hierarchicalChunkingConfiguration = hierarchicalChunkingConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link ChunkingConfigurationProperty#getHierarchicalChunkingConfiguration}
             * @param hierarchicalChunkingConfiguration Settings for hierarchical document chunking for a data source.
             *                                          Hierarchical chunking splits documents into layers of chunks where the first layer contains large chunks, and the second layer contains smaller chunks derived from the first layer.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder hierarchicalChunkingConfiguration(software.amazon.awscdk.services.wisdom.CfnKnowledgeBase.HierarchicalChunkingConfigurationProperty hierarchicalChunkingConfiguration) {
                this.hierarchicalChunkingConfiguration = hierarchicalChunkingConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link ChunkingConfigurationProperty#getSemanticChunkingConfiguration}
             * @param semanticChunkingConfiguration Settings for semantic document chunking for a data source.
             *                                      Semantic chunking splits a document into smaller documents based on groups of similar content derived from the text with natural language processing.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder semanticChunkingConfiguration(software.amazon.awscdk.IResolvable semanticChunkingConfiguration) {
                this.semanticChunkingConfiguration = semanticChunkingConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link ChunkingConfigurationProperty#getSemanticChunkingConfiguration}
             * @param semanticChunkingConfiguration Settings for semantic document chunking for a data source.
             *                                      Semantic chunking splits a document into smaller documents based on groups of similar content derived from the text with natural language processing.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder semanticChunkingConfiguration(software.amazon.awscdk.services.wisdom.CfnKnowledgeBase.SemanticChunkingConfigurationProperty semanticChunkingConfiguration) {
                this.semanticChunkingConfiguration = semanticChunkingConfiguration;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ChunkingConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ChunkingConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ChunkingConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ChunkingConfigurationProperty {
            private final java.lang.String chunkingStrategy;
            private final java.lang.Object fixedSizeChunkingConfiguration;
            private final java.lang.Object hierarchicalChunkingConfiguration;
            private final java.lang.Object semanticChunkingConfiguration;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.chunkingStrategy = software.amazon.jsii.Kernel.get(this, "chunkingStrategy", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.fixedSizeChunkingConfiguration = software.amazon.jsii.Kernel.get(this, "fixedSizeChunkingConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.hierarchicalChunkingConfiguration = software.amazon.jsii.Kernel.get(this, "hierarchicalChunkingConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.semanticChunkingConfiguration = software.amazon.jsii.Kernel.get(this, "semanticChunkingConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.chunkingStrategy = java.util.Objects.requireNonNull(builder.chunkingStrategy, "chunkingStrategy is required");
                this.fixedSizeChunkingConfiguration = builder.fixedSizeChunkingConfiguration;
                this.hierarchicalChunkingConfiguration = builder.hierarchicalChunkingConfiguration;
                this.semanticChunkingConfiguration = builder.semanticChunkingConfiguration;
            }

            @Override
            public final java.lang.String getChunkingStrategy() {
                return this.chunkingStrategy;
            }

            @Override
            public final java.lang.Object getFixedSizeChunkingConfiguration() {
                return this.fixedSizeChunkingConfiguration;
            }

            @Override
            public final java.lang.Object getHierarchicalChunkingConfiguration() {
                return this.hierarchicalChunkingConfiguration;
            }

            @Override
            public final java.lang.Object getSemanticChunkingConfiguration() {
                return this.semanticChunkingConfiguration;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("chunkingStrategy", om.valueToTree(this.getChunkingStrategy()));
                if (this.getFixedSizeChunkingConfiguration() != null) {
                    data.set("fixedSizeChunkingConfiguration", om.valueToTree(this.getFixedSizeChunkingConfiguration()));
                }
                if (this.getHierarchicalChunkingConfiguration() != null) {
                    data.set("hierarchicalChunkingConfiguration", om.valueToTree(this.getHierarchicalChunkingConfiguration()));
                }
                if (this.getSemanticChunkingConfiguration() != null) {
                    data.set("semanticChunkingConfiguration", om.valueToTree(this.getSemanticChunkingConfiguration()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_wisdom.CfnKnowledgeBase.ChunkingConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ChunkingConfigurationProperty.Jsii$Proxy that = (ChunkingConfigurationProperty.Jsii$Proxy) o;

                if (!chunkingStrategy.equals(that.chunkingStrategy)) return false;
                if (this.fixedSizeChunkingConfiguration != null ? !this.fixedSizeChunkingConfiguration.equals(that.fixedSizeChunkingConfiguration) : that.fixedSizeChunkingConfiguration != null) return false;
                if (this.hierarchicalChunkingConfiguration != null ? !this.hierarchicalChunkingConfiguration.equals(that.hierarchicalChunkingConfiguration) : that.hierarchicalChunkingConfiguration != null) return false;
                return this.semanticChunkingConfiguration != null ? this.semanticChunkingConfiguration.equals(that.semanticChunkingConfiguration) : that.semanticChunkingConfiguration == null;
            }

            @Override
            public final int hashCode() {
                int result = this.chunkingStrategy.hashCode();
                result = 31 * result + (this.fixedSizeChunkingConfiguration != null ? this.fixedSizeChunkingConfiguration.hashCode() : 0);
                result = 31 * result + (this.hierarchicalChunkingConfiguration != null ? this.hierarchicalChunkingConfiguration.hashCode() : 0);
                result = 31 * result + (this.semanticChunkingConfiguration != null ? this.semanticChunkingConfiguration.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The limits of the crawler.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.wisdom.*;
     * CrawlerLimitsProperty crawlerLimitsProperty = CrawlerLimitsProperty.builder()
     *         .rateLimit(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-knowledgebase-crawlerlimits.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-knowledgebase-crawlerlimits.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_wisdom.CfnKnowledgeBase.CrawlerLimitsProperty")
    @software.amazon.jsii.Jsii.Proxy(CrawlerLimitsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CrawlerLimitsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The limit rate at which the crawler is configured.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-knowledgebase-crawlerlimits.html#cfn-wisdom-knowledgebase-crawlerlimits-ratelimit">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-knowledgebase-crawlerlimits.html#cfn-wisdom-knowledgebase-crawlerlimits-ratelimit</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getRateLimit() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CrawlerLimitsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CrawlerLimitsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CrawlerLimitsProperty> {
            java.lang.Number rateLimit;

            /**
             * Sets the value of {@link CrawlerLimitsProperty#getRateLimit}
             * @param rateLimit The limit rate at which the crawler is configured.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rateLimit(java.lang.Number rateLimit) {
                this.rateLimit = rateLimit;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CrawlerLimitsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CrawlerLimitsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CrawlerLimitsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CrawlerLimitsProperty {
            private final java.lang.Number rateLimit;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.rateLimit = software.amazon.jsii.Kernel.get(this, "rateLimit", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.rateLimit = builder.rateLimit;
            }

            @Override
            public final java.lang.Number getRateLimit() {
                return this.rateLimit;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getRateLimit() != null) {
                    data.set("rateLimit", om.valueToTree(this.getRateLimit()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_wisdom.CfnKnowledgeBase.CrawlerLimitsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CrawlerLimitsProperty.Jsii$Proxy that = (CrawlerLimitsProperty.Jsii$Proxy) o;

                return this.rateLimit != null ? this.rateLimit.equals(that.rateLimit) : that.rateLimit == null;
            }

            @Override
            public final int hashCode() {
                int result = this.rateLimit != null ? this.rateLimit.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Configurations for when you choose fixed-size chunking.
     * <p>
     * If you set the <code>chunkingStrategy</code> as <code>NONE</code> , exclude this field.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.wisdom.*;
     * FixedSizeChunkingConfigurationProperty fixedSizeChunkingConfigurationProperty = FixedSizeChunkingConfigurationProperty.builder()
     *         .maxTokens(123)
     *         .overlapPercentage(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-knowledgebase-fixedsizechunkingconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-knowledgebase-fixedsizechunkingconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_wisdom.CfnKnowledgeBase.FixedSizeChunkingConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(FixedSizeChunkingConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface FixedSizeChunkingConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The maximum number of tokens to include in a chunk.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-knowledgebase-fixedsizechunkingconfiguration.html#cfn-wisdom-knowledgebase-fixedsizechunkingconfiguration-maxtokens">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-knowledgebase-fixedsizechunkingconfiguration.html#cfn-wisdom-knowledgebase-fixedsizechunkingconfiguration-maxtokens</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getMaxTokens();

        /**
         * The percentage of overlap between adjacent chunks of a data source.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-knowledgebase-fixedsizechunkingconfiguration.html#cfn-wisdom-knowledgebase-fixedsizechunkingconfiguration-overlappercentage">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-knowledgebase-fixedsizechunkingconfiguration.html#cfn-wisdom-knowledgebase-fixedsizechunkingconfiguration-overlappercentage</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getOverlapPercentage();

        /**
         * @return a {@link Builder} of {@link FixedSizeChunkingConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link FixedSizeChunkingConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<FixedSizeChunkingConfigurationProperty> {
            java.lang.Number maxTokens;
            java.lang.Number overlapPercentage;

            /**
             * Sets the value of {@link FixedSizeChunkingConfigurationProperty#getMaxTokens}
             * @param maxTokens The maximum number of tokens to include in a chunk. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maxTokens(java.lang.Number maxTokens) {
                this.maxTokens = maxTokens;
                return this;
            }

            /**
             * Sets the value of {@link FixedSizeChunkingConfigurationProperty#getOverlapPercentage}
             * @param overlapPercentage The percentage of overlap between adjacent chunks of a data source. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder overlapPercentage(java.lang.Number overlapPercentage) {
                this.overlapPercentage = overlapPercentage;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link FixedSizeChunkingConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public FixedSizeChunkingConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link FixedSizeChunkingConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FixedSizeChunkingConfigurationProperty {
            private final java.lang.Number maxTokens;
            private final java.lang.Number overlapPercentage;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.maxTokens = software.amazon.jsii.Kernel.get(this, "maxTokens", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.overlapPercentage = software.amazon.jsii.Kernel.get(this, "overlapPercentage", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.maxTokens = java.util.Objects.requireNonNull(builder.maxTokens, "maxTokens is required");
                this.overlapPercentage = java.util.Objects.requireNonNull(builder.overlapPercentage, "overlapPercentage is required");
            }

            @Override
            public final java.lang.Number getMaxTokens() {
                return this.maxTokens;
            }

            @Override
            public final java.lang.Number getOverlapPercentage() {
                return this.overlapPercentage;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("maxTokens", om.valueToTree(this.getMaxTokens()));
                data.set("overlapPercentage", om.valueToTree(this.getOverlapPercentage()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_wisdom.CfnKnowledgeBase.FixedSizeChunkingConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                FixedSizeChunkingConfigurationProperty.Jsii$Proxy that = (FixedSizeChunkingConfigurationProperty.Jsii$Proxy) o;

                if (!maxTokens.equals(that.maxTokens)) return false;
                return this.overlapPercentage.equals(that.overlapPercentage);
            }

            @Override
            public final int hashCode() {
                int result = this.maxTokens.hashCode();
                result = 31 * result + (this.overlapPercentage.hashCode());
                return result;
            }
        }
    }
    /**
     * Settings for hierarchical document chunking for a data source.
     * <p>
     * Hierarchical chunking splits documents into layers of chunks where the first layer contains large chunks, and the second layer contains smaller chunks derived from the first layer.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.wisdom.*;
     * HierarchicalChunkingConfigurationProperty hierarchicalChunkingConfigurationProperty = HierarchicalChunkingConfigurationProperty.builder()
     *         .levelConfigurations(List.of(HierarchicalChunkingLevelConfigurationProperty.builder()
     *                 .maxTokens(123)
     *                 .build()))
     *         .overlapTokens(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-knowledgebase-hierarchicalchunkingconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-knowledgebase-hierarchicalchunkingconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_wisdom.CfnKnowledgeBase.HierarchicalChunkingConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(HierarchicalChunkingConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface HierarchicalChunkingConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Token settings for each layer.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-knowledgebase-hierarchicalchunkingconfiguration.html#cfn-wisdom-knowledgebase-hierarchicalchunkingconfiguration-levelconfigurations">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-knowledgebase-hierarchicalchunkingconfiguration.html#cfn-wisdom-knowledgebase-hierarchicalchunkingconfiguration-levelconfigurations</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getLevelConfigurations();

        /**
         * The number of tokens to repeat across chunks in the same layer.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-knowledgebase-hierarchicalchunkingconfiguration.html#cfn-wisdom-knowledgebase-hierarchicalchunkingconfiguration-overlaptokens">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-knowledgebase-hierarchicalchunkingconfiguration.html#cfn-wisdom-knowledgebase-hierarchicalchunkingconfiguration-overlaptokens</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getOverlapTokens();

        /**
         * @return a {@link Builder} of {@link HierarchicalChunkingConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link HierarchicalChunkingConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<HierarchicalChunkingConfigurationProperty> {
            java.lang.Object levelConfigurations;
            java.lang.Number overlapTokens;

            /**
             * Sets the value of {@link HierarchicalChunkingConfigurationProperty#getLevelConfigurations}
             * @param levelConfigurations Token settings for each layer. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder levelConfigurations(software.amazon.awscdk.IResolvable levelConfigurations) {
                this.levelConfigurations = levelConfigurations;
                return this;
            }

            /**
             * Sets the value of {@link HierarchicalChunkingConfigurationProperty#getLevelConfigurations}
             * @param levelConfigurations Token settings for each layer. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder levelConfigurations(java.util.List<? extends java.lang.Object> levelConfigurations) {
                this.levelConfigurations = levelConfigurations;
                return this;
            }

            /**
             * Sets the value of {@link HierarchicalChunkingConfigurationProperty#getOverlapTokens}
             * @param overlapTokens The number of tokens to repeat across chunks in the same layer. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder overlapTokens(java.lang.Number overlapTokens) {
                this.overlapTokens = overlapTokens;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link HierarchicalChunkingConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public HierarchicalChunkingConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link HierarchicalChunkingConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements HierarchicalChunkingConfigurationProperty {
            private final java.lang.Object levelConfigurations;
            private final java.lang.Number overlapTokens;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.levelConfigurations = software.amazon.jsii.Kernel.get(this, "levelConfigurations", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.overlapTokens = software.amazon.jsii.Kernel.get(this, "overlapTokens", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.levelConfigurations = java.util.Objects.requireNonNull(builder.levelConfigurations, "levelConfigurations is required");
                this.overlapTokens = java.util.Objects.requireNonNull(builder.overlapTokens, "overlapTokens is required");
            }

            @Override
            public final java.lang.Object getLevelConfigurations() {
                return this.levelConfigurations;
            }

            @Override
            public final java.lang.Number getOverlapTokens() {
                return this.overlapTokens;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("levelConfigurations", om.valueToTree(this.getLevelConfigurations()));
                data.set("overlapTokens", om.valueToTree(this.getOverlapTokens()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_wisdom.CfnKnowledgeBase.HierarchicalChunkingConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                HierarchicalChunkingConfigurationProperty.Jsii$Proxy that = (HierarchicalChunkingConfigurationProperty.Jsii$Proxy) o;

                if (!levelConfigurations.equals(that.levelConfigurations)) return false;
                return this.overlapTokens.equals(that.overlapTokens);
            }

            @Override
            public final int hashCode() {
                int result = this.levelConfigurations.hashCode();
                result = 31 * result + (this.overlapTokens.hashCode());
                return result;
            }
        }
    }
    /**
     * Token settings for each layer.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.wisdom.*;
     * HierarchicalChunkingLevelConfigurationProperty hierarchicalChunkingLevelConfigurationProperty = HierarchicalChunkingLevelConfigurationProperty.builder()
     *         .maxTokens(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-knowledgebase-hierarchicalchunkinglevelconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-knowledgebase-hierarchicalchunkinglevelconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_wisdom.CfnKnowledgeBase.HierarchicalChunkingLevelConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(HierarchicalChunkingLevelConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface HierarchicalChunkingLevelConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The maximum number of tokens that a chunk can contain in this layer.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-knowledgebase-hierarchicalchunkinglevelconfiguration.html#cfn-wisdom-knowledgebase-hierarchicalchunkinglevelconfiguration-maxtokens">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-knowledgebase-hierarchicalchunkinglevelconfiguration.html#cfn-wisdom-knowledgebase-hierarchicalchunkinglevelconfiguration-maxtokens</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getMaxTokens();

        /**
         * @return a {@link Builder} of {@link HierarchicalChunkingLevelConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link HierarchicalChunkingLevelConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<HierarchicalChunkingLevelConfigurationProperty> {
            java.lang.Number maxTokens;

            /**
             * Sets the value of {@link HierarchicalChunkingLevelConfigurationProperty#getMaxTokens}
             * @param maxTokens The maximum number of tokens that a chunk can contain in this layer. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maxTokens(java.lang.Number maxTokens) {
                this.maxTokens = maxTokens;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link HierarchicalChunkingLevelConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public HierarchicalChunkingLevelConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link HierarchicalChunkingLevelConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements HierarchicalChunkingLevelConfigurationProperty {
            private final java.lang.Number maxTokens;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.maxTokens = software.amazon.jsii.Kernel.get(this, "maxTokens", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.maxTokens = java.util.Objects.requireNonNull(builder.maxTokens, "maxTokens is required");
            }

            @Override
            public final java.lang.Number getMaxTokens() {
                return this.maxTokens;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("maxTokens", om.valueToTree(this.getMaxTokens()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_wisdom.CfnKnowledgeBase.HierarchicalChunkingLevelConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                HierarchicalChunkingLevelConfigurationProperty.Jsii$Proxy that = (HierarchicalChunkingLevelConfigurationProperty.Jsii$Proxy) o;

                return this.maxTokens.equals(that.maxTokens);
            }

            @Override
            public final int hashCode() {
                int result = this.maxTokens.hashCode();
                return result;
            }
        }
    }
    /**
     * Source configuration for managed resources.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.wisdom.*;
     * ManagedSourceConfigurationProperty managedSourceConfigurationProperty = ManagedSourceConfigurationProperty.builder()
     *         .webCrawlerConfiguration(WebCrawlerConfigurationProperty.builder()
     *                 .urlConfiguration(UrlConfigurationProperty.builder()
     *                         .seedUrls(List.of(SeedUrlProperty.builder()
     *                                 .url("url")
     *                                 .build()))
     *                         .build())
     *                 // the properties below are optional
     *                 .crawlerLimits(CrawlerLimitsProperty.builder()
     *                         .rateLimit(123)
     *                         .build())
     *                 .exclusionFilters(List.of("exclusionFilters"))
     *                 .inclusionFilters(List.of("inclusionFilters"))
     *                 .scope("scope")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-knowledgebase-managedsourceconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-knowledgebase-managedsourceconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_wisdom.CfnKnowledgeBase.ManagedSourceConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(ManagedSourceConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ManagedSourceConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Configuration data for web crawler data source.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-knowledgebase-managedsourceconfiguration.html#cfn-wisdom-knowledgebase-managedsourceconfiguration-webcrawlerconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-knowledgebase-managedsourceconfiguration.html#cfn-wisdom-knowledgebase-managedsourceconfiguration-webcrawlerconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getWebCrawlerConfiguration();

        /**
         * @return a {@link Builder} of {@link ManagedSourceConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ManagedSourceConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ManagedSourceConfigurationProperty> {
            java.lang.Object webCrawlerConfiguration;

            /**
             * Sets the value of {@link ManagedSourceConfigurationProperty#getWebCrawlerConfiguration}
             * @param webCrawlerConfiguration Configuration data for web crawler data source. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder webCrawlerConfiguration(software.amazon.awscdk.IResolvable webCrawlerConfiguration) {
                this.webCrawlerConfiguration = webCrawlerConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link ManagedSourceConfigurationProperty#getWebCrawlerConfiguration}
             * @param webCrawlerConfiguration Configuration data for web crawler data source. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder webCrawlerConfiguration(software.amazon.awscdk.services.wisdom.CfnKnowledgeBase.WebCrawlerConfigurationProperty webCrawlerConfiguration) {
                this.webCrawlerConfiguration = webCrawlerConfiguration;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ManagedSourceConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ManagedSourceConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ManagedSourceConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ManagedSourceConfigurationProperty {
            private final java.lang.Object webCrawlerConfiguration;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.webCrawlerConfiguration = software.amazon.jsii.Kernel.get(this, "webCrawlerConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.webCrawlerConfiguration = java.util.Objects.requireNonNull(builder.webCrawlerConfiguration, "webCrawlerConfiguration is required");
            }

            @Override
            public final java.lang.Object getWebCrawlerConfiguration() {
                return this.webCrawlerConfiguration;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("webCrawlerConfiguration", om.valueToTree(this.getWebCrawlerConfiguration()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_wisdom.CfnKnowledgeBase.ManagedSourceConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ManagedSourceConfigurationProperty.Jsii$Proxy that = (ManagedSourceConfigurationProperty.Jsii$Proxy) o;

                return this.webCrawlerConfiguration.equals(that.webCrawlerConfiguration);
            }

            @Override
            public final int hashCode() {
                int result = this.webCrawlerConfiguration.hashCode();
                return result;
            }
        }
    }
    /**
     * Settings for parsing document contents.
     * <p>
     * By default, the service converts the contents of each document into text before splitting it into chunks. To improve processing of PDF files with tables and images, you can configure the data source to convert the pages of text into images and use a model to describe the contents of each page.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.wisdom.*;
     * ParsingConfigurationProperty parsingConfigurationProperty = ParsingConfigurationProperty.builder()
     *         .parsingStrategy("parsingStrategy")
     *         // the properties below are optional
     *         .bedrockFoundationModelConfiguration(BedrockFoundationModelConfigurationProperty.builder()
     *                 .modelArn("modelArn")
     *                 // the properties below are optional
     *                 .parsingPrompt(ParsingPromptProperty.builder()
     *                         .parsingPromptText("parsingPromptText")
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-knowledgebase-parsingconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-knowledgebase-parsingconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_wisdom.CfnKnowledgeBase.ParsingConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(ParsingConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ParsingConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The parsing strategy for the data source.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-knowledgebase-parsingconfiguration.html#cfn-wisdom-knowledgebase-parsingconfiguration-parsingstrategy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-knowledgebase-parsingconfiguration.html#cfn-wisdom-knowledgebase-parsingconfiguration-parsingstrategy</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getParsingStrategy();

        /**
         * Settings for a foundation model used to parse documents for a data source.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-knowledgebase-parsingconfiguration.html#cfn-wisdom-knowledgebase-parsingconfiguration-bedrockfoundationmodelconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-knowledgebase-parsingconfiguration.html#cfn-wisdom-knowledgebase-parsingconfiguration-bedrockfoundationmodelconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getBedrockFoundationModelConfiguration() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ParsingConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ParsingConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ParsingConfigurationProperty> {
            java.lang.String parsingStrategy;
            java.lang.Object bedrockFoundationModelConfiguration;

            /**
             * Sets the value of {@link ParsingConfigurationProperty#getParsingStrategy}
             * @param parsingStrategy The parsing strategy for the data source. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder parsingStrategy(java.lang.String parsingStrategy) {
                this.parsingStrategy = parsingStrategy;
                return this;
            }

            /**
             * Sets the value of {@link ParsingConfigurationProperty#getBedrockFoundationModelConfiguration}
             * @param bedrockFoundationModelConfiguration Settings for a foundation model used to parse documents for a data source.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bedrockFoundationModelConfiguration(software.amazon.awscdk.IResolvable bedrockFoundationModelConfiguration) {
                this.bedrockFoundationModelConfiguration = bedrockFoundationModelConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link ParsingConfigurationProperty#getBedrockFoundationModelConfiguration}
             * @param bedrockFoundationModelConfiguration Settings for a foundation model used to parse documents for a data source.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bedrockFoundationModelConfiguration(software.amazon.awscdk.services.wisdom.CfnKnowledgeBase.BedrockFoundationModelConfigurationProperty bedrockFoundationModelConfiguration) {
                this.bedrockFoundationModelConfiguration = bedrockFoundationModelConfiguration;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ParsingConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ParsingConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ParsingConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ParsingConfigurationProperty {
            private final java.lang.String parsingStrategy;
            private final java.lang.Object bedrockFoundationModelConfiguration;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.parsingStrategy = software.amazon.jsii.Kernel.get(this, "parsingStrategy", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.bedrockFoundationModelConfiguration = software.amazon.jsii.Kernel.get(this, "bedrockFoundationModelConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.parsingStrategy = java.util.Objects.requireNonNull(builder.parsingStrategy, "parsingStrategy is required");
                this.bedrockFoundationModelConfiguration = builder.bedrockFoundationModelConfiguration;
            }

            @Override
            public final java.lang.String getParsingStrategy() {
                return this.parsingStrategy;
            }

            @Override
            public final java.lang.Object getBedrockFoundationModelConfiguration() {
                return this.bedrockFoundationModelConfiguration;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("parsingStrategy", om.valueToTree(this.getParsingStrategy()));
                if (this.getBedrockFoundationModelConfiguration() != null) {
                    data.set("bedrockFoundationModelConfiguration", om.valueToTree(this.getBedrockFoundationModelConfiguration()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_wisdom.CfnKnowledgeBase.ParsingConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ParsingConfigurationProperty.Jsii$Proxy that = (ParsingConfigurationProperty.Jsii$Proxy) o;

                if (!parsingStrategy.equals(that.parsingStrategy)) return false;
                return this.bedrockFoundationModelConfiguration != null ? this.bedrockFoundationModelConfiguration.equals(that.bedrockFoundationModelConfiguration) : that.bedrockFoundationModelConfiguration == null;
            }

            @Override
            public final int hashCode() {
                int result = this.parsingStrategy.hashCode();
                result = 31 * result + (this.bedrockFoundationModelConfiguration != null ? this.bedrockFoundationModelConfiguration.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Instructions for interpreting the contents of a document.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.wisdom.*;
     * ParsingPromptProperty parsingPromptProperty = ParsingPromptProperty.builder()
     *         .parsingPromptText("parsingPromptText")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-knowledgebase-parsingprompt.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-knowledgebase-parsingprompt.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_wisdom.CfnKnowledgeBase.ParsingPromptProperty")
    @software.amazon.jsii.Jsii.Proxy(ParsingPromptProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ParsingPromptProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Instructions for interpreting the contents of a document.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-knowledgebase-parsingprompt.html#cfn-wisdom-knowledgebase-parsingprompt-parsingprompttext">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-knowledgebase-parsingprompt.html#cfn-wisdom-knowledgebase-parsingprompt-parsingprompttext</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getParsingPromptText();

        /**
         * @return a {@link Builder} of {@link ParsingPromptProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ParsingPromptProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ParsingPromptProperty> {
            java.lang.String parsingPromptText;

            /**
             * Sets the value of {@link ParsingPromptProperty#getParsingPromptText}
             * @param parsingPromptText Instructions for interpreting the contents of a document. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder parsingPromptText(java.lang.String parsingPromptText) {
                this.parsingPromptText = parsingPromptText;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ParsingPromptProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ParsingPromptProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ParsingPromptProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ParsingPromptProperty {
            private final java.lang.String parsingPromptText;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.parsingPromptText = software.amazon.jsii.Kernel.get(this, "parsingPromptText", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.parsingPromptText = java.util.Objects.requireNonNull(builder.parsingPromptText, "parsingPromptText is required");
            }

            @Override
            public final java.lang.String getParsingPromptText() {
                return this.parsingPromptText;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("parsingPromptText", om.valueToTree(this.getParsingPromptText()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_wisdom.CfnKnowledgeBase.ParsingPromptProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ParsingPromptProperty.Jsii$Proxy that = (ParsingPromptProperty.Jsii$Proxy) o;

                return this.parsingPromptText.equals(that.parsingPromptText);
            }

            @Override
            public final int hashCode() {
                int result = this.parsingPromptText.hashCode();
                return result;
            }
        }
    }
    /**
     * Information about how to render the content.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.wisdom.*;
     * RenderingConfigurationProperty renderingConfigurationProperty = RenderingConfigurationProperty.builder()
     *         .templateUri("templateUri")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-knowledgebase-renderingconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-knowledgebase-renderingconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_wisdom.CfnKnowledgeBase.RenderingConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(RenderingConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RenderingConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A URI template containing exactly one variable in <code>${variableName}</code> format.
         * <p>
         * This can only be set for <code>EXTERNAL</code> knowledge bases. For Salesforce, ServiceNow, and Zendesk, the variable must be one of the following:
         * <p>
         * <ul>
         * <li>Salesforce: <code>Id</code> , <code>ArticleNumber</code> , <code>VersionNumber</code> , <code>Title</code> , <code>PublishStatus</code> , or <code>IsDeleted</code></li>
         * <li>ServiceNow: <code>number</code> , <code>short_description</code> , <code>sys_mod_count</code> , <code>workflow_state</code> , or <code>active</code></li>
         * <li>Zendesk: <code>id</code> , <code>title</code> , <code>updated_at</code> , or <code>draft</code></li>
         * </ul>
         * <p>
         * The variable is replaced with the actual value for a piece of content when calling <a href="https://docs.aws.amazon.com/amazon-q-connect/latest/APIReference/API_GetContent.html">GetContent</a> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-knowledgebase-renderingconfiguration.html#cfn-wisdom-knowledgebase-renderingconfiguration-templateuri">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-knowledgebase-renderingconfiguration.html#cfn-wisdom-knowledgebase-renderingconfiguration-templateuri</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTemplateUri() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link RenderingConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RenderingConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RenderingConfigurationProperty> {
            java.lang.String templateUri;

            /**
             * Sets the value of {@link RenderingConfigurationProperty#getTemplateUri}
             * @param templateUri A URI template containing exactly one variable in <code>${variableName}</code> format.
             *                    This can only be set for <code>EXTERNAL</code> knowledge bases. For Salesforce, ServiceNow, and Zendesk, the variable must be one of the following:
             *                    <p>
             *                    <ul>
             *                    <li>Salesforce: <code>Id</code> , <code>ArticleNumber</code> , <code>VersionNumber</code> , <code>Title</code> , <code>PublishStatus</code> , or <code>IsDeleted</code></li>
             *                    <li>ServiceNow: <code>number</code> , <code>short_description</code> , <code>sys_mod_count</code> , <code>workflow_state</code> , or <code>active</code></li>
             *                    <li>Zendesk: <code>id</code> , <code>title</code> , <code>updated_at</code> , or <code>draft</code></li>
             *                    </ul>
             *                    <p>
             *                    The variable is replaced with the actual value for a piece of content when calling <a href="https://docs.aws.amazon.com/amazon-q-connect/latest/APIReference/API_GetContent.html">GetContent</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder templateUri(java.lang.String templateUri) {
                this.templateUri = templateUri;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RenderingConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RenderingConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RenderingConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RenderingConfigurationProperty {
            private final java.lang.String templateUri;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.templateUri = software.amazon.jsii.Kernel.get(this, "templateUri", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.templateUri = builder.templateUri;
            }

            @Override
            public final java.lang.String getTemplateUri() {
                return this.templateUri;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getTemplateUri() != null) {
                    data.set("templateUri", om.valueToTree(this.getTemplateUri()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_wisdom.CfnKnowledgeBase.RenderingConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RenderingConfigurationProperty.Jsii$Proxy that = (RenderingConfigurationProperty.Jsii$Proxy) o;

                return this.templateUri != null ? this.templateUri.equals(that.templateUri) : that.templateUri == null;
            }

            @Override
            public final int hashCode() {
                int result = this.templateUri != null ? this.templateUri.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * A URL for crawling.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.wisdom.*;
     * SeedUrlProperty seedUrlProperty = SeedUrlProperty.builder()
     *         .url("url")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-knowledgebase-seedurl.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-knowledgebase-seedurl.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_wisdom.CfnKnowledgeBase.SeedUrlProperty")
    @software.amazon.jsii.Jsii.Proxy(SeedUrlProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SeedUrlProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * URL for crawling.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-knowledgebase-seedurl.html#cfn-wisdom-knowledgebase-seedurl-url">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-knowledgebase-seedurl.html#cfn-wisdom-knowledgebase-seedurl-url</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getUrl() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SeedUrlProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SeedUrlProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SeedUrlProperty> {
            java.lang.String url;

            /**
             * Sets the value of {@link SeedUrlProperty#getUrl}
             * @param url URL for crawling.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder url(java.lang.String url) {
                this.url = url;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SeedUrlProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SeedUrlProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SeedUrlProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SeedUrlProperty {
            private final java.lang.String url;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.url = software.amazon.jsii.Kernel.get(this, "url", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.url = builder.url;
            }

            @Override
            public final java.lang.String getUrl() {
                return this.url;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getUrl() != null) {
                    data.set("url", om.valueToTree(this.getUrl()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_wisdom.CfnKnowledgeBase.SeedUrlProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SeedUrlProperty.Jsii$Proxy that = (SeedUrlProperty.Jsii$Proxy) o;

                return this.url != null ? this.url.equals(that.url) : that.url == null;
            }

            @Override
            public final int hashCode() {
                int result = this.url != null ? this.url.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Settings for semantic document chunking for a data source.
     * <p>
     * Semantic chunking splits a document into smaller documents based on groups of similar content derived from the text with natural language processing.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.wisdom.*;
     * SemanticChunkingConfigurationProperty semanticChunkingConfigurationProperty = SemanticChunkingConfigurationProperty.builder()
     *         .breakpointPercentileThreshold(123)
     *         .bufferSize(123)
     *         .maxTokens(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-knowledgebase-semanticchunkingconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-knowledgebase-semanticchunkingconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_wisdom.CfnKnowledgeBase.SemanticChunkingConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(SemanticChunkingConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SemanticChunkingConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The dissimilarity threshold for splitting chunks.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-knowledgebase-semanticchunkingconfiguration.html#cfn-wisdom-knowledgebase-semanticchunkingconfiguration-breakpointpercentilethreshold">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-knowledgebase-semanticchunkingconfiguration.html#cfn-wisdom-knowledgebase-semanticchunkingconfiguration-breakpointpercentilethreshold</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getBreakpointPercentileThreshold();

        /**
         * The buffer size.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-knowledgebase-semanticchunkingconfiguration.html#cfn-wisdom-knowledgebase-semanticchunkingconfiguration-buffersize">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-knowledgebase-semanticchunkingconfiguration.html#cfn-wisdom-knowledgebase-semanticchunkingconfiguration-buffersize</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getBufferSize();

        /**
         * The maximum number of tokens that a chunk can contain.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-knowledgebase-semanticchunkingconfiguration.html#cfn-wisdom-knowledgebase-semanticchunkingconfiguration-maxtokens">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-knowledgebase-semanticchunkingconfiguration.html#cfn-wisdom-knowledgebase-semanticchunkingconfiguration-maxtokens</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getMaxTokens();

        /**
         * @return a {@link Builder} of {@link SemanticChunkingConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SemanticChunkingConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SemanticChunkingConfigurationProperty> {
            java.lang.Number breakpointPercentileThreshold;
            java.lang.Number bufferSize;
            java.lang.Number maxTokens;

            /**
             * Sets the value of {@link SemanticChunkingConfigurationProperty#getBreakpointPercentileThreshold}
             * @param breakpointPercentileThreshold The dissimilarity threshold for splitting chunks. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder breakpointPercentileThreshold(java.lang.Number breakpointPercentileThreshold) {
                this.breakpointPercentileThreshold = breakpointPercentileThreshold;
                return this;
            }

            /**
             * Sets the value of {@link SemanticChunkingConfigurationProperty#getBufferSize}
             * @param bufferSize The buffer size. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bufferSize(java.lang.Number bufferSize) {
                this.bufferSize = bufferSize;
                return this;
            }

            /**
             * Sets the value of {@link SemanticChunkingConfigurationProperty#getMaxTokens}
             * @param maxTokens The maximum number of tokens that a chunk can contain. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maxTokens(java.lang.Number maxTokens) {
                this.maxTokens = maxTokens;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SemanticChunkingConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SemanticChunkingConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SemanticChunkingConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SemanticChunkingConfigurationProperty {
            private final java.lang.Number breakpointPercentileThreshold;
            private final java.lang.Number bufferSize;
            private final java.lang.Number maxTokens;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.breakpointPercentileThreshold = software.amazon.jsii.Kernel.get(this, "breakpointPercentileThreshold", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.bufferSize = software.amazon.jsii.Kernel.get(this, "bufferSize", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.maxTokens = software.amazon.jsii.Kernel.get(this, "maxTokens", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.breakpointPercentileThreshold = java.util.Objects.requireNonNull(builder.breakpointPercentileThreshold, "breakpointPercentileThreshold is required");
                this.bufferSize = java.util.Objects.requireNonNull(builder.bufferSize, "bufferSize is required");
                this.maxTokens = java.util.Objects.requireNonNull(builder.maxTokens, "maxTokens is required");
            }

            @Override
            public final java.lang.Number getBreakpointPercentileThreshold() {
                return this.breakpointPercentileThreshold;
            }

            @Override
            public final java.lang.Number getBufferSize() {
                return this.bufferSize;
            }

            @Override
            public final java.lang.Number getMaxTokens() {
                return this.maxTokens;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("breakpointPercentileThreshold", om.valueToTree(this.getBreakpointPercentileThreshold()));
                data.set("bufferSize", om.valueToTree(this.getBufferSize()));
                data.set("maxTokens", om.valueToTree(this.getMaxTokens()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_wisdom.CfnKnowledgeBase.SemanticChunkingConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SemanticChunkingConfigurationProperty.Jsii$Proxy that = (SemanticChunkingConfigurationProperty.Jsii$Proxy) o;

                if (!breakpointPercentileThreshold.equals(that.breakpointPercentileThreshold)) return false;
                if (!bufferSize.equals(that.bufferSize)) return false;
                return this.maxTokens.equals(that.maxTokens);
            }

            @Override
            public final int hashCode() {
                int result = this.breakpointPercentileThreshold.hashCode();
                result = 31 * result + (this.bufferSize.hashCode());
                result = 31 * result + (this.maxTokens.hashCode());
                return result;
            }
        }
    }
    /**
     * The configuration information for the customer managed key used for encryption.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.wisdom.*;
     * ServerSideEncryptionConfigurationProperty serverSideEncryptionConfigurationProperty = ServerSideEncryptionConfigurationProperty.builder()
     *         .kmsKeyId("kmsKeyId")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-knowledgebase-serversideencryptionconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-knowledgebase-serversideencryptionconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_wisdom.CfnKnowledgeBase.ServerSideEncryptionConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(ServerSideEncryptionConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ServerSideEncryptionConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The customer managed key used for encryption.
         * <p>
         * This customer managed key must have a policy that allows <code>kms:CreateGrant</code> and <code>kms:DescribeKey</code> permissions to the IAM identity using the key to invoke Wisdom.
         * <p>
         * For more information about setting up a customer managed key for Wisdom, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/enable-wisdom.html">Enable Amazon Connect Wisdom for your instance</a> . For information about valid ID values, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id">Key identifiers (KeyId)</a> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-knowledgebase-serversideencryptionconfiguration.html#cfn-wisdom-knowledgebase-serversideencryptionconfiguration-kmskeyid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-knowledgebase-serversideencryptionconfiguration.html#cfn-wisdom-knowledgebase-serversideencryptionconfiguration-kmskeyid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getKmsKeyId() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ServerSideEncryptionConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ServerSideEncryptionConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ServerSideEncryptionConfigurationProperty> {
            java.lang.String kmsKeyId;

            /**
             * Sets the value of {@link ServerSideEncryptionConfigurationProperty#getKmsKeyId}
             * @param kmsKeyId The customer managed key used for encryption.
             *                 This customer managed key must have a policy that allows <code>kms:CreateGrant</code> and <code>kms:DescribeKey</code> permissions to the IAM identity using the key to invoke Wisdom.
             *                 <p>
             *                 For more information about setting up a customer managed key for Wisdom, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/enable-wisdom.html">Enable Amazon Connect Wisdom for your instance</a> . For information about valid ID values, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id">Key identifiers (KeyId)</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder kmsKeyId(java.lang.String kmsKeyId) {
                this.kmsKeyId = kmsKeyId;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ServerSideEncryptionConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ServerSideEncryptionConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ServerSideEncryptionConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ServerSideEncryptionConfigurationProperty {
            private final java.lang.String kmsKeyId;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.kmsKeyId = software.amazon.jsii.Kernel.get(this, "kmsKeyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.kmsKeyId = builder.kmsKeyId;
            }

            @Override
            public final java.lang.String getKmsKeyId() {
                return this.kmsKeyId;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getKmsKeyId() != null) {
                    data.set("kmsKeyId", om.valueToTree(this.getKmsKeyId()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_wisdom.CfnKnowledgeBase.ServerSideEncryptionConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ServerSideEncryptionConfigurationProperty.Jsii$Proxy that = (ServerSideEncryptionConfigurationProperty.Jsii$Proxy) o;

                return this.kmsKeyId != null ? this.kmsKeyId.equals(that.kmsKeyId) : that.kmsKeyId == null;
            }

            @Override
            public final int hashCode() {
                int result = this.kmsKeyId != null ? this.kmsKeyId.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Configuration information about the external data source.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.wisdom.*;
     * SourceConfigurationProperty sourceConfigurationProperty = SourceConfigurationProperty.builder()
     *         .appIntegrations(AppIntegrationsConfigurationProperty.builder()
     *                 .appIntegrationArn("appIntegrationArn")
     *                 // the properties below are optional
     *                 .objectFields(List.of("objectFields"))
     *                 .build())
     *         .managedSourceConfiguration(ManagedSourceConfigurationProperty.builder()
     *                 .webCrawlerConfiguration(WebCrawlerConfigurationProperty.builder()
     *                         .urlConfiguration(UrlConfigurationProperty.builder()
     *                                 .seedUrls(List.of(SeedUrlProperty.builder()
     *                                         .url("url")
     *                                         .build()))
     *                                 .build())
     *                         // the properties below are optional
     *                         .crawlerLimits(CrawlerLimitsProperty.builder()
     *                                 .rateLimit(123)
     *                                 .build())
     *                         .exclusionFilters(List.of("exclusionFilters"))
     *                         .inclusionFilters(List.of("inclusionFilters"))
     *                         .scope("scope")
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-knowledgebase-sourceconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-knowledgebase-sourceconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_wisdom.CfnKnowledgeBase.SourceConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(SourceConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SourceConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Configuration information for Amazon AppIntegrations to automatically ingest content.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-knowledgebase-sourceconfiguration.html#cfn-wisdom-knowledgebase-sourceconfiguration-appintegrations">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-knowledgebase-sourceconfiguration.html#cfn-wisdom-knowledgebase-sourceconfiguration-appintegrations</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAppIntegrations() {
            return null;
        }

        /**
         * Source configuration for managed resources.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-knowledgebase-sourceconfiguration.html#cfn-wisdom-knowledgebase-sourceconfiguration-managedsourceconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-knowledgebase-sourceconfiguration.html#cfn-wisdom-knowledgebase-sourceconfiguration-managedsourceconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getManagedSourceConfiguration() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SourceConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SourceConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SourceConfigurationProperty> {
            java.lang.Object appIntegrations;
            java.lang.Object managedSourceConfiguration;

            /**
             * Sets the value of {@link SourceConfigurationProperty#getAppIntegrations}
             * @param appIntegrations Configuration information for Amazon AppIntegrations to automatically ingest content.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder appIntegrations(software.amazon.awscdk.IResolvable appIntegrations) {
                this.appIntegrations = appIntegrations;
                return this;
            }

            /**
             * Sets the value of {@link SourceConfigurationProperty#getAppIntegrations}
             * @param appIntegrations Configuration information for Amazon AppIntegrations to automatically ingest content.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder appIntegrations(software.amazon.awscdk.services.wisdom.CfnKnowledgeBase.AppIntegrationsConfigurationProperty appIntegrations) {
                this.appIntegrations = appIntegrations;
                return this;
            }

            /**
             * Sets the value of {@link SourceConfigurationProperty#getManagedSourceConfiguration}
             * @param managedSourceConfiguration Source configuration for managed resources.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder managedSourceConfiguration(software.amazon.awscdk.IResolvable managedSourceConfiguration) {
                this.managedSourceConfiguration = managedSourceConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link SourceConfigurationProperty#getManagedSourceConfiguration}
             * @param managedSourceConfiguration Source configuration for managed resources.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder managedSourceConfiguration(software.amazon.awscdk.services.wisdom.CfnKnowledgeBase.ManagedSourceConfigurationProperty managedSourceConfiguration) {
                this.managedSourceConfiguration = managedSourceConfiguration;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SourceConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SourceConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SourceConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SourceConfigurationProperty {
            private final java.lang.Object appIntegrations;
            private final java.lang.Object managedSourceConfiguration;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.appIntegrations = software.amazon.jsii.Kernel.get(this, "appIntegrations", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.managedSourceConfiguration = software.amazon.jsii.Kernel.get(this, "managedSourceConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.appIntegrations = builder.appIntegrations;
                this.managedSourceConfiguration = builder.managedSourceConfiguration;
            }

            @Override
            public final java.lang.Object getAppIntegrations() {
                return this.appIntegrations;
            }

            @Override
            public final java.lang.Object getManagedSourceConfiguration() {
                return this.managedSourceConfiguration;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAppIntegrations() != null) {
                    data.set("appIntegrations", om.valueToTree(this.getAppIntegrations()));
                }
                if (this.getManagedSourceConfiguration() != null) {
                    data.set("managedSourceConfiguration", om.valueToTree(this.getManagedSourceConfiguration()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_wisdom.CfnKnowledgeBase.SourceConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SourceConfigurationProperty.Jsii$Proxy that = (SourceConfigurationProperty.Jsii$Proxy) o;

                if (this.appIntegrations != null ? !this.appIntegrations.equals(that.appIntegrations) : that.appIntegrations != null) return false;
                return this.managedSourceConfiguration != null ? this.managedSourceConfiguration.equals(that.managedSourceConfiguration) : that.managedSourceConfiguration == null;
            }

            @Override
            public final int hashCode() {
                int result = this.appIntegrations != null ? this.appIntegrations.hashCode() : 0;
                result = 31 * result + (this.managedSourceConfiguration != null ? this.managedSourceConfiguration.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The configuration of the URL/URLs for the web content that you want to crawl.
     * <p>
     * You should be authorized to crawl the URLs.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.wisdom.*;
     * UrlConfigurationProperty urlConfigurationProperty = UrlConfigurationProperty.builder()
     *         .seedUrls(List.of(SeedUrlProperty.builder()
     *                 .url("url")
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-knowledgebase-urlconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-knowledgebase-urlconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_wisdom.CfnKnowledgeBase.UrlConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(UrlConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface UrlConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * List of URLs for crawling.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-knowledgebase-urlconfiguration.html#cfn-wisdom-knowledgebase-urlconfiguration-seedurls">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-knowledgebase-urlconfiguration.html#cfn-wisdom-knowledgebase-urlconfiguration-seedurls</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSeedUrls() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link UrlConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link UrlConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<UrlConfigurationProperty> {
            java.lang.Object seedUrls;

            /**
             * Sets the value of {@link UrlConfigurationProperty#getSeedUrls}
             * @param seedUrls List of URLs for crawling.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder seedUrls(software.amazon.awscdk.IResolvable seedUrls) {
                this.seedUrls = seedUrls;
                return this;
            }

            /**
             * Sets the value of {@link UrlConfigurationProperty#getSeedUrls}
             * @param seedUrls List of URLs for crawling.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder seedUrls(java.util.List<? extends java.lang.Object> seedUrls) {
                this.seedUrls = seedUrls;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link UrlConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public UrlConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link UrlConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements UrlConfigurationProperty {
            private final java.lang.Object seedUrls;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.seedUrls = software.amazon.jsii.Kernel.get(this, "seedUrls", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.seedUrls = builder.seedUrls;
            }

            @Override
            public final java.lang.Object getSeedUrls() {
                return this.seedUrls;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getSeedUrls() != null) {
                    data.set("seedUrls", om.valueToTree(this.getSeedUrls()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_wisdom.CfnKnowledgeBase.UrlConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                UrlConfigurationProperty.Jsii$Proxy that = (UrlConfigurationProperty.Jsii$Proxy) o;

                return this.seedUrls != null ? this.seedUrls.equals(that.seedUrls) : that.seedUrls == null;
            }

            @Override
            public final int hashCode() {
                int result = this.seedUrls != null ? this.seedUrls.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Contains details about how to ingest the documents in a data source.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.wisdom.*;
     * VectorIngestionConfigurationProperty vectorIngestionConfigurationProperty = VectorIngestionConfigurationProperty.builder()
     *         .chunkingConfiguration(ChunkingConfigurationProperty.builder()
     *                 .chunkingStrategy("chunkingStrategy")
     *                 // the properties below are optional
     *                 .fixedSizeChunkingConfiguration(FixedSizeChunkingConfigurationProperty.builder()
     *                         .maxTokens(123)
     *                         .overlapPercentage(123)
     *                         .build())
     *                 .hierarchicalChunkingConfiguration(HierarchicalChunkingConfigurationProperty.builder()
     *                         .levelConfigurations(List.of(HierarchicalChunkingLevelConfigurationProperty.builder()
     *                                 .maxTokens(123)
     *                                 .build()))
     *                         .overlapTokens(123)
     *                         .build())
     *                 .semanticChunkingConfiguration(SemanticChunkingConfigurationProperty.builder()
     *                         .breakpointPercentileThreshold(123)
     *                         .bufferSize(123)
     *                         .maxTokens(123)
     *                         .build())
     *                 .build())
     *         .parsingConfiguration(ParsingConfigurationProperty.builder()
     *                 .parsingStrategy("parsingStrategy")
     *                 // the properties below are optional
     *                 .bedrockFoundationModelConfiguration(BedrockFoundationModelConfigurationProperty.builder()
     *                         .modelArn("modelArn")
     *                         // the properties below are optional
     *                         .parsingPrompt(ParsingPromptProperty.builder()
     *                                 .parsingPromptText("parsingPromptText")
     *                                 .build())
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-knowledgebase-vectoringestionconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-knowledgebase-vectoringestionconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_wisdom.CfnKnowledgeBase.VectorIngestionConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(VectorIngestionConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface VectorIngestionConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Details about how to chunk the documents in the data source.
         * <p>
         * A chunk refers to an excerpt from a data source that is returned when the knowledge base that it belongs to is queried.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-knowledgebase-vectoringestionconfiguration.html#cfn-wisdom-knowledgebase-vectoringestionconfiguration-chunkingconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-knowledgebase-vectoringestionconfiguration.html#cfn-wisdom-knowledgebase-vectoringestionconfiguration-chunkingconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getChunkingConfiguration() {
            return null;
        }

        /**
         * A custom parser for data source documents.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-knowledgebase-vectoringestionconfiguration.html#cfn-wisdom-knowledgebase-vectoringestionconfiguration-parsingconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-knowledgebase-vectoringestionconfiguration.html#cfn-wisdom-knowledgebase-vectoringestionconfiguration-parsingconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getParsingConfiguration() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link VectorIngestionConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link VectorIngestionConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<VectorIngestionConfigurationProperty> {
            java.lang.Object chunkingConfiguration;
            java.lang.Object parsingConfiguration;

            /**
             * Sets the value of {@link VectorIngestionConfigurationProperty#getChunkingConfiguration}
             * @param chunkingConfiguration Details about how to chunk the documents in the data source.
             *                              A chunk refers to an excerpt from a data source that is returned when the knowledge base that it belongs to is queried.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder chunkingConfiguration(software.amazon.awscdk.IResolvable chunkingConfiguration) {
                this.chunkingConfiguration = chunkingConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link VectorIngestionConfigurationProperty#getChunkingConfiguration}
             * @param chunkingConfiguration Details about how to chunk the documents in the data source.
             *                              A chunk refers to an excerpt from a data source that is returned when the knowledge base that it belongs to is queried.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder chunkingConfiguration(software.amazon.awscdk.services.wisdom.CfnKnowledgeBase.ChunkingConfigurationProperty chunkingConfiguration) {
                this.chunkingConfiguration = chunkingConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link VectorIngestionConfigurationProperty#getParsingConfiguration}
             * @param parsingConfiguration A custom parser for data source documents.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder parsingConfiguration(software.amazon.awscdk.IResolvable parsingConfiguration) {
                this.parsingConfiguration = parsingConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link VectorIngestionConfigurationProperty#getParsingConfiguration}
             * @param parsingConfiguration A custom parser for data source documents.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder parsingConfiguration(software.amazon.awscdk.services.wisdom.CfnKnowledgeBase.ParsingConfigurationProperty parsingConfiguration) {
                this.parsingConfiguration = parsingConfiguration;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link VectorIngestionConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public VectorIngestionConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link VectorIngestionConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements VectorIngestionConfigurationProperty {
            private final java.lang.Object chunkingConfiguration;
            private final java.lang.Object parsingConfiguration;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.chunkingConfiguration = software.amazon.jsii.Kernel.get(this, "chunkingConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.parsingConfiguration = software.amazon.jsii.Kernel.get(this, "parsingConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.chunkingConfiguration = builder.chunkingConfiguration;
                this.parsingConfiguration = builder.parsingConfiguration;
            }

            @Override
            public final java.lang.Object getChunkingConfiguration() {
                return this.chunkingConfiguration;
            }

            @Override
            public final java.lang.Object getParsingConfiguration() {
                return this.parsingConfiguration;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getChunkingConfiguration() != null) {
                    data.set("chunkingConfiguration", om.valueToTree(this.getChunkingConfiguration()));
                }
                if (this.getParsingConfiguration() != null) {
                    data.set("parsingConfiguration", om.valueToTree(this.getParsingConfiguration()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_wisdom.CfnKnowledgeBase.VectorIngestionConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                VectorIngestionConfigurationProperty.Jsii$Proxy that = (VectorIngestionConfigurationProperty.Jsii$Proxy) o;

                if (this.chunkingConfiguration != null ? !this.chunkingConfiguration.equals(that.chunkingConfiguration) : that.chunkingConfiguration != null) return false;
                return this.parsingConfiguration != null ? this.parsingConfiguration.equals(that.parsingConfiguration) : that.parsingConfiguration == null;
            }

            @Override
            public final int hashCode() {
                int result = this.chunkingConfiguration != null ? this.chunkingConfiguration.hashCode() : 0;
                result = 31 * result + (this.parsingConfiguration != null ? this.parsingConfiguration.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The configuration details for the web data source.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.wisdom.*;
     * WebCrawlerConfigurationProperty webCrawlerConfigurationProperty = WebCrawlerConfigurationProperty.builder()
     *         .urlConfiguration(UrlConfigurationProperty.builder()
     *                 .seedUrls(List.of(SeedUrlProperty.builder()
     *                         .url("url")
     *                         .build()))
     *                 .build())
     *         // the properties below are optional
     *         .crawlerLimits(CrawlerLimitsProperty.builder()
     *                 .rateLimit(123)
     *                 .build())
     *         .exclusionFilters(List.of("exclusionFilters"))
     *         .inclusionFilters(List.of("inclusionFilters"))
     *         .scope("scope")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-knowledgebase-webcrawlerconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-knowledgebase-webcrawlerconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_wisdom.CfnKnowledgeBase.WebCrawlerConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(WebCrawlerConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface WebCrawlerConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The configuration of the URL/URLs for the web content that you want to crawl.
         * <p>
         * You should be authorized to crawl the URLs.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-knowledgebase-webcrawlerconfiguration.html#cfn-wisdom-knowledgebase-webcrawlerconfiguration-urlconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-knowledgebase-webcrawlerconfiguration.html#cfn-wisdom-knowledgebase-webcrawlerconfiguration-urlconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getUrlConfiguration();

        /**
         * The configuration of crawl limits for the web URLs.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-knowledgebase-webcrawlerconfiguration.html#cfn-wisdom-knowledgebase-webcrawlerconfiguration-crawlerlimits">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-knowledgebase-webcrawlerconfiguration.html#cfn-wisdom-knowledgebase-webcrawlerconfiguration-crawlerlimits</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCrawlerLimits() {
            return null;
        }

        /**
         * A list of one or more exclusion regular expression patterns to exclude certain URLs.
         * <p>
         * If you specify an inclusion and exclusion filter/pattern and both match a URL, the exclusion filter takes precedence and the web content of the URL isn’t crawled.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-knowledgebase-webcrawlerconfiguration.html#cfn-wisdom-knowledgebase-webcrawlerconfiguration-exclusionfilters">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-knowledgebase-webcrawlerconfiguration.html#cfn-wisdom-knowledgebase-webcrawlerconfiguration-exclusionfilters</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getExclusionFilters() {
            return null;
        }

        /**
         * A list of one or more inclusion regular expression patterns to include certain URLs.
         * <p>
         * If you specify an inclusion and exclusion filter/pattern and both match a URL, the exclusion filter takes precedence and the web content of the URL isn’t crawled.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-knowledgebase-webcrawlerconfiguration.html#cfn-wisdom-knowledgebase-webcrawlerconfiguration-inclusionfilters">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-knowledgebase-webcrawlerconfiguration.html#cfn-wisdom-knowledgebase-webcrawlerconfiguration-inclusionfilters</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getInclusionFilters() {
            return null;
        }

        /**
         * The scope of what is crawled for your URLs.
         * <p>
         * You can choose to crawl only web pages that belong to the same host or primary domain. For example, only web pages that contain the seed URL <code>https://docs.aws.amazon.com/bedrock/latest/userguide/</code> and no other domains. You can choose to include sub domains in addition to the host or primary domain. For example, web pages that contain <code>aws.amazon.com</code> can also include sub domain <code>docs.aws.amazon.com</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-knowledgebase-webcrawlerconfiguration.html#cfn-wisdom-knowledgebase-webcrawlerconfiguration-scope">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-knowledgebase-webcrawlerconfiguration.html#cfn-wisdom-knowledgebase-webcrawlerconfiguration-scope</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getScope() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link WebCrawlerConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link WebCrawlerConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<WebCrawlerConfigurationProperty> {
            java.lang.Object urlConfiguration;
            java.lang.Object crawlerLimits;
            java.util.List<java.lang.String> exclusionFilters;
            java.util.List<java.lang.String> inclusionFilters;
            java.lang.String scope;

            /**
             * Sets the value of {@link WebCrawlerConfigurationProperty#getUrlConfiguration}
             * @param urlConfiguration The configuration of the URL/URLs for the web content that you want to crawl. This parameter is required.
             *                         You should be authorized to crawl the URLs.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder urlConfiguration(software.amazon.awscdk.IResolvable urlConfiguration) {
                this.urlConfiguration = urlConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link WebCrawlerConfigurationProperty#getUrlConfiguration}
             * @param urlConfiguration The configuration of the URL/URLs for the web content that you want to crawl. This parameter is required.
             *                         You should be authorized to crawl the URLs.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder urlConfiguration(software.amazon.awscdk.services.wisdom.CfnKnowledgeBase.UrlConfigurationProperty urlConfiguration) {
                this.urlConfiguration = urlConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link WebCrawlerConfigurationProperty#getCrawlerLimits}
             * @param crawlerLimits The configuration of crawl limits for the web URLs.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder crawlerLimits(software.amazon.awscdk.IResolvable crawlerLimits) {
                this.crawlerLimits = crawlerLimits;
                return this;
            }

            /**
             * Sets the value of {@link WebCrawlerConfigurationProperty#getCrawlerLimits}
             * @param crawlerLimits The configuration of crawl limits for the web URLs.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder crawlerLimits(software.amazon.awscdk.services.wisdom.CfnKnowledgeBase.CrawlerLimitsProperty crawlerLimits) {
                this.crawlerLimits = crawlerLimits;
                return this;
            }

            /**
             * Sets the value of {@link WebCrawlerConfigurationProperty#getExclusionFilters}
             * @param exclusionFilters A list of one or more exclusion regular expression patterns to exclude certain URLs.
             *                         If you specify an inclusion and exclusion filter/pattern and both match a URL, the exclusion filter takes precedence and the web content of the URL isn’t crawled.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder exclusionFilters(java.util.List<java.lang.String> exclusionFilters) {
                this.exclusionFilters = exclusionFilters;
                return this;
            }

            /**
             * Sets the value of {@link WebCrawlerConfigurationProperty#getInclusionFilters}
             * @param inclusionFilters A list of one or more inclusion regular expression patterns to include certain URLs.
             *                         If you specify an inclusion and exclusion filter/pattern and both match a URL, the exclusion filter takes precedence and the web content of the URL isn’t crawled.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inclusionFilters(java.util.List<java.lang.String> inclusionFilters) {
                this.inclusionFilters = inclusionFilters;
                return this;
            }

            /**
             * Sets the value of {@link WebCrawlerConfigurationProperty#getScope}
             * @param scope The scope of what is crawled for your URLs.
             *              You can choose to crawl only web pages that belong to the same host or primary domain. For example, only web pages that contain the seed URL <code>https://docs.aws.amazon.com/bedrock/latest/userguide/</code> and no other domains. You can choose to include sub domains in addition to the host or primary domain. For example, web pages that contain <code>aws.amazon.com</code> can also include sub domain <code>docs.aws.amazon.com</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder scope(java.lang.String scope) {
                this.scope = scope;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link WebCrawlerConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public WebCrawlerConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link WebCrawlerConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements WebCrawlerConfigurationProperty {
            private final java.lang.Object urlConfiguration;
            private final java.lang.Object crawlerLimits;
            private final java.util.List<java.lang.String> exclusionFilters;
            private final java.util.List<java.lang.String> inclusionFilters;
            private final java.lang.String scope;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.urlConfiguration = software.amazon.jsii.Kernel.get(this, "urlConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.crawlerLimits = software.amazon.jsii.Kernel.get(this, "crawlerLimits", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.exclusionFilters = software.amazon.jsii.Kernel.get(this, "exclusionFilters", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.inclusionFilters = software.amazon.jsii.Kernel.get(this, "inclusionFilters", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.scope = software.amazon.jsii.Kernel.get(this, "scope", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.urlConfiguration = java.util.Objects.requireNonNull(builder.urlConfiguration, "urlConfiguration is required");
                this.crawlerLimits = builder.crawlerLimits;
                this.exclusionFilters = builder.exclusionFilters;
                this.inclusionFilters = builder.inclusionFilters;
                this.scope = builder.scope;
            }

            @Override
            public final java.lang.Object getUrlConfiguration() {
                return this.urlConfiguration;
            }

            @Override
            public final java.lang.Object getCrawlerLimits() {
                return this.crawlerLimits;
            }

            @Override
            public final java.util.List<java.lang.String> getExclusionFilters() {
                return this.exclusionFilters;
            }

            @Override
            public final java.util.List<java.lang.String> getInclusionFilters() {
                return this.inclusionFilters;
            }

            @Override
            public final java.lang.String getScope() {
                return this.scope;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("urlConfiguration", om.valueToTree(this.getUrlConfiguration()));
                if (this.getCrawlerLimits() != null) {
                    data.set("crawlerLimits", om.valueToTree(this.getCrawlerLimits()));
                }
                if (this.getExclusionFilters() != null) {
                    data.set("exclusionFilters", om.valueToTree(this.getExclusionFilters()));
                }
                if (this.getInclusionFilters() != null) {
                    data.set("inclusionFilters", om.valueToTree(this.getInclusionFilters()));
                }
                if (this.getScope() != null) {
                    data.set("scope", om.valueToTree(this.getScope()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_wisdom.CfnKnowledgeBase.WebCrawlerConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                WebCrawlerConfigurationProperty.Jsii$Proxy that = (WebCrawlerConfigurationProperty.Jsii$Proxy) o;

                if (!urlConfiguration.equals(that.urlConfiguration)) return false;
                if (this.crawlerLimits != null ? !this.crawlerLimits.equals(that.crawlerLimits) : that.crawlerLimits != null) return false;
                if (this.exclusionFilters != null ? !this.exclusionFilters.equals(that.exclusionFilters) : that.exclusionFilters != null) return false;
                if (this.inclusionFilters != null ? !this.inclusionFilters.equals(that.inclusionFilters) : that.inclusionFilters != null) return false;
                return this.scope != null ? this.scope.equals(that.scope) : that.scope == null;
            }

            @Override
            public final int hashCode() {
                int result = this.urlConfiguration.hashCode();
                result = 31 * result + (this.crawlerLimits != null ? this.crawlerLimits.hashCode() : 0);
                result = 31 * result + (this.exclusionFilters != null ? this.exclusionFilters.hashCode() : 0);
                result = 31 * result + (this.inclusionFilters != null ? this.inclusionFilters.hashCode() : 0);
                result = 31 * result + (this.scope != null ? this.scope.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.wisdom.CfnKnowledgeBase}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.wisdom.CfnKnowledgeBase> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.wisdom.CfnKnowledgeBaseProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.wisdom.CfnKnowledgeBaseProps.Builder();
        }

        /**
         * The type of knowledge base.
         * <p>
         * Only CUSTOM knowledge bases allow you to upload your own content. EXTERNAL knowledge bases support integrations with third-party systems whose content is synchronized automatically.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-knowledgebase.html#cfn-wisdom-knowledgebase-knowledgebasetype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-knowledgebase.html#cfn-wisdom-knowledgebase-knowledgebasetype</a>
         * @param knowledgeBaseType The type of knowledge base. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder knowledgeBaseType(final java.lang.String knowledgeBaseType) {
            this.props.knowledgeBaseType(knowledgeBaseType);
            return this;
        }

        /**
         * The name of the knowledge base.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-knowledgebase.html#cfn-wisdom-knowledgebase-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-knowledgebase.html#cfn-wisdom-knowledgebase-name</a>
         * @param name The name of the knowledge base. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props.name(name);
            return this;
        }

        /**
         * The description.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-knowledgebase.html#cfn-wisdom-knowledgebase-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-knowledgebase.html#cfn-wisdom-knowledgebase-description</a>
         * @param description The description. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * Information about how to render the content.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-knowledgebase.html#cfn-wisdom-knowledgebase-renderingconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-knowledgebase.html#cfn-wisdom-knowledgebase-renderingconfiguration</a>
         * @param renderingConfiguration Information about how to render the content. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder renderingConfiguration(final software.amazon.awscdk.IResolvable renderingConfiguration) {
            this.props.renderingConfiguration(renderingConfiguration);
            return this;
        }
        /**
         * Information about how to render the content.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-knowledgebase.html#cfn-wisdom-knowledgebase-renderingconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-knowledgebase.html#cfn-wisdom-knowledgebase-renderingconfiguration</a>
         * @param renderingConfiguration Information about how to render the content. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder renderingConfiguration(final software.amazon.awscdk.services.wisdom.CfnKnowledgeBase.RenderingConfigurationProperty renderingConfiguration) {
            this.props.renderingConfiguration(renderingConfiguration);
            return this;
        }

        /**
         * This customer managed key must have a policy that allows <code>kms:CreateGrant</code> and <code>kms:DescribeKey</code> permissions to the IAM identity using the key to invoke Wisdom.
         * <p>
         * For more information about setting up a customer managed key for Wisdom, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/enable-wisdom.html">Enable Amazon Connect Wisdom for your instance</a> . For information about valid ID values, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id">Key identifiers (KeyId)</a> in the <em>AWS Key Management Service Developer Guide</em> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-knowledgebase.html#cfn-wisdom-knowledgebase-serversideencryptionconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-knowledgebase.html#cfn-wisdom-knowledgebase-serversideencryptionconfiguration</a>
         * @param serverSideEncryptionConfiguration This customer managed key must have a policy that allows <code>kms:CreateGrant</code> and <code>kms:DescribeKey</code> permissions to the IAM identity using the key to invoke Wisdom. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serverSideEncryptionConfiguration(final software.amazon.awscdk.IResolvable serverSideEncryptionConfiguration) {
            this.props.serverSideEncryptionConfiguration(serverSideEncryptionConfiguration);
            return this;
        }
        /**
         * This customer managed key must have a policy that allows <code>kms:CreateGrant</code> and <code>kms:DescribeKey</code> permissions to the IAM identity using the key to invoke Wisdom.
         * <p>
         * For more information about setting up a customer managed key for Wisdom, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/enable-wisdom.html">Enable Amazon Connect Wisdom for your instance</a> . For information about valid ID values, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id">Key identifiers (KeyId)</a> in the <em>AWS Key Management Service Developer Guide</em> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-knowledgebase.html#cfn-wisdom-knowledgebase-serversideencryptionconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-knowledgebase.html#cfn-wisdom-knowledgebase-serversideencryptionconfiguration</a>
         * @param serverSideEncryptionConfiguration This customer managed key must have a policy that allows <code>kms:CreateGrant</code> and <code>kms:DescribeKey</code> permissions to the IAM identity using the key to invoke Wisdom. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serverSideEncryptionConfiguration(final software.amazon.awscdk.services.wisdom.CfnKnowledgeBase.ServerSideEncryptionConfigurationProperty serverSideEncryptionConfiguration) {
            this.props.serverSideEncryptionConfiguration(serverSideEncryptionConfiguration);
            return this;
        }

        /**
         * The source of the knowledge base content.
         * <p>
         * Only set this argument for EXTERNAL or Managed knowledge bases.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-knowledgebase.html#cfn-wisdom-knowledgebase-sourceconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-knowledgebase.html#cfn-wisdom-knowledgebase-sourceconfiguration</a>
         * @param sourceConfiguration The source of the knowledge base content. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourceConfiguration(final software.amazon.awscdk.IResolvable sourceConfiguration) {
            this.props.sourceConfiguration(sourceConfiguration);
            return this;
        }
        /**
         * The source of the knowledge base content.
         * <p>
         * Only set this argument for EXTERNAL or Managed knowledge bases.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-knowledgebase.html#cfn-wisdom-knowledgebase-sourceconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-knowledgebase.html#cfn-wisdom-knowledgebase-sourceconfiguration</a>
         * @param sourceConfiguration The source of the knowledge base content. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourceConfiguration(final software.amazon.awscdk.services.wisdom.CfnKnowledgeBase.SourceConfigurationProperty sourceConfiguration) {
            this.props.sourceConfiguration(sourceConfiguration);
            return this;
        }

        /**
         * The tags used to organize, track, or control access for this resource.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-knowledgebase.html#cfn-wisdom-knowledgebase-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-knowledgebase.html#cfn-wisdom-knowledgebase-tags</a>
         * @param tags The tags used to organize, track, or control access for this resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * Contains details about how to ingest the documents in a data source.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-knowledgebase.html#cfn-wisdom-knowledgebase-vectoringestionconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-knowledgebase.html#cfn-wisdom-knowledgebase-vectoringestionconfiguration</a>
         * @param vectorIngestionConfiguration Contains details about how to ingest the documents in a data source. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vectorIngestionConfiguration(final software.amazon.awscdk.IResolvable vectorIngestionConfiguration) {
            this.props.vectorIngestionConfiguration(vectorIngestionConfiguration);
            return this;
        }
        /**
         * Contains details about how to ingest the documents in a data source.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-knowledgebase.html#cfn-wisdom-knowledgebase-vectoringestionconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-knowledgebase.html#cfn-wisdom-knowledgebase-vectoringestionconfiguration</a>
         * @param vectorIngestionConfiguration Contains details about how to ingest the documents in a data source. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vectorIngestionConfiguration(final software.amazon.awscdk.services.wisdom.CfnKnowledgeBase.VectorIngestionConfigurationProperty vectorIngestionConfiguration) {
            this.props.vectorIngestionConfiguration(vectorIngestionConfiguration);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.wisdom.CfnKnowledgeBase}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.wisdom.CfnKnowledgeBase build() {
            return new software.amazon.awscdk.services.wisdom.CfnKnowledgeBase(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
