package software.amazon.awscdk.services.workspacesinstances;

/**
 * Properties for defining a <code>CfnWorkspaceInstance</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.workspacesinstances.*;
 * CfnWorkspaceInstanceProps cfnWorkspaceInstanceProps = CfnWorkspaceInstanceProps.builder()
 *         .managedInstance(ManagedInstanceProperty.builder()
 *                 .imageId("imageId")
 *                 .instanceType("instanceType")
 *                 // the properties below are optional
 *                 .blockDeviceMappings(List.of(BlockDeviceMappingProperty.builder()
 *                         .deviceName("deviceName")
 *                         .ebs(EbsBlockDeviceProperty.builder()
 *                                 .encrypted(false)
 *                                 .iops(123)
 *                                 .kmsKeyId("kmsKeyId")
 *                                 .throughput(123)
 *                                 .volumeSize(123)
 *                                 .volumeType("volumeType")
 *                                 .build())
 *                         .noDevice("noDevice")
 *                         .virtualName("virtualName")
 *                         .build()))
 *                 .cpuOptions(CpuOptionsRequestProperty.builder()
 *                         .coreCount(123)
 *                         .threadsPerCore(123)
 *                         .build())
 *                 .creditSpecification(CreditSpecificationRequestProperty.builder()
 *                         .cpuCredits("cpuCredits")
 *                         .build())
 *                 .disableApiStop(false)
 *                 .ebsOptimized(false)
 *                 .enclaveOptions(EnclaveOptionsRequestProperty.builder()
 *                         .enabled(false)
 *                         .build())
 *                 .hibernationOptions(HibernationOptionsRequestProperty.builder()
 *                         .configured(false)
 *                         .build())
 *                 .iamInstanceProfile(IamInstanceProfileSpecificationProperty.builder()
 *                         .name("name")
 *                         .build())
 *                 .keyName("keyName")
 *                 .maintenanceOptions(InstanceMaintenanceOptionsRequestProperty.builder()
 *                         .autoRecovery("autoRecovery")
 *                         .build())
 *                 .metadataOptions(InstanceMetadataOptionsRequestProperty.builder()
 *                         .httpEndpoint("httpEndpoint")
 *                         .httpProtocolIpv6("httpProtocolIpv6")
 *                         .httpPutResponseHopLimit(123)
 *                         .httpTokens("httpTokens")
 *                         .instanceMetadataTags("instanceMetadataTags")
 *                         .build())
 *                 .monitoring(RunInstancesMonitoringEnabledProperty.builder()
 *                         .enabled(false)
 *                         .build())
 *                 .networkInterfaces(List.of(InstanceNetworkInterfaceSpecificationProperty.builder()
 *                         .description("description")
 *                         .deviceIndex(123)
 *                         .groups(List.of("groups"))
 *                         .subnetId("subnetId")
 *                         .build()))
 *                 .networkPerformanceOptions(InstanceNetworkPerformanceOptionsRequestProperty.builder()
 *                         .bandwidthWeighting("bandwidthWeighting")
 *                         .build())
 *                 .placement(PlacementProperty.builder()
 *                         .availabilityZone("availabilityZone")
 *                         .groupName("groupName")
 *                         .tenancy("tenancy")
 *                         .build())
 *                 .privateDnsNameOptions(PrivateDnsNameOptionsRequestProperty.builder()
 *                         .enableResourceNameDnsAaaaRecord(false)
 *                         .enableResourceNameDnsARecord(false)
 *                         .hostnameType("hostnameType")
 *                         .build())
 *                 .tagSpecifications(List.of(TagSpecificationProperty.builder()
 *                         .resourceType("resourceType")
 *                         .tags(List.of(CfnTag.builder()
 *                                 .key("key")
 *                                 .value("value")
 *                                 .build()))
 *                         .build()))
 *                 .userData("userData")
 *                 .build())
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspacesinstances-workspaceinstance.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspacesinstances-workspaceinstance.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-24T11:33:25.010Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_workspacesinstances.CfnWorkspaceInstanceProps")
@software.amazon.jsii.Jsii.Proxy(CfnWorkspaceInstanceProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnWorkspaceInstanceProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspacesinstances-workspaceinstance.html#cfn-workspacesinstances-workspaceinstance-managedinstance">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspacesinstances-workspaceinstance.html#cfn-workspacesinstances-workspaceinstance-managedinstance</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getManagedInstance() {
        return null;
    }

    /**
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspacesinstances-workspaceinstance.html#cfn-workspacesinstances-workspaceinstance-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspacesinstances-workspaceinstance.html#cfn-workspacesinstances-workspaceinstance-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnWorkspaceInstanceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnWorkspaceInstanceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnWorkspaceInstanceProps> {
        java.lang.Object managedInstance;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnWorkspaceInstanceProps#getManagedInstance}
         * @param managedInstance the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder managedInstance(software.amazon.awscdk.IResolvable managedInstance) {
            this.managedInstance = managedInstance;
            return this;
        }

        /**
         * Sets the value of {@link CfnWorkspaceInstanceProps#getManagedInstance}
         * @param managedInstance the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder managedInstance(software.amazon.awscdk.services.workspacesinstances.CfnWorkspaceInstance.ManagedInstanceProperty managedInstance) {
            this.managedInstance = managedInstance;
            return this;
        }

        /**
         * Sets the value of {@link CfnWorkspaceInstanceProps#getTags}
         * @param tags the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnWorkspaceInstanceProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnWorkspaceInstanceProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnWorkspaceInstanceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnWorkspaceInstanceProps {
        private final java.lang.Object managedInstance;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.managedInstance = software.amazon.jsii.Kernel.get(this, "managedInstance", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.managedInstance = builder.managedInstance;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.Object getManagedInstance() {
            return this.managedInstance;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getManagedInstance() != null) {
                data.set("managedInstance", om.valueToTree(this.getManagedInstance()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_workspacesinstances.CfnWorkspaceInstanceProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnWorkspaceInstanceProps.Jsii$Proxy that = (CfnWorkspaceInstanceProps.Jsii$Proxy) o;

            if (this.managedInstance != null ? !this.managedInstance.equals(that.managedInstance) : that.managedInstance != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.managedInstance != null ? this.managedInstance.hashCode() : 0;
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
