package software.amazon.awscdk;

/**
 * Initialization properties for <code>CustomResourceProviderBase</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.*;
 * Object policyStatements;
 * Size size;
 * CustomResourceProviderBaseProps customResourceProviderBaseProps = CustomResourceProviderBaseProps.builder()
 *         .codeDirectory("codeDirectory")
 *         .runtimeName("runtimeName")
 *         // the properties below are optional
 *         .description("description")
 *         .environment(Map.of(
 *                 "environmentKey", "environment"))
 *         .memorySize(size)
 *         .policyStatements(List.of(policyStatements))
 *         .timeout(Duration.minutes(30))
 *         .useCfnResponseWrapper(false)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-08-06T18:14:31.113Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.CustomResourceProviderBaseProps")
@software.amazon.jsii.Jsii.Proxy(CustomResourceProviderBaseProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CustomResourceProviderBaseProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.CustomResourceProviderOptions {

    /**
     * A local file system directory with the provider's code.
     * <p>
     * The code will be
     * bundled into a zip asset and wired to the provider's AWS Lambda function.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getCodeDirectory();

    /**
     * The AWS Lambda runtime and version name to use for the provider.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getRuntimeName();

    /**
     * @return a {@link Builder} of {@link CustomResourceProviderBaseProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CustomResourceProviderBaseProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CustomResourceProviderBaseProps> {
        java.lang.String codeDirectory;
        java.lang.String runtimeName;
        java.lang.String description;
        java.util.Map<java.lang.String, java.lang.String> environment;
        software.amazon.awscdk.Size memorySize;
        java.util.List<java.lang.Object> policyStatements;
        software.amazon.awscdk.Duration timeout;
        java.lang.Boolean useCfnResponseWrapper;

        /**
         * Sets the value of {@link CustomResourceProviderBaseProps#getCodeDirectory}
         * @param codeDirectory A local file system directory with the provider's code. This parameter is required.
         *                      The code will be
         *                      bundled into a zip asset and wired to the provider's AWS Lambda function.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder codeDirectory(java.lang.String codeDirectory) {
            this.codeDirectory = codeDirectory;
            return this;
        }

        /**
         * Sets the value of {@link CustomResourceProviderBaseProps#getRuntimeName}
         * @param runtimeName The AWS Lambda runtime and version name to use for the provider. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder runtimeName(java.lang.String runtimeName) {
            this.runtimeName = runtimeName;
            return this;
        }

        /**
         * Sets the value of {@link CustomResourceProviderBaseProps#getDescription}
         * @param description A description of the function.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CustomResourceProviderBaseProps#getEnvironment}
         * @param environment Key-value pairs that are passed to Lambda as Environment.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder environment(java.util.Map<java.lang.String, java.lang.String> environment) {
            this.environment = environment;
            return this;
        }

        /**
         * Sets the value of {@link CustomResourceProviderBaseProps#getMemorySize}
         * @param memorySize The amount of memory that your function has access to.
         *                   Increasing the
         *                   function's memory also increases its CPU allocation.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder memorySize(software.amazon.awscdk.Size memorySize) {
            this.memorySize = memorySize;
            return this;
        }

        /**
         * Sets the value of {@link CustomResourceProviderBaseProps#getPolicyStatements}
         * @param policyStatements A set of IAM policy statements to include in the inline policy of the provider's lambda function.
         *                         <strong>Please note</strong>: these are direct IAM JSON policy blobs, <em>not</em> <code>iam.PolicyStatement</code>
         *                         objects like you will see in the rest of the CDK.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder policyStatements(java.util.List<? extends java.lang.Object> policyStatements) {
            this.policyStatements = (java.util.List<java.lang.Object>)policyStatements;
            return this;
        }

        /**
         * Sets the value of {@link CustomResourceProviderBaseProps#getTimeout}
         * @param timeout AWS Lambda timeout for the provider.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder timeout(software.amazon.awscdk.Duration timeout) {
            this.timeout = timeout;
            return this;
        }

        /**
         * Sets the value of {@link CustomResourceProviderBaseProps#getUseCfnResponseWrapper}
         * @param useCfnResponseWrapper Whether or not the cloudformation response wrapper (<code>nodejs-entrypoint.ts</code>) is used. If set to <code>true</code>, <code>nodejs-entrypoint.js</code> is bundled in the same asset as the custom resource and set as the entrypoint. If set to <code>false</code>, the custom resource provided is the entrypoint.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder useCfnResponseWrapper(java.lang.Boolean useCfnResponseWrapper) {
            this.useCfnResponseWrapper = useCfnResponseWrapper;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CustomResourceProviderBaseProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CustomResourceProviderBaseProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CustomResourceProviderBaseProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CustomResourceProviderBaseProps {
        private final java.lang.String codeDirectory;
        private final java.lang.String runtimeName;
        private final java.lang.String description;
        private final java.util.Map<java.lang.String, java.lang.String> environment;
        private final software.amazon.awscdk.Size memorySize;
        private final java.util.List<java.lang.Object> policyStatements;
        private final software.amazon.awscdk.Duration timeout;
        private final java.lang.Boolean useCfnResponseWrapper;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.codeDirectory = software.amazon.jsii.Kernel.get(this, "codeDirectory", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.runtimeName = software.amazon.jsii.Kernel.get(this, "runtimeName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.environment = software.amazon.jsii.Kernel.get(this, "environment", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.memorySize = software.amazon.jsii.Kernel.get(this, "memorySize", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Size.class));
            this.policyStatements = software.amazon.jsii.Kernel.get(this, "policyStatements", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)));
            this.timeout = software.amazon.jsii.Kernel.get(this, "timeout", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
            this.useCfnResponseWrapper = software.amazon.jsii.Kernel.get(this, "useCfnResponseWrapper", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.codeDirectory = java.util.Objects.requireNonNull(builder.codeDirectory, "codeDirectory is required");
            this.runtimeName = java.util.Objects.requireNonNull(builder.runtimeName, "runtimeName is required");
            this.description = builder.description;
            this.environment = builder.environment;
            this.memorySize = builder.memorySize;
            this.policyStatements = (java.util.List<java.lang.Object>)builder.policyStatements;
            this.timeout = builder.timeout;
            this.useCfnResponseWrapper = builder.useCfnResponseWrapper;
        }

        @Override
        public final java.lang.String getCodeDirectory() {
            return this.codeDirectory;
        }

        @Override
        public final java.lang.String getRuntimeName() {
            return this.runtimeName;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getEnvironment() {
            return this.environment;
        }

        @Override
        public final software.amazon.awscdk.Size getMemorySize() {
            return this.memorySize;
        }

        @Override
        public final java.util.List<java.lang.Object> getPolicyStatements() {
            return this.policyStatements;
        }

        @Override
        public final software.amazon.awscdk.Duration getTimeout() {
            return this.timeout;
        }

        @Override
        public final java.lang.Boolean getUseCfnResponseWrapper() {
            return this.useCfnResponseWrapper;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("codeDirectory", om.valueToTree(this.getCodeDirectory()));
            data.set("runtimeName", om.valueToTree(this.getRuntimeName()));
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getEnvironment() != null) {
                data.set("environment", om.valueToTree(this.getEnvironment()));
            }
            if (this.getMemorySize() != null) {
                data.set("memorySize", om.valueToTree(this.getMemorySize()));
            }
            if (this.getPolicyStatements() != null) {
                data.set("policyStatements", om.valueToTree(this.getPolicyStatements()));
            }
            if (this.getTimeout() != null) {
                data.set("timeout", om.valueToTree(this.getTimeout()));
            }
            if (this.getUseCfnResponseWrapper() != null) {
                data.set("useCfnResponseWrapper", om.valueToTree(this.getUseCfnResponseWrapper()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.CustomResourceProviderBaseProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CustomResourceProviderBaseProps.Jsii$Proxy that = (CustomResourceProviderBaseProps.Jsii$Proxy) o;

            if (!codeDirectory.equals(that.codeDirectory)) return false;
            if (!runtimeName.equals(that.runtimeName)) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.environment != null ? !this.environment.equals(that.environment) : that.environment != null) return false;
            if (this.memorySize != null ? !this.memorySize.equals(that.memorySize) : that.memorySize != null) return false;
            if (this.policyStatements != null ? !this.policyStatements.equals(that.policyStatements) : that.policyStatements != null) return false;
            if (this.timeout != null ? !this.timeout.equals(that.timeout) : that.timeout != null) return false;
            return this.useCfnResponseWrapper != null ? this.useCfnResponseWrapper.equals(that.useCfnResponseWrapper) : that.useCfnResponseWrapper == null;
        }

        @Override
        public final int hashCode() {
            int result = this.codeDirectory.hashCode();
            result = 31 * result + (this.runtimeName.hashCode());
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.environment != null ? this.environment.hashCode() : 0);
            result = 31 * result + (this.memorySize != null ? this.memorySize.hashCode() : 0);
            result = 31 * result + (this.policyStatements != null ? this.policyStatements.hashCode() : 0);
            result = 31 * result + (this.timeout != null ? this.timeout.hashCode() : 0);
            result = 31 * result + (this.useCfnResponseWrapper != null ? this.useCfnResponseWrapper.hashCode() : 0);
            return result;
        }
    }
}
