package software.amazon.awscdk;

/**
 * Methods to build Docker CLI arguments for builds using secrets.
 * <p>
 * Docker BuildKit must be enabled to use build secrets.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.*;
 * DockerBuildSecret dockerBuildSecret = new DockerBuildSecret();
 * </pre></blockquote>
 * <p>
 * @see <a href="https://docs.docker.com/build/buildkit/">https://docs.docker.com/build/buildkit/</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-08-06T18:14:31.132Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.DockerBuildSecret")
public class DockerBuildSecret extends software.amazon.jsii.JsiiObject {

    protected DockerBuildSecret(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected DockerBuildSecret(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public DockerBuildSecret() {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this);
    }

    /**
     * A Docker build secret from a file source.
     * <p>
     * @return The latter half required for <code>--secret</code>
     * @param src The path to the source file, relative to the build directory. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String fromSrc(final @org.jetbrains.annotations.NotNull java.lang.String src) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.DockerBuildSecret.class, "fromSrc", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { java.util.Objects.requireNonNull(src, "src is required") });
    }
}
