package software.amazon.awscdk;

/**
 * A CloudFormation nested stack.
 * <p>
 * When you apply template changes to update a top-level stack, CloudFormation
 * updates the top-level stack and initiates an update to its nested stacks.
 * CloudFormation updates the resources of modified nested stacks, but does not
 * update the resources of unmodified nested stacks.
 * <p>
 * Furthermore, this stack will not be treated as an independent deployment
 * artifact (won't be listed in "cdk list" or deployable through "cdk deploy"),
 * but rather only synthesized as a template and uploaded as an asset to S3.
 * <p>
 * Cross references of resource attributes between the parent stack and the
 * nested stack will automatically be translated to stack parameters and
 * outputs.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.*;
 * import software.amazon.awscdk.customresources.CustomResourceConfig;
 * import software.amazon.awscdk.services.s3.deployment.*;
 * App app = new App();
 * Stack stack = new Stack(app, "Stack");
 * CustomResourceConfig.of(app).addLogRetentionLifetime(RetentionDays.TEN_YEARS);
 * NestedStack nestedStackA = new NestedStack(stack, "NestedStackA");
 * Bucket websiteBucketA = Bucket.Builder.create(nestedStackA, "WebsiteBucketA").build();
 * BucketDeployment.Builder.create(nestedStackA, "s3deployA")
 *         .sources(List.of(Source.jsonData("file.json", Map.of("a", "b"))))
 *         .destinationBucket(websiteBucketA)
 *         .logRetention(RetentionDays.ONE_DAY)
 *         .build();
 * NestedStack nestedStackB = new NestedStack(stack, "NestedStackB");
 * Bucket websiteBucketB = Bucket.Builder.create(nestedStackB, "WebsiteBucketB").build();
 * BucketDeployment.Builder.create(nestedStackB, "s3deployB")
 *         .sources(List.of(Source.jsonData("file.json", Map.of("a", "b"))))
 *         .destinationBucket(websiteBucketB)
 *         .logRetention(RetentionDays.ONE_DAY)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-08-06T18:14:31.177Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.NestedStack")
public class NestedStack extends software.amazon.awscdk.Stack {

    protected NestedStack(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected NestedStack(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public NestedStack(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.NestedStackProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public NestedStack(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Checks if <code>x</code> is an object of type <code>NestedStack</code>.
     * <p>
     * @param x This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.Boolean isNestedStack(final @org.jetbrains.annotations.NotNull java.lang.Object x) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.NestedStack.class, "isNestedStack", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class), new Object[] { x });
    }

    /**
     * Assign a value to one of the nested stack parameters.
     * <p>
     * @param name The parameter name (ID). This parameter is required.
     * @param value The value to assign. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setParameter(final @org.jetbrains.annotations.NotNull java.lang.String name, final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.call(this, "setParameter", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(name, "name is required"), java.util.Objects.requireNonNull(value, "value is required") });
    }

    /**
     * Indicates whether the stack requires bundling or not.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Boolean getBundlingRequired() {
        return software.amazon.jsii.Kernel.get(this, "bundlingRequired", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
    }

    /**
     * An attribute that represents the ID of the stack.
     * <p>
     * This is a context aware attribute:
     * <p>
     * <ul>
     * <li>If this is referenced from the parent stack, it will return <code>{ "Ref": "LogicalIdOfNestedStackResource" }</code>.</li>
     * <li>If this is referenced from the context of the nested stack, it will return <code>{ "Ref": "AWS::StackId" }</code></li>
     * </ul>
     * <p>
     * Example value: <code>arn:aws:cloudformation:us-east-2:123456789012:stack/mystack-mynestedstack-sggfrhxhum7w/f449b250-b969-11e0-a185-5081d0136786</code>
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getStackId() {
        return software.amazon.jsii.Kernel.get(this, "stackId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * An attribute that represents the name of the nested stack.
     * <p>
     * This is a context aware attribute:
     * <p>
     * <ul>
     * <li>If this is referenced from the parent stack, it will return a token that parses the name from the stack ID.</li>
     * <li>If this is referenced from the context of the nested stack, it will return <code>{ "Ref": "AWS::StackName" }</code></li>
     * </ul>
     * <p>
     * Example value: <code>mystack-mynestedstack-sggfrhxhum7w</code>
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getStackName() {
        return software.amazon.jsii.Kernel.get(this, "stackName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the CloudFormation template file emitted to the output directory during synthesis.
     * <p>
     * Example value: <code>MyStack.template.json</code>
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getTemplateFile() {
        return software.amazon.jsii.Kernel.get(this, "templateFile", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * If this is a nested stack, this represents its <code>AWS::CloudFormation::Stack</code> resource.
     * <p>
     * <code>undefined</code> for top-level (non-nested) stacks.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.CfnResource getNestedStackResource() {
        return software.amazon.jsii.Kernel.get(this, "nestedStackResource", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnResource.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.NestedStack}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.NestedStack> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.NestedStackProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * A description of the stack.
         * <p>
         * Default: - No description.
         * <p>
         * @return {@code this}
         * @param description A description of the stack. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props().description(description);
            return this;
        }

        /**
         * The Simple Notification Service (SNS) topics to publish stack related events.
         * <p>
         * Default: - notifications are not sent for this stack.
         * <p>
         * @return {@code this}
         * @param notificationArns The Simple Notification Service (SNS) topics to publish stack related events. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder notificationArns(final java.util.List<java.lang.String> notificationArns) {
            this.props().notificationArns(notificationArns);
            return this;
        }

        /**
         * The set value pairs that represent the parameters passed to CloudFormation when this nested stack is created.
         * <p>
         * Each parameter has a name corresponding
         * to a parameter defined in the embedded template and a value representing
         * the value that you want to set for the parameter.
         * <p>
         * The nested stack construct will automatically synthesize parameters in order
         * to bind references from the parent stack(s) into the nested stack.
         * <p>
         * Default: - no user-defined parameters are passed to the nested stack
         * <p>
         * @return {@code this}
         * @param parameters The set value pairs that represent the parameters passed to CloudFormation when this nested stack is created. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder parameters(final java.util.Map<java.lang.String, java.lang.String> parameters) {
            this.props().parameters(parameters);
            return this;
        }

        /**
         * Policy to apply when the nested stack is removed.
         * <p>
         * The default is <code>Destroy</code>, because all Removal Policies of resources inside the
         * Nested Stack should already have been set correctly. You normally should
         * not need to set this value.
         * <p>
         * Default: RemovalPolicy.DESTROY
         * <p>
         * @return {@code this}
         * @param removalPolicy Policy to apply when the nested stack is removed. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder removalPolicy(final software.amazon.awscdk.RemovalPolicy removalPolicy) {
            this.props().removalPolicy(removalPolicy);
            return this;
        }

        /**
         * The length of time that CloudFormation waits for the nested stack to reach the CREATE_COMPLETE state.
         * <p>
         * When CloudFormation detects that the nested stack has reached the
         * CREATE_COMPLETE state, it marks the nested stack resource as
         * CREATE_COMPLETE in the parent stack and resumes creating the parent stack.
         * If the timeout period expires before the nested stack reaches
         * CREATE_COMPLETE, CloudFormation marks the nested stack as failed and rolls
         * back both the nested stack and parent stack.
         * <p>
         * Default: - no timeout
         * <p>
         * @return {@code this}
         * @param timeout The length of time that CloudFormation waits for the nested stack to reach the CREATE_COMPLETE state. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder timeout(final software.amazon.awscdk.Duration timeout) {
            this.props().timeout(timeout);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.NestedStack}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.NestedStack build() {
            return new software.amazon.awscdk.NestedStack(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.NestedStackProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.NestedStackProps.Builder();
            }
            return this.props;
        }
    }
}
