package software.amazon.awscdk;

/**
 * Properties for applying a removal policy.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.*;
 * RemovalPolicyProps removalPolicyProps = RemovalPolicyProps.builder()
 *         .applyToResourceTypes(List.of("applyToResourceTypes"))
 *         .excludeResourceTypes(List.of("excludeResourceTypes"))
 *         .priority(123)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-08-06T18:14:31.185Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.RemovalPolicyProps")
@software.amazon.jsii.Jsii.Proxy(RemovalPolicyProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface RemovalPolicyProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Apply the removal policy only to specific resource types.
     * <p>
     * Can be a CloudFormation resource type string (e.g., 'AWS::S3::Bucket').
     * <p>
     * Default: - apply to all resources
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getApplyToResourceTypes() {
        return null;
    }

    /**
     * Exclude specific resource types from the removal policy.
     * <p>
     * Can be a CloudFormation resource type string (e.g., 'AWS::S3::Bucket').
     * <p>
     * Default: - no exclusions
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getExcludeResourceTypes() {
        return null;
    }

    /**
     * The priority to use when applying this policy.
     * <p>
     * The priority affects only the order in which aspects are applied during synthesis.
     * For RemovalPolicies, the last applied policy will override previous ones.
     * <p>
     * NOTE: Priority does NOT determine which policy "wins" when there are conflicts.
     * The order of application determines the final policy, with later policies
     * overriding earlier ones.
     * <p>
     * Default: - AspectPriority.MUTATING
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getPriority() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link RemovalPolicyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link RemovalPolicyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<RemovalPolicyProps> {
        java.util.List<java.lang.String> applyToResourceTypes;
        java.util.List<java.lang.String> excludeResourceTypes;
        java.lang.Number priority;

        /**
         * Sets the value of {@link RemovalPolicyProps#getApplyToResourceTypes}
         * @param applyToResourceTypes Apply the removal policy only to specific resource types.
         *                             Can be a CloudFormation resource type string (e.g., 'AWS::S3::Bucket').
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder applyToResourceTypes(java.util.List<java.lang.String> applyToResourceTypes) {
            this.applyToResourceTypes = applyToResourceTypes;
            return this;
        }

        /**
         * Sets the value of {@link RemovalPolicyProps#getExcludeResourceTypes}
         * @param excludeResourceTypes Exclude specific resource types from the removal policy.
         *                             Can be a CloudFormation resource type string (e.g., 'AWS::S3::Bucket').
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder excludeResourceTypes(java.util.List<java.lang.String> excludeResourceTypes) {
            this.excludeResourceTypes = excludeResourceTypes;
            return this;
        }

        /**
         * Sets the value of {@link RemovalPolicyProps#getPriority}
         * @param priority The priority to use when applying this policy.
         *                 The priority affects only the order in which aspects are applied during synthesis.
         *                 For RemovalPolicies, the last applied policy will override previous ones.
         *                 <p>
         *                 NOTE: Priority does NOT determine which policy "wins" when there are conflicts.
         *                 The order of application determines the final policy, with later policies
         *                 overriding earlier ones.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder priority(java.lang.Number priority) {
            this.priority = priority;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link RemovalPolicyProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public RemovalPolicyProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link RemovalPolicyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RemovalPolicyProps {
        private final java.util.List<java.lang.String> applyToResourceTypes;
        private final java.util.List<java.lang.String> excludeResourceTypes;
        private final java.lang.Number priority;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.applyToResourceTypes = software.amazon.jsii.Kernel.get(this, "applyToResourceTypes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.excludeResourceTypes = software.amazon.jsii.Kernel.get(this, "excludeResourceTypes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.priority = software.amazon.jsii.Kernel.get(this, "priority", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.applyToResourceTypes = builder.applyToResourceTypes;
            this.excludeResourceTypes = builder.excludeResourceTypes;
            this.priority = builder.priority;
        }

        @Override
        public final java.util.List<java.lang.String> getApplyToResourceTypes() {
            return this.applyToResourceTypes;
        }

        @Override
        public final java.util.List<java.lang.String> getExcludeResourceTypes() {
            return this.excludeResourceTypes;
        }

        @Override
        public final java.lang.Number getPriority() {
            return this.priority;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getApplyToResourceTypes() != null) {
                data.set("applyToResourceTypes", om.valueToTree(this.getApplyToResourceTypes()));
            }
            if (this.getExcludeResourceTypes() != null) {
                data.set("excludeResourceTypes", om.valueToTree(this.getExcludeResourceTypes()));
            }
            if (this.getPriority() != null) {
                data.set("priority", om.valueToTree(this.getPriority()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.RemovalPolicyProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            RemovalPolicyProps.Jsii$Proxy that = (RemovalPolicyProps.Jsii$Proxy) o;

            if (this.applyToResourceTypes != null ? !this.applyToResourceTypes.equals(that.applyToResourceTypes) : that.applyToResourceTypes != null) return false;
            if (this.excludeResourceTypes != null ? !this.excludeResourceTypes.equals(that.excludeResourceTypes) : that.excludeResourceTypes != null) return false;
            return this.priority != null ? this.priority.equals(that.priority) : that.priority == null;
        }

        @Override
        public final int hashCode() {
            int result = this.applyToResourceTypes != null ? this.applyToResourceTypes.hashCode() : 0;
            result = 31 * result + (this.excludeResourceTypes != null ? this.excludeResourceTypes.hashCode() : 0);
            result = 31 * result + (this.priority != null ? this.priority.hashCode() : 0);
            return result;
        }
    }
}
