package software.amazon.awscdk.aws_apigatewayv2_authorizers;

/**
 * Properties to initialize HttpUserPoolAuthorizer.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.aws_apigatewayv2_authorizers.*;
 * import software.amazon.awscdk.services.cognito.*;
 * UserPoolClient userPoolClient;
 * HttpUserPoolAuthorizerProps httpUserPoolAuthorizerProps = HttpUserPoolAuthorizerProps.builder()
 *         .authorizerName("authorizerName")
 *         .identitySource(List.of("identitySource"))
 *         .userPoolClients(List.of(userPoolClient))
 *         .userPoolRegion("userPoolRegion")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-08-06T18:14:31.828Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_apigatewayv2_authorizers.HttpUserPoolAuthorizerProps")
@software.amazon.jsii.Jsii.Proxy(HttpUserPoolAuthorizerProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface HttpUserPoolAuthorizerProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Friendly name of the authorizer.
     * <p>
     * Default: - same value as `id` passed in the constructor
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAuthorizerName() {
        return null;
    }

    /**
     * The identity source for which authorization is requested.
     * <p>
     * Default: ['$request.header.Authorization']
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getIdentitySource() {
        return null;
    }

    /**
     * The user pool clients that should be used to authorize requests with the user pool.
     * <p>
     * Default: - a new client will be created for the given user pool
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.cognito.IUserPoolClient> getUserPoolClients() {
        return null;
    }

    /**
     * The AWS region in which the user pool is present.
     * <p>
     * Default: - same region as the Route the authorizer is attached to.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getUserPoolRegion() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link HttpUserPoolAuthorizerProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link HttpUserPoolAuthorizerProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<HttpUserPoolAuthorizerProps> {
        java.lang.String authorizerName;
        java.util.List<java.lang.String> identitySource;
        java.util.List<software.amazon.awscdk.services.cognito.IUserPoolClient> userPoolClients;
        java.lang.String userPoolRegion;

        /**
         * Sets the value of {@link HttpUserPoolAuthorizerProps#getAuthorizerName}
         * @param authorizerName Friendly name of the authorizer.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder authorizerName(java.lang.String authorizerName) {
            this.authorizerName = authorizerName;
            return this;
        }

        /**
         * Sets the value of {@link HttpUserPoolAuthorizerProps#getIdentitySource}
         * @param identitySource The identity source for which authorization is requested.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder identitySource(java.util.List<java.lang.String> identitySource) {
            this.identitySource = identitySource;
            return this;
        }

        /**
         * Sets the value of {@link HttpUserPoolAuthorizerProps#getUserPoolClients}
         * @param userPoolClients The user pool clients that should be used to authorize requests with the user pool.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder userPoolClients(java.util.List<? extends software.amazon.awscdk.services.cognito.IUserPoolClient> userPoolClients) {
            this.userPoolClients = (java.util.List<software.amazon.awscdk.services.cognito.IUserPoolClient>)userPoolClients;
            return this;
        }

        /**
         * Sets the value of {@link HttpUserPoolAuthorizerProps#getUserPoolRegion}
         * @param userPoolRegion The AWS region in which the user pool is present.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder userPoolRegion(java.lang.String userPoolRegion) {
            this.userPoolRegion = userPoolRegion;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link HttpUserPoolAuthorizerProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public HttpUserPoolAuthorizerProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link HttpUserPoolAuthorizerProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements HttpUserPoolAuthorizerProps {
        private final java.lang.String authorizerName;
        private final java.util.List<java.lang.String> identitySource;
        private final java.util.List<software.amazon.awscdk.services.cognito.IUserPoolClient> userPoolClients;
        private final java.lang.String userPoolRegion;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.authorizerName = software.amazon.jsii.Kernel.get(this, "authorizerName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.identitySource = software.amazon.jsii.Kernel.get(this, "identitySource", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.userPoolClients = software.amazon.jsii.Kernel.get(this, "userPoolClients", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.IUserPoolClient.class)));
            this.userPoolRegion = software.amazon.jsii.Kernel.get(this, "userPoolRegion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.authorizerName = builder.authorizerName;
            this.identitySource = builder.identitySource;
            this.userPoolClients = (java.util.List<software.amazon.awscdk.services.cognito.IUserPoolClient>)builder.userPoolClients;
            this.userPoolRegion = builder.userPoolRegion;
        }

        @Override
        public final java.lang.String getAuthorizerName() {
            return this.authorizerName;
        }

        @Override
        public final java.util.List<java.lang.String> getIdentitySource() {
            return this.identitySource;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.cognito.IUserPoolClient> getUserPoolClients() {
            return this.userPoolClients;
        }

        @Override
        public final java.lang.String getUserPoolRegion() {
            return this.userPoolRegion;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getAuthorizerName() != null) {
                data.set("authorizerName", om.valueToTree(this.getAuthorizerName()));
            }
            if (this.getIdentitySource() != null) {
                data.set("identitySource", om.valueToTree(this.getIdentitySource()));
            }
            if (this.getUserPoolClients() != null) {
                data.set("userPoolClients", om.valueToTree(this.getUserPoolClients()));
            }
            if (this.getUserPoolRegion() != null) {
                data.set("userPoolRegion", om.valueToTree(this.getUserPoolRegion()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_apigatewayv2_authorizers.HttpUserPoolAuthorizerProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            HttpUserPoolAuthorizerProps.Jsii$Proxy that = (HttpUserPoolAuthorizerProps.Jsii$Proxy) o;

            if (this.authorizerName != null ? !this.authorizerName.equals(that.authorizerName) : that.authorizerName != null) return false;
            if (this.identitySource != null ? !this.identitySource.equals(that.identitySource) : that.identitySource != null) return false;
            if (this.userPoolClients != null ? !this.userPoolClients.equals(that.userPoolClients) : that.userPoolClients != null) return false;
            return this.userPoolRegion != null ? this.userPoolRegion.equals(that.userPoolRegion) : that.userPoolRegion == null;
        }

        @Override
        public final int hashCode() {
            int result = this.authorizerName != null ? this.authorizerName.hashCode() : 0;
            result = 31 * result + (this.identitySource != null ? this.identitySource.hashCode() : 0);
            result = 31 * result + (this.userPoolClients != null ? this.userPoolClients.hashCode() : 0);
            result = 31 * result + (this.userPoolRegion != null ? this.userPoolRegion.hashCode() : 0);
            return result;
        }
    }
}
