package software.amazon.awscdk.services.acmpca;

/**
 * Properties for defining a <code>CfnPermission</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.acmpca.*;
 * CfnPermissionProps cfnPermissionProps = CfnPermissionProps.builder()
 *         .actions(List.of("actions"))
 *         .certificateAuthorityArn("certificateAuthorityArn")
 *         .principal("principal")
 *         // the properties below are optional
 *         .sourceAccount("sourceAccount")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-acmpca-permission.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-acmpca-permission.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-08-06T18:14:31.312Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_acmpca.CfnPermissionProps")
@software.amazon.jsii.Jsii.Proxy(CfnPermissionProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnPermissionProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The private CA actions that can be performed by the designated AWS service.
     * <p>
     * Supported actions are <code>IssueCertificate</code> , <code>GetCertificate</code> , and <code>ListPermissions</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-acmpca-permission.html#cfn-acmpca-permission-actions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-acmpca-permission.html#cfn-acmpca-permission-actions</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getActions();

    /**
     * The Amazon Resource Number (ARN) of the private CA from which the permission was issued.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-acmpca-permission.html#cfn-acmpca-permission-certificateauthorityarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-acmpca-permission.html#cfn-acmpca-permission-certificateauthorityarn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getCertificateAuthorityArn();

    /**
     * The AWS service or entity that holds the permission.
     * <p>
     * At this time, the only valid principal is <code>acm.amazonaws.com</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-acmpca-permission.html#cfn-acmpca-permission-principal">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-acmpca-permission.html#cfn-acmpca-permission-principal</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getPrincipal();

    /**
     * The ID of the account that assigned the permission.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-acmpca-permission.html#cfn-acmpca-permission-sourceaccount">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-acmpca-permission.html#cfn-acmpca-permission-sourceaccount</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getSourceAccount() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnPermissionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnPermissionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnPermissionProps> {
        java.util.List<java.lang.String> actions;
        java.lang.String certificateAuthorityArn;
        java.lang.String principal;
        java.lang.String sourceAccount;

        /**
         * Sets the value of {@link CfnPermissionProps#getActions}
         * @param actions The private CA actions that can be performed by the designated AWS service. This parameter is required.
         *                Supported actions are <code>IssueCertificate</code> , <code>GetCertificate</code> , and <code>ListPermissions</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder actions(java.util.List<java.lang.String> actions) {
            this.actions = actions;
            return this;
        }

        /**
         * Sets the value of {@link CfnPermissionProps#getCertificateAuthorityArn}
         * @param certificateAuthorityArn The Amazon Resource Number (ARN) of the private CA from which the permission was issued. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder certificateAuthorityArn(java.lang.String certificateAuthorityArn) {
            this.certificateAuthorityArn = certificateAuthorityArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnPermissionProps#getPrincipal}
         * @param principal The AWS service or entity that holds the permission. This parameter is required.
         *                  At this time, the only valid principal is <code>acm.amazonaws.com</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder principal(java.lang.String principal) {
            this.principal = principal;
            return this;
        }

        /**
         * Sets the value of {@link CfnPermissionProps#getSourceAccount}
         * @param sourceAccount The ID of the account that assigned the permission.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourceAccount(java.lang.String sourceAccount) {
            this.sourceAccount = sourceAccount;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnPermissionProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnPermissionProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnPermissionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnPermissionProps {
        private final java.util.List<java.lang.String> actions;
        private final java.lang.String certificateAuthorityArn;
        private final java.lang.String principal;
        private final java.lang.String sourceAccount;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.actions = software.amazon.jsii.Kernel.get(this, "actions", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.certificateAuthorityArn = software.amazon.jsii.Kernel.get(this, "certificateAuthorityArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.principal = software.amazon.jsii.Kernel.get(this, "principal", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.sourceAccount = software.amazon.jsii.Kernel.get(this, "sourceAccount", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.actions = java.util.Objects.requireNonNull(builder.actions, "actions is required");
            this.certificateAuthorityArn = java.util.Objects.requireNonNull(builder.certificateAuthorityArn, "certificateAuthorityArn is required");
            this.principal = java.util.Objects.requireNonNull(builder.principal, "principal is required");
            this.sourceAccount = builder.sourceAccount;
        }

        @Override
        public final java.util.List<java.lang.String> getActions() {
            return this.actions;
        }

        @Override
        public final java.lang.String getCertificateAuthorityArn() {
            return this.certificateAuthorityArn;
        }

        @Override
        public final java.lang.String getPrincipal() {
            return this.principal;
        }

        @Override
        public final java.lang.String getSourceAccount() {
            return this.sourceAccount;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("actions", om.valueToTree(this.getActions()));
            data.set("certificateAuthorityArn", om.valueToTree(this.getCertificateAuthorityArn()));
            data.set("principal", om.valueToTree(this.getPrincipal()));
            if (this.getSourceAccount() != null) {
                data.set("sourceAccount", om.valueToTree(this.getSourceAccount()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_acmpca.CfnPermissionProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnPermissionProps.Jsii$Proxy that = (CfnPermissionProps.Jsii$Proxy) o;

            if (!actions.equals(that.actions)) return false;
            if (!certificateAuthorityArn.equals(that.certificateAuthorityArn)) return false;
            if (!principal.equals(that.principal)) return false;
            return this.sourceAccount != null ? this.sourceAccount.equals(that.sourceAccount) : that.sourceAccount == null;
        }

        @Override
        public final int hashCode() {
            int result = this.actions.hashCode();
            result = 31 * result + (this.certificateAuthorityArn.hashCode());
            result = 31 * result + (this.principal.hashCode());
            result = 31 * result + (this.sourceAccount != null ? this.sourceAccount.hashCode() : 0);
            return result;
        }
    }
}
