package software.amazon.awscdk.services.apigateway;

/**
 * Example:
 * <p>
 * <blockquote><pre>
 * RestApi api;
 * // We define the JSON Schema for the transformed valid response
 * Model responseModel = api.addModel("ResponseModel", ModelOptions.builder()
 *         .contentType("application/json")
 *         .modelName("ResponseModel")
 *         .schema(JsonSchema.builder()
 *                 .schema(JsonSchemaVersion.DRAFT4)
 *                 .title("pollResponse")
 *                 .type(JsonSchemaType.OBJECT)
 *                 .properties(Map.of(
 *                         "state", JsonSchema.builder().type(JsonSchemaType.STRING).build(),
 *                         "greeting", JsonSchema.builder().type(JsonSchemaType.STRING).build()))
 *                 .build())
 *         .build());
 * // We define the JSON Schema for the transformed error response
 * Model errorResponseModel = api.addModel("ErrorResponseModel", ModelOptions.builder()
 *         .contentType("application/json")
 *         .modelName("ErrorResponseModel")
 *         .schema(JsonSchema.builder()
 *                 .schema(JsonSchemaVersion.DRAFT4)
 *                 .title("errorResponse")
 *                 .type(JsonSchemaType.OBJECT)
 *                 .properties(Map.of(
 *                         "state", JsonSchema.builder().type(JsonSchemaType.STRING).build(),
 *                         "message", JsonSchema.builder().type(JsonSchemaType.STRING).build()))
 *                 .build())
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-08-06T18:14:31.602Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_apigateway.ModelOptions")
@software.amazon.jsii.Jsii.Proxy(ModelOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ModelOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * The schema to use to transform data to one or more output formats.
     * <p>
     * Specify null ({}) if you don't want to specify a schema.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigateway.JsonSchema getSchema();

    /**
     * The content type for the model.
     * <p>
     * You can also force a
     * content type in the request or response model mapping.
     * <p>
     * Default: 'application/json'
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getContentType() {
        return null;
    }

    /**
     * A description that identifies this model.
     * <p>
     * Default: None
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * A name for the model.
     * <p>
     * Important
     * If you specify a name, you cannot perform updates that
     * require replacement of this resource. You can perform
     * updates that require no or some interruption. If you
     * must replace the resource, specify a new name.
     * <p>
     * Default: <auto> If you don't specify a name,
     * AWS CloudFormation generates a unique physical ID and
     * uses that ID for the model name. For more information,
     * see Name Type.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getModelName() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link ModelOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ModelOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ModelOptions> {
        software.amazon.awscdk.services.apigateway.JsonSchema schema;
        java.lang.String contentType;
        java.lang.String description;
        java.lang.String modelName;

        /**
         * Sets the value of {@link ModelOptions#getSchema}
         * @param schema The schema to use to transform data to one or more output formats. This parameter is required.
         *               Specify null ({}) if you don't want to specify a schema.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder schema(software.amazon.awscdk.services.apigateway.JsonSchema schema) {
            this.schema = schema;
            return this;
        }

        /**
         * Sets the value of {@link ModelOptions#getContentType}
         * @param contentType The content type for the model.
         *                    You can also force a
         *                    content type in the request or response model mapping.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder contentType(java.lang.String contentType) {
            this.contentType = contentType;
            return this;
        }

        /**
         * Sets the value of {@link ModelOptions#getDescription}
         * @param description A description that identifies this model.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link ModelOptions#getModelName}
         * @param modelName A name for the model.
         *                  Important
         *                  If you specify a name, you cannot perform updates that
         *                  require replacement of this resource. You can perform
         *                  updates that require no or some interruption. If you
         *                  must replace the resource, specify a new name.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder modelName(java.lang.String modelName) {
            this.modelName = modelName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ModelOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ModelOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ModelOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ModelOptions {
        private final software.amazon.awscdk.services.apigateway.JsonSchema schema;
        private final java.lang.String contentType;
        private final java.lang.String description;
        private final java.lang.String modelName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.schema = software.amazon.jsii.Kernel.get(this, "schema", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigateway.JsonSchema.class));
            this.contentType = software.amazon.jsii.Kernel.get(this, "contentType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.modelName = software.amazon.jsii.Kernel.get(this, "modelName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.schema = java.util.Objects.requireNonNull(builder.schema, "schema is required");
            this.contentType = builder.contentType;
            this.description = builder.description;
            this.modelName = builder.modelName;
        }

        @Override
        public final software.amazon.awscdk.services.apigateway.JsonSchema getSchema() {
            return this.schema;
        }

        @Override
        public final java.lang.String getContentType() {
            return this.contentType;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.String getModelName() {
            return this.modelName;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("schema", om.valueToTree(this.getSchema()));
            if (this.getContentType() != null) {
                data.set("contentType", om.valueToTree(this.getContentType()));
            }
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getModelName() != null) {
                data.set("modelName", om.valueToTree(this.getModelName()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_apigateway.ModelOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ModelOptions.Jsii$Proxy that = (ModelOptions.Jsii$Proxy) o;

            if (!schema.equals(that.schema)) return false;
            if (this.contentType != null ? !this.contentType.equals(that.contentType) : that.contentType != null) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            return this.modelName != null ? this.modelName.equals(that.modelName) : that.modelName == null;
        }

        @Override
        public final int hashCode() {
            int result = this.schema.hashCode();
            result = 31 * result + (this.contentType != null ? this.contentType.hashCode() : 0);
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.modelName != null ? this.modelName.hashCode() : 0);
            return result;
        }
    }
}
