package software.amazon.awscdk.services.apigatewayv2;

/**
 * Properties for defining a <code>CfnAuthorizer</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.apigatewayv2.*;
 * CfnAuthorizerProps cfnAuthorizerProps = CfnAuthorizerProps.builder()
 *         .apiId("apiId")
 *         .authorizerType("authorizerType")
 *         .name("name")
 *         // the properties below are optional
 *         .authorizerCredentialsArn("authorizerCredentialsArn")
 *         .authorizerPayloadFormatVersion("authorizerPayloadFormatVersion")
 *         .authorizerResultTtlInSeconds(123)
 *         .authorizerUri("authorizerUri")
 *         .enableSimpleResponses(false)
 *         .identitySource(List.of("identitySource"))
 *         .identityValidationExpression("identityValidationExpression")
 *         .jwtConfiguration(JWTConfigurationProperty.builder()
 *                 .audience(List.of("audience"))
 *                 .issuer("issuer")
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-authorizer.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-authorizer.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-08-06T18:14:31.709Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_apigatewayv2.CfnAuthorizerProps")
@software.amazon.jsii.Jsii.Proxy(CfnAuthorizerProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnAuthorizerProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The API identifier.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-authorizer.html#cfn-apigatewayv2-authorizer-apiid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-authorizer.html#cfn-apigatewayv2-authorizer-apiid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getApiId();

    /**
     * The authorizer type.
     * <p>
     * Specify <code>REQUEST</code> for a Lambda function using incoming request parameters. Specify <code>JWT</code> to use JSON Web Tokens (supported only for HTTP APIs).
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-authorizer.html#cfn-apigatewayv2-authorizer-authorizertype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-authorizer.html#cfn-apigatewayv2-authorizer-authorizertype</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getAuthorizerType();

    /**
     * The name of the authorizer.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-authorizer.html#cfn-apigatewayv2-authorizer-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-authorizer.html#cfn-apigatewayv2-authorizer-name</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getName();

    /**
     * Specifies the required credentials as an IAM role for API Gateway to invoke the authorizer.
     * <p>
     * To specify an IAM role for API Gateway to assume, use the role's Amazon Resource Name (ARN). To use resource-based permissions on the Lambda function, specify null. Supported only for <code>REQUEST</code> authorizers.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-authorizer.html#cfn-apigatewayv2-authorizer-authorizercredentialsarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-authorizer.html#cfn-apigatewayv2-authorizer-authorizercredentialsarn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAuthorizerCredentialsArn() {
        return null;
    }

    /**
     * Specifies the format of the payload sent to an HTTP API Lambda authorizer.
     * <p>
     * Required for HTTP API Lambda authorizers. Supported values are <code>1.0</code> and <code>2.0</code> . To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-lambda-authorizer.html">Working with AWS Lambda authorizers for HTTP APIs</a> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-authorizer.html#cfn-apigatewayv2-authorizer-authorizerpayloadformatversion">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-authorizer.html#cfn-apigatewayv2-authorizer-authorizerpayloadformatversion</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAuthorizerPayloadFormatVersion() {
        return null;
    }

    /**
     * The time to live (TTL) for cached authorizer results, in seconds.
     * <p>
     * If it equals 0, authorization caching is disabled. If it is greater than 0, API Gateway caches authorizer responses. The maximum value is 3600, or 1 hour. Supported only for HTTP API Lambda authorizers.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-authorizer.html#cfn-apigatewayv2-authorizer-authorizerresultttlinseconds">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-authorizer.html#cfn-apigatewayv2-authorizer-authorizerresultttlinseconds</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getAuthorizerResultTtlInSeconds() {
        return null;
    }

    /**
     * The authorizer's Uniform Resource Identifier (URI).
     * <p>
     * For <code>REQUEST</code> authorizers, this must be a well-formed Lambda function URI, for example, <code>arn:aws:apigateway:us-west-2:lambda:path/2015-03-31/functions/arn:aws:lambda:us-west-2: *{account_id}* :function: *{lambda_function_name}* /invocations</code> . In general, the URI has this form: <code>arn:aws:apigateway: *{region}* :lambda:path/ *{service_api}*</code> , where <em>{region}</em> is the same as the region hosting the Lambda function, path indicates that the remaining substring in the URI should be treated as the path to the resource, including the initial <code>/</code> . For Lambda functions, this is usually of the form <code>/2015-03-31/functions/[FunctionARN]/invocations</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-authorizer.html#cfn-apigatewayv2-authorizer-authorizeruri">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-authorizer.html#cfn-apigatewayv2-authorizer-authorizeruri</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAuthorizerUri() {
        return null;
    }

    /**
     * Specifies whether a Lambda authorizer returns a response in a simple format.
     * <p>
     * By default, a Lambda authorizer must return an IAM policy. If enabled, the Lambda authorizer can return a boolean value instead of an IAM policy. Supported only for HTTP APIs. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-lambda-authorizer.html">Working with AWS Lambda authorizers for HTTP APIs</a> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-authorizer.html#cfn-apigatewayv2-authorizer-enablesimpleresponses">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-authorizer.html#cfn-apigatewayv2-authorizer-enablesimpleresponses</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getEnableSimpleResponses() {
        return null;
    }

    /**
     * The identity source for which authorization is requested.
     * <p>
     * For a <code>REQUEST</code> authorizer, this is optional. The value is a set of one or more mapping expressions of the specified request parameters. The identity source can be headers, query string parameters, stage variables, and context parameters. For example, if an Auth header and a Name query string parameter are defined as identity sources, this value is route.request.header.Auth, route.request.querystring.Name for WebSocket APIs. For HTTP APIs, use selection expressions prefixed with <code>$</code> , for example, <code>$request.header.Auth</code> , <code>$request.querystring.Name</code> . These parameters are used to perform runtime validation for Lambda-based authorizers by verifying all of the identity-related request parameters are present in the request, not null, and non-empty. Only when this is true does the authorizer invoke the authorizer Lambda function. Otherwise, it returns a 401 Unauthorized response without calling the Lambda function. For HTTP APIs, identity sources are also used as the cache key when caching is enabled. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-lambda-authorizer.html">Working with AWS Lambda authorizers for HTTP APIs</a> .
     * <p>
     * For <code>JWT</code> , a single entry that specifies where to extract the JSON Web Token (JWT) from inbound requests. Currently only header-based and query parameter-based selections are supported, for example <code>$request.header.Authorization</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-authorizer.html#cfn-apigatewayv2-authorizer-identitysource">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-authorizer.html#cfn-apigatewayv2-authorizer-identitysource</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getIdentitySource() {
        return null;
    }

    /**
     * This parameter is not used.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-authorizer.html#cfn-apigatewayv2-authorizer-identityvalidationexpression">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-authorizer.html#cfn-apigatewayv2-authorizer-identityvalidationexpression</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getIdentityValidationExpression() {
        return null;
    }

    /**
     * The <code>JWTConfiguration</code> property specifies the configuration of a JWT authorizer.
     * <p>
     * Required for the <code>JWT</code> authorizer type. Supported only for HTTP APIs.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-authorizer.html#cfn-apigatewayv2-authorizer-jwtconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-authorizer.html#cfn-apigatewayv2-authorizer-jwtconfiguration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getJwtConfiguration() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnAuthorizerProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnAuthorizerProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnAuthorizerProps> {
        java.lang.String apiId;
        java.lang.String authorizerType;
        java.lang.String name;
        java.lang.String authorizerCredentialsArn;
        java.lang.String authorizerPayloadFormatVersion;
        java.lang.Number authorizerResultTtlInSeconds;
        java.lang.String authorizerUri;
        java.lang.Object enableSimpleResponses;
        java.util.List<java.lang.String> identitySource;
        java.lang.String identityValidationExpression;
        java.lang.Object jwtConfiguration;

        /**
         * Sets the value of {@link CfnAuthorizerProps#getApiId}
         * @param apiId The API identifier. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder apiId(java.lang.String apiId) {
            this.apiId = apiId;
            return this;
        }

        /**
         * Sets the value of {@link CfnAuthorizerProps#getAuthorizerType}
         * @param authorizerType The authorizer type. This parameter is required.
         *                       Specify <code>REQUEST</code> for a Lambda function using incoming request parameters. Specify <code>JWT</code> to use JSON Web Tokens (supported only for HTTP APIs).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder authorizerType(java.lang.String authorizerType) {
            this.authorizerType = authorizerType;
            return this;
        }

        /**
         * Sets the value of {@link CfnAuthorizerProps#getName}
         * @param name The name of the authorizer. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnAuthorizerProps#getAuthorizerCredentialsArn}
         * @param authorizerCredentialsArn Specifies the required credentials as an IAM role for API Gateway to invoke the authorizer.
         *                                 To specify an IAM role for API Gateway to assume, use the role's Amazon Resource Name (ARN). To use resource-based permissions on the Lambda function, specify null. Supported only for <code>REQUEST</code> authorizers.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder authorizerCredentialsArn(java.lang.String authorizerCredentialsArn) {
            this.authorizerCredentialsArn = authorizerCredentialsArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnAuthorizerProps#getAuthorizerPayloadFormatVersion}
         * @param authorizerPayloadFormatVersion Specifies the format of the payload sent to an HTTP API Lambda authorizer.
         *                                       Required for HTTP API Lambda authorizers. Supported values are <code>1.0</code> and <code>2.0</code> . To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-lambda-authorizer.html">Working with AWS Lambda authorizers for HTTP APIs</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder authorizerPayloadFormatVersion(java.lang.String authorizerPayloadFormatVersion) {
            this.authorizerPayloadFormatVersion = authorizerPayloadFormatVersion;
            return this;
        }

        /**
         * Sets the value of {@link CfnAuthorizerProps#getAuthorizerResultTtlInSeconds}
         * @param authorizerResultTtlInSeconds The time to live (TTL) for cached authorizer results, in seconds.
         *                                     If it equals 0, authorization caching is disabled. If it is greater than 0, API Gateway caches authorizer responses. The maximum value is 3600, or 1 hour. Supported only for HTTP API Lambda authorizers.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder authorizerResultTtlInSeconds(java.lang.Number authorizerResultTtlInSeconds) {
            this.authorizerResultTtlInSeconds = authorizerResultTtlInSeconds;
            return this;
        }

        /**
         * Sets the value of {@link CfnAuthorizerProps#getAuthorizerUri}
         * @param authorizerUri The authorizer's Uniform Resource Identifier (URI).
         *                      For <code>REQUEST</code> authorizers, this must be a well-formed Lambda function URI, for example, <code>arn:aws:apigateway:us-west-2:lambda:path/2015-03-31/functions/arn:aws:lambda:us-west-2: *{account_id}* :function: *{lambda_function_name}* /invocations</code> . In general, the URI has this form: <code>arn:aws:apigateway: *{region}* :lambda:path/ *{service_api}*</code> , where <em>{region}</em> is the same as the region hosting the Lambda function, path indicates that the remaining substring in the URI should be treated as the path to the resource, including the initial <code>/</code> . For Lambda functions, this is usually of the form <code>/2015-03-31/functions/[FunctionARN]/invocations</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder authorizerUri(java.lang.String authorizerUri) {
            this.authorizerUri = authorizerUri;
            return this;
        }

        /**
         * Sets the value of {@link CfnAuthorizerProps#getEnableSimpleResponses}
         * @param enableSimpleResponses Specifies whether a Lambda authorizer returns a response in a simple format.
         *                              By default, a Lambda authorizer must return an IAM policy. If enabled, the Lambda authorizer can return a boolean value instead of an IAM policy. Supported only for HTTP APIs. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-lambda-authorizer.html">Working with AWS Lambda authorizers for HTTP APIs</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableSimpleResponses(java.lang.Boolean enableSimpleResponses) {
            this.enableSimpleResponses = enableSimpleResponses;
            return this;
        }

        /**
         * Sets the value of {@link CfnAuthorizerProps#getEnableSimpleResponses}
         * @param enableSimpleResponses Specifies whether a Lambda authorizer returns a response in a simple format.
         *                              By default, a Lambda authorizer must return an IAM policy. If enabled, the Lambda authorizer can return a boolean value instead of an IAM policy. Supported only for HTTP APIs. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-lambda-authorizer.html">Working with AWS Lambda authorizers for HTTP APIs</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableSimpleResponses(software.amazon.awscdk.IResolvable enableSimpleResponses) {
            this.enableSimpleResponses = enableSimpleResponses;
            return this;
        }

        /**
         * Sets the value of {@link CfnAuthorizerProps#getIdentitySource}
         * @param identitySource The identity source for which authorization is requested.
         *                       For a <code>REQUEST</code> authorizer, this is optional. The value is a set of one or more mapping expressions of the specified request parameters. The identity source can be headers, query string parameters, stage variables, and context parameters. For example, if an Auth header and a Name query string parameter are defined as identity sources, this value is route.request.header.Auth, route.request.querystring.Name for WebSocket APIs. For HTTP APIs, use selection expressions prefixed with <code>$</code> , for example, <code>$request.header.Auth</code> , <code>$request.querystring.Name</code> . These parameters are used to perform runtime validation for Lambda-based authorizers by verifying all of the identity-related request parameters are present in the request, not null, and non-empty. Only when this is true does the authorizer invoke the authorizer Lambda function. Otherwise, it returns a 401 Unauthorized response without calling the Lambda function. For HTTP APIs, identity sources are also used as the cache key when caching is enabled. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-lambda-authorizer.html">Working with AWS Lambda authorizers for HTTP APIs</a> .
         *                       <p>
         *                       For <code>JWT</code> , a single entry that specifies where to extract the JSON Web Token (JWT) from inbound requests. Currently only header-based and query parameter-based selections are supported, for example <code>$request.header.Authorization</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder identitySource(java.util.List<java.lang.String> identitySource) {
            this.identitySource = identitySource;
            return this;
        }

        /**
         * Sets the value of {@link CfnAuthorizerProps#getIdentityValidationExpression}
         * @param identityValidationExpression This parameter is not used.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder identityValidationExpression(java.lang.String identityValidationExpression) {
            this.identityValidationExpression = identityValidationExpression;
            return this;
        }

        /**
         * Sets the value of {@link CfnAuthorizerProps#getJwtConfiguration}
         * @param jwtConfiguration The <code>JWTConfiguration</code> property specifies the configuration of a JWT authorizer.
         *                         Required for the <code>JWT</code> authorizer type. Supported only for HTTP APIs.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder jwtConfiguration(software.amazon.awscdk.IResolvable jwtConfiguration) {
            this.jwtConfiguration = jwtConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnAuthorizerProps#getJwtConfiguration}
         * @param jwtConfiguration The <code>JWTConfiguration</code> property specifies the configuration of a JWT authorizer.
         *                         Required for the <code>JWT</code> authorizer type. Supported only for HTTP APIs.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder jwtConfiguration(software.amazon.awscdk.services.apigatewayv2.CfnAuthorizer.JWTConfigurationProperty jwtConfiguration) {
            this.jwtConfiguration = jwtConfiguration;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnAuthorizerProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnAuthorizerProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnAuthorizerProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnAuthorizerProps {
        private final java.lang.String apiId;
        private final java.lang.String authorizerType;
        private final java.lang.String name;
        private final java.lang.String authorizerCredentialsArn;
        private final java.lang.String authorizerPayloadFormatVersion;
        private final java.lang.Number authorizerResultTtlInSeconds;
        private final java.lang.String authorizerUri;
        private final java.lang.Object enableSimpleResponses;
        private final java.util.List<java.lang.String> identitySource;
        private final java.lang.String identityValidationExpression;
        private final java.lang.Object jwtConfiguration;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.apiId = software.amazon.jsii.Kernel.get(this, "apiId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.authorizerType = software.amazon.jsii.Kernel.get(this, "authorizerType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.authorizerCredentialsArn = software.amazon.jsii.Kernel.get(this, "authorizerCredentialsArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.authorizerPayloadFormatVersion = software.amazon.jsii.Kernel.get(this, "authorizerPayloadFormatVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.authorizerResultTtlInSeconds = software.amazon.jsii.Kernel.get(this, "authorizerResultTtlInSeconds", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.authorizerUri = software.amazon.jsii.Kernel.get(this, "authorizerUri", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.enableSimpleResponses = software.amazon.jsii.Kernel.get(this, "enableSimpleResponses", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.identitySource = software.amazon.jsii.Kernel.get(this, "identitySource", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.identityValidationExpression = software.amazon.jsii.Kernel.get(this, "identityValidationExpression", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.jwtConfiguration = software.amazon.jsii.Kernel.get(this, "jwtConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.apiId = java.util.Objects.requireNonNull(builder.apiId, "apiId is required");
            this.authorizerType = java.util.Objects.requireNonNull(builder.authorizerType, "authorizerType is required");
            this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            this.authorizerCredentialsArn = builder.authorizerCredentialsArn;
            this.authorizerPayloadFormatVersion = builder.authorizerPayloadFormatVersion;
            this.authorizerResultTtlInSeconds = builder.authorizerResultTtlInSeconds;
            this.authorizerUri = builder.authorizerUri;
            this.enableSimpleResponses = builder.enableSimpleResponses;
            this.identitySource = builder.identitySource;
            this.identityValidationExpression = builder.identityValidationExpression;
            this.jwtConfiguration = builder.jwtConfiguration;
        }

        @Override
        public final java.lang.String getApiId() {
            return this.apiId;
        }

        @Override
        public final java.lang.String getAuthorizerType() {
            return this.authorizerType;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.String getAuthorizerCredentialsArn() {
            return this.authorizerCredentialsArn;
        }

        @Override
        public final java.lang.String getAuthorizerPayloadFormatVersion() {
            return this.authorizerPayloadFormatVersion;
        }

        @Override
        public final java.lang.Number getAuthorizerResultTtlInSeconds() {
            return this.authorizerResultTtlInSeconds;
        }

        @Override
        public final java.lang.String getAuthorizerUri() {
            return this.authorizerUri;
        }

        @Override
        public final java.lang.Object getEnableSimpleResponses() {
            return this.enableSimpleResponses;
        }

        @Override
        public final java.util.List<java.lang.String> getIdentitySource() {
            return this.identitySource;
        }

        @Override
        public final java.lang.String getIdentityValidationExpression() {
            return this.identityValidationExpression;
        }

        @Override
        public final java.lang.Object getJwtConfiguration() {
            return this.jwtConfiguration;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("apiId", om.valueToTree(this.getApiId()));
            data.set("authorizerType", om.valueToTree(this.getAuthorizerType()));
            data.set("name", om.valueToTree(this.getName()));
            if (this.getAuthorizerCredentialsArn() != null) {
                data.set("authorizerCredentialsArn", om.valueToTree(this.getAuthorizerCredentialsArn()));
            }
            if (this.getAuthorizerPayloadFormatVersion() != null) {
                data.set("authorizerPayloadFormatVersion", om.valueToTree(this.getAuthorizerPayloadFormatVersion()));
            }
            if (this.getAuthorizerResultTtlInSeconds() != null) {
                data.set("authorizerResultTtlInSeconds", om.valueToTree(this.getAuthorizerResultTtlInSeconds()));
            }
            if (this.getAuthorizerUri() != null) {
                data.set("authorizerUri", om.valueToTree(this.getAuthorizerUri()));
            }
            if (this.getEnableSimpleResponses() != null) {
                data.set("enableSimpleResponses", om.valueToTree(this.getEnableSimpleResponses()));
            }
            if (this.getIdentitySource() != null) {
                data.set("identitySource", om.valueToTree(this.getIdentitySource()));
            }
            if (this.getIdentityValidationExpression() != null) {
                data.set("identityValidationExpression", om.valueToTree(this.getIdentityValidationExpression()));
            }
            if (this.getJwtConfiguration() != null) {
                data.set("jwtConfiguration", om.valueToTree(this.getJwtConfiguration()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_apigatewayv2.CfnAuthorizerProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnAuthorizerProps.Jsii$Proxy that = (CfnAuthorizerProps.Jsii$Proxy) o;

            if (!apiId.equals(that.apiId)) return false;
            if (!authorizerType.equals(that.authorizerType)) return false;
            if (!name.equals(that.name)) return false;
            if (this.authorizerCredentialsArn != null ? !this.authorizerCredentialsArn.equals(that.authorizerCredentialsArn) : that.authorizerCredentialsArn != null) return false;
            if (this.authorizerPayloadFormatVersion != null ? !this.authorizerPayloadFormatVersion.equals(that.authorizerPayloadFormatVersion) : that.authorizerPayloadFormatVersion != null) return false;
            if (this.authorizerResultTtlInSeconds != null ? !this.authorizerResultTtlInSeconds.equals(that.authorizerResultTtlInSeconds) : that.authorizerResultTtlInSeconds != null) return false;
            if (this.authorizerUri != null ? !this.authorizerUri.equals(that.authorizerUri) : that.authorizerUri != null) return false;
            if (this.enableSimpleResponses != null ? !this.enableSimpleResponses.equals(that.enableSimpleResponses) : that.enableSimpleResponses != null) return false;
            if (this.identitySource != null ? !this.identitySource.equals(that.identitySource) : that.identitySource != null) return false;
            if (this.identityValidationExpression != null ? !this.identityValidationExpression.equals(that.identityValidationExpression) : that.identityValidationExpression != null) return false;
            return this.jwtConfiguration != null ? this.jwtConfiguration.equals(that.jwtConfiguration) : that.jwtConfiguration == null;
        }

        @Override
        public final int hashCode() {
            int result = this.apiId.hashCode();
            result = 31 * result + (this.authorizerType.hashCode());
            result = 31 * result + (this.name.hashCode());
            result = 31 * result + (this.authorizerCredentialsArn != null ? this.authorizerCredentialsArn.hashCode() : 0);
            result = 31 * result + (this.authorizerPayloadFormatVersion != null ? this.authorizerPayloadFormatVersion.hashCode() : 0);
            result = 31 * result + (this.authorizerResultTtlInSeconds != null ? this.authorizerResultTtlInSeconds.hashCode() : 0);
            result = 31 * result + (this.authorizerUri != null ? this.authorizerUri.hashCode() : 0);
            result = 31 * result + (this.enableSimpleResponses != null ? this.enableSimpleResponses.hashCode() : 0);
            result = 31 * result + (this.identitySource != null ? this.identitySource.hashCode() : 0);
            result = 31 * result + (this.identityValidationExpression != null ? this.identityValidationExpression.hashCode() : 0);
            result = 31 * result + (this.jwtConfiguration != null ? this.jwtConfiguration.hashCode() : 0);
            return result;
        }
    }
}
