package software.amazon.awscdk.services.apigatewayv2;

/**
 * Properties for defining a <code>CfnIntegrationResponse</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.apigatewayv2.*;
 * Object responseParameters;
 * Object responseTemplates;
 * CfnIntegrationResponseProps cfnIntegrationResponseProps = CfnIntegrationResponseProps.builder()
 *         .apiId("apiId")
 *         .integrationId("integrationId")
 *         .integrationResponseKey("integrationResponseKey")
 *         // the properties below are optional
 *         .contentHandlingStrategy("contentHandlingStrategy")
 *         .responseParameters(responseParameters)
 *         .responseTemplates(responseTemplates)
 *         .templateSelectionExpression("templateSelectionExpression")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-integrationresponse.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-integrationresponse.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-08-06T18:14:31.722Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_apigatewayv2.CfnIntegrationResponseProps")
@software.amazon.jsii.Jsii.Proxy(CfnIntegrationResponseProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnIntegrationResponseProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The API identifier.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-integrationresponse.html#cfn-apigatewayv2-integrationresponse-apiid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-integrationresponse.html#cfn-apigatewayv2-integrationresponse-apiid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getApiId();

    /**
     * The integration ID.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-integrationresponse.html#cfn-apigatewayv2-integrationresponse-integrationid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-integrationresponse.html#cfn-apigatewayv2-integrationresponse-integrationid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getIntegrationId();

    /**
     * The integration response key.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-integrationresponse.html#cfn-apigatewayv2-integrationresponse-integrationresponsekey">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-integrationresponse.html#cfn-apigatewayv2-integrationresponse-integrationresponsekey</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getIntegrationResponseKey();

    /**
     * Supported only for WebSocket APIs.
     * <p>
     * Specifies how to handle response payload content type conversions. Supported values are <code>CONVERT_TO_BINARY</code> and <code>CONVERT_TO_TEXT</code> , with the following behaviors:
     * <p>
     * <code>CONVERT_TO_BINARY</code> : Converts a response payload from a Base64-encoded string to the corresponding binary blob.
     * <p>
     * <code>CONVERT_TO_TEXT</code> : Converts a response payload from a binary blob to a Base64-encoded string.
     * <p>
     * If this property is not defined, the response payload will be passed through from the integration response to the route response or method response without modification.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-integrationresponse.html#cfn-apigatewayv2-integrationresponse-contenthandlingstrategy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-integrationresponse.html#cfn-apigatewayv2-integrationresponse-contenthandlingstrategy</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getContentHandlingStrategy() {
        return null;
    }

    /**
     * A key-value map specifying response parameters that are passed to the method response from the backend.
     * <p>
     * The key is a method response header parameter name and the mapped value is an integration response header value, a static value enclosed within a pair of single quotes, or a JSON expression from the integration response body. The mapping key must match the pattern of <code>method.response.header. *{name}*</code> , where name is a valid and unique header name. The mapped non-static value must match the pattern of <code>integration.response.header. *{name}*</code> or <code>integration.response.body. *{JSON-expression}*</code> , where <code>*{name}*</code> is a valid and unique response header name and <code>*{JSON-expression}*</code> is a valid JSON expression without the <code>$</code> prefix.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-integrationresponse.html#cfn-apigatewayv2-integrationresponse-responseparameters">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-integrationresponse.html#cfn-apigatewayv2-integrationresponse-responseparameters</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getResponseParameters() {
        return null;
    }

    /**
     * The collection of response templates for the integration response as a string-to-string map of key-value pairs.
     * <p>
     * Response templates are represented as a key/value map, with a content-type as the key and a template as the value.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-integrationresponse.html#cfn-apigatewayv2-integrationresponse-responsetemplates">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-integrationresponse.html#cfn-apigatewayv2-integrationresponse-responsetemplates</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getResponseTemplates() {
        return null;
    }

    /**
     * The template selection expression for the integration response.
     * <p>
     * Supported only for WebSocket APIs.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-integrationresponse.html#cfn-apigatewayv2-integrationresponse-templateselectionexpression">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-integrationresponse.html#cfn-apigatewayv2-integrationresponse-templateselectionexpression</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getTemplateSelectionExpression() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnIntegrationResponseProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnIntegrationResponseProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnIntegrationResponseProps> {
        java.lang.String apiId;
        java.lang.String integrationId;
        java.lang.String integrationResponseKey;
        java.lang.String contentHandlingStrategy;
        java.lang.Object responseParameters;
        java.lang.Object responseTemplates;
        java.lang.String templateSelectionExpression;

        /**
         * Sets the value of {@link CfnIntegrationResponseProps#getApiId}
         * @param apiId The API identifier. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder apiId(java.lang.String apiId) {
            this.apiId = apiId;
            return this;
        }

        /**
         * Sets the value of {@link CfnIntegrationResponseProps#getIntegrationId}
         * @param integrationId The integration ID. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder integrationId(java.lang.String integrationId) {
            this.integrationId = integrationId;
            return this;
        }

        /**
         * Sets the value of {@link CfnIntegrationResponseProps#getIntegrationResponseKey}
         * @param integrationResponseKey The integration response key. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder integrationResponseKey(java.lang.String integrationResponseKey) {
            this.integrationResponseKey = integrationResponseKey;
            return this;
        }

        /**
         * Sets the value of {@link CfnIntegrationResponseProps#getContentHandlingStrategy}
         * @param contentHandlingStrategy Supported only for WebSocket APIs.
         *                                Specifies how to handle response payload content type conversions. Supported values are <code>CONVERT_TO_BINARY</code> and <code>CONVERT_TO_TEXT</code> , with the following behaviors:
         *                                <p>
         *                                <code>CONVERT_TO_BINARY</code> : Converts a response payload from a Base64-encoded string to the corresponding binary blob.
         *                                <p>
         *                                <code>CONVERT_TO_TEXT</code> : Converts a response payload from a binary blob to a Base64-encoded string.
         *                                <p>
         *                                If this property is not defined, the response payload will be passed through from the integration response to the route response or method response without modification.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder contentHandlingStrategy(java.lang.String contentHandlingStrategy) {
            this.contentHandlingStrategy = contentHandlingStrategy;
            return this;
        }

        /**
         * Sets the value of {@link CfnIntegrationResponseProps#getResponseParameters}
         * @param responseParameters A key-value map specifying response parameters that are passed to the method response from the backend.
         *                           The key is a method response header parameter name and the mapped value is an integration response header value, a static value enclosed within a pair of single quotes, or a JSON expression from the integration response body. The mapping key must match the pattern of <code>method.response.header. *{name}*</code> , where name is a valid and unique header name. The mapped non-static value must match the pattern of <code>integration.response.header. *{name}*</code> or <code>integration.response.body. *{JSON-expression}*</code> , where <code>*{name}*</code> is a valid and unique response header name and <code>*{JSON-expression}*</code> is a valid JSON expression without the <code>$</code> prefix.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder responseParameters(java.lang.Object responseParameters) {
            this.responseParameters = responseParameters;
            return this;
        }

        /**
         * Sets the value of {@link CfnIntegrationResponseProps#getResponseTemplates}
         * @param responseTemplates The collection of response templates for the integration response as a string-to-string map of key-value pairs.
         *                          Response templates are represented as a key/value map, with a content-type as the key and a template as the value.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder responseTemplates(java.lang.Object responseTemplates) {
            this.responseTemplates = responseTemplates;
            return this;
        }

        /**
         * Sets the value of {@link CfnIntegrationResponseProps#getTemplateSelectionExpression}
         * @param templateSelectionExpression The template selection expression for the integration response.
         *                                    Supported only for WebSocket APIs.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder templateSelectionExpression(java.lang.String templateSelectionExpression) {
            this.templateSelectionExpression = templateSelectionExpression;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnIntegrationResponseProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnIntegrationResponseProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnIntegrationResponseProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnIntegrationResponseProps {
        private final java.lang.String apiId;
        private final java.lang.String integrationId;
        private final java.lang.String integrationResponseKey;
        private final java.lang.String contentHandlingStrategy;
        private final java.lang.Object responseParameters;
        private final java.lang.Object responseTemplates;
        private final java.lang.String templateSelectionExpression;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.apiId = software.amazon.jsii.Kernel.get(this, "apiId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.integrationId = software.amazon.jsii.Kernel.get(this, "integrationId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.integrationResponseKey = software.amazon.jsii.Kernel.get(this, "integrationResponseKey", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.contentHandlingStrategy = software.amazon.jsii.Kernel.get(this, "contentHandlingStrategy", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.responseParameters = software.amazon.jsii.Kernel.get(this, "responseParameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.responseTemplates = software.amazon.jsii.Kernel.get(this, "responseTemplates", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.templateSelectionExpression = software.amazon.jsii.Kernel.get(this, "templateSelectionExpression", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.apiId = java.util.Objects.requireNonNull(builder.apiId, "apiId is required");
            this.integrationId = java.util.Objects.requireNonNull(builder.integrationId, "integrationId is required");
            this.integrationResponseKey = java.util.Objects.requireNonNull(builder.integrationResponseKey, "integrationResponseKey is required");
            this.contentHandlingStrategy = builder.contentHandlingStrategy;
            this.responseParameters = builder.responseParameters;
            this.responseTemplates = builder.responseTemplates;
            this.templateSelectionExpression = builder.templateSelectionExpression;
        }

        @Override
        public final java.lang.String getApiId() {
            return this.apiId;
        }

        @Override
        public final java.lang.String getIntegrationId() {
            return this.integrationId;
        }

        @Override
        public final java.lang.String getIntegrationResponseKey() {
            return this.integrationResponseKey;
        }

        @Override
        public final java.lang.String getContentHandlingStrategy() {
            return this.contentHandlingStrategy;
        }

        @Override
        public final java.lang.Object getResponseParameters() {
            return this.responseParameters;
        }

        @Override
        public final java.lang.Object getResponseTemplates() {
            return this.responseTemplates;
        }

        @Override
        public final java.lang.String getTemplateSelectionExpression() {
            return this.templateSelectionExpression;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("apiId", om.valueToTree(this.getApiId()));
            data.set("integrationId", om.valueToTree(this.getIntegrationId()));
            data.set("integrationResponseKey", om.valueToTree(this.getIntegrationResponseKey()));
            if (this.getContentHandlingStrategy() != null) {
                data.set("contentHandlingStrategy", om.valueToTree(this.getContentHandlingStrategy()));
            }
            if (this.getResponseParameters() != null) {
                data.set("responseParameters", om.valueToTree(this.getResponseParameters()));
            }
            if (this.getResponseTemplates() != null) {
                data.set("responseTemplates", om.valueToTree(this.getResponseTemplates()));
            }
            if (this.getTemplateSelectionExpression() != null) {
                data.set("templateSelectionExpression", om.valueToTree(this.getTemplateSelectionExpression()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_apigatewayv2.CfnIntegrationResponseProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnIntegrationResponseProps.Jsii$Proxy that = (CfnIntegrationResponseProps.Jsii$Proxy) o;

            if (!apiId.equals(that.apiId)) return false;
            if (!integrationId.equals(that.integrationId)) return false;
            if (!integrationResponseKey.equals(that.integrationResponseKey)) return false;
            if (this.contentHandlingStrategy != null ? !this.contentHandlingStrategy.equals(that.contentHandlingStrategy) : that.contentHandlingStrategy != null) return false;
            if (this.responseParameters != null ? !this.responseParameters.equals(that.responseParameters) : that.responseParameters != null) return false;
            if (this.responseTemplates != null ? !this.responseTemplates.equals(that.responseTemplates) : that.responseTemplates != null) return false;
            return this.templateSelectionExpression != null ? this.templateSelectionExpression.equals(that.templateSelectionExpression) : that.templateSelectionExpression == null;
        }

        @Override
        public final int hashCode() {
            int result = this.apiId.hashCode();
            result = 31 * result + (this.integrationId.hashCode());
            result = 31 * result + (this.integrationResponseKey.hashCode());
            result = 31 * result + (this.contentHandlingStrategy != null ? this.contentHandlingStrategy.hashCode() : 0);
            result = 31 * result + (this.responseParameters != null ? this.responseParameters.hashCode() : 0);
            result = 31 * result + (this.responseTemplates != null ? this.responseTemplates.hashCode() : 0);
            result = 31 * result + (this.templateSelectionExpression != null ? this.templateSelectionExpression.hashCode() : 0);
            return result;
        }
    }
}
