package software.amazon.awscdk.services.appmesh;

/**
 * Used to generate specs with different protocols for a GatewayRoute.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * VirtualGateway gateway;
 * VirtualService virtualService;
 * gateway.addGatewayRoute("gateway-route-grpc", GatewayRouteBaseProps.builder()
 *         .routeSpec(GatewayRouteSpec.grpc(GrpcGatewayRouteSpecOptions.builder()
 *                 .routeTarget(virtualService)
 *                 .match(GrpcGatewayRouteMatch.builder()
 *                         .hostname(GatewayRouteHostnameMatch.exactly("example.com"))
 *                         // This disables the default rewrite to virtual service name and retain original request.
 *                         .rewriteRequestHostname(false)
 *                         .build())
 *                 .build()))
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-08-06T18:14:32.286Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appmesh.GatewayRouteSpec")
public abstract class GatewayRouteSpec extends software.amazon.jsii.JsiiObject {

    protected GatewayRouteSpec(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected GatewayRouteSpec(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected GatewayRouteSpec() {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this);
    }

    /**
     * Creates an gRPC Based GatewayRoute.
     * <p>
     * @param options <ul><li>no grpc gateway route.</li></ul> This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appmesh.GatewayRouteSpec grpc(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appmesh.GrpcGatewayRouteSpecOptions options) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.appmesh.GatewayRouteSpec.class, "grpc", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appmesh.GatewayRouteSpec.class), new Object[] { java.util.Objects.requireNonNull(options, "options is required") });
    }

    /**
     * Creates an HTTP Based GatewayRoute.
     * <p>
     * @param options <ul><li>no http gateway route.</li></ul> This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appmesh.GatewayRouteSpec http(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appmesh.HttpGatewayRouteSpecOptions options) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.appmesh.GatewayRouteSpec.class, "http", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appmesh.GatewayRouteSpec.class), new Object[] { java.util.Objects.requireNonNull(options, "options is required") });
    }

    /**
     * Creates an HTTP2 Based GatewayRoute.
     * <p>
     * @param options <ul><li>no http2 gateway route.</li></ul> This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appmesh.GatewayRouteSpec http2(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appmesh.HttpGatewayRouteSpecOptions options) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.appmesh.GatewayRouteSpec.class, "http2", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appmesh.GatewayRouteSpec.class), new Object[] { java.util.Objects.requireNonNull(options, "options is required") });
    }

    /**
     * Called when the GatewayRouteSpec type is initialized.
     * <p>
     * Can be used to enforce
     * mutual exclusivity with future properties
     * <p>
     * @param scope This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public abstract @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appmesh.GatewayRouteSpecConfig bind(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope);

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    @software.amazon.jsii.Internal
    private static final class Jsii$Proxy extends software.amazon.awscdk.services.appmesh.GatewayRouteSpec {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }

        /**
         * Called when the GatewayRouteSpec type is initialized.
         * <p>
         * Can be used to enforce
         * mutual exclusivity with future properties
         * <p>
         * @param scope This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appmesh.GatewayRouteSpecConfig bind(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope) {
            return software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appmesh.GatewayRouteSpecConfig.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required") });
        }
    }
}
