package software.amazon.awscdk.services.appmesh;

/**
 * Represents the properties needed to define TLS Validation context.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Mesh mesh;
 * Service service;
 * VirtualNode node = VirtualNode.Builder.create(this, "node")
 *         .mesh(mesh)
 *         .serviceDiscovery(ServiceDiscovery.cloudMap(service))
 *         .listeners(List.of(VirtualNodeListener.http(HttpVirtualNodeListenerOptions.builder()
 *                 .port(8080)
 *                 .healthCheck(HealthCheck.http(HttpHealthCheckOptions.builder()
 *                         .healthyThreshold(3)
 *                         .interval(Duration.seconds(5))
 *                         .path("/ping")
 *                         .timeout(Duration.seconds(2))
 *                         .unhealthyThreshold(2)
 *                         .build()))
 *                 .timeout(HttpTimeout.builder()
 *                         .idle(Duration.seconds(5))
 *                         .build())
 *                 .build())))
 *         .backendDefaults(BackendDefaults.builder()
 *                 .tlsClientPolicy(TlsClientPolicy.builder()
 *                         .validation(TlsValidation.builder()
 *                                 .trust(TlsValidationTrust.file("/keys/local_cert_chain.pem"))
 *                                 .build())
 *                         .build())
 *                 .build())
 *         .accessLog(AccessLog.fromFilePath("/dev/stdout"))
 *         .build();
 * Tags.of(node).add("Environment", "Dev");
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-08-06T18:14:32.340Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appmesh.TlsValidation")
@software.amazon.jsii.Jsii.Proxy(TlsValidation.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface TlsValidation extends software.amazon.jsii.JsiiSerializable {

    /**
     * Reference to where to retrieve the trust chain.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appmesh.TlsValidationTrust getTrust();

    /**
     * Represents the subject alternative names (SANs) secured by the certificate.
     * <p>
     * SANs must be in the FQDN or URI format.
     * <p>
     * Default: - If you don't specify SANs on the terminating mesh endpoint,
     * the Envoy proxy for that node doesn't verify the SAN on a peer client certificate.
     * If you don't specify SANs on the originating mesh endpoint,
     * the SAN on the certificate provided by the terminating endpoint must match the mesh endpoint service discovery configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appmesh.SubjectAlternativeNames getSubjectAlternativeNames() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link TlsValidation}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link TlsValidation}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<TlsValidation> {
        software.amazon.awscdk.services.appmesh.TlsValidationTrust trust;
        software.amazon.awscdk.services.appmesh.SubjectAlternativeNames subjectAlternativeNames;

        /**
         * Sets the value of {@link TlsValidation#getTrust}
         * @param trust Reference to where to retrieve the trust chain. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder trust(software.amazon.awscdk.services.appmesh.TlsValidationTrust trust) {
            this.trust = trust;
            return this;
        }

        /**
         * Sets the value of {@link TlsValidation#getSubjectAlternativeNames}
         * @param subjectAlternativeNames Represents the subject alternative names (SANs) secured by the certificate.
         *                                SANs must be in the FQDN or URI format.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subjectAlternativeNames(software.amazon.awscdk.services.appmesh.SubjectAlternativeNames subjectAlternativeNames) {
            this.subjectAlternativeNames = subjectAlternativeNames;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link TlsValidation}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public TlsValidation build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link TlsValidation}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TlsValidation {
        private final software.amazon.awscdk.services.appmesh.TlsValidationTrust trust;
        private final software.amazon.awscdk.services.appmesh.SubjectAlternativeNames subjectAlternativeNames;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.trust = software.amazon.jsii.Kernel.get(this, "trust", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appmesh.TlsValidationTrust.class));
            this.subjectAlternativeNames = software.amazon.jsii.Kernel.get(this, "subjectAlternativeNames", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appmesh.SubjectAlternativeNames.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.trust = java.util.Objects.requireNonNull(builder.trust, "trust is required");
            this.subjectAlternativeNames = builder.subjectAlternativeNames;
        }

        @Override
        public final software.amazon.awscdk.services.appmesh.TlsValidationTrust getTrust() {
            return this.trust;
        }

        @Override
        public final software.amazon.awscdk.services.appmesh.SubjectAlternativeNames getSubjectAlternativeNames() {
            return this.subjectAlternativeNames;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("trust", om.valueToTree(this.getTrust()));
            if (this.getSubjectAlternativeNames() != null) {
                data.set("subjectAlternativeNames", om.valueToTree(this.getSubjectAlternativeNames()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appmesh.TlsValidation"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            TlsValidation.Jsii$Proxy that = (TlsValidation.Jsii$Proxy) o;

            if (!trust.equals(that.trust)) return false;
            return this.subjectAlternativeNames != null ? this.subjectAlternativeNames.equals(that.subjectAlternativeNames) : that.subjectAlternativeNames == null;
        }

        @Override
        public final int hashCode() {
            int result = this.trust.hashCode();
            result = 31 * result + (this.subjectAlternativeNames != null ? this.subjectAlternativeNames.hashCode() : 0);
            return result;
        }
    }
}
