package software.amazon.awscdk.services.appmesh;

/**
 * VirtualNode represents a newly defined AppMesh VirtualNode.
 * <p>
 * Any inbound traffic that your virtual node expects should be specified as a
 * listener. Any outbound traffic that your virtual node expects to reach
 * should be specified as a backend.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Mesh mesh;
 * // Cloud Map service discovery is currently required for host ejection by outlier detection
 * Vpc vpc = new Vpc(this, "vpc");
 * PrivateDnsNamespace namespace = PrivateDnsNamespace.Builder.create(this, "test-namespace")
 *         .vpc(vpc)
 *         .name("domain.local")
 *         .build();
 * Service service = namespace.createService("Svc");
 * VirtualNode node = mesh.addVirtualNode("virtual-node", VirtualNodeBaseProps.builder()
 *         .serviceDiscovery(ServiceDiscovery.cloudMap(service))
 *         .listeners(List.of(VirtualNodeListener.http(HttpVirtualNodeListenerOptions.builder()
 *                 .outlierDetection(OutlierDetection.builder()
 *                         .baseEjectionDuration(Duration.seconds(10))
 *                         .interval(Duration.seconds(30))
 *                         .maxEjectionPercent(50)
 *                         .maxServerErrors(5)
 *                         .build())
 *                 .build())))
 *         .build());
 * </pre></blockquote>
 * <p>
 * @see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/virtual_nodes.html">https://docs.aws.amazon.com/app-mesh/latest/userguide/virtual_nodes.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-08-06T18:14:32.345Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appmesh.VirtualNode")
public class VirtualNode extends software.amazon.awscdk.Resource implements software.amazon.awscdk.services.appmesh.IVirtualNode {

    protected VirtualNode(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected VirtualNode(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        PROPERTY_INJECTION_ID = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.appmesh.VirtualNode.class, "PROPERTY_INJECTION_ID", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public VirtualNode(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appmesh.VirtualNodeProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Import an existing VirtualNode given an ARN.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param virtualNodeArn This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appmesh.IVirtualNode fromVirtualNodeArn(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String virtualNodeArn) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.appmesh.VirtualNode.class, "fromVirtualNodeArn", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appmesh.IVirtualNode.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(virtualNodeArn, "virtualNodeArn is required") });
    }

    /**
     * Import an existing VirtualNode given its name.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param attrs This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appmesh.IVirtualNode fromVirtualNodeAttributes(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appmesh.VirtualNodeAttributes attrs) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.appmesh.VirtualNode.class, "fromVirtualNodeAttributes", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appmesh.IVirtualNode.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(attrs, "attrs is required") });
    }

    /**
     * Add a Virtual Services that this node is expected to send outbound traffic to.
     * <p>
     * @param backend This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addBackend(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appmesh.Backend backend) {
        software.amazon.jsii.Kernel.call(this, "addBackend", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(backend, "backend is required") });
    }

    /**
     * Utility method to add an inbound listener for this VirtualNode.
     * <p>
     * Note: At this time, Virtual Nodes support at most one listener. Adding
     * more than one will result in a failure to deploy the CloudFormation stack.
     * However, the App Mesh team has plans to add support for multiple listeners
     * on Virtual Nodes and Virtual Routers.
     * <p>
     * @see <a href="https://github.com/aws/aws-app-mesh-roadmap/issues/120">https://github.com/aws/aws-app-mesh-roadmap/issues/120</a>
     * @param listener This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addListener(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appmesh.VirtualNodeListener listener) {
        software.amazon.jsii.Kernel.call(this, "addListener", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(listener, "listener is required") });
    }

    /**
     * Grants the given entity <code>appmesh:StreamAggregatedResources</code>.
     * <p>
     * @param identity This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantStreamAggregatedResources(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable identity) {
        return software.amazon.jsii.Kernel.call(this, "grantStreamAggregatedResources", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(identity, "identity is required") });
    }

    /**
     * Uniquely identifies this class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String PROPERTY_INJECTION_ID;

    /**
     * The Mesh which the VirtualNode belongs to.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appmesh.IMesh getMesh() {
        return software.amazon.jsii.Kernel.get(this, "mesh", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appmesh.IMesh.class));
    }

    /**
     * The Amazon Resource Name belonging to the VirtualNode.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getVirtualNodeArn() {
        return software.amazon.jsii.Kernel.get(this, "virtualNodeArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the VirtualNode.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getVirtualNodeName() {
        return software.amazon.jsii.Kernel.get(this, "virtualNodeName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.appmesh.VirtualNode}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.appmesh.VirtualNode> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.appmesh.VirtualNodeProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.appmesh.VirtualNodeProps.Builder();
        }

        /**
         * Access Logging Configuration for the virtual node.
         * <p>
         * Default: - No access logging
         * <p>
         * @return {@code this}
         * @param accessLog Access Logging Configuration for the virtual node. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder accessLog(final software.amazon.awscdk.services.appmesh.AccessLog accessLog) {
            this.props.accessLog(accessLog);
            return this;
        }

        /**
         * Default Configuration Virtual Node uses to communicate with Virtual Service.
         * <p>
         * Default: - No Config
         * <p>
         * @return {@code this}
         * @param backendDefaults Default Configuration Virtual Node uses to communicate with Virtual Service. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder backendDefaults(final software.amazon.awscdk.services.appmesh.BackendDefaults backendDefaults) {
            this.props.backendDefaults(backendDefaults);
            return this;
        }

        /**
         * Virtual Services that this is node expected to send outbound traffic to.
         * <p>
         * Default: - No backends
         * <p>
         * @return {@code this}
         * @param backends Virtual Services that this is node expected to send outbound traffic to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder backends(final java.util.List<? extends software.amazon.awscdk.services.appmesh.Backend> backends) {
            this.props.backends(backends);
            return this;
        }

        /**
         * Initial listener for the virtual node.
         * <p>
         * Default: - No listeners
         * <p>
         * @return {@code this}
         * @param listeners Initial listener for the virtual node. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder listeners(final java.util.List<? extends software.amazon.awscdk.services.appmesh.VirtualNodeListener> listeners) {
            this.props.listeners(listeners);
            return this;
        }

        /**
         * Defines how upstream clients will discover this VirtualNode.
         * <p>
         * Default: - No Service Discovery
         * <p>
         * @return {@code this}
         * @param serviceDiscovery Defines how upstream clients will discover this VirtualNode. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serviceDiscovery(final software.amazon.awscdk.services.appmesh.ServiceDiscovery serviceDiscovery) {
            this.props.serviceDiscovery(serviceDiscovery);
            return this;
        }

        /**
         * The name of the VirtualNode.
         * <p>
         * Default: - A name is automatically determined
         * <p>
         * @return {@code this}
         * @param virtualNodeName The name of the VirtualNode. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder virtualNodeName(final java.lang.String virtualNodeName) {
            this.props.virtualNodeName(virtualNodeName);
            return this;
        }

        /**
         * The Mesh which the VirtualNode belongs to.
         * <p>
         * @return {@code this}
         * @param mesh The Mesh which the VirtualNode belongs to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder mesh(final software.amazon.awscdk.services.appmesh.IMesh mesh) {
            this.props.mesh(mesh);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.appmesh.VirtualNode}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.appmesh.VirtualNode build() {
            return new software.amazon.awscdk.services.appmesh.VirtualNode(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
