package software.amazon.awscdk.services.appsync;

/**
 * Abstract AppSync datasource implementation.
 * <p>
 * Do not use directly but use subclasses for resource backed datasources
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * EventApi api;
 * AppSyncDynamoDbDataSource ddbDataSource;
 * AppSyncEventBridgeDataSource ebDataSource;
 * // DynamoDB data source for publish handler
 * api.addChannelNamespace("ddb-eb-ns", ChannelNamespaceOptions.builder()
 *         .code(Code.fromInline("/* event handler code here.*&#47;"))
 *         .publishHandlerConfig(HandlerConfig.builder()
 *                 .dataSource(ddbDataSource)
 *                 .build())
 *         .subscribeHandlerConfig(HandlerConfig.builder()
 *                 .dataSource(ebDataSource)
 *                 .build())
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-08-06T18:14:32.460Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appsync.AppSyncBackedDataSource")
public abstract class AppSyncBackedDataSource extends software.amazon.awscdk.services.appsync.AppSyncBaseDataSource implements software.amazon.awscdk.services.iam.IGrantable {

    protected AppSyncBackedDataSource(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected AppSyncBackedDataSource(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     * @param extended This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected AppSyncBackedDataSource(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.AppSyncBackedDataSourceProps props, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.AppSyncExtendedDataSourceProps extended) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required"), java.util.Objects.requireNonNull(extended, "extended is required") });
    }

    /**
     * The principal of the data source to be IGrantable.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IPrincipal getGrantPrincipal() {
        return software.amazon.jsii.Kernel.get(this, "grantPrincipal", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IPrincipal.class));
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    @software.amazon.jsii.Internal
    private static final class Jsii$Proxy extends software.amazon.awscdk.services.appsync.AppSyncBackedDataSource implements software.amazon.awscdk.services.iam.IGrantable.Jsii$Default, software.constructs.IConstruct.Jsii$Default {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }
    }
}
