package software.amazon.awscdk.services.appsync;

/**
 * Handler configuration construct for onPublish and onSubscribe.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * EventApi api;
 * AppSyncDynamoDbDataSource ddbDataSource;
 * AppSyncEventBridgeDataSource ebDataSource;
 * // DynamoDB data source for publish handler
 * api.addChannelNamespace("ddb-eb-ns", ChannelNamespaceOptions.builder()
 *         .code(Code.fromInline("/* event handler code here.*&#47;"))
 *         .publishHandlerConfig(HandlerConfig.builder()
 *                 .dataSource(ddbDataSource)
 *                 .build())
 *         .subscribeHandlerConfig(HandlerConfig.builder()
 *                 .dataSource(ebDataSource)
 *                 .build())
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-08-06T18:14:32.588Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appsync.HandlerConfig")
@software.amazon.jsii.Jsii.Proxy(HandlerConfig.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface HandlerConfig extends software.amazon.jsii.JsiiSerializable {

    /**
     * The Event Handler data source.
     * <p>
     * Default: - no data source is used
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appsync.AppSyncBackedDataSource getDataSource() {
        return null;
    }

    /**
     * If the Event Handler should invoke the data source directly.
     * <p>
     * Default: - false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getDirect() {
        return null;
    }

    /**
     * The Lambda invocation type for direct integrations.
     * <p>
     * Default: - LambdaInvokeType.REQUEST_RESPONSE
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appsync.LambdaInvokeType getLambdaInvokeType() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link HandlerConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link HandlerConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<HandlerConfig> {
        software.amazon.awscdk.services.appsync.AppSyncBackedDataSource dataSource;
        java.lang.Boolean direct;
        software.amazon.awscdk.services.appsync.LambdaInvokeType lambdaInvokeType;

        /**
         * Sets the value of {@link HandlerConfig#getDataSource}
         * @param dataSource The Event Handler data source.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dataSource(software.amazon.awscdk.services.appsync.AppSyncBackedDataSource dataSource) {
            this.dataSource = dataSource;
            return this;
        }

        /**
         * Sets the value of {@link HandlerConfig#getDirect}
         * @param direct If the Event Handler should invoke the data source directly.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder direct(java.lang.Boolean direct) {
            this.direct = direct;
            return this;
        }

        /**
         * Sets the value of {@link HandlerConfig#getLambdaInvokeType}
         * @param lambdaInvokeType The Lambda invocation type for direct integrations.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder lambdaInvokeType(software.amazon.awscdk.services.appsync.LambdaInvokeType lambdaInvokeType) {
            this.lambdaInvokeType = lambdaInvokeType;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link HandlerConfig}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public HandlerConfig build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link HandlerConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements HandlerConfig {
        private final software.amazon.awscdk.services.appsync.AppSyncBackedDataSource dataSource;
        private final java.lang.Boolean direct;
        private final software.amazon.awscdk.services.appsync.LambdaInvokeType lambdaInvokeType;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.dataSource = software.amazon.jsii.Kernel.get(this, "dataSource", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.AppSyncBackedDataSource.class));
            this.direct = software.amazon.jsii.Kernel.get(this, "direct", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.lambdaInvokeType = software.amazon.jsii.Kernel.get(this, "lambdaInvokeType", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.LambdaInvokeType.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.dataSource = builder.dataSource;
            this.direct = builder.direct;
            this.lambdaInvokeType = builder.lambdaInvokeType;
        }

        @Override
        public final software.amazon.awscdk.services.appsync.AppSyncBackedDataSource getDataSource() {
            return this.dataSource;
        }

        @Override
        public final java.lang.Boolean getDirect() {
            return this.direct;
        }

        @Override
        public final software.amazon.awscdk.services.appsync.LambdaInvokeType getLambdaInvokeType() {
            return this.lambdaInvokeType;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getDataSource() != null) {
                data.set("dataSource", om.valueToTree(this.getDataSource()));
            }
            if (this.getDirect() != null) {
                data.set("direct", om.valueToTree(this.getDirect()));
            }
            if (this.getLambdaInvokeType() != null) {
                data.set("lambdaInvokeType", om.valueToTree(this.getLambdaInvokeType()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appsync.HandlerConfig"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            HandlerConfig.Jsii$Proxy that = (HandlerConfig.Jsii$Proxy) o;

            if (this.dataSource != null ? !this.dataSource.equals(that.dataSource) : that.dataSource != null) return false;
            if (this.direct != null ? !this.direct.equals(that.direct) : that.direct != null) return false;
            return this.lambdaInvokeType != null ? this.lambdaInvokeType.equals(that.lambdaInvokeType) : that.lambdaInvokeType == null;
        }

        @Override
        public final int hashCode() {
            int result = this.dataSource != null ? this.dataSource.hashCode() : 0;
            result = 31 * result + (this.direct != null ? this.direct.hashCode() : 0);
            result = 31 * result + (this.lambdaInvokeType != null ? this.lambdaInvokeType.hashCode() : 0);
            return result;
        }
    }
}
