package software.amazon.awscdk.services.appsync;

/**
 * The options for configuring a schema from an existing file.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.certificatemanager.*;
 * import software.amazon.awscdk.services.route53.*;
 * // hosted zone and route53 features
 * String hostedZoneId;
 * String zoneName = "example.com";
 * String myDomainName = "api.example.com";
 * Certificate certificate = Certificate.Builder.create(this, "cert").domainName(myDomainName).build();
 * SchemaFile schema = SchemaFile.Builder.create().filePath("mySchemaFile").build();
 * GraphqlApi api = GraphqlApi.Builder.create(this, "api")
 *         .name("myApi")
 *         .definition(Definition.fromSchema(schema))
 *         .domainName(DomainOptions.builder()
 *                 .certificate(certificate)
 *                 .domainName(myDomainName)
 *                 .build())
 *         .build();
 * // hosted zone for adding appsync domain
 * IHostedZone zone = HostedZone.fromHostedZoneAttributes(this, "HostedZone", HostedZoneAttributes.builder()
 *         .hostedZoneId(hostedZoneId)
 *         .zoneName(zoneName)
 *         .build());
 * // create a cname to the appsync domain. will map to something like xxxx.cloudfront.net
 * // create a cname to the appsync domain. will map to something like xxxx.cloudfront.net
 * CnameRecord.Builder.create(this, "CnameApiRecord")
 *         .recordName("api")
 *         .zone(zone)
 *         .domainName(api.getAppSyncDomainName())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-08-06T18:14:32.626Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appsync.SchemaProps")
@software.amazon.jsii.Jsii.Proxy(SchemaProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface SchemaProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The file path for the schema.
     * <p>
     * When this option is
     * configured, then the schema will be generated from an
     * existing file from disk.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getFilePath();

    /**
     * @return a {@link Builder} of {@link SchemaProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link SchemaProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<SchemaProps> {
        java.lang.String filePath;

        /**
         * Sets the value of {@link SchemaProps#getFilePath}
         * @param filePath The file path for the schema. This parameter is required.
         *                 When this option is
         *                 configured, then the schema will be generated from an
         *                 existing file from disk.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder filePath(java.lang.String filePath) {
            this.filePath = filePath;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link SchemaProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public SchemaProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link SchemaProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SchemaProps {
        private final java.lang.String filePath;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.filePath = software.amazon.jsii.Kernel.get(this, "filePath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.filePath = java.util.Objects.requireNonNull(builder.filePath, "filePath is required");
        }

        @Override
        public final java.lang.String getFilePath() {
            return this.filePath;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("filePath", om.valueToTree(this.getFilePath()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appsync.SchemaProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            SchemaProps.Jsii$Proxy that = (SchemaProps.Jsii$Proxy) o;

            return this.filePath.equals(that.filePath);
        }

        @Override
        public final int hashCode() {
            int result = this.filePath.hashCode();
            return result;
        }
    }
}
