package software.amazon.awscdk.services.arczonalshift;

/**
 * The zonal autoshift configuration for a resource includes the practice run configuration and the status for running autoshifts, zonal autoshift status.
 * <p>
 * When a resource has a practice run configuation, ARC starts weekly zonal shifts for the resource, to shift traffic away from an Availability Zone. Weekly practice runs help you to make sure that your application can continue to operate normally with the loss of one Availability Zone.
 * <p>
 * You can update the zonal autoshift autoshift status to enable or disable zonal autoshift. When zonal autoshift is <code>ENABLED</code> , you authorize AWS to shift away resource traffic for an application from an Availability Zone during events, on your behalf, to help reduce time to recovery. Traffic is also shifted away for the required weekly practice runs.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.arczonalshift.*;
 * CfnZonalAutoshiftConfiguration cfnZonalAutoshiftConfiguration = CfnZonalAutoshiftConfiguration.Builder.create(this, "MyCfnZonalAutoshiftConfiguration")
 *         .resourceIdentifier("resourceIdentifier")
 *         // the properties below are optional
 *         .practiceRunConfiguration(PracticeRunConfigurationProperty.builder()
 *                 .outcomeAlarms(List.of(ControlConditionProperty.builder()
 *                         .alarmIdentifier("alarmIdentifier")
 *                         .type("type")
 *                         .build()))
 *                 // the properties below are optional
 *                 .blockedDates(List.of("blockedDates"))
 *                 .blockedWindows(List.of("blockedWindows"))
 *                 .blockingAlarms(List.of(ControlConditionProperty.builder()
 *                         .alarmIdentifier("alarmIdentifier")
 *                         .type("type")
 *                         .build()))
 *                 .build())
 *         .zonalAutoshiftStatus("zonalAutoshiftStatus")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-arczonalshift-zonalautoshiftconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-arczonalshift-zonalautoshiftconfiguration.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-08-06T18:14:32.670Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_arczonalshift.CfnZonalAutoshiftConfiguration")
public class CfnZonalAutoshiftConfiguration extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnZonalAutoshiftConfiguration(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnZonalAutoshiftConfiguration(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.arczonalshift.CfnZonalAutoshiftConfiguration.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnZonalAutoshiftConfiguration(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.arczonalshift.CfnZonalAutoshiftConfigurationProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The identifier for the resource that AWS shifts traffic for.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getResourceIdentifier() {
        return software.amazon.jsii.Kernel.get(this, "resourceIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The identifier for the resource that AWS shifts traffic for.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setResourceIdentifier(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "resourceIdentifier", java.util.Objects.requireNonNull(value, "resourceIdentifier is required"));
    }

    /**
     * A practice run configuration for a resource includes the Amazon CloudWatch alarms that you've specified for a practice run, as well as any blocked dates or blocked windows for the practice run.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getPracticeRunConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "practiceRunConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A practice run configuration for a resource includes the Amazon CloudWatch alarms that you've specified for a practice run, as well as any blocked dates or blocked windows for the practice run.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPracticeRunConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "practiceRunConfiguration", value);
    }

    /**
     * A practice run configuration for a resource includes the Amazon CloudWatch alarms that you've specified for a practice run, as well as any blocked dates or blocked windows for the practice run.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPracticeRunConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.arczonalshift.CfnZonalAutoshiftConfiguration.PracticeRunConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "practiceRunConfiguration", value);
    }

    /**
     * When zonal autoshift is <code>ENABLED</code> , you authorize AWS to shift away resource traffic for an application from an Availability Zone during events, on your behalf, to help reduce time to recovery.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getZonalAutoshiftStatus() {
        return software.amazon.jsii.Kernel.get(this, "zonalAutoshiftStatus", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * When zonal autoshift is <code>ENABLED</code> , you authorize AWS to shift away resource traffic for an application from an Availability Zone during events, on your behalf, to help reduce time to recovery.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setZonalAutoshiftStatus(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "zonalAutoshiftStatus", value);
    }
    /**
     * A control condition is an alarm that you specify for a practice run.
     * <p>
     * When you configure practice runs with zonal autoshift for a resource, you specify Amazon CloudWatch alarms, which you create in CloudWatch to use with the practice run. The alarms that you specify are an <em>outcome alarm</em> , to monitor application health during practice runs and, optionally, a <em>blocking alarm</em> , to block practice runs from starting or to interrupt a practice run in progress.
     * <p>
     * Control condition alarms do not apply for autoshifts.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/r53recovery/latest/dg/arc-zonal-autoshift.considerations.html">Considerations when you configure zonal autoshift</a> in the ARC Developer Guide.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.arczonalshift.*;
     * ControlConditionProperty controlConditionProperty = ControlConditionProperty.builder()
     *         .alarmIdentifier("alarmIdentifier")
     *         .type("type")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arczonalshift-zonalautoshiftconfiguration-controlcondition.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arczonalshift-zonalautoshiftconfiguration-controlcondition.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_arczonalshift.CfnZonalAutoshiftConfiguration.ControlConditionProperty")
    @software.amazon.jsii.Jsii.Proxy(ControlConditionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ControlConditionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon Resource Name (ARN) for an Amazon CloudWatch alarm that you specify as a control condition for a practice run.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arczonalshift-zonalautoshiftconfiguration-controlcondition.html#cfn-arczonalshift-zonalautoshiftconfiguration-controlcondition-alarmidentifier">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arczonalshift-zonalautoshiftconfiguration-controlcondition.html#cfn-arczonalshift-zonalautoshiftconfiguration-controlcondition-alarmidentifier</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getAlarmIdentifier();

        /**
         * The type of alarm specified for a practice run.
         * <p>
         * You can only specify Amazon CloudWatch alarms for practice runs, so the only valid value is <code>CLOUDWATCH</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arczonalshift-zonalautoshiftconfiguration-controlcondition.html#cfn-arczonalshift-zonalautoshiftconfiguration-controlcondition-type">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arczonalshift-zonalautoshiftconfiguration-controlcondition.html#cfn-arczonalshift-zonalautoshiftconfiguration-controlcondition-type</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getType();

        /**
         * @return a {@link Builder} of {@link ControlConditionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ControlConditionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ControlConditionProperty> {
            java.lang.String alarmIdentifier;
            java.lang.String type;

            /**
             * Sets the value of {@link ControlConditionProperty#getAlarmIdentifier}
             * @param alarmIdentifier The Amazon Resource Name (ARN) for an Amazon CloudWatch alarm that you specify as a control condition for a practice run. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder alarmIdentifier(java.lang.String alarmIdentifier) {
                this.alarmIdentifier = alarmIdentifier;
                return this;
            }

            /**
             * Sets the value of {@link ControlConditionProperty#getType}
             * @param type The type of alarm specified for a practice run. This parameter is required.
             *             You can only specify Amazon CloudWatch alarms for practice runs, so the only valid value is <code>CLOUDWATCH</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ControlConditionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ControlConditionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ControlConditionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ControlConditionProperty {
            private final java.lang.String alarmIdentifier;
            private final java.lang.String type;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.alarmIdentifier = software.amazon.jsii.Kernel.get(this, "alarmIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.alarmIdentifier = java.util.Objects.requireNonNull(builder.alarmIdentifier, "alarmIdentifier is required");
                this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
            }

            @Override
            public final java.lang.String getAlarmIdentifier() {
                return this.alarmIdentifier;
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("alarmIdentifier", om.valueToTree(this.getAlarmIdentifier()));
                data.set("type", om.valueToTree(this.getType()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_arczonalshift.CfnZonalAutoshiftConfiguration.ControlConditionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ControlConditionProperty.Jsii$Proxy that = (ControlConditionProperty.Jsii$Proxy) o;

                if (!alarmIdentifier.equals(that.alarmIdentifier)) return false;
                return this.type.equals(that.type);
            }

            @Override
            public final int hashCode() {
                int result = this.alarmIdentifier.hashCode();
                result = 31 * result + (this.type.hashCode());
                return result;
            }
        }
    }
    /**
     * A practice run configuration for a resource includes the Amazon CloudWatch alarms that you've specified for a practice run, as well as any blocked dates or blocked windows for the practice run.
     * <p>
     * When a resource has a practice run configuation, ARC starts weekly zonal shifts for the resource, to shift traffic away from an Availability Zone. Weekly practice runs help you to make sure that your application can continue to operate normally with the loss of one Availability Zone.
     * <p>
     * You can update or delete a practice run configuration. When you delete a practice run configuration, zonal autoshift is disabled for the resource. A practice run configuration is required when zonal autoshift is enabled.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.arczonalshift.*;
     * PracticeRunConfigurationProperty practiceRunConfigurationProperty = PracticeRunConfigurationProperty.builder()
     *         .outcomeAlarms(List.of(ControlConditionProperty.builder()
     *                 .alarmIdentifier("alarmIdentifier")
     *                 .type("type")
     *                 .build()))
     *         // the properties below are optional
     *         .blockedDates(List.of("blockedDates"))
     *         .blockedWindows(List.of("blockedWindows"))
     *         .blockingAlarms(List.of(ControlConditionProperty.builder()
     *                 .alarmIdentifier("alarmIdentifier")
     *                 .type("type")
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arczonalshift-zonalautoshiftconfiguration-practicerunconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arczonalshift-zonalautoshiftconfiguration-practicerunconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_arczonalshift.CfnZonalAutoshiftConfiguration.PracticeRunConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(PracticeRunConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PracticeRunConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The alarm that you specify to monitor the health of your application during practice runs.
         * <p>
         * When the outcome alarm goes into an <code>ALARM</code> state, the practice run is ended and the outcome is set to <code>FAILED</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arczonalshift-zonalautoshiftconfiguration-practicerunconfiguration.html#cfn-arczonalshift-zonalautoshiftconfiguration-practicerunconfiguration-outcomealarms">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arczonalshift-zonalautoshiftconfiguration-practicerunconfiguration.html#cfn-arczonalshift-zonalautoshiftconfiguration-practicerunconfiguration-outcomealarms</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getOutcomeAlarms();

        /**
         * An array of one or more dates that you can specify when AWS does not start practice runs for a resource.
         * <p>
         * Dates are in UTC.
         * <p>
         * Specify blocked dates in the format <code>YYYY-MM-DD</code> , separated by spaces.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arczonalshift-zonalautoshiftconfiguration-practicerunconfiguration.html#cfn-arczonalshift-zonalautoshiftconfiguration-practicerunconfiguration-blockeddates">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arczonalshift-zonalautoshiftconfiguration-practicerunconfiguration.html#cfn-arczonalshift-zonalautoshiftconfiguration-practicerunconfiguration-blockeddates</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getBlockedDates() {
            return null;
        }

        /**
         * An array of one or more days and times that you can specify when ARC does not start practice runs for a resource.
         * <p>
         * Days and times are in UTC.
         * <p>
         * Specify blocked windows in the format <code>DAY:HH:MM-DAY:HH:MM</code> , separated by spaces. For example, <code>MON:18:30-MON:19:30 TUE:18:30-TUE:19:30</code> .
         * <p>
         * <blockquote>
         * <p>
         * Blocked windows have to start and end on the same day. Windows that span multiple days aren't supported.
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arczonalshift-zonalautoshiftconfiguration-practicerunconfiguration.html#cfn-arczonalshift-zonalautoshiftconfiguration-practicerunconfiguration-blockedwindows">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arczonalshift-zonalautoshiftconfiguration-practicerunconfiguration.html#cfn-arczonalshift-zonalautoshiftconfiguration-practicerunconfiguration-blockedwindows</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getBlockedWindows() {
            return null;
        }

        /**
         * An optional alarm that you can specify that blocks practice runs when the alarm is in an <code>ALARM</code> state.
         * <p>
         * When a blocking alarm goes into an <code>ALARM</code> state, it prevents practice runs from being started, and ends practice runs that are in progress.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arczonalshift-zonalautoshiftconfiguration-practicerunconfiguration.html#cfn-arczonalshift-zonalautoshiftconfiguration-practicerunconfiguration-blockingalarms">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arczonalshift-zonalautoshiftconfiguration-practicerunconfiguration.html#cfn-arczonalshift-zonalautoshiftconfiguration-practicerunconfiguration-blockingalarms</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getBlockingAlarms() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link PracticeRunConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PracticeRunConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PracticeRunConfigurationProperty> {
            java.lang.Object outcomeAlarms;
            java.util.List<java.lang.String> blockedDates;
            java.util.List<java.lang.String> blockedWindows;
            java.lang.Object blockingAlarms;

            /**
             * Sets the value of {@link PracticeRunConfigurationProperty#getOutcomeAlarms}
             * @param outcomeAlarms The alarm that you specify to monitor the health of your application during practice runs. This parameter is required.
             *                      When the outcome alarm goes into an <code>ALARM</code> state, the practice run is ended and the outcome is set to <code>FAILED</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder outcomeAlarms(software.amazon.awscdk.IResolvable outcomeAlarms) {
                this.outcomeAlarms = outcomeAlarms;
                return this;
            }

            /**
             * Sets the value of {@link PracticeRunConfigurationProperty#getOutcomeAlarms}
             * @param outcomeAlarms The alarm that you specify to monitor the health of your application during practice runs. This parameter is required.
             *                      When the outcome alarm goes into an <code>ALARM</code> state, the practice run is ended and the outcome is set to <code>FAILED</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder outcomeAlarms(java.util.List<? extends java.lang.Object> outcomeAlarms) {
                this.outcomeAlarms = outcomeAlarms;
                return this;
            }

            /**
             * Sets the value of {@link PracticeRunConfigurationProperty#getBlockedDates}
             * @param blockedDates An array of one or more dates that you can specify when AWS does not start practice runs for a resource.
             *                     Dates are in UTC.
             *                     <p>
             *                     Specify blocked dates in the format <code>YYYY-MM-DD</code> , separated by spaces.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder blockedDates(java.util.List<java.lang.String> blockedDates) {
                this.blockedDates = blockedDates;
                return this;
            }

            /**
             * Sets the value of {@link PracticeRunConfigurationProperty#getBlockedWindows}
             * @param blockedWindows An array of one or more days and times that you can specify when ARC does not start practice runs for a resource.
             *                       Days and times are in UTC.
             *                       <p>
             *                       Specify blocked windows in the format <code>DAY:HH:MM-DAY:HH:MM</code> , separated by spaces. For example, <code>MON:18:30-MON:19:30 TUE:18:30-TUE:19:30</code> .
             *                       <p>
             *                       <blockquote>
             *                       <p>
             *                       Blocked windows have to start and end on the same day. Windows that span multiple days aren't supported.
             *                       <p>
             *                       </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder blockedWindows(java.util.List<java.lang.String> blockedWindows) {
                this.blockedWindows = blockedWindows;
                return this;
            }

            /**
             * Sets the value of {@link PracticeRunConfigurationProperty#getBlockingAlarms}
             * @param blockingAlarms An optional alarm that you can specify that blocks practice runs when the alarm is in an <code>ALARM</code> state.
             *                       When a blocking alarm goes into an <code>ALARM</code> state, it prevents practice runs from being started, and ends practice runs that are in progress.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder blockingAlarms(software.amazon.awscdk.IResolvable blockingAlarms) {
                this.blockingAlarms = blockingAlarms;
                return this;
            }

            /**
             * Sets the value of {@link PracticeRunConfigurationProperty#getBlockingAlarms}
             * @param blockingAlarms An optional alarm that you can specify that blocks practice runs when the alarm is in an <code>ALARM</code> state.
             *                       When a blocking alarm goes into an <code>ALARM</code> state, it prevents practice runs from being started, and ends practice runs that are in progress.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder blockingAlarms(java.util.List<? extends java.lang.Object> blockingAlarms) {
                this.blockingAlarms = blockingAlarms;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PracticeRunConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PracticeRunConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PracticeRunConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PracticeRunConfigurationProperty {
            private final java.lang.Object outcomeAlarms;
            private final java.util.List<java.lang.String> blockedDates;
            private final java.util.List<java.lang.String> blockedWindows;
            private final java.lang.Object blockingAlarms;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.outcomeAlarms = software.amazon.jsii.Kernel.get(this, "outcomeAlarms", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.blockedDates = software.amazon.jsii.Kernel.get(this, "blockedDates", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.blockedWindows = software.amazon.jsii.Kernel.get(this, "blockedWindows", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.blockingAlarms = software.amazon.jsii.Kernel.get(this, "blockingAlarms", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.outcomeAlarms = java.util.Objects.requireNonNull(builder.outcomeAlarms, "outcomeAlarms is required");
                this.blockedDates = builder.blockedDates;
                this.blockedWindows = builder.blockedWindows;
                this.blockingAlarms = builder.blockingAlarms;
            }

            @Override
            public final java.lang.Object getOutcomeAlarms() {
                return this.outcomeAlarms;
            }

            @Override
            public final java.util.List<java.lang.String> getBlockedDates() {
                return this.blockedDates;
            }

            @Override
            public final java.util.List<java.lang.String> getBlockedWindows() {
                return this.blockedWindows;
            }

            @Override
            public final java.lang.Object getBlockingAlarms() {
                return this.blockingAlarms;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("outcomeAlarms", om.valueToTree(this.getOutcomeAlarms()));
                if (this.getBlockedDates() != null) {
                    data.set("blockedDates", om.valueToTree(this.getBlockedDates()));
                }
                if (this.getBlockedWindows() != null) {
                    data.set("blockedWindows", om.valueToTree(this.getBlockedWindows()));
                }
                if (this.getBlockingAlarms() != null) {
                    data.set("blockingAlarms", om.valueToTree(this.getBlockingAlarms()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_arczonalshift.CfnZonalAutoshiftConfiguration.PracticeRunConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PracticeRunConfigurationProperty.Jsii$Proxy that = (PracticeRunConfigurationProperty.Jsii$Proxy) o;

                if (!outcomeAlarms.equals(that.outcomeAlarms)) return false;
                if (this.blockedDates != null ? !this.blockedDates.equals(that.blockedDates) : that.blockedDates != null) return false;
                if (this.blockedWindows != null ? !this.blockedWindows.equals(that.blockedWindows) : that.blockedWindows != null) return false;
                return this.blockingAlarms != null ? this.blockingAlarms.equals(that.blockingAlarms) : that.blockingAlarms == null;
            }

            @Override
            public final int hashCode() {
                int result = this.outcomeAlarms.hashCode();
                result = 31 * result + (this.blockedDates != null ? this.blockedDates.hashCode() : 0);
                result = 31 * result + (this.blockedWindows != null ? this.blockedWindows.hashCode() : 0);
                result = 31 * result + (this.blockingAlarms != null ? this.blockingAlarms.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.arczonalshift.CfnZonalAutoshiftConfiguration}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.arczonalshift.CfnZonalAutoshiftConfiguration> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.arczonalshift.CfnZonalAutoshiftConfigurationProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.arczonalshift.CfnZonalAutoshiftConfigurationProps.Builder();
        }

        /**
         * The identifier for the resource that AWS shifts traffic for.
         * <p>
         * The identifier is the Amazon Resource Name (ARN) for the resource.
         * <p>
         * At this time, supported resources are Network Load Balancers and Application Load Balancers.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-arczonalshift-zonalautoshiftconfiguration.html#cfn-arczonalshift-zonalautoshiftconfiguration-resourceidentifier">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-arczonalshift-zonalautoshiftconfiguration.html#cfn-arczonalshift-zonalautoshiftconfiguration-resourceidentifier</a>
         * @param resourceIdentifier The identifier for the resource that AWS shifts traffic for. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resourceIdentifier(final java.lang.String resourceIdentifier) {
            this.props.resourceIdentifier(resourceIdentifier);
            return this;
        }

        /**
         * A practice run configuration for a resource includes the Amazon CloudWatch alarms that you've specified for a practice run, as well as any blocked dates or blocked windows for the practice run.
         * <p>
         * When a resource has a practice run configuration, ARC shifts traffic for the resource weekly for practice runs.
         * <p>
         * Practice runs are required for zonal autoshift. The zonal shifts that ARC starts for practice runs help you to ensure that shifting away traffic from an Availability Zone during an autoshift is safe for your application.
         * <p>
         * You can update or delete a practice run configuration. Before you delete a practice run configuration, you must disable zonal autoshift for the resource. A practice run configuration is required when zonal autoshift is enabled.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-arczonalshift-zonalautoshiftconfiguration.html#cfn-arczonalshift-zonalautoshiftconfiguration-practicerunconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-arczonalshift-zonalautoshiftconfiguration.html#cfn-arczonalshift-zonalautoshiftconfiguration-practicerunconfiguration</a>
         * @param practiceRunConfiguration A practice run configuration for a resource includes the Amazon CloudWatch alarms that you've specified for a practice run, as well as any blocked dates or blocked windows for the practice run. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder practiceRunConfiguration(final software.amazon.awscdk.IResolvable practiceRunConfiguration) {
            this.props.practiceRunConfiguration(practiceRunConfiguration);
            return this;
        }
        /**
         * A practice run configuration for a resource includes the Amazon CloudWatch alarms that you've specified for a practice run, as well as any blocked dates or blocked windows for the practice run.
         * <p>
         * When a resource has a practice run configuration, ARC shifts traffic for the resource weekly for practice runs.
         * <p>
         * Practice runs are required for zonal autoshift. The zonal shifts that ARC starts for practice runs help you to ensure that shifting away traffic from an Availability Zone during an autoshift is safe for your application.
         * <p>
         * You can update or delete a practice run configuration. Before you delete a practice run configuration, you must disable zonal autoshift for the resource. A practice run configuration is required when zonal autoshift is enabled.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-arczonalshift-zonalautoshiftconfiguration.html#cfn-arczonalshift-zonalautoshiftconfiguration-practicerunconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-arczonalshift-zonalautoshiftconfiguration.html#cfn-arczonalshift-zonalautoshiftconfiguration-practicerunconfiguration</a>
         * @param practiceRunConfiguration A practice run configuration for a resource includes the Amazon CloudWatch alarms that you've specified for a practice run, as well as any blocked dates or blocked windows for the practice run. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder practiceRunConfiguration(final software.amazon.awscdk.services.arczonalshift.CfnZonalAutoshiftConfiguration.PracticeRunConfigurationProperty practiceRunConfiguration) {
            this.props.practiceRunConfiguration(practiceRunConfiguration);
            return this;
        }

        /**
         * When zonal autoshift is <code>ENABLED</code> , you authorize AWS to shift away resource traffic for an application from an Availability Zone during events, on your behalf, to help reduce time to recovery.
         * <p>
         * Traffic is also shifted away for the required weekly practice runs.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-arczonalshift-zonalautoshiftconfiguration.html#cfn-arczonalshift-zonalautoshiftconfiguration-zonalautoshiftstatus">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-arczonalshift-zonalautoshiftconfiguration.html#cfn-arczonalshift-zonalautoshiftconfiguration-zonalautoshiftstatus</a>
         * @param zonalAutoshiftStatus When zonal autoshift is <code>ENABLED</code> , you authorize AWS to shift away resource traffic for an application from an Availability Zone during events, on your behalf, to help reduce time to recovery. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder zonalAutoshiftStatus(final java.lang.String zonalAutoshiftStatus) {
            this.props.zonalAutoshiftStatus(zonalAutoshiftStatus);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.arczonalshift.CfnZonalAutoshiftConfiguration}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.arczonalshift.CfnZonalAutoshiftConfiguration build() {
            return new software.amazon.awscdk.services.arczonalshift.CfnZonalAutoshiftConfiguration(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
