package software.amazon.awscdk.services.autoscaling;

/**
 * Result of binding a lifecycle hook to a target.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.autoscaling.*;
 * import software.amazon.awscdk.services.iam.*;
 * Role role;
 * LifecycleHookTargetConfig lifecycleHookTargetConfig = LifecycleHookTargetConfig.builder()
 *         .createdRole(role)
 *         .notificationTargetArn("notificationTargetArn")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-08-06T18:14:32.862Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_autoscaling.LifecycleHookTargetConfig")
@software.amazon.jsii.Jsii.Proxy(LifecycleHookTargetConfig.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface LifecycleHookTargetConfig extends software.amazon.jsii.JsiiSerializable {

    /**
     * The IRole that was used to bind the lifecycle hook to the target.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IRole getCreatedRole();

    /**
     * The targetArn that the lifecycle hook was bound to.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getNotificationTargetArn();

    /**
     * @return a {@link Builder} of {@link LifecycleHookTargetConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link LifecycleHookTargetConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<LifecycleHookTargetConfig> {
        software.amazon.awscdk.services.iam.IRole createdRole;
        java.lang.String notificationTargetArn;

        /**
         * Sets the value of {@link LifecycleHookTargetConfig#getCreatedRole}
         * @param createdRole The IRole that was used to bind the lifecycle hook to the target. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder createdRole(software.amazon.awscdk.services.iam.IRole createdRole) {
            this.createdRole = createdRole;
            return this;
        }

        /**
         * Sets the value of {@link LifecycleHookTargetConfig#getNotificationTargetArn}
         * @param notificationTargetArn The targetArn that the lifecycle hook was bound to. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder notificationTargetArn(java.lang.String notificationTargetArn) {
            this.notificationTargetArn = notificationTargetArn;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link LifecycleHookTargetConfig}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public LifecycleHookTargetConfig build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link LifecycleHookTargetConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LifecycleHookTargetConfig {
        private final software.amazon.awscdk.services.iam.IRole createdRole;
        private final java.lang.String notificationTargetArn;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.createdRole = software.amazon.jsii.Kernel.get(this, "createdRole", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
            this.notificationTargetArn = software.amazon.jsii.Kernel.get(this, "notificationTargetArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.createdRole = java.util.Objects.requireNonNull(builder.createdRole, "createdRole is required");
            this.notificationTargetArn = java.util.Objects.requireNonNull(builder.notificationTargetArn, "notificationTargetArn is required");
        }

        @Override
        public final software.amazon.awscdk.services.iam.IRole getCreatedRole() {
            return this.createdRole;
        }

        @Override
        public final java.lang.String getNotificationTargetArn() {
            return this.notificationTargetArn;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("createdRole", om.valueToTree(this.getCreatedRole()));
            data.set("notificationTargetArn", om.valueToTree(this.getNotificationTargetArn()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_autoscaling.LifecycleHookTargetConfig"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            LifecycleHookTargetConfig.Jsii$Proxy that = (LifecycleHookTargetConfig.Jsii$Proxy) o;

            if (!createdRole.equals(that.createdRole)) return false;
            return this.notificationTargetArn.equals(that.notificationTargetArn);
        }

        @Override
        public final int hashCode() {
            int result = this.createdRole.hashCode();
            result = 31 * result + (this.notificationTargetArn.hashCode());
            return result;
        }
    }
}
