package software.amazon.awscdk.services.batch;

/**
 * Properties for defining a <code>CfnJobDefinition</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobdefinition.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobdefinition.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-08-06T18:14:33.086Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_batch.CfnJobDefinitionProps")
@software.amazon.jsii.Jsii.Proxy(CfnJobDefinitionProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnJobDefinitionProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The type of job definition.
     * <p>
     * For more information about multi-node parallel jobs, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/multi-node-job-def.html">Creating a multi-node parallel job definition</a> in the <em>AWS Batch User Guide</em> .
     * <p>
     * <ul>
     * <li>If the value is <code>container</code> , then one of the following is required: <code>containerProperties</code> , <code>ecsProperties</code> , or <code>eksProperties</code> .</li>
     * <li>If the value is <code>multinode</code> , then <code>nodeProperties</code> is required.</li>
     * </ul>
     * <p>
     * <blockquote>
     * <p>
     * If the job is run on Fargate resources, then <code>multinode</code> isn't supported.
     * <p>
     * </blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobdefinition.html#cfn-batch-jobdefinition-type">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobdefinition.html#cfn-batch-jobdefinition-type</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getType();

    /**
     * Contains a list of consumable resources required by the job.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobdefinition.html#cfn-batch-jobdefinition-consumableresourceproperties">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobdefinition.html#cfn-batch-jobdefinition-consumableresourceproperties</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getConsumableResourceProperties() {
        return null;
    }

    /**
     * An object with properties specific to Amazon ECS-based jobs.
     * <p>
     * When <code>containerProperties</code> is used in the job definition, it can't be used in addition to <code>eksProperties</code> , <code>ecsProperties</code> , or <code>nodeProperties</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobdefinition.html#cfn-batch-jobdefinition-containerproperties">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobdefinition.html#cfn-batch-jobdefinition-containerproperties</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getContainerProperties() {
        return null;
    }

    /**
     * An object that contains the properties for the Amazon ECS resources of a job.When <code>ecsProperties</code> is used in the job definition, it can't be used in addition to <code>containerProperties</code> , <code>eksProperties</code> , or <code>nodeProperties</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobdefinition.html#cfn-batch-jobdefinition-ecsproperties">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobdefinition.html#cfn-batch-jobdefinition-ecsproperties</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getEcsProperties() {
        return null;
    }

    /**
     * An object with properties that are specific to Amazon EKS-based jobs.
     * <p>
     * When <code>eksProperties</code> is used in the job definition, it can't be used in addition to <code>containerProperties</code> , <code>ecsProperties</code> , or <code>nodeProperties</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobdefinition.html#cfn-batch-jobdefinition-eksproperties">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobdefinition.html#cfn-batch-jobdefinition-eksproperties</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getEksProperties() {
        return null;
    }

    /**
     * The name of the job definition.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobdefinition.html#cfn-batch-jobdefinition-jobdefinitionname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobdefinition.html#cfn-batch-jobdefinition-jobdefinitionname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getJobDefinitionName() {
        return null;
    }

    /**
     * An object with properties that are specific to multi-node parallel jobs.
     * <p>
     * When <code>nodeProperties</code> is used in the job definition, it can't be used in addition to <code>containerProperties</code> , <code>ecsProperties</code> , or <code>eksProperties</code> .
     * <p>
     * <blockquote>
     * <p>
     * If the job runs on Fargate resources, don't specify <code>nodeProperties</code> . Use <code>containerProperties</code> instead.
     * <p>
     * </blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobdefinition.html#cfn-batch-jobdefinition-nodeproperties">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobdefinition.html#cfn-batch-jobdefinition-nodeproperties</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getNodeProperties() {
        return null;
    }

    /**
     * Default parameters or parameter substitution placeholders that are set in the job definition.
     * <p>
     * Parameters are specified as a key-value pair mapping. Parameters in a <code>SubmitJob</code> request override any corresponding parameter defaults from the job definition. For more information about specifying parameters, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/job_definition_parameters.html">Job definition parameters</a> in the <em>AWS Batch User Guide</em> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobdefinition.html#cfn-batch-jobdefinition-parameters">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobdefinition.html#cfn-batch-jobdefinition-parameters</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getParameters() {
        return null;
    }

    /**
     * The platform capabilities required by the job definition.
     * <p>
     * If no value is specified, it defaults to <code>EC2</code> . Jobs run on Fargate resources specify <code>FARGATE</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobdefinition.html#cfn-batch-jobdefinition-platformcapabilities">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobdefinition.html#cfn-batch-jobdefinition-platformcapabilities</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getPlatformCapabilities() {
        return null;
    }

    /**
     * Specifies whether to propagate the tags from the job or job definition to the corresponding Amazon ECS task.
     * <p>
     * If no value is specified, the tags aren't propagated. Tags can only be propagated to the tasks when the tasks are created. For tags with the same name, job tags are given priority over job definitions tags. If the total number of combined tags from the job and job definition is over 50, the job is moved to the <code>FAILED</code> state.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobdefinition.html#cfn-batch-jobdefinition-propagatetags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobdefinition.html#cfn-batch-jobdefinition-propagatetags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getPropagateTags() {
        return null;
    }

    /**
     * The retry strategy to use for failed jobs that are submitted with this job definition.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobdefinition.html#cfn-batch-jobdefinition-retrystrategy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobdefinition.html#cfn-batch-jobdefinition-retrystrategy</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getRetryStrategy() {
        return null;
    }

    /**
     * The scheduling priority of the job definition.
     * <p>
     * This only affects jobs in job queues with a fair-share policy. Jobs with a higher scheduling priority are scheduled before jobs with a lower scheduling priority.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobdefinition.html#cfn-batch-jobdefinition-schedulingpriority">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobdefinition.html#cfn-batch-jobdefinition-schedulingpriority</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getSchedulingPriority() {
        return null;
    }

    /**
     * The tags that are applied to the job definition.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobdefinition.html#cfn-batch-jobdefinition-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobdefinition.html#cfn-batch-jobdefinition-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getTags() {
        return null;
    }

    /**
     * The timeout time for jobs that are submitted with this job definition.
     * <p>
     * After the amount of time you specify passes, AWS Batch terminates your jobs if they aren't finished.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobdefinition.html#cfn-batch-jobdefinition-timeout">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobdefinition.html#cfn-batch-jobdefinition-timeout</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getTimeout() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnJobDefinitionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnJobDefinitionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnJobDefinitionProps> {
        java.lang.String type;
        java.lang.Object consumableResourceProperties;
        java.lang.Object containerProperties;
        java.lang.Object ecsProperties;
        java.lang.Object eksProperties;
        java.lang.String jobDefinitionName;
        java.lang.Object nodeProperties;
        java.lang.Object parameters;
        java.util.List<java.lang.String> platformCapabilities;
        java.lang.Object propagateTags;
        java.lang.Object retryStrategy;
        java.lang.Number schedulingPriority;
        java.lang.Object tags;
        java.lang.Object timeout;

        /**
         * Sets the value of {@link CfnJobDefinitionProps#getType}
         * @param type The type of job definition. This parameter is required.
         *             For more information about multi-node parallel jobs, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/multi-node-job-def.html">Creating a multi-node parallel job definition</a> in the <em>AWS Batch User Guide</em> .
         *             <p>
         *             <ul>
         *             <li>If the value is <code>container</code> , then one of the following is required: <code>containerProperties</code> , <code>ecsProperties</code> , or <code>eksProperties</code> .</li>
         *             <li>If the value is <code>multinode</code> , then <code>nodeProperties</code> is required.</li>
         *             </ul>
         *             <p>
         *             <blockquote>
         *             <p>
         *             If the job is run on Fargate resources, then <code>multinode</code> isn't supported.
         *             <p>
         *             </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder type(java.lang.String type) {
            this.type = type;
            return this;
        }

        /**
         * Sets the value of {@link CfnJobDefinitionProps#getConsumableResourceProperties}
         * @param consumableResourceProperties Contains a list of consumable resources required by the job.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder consumableResourceProperties(software.amazon.awscdk.IResolvable consumableResourceProperties) {
            this.consumableResourceProperties = consumableResourceProperties;
            return this;
        }

        /**
         * Sets the value of {@link CfnJobDefinitionProps#getConsumableResourceProperties}
         * @param consumableResourceProperties Contains a list of consumable resources required by the job.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder consumableResourceProperties(software.amazon.awscdk.services.batch.CfnJobDefinition.ConsumableResourcePropertiesProperty consumableResourceProperties) {
            this.consumableResourceProperties = consumableResourceProperties;
            return this;
        }

        /**
         * Sets the value of {@link CfnJobDefinitionProps#getContainerProperties}
         * @param containerProperties An object with properties specific to Amazon ECS-based jobs.
         *                            When <code>containerProperties</code> is used in the job definition, it can't be used in addition to <code>eksProperties</code> , <code>ecsProperties</code> , or <code>nodeProperties</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder containerProperties(software.amazon.awscdk.IResolvable containerProperties) {
            this.containerProperties = containerProperties;
            return this;
        }

        /**
         * Sets the value of {@link CfnJobDefinitionProps#getContainerProperties}
         * @param containerProperties An object with properties specific to Amazon ECS-based jobs.
         *                            When <code>containerProperties</code> is used in the job definition, it can't be used in addition to <code>eksProperties</code> , <code>ecsProperties</code> , or <code>nodeProperties</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder containerProperties(software.amazon.awscdk.services.batch.CfnJobDefinition.ContainerPropertiesProperty containerProperties) {
            this.containerProperties = containerProperties;
            return this;
        }

        /**
         * Sets the value of {@link CfnJobDefinitionProps#getEcsProperties}
         * @param ecsProperties An object that contains the properties for the Amazon ECS resources of a job.When <code>ecsProperties</code> is used in the job definition, it can't be used in addition to <code>containerProperties</code> , <code>eksProperties</code> , or <code>nodeProperties</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ecsProperties(software.amazon.awscdk.IResolvable ecsProperties) {
            this.ecsProperties = ecsProperties;
            return this;
        }

        /**
         * Sets the value of {@link CfnJobDefinitionProps#getEcsProperties}
         * @param ecsProperties An object that contains the properties for the Amazon ECS resources of a job.When <code>ecsProperties</code> is used in the job definition, it can't be used in addition to <code>containerProperties</code> , <code>eksProperties</code> , or <code>nodeProperties</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ecsProperties(software.amazon.awscdk.services.batch.CfnJobDefinition.EcsPropertiesProperty ecsProperties) {
            this.ecsProperties = ecsProperties;
            return this;
        }

        /**
         * Sets the value of {@link CfnJobDefinitionProps#getEksProperties}
         * @param eksProperties An object with properties that are specific to Amazon EKS-based jobs.
         *                      When <code>eksProperties</code> is used in the job definition, it can't be used in addition to <code>containerProperties</code> , <code>ecsProperties</code> , or <code>nodeProperties</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder eksProperties(software.amazon.awscdk.IResolvable eksProperties) {
            this.eksProperties = eksProperties;
            return this;
        }

        /**
         * Sets the value of {@link CfnJobDefinitionProps#getEksProperties}
         * @param eksProperties An object with properties that are specific to Amazon EKS-based jobs.
         *                      When <code>eksProperties</code> is used in the job definition, it can't be used in addition to <code>containerProperties</code> , <code>ecsProperties</code> , or <code>nodeProperties</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder eksProperties(software.amazon.awscdk.services.batch.CfnJobDefinition.EksPropertiesProperty eksProperties) {
            this.eksProperties = eksProperties;
            return this;
        }

        /**
         * Sets the value of {@link CfnJobDefinitionProps#getJobDefinitionName}
         * @param jobDefinitionName The name of the job definition.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder jobDefinitionName(java.lang.String jobDefinitionName) {
            this.jobDefinitionName = jobDefinitionName;
            return this;
        }

        /**
         * Sets the value of {@link CfnJobDefinitionProps#getNodeProperties}
         * @param nodeProperties An object with properties that are specific to multi-node parallel jobs.
         *                       When <code>nodeProperties</code> is used in the job definition, it can't be used in addition to <code>containerProperties</code> , <code>ecsProperties</code> , or <code>eksProperties</code> .
         *                       <p>
         *                       <blockquote>
         *                       <p>
         *                       If the job runs on Fargate resources, don't specify <code>nodeProperties</code> . Use <code>containerProperties</code> instead.
         *                       <p>
         *                       </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder nodeProperties(software.amazon.awscdk.IResolvable nodeProperties) {
            this.nodeProperties = nodeProperties;
            return this;
        }

        /**
         * Sets the value of {@link CfnJobDefinitionProps#getNodeProperties}
         * @param nodeProperties An object with properties that are specific to multi-node parallel jobs.
         *                       When <code>nodeProperties</code> is used in the job definition, it can't be used in addition to <code>containerProperties</code> , <code>ecsProperties</code> , or <code>eksProperties</code> .
         *                       <p>
         *                       <blockquote>
         *                       <p>
         *                       If the job runs on Fargate resources, don't specify <code>nodeProperties</code> . Use <code>containerProperties</code> instead.
         *                       <p>
         *                       </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder nodeProperties(software.amazon.awscdk.services.batch.CfnJobDefinition.NodePropertiesProperty nodeProperties) {
            this.nodeProperties = nodeProperties;
            return this;
        }

        /**
         * Sets the value of {@link CfnJobDefinitionProps#getParameters}
         * @param parameters Default parameters or parameter substitution placeholders that are set in the job definition.
         *                   Parameters are specified as a key-value pair mapping. Parameters in a <code>SubmitJob</code> request override any corresponding parameter defaults from the job definition. For more information about specifying parameters, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/job_definition_parameters.html">Job definition parameters</a> in the <em>AWS Batch User Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder parameters(java.lang.Object parameters) {
            this.parameters = parameters;
            return this;
        }

        /**
         * Sets the value of {@link CfnJobDefinitionProps#getPlatformCapabilities}
         * @param platformCapabilities The platform capabilities required by the job definition.
         *                             If no value is specified, it defaults to <code>EC2</code> . Jobs run on Fargate resources specify <code>FARGATE</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder platformCapabilities(java.util.List<java.lang.String> platformCapabilities) {
            this.platformCapabilities = platformCapabilities;
            return this;
        }

        /**
         * Sets the value of {@link CfnJobDefinitionProps#getPropagateTags}
         * @param propagateTags Specifies whether to propagate the tags from the job or job definition to the corresponding Amazon ECS task.
         *                      If no value is specified, the tags aren't propagated. Tags can only be propagated to the tasks when the tasks are created. For tags with the same name, job tags are given priority over job definitions tags. If the total number of combined tags from the job and job definition is over 50, the job is moved to the <code>FAILED</code> state.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder propagateTags(java.lang.Boolean propagateTags) {
            this.propagateTags = propagateTags;
            return this;
        }

        /**
         * Sets the value of {@link CfnJobDefinitionProps#getPropagateTags}
         * @param propagateTags Specifies whether to propagate the tags from the job or job definition to the corresponding Amazon ECS task.
         *                      If no value is specified, the tags aren't propagated. Tags can only be propagated to the tasks when the tasks are created. For tags with the same name, job tags are given priority over job definitions tags. If the total number of combined tags from the job and job definition is over 50, the job is moved to the <code>FAILED</code> state.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder propagateTags(software.amazon.awscdk.IResolvable propagateTags) {
            this.propagateTags = propagateTags;
            return this;
        }

        /**
         * Sets the value of {@link CfnJobDefinitionProps#getRetryStrategy}
         * @param retryStrategy The retry strategy to use for failed jobs that are submitted with this job definition.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder retryStrategy(software.amazon.awscdk.IResolvable retryStrategy) {
            this.retryStrategy = retryStrategy;
            return this;
        }

        /**
         * Sets the value of {@link CfnJobDefinitionProps#getRetryStrategy}
         * @param retryStrategy The retry strategy to use for failed jobs that are submitted with this job definition.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder retryStrategy(software.amazon.awscdk.services.batch.CfnJobDefinition.RetryStrategyProperty retryStrategy) {
            this.retryStrategy = retryStrategy;
            return this;
        }

        /**
         * Sets the value of {@link CfnJobDefinitionProps#getSchedulingPriority}
         * @param schedulingPriority The scheduling priority of the job definition.
         *                           This only affects jobs in job queues with a fair-share policy. Jobs with a higher scheduling priority are scheduled before jobs with a lower scheduling priority.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder schedulingPriority(java.lang.Number schedulingPriority) {
            this.schedulingPriority = schedulingPriority;
            return this;
        }

        /**
         * Sets the value of {@link CfnJobDefinitionProps#getTags}
         * @param tags The tags that are applied to the job definition.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(java.lang.Object tags) {
            this.tags = tags;
            return this;
        }

        /**
         * Sets the value of {@link CfnJobDefinitionProps#getTimeout}
         * @param timeout The timeout time for jobs that are submitted with this job definition.
         *                After the amount of time you specify passes, AWS Batch terminates your jobs if they aren't finished.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder timeout(software.amazon.awscdk.IResolvable timeout) {
            this.timeout = timeout;
            return this;
        }

        /**
         * Sets the value of {@link CfnJobDefinitionProps#getTimeout}
         * @param timeout The timeout time for jobs that are submitted with this job definition.
         *                After the amount of time you specify passes, AWS Batch terminates your jobs if they aren't finished.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder timeout(software.amazon.awscdk.services.batch.CfnJobDefinition.TimeoutProperty timeout) {
            this.timeout = timeout;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnJobDefinitionProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnJobDefinitionProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnJobDefinitionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnJobDefinitionProps {
        private final java.lang.String type;
        private final java.lang.Object consumableResourceProperties;
        private final java.lang.Object containerProperties;
        private final java.lang.Object ecsProperties;
        private final java.lang.Object eksProperties;
        private final java.lang.String jobDefinitionName;
        private final java.lang.Object nodeProperties;
        private final java.lang.Object parameters;
        private final java.util.List<java.lang.String> platformCapabilities;
        private final java.lang.Object propagateTags;
        private final java.lang.Object retryStrategy;
        private final java.lang.Number schedulingPriority;
        private final java.lang.Object tags;
        private final java.lang.Object timeout;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.consumableResourceProperties = software.amazon.jsii.Kernel.get(this, "consumableResourceProperties", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.containerProperties = software.amazon.jsii.Kernel.get(this, "containerProperties", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.ecsProperties = software.amazon.jsii.Kernel.get(this, "ecsProperties", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.eksProperties = software.amazon.jsii.Kernel.get(this, "eksProperties", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.jobDefinitionName = software.amazon.jsii.Kernel.get(this, "jobDefinitionName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.nodeProperties = software.amazon.jsii.Kernel.get(this, "nodeProperties", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.parameters = software.amazon.jsii.Kernel.get(this, "parameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.platformCapabilities = software.amazon.jsii.Kernel.get(this, "platformCapabilities", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.propagateTags = software.amazon.jsii.Kernel.get(this, "propagateTags", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.retryStrategy = software.amazon.jsii.Kernel.get(this, "retryStrategy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.schedulingPriority = software.amazon.jsii.Kernel.get(this, "schedulingPriority", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.timeout = software.amazon.jsii.Kernel.get(this, "timeout", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
            this.consumableResourceProperties = builder.consumableResourceProperties;
            this.containerProperties = builder.containerProperties;
            this.ecsProperties = builder.ecsProperties;
            this.eksProperties = builder.eksProperties;
            this.jobDefinitionName = builder.jobDefinitionName;
            this.nodeProperties = builder.nodeProperties;
            this.parameters = builder.parameters;
            this.platformCapabilities = builder.platformCapabilities;
            this.propagateTags = builder.propagateTags;
            this.retryStrategy = builder.retryStrategy;
            this.schedulingPriority = builder.schedulingPriority;
            this.tags = builder.tags;
            this.timeout = builder.timeout;
        }

        @Override
        public final java.lang.String getType() {
            return this.type;
        }

        @Override
        public final java.lang.Object getConsumableResourceProperties() {
            return this.consumableResourceProperties;
        }

        @Override
        public final java.lang.Object getContainerProperties() {
            return this.containerProperties;
        }

        @Override
        public final java.lang.Object getEcsProperties() {
            return this.ecsProperties;
        }

        @Override
        public final java.lang.Object getEksProperties() {
            return this.eksProperties;
        }

        @Override
        public final java.lang.String getJobDefinitionName() {
            return this.jobDefinitionName;
        }

        @Override
        public final java.lang.Object getNodeProperties() {
            return this.nodeProperties;
        }

        @Override
        public final java.lang.Object getParameters() {
            return this.parameters;
        }

        @Override
        public final java.util.List<java.lang.String> getPlatformCapabilities() {
            return this.platformCapabilities;
        }

        @Override
        public final java.lang.Object getPropagateTags() {
            return this.propagateTags;
        }

        @Override
        public final java.lang.Object getRetryStrategy() {
            return this.retryStrategy;
        }

        @Override
        public final java.lang.Number getSchedulingPriority() {
            return this.schedulingPriority;
        }

        @Override
        public final java.lang.Object getTags() {
            return this.tags;
        }

        @Override
        public final java.lang.Object getTimeout() {
            return this.timeout;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("type", om.valueToTree(this.getType()));
            if (this.getConsumableResourceProperties() != null) {
                data.set("consumableResourceProperties", om.valueToTree(this.getConsumableResourceProperties()));
            }
            if (this.getContainerProperties() != null) {
                data.set("containerProperties", om.valueToTree(this.getContainerProperties()));
            }
            if (this.getEcsProperties() != null) {
                data.set("ecsProperties", om.valueToTree(this.getEcsProperties()));
            }
            if (this.getEksProperties() != null) {
                data.set("eksProperties", om.valueToTree(this.getEksProperties()));
            }
            if (this.getJobDefinitionName() != null) {
                data.set("jobDefinitionName", om.valueToTree(this.getJobDefinitionName()));
            }
            if (this.getNodeProperties() != null) {
                data.set("nodeProperties", om.valueToTree(this.getNodeProperties()));
            }
            if (this.getParameters() != null) {
                data.set("parameters", om.valueToTree(this.getParameters()));
            }
            if (this.getPlatformCapabilities() != null) {
                data.set("platformCapabilities", om.valueToTree(this.getPlatformCapabilities()));
            }
            if (this.getPropagateTags() != null) {
                data.set("propagateTags", om.valueToTree(this.getPropagateTags()));
            }
            if (this.getRetryStrategy() != null) {
                data.set("retryStrategy", om.valueToTree(this.getRetryStrategy()));
            }
            if (this.getSchedulingPriority() != null) {
                data.set("schedulingPriority", om.valueToTree(this.getSchedulingPriority()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getTimeout() != null) {
                data.set("timeout", om.valueToTree(this.getTimeout()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_batch.CfnJobDefinitionProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnJobDefinitionProps.Jsii$Proxy that = (CfnJobDefinitionProps.Jsii$Proxy) o;

            if (!type.equals(that.type)) return false;
            if (this.consumableResourceProperties != null ? !this.consumableResourceProperties.equals(that.consumableResourceProperties) : that.consumableResourceProperties != null) return false;
            if (this.containerProperties != null ? !this.containerProperties.equals(that.containerProperties) : that.containerProperties != null) return false;
            if (this.ecsProperties != null ? !this.ecsProperties.equals(that.ecsProperties) : that.ecsProperties != null) return false;
            if (this.eksProperties != null ? !this.eksProperties.equals(that.eksProperties) : that.eksProperties != null) return false;
            if (this.jobDefinitionName != null ? !this.jobDefinitionName.equals(that.jobDefinitionName) : that.jobDefinitionName != null) return false;
            if (this.nodeProperties != null ? !this.nodeProperties.equals(that.nodeProperties) : that.nodeProperties != null) return false;
            if (this.parameters != null ? !this.parameters.equals(that.parameters) : that.parameters != null) return false;
            if (this.platformCapabilities != null ? !this.platformCapabilities.equals(that.platformCapabilities) : that.platformCapabilities != null) return false;
            if (this.propagateTags != null ? !this.propagateTags.equals(that.propagateTags) : that.propagateTags != null) return false;
            if (this.retryStrategy != null ? !this.retryStrategy.equals(that.retryStrategy) : that.retryStrategy != null) return false;
            if (this.schedulingPriority != null ? !this.schedulingPriority.equals(that.schedulingPriority) : that.schedulingPriority != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            return this.timeout != null ? this.timeout.equals(that.timeout) : that.timeout == null;
        }

        @Override
        public final int hashCode() {
            int result = this.type.hashCode();
            result = 31 * result + (this.consumableResourceProperties != null ? this.consumableResourceProperties.hashCode() : 0);
            result = 31 * result + (this.containerProperties != null ? this.containerProperties.hashCode() : 0);
            result = 31 * result + (this.ecsProperties != null ? this.ecsProperties.hashCode() : 0);
            result = 31 * result + (this.eksProperties != null ? this.eksProperties.hashCode() : 0);
            result = 31 * result + (this.jobDefinitionName != null ? this.jobDefinitionName.hashCode() : 0);
            result = 31 * result + (this.nodeProperties != null ? this.nodeProperties.hashCode() : 0);
            result = 31 * result + (this.parameters != null ? this.parameters.hashCode() : 0);
            result = 31 * result + (this.platformCapabilities != null ? this.platformCapabilities.hashCode() : 0);
            result = 31 * result + (this.propagateTags != null ? this.propagateTags.hashCode() : 0);
            result = 31 * result + (this.retryStrategy != null ? this.retryStrategy.hashCode() : 0);
            result = 31 * result + (this.schedulingPriority != null ? this.schedulingPriority.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.timeout != null ? this.timeout.hashCode() : 0);
            return result;
        }
    }
}
