package software.amazon.awscdk.services.bedrock;

/**
 * Specifies an agent alias as a resource in a top-level template. Minimally, you must specify the following properties:.
 * <p>
 * <ul>
 * <li>AgentAliasName – Specify a name for the alias.</li>
 * </ul>
 * <p>
 * For more information about creating aliases for an agent in Amazon Bedrock , see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/agents-deploy.html">Deploy an Amazon Bedrock agent</a> .
 * <p>
 * See the <em>Properties</em> section below for descriptions of both the required and optional properties.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.bedrock.*;
 * CfnAgentAlias cfnAgentAlias = CfnAgentAlias.Builder.create(this, "MyCfnAgentAlias")
 *         .agentAliasName("agentAliasName")
 *         .agentId("agentId")
 *         // the properties below are optional
 *         .description("description")
 *         .routingConfiguration(List.of(AgentAliasRoutingConfigurationListItemProperty.builder()
 *                 .agentVersion("agentVersion")
 *                 .build()))
 *         .tags(Map.of(
 *                 "tagsKey", "tags"))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-agentalias.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-agentalias.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-08-06T18:14:33.218Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnAgentAlias")
public class CfnAgentAlias extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.ITaggableV2 {

    protected CfnAgentAlias(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnAgentAlias(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.bedrock.CfnAgentAlias.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnAgentAlias(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.bedrock.CfnAgentAliasProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The Amazon Resource Name (ARN) of the alias of the agent.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrAgentAliasArn() {
        return software.amazon.jsii.Kernel.get(this, "attrAgentAliasArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Contains details about the history of the alias.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable getAttrAgentAliasHistoryEvents() {
        return software.amazon.jsii.Kernel.get(this, "attrAgentAliasHistoryEvents", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.IResolvable.class));
    }

    /**
     * The unique identifier of the alias of the agent.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrAgentAliasId() {
        return software.amazon.jsii.Kernel.get(this, "attrAgentAliasId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The status of the alias of the agent and whether it is ready for use.
     * <p>
     * The following statuses are possible:
     * <p>
     * <ul>
     * <li>CREATING – The agent alias is being created.</li>
     * <li>PREPARED – The agent alias is finished being created or updated and is ready to be invoked.</li>
     * <li>FAILED – The agent alias API operation failed.</li>
     * <li>UPDATING – The agent alias is being updated.</li>
     * <li>DELETING – The agent alias is being deleted.</li>
     * <li>DISSOCIATED - The agent alias has no version associated with it.</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrAgentAliasStatus() {
        return software.amazon.jsii.Kernel.get(this, "attrAgentAliasStatus", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The time at which the alias of the agent was created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrCreatedAt() {
        return software.amazon.jsii.Kernel.get(this, "attrCreatedAt", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The time at which the alias was last updated.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrUpdatedAt() {
        return software.amazon.jsii.Kernel.get(this, "attrUpdatedAt", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getCdkTagManager() {
        return software.amazon.jsii.Kernel.get(this, "cdkTagManager", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The name of the alias of the agent.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAgentAliasName() {
        return software.amazon.jsii.Kernel.get(this, "agentAliasName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the alias of the agent.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAgentAliasName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "agentAliasName", java.util.Objects.requireNonNull(value, "agentAliasName is required"));
    }

    /**
     * The unique identifier of the agent.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAgentId() {
        return software.amazon.jsii.Kernel.get(this, "agentId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The unique identifier of the agent.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAgentId(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "agentId", java.util.Objects.requireNonNull(value, "agentId is required"));
    }

    /**
     * The description of the alias of the agent.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The description of the alias of the agent.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDescription(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "description", value);
    }

    /**
     * Contains details about the routing configuration of the alias.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getRoutingConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "routingConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Contains details about the routing configuration of the alias.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRoutingConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "routingConfiguration", value);
    }

    /**
     * Contains details about the routing configuration of the alias.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRoutingConfiguration(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.bedrock.CfnAgentAlias.AgentAliasRoutingConfigurationListItemProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.bedrock.CfnAgentAlias.AgentAliasRoutingConfigurationListItemProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "routingConfiguration", value);
    }

    /**
     * Metadata that you can assign to a resource as key-value pairs.
     * <p>
     * For more information, see the following resources:.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getTags() {
        return java.util.Optional.ofNullable((java.util.Map<java.lang.String, java.lang.String>)(software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableMap).orElse(null);
    }

    /**
     * Metadata that you can assign to a resource as key-value pairs.
     * <p>
     * For more information, see the following resources:.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTags(final @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "tags", value);
    }
    /**
     * Contains details about the history of the alias.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * AgentAliasHistoryEventProperty agentAliasHistoryEventProperty = AgentAliasHistoryEventProperty.builder()
     *         .endDate("endDate")
     *         .routingConfiguration(List.of(AgentAliasRoutingConfigurationListItemProperty.builder()
     *                 .agentVersion("agentVersion")
     *                 .build()))
     *         .startDate("startDate")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-agentalias-agentaliashistoryevent.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-agentalias-agentaliashistoryevent.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnAgentAlias.AgentAliasHistoryEventProperty")
    @software.amazon.jsii.Jsii.Proxy(AgentAliasHistoryEventProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AgentAliasHistoryEventProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The date that the alias stopped being associated to the version in the <code>routingConfiguration</code> object.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-agentalias-agentaliashistoryevent.html#cfn-bedrock-agentalias-agentaliashistoryevent-enddate">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-agentalias-agentaliashistoryevent.html#cfn-bedrock-agentalias-agentaliashistoryevent-enddate</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getEndDate() {
            return null;
        }

        /**
         * Contains details about the version of the agent with which the alias is associated.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-agentalias-agentaliashistoryevent.html#cfn-bedrock-agentalias-agentaliashistoryevent-routingconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-agentalias-agentaliashistoryevent.html#cfn-bedrock-agentalias-agentaliashistoryevent-routingconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRoutingConfiguration() {
            return null;
        }

        /**
         * The date that the alias began being associated to the version in the <code>routingConfiguration</code> object.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-agentalias-agentaliashistoryevent.html#cfn-bedrock-agentalias-agentaliashistoryevent-startdate">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-agentalias-agentaliashistoryevent.html#cfn-bedrock-agentalias-agentaliashistoryevent-startdate</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getStartDate() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AgentAliasHistoryEventProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AgentAliasHistoryEventProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AgentAliasHistoryEventProperty> {
            java.lang.String endDate;
            java.lang.Object routingConfiguration;
            java.lang.String startDate;

            /**
             * Sets the value of {@link AgentAliasHistoryEventProperty#getEndDate}
             * @param endDate The date that the alias stopped being associated to the version in the <code>routingConfiguration</code> object.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder endDate(java.lang.String endDate) {
                this.endDate = endDate;
                return this;
            }

            /**
             * Sets the value of {@link AgentAliasHistoryEventProperty#getRoutingConfiguration}
             * @param routingConfiguration Contains details about the version of the agent with which the alias is associated.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder routingConfiguration(software.amazon.awscdk.IResolvable routingConfiguration) {
                this.routingConfiguration = routingConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link AgentAliasHistoryEventProperty#getRoutingConfiguration}
             * @param routingConfiguration Contains details about the version of the agent with which the alias is associated.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder routingConfiguration(java.util.List<? extends java.lang.Object> routingConfiguration) {
                this.routingConfiguration = routingConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link AgentAliasHistoryEventProperty#getStartDate}
             * @param startDate The date that the alias began being associated to the version in the <code>routingConfiguration</code> object.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder startDate(java.lang.String startDate) {
                this.startDate = startDate;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AgentAliasHistoryEventProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AgentAliasHistoryEventProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AgentAliasHistoryEventProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AgentAliasHistoryEventProperty {
            private final java.lang.String endDate;
            private final java.lang.Object routingConfiguration;
            private final java.lang.String startDate;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.endDate = software.amazon.jsii.Kernel.get(this, "endDate", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.routingConfiguration = software.amazon.jsii.Kernel.get(this, "routingConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.startDate = software.amazon.jsii.Kernel.get(this, "startDate", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.endDate = builder.endDate;
                this.routingConfiguration = builder.routingConfiguration;
                this.startDate = builder.startDate;
            }

            @Override
            public final java.lang.String getEndDate() {
                return this.endDate;
            }

            @Override
            public final java.lang.Object getRoutingConfiguration() {
                return this.routingConfiguration;
            }

            @Override
            public final java.lang.String getStartDate() {
                return this.startDate;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getEndDate() != null) {
                    data.set("endDate", om.valueToTree(this.getEndDate()));
                }
                if (this.getRoutingConfiguration() != null) {
                    data.set("routingConfiguration", om.valueToTree(this.getRoutingConfiguration()));
                }
                if (this.getStartDate() != null) {
                    data.set("startDate", om.valueToTree(this.getStartDate()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnAgentAlias.AgentAliasHistoryEventProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AgentAliasHistoryEventProperty.Jsii$Proxy that = (AgentAliasHistoryEventProperty.Jsii$Proxy) o;

                if (this.endDate != null ? !this.endDate.equals(that.endDate) : that.endDate != null) return false;
                if (this.routingConfiguration != null ? !this.routingConfiguration.equals(that.routingConfiguration) : that.routingConfiguration != null) return false;
                return this.startDate != null ? this.startDate.equals(that.startDate) : that.startDate == null;
            }

            @Override
            public final int hashCode() {
                int result = this.endDate != null ? this.endDate.hashCode() : 0;
                result = 31 * result + (this.routingConfiguration != null ? this.routingConfiguration.hashCode() : 0);
                result = 31 * result + (this.startDate != null ? this.startDate.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Contains details about the routing configuration of the alias.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * AgentAliasRoutingConfigurationListItemProperty agentAliasRoutingConfigurationListItemProperty = AgentAliasRoutingConfigurationListItemProperty.builder()
     *         .agentVersion("agentVersion")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-agentalias-agentaliasroutingconfigurationlistitem.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-agentalias-agentaliasroutingconfigurationlistitem.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnAgentAlias.AgentAliasRoutingConfigurationListItemProperty")
    @software.amazon.jsii.Jsii.Proxy(AgentAliasRoutingConfigurationListItemProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AgentAliasRoutingConfigurationListItemProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The version of the agent with which the alias is associated.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-agentalias-agentaliasroutingconfigurationlistitem.html#cfn-bedrock-agentalias-agentaliasroutingconfigurationlistitem-agentversion">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-agentalias-agentaliasroutingconfigurationlistitem.html#cfn-bedrock-agentalias-agentaliasroutingconfigurationlistitem-agentversion</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getAgentVersion();

        /**
         * @return a {@link Builder} of {@link AgentAliasRoutingConfigurationListItemProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AgentAliasRoutingConfigurationListItemProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AgentAliasRoutingConfigurationListItemProperty> {
            java.lang.String agentVersion;

            /**
             * Sets the value of {@link AgentAliasRoutingConfigurationListItemProperty#getAgentVersion}
             * @param agentVersion The version of the agent with which the alias is associated. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder agentVersion(java.lang.String agentVersion) {
                this.agentVersion = agentVersion;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AgentAliasRoutingConfigurationListItemProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AgentAliasRoutingConfigurationListItemProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AgentAliasRoutingConfigurationListItemProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AgentAliasRoutingConfigurationListItemProperty {
            private final java.lang.String agentVersion;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.agentVersion = software.amazon.jsii.Kernel.get(this, "agentVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.agentVersion = java.util.Objects.requireNonNull(builder.agentVersion, "agentVersion is required");
            }

            @Override
            public final java.lang.String getAgentVersion() {
                return this.agentVersion;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("agentVersion", om.valueToTree(this.getAgentVersion()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnAgentAlias.AgentAliasRoutingConfigurationListItemProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AgentAliasRoutingConfigurationListItemProperty.Jsii$Proxy that = (AgentAliasRoutingConfigurationListItemProperty.Jsii$Proxy) o;

                return this.agentVersion.equals(that.agentVersion);
            }

            @Override
            public final int hashCode() {
                int result = this.agentVersion.hashCode();
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.bedrock.CfnAgentAlias}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.bedrock.CfnAgentAlias> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.bedrock.CfnAgentAliasProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.bedrock.CfnAgentAliasProps.Builder();
        }

        /**
         * The name of the alias of the agent.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-agentalias.html#cfn-bedrock-agentalias-agentaliasname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-agentalias.html#cfn-bedrock-agentalias-agentaliasname</a>
         * @param agentAliasName The name of the alias of the agent. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder agentAliasName(final java.lang.String agentAliasName) {
            this.props.agentAliasName(agentAliasName);
            return this;
        }

        /**
         * The unique identifier of the agent.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-agentalias.html#cfn-bedrock-agentalias-agentid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-agentalias.html#cfn-bedrock-agentalias-agentid</a>
         * @param agentId The unique identifier of the agent. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder agentId(final java.lang.String agentId) {
            this.props.agentId(agentId);
            return this;
        }

        /**
         * The description of the alias of the agent.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-agentalias.html#cfn-bedrock-agentalias-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-agentalias.html#cfn-bedrock-agentalias-description</a>
         * @param description The description of the alias of the agent. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * Contains details about the routing configuration of the alias.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-agentalias.html#cfn-bedrock-agentalias-routingconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-agentalias.html#cfn-bedrock-agentalias-routingconfiguration</a>
         * @param routingConfiguration Contains details about the routing configuration of the alias. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder routingConfiguration(final software.amazon.awscdk.IResolvable routingConfiguration) {
            this.props.routingConfiguration(routingConfiguration);
            return this;
        }
        /**
         * Contains details about the routing configuration of the alias.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-agentalias.html#cfn-bedrock-agentalias-routingconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-agentalias.html#cfn-bedrock-agentalias-routingconfiguration</a>
         * @param routingConfiguration Contains details about the routing configuration of the alias. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder routingConfiguration(final java.util.List<? extends java.lang.Object> routingConfiguration) {
            this.props.routingConfiguration(routingConfiguration);
            return this;
        }

        /**
         * Metadata that you can assign to a resource as key-value pairs. For more information, see the following resources:.
         * <p>
         * <ul>
         * <li><a href="https://docs.aws.amazon.com/tag-editor/latest/userguide/tagging.html#tag-conventions">Tag naming limits and requirements</a></li>
         * <li><a href="https://docs.aws.amazon.com/tag-editor/latest/userguide/tagging.html#tag-best-practices">Tagging best practices</a></li>
         * </ul>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-agentalias.html#cfn-bedrock-agentalias-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-agentalias.html#cfn-bedrock-agentalias-tags</a>
         * @param tags Metadata that you can assign to a resource as key-value pairs. For more information, see the following resources:. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.Map<java.lang.String, java.lang.String> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.bedrock.CfnAgentAlias}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.bedrock.CfnAgentAlias build() {
            return new software.amazon.awscdk.services.bedrock.CfnAgentAlias(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
