package software.amazon.awscdk.services.budgets;

/**
 * The <code>AWS::Budgets::Budget</code> resource allows customers to take pre-defined actions that will trigger once a budget threshold has been exceeded.
 * <p>
 * creates, replaces, or deletes budgets for Billing and Cost Management. For more information, see <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/budgets-managing-costs.html">Managing Your Costs with Budgets</a> in the <em>Billing and Cost Management User Guide</em> .
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.budgets.*;
 * Object costFilters;
 * ExpressionProperty expressionProperty_;
 * Object plannedBudgetLimits;
 * CfnBudget cfnBudget = CfnBudget.Builder.create(this, "MyCfnBudget")
 *         .budget(BudgetDataProperty.builder()
 *                 .budgetType("budgetType")
 *                 .timeUnit("timeUnit")
 *                 // the properties below are optional
 *                 .autoAdjustData(AutoAdjustDataProperty.builder()
 *                         .autoAdjustType("autoAdjustType")
 *                         // the properties below are optional
 *                         .historicalOptions(HistoricalOptionsProperty.builder()
 *                                 .budgetAdjustmentPeriod(123)
 *                                 .build())
 *                         .build())
 *                 .budgetLimit(SpendProperty.builder()
 *                         .amount(123)
 *                         .unit("unit")
 *                         .build())
 *                 .budgetName("budgetName")
 *                 .costFilters(costFilters)
 *                 .costTypes(CostTypesProperty.builder()
 *                         .includeCredit(false)
 *                         .includeDiscount(false)
 *                         .includeOtherSubscription(false)
 *                         .includeRecurring(false)
 *                         .includeRefund(false)
 *                         .includeSubscription(false)
 *                         .includeSupport(false)
 *                         .includeTax(false)
 *                         .includeUpfront(false)
 *                         .useAmortized(false)
 *                         .useBlended(false)
 *                         .build())
 *                 .filterExpression(ExpressionProperty.builder()
 *                         .and(List.of(expressionProperty_))
 *                         .costCategories(CostCategoryValuesProperty.builder()
 *                                 .key("key")
 *                                 .matchOptions(List.of("matchOptions"))
 *                                 .values(List.of("values"))
 *                                 .build())
 *                         .dimensions(ExpressionDimensionValuesProperty.builder()
 *                                 .key("key")
 *                                 .matchOptions(List.of("matchOptions"))
 *                                 .values(List.of("values"))
 *                                 .build())
 *                         .not(expressionProperty_)
 *                         .or(List.of(expressionProperty_))
 *                         .tags(TagValuesProperty.builder()
 *                                 .key("key")
 *                                 .matchOptions(List.of("matchOptions"))
 *                                 .values(List.of("values"))
 *                                 .build())
 *                         .build())
 *                 .metrics(List.of("metrics"))
 *                 .plannedBudgetLimits(plannedBudgetLimits)
 *                 .timePeriod(TimePeriodProperty.builder()
 *                         .end("end")
 *                         .start("start")
 *                         .build())
 *                 .build())
 *         // the properties below are optional
 *         .notificationsWithSubscribers(List.of(NotificationWithSubscribersProperty.builder()
 *                 .notification(NotificationProperty.builder()
 *                         .comparisonOperator("comparisonOperator")
 *                         .notificationType("notificationType")
 *                         .threshold(123)
 *                         // the properties below are optional
 *                         .thresholdType("thresholdType")
 *                         .build())
 *                 .subscribers(List.of(SubscriberProperty.builder()
 *                         .address("address")
 *                         .subscriptionType("subscriptionType")
 *                         .build()))
 *                 .build()))
 *         .resourceTags(List.of(ResourceTagProperty.builder()
 *                 .key("key")
 *                 // the properties below are optional
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-budgets-budget.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-budgets-budget.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-08-06T18:14:33.478Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_budgets.CfnBudget")
public class CfnBudget extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnBudget(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnBudget(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.budgets.CfnBudget.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnBudget(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.budgets.CfnBudgetProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrId() {
        return software.amazon.jsii.Kernel.get(this, "attrId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The budget object that you want to create.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getBudget() {
        return software.amazon.jsii.Kernel.get(this, "budget", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The budget object that you want to create.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setBudget(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "budget", java.util.Objects.requireNonNull(value, "budget is required"));
    }

    /**
     * The budget object that you want to create.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setBudget(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.budgets.CfnBudget.BudgetDataProperty value) {
        software.amazon.jsii.Kernel.set(this, "budget", java.util.Objects.requireNonNull(value, "budget is required"));
    }

    /**
     * A notification that you want to associate with a budget.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getNotificationsWithSubscribers() {
        return software.amazon.jsii.Kernel.get(this, "notificationsWithSubscribers", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A notification that you want to associate with a budget.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setNotificationsWithSubscribers(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "notificationsWithSubscribers", value);
    }

    /**
     * A notification that you want to associate with a budget.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setNotificationsWithSubscribers(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.budgets.CfnBudget.NotificationWithSubscribersProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.budgets.CfnBudget.NotificationWithSubscribersProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "notificationsWithSubscribers", value);
    }

    /**
     * An optional list of tags to associate with the specified budget.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getResourceTags() {
        return software.amazon.jsii.Kernel.get(this, "resourceTags", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * An optional list of tags to associate with the specified budget.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setResourceTags(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "resourceTags", value);
    }

    /**
     * An optional list of tags to associate with the specified budget.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setResourceTags(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.budgets.CfnBudget.ResourceTagProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.budgets.CfnBudget.ResourceTagProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "resourceTags", value);
    }
    /**
     * Determine the budget amount for an auto-adjusting budget.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.budgets.*;
     * AutoAdjustDataProperty autoAdjustDataProperty = AutoAdjustDataProperty.builder()
     *         .autoAdjustType("autoAdjustType")
     *         // the properties below are optional
     *         .historicalOptions(HistoricalOptionsProperty.builder()
     *                 .budgetAdjustmentPeriod(123)
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-autoadjustdata.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-autoadjustdata.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_budgets.CfnBudget.AutoAdjustDataProperty")
    @software.amazon.jsii.Jsii.Proxy(AutoAdjustDataProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AutoAdjustDataProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The string that defines whether your budget auto-adjusts based on historical or forecasted data.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-autoadjustdata.html#cfn-budgets-budget-autoadjustdata-autoadjusttype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-autoadjustdata.html#cfn-budgets-budget-autoadjustdata-autoadjusttype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getAutoAdjustType();

        /**
         * The parameters that define or describe the historical data that your auto-adjusting budget is based on.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-autoadjustdata.html#cfn-budgets-budget-autoadjustdata-historicaloptions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-autoadjustdata.html#cfn-budgets-budget-autoadjustdata-historicaloptions</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getHistoricalOptions() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AutoAdjustDataProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AutoAdjustDataProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AutoAdjustDataProperty> {
            java.lang.String autoAdjustType;
            java.lang.Object historicalOptions;

            /**
             * Sets the value of {@link AutoAdjustDataProperty#getAutoAdjustType}
             * @param autoAdjustType The string that defines whether your budget auto-adjusts based on historical or forecasted data. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder autoAdjustType(java.lang.String autoAdjustType) {
                this.autoAdjustType = autoAdjustType;
                return this;
            }

            /**
             * Sets the value of {@link AutoAdjustDataProperty#getHistoricalOptions}
             * @param historicalOptions The parameters that define or describe the historical data that your auto-adjusting budget is based on.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder historicalOptions(software.amazon.awscdk.IResolvable historicalOptions) {
                this.historicalOptions = historicalOptions;
                return this;
            }

            /**
             * Sets the value of {@link AutoAdjustDataProperty#getHistoricalOptions}
             * @param historicalOptions The parameters that define or describe the historical data that your auto-adjusting budget is based on.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder historicalOptions(software.amazon.awscdk.services.budgets.CfnBudget.HistoricalOptionsProperty historicalOptions) {
                this.historicalOptions = historicalOptions;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AutoAdjustDataProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AutoAdjustDataProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AutoAdjustDataProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AutoAdjustDataProperty {
            private final java.lang.String autoAdjustType;
            private final java.lang.Object historicalOptions;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.autoAdjustType = software.amazon.jsii.Kernel.get(this, "autoAdjustType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.historicalOptions = software.amazon.jsii.Kernel.get(this, "historicalOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.autoAdjustType = java.util.Objects.requireNonNull(builder.autoAdjustType, "autoAdjustType is required");
                this.historicalOptions = builder.historicalOptions;
            }

            @Override
            public final java.lang.String getAutoAdjustType() {
                return this.autoAdjustType;
            }

            @Override
            public final java.lang.Object getHistoricalOptions() {
                return this.historicalOptions;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("autoAdjustType", om.valueToTree(this.getAutoAdjustType()));
                if (this.getHistoricalOptions() != null) {
                    data.set("historicalOptions", om.valueToTree(this.getHistoricalOptions()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_budgets.CfnBudget.AutoAdjustDataProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AutoAdjustDataProperty.Jsii$Proxy that = (AutoAdjustDataProperty.Jsii$Proxy) o;

                if (!autoAdjustType.equals(that.autoAdjustType)) return false;
                return this.historicalOptions != null ? this.historicalOptions.equals(that.historicalOptions) : that.historicalOptions == null;
            }

            @Override
            public final int hashCode() {
                int result = this.autoAdjustType.hashCode();
                result = 31 * result + (this.historicalOptions != null ? this.historicalOptions.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Represents the output of the <code>CreateBudget</code> operation.
     * <p>
     * The content consists of the detailed metadata and data file information, and the current status of the <code>budget</code> object.
     * <p>
     * This is the Amazon Resource Name (ARN) pattern for a budget:
     * <p>
     * <code>arn:aws:budgets::AccountId:budget/budgetName</code>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.budgets.*;
     * Object costFilters;
     * ExpressionProperty expressionProperty_;
     * Object plannedBudgetLimits;
     * BudgetDataProperty budgetDataProperty = BudgetDataProperty.builder()
     *         .budgetType("budgetType")
     *         .timeUnit("timeUnit")
     *         // the properties below are optional
     *         .autoAdjustData(AutoAdjustDataProperty.builder()
     *                 .autoAdjustType("autoAdjustType")
     *                 // the properties below are optional
     *                 .historicalOptions(HistoricalOptionsProperty.builder()
     *                         .budgetAdjustmentPeriod(123)
     *                         .build())
     *                 .build())
     *         .budgetLimit(SpendProperty.builder()
     *                 .amount(123)
     *                 .unit("unit")
     *                 .build())
     *         .budgetName("budgetName")
     *         .costFilters(costFilters)
     *         .costTypes(CostTypesProperty.builder()
     *                 .includeCredit(false)
     *                 .includeDiscount(false)
     *                 .includeOtherSubscription(false)
     *                 .includeRecurring(false)
     *                 .includeRefund(false)
     *                 .includeSubscription(false)
     *                 .includeSupport(false)
     *                 .includeTax(false)
     *                 .includeUpfront(false)
     *                 .useAmortized(false)
     *                 .useBlended(false)
     *                 .build())
     *         .filterExpression(ExpressionProperty.builder()
     *                 .and(List.of(expressionProperty_))
     *                 .costCategories(CostCategoryValuesProperty.builder()
     *                         .key("key")
     *                         .matchOptions(List.of("matchOptions"))
     *                         .values(List.of("values"))
     *                         .build())
     *                 .dimensions(ExpressionDimensionValuesProperty.builder()
     *                         .key("key")
     *                         .matchOptions(List.of("matchOptions"))
     *                         .values(List.of("values"))
     *                         .build())
     *                 .not(expressionProperty_)
     *                 .or(List.of(expressionProperty_))
     *                 .tags(TagValuesProperty.builder()
     *                         .key("key")
     *                         .matchOptions(List.of("matchOptions"))
     *                         .values(List.of("values"))
     *                         .build())
     *                 .build())
     *         .metrics(List.of("metrics"))
     *         .plannedBudgetLimits(plannedBudgetLimits)
     *         .timePeriod(TimePeriodProperty.builder()
     *                 .end("end")
     *                 .start("start")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-budgetdata.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-budgetdata.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_budgets.CfnBudget.BudgetDataProperty")
    @software.amazon.jsii.Jsii.Proxy(BudgetDataProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface BudgetDataProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies whether this budget tracks costs, usage, RI utilization, RI coverage, Savings Plans utilization, or Savings Plans coverage.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-budgetdata.html#cfn-budgets-budget-budgetdata-budgettype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-budgetdata.html#cfn-budgets-budget-budgetdata-budgettype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getBudgetType();

        /**
         * The length of time until a budget resets the actual and forecasted spend.
         * <p>
         * <code>DAILY</code> is available only for <code>RI_UTILIZATION</code> and <code>RI_COVERAGE</code> budgets.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-budgetdata.html#cfn-budgets-budget-budgetdata-timeunit">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-budgetdata.html#cfn-budgets-budget-budgetdata-timeunit</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getTimeUnit();

        /**
         * Determine the budget amount for an auto-adjusting budget.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-budgetdata.html#cfn-budgets-budget-budgetdata-autoadjustdata">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-budgetdata.html#cfn-budgets-budget-budgetdata-autoadjustdata</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAutoAdjustData() {
            return null;
        }

        /**
         * The total amount of cost, usage, RI utilization, RI coverage, Savings Plans utilization, or Savings Plans coverage that you want to track with your budget.
         * <p>
         * <code>BudgetLimit</code> is required for cost or usage budgets, but optional for RI or Savings Plans utilization or coverage budgets. RI and Savings Plans utilization or coverage budgets default to <code>100</code> . This is the only valid value for RI or Savings Plans utilization or coverage budgets. You can't use <code>BudgetLimit</code> with <code>PlannedBudgetLimits</code> for <code>CreateBudget</code> and <code>UpdateBudget</code> actions.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-budgetdata.html#cfn-budgets-budget-budgetdata-budgetlimit">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-budgetdata.html#cfn-budgets-budget-budgetdata-budgetlimit</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getBudgetLimit() {
            return null;
        }

        /**
         * The name of a budget.
         * <p>
         * The value must be unique within an account. <code>BudgetName</code> can't include <code>:</code> and <code>\</code> characters. If you don't include value for <code>BudgetName</code> in the template, Billing and Cost Management assigns your budget a randomly generated name.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-budgetdata.html#cfn-budgets-budget-budgetdata-budgetname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-budgetdata.html#cfn-budgets-budget-budgetdata-budgetname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getBudgetName() {
            return null;
        }

        /**
         * The cost filters, such as <code>Region</code> , <code>Service</code> , <code>LinkedAccount</code> , <code>Tag</code> , or <code>CostCategory</code> , that are applied to a budget.
         * <p>
         * AWS Budgets supports the following services as a <code>Service</code> filter for RI budgets:
         * <p>
         * <ul>
         * <li>Amazon EC2</li>
         * <li>Amazon Redshift</li>
         * <li>Amazon Relational Database Service</li>
         * <li>Amazon ElastiCache</li>
         * <li>Amazon OpenSearch Service</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-budgetdata.html#cfn-budgets-budget-budgetdata-costfilters">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-budgetdata.html#cfn-budgets-budget-budgetdata-costfilters</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCostFilters() {
            return null;
        }

        /**
         * The types of costs that are included in this <code>COST</code> budget.
         * <p>
         * <code>USAGE</code> , <code>RI_UTILIZATION</code> , <code>RI_COVERAGE</code> , <code>SAVINGS_PLANS_UTILIZATION</code> , and <code>SAVINGS_PLANS_COVERAGE</code> budgets do not have <code>CostTypes</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-budgetdata.html#cfn-budgets-budget-budgetdata-costtypes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-budgetdata.html#cfn-budgets-budget-budgetdata-costtypes</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCostTypes() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-budgetdata.html#cfn-budgets-budget-budgetdata-filterexpression">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-budgetdata.html#cfn-budgets-budget-budgetdata-filterexpression</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getFilterExpression() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-budgetdata.html#cfn-budgets-budget-budgetdata-metrics">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-budgetdata.html#cfn-budgets-budget-budgetdata-metrics</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getMetrics() {
            return null;
        }

        /**
         * A map containing multiple <code>BudgetLimit</code> , including current or future limits.
         * <p>
         * <code>PlannedBudgetLimits</code> is available for cost or usage budget and supports both monthly and quarterly <code>TimeUnit</code> .
         * <p>
         * For monthly budgets, provide 12 months of <code>PlannedBudgetLimits</code> values. This must start from the current month and include the next 11 months. The <code>key</code> is the start of the month, <code>UTC</code> in epoch seconds.
         * <p>
         * For quarterly budgets, provide four quarters of <code>PlannedBudgetLimits</code> value entries in standard calendar quarter increments. This must start from the current quarter and include the next three quarters. The <code>key</code> is the start of the quarter, <code>UTC</code> in epoch seconds.
         * <p>
         * If the planned budget expires before 12 months for monthly or four quarters for quarterly, provide the <code>PlannedBudgetLimits</code> values only for the remaining periods.
         * <p>
         * If the budget begins at a date in the future, provide <code>PlannedBudgetLimits</code> values from the start date of the budget.
         * <p>
         * After all of the <code>BudgetLimit</code> values in <code>PlannedBudgetLimits</code> are used, the budget continues to use the last limit as the <code>BudgetLimit</code> . At that point, the planned budget provides the same experience as a fixed budget.
         * <p>
         * <code>DescribeBudget</code> and <code>DescribeBudgets</code> response along with <code>PlannedBudgetLimits</code> also contain <code>BudgetLimit</code> representing the current month or quarter limit present in <code>PlannedBudgetLimits</code> . This only applies to budgets that are created with <code>PlannedBudgetLimits</code> . Budgets that are created without <code>PlannedBudgetLimits</code> only contain <code>BudgetLimit</code> . They don't contain <code>PlannedBudgetLimits</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-budgetdata.html#cfn-budgets-budget-budgetdata-plannedbudgetlimits">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-budgetdata.html#cfn-budgets-budget-budgetdata-plannedbudgetlimits</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPlannedBudgetLimits() {
            return null;
        }

        /**
         * The period of time that is covered by a budget.
         * <p>
         * The period has a start date and an end date. The start date must come before the end date. There are no restrictions on the end date.
         * <p>
         * The start date for a budget. If you created your budget and didn't specify a start date, the start date defaults to the start of the chosen time period (MONTHLY, QUARTERLY, or ANNUALLY). For example, if you create your budget on January 24, 2019, choose <code>MONTHLY</code> , and don't set a start date, the start date defaults to <code>01/01/19 00:00 UTC</code> . The defaults are the same for the Billing and Cost Management console and the API.
         * <p>
         * You can change your start date with the <code>UpdateBudget</code> operation.
         * <p>
         * After the end date, AWS deletes the budget and all associated notifications and subscribers.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-budgetdata.html#cfn-budgets-budget-budgetdata-timeperiod">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-budgetdata.html#cfn-budgets-budget-budgetdata-timeperiod</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTimePeriod() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link BudgetDataProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link BudgetDataProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<BudgetDataProperty> {
            java.lang.String budgetType;
            java.lang.String timeUnit;
            java.lang.Object autoAdjustData;
            java.lang.Object budgetLimit;
            java.lang.String budgetName;
            java.lang.Object costFilters;
            java.lang.Object costTypes;
            java.lang.Object filterExpression;
            java.util.List<java.lang.String> metrics;
            java.lang.Object plannedBudgetLimits;
            java.lang.Object timePeriod;

            /**
             * Sets the value of {@link BudgetDataProperty#getBudgetType}
             * @param budgetType Specifies whether this budget tracks costs, usage, RI utilization, RI coverage, Savings Plans utilization, or Savings Plans coverage. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder budgetType(java.lang.String budgetType) {
                this.budgetType = budgetType;
                return this;
            }

            /**
             * Sets the value of {@link BudgetDataProperty#getTimeUnit}
             * @param timeUnit The length of time until a budget resets the actual and forecasted spend. This parameter is required.
             *                 <code>DAILY</code> is available only for <code>RI_UTILIZATION</code> and <code>RI_COVERAGE</code> budgets.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder timeUnit(java.lang.String timeUnit) {
                this.timeUnit = timeUnit;
                return this;
            }

            /**
             * Sets the value of {@link BudgetDataProperty#getAutoAdjustData}
             * @param autoAdjustData Determine the budget amount for an auto-adjusting budget.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder autoAdjustData(software.amazon.awscdk.IResolvable autoAdjustData) {
                this.autoAdjustData = autoAdjustData;
                return this;
            }

            /**
             * Sets the value of {@link BudgetDataProperty#getAutoAdjustData}
             * @param autoAdjustData Determine the budget amount for an auto-adjusting budget.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder autoAdjustData(software.amazon.awscdk.services.budgets.CfnBudget.AutoAdjustDataProperty autoAdjustData) {
                this.autoAdjustData = autoAdjustData;
                return this;
            }

            /**
             * Sets the value of {@link BudgetDataProperty#getBudgetLimit}
             * @param budgetLimit The total amount of cost, usage, RI utilization, RI coverage, Savings Plans utilization, or Savings Plans coverage that you want to track with your budget.
             *                    <code>BudgetLimit</code> is required for cost or usage budgets, but optional for RI or Savings Plans utilization or coverage budgets. RI and Savings Plans utilization or coverage budgets default to <code>100</code> . This is the only valid value for RI or Savings Plans utilization or coverage budgets. You can't use <code>BudgetLimit</code> with <code>PlannedBudgetLimits</code> for <code>CreateBudget</code> and <code>UpdateBudget</code> actions.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder budgetLimit(software.amazon.awscdk.IResolvable budgetLimit) {
                this.budgetLimit = budgetLimit;
                return this;
            }

            /**
             * Sets the value of {@link BudgetDataProperty#getBudgetLimit}
             * @param budgetLimit The total amount of cost, usage, RI utilization, RI coverage, Savings Plans utilization, or Savings Plans coverage that you want to track with your budget.
             *                    <code>BudgetLimit</code> is required for cost or usage budgets, but optional for RI or Savings Plans utilization or coverage budgets. RI and Savings Plans utilization or coverage budgets default to <code>100</code> . This is the only valid value for RI or Savings Plans utilization or coverage budgets. You can't use <code>BudgetLimit</code> with <code>PlannedBudgetLimits</code> for <code>CreateBudget</code> and <code>UpdateBudget</code> actions.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder budgetLimit(software.amazon.awscdk.services.budgets.CfnBudget.SpendProperty budgetLimit) {
                this.budgetLimit = budgetLimit;
                return this;
            }

            /**
             * Sets the value of {@link BudgetDataProperty#getBudgetName}
             * @param budgetName The name of a budget.
             *                   The value must be unique within an account. <code>BudgetName</code> can't include <code>:</code> and <code>\</code> characters. If you don't include value for <code>BudgetName</code> in the template, Billing and Cost Management assigns your budget a randomly generated name.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder budgetName(java.lang.String budgetName) {
                this.budgetName = budgetName;
                return this;
            }

            /**
             * Sets the value of {@link BudgetDataProperty#getCostFilters}
             * @param costFilters The cost filters, such as <code>Region</code> , <code>Service</code> , <code>LinkedAccount</code> , <code>Tag</code> , or <code>CostCategory</code> , that are applied to a budget.
             *                    AWS Budgets supports the following services as a <code>Service</code> filter for RI budgets:
             *                    <p>
             *                    <ul>
             *                    <li>Amazon EC2</li>
             *                    <li>Amazon Redshift</li>
             *                    <li>Amazon Relational Database Service</li>
             *                    <li>Amazon ElastiCache</li>
             *                    <li>Amazon OpenSearch Service</li>
             *                    </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder costFilters(java.lang.Object costFilters) {
                this.costFilters = costFilters;
                return this;
            }

            /**
             * Sets the value of {@link BudgetDataProperty#getCostTypes}
             * @param costTypes The types of costs that are included in this <code>COST</code> budget.
             *                  <code>USAGE</code> , <code>RI_UTILIZATION</code> , <code>RI_COVERAGE</code> , <code>SAVINGS_PLANS_UTILIZATION</code> , and <code>SAVINGS_PLANS_COVERAGE</code> budgets do not have <code>CostTypes</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder costTypes(software.amazon.awscdk.IResolvable costTypes) {
                this.costTypes = costTypes;
                return this;
            }

            /**
             * Sets the value of {@link BudgetDataProperty#getCostTypes}
             * @param costTypes The types of costs that are included in this <code>COST</code> budget.
             *                  <code>USAGE</code> , <code>RI_UTILIZATION</code> , <code>RI_COVERAGE</code> , <code>SAVINGS_PLANS_UTILIZATION</code> , and <code>SAVINGS_PLANS_COVERAGE</code> budgets do not have <code>CostTypes</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder costTypes(software.amazon.awscdk.services.budgets.CfnBudget.CostTypesProperty costTypes) {
                this.costTypes = costTypes;
                return this;
            }

            /**
             * Sets the value of {@link BudgetDataProperty#getFilterExpression}
             * @param filterExpression the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder filterExpression(software.amazon.awscdk.IResolvable filterExpression) {
                this.filterExpression = filterExpression;
                return this;
            }

            /**
             * Sets the value of {@link BudgetDataProperty#getFilterExpression}
             * @param filterExpression the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder filterExpression(software.amazon.awscdk.services.budgets.CfnBudget.ExpressionProperty filterExpression) {
                this.filterExpression = filterExpression;
                return this;
            }

            /**
             * Sets the value of {@link BudgetDataProperty#getMetrics}
             * @param metrics the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder metrics(java.util.List<java.lang.String> metrics) {
                this.metrics = metrics;
                return this;
            }

            /**
             * Sets the value of {@link BudgetDataProperty#getPlannedBudgetLimits}
             * @param plannedBudgetLimits A map containing multiple <code>BudgetLimit</code> , including current or future limits.
             *                            <code>PlannedBudgetLimits</code> is available for cost or usage budget and supports both monthly and quarterly <code>TimeUnit</code> .
             *                            <p>
             *                            For monthly budgets, provide 12 months of <code>PlannedBudgetLimits</code> values. This must start from the current month and include the next 11 months. The <code>key</code> is the start of the month, <code>UTC</code> in epoch seconds.
             *                            <p>
             *                            For quarterly budgets, provide four quarters of <code>PlannedBudgetLimits</code> value entries in standard calendar quarter increments. This must start from the current quarter and include the next three quarters. The <code>key</code> is the start of the quarter, <code>UTC</code> in epoch seconds.
             *                            <p>
             *                            If the planned budget expires before 12 months for monthly or four quarters for quarterly, provide the <code>PlannedBudgetLimits</code> values only for the remaining periods.
             *                            <p>
             *                            If the budget begins at a date in the future, provide <code>PlannedBudgetLimits</code> values from the start date of the budget.
             *                            <p>
             *                            After all of the <code>BudgetLimit</code> values in <code>PlannedBudgetLimits</code> are used, the budget continues to use the last limit as the <code>BudgetLimit</code> . At that point, the planned budget provides the same experience as a fixed budget.
             *                            <p>
             *                            <code>DescribeBudget</code> and <code>DescribeBudgets</code> response along with <code>PlannedBudgetLimits</code> also contain <code>BudgetLimit</code> representing the current month or quarter limit present in <code>PlannedBudgetLimits</code> . This only applies to budgets that are created with <code>PlannedBudgetLimits</code> . Budgets that are created without <code>PlannedBudgetLimits</code> only contain <code>BudgetLimit</code> . They don't contain <code>PlannedBudgetLimits</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder plannedBudgetLimits(java.lang.Object plannedBudgetLimits) {
                this.plannedBudgetLimits = plannedBudgetLimits;
                return this;
            }

            /**
             * Sets the value of {@link BudgetDataProperty#getTimePeriod}
             * @param timePeriod The period of time that is covered by a budget.
             *                   The period has a start date and an end date. The start date must come before the end date. There are no restrictions on the end date.
             *                   <p>
             *                   The start date for a budget. If you created your budget and didn't specify a start date, the start date defaults to the start of the chosen time period (MONTHLY, QUARTERLY, or ANNUALLY). For example, if you create your budget on January 24, 2019, choose <code>MONTHLY</code> , and don't set a start date, the start date defaults to <code>01/01/19 00:00 UTC</code> . The defaults are the same for the Billing and Cost Management console and the API.
             *                   <p>
             *                   You can change your start date with the <code>UpdateBudget</code> operation.
             *                   <p>
             *                   After the end date, AWS deletes the budget and all associated notifications and subscribers.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder timePeriod(software.amazon.awscdk.IResolvable timePeriod) {
                this.timePeriod = timePeriod;
                return this;
            }

            /**
             * Sets the value of {@link BudgetDataProperty#getTimePeriod}
             * @param timePeriod The period of time that is covered by a budget.
             *                   The period has a start date and an end date. The start date must come before the end date. There are no restrictions on the end date.
             *                   <p>
             *                   The start date for a budget. If you created your budget and didn't specify a start date, the start date defaults to the start of the chosen time period (MONTHLY, QUARTERLY, or ANNUALLY). For example, if you create your budget on January 24, 2019, choose <code>MONTHLY</code> , and don't set a start date, the start date defaults to <code>01/01/19 00:00 UTC</code> . The defaults are the same for the Billing and Cost Management console and the API.
             *                   <p>
             *                   You can change your start date with the <code>UpdateBudget</code> operation.
             *                   <p>
             *                   After the end date, AWS deletes the budget and all associated notifications and subscribers.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder timePeriod(software.amazon.awscdk.services.budgets.CfnBudget.TimePeriodProperty timePeriod) {
                this.timePeriod = timePeriod;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link BudgetDataProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public BudgetDataProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link BudgetDataProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BudgetDataProperty {
            private final java.lang.String budgetType;
            private final java.lang.String timeUnit;
            private final java.lang.Object autoAdjustData;
            private final java.lang.Object budgetLimit;
            private final java.lang.String budgetName;
            private final java.lang.Object costFilters;
            private final java.lang.Object costTypes;
            private final java.lang.Object filterExpression;
            private final java.util.List<java.lang.String> metrics;
            private final java.lang.Object plannedBudgetLimits;
            private final java.lang.Object timePeriod;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.budgetType = software.amazon.jsii.Kernel.get(this, "budgetType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.timeUnit = software.amazon.jsii.Kernel.get(this, "timeUnit", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.autoAdjustData = software.amazon.jsii.Kernel.get(this, "autoAdjustData", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.budgetLimit = software.amazon.jsii.Kernel.get(this, "budgetLimit", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.budgetName = software.amazon.jsii.Kernel.get(this, "budgetName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.costFilters = software.amazon.jsii.Kernel.get(this, "costFilters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.costTypes = software.amazon.jsii.Kernel.get(this, "costTypes", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.filterExpression = software.amazon.jsii.Kernel.get(this, "filterExpression", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.metrics = software.amazon.jsii.Kernel.get(this, "metrics", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.plannedBudgetLimits = software.amazon.jsii.Kernel.get(this, "plannedBudgetLimits", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.timePeriod = software.amazon.jsii.Kernel.get(this, "timePeriod", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.budgetType = java.util.Objects.requireNonNull(builder.budgetType, "budgetType is required");
                this.timeUnit = java.util.Objects.requireNonNull(builder.timeUnit, "timeUnit is required");
                this.autoAdjustData = builder.autoAdjustData;
                this.budgetLimit = builder.budgetLimit;
                this.budgetName = builder.budgetName;
                this.costFilters = builder.costFilters;
                this.costTypes = builder.costTypes;
                this.filterExpression = builder.filterExpression;
                this.metrics = builder.metrics;
                this.plannedBudgetLimits = builder.plannedBudgetLimits;
                this.timePeriod = builder.timePeriod;
            }

            @Override
            public final java.lang.String getBudgetType() {
                return this.budgetType;
            }

            @Override
            public final java.lang.String getTimeUnit() {
                return this.timeUnit;
            }

            @Override
            public final java.lang.Object getAutoAdjustData() {
                return this.autoAdjustData;
            }

            @Override
            public final java.lang.Object getBudgetLimit() {
                return this.budgetLimit;
            }

            @Override
            public final java.lang.String getBudgetName() {
                return this.budgetName;
            }

            @Override
            public final java.lang.Object getCostFilters() {
                return this.costFilters;
            }

            @Override
            public final java.lang.Object getCostTypes() {
                return this.costTypes;
            }

            @Override
            public final java.lang.Object getFilterExpression() {
                return this.filterExpression;
            }

            @Override
            public final java.util.List<java.lang.String> getMetrics() {
                return this.metrics;
            }

            @Override
            public final java.lang.Object getPlannedBudgetLimits() {
                return this.plannedBudgetLimits;
            }

            @Override
            public final java.lang.Object getTimePeriod() {
                return this.timePeriod;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("budgetType", om.valueToTree(this.getBudgetType()));
                data.set("timeUnit", om.valueToTree(this.getTimeUnit()));
                if (this.getAutoAdjustData() != null) {
                    data.set("autoAdjustData", om.valueToTree(this.getAutoAdjustData()));
                }
                if (this.getBudgetLimit() != null) {
                    data.set("budgetLimit", om.valueToTree(this.getBudgetLimit()));
                }
                if (this.getBudgetName() != null) {
                    data.set("budgetName", om.valueToTree(this.getBudgetName()));
                }
                if (this.getCostFilters() != null) {
                    data.set("costFilters", om.valueToTree(this.getCostFilters()));
                }
                if (this.getCostTypes() != null) {
                    data.set("costTypes", om.valueToTree(this.getCostTypes()));
                }
                if (this.getFilterExpression() != null) {
                    data.set("filterExpression", om.valueToTree(this.getFilterExpression()));
                }
                if (this.getMetrics() != null) {
                    data.set("metrics", om.valueToTree(this.getMetrics()));
                }
                if (this.getPlannedBudgetLimits() != null) {
                    data.set("plannedBudgetLimits", om.valueToTree(this.getPlannedBudgetLimits()));
                }
                if (this.getTimePeriod() != null) {
                    data.set("timePeriod", om.valueToTree(this.getTimePeriod()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_budgets.CfnBudget.BudgetDataProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                BudgetDataProperty.Jsii$Proxy that = (BudgetDataProperty.Jsii$Proxy) o;

                if (!budgetType.equals(that.budgetType)) return false;
                if (!timeUnit.equals(that.timeUnit)) return false;
                if (this.autoAdjustData != null ? !this.autoAdjustData.equals(that.autoAdjustData) : that.autoAdjustData != null) return false;
                if (this.budgetLimit != null ? !this.budgetLimit.equals(that.budgetLimit) : that.budgetLimit != null) return false;
                if (this.budgetName != null ? !this.budgetName.equals(that.budgetName) : that.budgetName != null) return false;
                if (this.costFilters != null ? !this.costFilters.equals(that.costFilters) : that.costFilters != null) return false;
                if (this.costTypes != null ? !this.costTypes.equals(that.costTypes) : that.costTypes != null) return false;
                if (this.filterExpression != null ? !this.filterExpression.equals(that.filterExpression) : that.filterExpression != null) return false;
                if (this.metrics != null ? !this.metrics.equals(that.metrics) : that.metrics != null) return false;
                if (this.plannedBudgetLimits != null ? !this.plannedBudgetLimits.equals(that.plannedBudgetLimits) : that.plannedBudgetLimits != null) return false;
                return this.timePeriod != null ? this.timePeriod.equals(that.timePeriod) : that.timePeriod == null;
            }

            @Override
            public final int hashCode() {
                int result = this.budgetType.hashCode();
                result = 31 * result + (this.timeUnit.hashCode());
                result = 31 * result + (this.autoAdjustData != null ? this.autoAdjustData.hashCode() : 0);
                result = 31 * result + (this.budgetLimit != null ? this.budgetLimit.hashCode() : 0);
                result = 31 * result + (this.budgetName != null ? this.budgetName.hashCode() : 0);
                result = 31 * result + (this.costFilters != null ? this.costFilters.hashCode() : 0);
                result = 31 * result + (this.costTypes != null ? this.costTypes.hashCode() : 0);
                result = 31 * result + (this.filterExpression != null ? this.filterExpression.hashCode() : 0);
                result = 31 * result + (this.metrics != null ? this.metrics.hashCode() : 0);
                result = 31 * result + (this.plannedBudgetLimits != null ? this.plannedBudgetLimits.hashCode() : 0);
                result = 31 * result + (this.timePeriod != null ? this.timePeriod.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The cost category values used for filtering the costs.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.budgets.*;
     * CostCategoryValuesProperty costCategoryValuesProperty = CostCategoryValuesProperty.builder()
     *         .key("key")
     *         .matchOptions(List.of("matchOptions"))
     *         .values(List.of("values"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-costcategoryvalues.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-costcategoryvalues.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_budgets.CfnBudget.CostCategoryValuesProperty")
    @software.amazon.jsii.Jsii.Proxy(CostCategoryValuesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CostCategoryValuesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The unique name of the cost category.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-costcategoryvalues.html#cfn-budgets-budget-costcategoryvalues-key">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-costcategoryvalues.html#cfn-budgets-budget-costcategoryvalues-key</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getKey() {
            return null;
        }

        /**
         * The match options that you can use to filter your results.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-costcategoryvalues.html#cfn-budgets-budget-costcategoryvalues-matchoptions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-costcategoryvalues.html#cfn-budgets-budget-costcategoryvalues-matchoptions</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getMatchOptions() {
            return null;
        }

        /**
         * The specific value of the cost category.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-costcategoryvalues.html#cfn-budgets-budget-costcategoryvalues-values">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-costcategoryvalues.html#cfn-budgets-budget-costcategoryvalues-values</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getValues() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CostCategoryValuesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CostCategoryValuesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CostCategoryValuesProperty> {
            java.lang.String key;
            java.util.List<java.lang.String> matchOptions;
            java.util.List<java.lang.String> values;

            /**
             * Sets the value of {@link CostCategoryValuesProperty#getKey}
             * @param key The unique name of the cost category.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder key(java.lang.String key) {
                this.key = key;
                return this;
            }

            /**
             * Sets the value of {@link CostCategoryValuesProperty#getMatchOptions}
             * @param matchOptions The match options that you can use to filter your results.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder matchOptions(java.util.List<java.lang.String> matchOptions) {
                this.matchOptions = matchOptions;
                return this;
            }

            /**
             * Sets the value of {@link CostCategoryValuesProperty#getValues}
             * @param values The specific value of the cost category.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder values(java.util.List<java.lang.String> values) {
                this.values = values;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CostCategoryValuesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CostCategoryValuesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CostCategoryValuesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CostCategoryValuesProperty {
            private final java.lang.String key;
            private final java.util.List<java.lang.String> matchOptions;
            private final java.util.List<java.lang.String> values;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.key = software.amazon.jsii.Kernel.get(this, "key", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.matchOptions = software.amazon.jsii.Kernel.get(this, "matchOptions", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.values = software.amazon.jsii.Kernel.get(this, "values", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.key = builder.key;
                this.matchOptions = builder.matchOptions;
                this.values = builder.values;
            }

            @Override
            public final java.lang.String getKey() {
                return this.key;
            }

            @Override
            public final java.util.List<java.lang.String> getMatchOptions() {
                return this.matchOptions;
            }

            @Override
            public final java.util.List<java.lang.String> getValues() {
                return this.values;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getKey() != null) {
                    data.set("key", om.valueToTree(this.getKey()));
                }
                if (this.getMatchOptions() != null) {
                    data.set("matchOptions", om.valueToTree(this.getMatchOptions()));
                }
                if (this.getValues() != null) {
                    data.set("values", om.valueToTree(this.getValues()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_budgets.CfnBudget.CostCategoryValuesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CostCategoryValuesProperty.Jsii$Proxy that = (CostCategoryValuesProperty.Jsii$Proxy) o;

                if (this.key != null ? !this.key.equals(that.key) : that.key != null) return false;
                if (this.matchOptions != null ? !this.matchOptions.equals(that.matchOptions) : that.matchOptions != null) return false;
                return this.values != null ? this.values.equals(that.values) : that.values == null;
            }

            @Override
            public final int hashCode() {
                int result = this.key != null ? this.key.hashCode() : 0;
                result = 31 * result + (this.matchOptions != null ? this.matchOptions.hashCode() : 0);
                result = 31 * result + (this.values != null ? this.values.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The types of cost that are included in a <code>COST</code> budget, such as tax and subscriptions.
     * <p>
     * <code>USAGE</code> , <code>RI_UTILIZATION</code> , <code>RI_COVERAGE</code> , <code>SAVINGS_PLANS_UTILIZATION</code> , and <code>SAVINGS_PLANS_COVERAGE</code> budgets don't have <code>CostTypes</code> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.budgets.*;
     * CostTypesProperty costTypesProperty = CostTypesProperty.builder()
     *         .includeCredit(false)
     *         .includeDiscount(false)
     *         .includeOtherSubscription(false)
     *         .includeRecurring(false)
     *         .includeRefund(false)
     *         .includeSubscription(false)
     *         .includeSupport(false)
     *         .includeTax(false)
     *         .includeUpfront(false)
     *         .useAmortized(false)
     *         .useBlended(false)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-costtypes.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-costtypes.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_budgets.CfnBudget.CostTypesProperty")
    @software.amazon.jsii.Jsii.Proxy(CostTypesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CostTypesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies whether a budget includes credits.
         * <p>
         * The default value is <code>true</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-costtypes.html#cfn-budgets-budget-costtypes-includecredit">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-costtypes.html#cfn-budgets-budget-costtypes-includecredit</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIncludeCredit() {
            return null;
        }

        /**
         * Specifies whether a budget includes discounts.
         * <p>
         * The default value is <code>true</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-costtypes.html#cfn-budgets-budget-costtypes-includediscount">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-costtypes.html#cfn-budgets-budget-costtypes-includediscount</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIncludeDiscount() {
            return null;
        }

        /**
         * Specifies whether a budget includes non-RI subscription costs.
         * <p>
         * The default value is <code>true</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-costtypes.html#cfn-budgets-budget-costtypes-includeothersubscription">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-costtypes.html#cfn-budgets-budget-costtypes-includeothersubscription</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIncludeOtherSubscription() {
            return null;
        }

        /**
         * Specifies whether a budget includes recurring fees such as monthly RI fees.
         * <p>
         * The default value is <code>true</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-costtypes.html#cfn-budgets-budget-costtypes-includerecurring">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-costtypes.html#cfn-budgets-budget-costtypes-includerecurring</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIncludeRecurring() {
            return null;
        }

        /**
         * Specifies whether a budget includes refunds.
         * <p>
         * The default value is <code>true</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-costtypes.html#cfn-budgets-budget-costtypes-includerefund">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-costtypes.html#cfn-budgets-budget-costtypes-includerefund</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIncludeRefund() {
            return null;
        }

        /**
         * Specifies whether a budget includes subscriptions.
         * <p>
         * The default value is <code>true</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-costtypes.html#cfn-budgets-budget-costtypes-includesubscription">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-costtypes.html#cfn-budgets-budget-costtypes-includesubscription</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIncludeSubscription() {
            return null;
        }

        /**
         * Specifies whether a budget includes support subscription fees.
         * <p>
         * The default value is <code>true</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-costtypes.html#cfn-budgets-budget-costtypes-includesupport">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-costtypes.html#cfn-budgets-budget-costtypes-includesupport</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIncludeSupport() {
            return null;
        }

        /**
         * Specifies whether a budget includes taxes.
         * <p>
         * The default value is <code>true</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-costtypes.html#cfn-budgets-budget-costtypes-includetax">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-costtypes.html#cfn-budgets-budget-costtypes-includetax</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIncludeTax() {
            return null;
        }

        /**
         * Specifies whether a budget includes upfront RI costs.
         * <p>
         * The default value is <code>true</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-costtypes.html#cfn-budgets-budget-costtypes-includeupfront">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-costtypes.html#cfn-budgets-budget-costtypes-includeupfront</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIncludeUpfront() {
            return null;
        }

        /**
         * Specifies whether a budget uses the amortized rate.
         * <p>
         * The default value is <code>false</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-costtypes.html#cfn-budgets-budget-costtypes-useamortized">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-costtypes.html#cfn-budgets-budget-costtypes-useamortized</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getUseAmortized() {
            return null;
        }

        /**
         * Specifies whether a budget uses a blended rate.
         * <p>
         * The default value is <code>false</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-costtypes.html#cfn-budgets-budget-costtypes-useblended">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-costtypes.html#cfn-budgets-budget-costtypes-useblended</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getUseBlended() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CostTypesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CostTypesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CostTypesProperty> {
            java.lang.Object includeCredit;
            java.lang.Object includeDiscount;
            java.lang.Object includeOtherSubscription;
            java.lang.Object includeRecurring;
            java.lang.Object includeRefund;
            java.lang.Object includeSubscription;
            java.lang.Object includeSupport;
            java.lang.Object includeTax;
            java.lang.Object includeUpfront;
            java.lang.Object useAmortized;
            java.lang.Object useBlended;

            /**
             * Sets the value of {@link CostTypesProperty#getIncludeCredit}
             * @param includeCredit Specifies whether a budget includes credits.
             *                      The default value is <code>true</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder includeCredit(java.lang.Boolean includeCredit) {
                this.includeCredit = includeCredit;
                return this;
            }

            /**
             * Sets the value of {@link CostTypesProperty#getIncludeCredit}
             * @param includeCredit Specifies whether a budget includes credits.
             *                      The default value is <code>true</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder includeCredit(software.amazon.awscdk.IResolvable includeCredit) {
                this.includeCredit = includeCredit;
                return this;
            }

            /**
             * Sets the value of {@link CostTypesProperty#getIncludeDiscount}
             * @param includeDiscount Specifies whether a budget includes discounts.
             *                        The default value is <code>true</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder includeDiscount(java.lang.Boolean includeDiscount) {
                this.includeDiscount = includeDiscount;
                return this;
            }

            /**
             * Sets the value of {@link CostTypesProperty#getIncludeDiscount}
             * @param includeDiscount Specifies whether a budget includes discounts.
             *                        The default value is <code>true</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder includeDiscount(software.amazon.awscdk.IResolvable includeDiscount) {
                this.includeDiscount = includeDiscount;
                return this;
            }

            /**
             * Sets the value of {@link CostTypesProperty#getIncludeOtherSubscription}
             * @param includeOtherSubscription Specifies whether a budget includes non-RI subscription costs.
             *                                 The default value is <code>true</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder includeOtherSubscription(java.lang.Boolean includeOtherSubscription) {
                this.includeOtherSubscription = includeOtherSubscription;
                return this;
            }

            /**
             * Sets the value of {@link CostTypesProperty#getIncludeOtherSubscription}
             * @param includeOtherSubscription Specifies whether a budget includes non-RI subscription costs.
             *                                 The default value is <code>true</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder includeOtherSubscription(software.amazon.awscdk.IResolvable includeOtherSubscription) {
                this.includeOtherSubscription = includeOtherSubscription;
                return this;
            }

            /**
             * Sets the value of {@link CostTypesProperty#getIncludeRecurring}
             * @param includeRecurring Specifies whether a budget includes recurring fees such as monthly RI fees.
             *                         The default value is <code>true</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder includeRecurring(java.lang.Boolean includeRecurring) {
                this.includeRecurring = includeRecurring;
                return this;
            }

            /**
             * Sets the value of {@link CostTypesProperty#getIncludeRecurring}
             * @param includeRecurring Specifies whether a budget includes recurring fees such as monthly RI fees.
             *                         The default value is <code>true</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder includeRecurring(software.amazon.awscdk.IResolvable includeRecurring) {
                this.includeRecurring = includeRecurring;
                return this;
            }

            /**
             * Sets the value of {@link CostTypesProperty#getIncludeRefund}
             * @param includeRefund Specifies whether a budget includes refunds.
             *                      The default value is <code>true</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder includeRefund(java.lang.Boolean includeRefund) {
                this.includeRefund = includeRefund;
                return this;
            }

            /**
             * Sets the value of {@link CostTypesProperty#getIncludeRefund}
             * @param includeRefund Specifies whether a budget includes refunds.
             *                      The default value is <code>true</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder includeRefund(software.amazon.awscdk.IResolvable includeRefund) {
                this.includeRefund = includeRefund;
                return this;
            }

            /**
             * Sets the value of {@link CostTypesProperty#getIncludeSubscription}
             * @param includeSubscription Specifies whether a budget includes subscriptions.
             *                            The default value is <code>true</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder includeSubscription(java.lang.Boolean includeSubscription) {
                this.includeSubscription = includeSubscription;
                return this;
            }

            /**
             * Sets the value of {@link CostTypesProperty#getIncludeSubscription}
             * @param includeSubscription Specifies whether a budget includes subscriptions.
             *                            The default value is <code>true</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder includeSubscription(software.amazon.awscdk.IResolvable includeSubscription) {
                this.includeSubscription = includeSubscription;
                return this;
            }

            /**
             * Sets the value of {@link CostTypesProperty#getIncludeSupport}
             * @param includeSupport Specifies whether a budget includes support subscription fees.
             *                       The default value is <code>true</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder includeSupport(java.lang.Boolean includeSupport) {
                this.includeSupport = includeSupport;
                return this;
            }

            /**
             * Sets the value of {@link CostTypesProperty#getIncludeSupport}
             * @param includeSupport Specifies whether a budget includes support subscription fees.
             *                       The default value is <code>true</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder includeSupport(software.amazon.awscdk.IResolvable includeSupport) {
                this.includeSupport = includeSupport;
                return this;
            }

            /**
             * Sets the value of {@link CostTypesProperty#getIncludeTax}
             * @param includeTax Specifies whether a budget includes taxes.
             *                   The default value is <code>true</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder includeTax(java.lang.Boolean includeTax) {
                this.includeTax = includeTax;
                return this;
            }

            /**
             * Sets the value of {@link CostTypesProperty#getIncludeTax}
             * @param includeTax Specifies whether a budget includes taxes.
             *                   The default value is <code>true</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder includeTax(software.amazon.awscdk.IResolvable includeTax) {
                this.includeTax = includeTax;
                return this;
            }

            /**
             * Sets the value of {@link CostTypesProperty#getIncludeUpfront}
             * @param includeUpfront Specifies whether a budget includes upfront RI costs.
             *                       The default value is <code>true</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder includeUpfront(java.lang.Boolean includeUpfront) {
                this.includeUpfront = includeUpfront;
                return this;
            }

            /**
             * Sets the value of {@link CostTypesProperty#getIncludeUpfront}
             * @param includeUpfront Specifies whether a budget includes upfront RI costs.
             *                       The default value is <code>true</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder includeUpfront(software.amazon.awscdk.IResolvable includeUpfront) {
                this.includeUpfront = includeUpfront;
                return this;
            }

            /**
             * Sets the value of {@link CostTypesProperty#getUseAmortized}
             * @param useAmortized Specifies whether a budget uses the amortized rate.
             *                     The default value is <code>false</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder useAmortized(java.lang.Boolean useAmortized) {
                this.useAmortized = useAmortized;
                return this;
            }

            /**
             * Sets the value of {@link CostTypesProperty#getUseAmortized}
             * @param useAmortized Specifies whether a budget uses the amortized rate.
             *                     The default value is <code>false</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder useAmortized(software.amazon.awscdk.IResolvable useAmortized) {
                this.useAmortized = useAmortized;
                return this;
            }

            /**
             * Sets the value of {@link CostTypesProperty#getUseBlended}
             * @param useBlended Specifies whether a budget uses a blended rate.
             *                   The default value is <code>false</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder useBlended(java.lang.Boolean useBlended) {
                this.useBlended = useBlended;
                return this;
            }

            /**
             * Sets the value of {@link CostTypesProperty#getUseBlended}
             * @param useBlended Specifies whether a budget uses a blended rate.
             *                   The default value is <code>false</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder useBlended(software.amazon.awscdk.IResolvable useBlended) {
                this.useBlended = useBlended;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CostTypesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CostTypesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CostTypesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CostTypesProperty {
            private final java.lang.Object includeCredit;
            private final java.lang.Object includeDiscount;
            private final java.lang.Object includeOtherSubscription;
            private final java.lang.Object includeRecurring;
            private final java.lang.Object includeRefund;
            private final java.lang.Object includeSubscription;
            private final java.lang.Object includeSupport;
            private final java.lang.Object includeTax;
            private final java.lang.Object includeUpfront;
            private final java.lang.Object useAmortized;
            private final java.lang.Object useBlended;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.includeCredit = software.amazon.jsii.Kernel.get(this, "includeCredit", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.includeDiscount = software.amazon.jsii.Kernel.get(this, "includeDiscount", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.includeOtherSubscription = software.amazon.jsii.Kernel.get(this, "includeOtherSubscription", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.includeRecurring = software.amazon.jsii.Kernel.get(this, "includeRecurring", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.includeRefund = software.amazon.jsii.Kernel.get(this, "includeRefund", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.includeSubscription = software.amazon.jsii.Kernel.get(this, "includeSubscription", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.includeSupport = software.amazon.jsii.Kernel.get(this, "includeSupport", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.includeTax = software.amazon.jsii.Kernel.get(this, "includeTax", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.includeUpfront = software.amazon.jsii.Kernel.get(this, "includeUpfront", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.useAmortized = software.amazon.jsii.Kernel.get(this, "useAmortized", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.useBlended = software.amazon.jsii.Kernel.get(this, "useBlended", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.includeCredit = builder.includeCredit;
                this.includeDiscount = builder.includeDiscount;
                this.includeOtherSubscription = builder.includeOtherSubscription;
                this.includeRecurring = builder.includeRecurring;
                this.includeRefund = builder.includeRefund;
                this.includeSubscription = builder.includeSubscription;
                this.includeSupport = builder.includeSupport;
                this.includeTax = builder.includeTax;
                this.includeUpfront = builder.includeUpfront;
                this.useAmortized = builder.useAmortized;
                this.useBlended = builder.useBlended;
            }

            @Override
            public final java.lang.Object getIncludeCredit() {
                return this.includeCredit;
            }

            @Override
            public final java.lang.Object getIncludeDiscount() {
                return this.includeDiscount;
            }

            @Override
            public final java.lang.Object getIncludeOtherSubscription() {
                return this.includeOtherSubscription;
            }

            @Override
            public final java.lang.Object getIncludeRecurring() {
                return this.includeRecurring;
            }

            @Override
            public final java.lang.Object getIncludeRefund() {
                return this.includeRefund;
            }

            @Override
            public final java.lang.Object getIncludeSubscription() {
                return this.includeSubscription;
            }

            @Override
            public final java.lang.Object getIncludeSupport() {
                return this.includeSupport;
            }

            @Override
            public final java.lang.Object getIncludeTax() {
                return this.includeTax;
            }

            @Override
            public final java.lang.Object getIncludeUpfront() {
                return this.includeUpfront;
            }

            @Override
            public final java.lang.Object getUseAmortized() {
                return this.useAmortized;
            }

            @Override
            public final java.lang.Object getUseBlended() {
                return this.useBlended;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getIncludeCredit() != null) {
                    data.set("includeCredit", om.valueToTree(this.getIncludeCredit()));
                }
                if (this.getIncludeDiscount() != null) {
                    data.set("includeDiscount", om.valueToTree(this.getIncludeDiscount()));
                }
                if (this.getIncludeOtherSubscription() != null) {
                    data.set("includeOtherSubscription", om.valueToTree(this.getIncludeOtherSubscription()));
                }
                if (this.getIncludeRecurring() != null) {
                    data.set("includeRecurring", om.valueToTree(this.getIncludeRecurring()));
                }
                if (this.getIncludeRefund() != null) {
                    data.set("includeRefund", om.valueToTree(this.getIncludeRefund()));
                }
                if (this.getIncludeSubscription() != null) {
                    data.set("includeSubscription", om.valueToTree(this.getIncludeSubscription()));
                }
                if (this.getIncludeSupport() != null) {
                    data.set("includeSupport", om.valueToTree(this.getIncludeSupport()));
                }
                if (this.getIncludeTax() != null) {
                    data.set("includeTax", om.valueToTree(this.getIncludeTax()));
                }
                if (this.getIncludeUpfront() != null) {
                    data.set("includeUpfront", om.valueToTree(this.getIncludeUpfront()));
                }
                if (this.getUseAmortized() != null) {
                    data.set("useAmortized", om.valueToTree(this.getUseAmortized()));
                }
                if (this.getUseBlended() != null) {
                    data.set("useBlended", om.valueToTree(this.getUseBlended()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_budgets.CfnBudget.CostTypesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CostTypesProperty.Jsii$Proxy that = (CostTypesProperty.Jsii$Proxy) o;

                if (this.includeCredit != null ? !this.includeCredit.equals(that.includeCredit) : that.includeCredit != null) return false;
                if (this.includeDiscount != null ? !this.includeDiscount.equals(that.includeDiscount) : that.includeDiscount != null) return false;
                if (this.includeOtherSubscription != null ? !this.includeOtherSubscription.equals(that.includeOtherSubscription) : that.includeOtherSubscription != null) return false;
                if (this.includeRecurring != null ? !this.includeRecurring.equals(that.includeRecurring) : that.includeRecurring != null) return false;
                if (this.includeRefund != null ? !this.includeRefund.equals(that.includeRefund) : that.includeRefund != null) return false;
                if (this.includeSubscription != null ? !this.includeSubscription.equals(that.includeSubscription) : that.includeSubscription != null) return false;
                if (this.includeSupport != null ? !this.includeSupport.equals(that.includeSupport) : that.includeSupport != null) return false;
                if (this.includeTax != null ? !this.includeTax.equals(that.includeTax) : that.includeTax != null) return false;
                if (this.includeUpfront != null ? !this.includeUpfront.equals(that.includeUpfront) : that.includeUpfront != null) return false;
                if (this.useAmortized != null ? !this.useAmortized.equals(that.useAmortized) : that.useAmortized != null) return false;
                return this.useBlended != null ? this.useBlended.equals(that.useBlended) : that.useBlended == null;
            }

            @Override
            public final int hashCode() {
                int result = this.includeCredit != null ? this.includeCredit.hashCode() : 0;
                result = 31 * result + (this.includeDiscount != null ? this.includeDiscount.hashCode() : 0);
                result = 31 * result + (this.includeOtherSubscription != null ? this.includeOtherSubscription.hashCode() : 0);
                result = 31 * result + (this.includeRecurring != null ? this.includeRecurring.hashCode() : 0);
                result = 31 * result + (this.includeRefund != null ? this.includeRefund.hashCode() : 0);
                result = 31 * result + (this.includeSubscription != null ? this.includeSubscription.hashCode() : 0);
                result = 31 * result + (this.includeSupport != null ? this.includeSupport.hashCode() : 0);
                result = 31 * result + (this.includeTax != null ? this.includeTax.hashCode() : 0);
                result = 31 * result + (this.includeUpfront != null ? this.includeUpfront.hashCode() : 0);
                result = 31 * result + (this.useAmortized != null ? this.useAmortized.hashCode() : 0);
                result = 31 * result + (this.useBlended != null ? this.useBlended.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Contains the specifications for the filters to use for your request.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.budgets.*;
     * ExpressionDimensionValuesProperty expressionDimensionValuesProperty = ExpressionDimensionValuesProperty.builder()
     *         .key("key")
     *         .matchOptions(List.of("matchOptions"))
     *         .values(List.of("values"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-expressiondimensionvalues.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-expressiondimensionvalues.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_budgets.CfnBudget.ExpressionDimensionValuesProperty")
    @software.amazon.jsii.Jsii.Proxy(ExpressionDimensionValuesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ExpressionDimensionValuesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the dimension that you want to filter on.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-expressiondimensionvalues.html#cfn-budgets-budget-expressiondimensionvalues-key">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-expressiondimensionvalues.html#cfn-budgets-budget-expressiondimensionvalues-key</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getKey() {
            return null;
        }

        /**
         * The match options that you can use to filter your results.
         * <p>
         * You can specify only one of these values in the array.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-expressiondimensionvalues.html#cfn-budgets-budget-expressiondimensionvalues-matchoptions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-expressiondimensionvalues.html#cfn-budgets-budget-expressiondimensionvalues-matchoptions</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getMatchOptions() {
            return null;
        }

        /**
         * The metadata values you can specify to filter upon, so that the results all match at least one of the specified values.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-expressiondimensionvalues.html#cfn-budgets-budget-expressiondimensionvalues-values">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-expressiondimensionvalues.html#cfn-budgets-budget-expressiondimensionvalues-values</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getValues() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ExpressionDimensionValuesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ExpressionDimensionValuesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ExpressionDimensionValuesProperty> {
            java.lang.String key;
            java.util.List<java.lang.String> matchOptions;
            java.util.List<java.lang.String> values;

            /**
             * Sets the value of {@link ExpressionDimensionValuesProperty#getKey}
             * @param key The name of the dimension that you want to filter on.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder key(java.lang.String key) {
                this.key = key;
                return this;
            }

            /**
             * Sets the value of {@link ExpressionDimensionValuesProperty#getMatchOptions}
             * @param matchOptions The match options that you can use to filter your results.
             *                     You can specify only one of these values in the array.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder matchOptions(java.util.List<java.lang.String> matchOptions) {
                this.matchOptions = matchOptions;
                return this;
            }

            /**
             * Sets the value of {@link ExpressionDimensionValuesProperty#getValues}
             * @param values The metadata values you can specify to filter upon, so that the results all match at least one of the specified values.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder values(java.util.List<java.lang.String> values) {
                this.values = values;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ExpressionDimensionValuesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ExpressionDimensionValuesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ExpressionDimensionValuesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ExpressionDimensionValuesProperty {
            private final java.lang.String key;
            private final java.util.List<java.lang.String> matchOptions;
            private final java.util.List<java.lang.String> values;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.key = software.amazon.jsii.Kernel.get(this, "key", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.matchOptions = software.amazon.jsii.Kernel.get(this, "matchOptions", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.values = software.amazon.jsii.Kernel.get(this, "values", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.key = builder.key;
                this.matchOptions = builder.matchOptions;
                this.values = builder.values;
            }

            @Override
            public final java.lang.String getKey() {
                return this.key;
            }

            @Override
            public final java.util.List<java.lang.String> getMatchOptions() {
                return this.matchOptions;
            }

            @Override
            public final java.util.List<java.lang.String> getValues() {
                return this.values;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getKey() != null) {
                    data.set("key", om.valueToTree(this.getKey()));
                }
                if (this.getMatchOptions() != null) {
                    data.set("matchOptions", om.valueToTree(this.getMatchOptions()));
                }
                if (this.getValues() != null) {
                    data.set("values", om.valueToTree(this.getValues()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_budgets.CfnBudget.ExpressionDimensionValuesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ExpressionDimensionValuesProperty.Jsii$Proxy that = (ExpressionDimensionValuesProperty.Jsii$Proxy) o;

                if (this.key != null ? !this.key.equals(that.key) : that.key != null) return false;
                if (this.matchOptions != null ? !this.matchOptions.equals(that.matchOptions) : that.matchOptions != null) return false;
                return this.values != null ? this.values.equals(that.values) : that.values == null;
            }

            @Override
            public final int hashCode() {
                int result = this.key != null ? this.key.hashCode() : 0;
                result = 31 * result + (this.matchOptions != null ? this.matchOptions.hashCode() : 0);
                result = 31 * result + (this.values != null ? this.values.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Use Expression to filter in various Budgets APIs.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.budgets.*;
     * ExpressionProperty expressionProperty_;
     * ExpressionProperty expressionProperty = ExpressionProperty.builder()
     *         .and(List.of(expressionProperty_))
     *         .costCategories(CostCategoryValuesProperty.builder()
     *                 .key("key")
     *                 .matchOptions(List.of("matchOptions"))
     *                 .values(List.of("values"))
     *                 .build())
     *         .dimensions(ExpressionDimensionValuesProperty.builder()
     *                 .key("key")
     *                 .matchOptions(List.of("matchOptions"))
     *                 .values(List.of("values"))
     *                 .build())
     *         .not(expressionProperty_)
     *         .or(List.of(expressionProperty_))
     *         .tags(TagValuesProperty.builder()
     *                 .key("key")
     *                 .matchOptions(List.of("matchOptions"))
     *                 .values(List.of("values"))
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-expression.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-expression.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_budgets.CfnBudget.ExpressionProperty")
    @software.amazon.jsii.Jsii.Proxy(ExpressionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ExpressionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Return results that match both Dimension objects.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-expression.html#cfn-budgets-budget-expression-and">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-expression.html#cfn-budgets-budget-expression-and</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAnd() {
            return null;
        }

        /**
         * The filter that's based on CostCategoryValues.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-expression.html#cfn-budgets-budget-expression-costcategories">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-expression.html#cfn-budgets-budget-expression-costcategories</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCostCategories() {
            return null;
        }

        /**
         * The specific Dimension to use for Expression.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-expression.html#cfn-budgets-budget-expression-dimensions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-expression.html#cfn-budgets-budget-expression-dimensions</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDimensions() {
            return null;
        }

        /**
         * Return results that don't match a Dimension object.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-expression.html#cfn-budgets-budget-expression-not">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-expression.html#cfn-budgets-budget-expression-not</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getNot() {
            return null;
        }

        /**
         * Return results that match either Dimension object.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-expression.html#cfn-budgets-budget-expression-or">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-expression.html#cfn-budgets-budget-expression-or</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getOr() {
            return null;
        }

        /**
         * The specific Tag to use for Expression.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-expression.html#cfn-budgets-budget-expression-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-expression.html#cfn-budgets-budget-expression-tags</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.budgets.CfnBudget.TagValuesProperty getTags() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ExpressionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ExpressionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ExpressionProperty> {
            java.lang.Object and;
            java.lang.Object costCategories;
            java.lang.Object dimensions;
            java.lang.Object not;
            java.lang.Object or;
            software.amazon.awscdk.services.budgets.CfnBudget.TagValuesProperty tags;

            /**
             * Sets the value of {@link ExpressionProperty#getAnd}
             * @param and Return results that match both Dimension objects.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder and(software.amazon.awscdk.IResolvable and) {
                this.and = and;
                return this;
            }

            /**
             * Sets the value of {@link ExpressionProperty#getAnd}
             * @param and Return results that match both Dimension objects.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder and(java.util.List<? extends java.lang.Object> and) {
                this.and = and;
                return this;
            }

            /**
             * Sets the value of {@link ExpressionProperty#getCostCategories}
             * @param costCategories The filter that's based on CostCategoryValues.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder costCategories(software.amazon.awscdk.IResolvable costCategories) {
                this.costCategories = costCategories;
                return this;
            }

            /**
             * Sets the value of {@link ExpressionProperty#getCostCategories}
             * @param costCategories The filter that's based on CostCategoryValues.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder costCategories(software.amazon.awscdk.services.budgets.CfnBudget.CostCategoryValuesProperty costCategories) {
                this.costCategories = costCategories;
                return this;
            }

            /**
             * Sets the value of {@link ExpressionProperty#getDimensions}
             * @param dimensions The specific Dimension to use for Expression.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dimensions(software.amazon.awscdk.IResolvable dimensions) {
                this.dimensions = dimensions;
                return this;
            }

            /**
             * Sets the value of {@link ExpressionProperty#getDimensions}
             * @param dimensions The specific Dimension to use for Expression.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dimensions(software.amazon.awscdk.services.budgets.CfnBudget.ExpressionDimensionValuesProperty dimensions) {
                this.dimensions = dimensions;
                return this;
            }

            /**
             * Sets the value of {@link ExpressionProperty#getNot}
             * @param not Return results that don't match a Dimension object.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder not(software.amazon.awscdk.IResolvable not) {
                this.not = not;
                return this;
            }

            /**
             * Sets the value of {@link ExpressionProperty#getNot}
             * @param not Return results that don't match a Dimension object.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder not(software.amazon.awscdk.services.budgets.CfnBudget.ExpressionProperty not) {
                this.not = not;
                return this;
            }

            /**
             * Sets the value of {@link ExpressionProperty#getOr}
             * @param or Return results that match either Dimension object.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder or(software.amazon.awscdk.IResolvable or) {
                this.or = or;
                return this;
            }

            /**
             * Sets the value of {@link ExpressionProperty#getOr}
             * @param or Return results that match either Dimension object.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder or(java.util.List<? extends java.lang.Object> or) {
                this.or = or;
                return this;
            }

            /**
             * Sets the value of {@link ExpressionProperty#getTags}
             * @param tags The specific Tag to use for Expression.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tags(software.amazon.awscdk.services.budgets.CfnBudget.TagValuesProperty tags) {
                this.tags = tags;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ExpressionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ExpressionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ExpressionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ExpressionProperty {
            private final java.lang.Object and;
            private final java.lang.Object costCategories;
            private final java.lang.Object dimensions;
            private final java.lang.Object not;
            private final java.lang.Object or;
            private final software.amazon.awscdk.services.budgets.CfnBudget.TagValuesProperty tags;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.and = software.amazon.jsii.Kernel.get(this, "and", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.costCategories = software.amazon.jsii.Kernel.get(this, "costCategories", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.dimensions = software.amazon.jsii.Kernel.get(this, "dimensions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.not = software.amazon.jsii.Kernel.get(this, "not", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.or = software.amazon.jsii.Kernel.get(this, "or", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.budgets.CfnBudget.TagValuesProperty.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.and = builder.and;
                this.costCategories = builder.costCategories;
                this.dimensions = builder.dimensions;
                this.not = builder.not;
                this.or = builder.or;
                this.tags = builder.tags;
            }

            @Override
            public final java.lang.Object getAnd() {
                return this.and;
            }

            @Override
            public final java.lang.Object getCostCategories() {
                return this.costCategories;
            }

            @Override
            public final java.lang.Object getDimensions() {
                return this.dimensions;
            }

            @Override
            public final java.lang.Object getNot() {
                return this.not;
            }

            @Override
            public final java.lang.Object getOr() {
                return this.or;
            }

            @Override
            public final software.amazon.awscdk.services.budgets.CfnBudget.TagValuesProperty getTags() {
                return this.tags;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAnd() != null) {
                    data.set("and", om.valueToTree(this.getAnd()));
                }
                if (this.getCostCategories() != null) {
                    data.set("costCategories", om.valueToTree(this.getCostCategories()));
                }
                if (this.getDimensions() != null) {
                    data.set("dimensions", om.valueToTree(this.getDimensions()));
                }
                if (this.getNot() != null) {
                    data.set("not", om.valueToTree(this.getNot()));
                }
                if (this.getOr() != null) {
                    data.set("or", om.valueToTree(this.getOr()));
                }
                if (this.getTags() != null) {
                    data.set("tags", om.valueToTree(this.getTags()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_budgets.CfnBudget.ExpressionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ExpressionProperty.Jsii$Proxy that = (ExpressionProperty.Jsii$Proxy) o;

                if (this.and != null ? !this.and.equals(that.and) : that.and != null) return false;
                if (this.costCategories != null ? !this.costCategories.equals(that.costCategories) : that.costCategories != null) return false;
                if (this.dimensions != null ? !this.dimensions.equals(that.dimensions) : that.dimensions != null) return false;
                if (this.not != null ? !this.not.equals(that.not) : that.not != null) return false;
                if (this.or != null ? !this.or.equals(that.or) : that.or != null) return false;
                return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
            }

            @Override
            public final int hashCode() {
                int result = this.and != null ? this.and.hashCode() : 0;
                result = 31 * result + (this.costCategories != null ? this.costCategories.hashCode() : 0);
                result = 31 * result + (this.dimensions != null ? this.dimensions.hashCode() : 0);
                result = 31 * result + (this.not != null ? this.not.hashCode() : 0);
                result = 31 * result + (this.or != null ? this.or.hashCode() : 0);
                result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The parameters that define or describe the historical data that your auto-adjusting budget is based on.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.budgets.*;
     * HistoricalOptionsProperty historicalOptionsProperty = HistoricalOptionsProperty.builder()
     *         .budgetAdjustmentPeriod(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-historicaloptions.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-historicaloptions.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_budgets.CfnBudget.HistoricalOptionsProperty")
    @software.amazon.jsii.Jsii.Proxy(HistoricalOptionsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface HistoricalOptionsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The number of budget periods included in the moving-average calculation that determines your auto-adjusted budget amount.
         * <p>
         * The maximum value depends on the <code>TimeUnit</code> granularity of the budget:
         * <p>
         * <ul>
         * <li>For the <code>DAILY</code> granularity, the maximum value is <code>60</code> .</li>
         * <li>For the <code>MONTHLY</code> granularity, the maximum value is <code>12</code> .</li>
         * <li>For the <code>QUARTERLY</code> granularity, the maximum value is <code>4</code> .</li>
         * <li>For the <code>ANNUALLY</code> granularity, the maximum value is <code>1</code> .</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-historicaloptions.html#cfn-budgets-budget-historicaloptions-budgetadjustmentperiod">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-historicaloptions.html#cfn-budgets-budget-historicaloptions-budgetadjustmentperiod</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getBudgetAdjustmentPeriod();

        /**
         * @return a {@link Builder} of {@link HistoricalOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link HistoricalOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<HistoricalOptionsProperty> {
            java.lang.Number budgetAdjustmentPeriod;

            /**
             * Sets the value of {@link HistoricalOptionsProperty#getBudgetAdjustmentPeriod}
             * @param budgetAdjustmentPeriod The number of budget periods included in the moving-average calculation that determines your auto-adjusted budget amount. This parameter is required.
             *                               The maximum value depends on the <code>TimeUnit</code> granularity of the budget:
             *                               <p>
             *                               <ul>
             *                               <li>For the <code>DAILY</code> granularity, the maximum value is <code>60</code> .</li>
             *                               <li>For the <code>MONTHLY</code> granularity, the maximum value is <code>12</code> .</li>
             *                               <li>For the <code>QUARTERLY</code> granularity, the maximum value is <code>4</code> .</li>
             *                               <li>For the <code>ANNUALLY</code> granularity, the maximum value is <code>1</code> .</li>
             *                               </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder budgetAdjustmentPeriod(java.lang.Number budgetAdjustmentPeriod) {
                this.budgetAdjustmentPeriod = budgetAdjustmentPeriod;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link HistoricalOptionsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public HistoricalOptionsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link HistoricalOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements HistoricalOptionsProperty {
            private final java.lang.Number budgetAdjustmentPeriod;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.budgetAdjustmentPeriod = software.amazon.jsii.Kernel.get(this, "budgetAdjustmentPeriod", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.budgetAdjustmentPeriod = java.util.Objects.requireNonNull(builder.budgetAdjustmentPeriod, "budgetAdjustmentPeriod is required");
            }

            @Override
            public final java.lang.Number getBudgetAdjustmentPeriod() {
                return this.budgetAdjustmentPeriod;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("budgetAdjustmentPeriod", om.valueToTree(this.getBudgetAdjustmentPeriod()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_budgets.CfnBudget.HistoricalOptionsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                HistoricalOptionsProperty.Jsii$Proxy that = (HistoricalOptionsProperty.Jsii$Proxy) o;

                return this.budgetAdjustmentPeriod.equals(that.budgetAdjustmentPeriod);
            }

            @Override
            public final int hashCode() {
                int result = this.budgetAdjustmentPeriod.hashCode();
                return result;
            }
        }
    }
    /**
     * A notification that's associated with a budget. A budget can have up to ten notifications.
     * <p>
     * Each notification must have at least one subscriber. A notification can have one SNS subscriber and up to 10 email subscribers, for a total of 11 subscribers.
     * <p>
     * For example, if you have a budget for 200 dollars and you want to be notified when you go over 160 dollars, create a notification with the following parameters:
     * <p>
     * <ul>
     * <li>A notificationType of <code>ACTUAL</code></li>
     * <li>A <code>thresholdType</code> of <code>PERCENTAGE</code></li>
     * <li>A <code>comparisonOperator</code> of <code>GREATER_THAN</code></li>
     * <li>A notification <code>threshold</code> of <code>80</code></li>
     * </ul>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.budgets.*;
     * NotificationProperty notificationProperty = NotificationProperty.builder()
     *         .comparisonOperator("comparisonOperator")
     *         .notificationType("notificationType")
     *         .threshold(123)
     *         // the properties below are optional
     *         .thresholdType("thresholdType")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-notification.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-notification.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_budgets.CfnBudget.NotificationProperty")
    @software.amazon.jsii.Jsii.Proxy(NotificationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface NotificationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The comparison that's used for this notification.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-notification.html#cfn-budgets-budget-notification-comparisonoperator">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-notification.html#cfn-budgets-budget-notification-comparisonoperator</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getComparisonOperator();

        /**
         * Specifies whether the notification is for how much you have spent ( <code>ACTUAL</code> ) or for how much that you're forecasted to spend ( <code>FORECASTED</code> ).
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-notification.html#cfn-budgets-budget-notification-notificationtype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-notification.html#cfn-budgets-budget-notification-notificationtype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getNotificationType();

        /**
         * The threshold that's associated with a notification.
         * <p>
         * Thresholds are always a percentage, and many customers find value being alerted between 50% - 200% of the budgeted amount. The maximum limit for your threshold is 1,000,000% above the budgeted amount.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-notification.html#cfn-budgets-budget-notification-threshold">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-notification.html#cfn-budgets-budget-notification-threshold</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getThreshold();

        /**
         * The type of threshold for a notification.
         * <p>
         * For <code>ABSOLUTE_VALUE</code> thresholds, AWS notifies you when you go over or are forecasted to go over your total cost threshold. For <code>PERCENTAGE</code> thresholds, AWS notifies you when you go over or are forecasted to go over a certain percentage of your forecasted spend. For example, if you have a budget for 200 dollars and you have a <code>PERCENTAGE</code> threshold of 80%, AWS notifies you when you go over 160 dollars.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-notification.html#cfn-budgets-budget-notification-thresholdtype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-notification.html#cfn-budgets-budget-notification-thresholdtype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getThresholdType() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link NotificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link NotificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<NotificationProperty> {
            java.lang.String comparisonOperator;
            java.lang.String notificationType;
            java.lang.Number threshold;
            java.lang.String thresholdType;

            /**
             * Sets the value of {@link NotificationProperty#getComparisonOperator}
             * @param comparisonOperator The comparison that's used for this notification. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder comparisonOperator(java.lang.String comparisonOperator) {
                this.comparisonOperator = comparisonOperator;
                return this;
            }

            /**
             * Sets the value of {@link NotificationProperty#getNotificationType}
             * @param notificationType Specifies whether the notification is for how much you have spent ( <code>ACTUAL</code> ) or for how much that you're forecasted to spend ( <code>FORECASTED</code> ). This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder notificationType(java.lang.String notificationType) {
                this.notificationType = notificationType;
                return this;
            }

            /**
             * Sets the value of {@link NotificationProperty#getThreshold}
             * @param threshold The threshold that's associated with a notification. This parameter is required.
             *                  Thresholds are always a percentage, and many customers find value being alerted between 50% - 200% of the budgeted amount. The maximum limit for your threshold is 1,000,000% above the budgeted amount.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder threshold(java.lang.Number threshold) {
                this.threshold = threshold;
                return this;
            }

            /**
             * Sets the value of {@link NotificationProperty#getThresholdType}
             * @param thresholdType The type of threshold for a notification.
             *                      For <code>ABSOLUTE_VALUE</code> thresholds, AWS notifies you when you go over or are forecasted to go over your total cost threshold. For <code>PERCENTAGE</code> thresholds, AWS notifies you when you go over or are forecasted to go over a certain percentage of your forecasted spend. For example, if you have a budget for 200 dollars and you have a <code>PERCENTAGE</code> threshold of 80%, AWS notifies you when you go over 160 dollars.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder thresholdType(java.lang.String thresholdType) {
                this.thresholdType = thresholdType;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link NotificationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public NotificationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link NotificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements NotificationProperty {
            private final java.lang.String comparisonOperator;
            private final java.lang.String notificationType;
            private final java.lang.Number threshold;
            private final java.lang.String thresholdType;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.comparisonOperator = software.amazon.jsii.Kernel.get(this, "comparisonOperator", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.notificationType = software.amazon.jsii.Kernel.get(this, "notificationType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.threshold = software.amazon.jsii.Kernel.get(this, "threshold", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.thresholdType = software.amazon.jsii.Kernel.get(this, "thresholdType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.comparisonOperator = java.util.Objects.requireNonNull(builder.comparisonOperator, "comparisonOperator is required");
                this.notificationType = java.util.Objects.requireNonNull(builder.notificationType, "notificationType is required");
                this.threshold = java.util.Objects.requireNonNull(builder.threshold, "threshold is required");
                this.thresholdType = builder.thresholdType;
            }

            @Override
            public final java.lang.String getComparisonOperator() {
                return this.comparisonOperator;
            }

            @Override
            public final java.lang.String getNotificationType() {
                return this.notificationType;
            }

            @Override
            public final java.lang.Number getThreshold() {
                return this.threshold;
            }

            @Override
            public final java.lang.String getThresholdType() {
                return this.thresholdType;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("comparisonOperator", om.valueToTree(this.getComparisonOperator()));
                data.set("notificationType", om.valueToTree(this.getNotificationType()));
                data.set("threshold", om.valueToTree(this.getThreshold()));
                if (this.getThresholdType() != null) {
                    data.set("thresholdType", om.valueToTree(this.getThresholdType()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_budgets.CfnBudget.NotificationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                NotificationProperty.Jsii$Proxy that = (NotificationProperty.Jsii$Proxy) o;

                if (!comparisonOperator.equals(that.comparisonOperator)) return false;
                if (!notificationType.equals(that.notificationType)) return false;
                if (!threshold.equals(that.threshold)) return false;
                return this.thresholdType != null ? this.thresholdType.equals(that.thresholdType) : that.thresholdType == null;
            }

            @Override
            public final int hashCode() {
                int result = this.comparisonOperator.hashCode();
                result = 31 * result + (this.notificationType.hashCode());
                result = 31 * result + (this.threshold.hashCode());
                result = 31 * result + (this.thresholdType != null ? this.thresholdType.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A notification with subscribers.
     * <p>
     * A notification can have one SNS subscriber and up to 10 email subscribers, for a total of 11 subscribers.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.budgets.*;
     * NotificationWithSubscribersProperty notificationWithSubscribersProperty = NotificationWithSubscribersProperty.builder()
     *         .notification(NotificationProperty.builder()
     *                 .comparisonOperator("comparisonOperator")
     *                 .notificationType("notificationType")
     *                 .threshold(123)
     *                 // the properties below are optional
     *                 .thresholdType("thresholdType")
     *                 .build())
     *         .subscribers(List.of(SubscriberProperty.builder()
     *                 .address("address")
     *                 .subscriptionType("subscriptionType")
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-notificationwithsubscribers.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-notificationwithsubscribers.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_budgets.CfnBudget.NotificationWithSubscribersProperty")
    @software.amazon.jsii.Jsii.Proxy(NotificationWithSubscribersProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface NotificationWithSubscribersProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The notification that's associated with a budget.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-notificationwithsubscribers.html#cfn-budgets-budget-notificationwithsubscribers-notification">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-notificationwithsubscribers.html#cfn-budgets-budget-notificationwithsubscribers-notification</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getNotification();

        /**
         * A list of subscribers who are subscribed to this notification.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-notificationwithsubscribers.html#cfn-budgets-budget-notificationwithsubscribers-subscribers">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-notificationwithsubscribers.html#cfn-budgets-budget-notificationwithsubscribers-subscribers</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getSubscribers();

        /**
         * @return a {@link Builder} of {@link NotificationWithSubscribersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link NotificationWithSubscribersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<NotificationWithSubscribersProperty> {
            java.lang.Object notification;
            java.lang.Object subscribers;

            /**
             * Sets the value of {@link NotificationWithSubscribersProperty#getNotification}
             * @param notification The notification that's associated with a budget. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder notification(software.amazon.awscdk.IResolvable notification) {
                this.notification = notification;
                return this;
            }

            /**
             * Sets the value of {@link NotificationWithSubscribersProperty#getNotification}
             * @param notification The notification that's associated with a budget. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder notification(software.amazon.awscdk.services.budgets.CfnBudget.NotificationProperty notification) {
                this.notification = notification;
                return this;
            }

            /**
             * Sets the value of {@link NotificationWithSubscribersProperty#getSubscribers}
             * @param subscribers A list of subscribers who are subscribed to this notification. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder subscribers(software.amazon.awscdk.IResolvable subscribers) {
                this.subscribers = subscribers;
                return this;
            }

            /**
             * Sets the value of {@link NotificationWithSubscribersProperty#getSubscribers}
             * @param subscribers A list of subscribers who are subscribed to this notification. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder subscribers(java.util.List<? extends java.lang.Object> subscribers) {
                this.subscribers = subscribers;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link NotificationWithSubscribersProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public NotificationWithSubscribersProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link NotificationWithSubscribersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements NotificationWithSubscribersProperty {
            private final java.lang.Object notification;
            private final java.lang.Object subscribers;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.notification = software.amazon.jsii.Kernel.get(this, "notification", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.subscribers = software.amazon.jsii.Kernel.get(this, "subscribers", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.notification = java.util.Objects.requireNonNull(builder.notification, "notification is required");
                this.subscribers = java.util.Objects.requireNonNull(builder.subscribers, "subscribers is required");
            }

            @Override
            public final java.lang.Object getNotification() {
                return this.notification;
            }

            @Override
            public final java.lang.Object getSubscribers() {
                return this.subscribers;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("notification", om.valueToTree(this.getNotification()));
                data.set("subscribers", om.valueToTree(this.getSubscribers()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_budgets.CfnBudget.NotificationWithSubscribersProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                NotificationWithSubscribersProperty.Jsii$Proxy that = (NotificationWithSubscribersProperty.Jsii$Proxy) o;

                if (!notification.equals(that.notification)) return false;
                return this.subscribers.equals(that.subscribers);
            }

            @Override
            public final int hashCode() {
                int result = this.notification.hashCode();
                result = 31 * result + (this.subscribers.hashCode());
                return result;
            }
        }
    }
    /**
     * The tag structure that contains a tag key and value.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.budgets.*;
     * ResourceTagProperty resourceTagProperty = ResourceTagProperty.builder()
     *         .key("key")
     *         // the properties below are optional
     *         .value("value")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-resourcetag.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-resourcetag.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_budgets.CfnBudget.ResourceTagProperty")
    @software.amazon.jsii.Jsii.Proxy(ResourceTagProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ResourceTagProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The key that's associated with the tag.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-resourcetag.html#cfn-budgets-budget-resourcetag-key">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-resourcetag.html#cfn-budgets-budget-resourcetag-key</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getKey();

        /**
         * The value that's associated with the tag.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-resourcetag.html#cfn-budgets-budget-resourcetag-value">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-resourcetag.html#cfn-budgets-budget-resourcetag-value</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getValue() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ResourceTagProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ResourceTagProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ResourceTagProperty> {
            java.lang.String key;
            java.lang.String value;

            /**
             * Sets the value of {@link ResourceTagProperty#getKey}
             * @param key The key that's associated with the tag. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder key(java.lang.String key) {
                this.key = key;
                return this;
            }

            /**
             * Sets the value of {@link ResourceTagProperty#getValue}
             * @param value The value that's associated with the tag.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(java.lang.String value) {
                this.value = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ResourceTagProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ResourceTagProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ResourceTagProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ResourceTagProperty {
            private final java.lang.String key;
            private final java.lang.String value;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.key = software.amazon.jsii.Kernel.get(this, "key", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.value = software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.key = java.util.Objects.requireNonNull(builder.key, "key is required");
                this.value = builder.value;
            }

            @Override
            public final java.lang.String getKey() {
                return this.key;
            }

            @Override
            public final java.lang.String getValue() {
                return this.value;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("key", om.valueToTree(this.getKey()));
                if (this.getValue() != null) {
                    data.set("value", om.valueToTree(this.getValue()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_budgets.CfnBudget.ResourceTagProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ResourceTagProperty.Jsii$Proxy that = (ResourceTagProperty.Jsii$Proxy) o;

                if (!key.equals(that.key)) return false;
                return this.value != null ? this.value.equals(that.value) : that.value == null;
            }

            @Override
            public final int hashCode() {
                int result = this.key.hashCode();
                result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The amount of cost or usage that's measured for a budget.
     * <p>
     * <em>Cost example:</em> A <code>Spend</code> for <code>3 USD</code> of costs has the following parameters:
     * <p>
     * <ul>
     * <li>An <code>Amount</code> of <code>3</code></li>
     * <li>A <code>Unit</code> of <code>USD</code></li>
     * </ul>
     * <p>
     * <em>Usage example:</em> A <code>Spend</code> for <code>3 GB</code> of S3 usage has the following parameters:
     * <p>
     * <ul>
     * <li>An <code>Amount</code> of <code>3</code></li>
     * <li>A <code>Unit</code> of <code>GB</code></li>
     * </ul>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.budgets.*;
     * SpendProperty spendProperty = SpendProperty.builder()
     *         .amount(123)
     *         .unit("unit")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-spend.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-spend.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_budgets.CfnBudget.SpendProperty")
    @software.amazon.jsii.Jsii.Proxy(SpendProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SpendProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The cost or usage amount that's associated with a budget forecast, actual spend, or budget threshold.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-spend.html#cfn-budgets-budget-spend-amount">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-spend.html#cfn-budgets-budget-spend-amount</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getAmount();

        /**
         * The unit of measurement that's used for the budget forecast, actual spend, or budget threshold.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-spend.html#cfn-budgets-budget-spend-unit">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-spend.html#cfn-budgets-budget-spend-unit</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getUnit();

        /**
         * @return a {@link Builder} of {@link SpendProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SpendProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SpendProperty> {
            java.lang.Number amount;
            java.lang.String unit;

            /**
             * Sets the value of {@link SpendProperty#getAmount}
             * @param amount The cost or usage amount that's associated with a budget forecast, actual spend, or budget threshold. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder amount(java.lang.Number amount) {
                this.amount = amount;
                return this;
            }

            /**
             * Sets the value of {@link SpendProperty#getUnit}
             * @param unit The unit of measurement that's used for the budget forecast, actual spend, or budget threshold. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder unit(java.lang.String unit) {
                this.unit = unit;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SpendProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SpendProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SpendProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SpendProperty {
            private final java.lang.Number amount;
            private final java.lang.String unit;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.amount = software.amazon.jsii.Kernel.get(this, "amount", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.unit = software.amazon.jsii.Kernel.get(this, "unit", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.amount = java.util.Objects.requireNonNull(builder.amount, "amount is required");
                this.unit = java.util.Objects.requireNonNull(builder.unit, "unit is required");
            }

            @Override
            public final java.lang.Number getAmount() {
                return this.amount;
            }

            @Override
            public final java.lang.String getUnit() {
                return this.unit;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("amount", om.valueToTree(this.getAmount()));
                data.set("unit", om.valueToTree(this.getUnit()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_budgets.CfnBudget.SpendProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SpendProperty.Jsii$Proxy that = (SpendProperty.Jsii$Proxy) o;

                if (!amount.equals(that.amount)) return false;
                return this.unit.equals(that.unit);
            }

            @Override
            public final int hashCode() {
                int result = this.amount.hashCode();
                result = 31 * result + (this.unit.hashCode());
                return result;
            }
        }
    }
    /**
     * The <code>Subscriber</code> property type specifies who to notify for a Billing and Cost Management budget notification.
     * <p>
     * The subscriber consists of a subscription type, and either an Amazon SNS topic or an email address.
     * <p>
     * For example, an email subscriber would have the following parameters:
     * <p>
     * <ul>
     * <li>A <code>subscriptionType</code> of <code>EMAIL</code></li>
     * <li>An <code>address</code> of <code>example&#64;example.com</code></li>
     * </ul>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.budgets.*;
     * SubscriberProperty subscriberProperty = SubscriberProperty.builder()
     *         .address("address")
     *         .subscriptionType("subscriptionType")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-subscriber.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-subscriber.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_budgets.CfnBudget.SubscriberProperty")
    @software.amazon.jsii.Jsii.Proxy(SubscriberProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SubscriberProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The address that AWS sends budget notifications to, either an SNS topic or an email.
         * <p>
         * When you create a subscriber, the value of <code>Address</code> can't contain line breaks.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-subscriber.html#cfn-budgets-budget-subscriber-address">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-subscriber.html#cfn-budgets-budget-subscriber-address</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getAddress();

        /**
         * The type of notification that AWS sends to a subscriber.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-subscriber.html#cfn-budgets-budget-subscriber-subscriptiontype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-subscriber.html#cfn-budgets-budget-subscriber-subscriptiontype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getSubscriptionType();

        /**
         * @return a {@link Builder} of {@link SubscriberProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SubscriberProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SubscriberProperty> {
            java.lang.String address;
            java.lang.String subscriptionType;

            /**
             * Sets the value of {@link SubscriberProperty#getAddress}
             * @param address The address that AWS sends budget notifications to, either an SNS topic or an email. This parameter is required.
             *                When you create a subscriber, the value of <code>Address</code> can't contain line breaks.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder address(java.lang.String address) {
                this.address = address;
                return this;
            }

            /**
             * Sets the value of {@link SubscriberProperty#getSubscriptionType}
             * @param subscriptionType The type of notification that AWS sends to a subscriber. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder subscriptionType(java.lang.String subscriptionType) {
                this.subscriptionType = subscriptionType;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SubscriberProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SubscriberProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SubscriberProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SubscriberProperty {
            private final java.lang.String address;
            private final java.lang.String subscriptionType;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.address = software.amazon.jsii.Kernel.get(this, "address", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.subscriptionType = software.amazon.jsii.Kernel.get(this, "subscriptionType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.address = java.util.Objects.requireNonNull(builder.address, "address is required");
                this.subscriptionType = java.util.Objects.requireNonNull(builder.subscriptionType, "subscriptionType is required");
            }

            @Override
            public final java.lang.String getAddress() {
                return this.address;
            }

            @Override
            public final java.lang.String getSubscriptionType() {
                return this.subscriptionType;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("address", om.valueToTree(this.getAddress()));
                data.set("subscriptionType", om.valueToTree(this.getSubscriptionType()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_budgets.CfnBudget.SubscriberProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SubscriberProperty.Jsii$Proxy that = (SubscriberProperty.Jsii$Proxy) o;

                if (!address.equals(that.address)) return false;
                return this.subscriptionType.equals(that.subscriptionType);
            }

            @Override
            public final int hashCode() {
                int result = this.address.hashCode();
                result = 31 * result + (this.subscriptionType.hashCode());
                return result;
            }
        }
    }
    /**
     * The values that are available for a tag.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.budgets.*;
     * TagValuesProperty tagValuesProperty = TagValuesProperty.builder()
     *         .key("key")
     *         .matchOptions(List.of("matchOptions"))
     *         .values(List.of("values"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-tagvalues.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-tagvalues.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_budgets.CfnBudget.TagValuesProperty")
    @software.amazon.jsii.Jsii.Proxy(TagValuesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TagValuesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The key for the tag.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-tagvalues.html#cfn-budgets-budget-tagvalues-key">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-tagvalues.html#cfn-budgets-budget-tagvalues-key</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getKey() {
            return null;
        }

        /**
         * The match options that you can use to filter your results.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-tagvalues.html#cfn-budgets-budget-tagvalues-matchoptions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-tagvalues.html#cfn-budgets-budget-tagvalues-matchoptions</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getMatchOptions() {
            return null;
        }

        /**
         * The specific value of the tag.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-tagvalues.html#cfn-budgets-budget-tagvalues-values">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-tagvalues.html#cfn-budgets-budget-tagvalues-values</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getValues() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link TagValuesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TagValuesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TagValuesProperty> {
            java.lang.String key;
            java.util.List<java.lang.String> matchOptions;
            java.util.List<java.lang.String> values;

            /**
             * Sets the value of {@link TagValuesProperty#getKey}
             * @param key The key for the tag.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder key(java.lang.String key) {
                this.key = key;
                return this;
            }

            /**
             * Sets the value of {@link TagValuesProperty#getMatchOptions}
             * @param matchOptions The match options that you can use to filter your results.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder matchOptions(java.util.List<java.lang.String> matchOptions) {
                this.matchOptions = matchOptions;
                return this;
            }

            /**
             * Sets the value of {@link TagValuesProperty#getValues}
             * @param values The specific value of the tag.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder values(java.util.List<java.lang.String> values) {
                this.values = values;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TagValuesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TagValuesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TagValuesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TagValuesProperty {
            private final java.lang.String key;
            private final java.util.List<java.lang.String> matchOptions;
            private final java.util.List<java.lang.String> values;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.key = software.amazon.jsii.Kernel.get(this, "key", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.matchOptions = software.amazon.jsii.Kernel.get(this, "matchOptions", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.values = software.amazon.jsii.Kernel.get(this, "values", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.key = builder.key;
                this.matchOptions = builder.matchOptions;
                this.values = builder.values;
            }

            @Override
            public final java.lang.String getKey() {
                return this.key;
            }

            @Override
            public final java.util.List<java.lang.String> getMatchOptions() {
                return this.matchOptions;
            }

            @Override
            public final java.util.List<java.lang.String> getValues() {
                return this.values;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getKey() != null) {
                    data.set("key", om.valueToTree(this.getKey()));
                }
                if (this.getMatchOptions() != null) {
                    data.set("matchOptions", om.valueToTree(this.getMatchOptions()));
                }
                if (this.getValues() != null) {
                    data.set("values", om.valueToTree(this.getValues()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_budgets.CfnBudget.TagValuesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TagValuesProperty.Jsii$Proxy that = (TagValuesProperty.Jsii$Proxy) o;

                if (this.key != null ? !this.key.equals(that.key) : that.key != null) return false;
                if (this.matchOptions != null ? !this.matchOptions.equals(that.matchOptions) : that.matchOptions != null) return false;
                return this.values != null ? this.values.equals(that.values) : that.values == null;
            }

            @Override
            public final int hashCode() {
                int result = this.key != null ? this.key.hashCode() : 0;
                result = 31 * result + (this.matchOptions != null ? this.matchOptions.hashCode() : 0);
                result = 31 * result + (this.values != null ? this.values.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The period of time that is covered by a budget.
     * <p>
     * The period has a start date and an end date. The start date must come before the end date. There are no restrictions on the end date.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.budgets.*;
     * TimePeriodProperty timePeriodProperty = TimePeriodProperty.builder()
     *         .end("end")
     *         .start("start")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-timeperiod.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-timeperiod.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_budgets.CfnBudget.TimePeriodProperty")
    @software.amazon.jsii.Jsii.Proxy(TimePeriodProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TimePeriodProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The end date for a budget.
         * <p>
         * If you didn't specify an end date, AWS set your end date to <code>06/15/87 00:00 UTC</code> . The defaults are the same for the Billing and Cost Management console and the API.
         * <p>
         * After the end date, AWS deletes the budget and all the associated notifications and subscribers. You can change your end date with the <code>UpdateBudget</code> operation.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-timeperiod.html#cfn-budgets-budget-timeperiod-end">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-timeperiod.html#cfn-budgets-budget-timeperiod-end</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getEnd() {
            return null;
        }

        /**
         * The start date for a budget.
         * <p>
         * If you created your budget and didn't specify a start date, the start date defaults to the start of the chosen time period (MONTHLY, QUARTERLY, or ANNUALLY). For example, if you create your budget on January 24, 2019, choose <code>MONTHLY</code> , and don't set a start date, the start date defaults to <code>01/01/19 00:00 UTC</code> . The defaults are the same for the Billing and Cost Management console and the API.
         * <p>
         * You can change your start date with the <code>UpdateBudget</code> operation.
         * <p>
         * Valid values depend on the value of <code>BudgetType</code> :
         * <p>
         * <ul>
         * <li>If <code>BudgetType</code> is <code>COST</code> or <code>USAGE</code> : Valid values are <code>MONTHLY</code> , <code>QUARTERLY</code> , and <code>ANNUALLY</code> .</li>
         * <li>If <code>BudgetType</code> is <code>RI_UTILIZATION</code> or <code>RI_COVERAGE</code> : Valid values are <code>DAILY</code> , <code>MONTHLY</code> , <code>QUARTERLY</code> , and <code>ANNUALLY</code> .</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-timeperiod.html#cfn-budgets-budget-timeperiod-start">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-timeperiod.html#cfn-budgets-budget-timeperiod-start</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getStart() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link TimePeriodProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TimePeriodProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TimePeriodProperty> {
            java.lang.String end;
            java.lang.String start;

            /**
             * Sets the value of {@link TimePeriodProperty#getEnd}
             * @param end The end date for a budget.
             *            If you didn't specify an end date, AWS set your end date to <code>06/15/87 00:00 UTC</code> . The defaults are the same for the Billing and Cost Management console and the API.
             *            <p>
             *            After the end date, AWS deletes the budget and all the associated notifications and subscribers. You can change your end date with the <code>UpdateBudget</code> operation.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder end(java.lang.String end) {
                this.end = end;
                return this;
            }

            /**
             * Sets the value of {@link TimePeriodProperty#getStart}
             * @param start The start date for a budget.
             *              If you created your budget and didn't specify a start date, the start date defaults to the start of the chosen time period (MONTHLY, QUARTERLY, or ANNUALLY). For example, if you create your budget on January 24, 2019, choose <code>MONTHLY</code> , and don't set a start date, the start date defaults to <code>01/01/19 00:00 UTC</code> . The defaults are the same for the Billing and Cost Management console and the API.
             *              <p>
             *              You can change your start date with the <code>UpdateBudget</code> operation.
             *              <p>
             *              Valid values depend on the value of <code>BudgetType</code> :
             *              <p>
             *              <ul>
             *              <li>If <code>BudgetType</code> is <code>COST</code> or <code>USAGE</code> : Valid values are <code>MONTHLY</code> , <code>QUARTERLY</code> , and <code>ANNUALLY</code> .</li>
             *              <li>If <code>BudgetType</code> is <code>RI_UTILIZATION</code> or <code>RI_COVERAGE</code> : Valid values are <code>DAILY</code> , <code>MONTHLY</code> , <code>QUARTERLY</code> , and <code>ANNUALLY</code> .</li>
             *              </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder start(java.lang.String start) {
                this.start = start;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TimePeriodProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TimePeriodProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TimePeriodProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TimePeriodProperty {
            private final java.lang.String end;
            private final java.lang.String start;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.end = software.amazon.jsii.Kernel.get(this, "end", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.start = software.amazon.jsii.Kernel.get(this, "start", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.end = builder.end;
                this.start = builder.start;
            }

            @Override
            public final java.lang.String getEnd() {
                return this.end;
            }

            @Override
            public final java.lang.String getStart() {
                return this.start;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getEnd() != null) {
                    data.set("end", om.valueToTree(this.getEnd()));
                }
                if (this.getStart() != null) {
                    data.set("start", om.valueToTree(this.getStart()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_budgets.CfnBudget.TimePeriodProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TimePeriodProperty.Jsii$Proxy that = (TimePeriodProperty.Jsii$Proxy) o;

                if (this.end != null ? !this.end.equals(that.end) : that.end != null) return false;
                return this.start != null ? this.start.equals(that.start) : that.start == null;
            }

            @Override
            public final int hashCode() {
                int result = this.end != null ? this.end.hashCode() : 0;
                result = 31 * result + (this.start != null ? this.start.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.budgets.CfnBudget}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.budgets.CfnBudget> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.budgets.CfnBudgetProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.budgets.CfnBudgetProps.Builder();
        }

        /**
         * The budget object that you want to create.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-budgets-budget.html#cfn-budgets-budget-budget">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-budgets-budget.html#cfn-budgets-budget-budget</a>
         * @param budget The budget object that you want to create. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder budget(final software.amazon.awscdk.IResolvable budget) {
            this.props.budget(budget);
            return this;
        }
        /**
         * The budget object that you want to create.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-budgets-budget.html#cfn-budgets-budget-budget">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-budgets-budget.html#cfn-budgets-budget-budget</a>
         * @param budget The budget object that you want to create. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder budget(final software.amazon.awscdk.services.budgets.CfnBudget.BudgetDataProperty budget) {
            this.props.budget(budget);
            return this;
        }

        /**
         * A notification that you want to associate with a budget.
         * <p>
         * A budget can have up to five notifications, and each notification can have one SNS subscriber and up to 10 email subscribers. If you include notifications and subscribers in your <code>CreateBudget</code> call, AWS creates the notifications and subscribers for you.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-budgets-budget.html#cfn-budgets-budget-notificationswithsubscribers">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-budgets-budget.html#cfn-budgets-budget-notificationswithsubscribers</a>
         * @param notificationsWithSubscribers A notification that you want to associate with a budget. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder notificationsWithSubscribers(final software.amazon.awscdk.IResolvable notificationsWithSubscribers) {
            this.props.notificationsWithSubscribers(notificationsWithSubscribers);
            return this;
        }
        /**
         * A notification that you want to associate with a budget.
         * <p>
         * A budget can have up to five notifications, and each notification can have one SNS subscriber and up to 10 email subscribers. If you include notifications and subscribers in your <code>CreateBudget</code> call, AWS creates the notifications and subscribers for you.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-budgets-budget.html#cfn-budgets-budget-notificationswithsubscribers">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-budgets-budget.html#cfn-budgets-budget-notificationswithsubscribers</a>
         * @param notificationsWithSubscribers A notification that you want to associate with a budget. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder notificationsWithSubscribers(final java.util.List<? extends java.lang.Object> notificationsWithSubscribers) {
            this.props.notificationsWithSubscribers(notificationsWithSubscribers);
            return this;
        }

        /**
         * An optional list of tags to associate with the specified budget.
         * <p>
         * Each tag consists of a key and a value, and each key must be unique for the resource.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-budgets-budget.html#cfn-budgets-budget-resourcetags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-budgets-budget.html#cfn-budgets-budget-resourcetags</a>
         * @param resourceTags An optional list of tags to associate with the specified budget. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resourceTags(final software.amazon.awscdk.IResolvable resourceTags) {
            this.props.resourceTags(resourceTags);
            return this;
        }
        /**
         * An optional list of tags to associate with the specified budget.
         * <p>
         * Each tag consists of a key and a value, and each key must be unique for the resource.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-budgets-budget.html#cfn-budgets-budget-resourcetags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-budgets-budget.html#cfn-budgets-budget-resourcetags</a>
         * @param resourceTags An optional list of tags to associate with the specified budget. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resourceTags(final java.util.List<? extends java.lang.Object> resourceTags) {
            this.props.resourceTags(resourceTags);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.budgets.CfnBudget}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.budgets.CfnBudget build() {
            return new software.amazon.awscdk.services.budgets.CfnBudget(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
