package software.amazon.awscdk.services.certificatemanager;

/**
 * Properties to create a DNS validated certificate managed by AWS Certificate Manager.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.certificatemanager.*;
 * import software.amazon.awscdk.services.iam.*;
 * import software.amazon.awscdk.services.route53.*;
 * CertificateValidation certificateValidation;
 * HostedZone hostedZone;
 * KeyAlgorithm keyAlgorithm;
 * Role role;
 * DnsValidatedCertificateProps dnsValidatedCertificateProps = DnsValidatedCertificateProps.builder()
 *         .domainName("domainName")
 *         .hostedZone(hostedZone)
 *         // the properties below are optional
 *         .certificateName("certificateName")
 *         .cleanupRoute53Records(false)
 *         .customResourceRole(role)
 *         .keyAlgorithm(keyAlgorithm)
 *         .region("region")
 *         .route53Endpoint("route53Endpoint")
 *         .subjectAlternativeNames(List.of("subjectAlternativeNames"))
 *         .transparencyLoggingEnabled(false)
 *         .validation(certificateValidation)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-08-06T18:14:33.552Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_certificatemanager.DnsValidatedCertificateProps")
@software.amazon.jsii.Jsii.Proxy(DnsValidatedCertificateProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface DnsValidatedCertificateProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.certificatemanager.CertificateProps {

    /**
     * Route 53 Hosted Zone used to perform DNS validation of the request.
     * <p>
     * The zone
     * must be authoritative for the domain name specified in the Certificate Request.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.route53.IHostedZone getHostedZone();

    /**
     * When set to true, when the DnsValidatedCertificate is deleted, the associated Route53 validation records are removed.
     * <p>
     * CAUTION: If multiple certificates share the same domains (and same validation records),
     * this can cause the other certificates to fail renewal and/or not validate.
     * Not recommended for production use.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getCleanupRoute53Records() {
        return null;
    }

    /**
     * Role to use for the custom resource that creates the validated certificate.
     * <p>
     * Default: - A new role will be created
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.IRole getCustomResourceRole() {
        return null;
    }

    /**
     * AWS region that will host the certificate.
     * <p>
     * This is needed especially
     * for certificates used for CloudFront distributions, which require the region
     * to be us-east-1.
     * <p>
     * Default: the region the stack is deployed in.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getRegion() {
        return null;
    }

    /**
     * An endpoint of Route53 service, which is not necessary as AWS SDK could figure out the right endpoints for most regions, but for some regions such as those in aws-cn partition, the default endpoint is not working now, hence the right endpoint need to be specified through this prop.
     * <p>
     * Route53 is not been officially launched in China, it is only available for AWS
     * internal accounts now. To make DnsValidatedCertificate work for internal accounts
     * now, a special endpoint needs to be provided.
     * <p>
     * Default: - The AWS SDK will determine the Route53 endpoint to use based on region
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getRoute53Endpoint() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link DnsValidatedCertificateProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link DnsValidatedCertificateProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<DnsValidatedCertificateProps> {
        software.amazon.awscdk.services.route53.IHostedZone hostedZone;
        java.lang.Boolean cleanupRoute53Records;
        software.amazon.awscdk.services.iam.IRole customResourceRole;
        java.lang.String region;
        java.lang.String route53Endpoint;
        java.lang.String domainName;
        java.lang.String certificateName;
        software.amazon.awscdk.services.certificatemanager.KeyAlgorithm keyAlgorithm;
        java.util.List<java.lang.String> subjectAlternativeNames;
        java.lang.Boolean transparencyLoggingEnabled;
        software.amazon.awscdk.services.certificatemanager.CertificateValidation validation;

        /**
         * Sets the value of {@link DnsValidatedCertificateProps#getHostedZone}
         * @param hostedZone Route 53 Hosted Zone used to perform DNS validation of the request. This parameter is required.
         *                   The zone
         *                   must be authoritative for the domain name specified in the Certificate Request.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder hostedZone(software.amazon.awscdk.services.route53.IHostedZone hostedZone) {
            this.hostedZone = hostedZone;
            return this;
        }

        /**
         * Sets the value of {@link DnsValidatedCertificateProps#getCleanupRoute53Records}
         * @param cleanupRoute53Records When set to true, when the DnsValidatedCertificate is deleted, the associated Route53 validation records are removed.
         *                              CAUTION: If multiple certificates share the same domains (and same validation records),
         *                              this can cause the other certificates to fail renewal and/or not validate.
         *                              Not recommended for production use.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cleanupRoute53Records(java.lang.Boolean cleanupRoute53Records) {
            this.cleanupRoute53Records = cleanupRoute53Records;
            return this;
        }

        /**
         * Sets the value of {@link DnsValidatedCertificateProps#getCustomResourceRole}
         * @param customResourceRole Role to use for the custom resource that creates the validated certificate.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder customResourceRole(software.amazon.awscdk.services.iam.IRole customResourceRole) {
            this.customResourceRole = customResourceRole;
            return this;
        }

        /**
         * Sets the value of {@link DnsValidatedCertificateProps#getRegion}
         * @param region AWS region that will host the certificate.
         *               This is needed especially
         *               for certificates used for CloudFront distributions, which require the region
         *               to be us-east-1.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder region(java.lang.String region) {
            this.region = region;
            return this;
        }

        /**
         * Sets the value of {@link DnsValidatedCertificateProps#getRoute53Endpoint}
         * @param route53Endpoint An endpoint of Route53 service, which is not necessary as AWS SDK could figure out the right endpoints for most regions, but for some regions such as those in aws-cn partition, the default endpoint is not working now, hence the right endpoint need to be specified through this prop.
         *                        Route53 is not been officially launched in China, it is only available for AWS
         *                        internal accounts now. To make DnsValidatedCertificate work for internal accounts
         *                        now, a special endpoint needs to be provided.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder route53Endpoint(java.lang.String route53Endpoint) {
            this.route53Endpoint = route53Endpoint;
            return this;
        }

        /**
         * Sets the value of {@link DnsValidatedCertificateProps#getDomainName}
         * @param domainName Fully-qualified domain name to request a certificate for. This parameter is required.
         *                   May contain wildcards, such as <code>*.domain.com</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domainName(java.lang.String domainName) {
            this.domainName = domainName;
            return this;
        }

        /**
         * Sets the value of {@link DnsValidatedCertificateProps#getCertificateName}
         * @param certificateName The Certificate name.
         *                        Since the Certificate resource doesn't support providing a physical name, the value provided here will be recorded in the <code>Name</code> tag
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder certificateName(java.lang.String certificateName) {
            this.certificateName = certificateName;
            return this;
        }

        /**
         * Sets the value of {@link DnsValidatedCertificateProps#getKeyAlgorithm}
         * @param keyAlgorithm Specifies the algorithm of the public and private key pair that your certificate uses to encrypt data.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder keyAlgorithm(software.amazon.awscdk.services.certificatemanager.KeyAlgorithm keyAlgorithm) {
            this.keyAlgorithm = keyAlgorithm;
            return this;
        }

        /**
         * Sets the value of {@link DnsValidatedCertificateProps#getSubjectAlternativeNames}
         * @param subjectAlternativeNames Alternative domain names on your certificate.
         *                                Use this to register alternative domain names that represent the same site.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subjectAlternativeNames(java.util.List<java.lang.String> subjectAlternativeNames) {
            this.subjectAlternativeNames = subjectAlternativeNames;
            return this;
        }

        /**
         * Sets the value of {@link DnsValidatedCertificateProps#getTransparencyLoggingEnabled}
         * @param transparencyLoggingEnabled Enable or disable transparency logging for this certificate.
         *                                   Once a certificate has been logged, it cannot be removed from the log.
         *                                   Opting out at that point will have no effect. If you opt out of logging
         *                                   when you request a certificate and then choose later to opt back in,
         *                                   your certificate will not be logged until it is renewed.
         *                                   If you want the certificate to be logged immediately, we recommend that you issue a new one.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder transparencyLoggingEnabled(java.lang.Boolean transparencyLoggingEnabled) {
            this.transparencyLoggingEnabled = transparencyLoggingEnabled;
            return this;
        }

        /**
         * Sets the value of {@link DnsValidatedCertificateProps#getValidation}
         * @param validation How to validate this certificate.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder validation(software.amazon.awscdk.services.certificatemanager.CertificateValidation validation) {
            this.validation = validation;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link DnsValidatedCertificateProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public DnsValidatedCertificateProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link DnsValidatedCertificateProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DnsValidatedCertificateProps {
        private final software.amazon.awscdk.services.route53.IHostedZone hostedZone;
        private final java.lang.Boolean cleanupRoute53Records;
        private final software.amazon.awscdk.services.iam.IRole customResourceRole;
        private final java.lang.String region;
        private final java.lang.String route53Endpoint;
        private final java.lang.String domainName;
        private final java.lang.String certificateName;
        private final software.amazon.awscdk.services.certificatemanager.KeyAlgorithm keyAlgorithm;
        private final java.util.List<java.lang.String> subjectAlternativeNames;
        private final java.lang.Boolean transparencyLoggingEnabled;
        private final software.amazon.awscdk.services.certificatemanager.CertificateValidation validation;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.hostedZone = software.amazon.jsii.Kernel.get(this, "hostedZone", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.route53.IHostedZone.class));
            this.cleanupRoute53Records = software.amazon.jsii.Kernel.get(this, "cleanupRoute53Records", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.customResourceRole = software.amazon.jsii.Kernel.get(this, "customResourceRole", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
            this.region = software.amazon.jsii.Kernel.get(this, "region", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.route53Endpoint = software.amazon.jsii.Kernel.get(this, "route53Endpoint", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.domainName = software.amazon.jsii.Kernel.get(this, "domainName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.certificateName = software.amazon.jsii.Kernel.get(this, "certificateName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.keyAlgorithm = software.amazon.jsii.Kernel.get(this, "keyAlgorithm", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.certificatemanager.KeyAlgorithm.class));
            this.subjectAlternativeNames = software.amazon.jsii.Kernel.get(this, "subjectAlternativeNames", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.transparencyLoggingEnabled = software.amazon.jsii.Kernel.get(this, "transparencyLoggingEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.validation = software.amazon.jsii.Kernel.get(this, "validation", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.certificatemanager.CertificateValidation.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.hostedZone = java.util.Objects.requireNonNull(builder.hostedZone, "hostedZone is required");
            this.cleanupRoute53Records = builder.cleanupRoute53Records;
            this.customResourceRole = builder.customResourceRole;
            this.region = builder.region;
            this.route53Endpoint = builder.route53Endpoint;
            this.domainName = java.util.Objects.requireNonNull(builder.domainName, "domainName is required");
            this.certificateName = builder.certificateName;
            this.keyAlgorithm = builder.keyAlgorithm;
            this.subjectAlternativeNames = builder.subjectAlternativeNames;
            this.transparencyLoggingEnabled = builder.transparencyLoggingEnabled;
            this.validation = builder.validation;
        }

        @Override
        public final software.amazon.awscdk.services.route53.IHostedZone getHostedZone() {
            return this.hostedZone;
        }

        @Override
        public final java.lang.Boolean getCleanupRoute53Records() {
            return this.cleanupRoute53Records;
        }

        @Override
        public final software.amazon.awscdk.services.iam.IRole getCustomResourceRole() {
            return this.customResourceRole;
        }

        @Override
        public final java.lang.String getRegion() {
            return this.region;
        }

        @Override
        public final java.lang.String getRoute53Endpoint() {
            return this.route53Endpoint;
        }

        @Override
        public final java.lang.String getDomainName() {
            return this.domainName;
        }

        @Override
        public final java.lang.String getCertificateName() {
            return this.certificateName;
        }

        @Override
        public final software.amazon.awscdk.services.certificatemanager.KeyAlgorithm getKeyAlgorithm() {
            return this.keyAlgorithm;
        }

        @Override
        public final java.util.List<java.lang.String> getSubjectAlternativeNames() {
            return this.subjectAlternativeNames;
        }

        @Override
        public final java.lang.Boolean getTransparencyLoggingEnabled() {
            return this.transparencyLoggingEnabled;
        }

        @Override
        public final software.amazon.awscdk.services.certificatemanager.CertificateValidation getValidation() {
            return this.validation;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("hostedZone", om.valueToTree(this.getHostedZone()));
            if (this.getCleanupRoute53Records() != null) {
                data.set("cleanupRoute53Records", om.valueToTree(this.getCleanupRoute53Records()));
            }
            if (this.getCustomResourceRole() != null) {
                data.set("customResourceRole", om.valueToTree(this.getCustomResourceRole()));
            }
            if (this.getRegion() != null) {
                data.set("region", om.valueToTree(this.getRegion()));
            }
            if (this.getRoute53Endpoint() != null) {
                data.set("route53Endpoint", om.valueToTree(this.getRoute53Endpoint()));
            }
            data.set("domainName", om.valueToTree(this.getDomainName()));
            if (this.getCertificateName() != null) {
                data.set("certificateName", om.valueToTree(this.getCertificateName()));
            }
            if (this.getKeyAlgorithm() != null) {
                data.set("keyAlgorithm", om.valueToTree(this.getKeyAlgorithm()));
            }
            if (this.getSubjectAlternativeNames() != null) {
                data.set("subjectAlternativeNames", om.valueToTree(this.getSubjectAlternativeNames()));
            }
            if (this.getTransparencyLoggingEnabled() != null) {
                data.set("transparencyLoggingEnabled", om.valueToTree(this.getTransparencyLoggingEnabled()));
            }
            if (this.getValidation() != null) {
                data.set("validation", om.valueToTree(this.getValidation()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_certificatemanager.DnsValidatedCertificateProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            DnsValidatedCertificateProps.Jsii$Proxy that = (DnsValidatedCertificateProps.Jsii$Proxy) o;

            if (!hostedZone.equals(that.hostedZone)) return false;
            if (this.cleanupRoute53Records != null ? !this.cleanupRoute53Records.equals(that.cleanupRoute53Records) : that.cleanupRoute53Records != null) return false;
            if (this.customResourceRole != null ? !this.customResourceRole.equals(that.customResourceRole) : that.customResourceRole != null) return false;
            if (this.region != null ? !this.region.equals(that.region) : that.region != null) return false;
            if (this.route53Endpoint != null ? !this.route53Endpoint.equals(that.route53Endpoint) : that.route53Endpoint != null) return false;
            if (!domainName.equals(that.domainName)) return false;
            if (this.certificateName != null ? !this.certificateName.equals(that.certificateName) : that.certificateName != null) return false;
            if (this.keyAlgorithm != null ? !this.keyAlgorithm.equals(that.keyAlgorithm) : that.keyAlgorithm != null) return false;
            if (this.subjectAlternativeNames != null ? !this.subjectAlternativeNames.equals(that.subjectAlternativeNames) : that.subjectAlternativeNames != null) return false;
            if (this.transparencyLoggingEnabled != null ? !this.transparencyLoggingEnabled.equals(that.transparencyLoggingEnabled) : that.transparencyLoggingEnabled != null) return false;
            return this.validation != null ? this.validation.equals(that.validation) : that.validation == null;
        }

        @Override
        public final int hashCode() {
            int result = this.hostedZone.hashCode();
            result = 31 * result + (this.cleanupRoute53Records != null ? this.cleanupRoute53Records.hashCode() : 0);
            result = 31 * result + (this.customResourceRole != null ? this.customResourceRole.hashCode() : 0);
            result = 31 * result + (this.region != null ? this.region.hashCode() : 0);
            result = 31 * result + (this.route53Endpoint != null ? this.route53Endpoint.hashCode() : 0);
            result = 31 * result + (this.domainName.hashCode());
            result = 31 * result + (this.certificateName != null ? this.certificateName.hashCode() : 0);
            result = 31 * result + (this.keyAlgorithm != null ? this.keyAlgorithm.hashCode() : 0);
            result = 31 * result + (this.subjectAlternativeNames != null ? this.subjectAlternativeNames.hashCode() : 0);
            result = 31 * result + (this.transparencyLoggingEnabled != null ? this.transparencyLoggingEnabled.hashCode() : 0);
            result = 31 * result + (this.validation != null ? this.validation.hashCode() : 0);
            return result;
        }
    }
}
