package software.amazon.awscdk.services.cloudfront;

/**
 * The minimum version of the SSL protocol that you want CloudFront to use for HTTPS connections.
 * <p>
 * CloudFront serves your objects only to browsers or devices that support at least the SSL version that you specify.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Bucket s3BucketSource = new Bucket(this, "Bucket");
 * CloudFrontWebDistribution distribution = CloudFrontWebDistribution.Builder.create(this, "AnAmazingWebsiteProbably")
 *         .originConfigs(List.of(SourceConfiguration.builder()
 *                 .s3OriginSource(S3OriginConfig.builder().s3BucketSource(s3BucketSource).build())
 *                 .behaviors(List.of(Behavior.builder().isDefaultBehavior(true).build()))
 *                 .build()))
 *         .viewerCertificate(ViewerCertificate.fromIamCertificate("certificateId", ViewerCertificateOptions.builder()
 *                 .aliases(List.of("example.com"))
 *                 .securityPolicy(SecurityPolicyProtocol.SSL_V3) // default
 *                 .sslMethod(SSLMethod.SNI)
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-08-06T18:14:33.932Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudfront.SecurityPolicyProtocol")
public enum SecurityPolicyProtocol {
    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    SSL_V3,
    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    TLS_V1,
    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    TLS_V1_2016,
    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    TLS_V1_1_2016,
    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    TLS_V1_2_2018,
    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    TLS_V1_2_2019,
    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    TLS_V1_2_2021,
}
