package software.amazon.awscdk.services.cloudtrail;

/**
 * Creates a new event data store.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.cloudtrail.*;
 * CfnEventDataStore cfnEventDataStore = CfnEventDataStore.Builder.create(this, "MyCfnEventDataStore")
 *         .advancedEventSelectors(List.of(AdvancedEventSelectorProperty.builder()
 *                 .fieldSelectors(List.of(AdvancedFieldSelectorProperty.builder()
 *                         .field("field")
 *                         // the properties below are optional
 *                         .endsWith(List.of("endsWith"))
 *                         .equalTo(List.of("equalTo"))
 *                         .notEndsWith(List.of("notEndsWith"))
 *                         .notEquals(List.of("notEquals"))
 *                         .notStartsWith(List.of("notStartsWith"))
 *                         .startsWith(List.of("startsWith"))
 *                         .build()))
 *                 // the properties below are optional
 *                 .name("name")
 *                 .build()))
 *         .billingMode("billingMode")
 *         .contextKeySelectors(List.of(ContextKeySelectorProperty.builder()
 *                 .equalTo(List.of("equalTo"))
 *                 .type("type")
 *                 .build()))
 *         .federationEnabled(false)
 *         .federationRoleArn("federationRoleArn")
 *         .ingestionEnabled(false)
 *         .insightsDestination("insightsDestination")
 *         .insightSelectors(List.of(InsightSelectorProperty.builder()
 *                 .insightType("insightType")
 *                 .build()))
 *         .kmsKeyId("kmsKeyId")
 *         .maxEventSize("maxEventSize")
 *         .multiRegionEnabled(false)
 *         .name("name")
 *         .organizationEnabled(false)
 *         .retentionPeriod(123)
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .terminationProtectionEnabled(false)
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudtrail-eventdatastore.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudtrail-eventdatastore.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-08-06T18:14:34.000Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudtrail.CfnEventDataStore")
public class CfnEventDataStore extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.ITaggable {

    protected CfnEventDataStore(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnEventDataStore(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.cloudtrail.CfnEventDataStore.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnEventDataStore(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudtrail.CfnEventDataStoreProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnEventDataStore(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * <code>Ref</code> returns the time stamp of the creation of the event data store, such as <code>1248496624</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrCreatedTimestamp() {
        return software.amazon.jsii.Kernel.get(this, "attrCreatedTimestamp", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * <code>Ref</code> returns the ARN of the CloudTrail event data store, such as <code>arn:aws:cloudtrail:us-east-1:12345678910:eventdatastore/EXAMPLE-f852-4e8f-8bd1-bcf6cEXAMPLE</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrEventDataStoreArn() {
        return software.amazon.jsii.Kernel.get(this, "attrEventDataStoreArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * <code>Ref</code> returns the status of the event data store, such as <code>ENABLED</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrStatus() {
        return software.amazon.jsii.Kernel.get(this, "attrStatus", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * <code>Ref</code> returns the time stamp that updates were made to an event data store, such as <code>1598296624</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrUpdatedTimestamp() {
        return software.amazon.jsii.Kernel.get(this, "attrUpdatedTimestamp", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * The advanced event selectors to use to select the events for the data store.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getAdvancedEventSelectors() {
        return software.amazon.jsii.Kernel.get(this, "advancedEventSelectors", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The advanced event selectors to use to select the events for the data store.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAdvancedEventSelectors(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "advancedEventSelectors", value);
    }

    /**
     * The advanced event selectors to use to select the events for the data store.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAdvancedEventSelectors(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.cloudtrail.CfnEventDataStore.AdvancedEventSelectorProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.cloudtrail.CfnEventDataStore.AdvancedEventSelectorProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "advancedEventSelectors", value);
    }

    /**
     * The billing mode for the event data store determines the cost for ingesting events and the default and maximum retention period for the event data store.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getBillingMode() {
        return software.amazon.jsii.Kernel.get(this, "billingMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The billing mode for the event data store determines the cost for ingesting events and the default and maximum retention period for the event data store.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setBillingMode(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "billingMode", value);
    }

    /**
     * The list of context key selectors that are configured for the event data store.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getContextKeySelectors() {
        return software.amazon.jsii.Kernel.get(this, "contextKeySelectors", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The list of context key selectors that are configured for the event data store.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setContextKeySelectors(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "contextKeySelectors", value);
    }

    /**
     * The list of context key selectors that are configured for the event data store.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setContextKeySelectors(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.cloudtrail.CfnEventDataStore.ContextKeySelectorProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.cloudtrail.CfnEventDataStore.ContextKeySelectorProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "contextKeySelectors", value);
    }

    /**
     * Indicates if <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/query-federation.html">Lake query federation</a> is enabled. By default, Lake query federation is disabled. You cannot delete an event data store if Lake query federation is enabled.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getFederationEnabled() {
        return software.amazon.jsii.Kernel.get(this, "federationEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Indicates if <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/query-federation.html">Lake query federation</a> is enabled. By default, Lake query federation is disabled. You cannot delete an event data store if Lake query federation is enabled.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setFederationEnabled(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "federationEnabled", value);
    }

    /**
     * Indicates if <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/query-federation.html">Lake query federation</a> is enabled. By default, Lake query federation is disabled. You cannot delete an event data store if Lake query federation is enabled.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setFederationEnabled(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "federationEnabled", value);
    }

    /**
     * If Lake query federation is enabled, provides the ARN of the federation role used to access the resources for the federated event data store.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getFederationRoleArn() {
        return software.amazon.jsii.Kernel.get(this, "federationRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * If Lake query federation is enabled, provides the ARN of the federation role used to access the resources for the federated event data store.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setFederationRoleArn(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "federationRoleArn", value);
    }

    /**
     * Specifies whether the event data store should start ingesting live events.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getIngestionEnabled() {
        return software.amazon.jsii.Kernel.get(this, "ingestionEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Specifies whether the event data store should start ingesting live events.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setIngestionEnabled(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "ingestionEnabled", value);
    }

    /**
     * Specifies whether the event data store should start ingesting live events.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setIngestionEnabled(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "ingestionEnabled", value);
    }

    /**
     * The ARN (or ID suffix of the ARN) of the destination event data store that logs Insights events.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getInsightsDestination() {
        return software.amazon.jsii.Kernel.get(this, "insightsDestination", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ARN (or ID suffix of the ARN) of the destination event data store that logs Insights events.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setInsightsDestination(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "insightsDestination", value);
    }

    /**
     * A JSON string that contains the Insights types you want to log on an event data store.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getInsightSelectors() {
        return software.amazon.jsii.Kernel.get(this, "insightSelectors", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A JSON string that contains the Insights types you want to log on an event data store.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setInsightSelectors(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "insightSelectors", value);
    }

    /**
     * A JSON string that contains the Insights types you want to log on an event data store.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setInsightSelectors(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.cloudtrail.CfnEventDataStore.InsightSelectorProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.cloudtrail.CfnEventDataStore.InsightSelectorProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "insightSelectors", value);
    }

    /**
     * Specifies the AWS KMS key ID to use to encrypt the events delivered by CloudTrail.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getKmsKeyId() {
        return software.amazon.jsii.Kernel.get(this, "kmsKeyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Specifies the AWS KMS key ID to use to encrypt the events delivered by CloudTrail.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setKmsKeyId(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "kmsKeyId", value);
    }

    /**
     * The maximum allowed size for events to be stored in the specified event data store.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getMaxEventSize() {
        return software.amazon.jsii.Kernel.get(this, "maxEventSize", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The maximum allowed size for events to be stored in the specified event data store.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMaxEventSize(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "maxEventSize", value);
    }

    /**
     * Specifies whether the event data store includes events from all Regions, or only from the Region in which the event data store is created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getMultiRegionEnabled() {
        return software.amazon.jsii.Kernel.get(this, "multiRegionEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Specifies whether the event data store includes events from all Regions, or only from the Region in which the event data store is created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMultiRegionEnabled(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "multiRegionEnabled", value);
    }

    /**
     * Specifies whether the event data store includes events from all Regions, or only from the Region in which the event data store is created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMultiRegionEnabled(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "multiRegionEnabled", value);
    }

    /**
     * The name of the event data store.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the event data store.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "name", value);
    }

    /**
     * Specifies whether an event data store collects events logged for an organization in AWS Organizations .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getOrganizationEnabled() {
        return software.amazon.jsii.Kernel.get(this, "organizationEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Specifies whether an event data store collects events logged for an organization in AWS Organizations .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setOrganizationEnabled(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "organizationEnabled", value);
    }

    /**
     * Specifies whether an event data store collects events logged for an organization in AWS Organizations .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setOrganizationEnabled(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "organizationEnabled", value);
    }

    /**
     * The retention period of the event data store, in days.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getRetentionPeriod() {
        return software.amazon.jsii.Kernel.get(this, "retentionPeriod", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The retention period of the event data store, in days.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRetentionPeriod(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "retentionPeriod", value);
    }

    /**
     * A list of tags.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTagsRaw() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tagsRaw", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * A list of tags.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTagsRaw(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tagsRaw", value);
    }

    /**
     * Specifies whether termination protection is enabled for the event data store.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getTerminationProtectionEnabled() {
        return software.amazon.jsii.Kernel.get(this, "terminationProtectionEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Specifies whether termination protection is enabled for the event data store.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTerminationProtectionEnabled(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "terminationProtectionEnabled", value);
    }

    /**
     * Specifies whether termination protection is enabled for the event data store.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTerminationProtectionEnabled(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "terminationProtectionEnabled", value);
    }
    /**
     * Advanced event selectors let you create fine-grained selectors for AWS CloudTrail management, data, and network activity events.
     * <p>
     * They help you control costs by logging only those events that are important to you. For more information about configuring advanced event selectors, see the <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-data-events-with-cloudtrail.html">Logging data events</a> , <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-network-events-with-cloudtrail.html">Logging network activity events</a> , and <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-management-events-with-cloudtrail.html">Logging management events</a> topics in the <em>AWS CloudTrail User Guide</em> .
     * <p>
     * You cannot apply both event selectors and advanced event selectors to a trail.
     * <p>
     * <em>Supported CloudTrail event record fields for management events</em>
     * <p>
     * <ul>
     * <li><code>eventCategory</code> (required)</li>
     * <li><code>eventSource</code></li>
     * <li><code>readOnly</code></li>
     * </ul>
     * <p>
     * The following additional fields are available for event data stores:
     * <p>
     * <ul>
     * <li><code>eventName</code></li>
     * <li><code>eventType</code></li>
     * <li><code>sessionCredentialFromConsole</code></li>
     * <li><code>userIdentity.arn</code></li>
     * </ul>
     * <p>
     * <em>Supported CloudTrail event record fields for data events</em>
     * <p>
     * <ul>
     * <li><code>eventCategory</code> (required)</li>
     * <li><code>eventName</code></li>
     * <li><code>eventSource</code></li>
     * <li><code>eventType</code></li>
     * <li><code>resources.ARN</code></li>
     * <li><code>resources.type</code> (required)</li>
     * <li><code>readOnly</code></li>
     * <li><code>sessionCredentialFromConsole</code></li>
     * <li><code>userIdentity.arn</code></li>
     * </ul>
     * <p>
     * <em>Supported CloudTrail event record fields for network activity events</em>
     * <p>
     * <ul>
     * <li><code>eventCategory</code> (required)</li>
     * <li><code>eventSource</code> (required)</li>
     * <li><code>eventName</code></li>
     * <li><code>errorCode</code> - The only valid value for <code>errorCode</code> is <code>VpceAccessDenied</code> .</li>
     * <li><code>vpcEndpointId</code></li>
     * </ul>
     * <p>
     * <blockquote>
     * <p>
     * For event data stores for CloudTrail Insights events, AWS Config configuration items, Audit Manager evidence, or events outside of AWS , the only supported field is <code>eventCategory</code> .
     * <p>
     * </blockquote>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.cloudtrail.*;
     * AdvancedEventSelectorProperty advancedEventSelectorProperty = AdvancedEventSelectorProperty.builder()
     *         .fieldSelectors(List.of(AdvancedFieldSelectorProperty.builder()
     *                 .field("field")
     *                 // the properties below are optional
     *                 .endsWith(List.of("endsWith"))
     *                 .equalTo(List.of("equalTo"))
     *                 .notEndsWith(List.of("notEndsWith"))
     *                 .notEquals(List.of("notEquals"))
     *                 .notStartsWith(List.of("notStartsWith"))
     *                 .startsWith(List.of("startsWith"))
     *                 .build()))
     *         // the properties below are optional
     *         .name("name")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudtrail-eventdatastore-advancedeventselector.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudtrail-eventdatastore-advancedeventselector.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudtrail.CfnEventDataStore.AdvancedEventSelectorProperty")
    @software.amazon.jsii.Jsii.Proxy(AdvancedEventSelectorProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AdvancedEventSelectorProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Contains all selector statements in an advanced event selector.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudtrail-eventdatastore-advancedeventselector.html#cfn-cloudtrail-eventdatastore-advancedeventselector-fieldselectors">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudtrail-eventdatastore-advancedeventselector.html#cfn-cloudtrail-eventdatastore-advancedeventselector-fieldselectors</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getFieldSelectors();

        /**
         * An optional, descriptive name for an advanced event selector, such as "Log data events for only two S3 buckets".
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudtrail-eventdatastore-advancedeventselector.html#cfn-cloudtrail-eventdatastore-advancedeventselector-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudtrail-eventdatastore-advancedeventselector.html#cfn-cloudtrail-eventdatastore-advancedeventselector-name</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getName() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AdvancedEventSelectorProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AdvancedEventSelectorProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AdvancedEventSelectorProperty> {
            java.lang.Object fieldSelectors;
            java.lang.String name;

            /**
             * Sets the value of {@link AdvancedEventSelectorProperty#getFieldSelectors}
             * @param fieldSelectors Contains all selector statements in an advanced event selector. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fieldSelectors(software.amazon.awscdk.IResolvable fieldSelectors) {
                this.fieldSelectors = fieldSelectors;
                return this;
            }

            /**
             * Sets the value of {@link AdvancedEventSelectorProperty#getFieldSelectors}
             * @param fieldSelectors Contains all selector statements in an advanced event selector. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fieldSelectors(java.util.List<? extends java.lang.Object> fieldSelectors) {
                this.fieldSelectors = fieldSelectors;
                return this;
            }

            /**
             * Sets the value of {@link AdvancedEventSelectorProperty#getName}
             * @param name An optional, descriptive name for an advanced event selector, such as "Log data events for only two S3 buckets".
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AdvancedEventSelectorProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AdvancedEventSelectorProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AdvancedEventSelectorProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AdvancedEventSelectorProperty {
            private final java.lang.Object fieldSelectors;
            private final java.lang.String name;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.fieldSelectors = software.amazon.jsii.Kernel.get(this, "fieldSelectors", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.fieldSelectors = java.util.Objects.requireNonNull(builder.fieldSelectors, "fieldSelectors is required");
                this.name = builder.name;
            }

            @Override
            public final java.lang.Object getFieldSelectors() {
                return this.fieldSelectors;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("fieldSelectors", om.valueToTree(this.getFieldSelectors()));
                if (this.getName() != null) {
                    data.set("name", om.valueToTree(this.getName()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cloudtrail.CfnEventDataStore.AdvancedEventSelectorProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AdvancedEventSelectorProperty.Jsii$Proxy that = (AdvancedEventSelectorProperty.Jsii$Proxy) o;

                if (!fieldSelectors.equals(that.fieldSelectors)) return false;
                return this.name != null ? this.name.equals(that.name) : that.name == null;
            }

            @Override
            public final int hashCode() {
                int result = this.fieldSelectors.hashCode();
                result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A single selector statement in an advanced event selector.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.cloudtrail.*;
     * AdvancedFieldSelectorProperty advancedFieldSelectorProperty = AdvancedFieldSelectorProperty.builder()
     *         .field("field")
     *         // the properties below are optional
     *         .endsWith(List.of("endsWith"))
     *         .equalTo(List.of("equalTo"))
     *         .notEndsWith(List.of("notEndsWith"))
     *         .notEquals(List.of("notEquals"))
     *         .notStartsWith(List.of("notStartsWith"))
     *         .startsWith(List.of("startsWith"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudtrail-eventdatastore-advancedfieldselector.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudtrail-eventdatastore-advancedfieldselector.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudtrail.CfnEventDataStore.AdvancedFieldSelectorProperty")
    @software.amazon.jsii.Jsii.Proxy(AdvancedFieldSelectorProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AdvancedFieldSelectorProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A field in a CloudTrail event record on which to filter events to be logged.
         * <p>
         * For event data stores for CloudTrail Insights events, AWS Config configuration items, Audit Manager evidence, or events outside of AWS , the field is used only for selecting events as filtering is not supported.
         * <p>
         * For CloudTrail management events, supported fields include <code>eventCategory</code> (required), <code>eventSource</code> , and <code>readOnly</code> . The following additional fields are available for event data stores: <code>eventName</code> , <code>eventType</code> , <code>sessionCredentialFromConsole</code> , and <code>userIdentity.arn</code> .
         * <p>
         * For CloudTrail data events, supported fields include <code>eventCategory</code> (required), <code>eventName</code> , <code>eventSource</code> , <code>eventType</code> , <code>resources.type</code> (required), <code>readOnly</code> , <code>resources.ARN</code> , <code>sessionCredentialFromConsole</code> , and <code>userIdentity.arn</code> .
         * <p>
         * For CloudTrail network activity events, supported fields include <code>eventCategory</code> (required), <code>eventSource</code> (required), <code>eventName</code> , <code>errorCode</code> , and <code>vpcEndpointId</code> .
         * <p>
         * For event data stores for CloudTrail Insights events, AWS Config configuration items, Audit Manager evidence, or events outside of AWS , the only supported field is <code>eventCategory</code> .
         * <p>
         * <blockquote>
         * <p>
         * Selectors don't support the use of wildcards like <code>*</code> . To match multiple values with a single condition, you may use <code>StartsWith</code> , <code>EndsWith</code> , <code>NotStartsWith</code> , or <code>NotEndsWith</code> to explicitly match the beginning or end of the event field.
         * <p>
         * </blockquote>
         * <p>
         * <ul>
         * <li><em><code>readOnly</code></em> - This is an optional field that is only used for management events and data events. This field can be set to <code>Equals</code> with a value of <code>true</code> or <code>false</code> . If you do not add this field, CloudTrail logs both <code>read</code> and <code>write</code> events. A value of <code>true</code> logs only <code>read</code> events. A value of <code>false</code> logs only <code>write</code> events.</li>
         * <li><em><code>eventSource</code></em> - This field is only used for management events, data events, and network activity events.</li>
         * </ul>
         * <p>
         * For management events for trails, this is an optional field that can be set to <code>NotEquals</code> <code>kms.amazonaws.com</code> to exclude KMS management events, or <code>NotEquals</code> <code>rdsdata.amazonaws.com</code> to exclude RDS management events.
         * <p>
         * For data events for trails, this is an optional field that you can use to include or exclude any event source and can use any operator.
         * <p>
         * For management and data events for event data stores, this is an optional field that you can use to include or exclude any event source and can use any operator.
         * <p>
         * For network activity events, this is a required field that only uses the <code>Equals</code> operator. Set this field to the event source for which you want to log network activity events. If you want to log network activity events for multiple event sources, you must create a separate field selector for each event source. For a list of services supporting network activity events, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-network-events-with-cloudtrail.html">Logging network activity events</a> in the <em>AWS CloudTrail User Guide</em> .
         * <p>
         * <ul>
         * <li><em><code>eventName</code></em> - This is an optional field that is only used for data events, management events (for event data stores only), and network activity events. You can use any operator with <code>eventName</code> . You can use it to ﬁlter in or ﬁlter out specific events. You can have multiple values for this ﬁeld, separated by commas.</li>
         * <li><em><code>eventCategory</code></em> - This field is required and must be set to <code>Equals</code> .</li>
         * <li>For CloudTrail management events, the value must be <code>Management</code> .</li>
         * <li>For CloudTrail data events, the value must be <code>Data</code> .</li>
         * <li>For CloudTrail network activity events, the value must be <code>NetworkActivity</code> .</li>
         * </ul>
         * <p>
         * The following are used only for event data stores:
         * <p>
         * <ul>
         * <li>For CloudTrail Insights events, the value must be <code>Insight</code> .</li>
         * <li>For AWS Config configuration items, the value must be <code>ConfigurationItem</code> .</li>
         * <li>For Audit Manager evidence, the value must be <code>Evidence</code> .</li>
         * <li>For events outside of AWS , the value must be <code>ActivityAuditLog</code> .</li>
         * <li><em><code>eventType</code></em> - For event data stores, this is an optional field available for event data stores to filter management and data events on the event type. For trails, this is an optional field to filter data events on the event type. For information about available event types, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-event-reference-record-contents.html#ct-event-type">CloudTrail record contents</a> in the <em>AWS CloudTrail user guide</em> .</li>
         * <li><em><code>errorCode</code></em> - This ﬁeld is only used to filter CloudTrail network activity events and is optional. This is the error code to filter on. Currently, the only valid <code>errorCode</code> is <code>VpceAccessDenied</code> . <code>errorCode</code> can only use the <code>Equals</code> operator.</li>
         * <li><em><code>sessionCredentialFromConsole</code></em> - For event data stores, this is an optional field used to filter management and data events based on whether the events originated from an AWS Management Console session. For trails, this is an optional field used to filter data events. <code>sessionCredentialFromConsole</code> can only use the <code>Equals</code> and <code>NotEquals</code> operators.</li>
         * <li><em><code>resources.type</code></em> - This ﬁeld is required for CloudTrail data events. <code>resources.type</code> can only use the <code>Equals</code> operator.</li>
         * </ul>
         * <p>
         * For a list of available resource types for data events, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-data-events-with-cloudtrail.html#logging-data-events">Data events</a> in the <em>AWS CloudTrail User Guide</em> .
         * <p>
         * You can have only one <code>resources.type</code> ﬁeld per selector. To log events on more than one resource type, add another selector.
         * <p>
         * <ul>
         * <li><em><code>resources.ARN</code></em> - The <code>resources.ARN</code> is an optional field for data events. You can use any operator with <code>resources.ARN</code> , but if you use <code>Equals</code> or <code>NotEquals</code> , the value must exactly match the ARN of a valid resource of the type you've speciﬁed in the template as the value of resources.type. To log all data events for all objects in a specific S3 bucket, use the <code>StartsWith</code> operator, and include only the bucket ARN as the matching value.</li>
         * </ul>
         * <p>
         * For more information about the ARN formats of data event resources, see <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/reference_policies_actions-resources-contextkeys.html">Actions, resources, and condition keys for AWS services</a> in the <em>Service Authorization Reference</em> .
         * <p>
         * <blockquote>
         * <p>
         * You can't use the <code>resources.ARN</code> field to filter resource types that do not have ARNs.
         * <p>
         * </blockquote>
         * <p>
         * <ul>
         * <li><em><code>userIdentity.arn</code></em> - For event data stores, this is an optional field used to filter management and data events for actions taken by specific IAM identities. For trails, this is an optional field used to filter data events. You can use any operator with <code>userIdentity.arn</code> . For more information on the userIdentity element, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-event-reference-user-identity.html">CloudTrail userIdentity element</a> in the <em>AWS CloudTrail User Guide</em> .</li>
         * <li><em><code>vpcEndpointId</code></em> - This ﬁeld is only used to filter CloudTrail network activity events and is optional. This field identifies the VPC endpoint that the request passed through. You can use any operator with <code>vpcEndpointId</code> .</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudtrail-eventdatastore-advancedfieldselector.html#cfn-cloudtrail-eventdatastore-advancedfieldselector-field">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudtrail-eventdatastore-advancedfieldselector.html#cfn-cloudtrail-eventdatastore-advancedfieldselector-field</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getField();

        /**
         * An operator that includes events that match the last few characters of the event record field specified as the value of <code>Field</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudtrail-eventdatastore-advancedfieldselector.html#cfn-cloudtrail-eventdatastore-advancedfieldselector-endswith">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudtrail-eventdatastore-advancedfieldselector.html#cfn-cloudtrail-eventdatastore-advancedfieldselector-endswith</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getEndsWith() {
            return null;
        }

        /**
         * An operator that includes events that match the exact value of the event record field specified as the value of <code>Field</code> .
         * <p>
         * This is the only valid operator that you can use with the <code>readOnly</code> , <code>eventCategory</code> , and <code>resources.type</code> fields.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudtrail-eventdatastore-advancedfieldselector.html#cfn-cloudtrail-eventdatastore-advancedfieldselector-equals">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudtrail-eventdatastore-advancedfieldselector.html#cfn-cloudtrail-eventdatastore-advancedfieldselector-equals</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getEqualTo() {
            return null;
        }

        /**
         * An operator that excludes events that match the last few characters of the event record field specified as the value of <code>Field</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudtrail-eventdatastore-advancedfieldselector.html#cfn-cloudtrail-eventdatastore-advancedfieldselector-notendswith">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudtrail-eventdatastore-advancedfieldselector.html#cfn-cloudtrail-eventdatastore-advancedfieldselector-notendswith</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getNotEndsWith() {
            return null;
        }

        /**
         * An operator that excludes events that match the exact value of the event record field specified as the value of <code>Field</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudtrail-eventdatastore-advancedfieldselector.html#cfn-cloudtrail-eventdatastore-advancedfieldselector-notequals">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudtrail-eventdatastore-advancedfieldselector.html#cfn-cloudtrail-eventdatastore-advancedfieldselector-notequals</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getNotEquals() {
            return null;
        }

        /**
         * An operator that excludes events that match the first few characters of the event record field specified as the value of <code>Field</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudtrail-eventdatastore-advancedfieldselector.html#cfn-cloudtrail-eventdatastore-advancedfieldselector-notstartswith">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudtrail-eventdatastore-advancedfieldselector.html#cfn-cloudtrail-eventdatastore-advancedfieldselector-notstartswith</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getNotStartsWith() {
            return null;
        }

        /**
         * An operator that includes events that match the first few characters of the event record field specified as the value of <code>Field</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudtrail-eventdatastore-advancedfieldselector.html#cfn-cloudtrail-eventdatastore-advancedfieldselector-startswith">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudtrail-eventdatastore-advancedfieldselector.html#cfn-cloudtrail-eventdatastore-advancedfieldselector-startswith</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getStartsWith() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AdvancedFieldSelectorProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AdvancedFieldSelectorProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AdvancedFieldSelectorProperty> {
            java.lang.String field;
            java.util.List<java.lang.String> endsWith;
            java.util.List<java.lang.String> equalTo;
            java.util.List<java.lang.String> notEndsWith;
            java.util.List<java.lang.String> notEquals;
            java.util.List<java.lang.String> notStartsWith;
            java.util.List<java.lang.String> startsWith;

            /**
             * Sets the value of {@link AdvancedFieldSelectorProperty#getField}
             * @param field A field in a CloudTrail event record on which to filter events to be logged. This parameter is required.
             *              For event data stores for CloudTrail Insights events, AWS Config configuration items, Audit Manager evidence, or events outside of AWS , the field is used only for selecting events as filtering is not supported.
             *              <p>
             *              For CloudTrail management events, supported fields include <code>eventCategory</code> (required), <code>eventSource</code> , and <code>readOnly</code> . The following additional fields are available for event data stores: <code>eventName</code> , <code>eventType</code> , <code>sessionCredentialFromConsole</code> , and <code>userIdentity.arn</code> .
             *              <p>
             *              For CloudTrail data events, supported fields include <code>eventCategory</code> (required), <code>eventName</code> , <code>eventSource</code> , <code>eventType</code> , <code>resources.type</code> (required), <code>readOnly</code> , <code>resources.ARN</code> , <code>sessionCredentialFromConsole</code> , and <code>userIdentity.arn</code> .
             *              <p>
             *              For CloudTrail network activity events, supported fields include <code>eventCategory</code> (required), <code>eventSource</code> (required), <code>eventName</code> , <code>errorCode</code> , and <code>vpcEndpointId</code> .
             *              <p>
             *              For event data stores for CloudTrail Insights events, AWS Config configuration items, Audit Manager evidence, or events outside of AWS , the only supported field is <code>eventCategory</code> .
             *              <p>
             *              <blockquote>
             *              <p>
             *              Selectors don't support the use of wildcards like <code>*</code> . To match multiple values with a single condition, you may use <code>StartsWith</code> , <code>EndsWith</code> , <code>NotStartsWith</code> , or <code>NotEndsWith</code> to explicitly match the beginning or end of the event field.
             *              <p>
             *              </blockquote>
             *              <p>
             *              <ul>
             *              <li><em><code>readOnly</code></em> - This is an optional field that is only used for management events and data events. This field can be set to <code>Equals</code> with a value of <code>true</code> or <code>false</code> . If you do not add this field, CloudTrail logs both <code>read</code> and <code>write</code> events. A value of <code>true</code> logs only <code>read</code> events. A value of <code>false</code> logs only <code>write</code> events.</li>
             *              <li><em><code>eventSource</code></em> - This field is only used for management events, data events, and network activity events.</li>
             *              </ul>
             *              <p>
             *              For management events for trails, this is an optional field that can be set to <code>NotEquals</code> <code>kms.amazonaws.com</code> to exclude KMS management events, or <code>NotEquals</code> <code>rdsdata.amazonaws.com</code> to exclude RDS management events.
             *              <p>
             *              For data events for trails, this is an optional field that you can use to include or exclude any event source and can use any operator.
             *              <p>
             *              For management and data events for event data stores, this is an optional field that you can use to include or exclude any event source and can use any operator.
             *              <p>
             *              For network activity events, this is a required field that only uses the <code>Equals</code> operator. Set this field to the event source for which you want to log network activity events. If you want to log network activity events for multiple event sources, you must create a separate field selector for each event source. For a list of services supporting network activity events, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-network-events-with-cloudtrail.html">Logging network activity events</a> in the <em>AWS CloudTrail User Guide</em> .
             *              <p>
             *              <ul>
             *              <li><em><code>eventName</code></em> - This is an optional field that is only used for data events, management events (for event data stores only), and network activity events. You can use any operator with <code>eventName</code> . You can use it to ﬁlter in or ﬁlter out specific events. You can have multiple values for this ﬁeld, separated by commas.</li>
             *              <li><em><code>eventCategory</code></em> - This field is required and must be set to <code>Equals</code> .</li>
             *              <li>For CloudTrail management events, the value must be <code>Management</code> .</li>
             *              <li>For CloudTrail data events, the value must be <code>Data</code> .</li>
             *              <li>For CloudTrail network activity events, the value must be <code>NetworkActivity</code> .</li>
             *              </ul>
             *              <p>
             *              The following are used only for event data stores:
             *              <p>
             *              <ul>
             *              <li>For CloudTrail Insights events, the value must be <code>Insight</code> .</li>
             *              <li>For AWS Config configuration items, the value must be <code>ConfigurationItem</code> .</li>
             *              <li>For Audit Manager evidence, the value must be <code>Evidence</code> .</li>
             *              <li>For events outside of AWS , the value must be <code>ActivityAuditLog</code> .</li>
             *              <li><em><code>eventType</code></em> - For event data stores, this is an optional field available for event data stores to filter management and data events on the event type. For trails, this is an optional field to filter data events on the event type. For information about available event types, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-event-reference-record-contents.html#ct-event-type">CloudTrail record contents</a> in the <em>AWS CloudTrail user guide</em> .</li>
             *              <li><em><code>errorCode</code></em> - This ﬁeld is only used to filter CloudTrail network activity events and is optional. This is the error code to filter on. Currently, the only valid <code>errorCode</code> is <code>VpceAccessDenied</code> . <code>errorCode</code> can only use the <code>Equals</code> operator.</li>
             *              <li><em><code>sessionCredentialFromConsole</code></em> - For event data stores, this is an optional field used to filter management and data events based on whether the events originated from an AWS Management Console session. For trails, this is an optional field used to filter data events. <code>sessionCredentialFromConsole</code> can only use the <code>Equals</code> and <code>NotEquals</code> operators.</li>
             *              <li><em><code>resources.type</code></em> - This ﬁeld is required for CloudTrail data events. <code>resources.type</code> can only use the <code>Equals</code> operator.</li>
             *              </ul>
             *              <p>
             *              For a list of available resource types for data events, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-data-events-with-cloudtrail.html#logging-data-events">Data events</a> in the <em>AWS CloudTrail User Guide</em> .
             *              <p>
             *              You can have only one <code>resources.type</code> ﬁeld per selector. To log events on more than one resource type, add another selector.
             *              <p>
             *              <ul>
             *              <li><em><code>resources.ARN</code></em> - The <code>resources.ARN</code> is an optional field for data events. You can use any operator with <code>resources.ARN</code> , but if you use <code>Equals</code> or <code>NotEquals</code> , the value must exactly match the ARN of a valid resource of the type you've speciﬁed in the template as the value of resources.type. To log all data events for all objects in a specific S3 bucket, use the <code>StartsWith</code> operator, and include only the bucket ARN as the matching value.</li>
             *              </ul>
             *              <p>
             *              For more information about the ARN formats of data event resources, see <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/reference_policies_actions-resources-contextkeys.html">Actions, resources, and condition keys for AWS services</a> in the <em>Service Authorization Reference</em> .
             *              <p>
             *              <blockquote>
             *              <p>
             *              You can't use the <code>resources.ARN</code> field to filter resource types that do not have ARNs.
             *              <p>
             *              </blockquote>
             *              <p>
             *              <ul>
             *              <li><em><code>userIdentity.arn</code></em> - For event data stores, this is an optional field used to filter management and data events for actions taken by specific IAM identities. For trails, this is an optional field used to filter data events. You can use any operator with <code>userIdentity.arn</code> . For more information on the userIdentity element, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-event-reference-user-identity.html">CloudTrail userIdentity element</a> in the <em>AWS CloudTrail User Guide</em> .</li>
             *              <li><em><code>vpcEndpointId</code></em> - This ﬁeld is only used to filter CloudTrail network activity events and is optional. This field identifies the VPC endpoint that the request passed through. You can use any operator with <code>vpcEndpointId</code> .</li>
             *              </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder field(java.lang.String field) {
                this.field = field;
                return this;
            }

            /**
             * Sets the value of {@link AdvancedFieldSelectorProperty#getEndsWith}
             * @param endsWith An operator that includes events that match the last few characters of the event record field specified as the value of <code>Field</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder endsWith(java.util.List<java.lang.String> endsWith) {
                this.endsWith = endsWith;
                return this;
            }

            /**
             * Sets the value of {@link AdvancedFieldSelectorProperty#getEqualTo}
             * @param equalTo An operator that includes events that match the exact value of the event record field specified as the value of <code>Field</code> .
             *                This is the only valid operator that you can use with the <code>readOnly</code> , <code>eventCategory</code> , and <code>resources.type</code> fields.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder equalTo(java.util.List<java.lang.String> equalTo) {
                this.equalTo = equalTo;
                return this;
            }

            /**
             * Sets the value of {@link AdvancedFieldSelectorProperty#getNotEndsWith}
             * @param notEndsWith An operator that excludes events that match the last few characters of the event record field specified as the value of <code>Field</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder notEndsWith(java.util.List<java.lang.String> notEndsWith) {
                this.notEndsWith = notEndsWith;
                return this;
            }

            /**
             * Sets the value of {@link AdvancedFieldSelectorProperty#getNotEquals}
             * @param notEquals An operator that excludes events that match the exact value of the event record field specified as the value of <code>Field</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder notEquals(java.util.List<java.lang.String> notEquals) {
                this.notEquals = notEquals;
                return this;
            }

            /**
             * Sets the value of {@link AdvancedFieldSelectorProperty#getNotStartsWith}
             * @param notStartsWith An operator that excludes events that match the first few characters of the event record field specified as the value of <code>Field</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder notStartsWith(java.util.List<java.lang.String> notStartsWith) {
                this.notStartsWith = notStartsWith;
                return this;
            }

            /**
             * Sets the value of {@link AdvancedFieldSelectorProperty#getStartsWith}
             * @param startsWith An operator that includes events that match the first few characters of the event record field specified as the value of <code>Field</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder startsWith(java.util.List<java.lang.String> startsWith) {
                this.startsWith = startsWith;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AdvancedFieldSelectorProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AdvancedFieldSelectorProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AdvancedFieldSelectorProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AdvancedFieldSelectorProperty {
            private final java.lang.String field;
            private final java.util.List<java.lang.String> endsWith;
            private final java.util.List<java.lang.String> equalTo;
            private final java.util.List<java.lang.String> notEndsWith;
            private final java.util.List<java.lang.String> notEquals;
            private final java.util.List<java.lang.String> notStartsWith;
            private final java.util.List<java.lang.String> startsWith;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.field = software.amazon.jsii.Kernel.get(this, "field", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.endsWith = software.amazon.jsii.Kernel.get(this, "endsWith", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.equalTo = software.amazon.jsii.Kernel.get(this, "equalTo", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.notEndsWith = software.amazon.jsii.Kernel.get(this, "notEndsWith", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.notEquals = software.amazon.jsii.Kernel.get(this, "notEquals", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.notStartsWith = software.amazon.jsii.Kernel.get(this, "notStartsWith", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.startsWith = software.amazon.jsii.Kernel.get(this, "startsWith", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.field = java.util.Objects.requireNonNull(builder.field, "field is required");
                this.endsWith = builder.endsWith;
                this.equalTo = builder.equalTo;
                this.notEndsWith = builder.notEndsWith;
                this.notEquals = builder.notEquals;
                this.notStartsWith = builder.notStartsWith;
                this.startsWith = builder.startsWith;
            }

            @Override
            public final java.lang.String getField() {
                return this.field;
            }

            @Override
            public final java.util.List<java.lang.String> getEndsWith() {
                return this.endsWith;
            }

            @Override
            public final java.util.List<java.lang.String> getEqualTo() {
                return this.equalTo;
            }

            @Override
            public final java.util.List<java.lang.String> getNotEndsWith() {
                return this.notEndsWith;
            }

            @Override
            public final java.util.List<java.lang.String> getNotEquals() {
                return this.notEquals;
            }

            @Override
            public final java.util.List<java.lang.String> getNotStartsWith() {
                return this.notStartsWith;
            }

            @Override
            public final java.util.List<java.lang.String> getStartsWith() {
                return this.startsWith;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("field", om.valueToTree(this.getField()));
                if (this.getEndsWith() != null) {
                    data.set("endsWith", om.valueToTree(this.getEndsWith()));
                }
                if (this.getEqualTo() != null) {
                    data.set("equalTo", om.valueToTree(this.getEqualTo()));
                }
                if (this.getNotEndsWith() != null) {
                    data.set("notEndsWith", om.valueToTree(this.getNotEndsWith()));
                }
                if (this.getNotEquals() != null) {
                    data.set("notEquals", om.valueToTree(this.getNotEquals()));
                }
                if (this.getNotStartsWith() != null) {
                    data.set("notStartsWith", om.valueToTree(this.getNotStartsWith()));
                }
                if (this.getStartsWith() != null) {
                    data.set("startsWith", om.valueToTree(this.getStartsWith()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cloudtrail.CfnEventDataStore.AdvancedFieldSelectorProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AdvancedFieldSelectorProperty.Jsii$Proxy that = (AdvancedFieldSelectorProperty.Jsii$Proxy) o;

                if (!field.equals(that.field)) return false;
                if (this.endsWith != null ? !this.endsWith.equals(that.endsWith) : that.endsWith != null) return false;
                if (this.equalTo != null ? !this.equalTo.equals(that.equalTo) : that.equalTo != null) return false;
                if (this.notEndsWith != null ? !this.notEndsWith.equals(that.notEndsWith) : that.notEndsWith != null) return false;
                if (this.notEquals != null ? !this.notEquals.equals(that.notEquals) : that.notEquals != null) return false;
                if (this.notStartsWith != null ? !this.notStartsWith.equals(that.notStartsWith) : that.notStartsWith != null) return false;
                return this.startsWith != null ? this.startsWith.equals(that.startsWith) : that.startsWith == null;
            }

            @Override
            public final int hashCode() {
                int result = this.field.hashCode();
                result = 31 * result + (this.endsWith != null ? this.endsWith.hashCode() : 0);
                result = 31 * result + (this.equalTo != null ? this.equalTo.hashCode() : 0);
                result = 31 * result + (this.notEndsWith != null ? this.notEndsWith.hashCode() : 0);
                result = 31 * result + (this.notEquals != null ? this.notEquals.hashCode() : 0);
                result = 31 * result + (this.notStartsWith != null ? this.notStartsWith.hashCode() : 0);
                result = 31 * result + (this.startsWith != null ? this.startsWith.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * An object that contains information types to be included in CloudTrail enriched events.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.cloudtrail.*;
     * ContextKeySelectorProperty contextKeySelectorProperty = ContextKeySelectorProperty.builder()
     *         .equalTo(List.of("equalTo"))
     *         .type("type")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudtrail-eventdatastore-contextkeyselector.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudtrail-eventdatastore-contextkeyselector.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudtrail.CfnEventDataStore.ContextKeySelectorProperty")
    @software.amazon.jsii.Jsii.Proxy(ContextKeySelectorProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ContextKeySelectorProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A list of keys defined by Type to be included in CloudTrail enriched events.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudtrail-eventdatastore-contextkeyselector.html#cfn-cloudtrail-eventdatastore-contextkeyselector-equals">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudtrail-eventdatastore-contextkeyselector.html#cfn-cloudtrail-eventdatastore-contextkeyselector-equals</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getEqualTo();

        /**
         * Specifies the type of the event record field in ContextKeySelector.
         * <p>
         * Valid values include RequestContext, TagContext.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudtrail-eventdatastore-contextkeyselector.html#cfn-cloudtrail-eventdatastore-contextkeyselector-type">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudtrail-eventdatastore-contextkeyselector.html#cfn-cloudtrail-eventdatastore-contextkeyselector-type</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getType();

        /**
         * @return a {@link Builder} of {@link ContextKeySelectorProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ContextKeySelectorProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ContextKeySelectorProperty> {
            java.util.List<java.lang.String> equalTo;
            java.lang.String type;

            /**
             * Sets the value of {@link ContextKeySelectorProperty#getEqualTo}
             * @param equalTo A list of keys defined by Type to be included in CloudTrail enriched events. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder equalTo(java.util.List<java.lang.String> equalTo) {
                this.equalTo = equalTo;
                return this;
            }

            /**
             * Sets the value of {@link ContextKeySelectorProperty#getType}
             * @param type Specifies the type of the event record field in ContextKeySelector. This parameter is required.
             *             Valid values include RequestContext, TagContext.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ContextKeySelectorProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ContextKeySelectorProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ContextKeySelectorProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ContextKeySelectorProperty {
            private final java.util.List<java.lang.String> equalTo;
            private final java.lang.String type;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.equalTo = software.amazon.jsii.Kernel.get(this, "equalTo", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.equalTo = java.util.Objects.requireNonNull(builder.equalTo, "equalTo is required");
                this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
            }

            @Override
            public final java.util.List<java.lang.String> getEqualTo() {
                return this.equalTo;
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("equalTo", om.valueToTree(this.getEqualTo()));
                data.set("type", om.valueToTree(this.getType()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cloudtrail.CfnEventDataStore.ContextKeySelectorProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ContextKeySelectorProperty.Jsii$Proxy that = (ContextKeySelectorProperty.Jsii$Proxy) o;

                if (!equalTo.equals(that.equalTo)) return false;
                return this.type.equals(that.type);
            }

            @Override
            public final int hashCode() {
                int result = this.equalTo.hashCode();
                result = 31 * result + (this.type.hashCode());
                return result;
            }
        }
    }
    /**
     * A JSON string that contains a list of Insights types that are logged on an event data store.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.cloudtrail.*;
     * InsightSelectorProperty insightSelectorProperty = InsightSelectorProperty.builder()
     *         .insightType("insightType")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudtrail-eventdatastore-insightselector.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudtrail-eventdatastore-insightselector.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudtrail.CfnEventDataStore.InsightSelectorProperty")
    @software.amazon.jsii.Jsii.Proxy(InsightSelectorProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface InsightSelectorProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The type of Insights events to log on an event data store. <code>ApiCallRateInsight</code> and <code>ApiErrorRateInsight</code> are valid Insight types.
         * <p>
         * The <code>ApiCallRateInsight</code> Insights type analyzes write-only management API calls that are aggregated per minute against a baseline API call volume.
         * <p>
         * The <code>ApiErrorRateInsight</code> Insights type analyzes management API calls that result in error codes. The error is shown if the API call is unsuccessful.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudtrail-eventdatastore-insightselector.html#cfn-cloudtrail-eventdatastore-insightselector-insighttype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudtrail-eventdatastore-insightselector.html#cfn-cloudtrail-eventdatastore-insightselector-insighttype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getInsightType() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link InsightSelectorProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link InsightSelectorProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<InsightSelectorProperty> {
            java.lang.String insightType;

            /**
             * Sets the value of {@link InsightSelectorProperty#getInsightType}
             * @param insightType The type of Insights events to log on an event data store. <code>ApiCallRateInsight</code> and <code>ApiErrorRateInsight</code> are valid Insight types.
             *                    The <code>ApiCallRateInsight</code> Insights type analyzes write-only management API calls that are aggregated per minute against a baseline API call volume.
             *                    <p>
             *                    The <code>ApiErrorRateInsight</code> Insights type analyzes management API calls that result in error codes. The error is shown if the API call is unsuccessful.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder insightType(java.lang.String insightType) {
                this.insightType = insightType;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link InsightSelectorProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public InsightSelectorProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link InsightSelectorProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements InsightSelectorProperty {
            private final java.lang.String insightType;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.insightType = software.amazon.jsii.Kernel.get(this, "insightType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.insightType = builder.insightType;
            }

            @Override
            public final java.lang.String getInsightType() {
                return this.insightType;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getInsightType() != null) {
                    data.set("insightType", om.valueToTree(this.getInsightType()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cloudtrail.CfnEventDataStore.InsightSelectorProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                InsightSelectorProperty.Jsii$Proxy that = (InsightSelectorProperty.Jsii$Proxy) o;

                return this.insightType != null ? this.insightType.equals(that.insightType) : that.insightType == null;
            }

            @Override
            public final int hashCode() {
                int result = this.insightType != null ? this.insightType.hashCode() : 0;
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.cloudtrail.CfnEventDataStore}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.cloudtrail.CfnEventDataStore> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.services.cloudtrail.CfnEventDataStoreProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * The advanced event selectors to use to select the events for the data store.
         * <p>
         * You can configure up to five advanced event selectors for each event data store.
         * <p>
         * For more information about how to use advanced event selectors to log CloudTrail events, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-data-events-with-cloudtrail.html#creating-data-event-selectors-advanced">Log events by using advanced event selectors</a> in the CloudTrail User Guide.
         * <p>
         * For more information about how to use advanced event selectors to include AWS Config configuration items in your event data store, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/lake-eds-cli.html#lake-cli-create-eds-config">Create an event data store for AWS Config configuration items</a> in the CloudTrail User Guide.
         * <p>
         * For more information about how to use advanced event selectors to include events outside of AWS events in your event data store, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/lake-integrations-cli.html#lake-cli-create-integration">Create an integration to log events from outside AWS</a> in the CloudTrail User Guide.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudtrail-eventdatastore.html#cfn-cloudtrail-eventdatastore-advancedeventselectors">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudtrail-eventdatastore.html#cfn-cloudtrail-eventdatastore-advancedeventselectors</a>
         * @param advancedEventSelectors The advanced event selectors to use to select the events for the data store. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder advancedEventSelectors(final software.amazon.awscdk.IResolvable advancedEventSelectors) {
            this.props().advancedEventSelectors(advancedEventSelectors);
            return this;
        }
        /**
         * The advanced event selectors to use to select the events for the data store.
         * <p>
         * You can configure up to five advanced event selectors for each event data store.
         * <p>
         * For more information about how to use advanced event selectors to log CloudTrail events, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-data-events-with-cloudtrail.html#creating-data-event-selectors-advanced">Log events by using advanced event selectors</a> in the CloudTrail User Guide.
         * <p>
         * For more information about how to use advanced event selectors to include AWS Config configuration items in your event data store, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/lake-eds-cli.html#lake-cli-create-eds-config">Create an event data store for AWS Config configuration items</a> in the CloudTrail User Guide.
         * <p>
         * For more information about how to use advanced event selectors to include events outside of AWS events in your event data store, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/lake-integrations-cli.html#lake-cli-create-integration">Create an integration to log events from outside AWS</a> in the CloudTrail User Guide.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudtrail-eventdatastore.html#cfn-cloudtrail-eventdatastore-advancedeventselectors">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudtrail-eventdatastore.html#cfn-cloudtrail-eventdatastore-advancedeventselectors</a>
         * @param advancedEventSelectors The advanced event selectors to use to select the events for the data store. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder advancedEventSelectors(final java.util.List<? extends java.lang.Object> advancedEventSelectors) {
            this.props().advancedEventSelectors(advancedEventSelectors);
            return this;
        }

        /**
         * The billing mode for the event data store determines the cost for ingesting events and the default and maximum retention period for the event data store.
         * <p>
         * The following are the possible values:
         * <p>
         * <ul>
         * <li><code>EXTENDABLE_RETENTION_PRICING</code> - This billing mode is generally recommended if you want a flexible retention period of up to 3653 days (about 10 years). The default retention period for this billing mode is 366 days.</li>
         * <li><code>FIXED_RETENTION_PRICING</code> - This billing mode is recommended if you expect to ingest more than 25 TB of event data per month and need a retention period of up to 2557 days (about 7 years). The default retention period for this billing mode is 2557 days.</li>
         * </ul>
         * <p>
         * The default value is <code>EXTENDABLE_RETENTION_PRICING</code> .
         * <p>
         * For more information about CloudTrail pricing, see <a href="https://docs.aws.amazon.com/cloudtrail/pricing/">AWS CloudTrail Pricing</a> and <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-lake-manage-costs.html">Managing CloudTrail Lake costs</a> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudtrail-eventdatastore.html#cfn-cloudtrail-eventdatastore-billingmode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudtrail-eventdatastore.html#cfn-cloudtrail-eventdatastore-billingmode</a>
         * @param billingMode The billing mode for the event data store determines the cost for ingesting events and the default and maximum retention period for the event data store. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder billingMode(final java.lang.String billingMode) {
            this.props().billingMode(billingMode);
            return this;
        }

        /**
         * The list of context key selectors that are configured for the event data store.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudtrail-eventdatastore.html#cfn-cloudtrail-eventdatastore-contextkeyselectors">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudtrail-eventdatastore.html#cfn-cloudtrail-eventdatastore-contextkeyselectors</a>
         * @param contextKeySelectors The list of context key selectors that are configured for the event data store. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder contextKeySelectors(final software.amazon.awscdk.IResolvable contextKeySelectors) {
            this.props().contextKeySelectors(contextKeySelectors);
            return this;
        }
        /**
         * The list of context key selectors that are configured for the event data store.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudtrail-eventdatastore.html#cfn-cloudtrail-eventdatastore-contextkeyselectors">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudtrail-eventdatastore.html#cfn-cloudtrail-eventdatastore-contextkeyselectors</a>
         * @param contextKeySelectors The list of context key selectors that are configured for the event data store. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder contextKeySelectors(final java.util.List<? extends java.lang.Object> contextKeySelectors) {
            this.props().contextKeySelectors(contextKeySelectors);
            return this;
        }

        /**
         * Indicates if <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/query-federation.html">Lake query federation</a> is enabled. By default, Lake query federation is disabled. You cannot delete an event data store if Lake query federation is enabled.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudtrail-eventdatastore.html#cfn-cloudtrail-eventdatastore-federationenabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudtrail-eventdatastore.html#cfn-cloudtrail-eventdatastore-federationenabled</a>
         * @param federationEnabled Indicates if <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/query-federation.html">Lake query federation</a> is enabled. By default, Lake query federation is disabled. You cannot delete an event data store if Lake query federation is enabled. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder federationEnabled(final java.lang.Boolean federationEnabled) {
            this.props().federationEnabled(federationEnabled);
            return this;
        }
        /**
         * Indicates if <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/query-federation.html">Lake query federation</a> is enabled. By default, Lake query federation is disabled. You cannot delete an event data store if Lake query federation is enabled.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudtrail-eventdatastore.html#cfn-cloudtrail-eventdatastore-federationenabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudtrail-eventdatastore.html#cfn-cloudtrail-eventdatastore-federationenabled</a>
         * @param federationEnabled Indicates if <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/query-federation.html">Lake query federation</a> is enabled. By default, Lake query federation is disabled. You cannot delete an event data store if Lake query federation is enabled. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder federationEnabled(final software.amazon.awscdk.IResolvable federationEnabled) {
            this.props().federationEnabled(federationEnabled);
            return this;
        }

        /**
         * If Lake query federation is enabled, provides the ARN of the federation role used to access the resources for the federated event data store.
         * <p>
         * The federation role must exist in your account and provide the <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/query-federation.html#query-federation-permissions-role">required minimum permissions</a> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudtrail-eventdatastore.html#cfn-cloudtrail-eventdatastore-federationrolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudtrail-eventdatastore.html#cfn-cloudtrail-eventdatastore-federationrolearn</a>
         * @param federationRoleArn If Lake query federation is enabled, provides the ARN of the federation role used to access the resources for the federated event data store. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder federationRoleArn(final java.lang.String federationRoleArn) {
            this.props().federationRoleArn(federationRoleArn);
            return this;
        }

        /**
         * Specifies whether the event data store should start ingesting live events.
         * <p>
         * The default is true.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudtrail-eventdatastore.html#cfn-cloudtrail-eventdatastore-ingestionenabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudtrail-eventdatastore.html#cfn-cloudtrail-eventdatastore-ingestionenabled</a>
         * @param ingestionEnabled Specifies whether the event data store should start ingesting live events. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ingestionEnabled(final java.lang.Boolean ingestionEnabled) {
            this.props().ingestionEnabled(ingestionEnabled);
            return this;
        }
        /**
         * Specifies whether the event data store should start ingesting live events.
         * <p>
         * The default is true.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudtrail-eventdatastore.html#cfn-cloudtrail-eventdatastore-ingestionenabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudtrail-eventdatastore.html#cfn-cloudtrail-eventdatastore-ingestionenabled</a>
         * @param ingestionEnabled Specifies whether the event data store should start ingesting live events. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ingestionEnabled(final software.amazon.awscdk.IResolvable ingestionEnabled) {
            this.props().ingestionEnabled(ingestionEnabled);
            return this;
        }

        /**
         * The ARN (or ID suffix of the ARN) of the destination event data store that logs Insights events.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/query-event-data-store-insights.html">Create an event data store for CloudTrail Insights events</a> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudtrail-eventdatastore.html#cfn-cloudtrail-eventdatastore-insightsdestination">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudtrail-eventdatastore.html#cfn-cloudtrail-eventdatastore-insightsdestination</a>
         * @param insightsDestination The ARN (or ID suffix of the ARN) of the destination event data store that logs Insights events. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder insightsDestination(final java.lang.String insightsDestination) {
            this.props().insightsDestination(insightsDestination);
            return this;
        }

        /**
         * A JSON string that contains the Insights types you want to log on an event data store.
         * <p>
         * <code>ApiCallRateInsight</code> and <code>ApiErrorRateInsight</code> are valid Insight types.
         * <p>
         * The <code>ApiCallRateInsight</code> Insights type analyzes write-only management API calls that are aggregated per minute against a baseline API call volume.
         * <p>
         * The <code>ApiErrorRateInsight</code> Insights type analyzes management API calls that result in error codes. The error is shown if the API call is unsuccessful.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudtrail-eventdatastore.html#cfn-cloudtrail-eventdatastore-insightselectors">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudtrail-eventdatastore.html#cfn-cloudtrail-eventdatastore-insightselectors</a>
         * @param insightSelectors A JSON string that contains the Insights types you want to log on an event data store. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder insightSelectors(final software.amazon.awscdk.IResolvable insightSelectors) {
            this.props().insightSelectors(insightSelectors);
            return this;
        }
        /**
         * A JSON string that contains the Insights types you want to log on an event data store.
         * <p>
         * <code>ApiCallRateInsight</code> and <code>ApiErrorRateInsight</code> are valid Insight types.
         * <p>
         * The <code>ApiCallRateInsight</code> Insights type analyzes write-only management API calls that are aggregated per minute against a baseline API call volume.
         * <p>
         * The <code>ApiErrorRateInsight</code> Insights type analyzes management API calls that result in error codes. The error is shown if the API call is unsuccessful.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudtrail-eventdatastore.html#cfn-cloudtrail-eventdatastore-insightselectors">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudtrail-eventdatastore.html#cfn-cloudtrail-eventdatastore-insightselectors</a>
         * @param insightSelectors A JSON string that contains the Insights types you want to log on an event data store. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder insightSelectors(final java.util.List<? extends java.lang.Object> insightSelectors) {
            this.props().insightSelectors(insightSelectors);
            return this;
        }

        /**
         * Specifies the AWS KMS key ID to use to encrypt the events delivered by CloudTrail.
         * <p>
         * The value can be an alias name prefixed by <code>alias/</code> , a fully specified ARN to an alias, a fully specified ARN to a key, or a globally unique identifier.
         * <p>
         * <blockquote>
         * <p>
         * Disabling or deleting the KMS key, or removing CloudTrail permissions on the key, prevents CloudTrail from logging events to the event data store, and prevents users from querying the data in the event data store that was encrypted with the key. After you associate an event data store with a KMS key, the KMS key cannot be removed or changed. Before you disable or delete a KMS key that you are using with an event data store, delete or back up your event data store.
         * <p>
         * </blockquote>
         * <p>
         * CloudTrail also supports AWS KMS multi-Region keys. For more information about multi-Region keys, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/multi-region-keys-overview.html">Using multi-Region keys</a> in the <em>AWS Key Management Service Developer Guide</em> .
         * <p>
         * Examples:
         * <p>
         * <ul>
         * <li><code>alias/MyAliasName</code></li>
         * <li><code>arn:aws:kms:us-east-2:123456789012:alias/MyAliasName</code></li>
         * <li><code>arn:aws:kms:us-east-2:123456789012:key/12345678-1234-1234-1234-123456789012</code></li>
         * <li><code>12345678-1234-1234-1234-123456789012</code></li>
         * </ul>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudtrail-eventdatastore.html#cfn-cloudtrail-eventdatastore-kmskeyid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudtrail-eventdatastore.html#cfn-cloudtrail-eventdatastore-kmskeyid</a>
         * @param kmsKeyId Specifies the AWS KMS key ID to use to encrypt the events delivered by CloudTrail. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kmsKeyId(final java.lang.String kmsKeyId) {
            this.props().kmsKeyId(kmsKeyId);
            return this;
        }

        /**
         * The maximum allowed size for events to be stored in the specified event data store.
         * <p>
         * If you are using context key selectors, MaxEventSize must be set to Large.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudtrail-eventdatastore.html#cfn-cloudtrail-eventdatastore-maxeventsize">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudtrail-eventdatastore.html#cfn-cloudtrail-eventdatastore-maxeventsize</a>
         * @param maxEventSize The maximum allowed size for events to be stored in the specified event data store. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxEventSize(final java.lang.String maxEventSize) {
            this.props().maxEventSize(maxEventSize);
            return this;
        }

        /**
         * Specifies whether the event data store includes events from all Regions, or only from the Region in which the event data store is created.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudtrail-eventdatastore.html#cfn-cloudtrail-eventdatastore-multiregionenabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudtrail-eventdatastore.html#cfn-cloudtrail-eventdatastore-multiregionenabled</a>
         * @param multiRegionEnabled Specifies whether the event data store includes events from all Regions, or only from the Region in which the event data store is created. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder multiRegionEnabled(final java.lang.Boolean multiRegionEnabled) {
            this.props().multiRegionEnabled(multiRegionEnabled);
            return this;
        }
        /**
         * Specifies whether the event data store includes events from all Regions, or only from the Region in which the event data store is created.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudtrail-eventdatastore.html#cfn-cloudtrail-eventdatastore-multiregionenabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudtrail-eventdatastore.html#cfn-cloudtrail-eventdatastore-multiregionenabled</a>
         * @param multiRegionEnabled Specifies whether the event data store includes events from all Regions, or only from the Region in which the event data store is created. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder multiRegionEnabled(final software.amazon.awscdk.IResolvable multiRegionEnabled) {
            this.props().multiRegionEnabled(multiRegionEnabled);
            return this;
        }

        /**
         * The name of the event data store.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudtrail-eventdatastore.html#cfn-cloudtrail-eventdatastore-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudtrail-eventdatastore.html#cfn-cloudtrail-eventdatastore-name</a>
         * @param name The name of the event data store. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props().name(name);
            return this;
        }

        /**
         * Specifies whether an event data store collects events logged for an organization in AWS Organizations .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudtrail-eventdatastore.html#cfn-cloudtrail-eventdatastore-organizationenabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudtrail-eventdatastore.html#cfn-cloudtrail-eventdatastore-organizationenabled</a>
         * @param organizationEnabled Specifies whether an event data store collects events logged for an organization in AWS Organizations . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder organizationEnabled(final java.lang.Boolean organizationEnabled) {
            this.props().organizationEnabled(organizationEnabled);
            return this;
        }
        /**
         * Specifies whether an event data store collects events logged for an organization in AWS Organizations .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudtrail-eventdatastore.html#cfn-cloudtrail-eventdatastore-organizationenabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudtrail-eventdatastore.html#cfn-cloudtrail-eventdatastore-organizationenabled</a>
         * @param organizationEnabled Specifies whether an event data store collects events logged for an organization in AWS Organizations . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder organizationEnabled(final software.amazon.awscdk.IResolvable organizationEnabled) {
            this.props().organizationEnabled(organizationEnabled);
            return this;
        }

        /**
         * The retention period of the event data store, in days.
         * <p>
         * If <code>BillingMode</code> is set to <code>EXTENDABLE_RETENTION_PRICING</code> , you can set a retention period of up to 3653 days, the equivalent of 10 years. If <code>BillingMode</code> is set to <code>FIXED_RETENTION_PRICING</code> , you can set a retention period of up to 2557 days, the equivalent of seven years.
         * <p>
         * CloudTrail Lake determines whether to retain an event by checking if the <code>eventTime</code> of the event is within the specified retention period. For example, if you set a retention period of 90 days, CloudTrail will remove events when the <code>eventTime</code> is older than 90 days.
         * <p>
         * <blockquote>
         * <p>
         * If you plan to copy trail events to this event data store, we recommend that you consider both the age of the events that you want to copy as well as how long you want to keep the copied events in your event data store. For example, if you copy trail events that are 5 years old and specify a retention period of 7 years, the event data store will retain those events for two years.
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudtrail-eventdatastore.html#cfn-cloudtrail-eventdatastore-retentionperiod">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudtrail-eventdatastore.html#cfn-cloudtrail-eventdatastore-retentionperiod</a>
         * @param retentionPeriod The retention period of the event data store, in days. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder retentionPeriod(final java.lang.Number retentionPeriod) {
            this.props().retentionPeriod(retentionPeriod);
            return this;
        }

        /**
         * A list of tags.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudtrail-eventdatastore.html#cfn-cloudtrail-eventdatastore-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudtrail-eventdatastore.html#cfn-cloudtrail-eventdatastore-tags</a>
         * @param tags A list of tags. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props().tags(tags);
            return this;
        }

        /**
         * Specifies whether termination protection is enabled for the event data store.
         * <p>
         * If termination protection is enabled, you cannot delete the event data store until termination protection is disabled.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudtrail-eventdatastore.html#cfn-cloudtrail-eventdatastore-terminationprotectionenabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudtrail-eventdatastore.html#cfn-cloudtrail-eventdatastore-terminationprotectionenabled</a>
         * @param terminationProtectionEnabled Specifies whether termination protection is enabled for the event data store. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder terminationProtectionEnabled(final java.lang.Boolean terminationProtectionEnabled) {
            this.props().terminationProtectionEnabled(terminationProtectionEnabled);
            return this;
        }
        /**
         * Specifies whether termination protection is enabled for the event data store.
         * <p>
         * If termination protection is enabled, you cannot delete the event data store until termination protection is disabled.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudtrail-eventdatastore.html#cfn-cloudtrail-eventdatastore-terminationprotectionenabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudtrail-eventdatastore.html#cfn-cloudtrail-eventdatastore-terminationprotectionenabled</a>
         * @param terminationProtectionEnabled Specifies whether termination protection is enabled for the event data store. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder terminationProtectionEnabled(final software.amazon.awscdk.IResolvable terminationProtectionEnabled) {
            this.props().terminationProtectionEnabled(terminationProtectionEnabled);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.cloudtrail.CfnEventDataStore}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.cloudtrail.CfnEventDataStore build() {
            return new software.amazon.awscdk.services.cloudtrail.CfnEventDataStore(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.cloudtrail.CfnEventDataStoreProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.cloudtrail.CfnEventDataStoreProps.Builder();
            }
            return this.props;
        }
    }
}
