package software.amazon.awscdk.services.cloudwatch;

/**
 * Properties for Anomaly Detection Alarms.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // Create a metric
 * Metric metric = Metric.Builder.create()
 *         .namespace("AWS/EC2")
 *         .metricName("CPUUtilization")
 *         .statistic("Average")
 *         .period(Duration.minutes(5))
 *         .build();
 * // Create an anomaly detection alarm
 * AnomalyDetectionAlarm alarm = AnomalyDetectionAlarm.Builder.create(this, "AnomalyAlarm")
 *         .metric(metric)
 *         .evaluationPeriods(1)
 *         // Number of standard deviations for the band (default: 2)
 *         .stdDevs(2)
 *         // Alarm outside on either side of the band, or just below or above it (default: outside)
 *         .comparisonOperator(ComparisonOperator.LESS_THAN_LOWER_OR_GREATER_THAN_UPPER_THRESHOLD)
 *         .alarmDescription("Alarm when metric is outside the expected band")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-08-06T18:14:34.065Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudwatch.AnomalyDetectionAlarmProps")
@software.amazon.jsii.Jsii.Proxy(AnomalyDetectionAlarmProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface AnomalyDetectionAlarmProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The number of periods over which data is compared to the specified threshold.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Number getEvaluationPeriods();

    /**
     * The metric to add the alarm on.
     * <p>
     * Metric objects can be obtained from most resources, or you can construct
     * custom Metric objects by instantiating one.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.IMetric getMetric();

    /**
     * Whether the actions for this alarm are enabled.
     * <p>
     * Default: true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getActionsEnabled() {
        return null;
    }

    /**
     * Description for the alarm.
     * <p>
     * Default: No description
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAlarmDescription() {
        return null;
    }

    /**
     * Name of the alarm.
     * <p>
     * Default: Automatically generated name
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAlarmName() {
        return null;
    }

    /**
     * Comparison operator to use to check if metric is breaching.
     * <p>
     * Must be one of the anomaly detection operators:
     * <p>
     * <ul>
     * <li>LESS_THAN_LOWER_OR_GREATER_THAN_UPPER_THRESHOLD</li>
     * <li>GREATER_THAN_UPPER_THRESHOLD</li>
     * <li>LESS_THAN_LOWER_THRESHOLD</li>
     * </ul>
     * <p>
     * Default: LESS_THAN_LOWER_OR_GREATER_THAN_UPPER_THRESHOLD
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.ComparisonOperator getComparisonOperator() {
        return null;
    }

    /**
     * The number of datapoints that must be breaching to trigger the alarm.
     * <p>
     * This is used only if you are setting an "M
     * out of N" alarm. In that case, this value is the M. For more information, see Evaluating an Alarm in the Amazon
     * CloudWatch User Guide.
     * <p>
     * Default: ``evaluationPeriods``
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/AlarmThatSendsEmail.html#alarm-evaluation">https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/AlarmThatSendsEmail.html#alarm-evaluation</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getDatapointsToAlarm() {
        return null;
    }

    /**
     * Specifies whether to evaluate the data and potentially change the alarm state if there are too few data points to be statistically significant.
     * <p>
     * Used only for alarms that are based on percentiles.
     * <p>
     * Default: - Not configured.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getEvaluateLowSampleCountPercentile() {
        return null;
    }

    /**
     * (deprecated) The period over which the specified statistic is applied.
     * <p>
     * Cannot be used with <code>MathExpression</code> objects.
     * <p>
     * Default: - The period from the metric
     * <p>
     * @deprecated Use <code>metric.with({ period: ... })</code> to encode the period into the Metric object
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.Duration getPeriod() {
        return null;
    }

    /**
     * (deprecated) What function to use for aggregating.
     * <p>
     * Can be one of the following:
     * <p>
     * <ul>
     * <li>"Minimum" | "min"</li>
     * <li>"Maximum" | "max"</li>
     * <li>"Average" | "avg"</li>
     * <li>"Sum" | "sum"</li>
     * <li>"SampleCount | "n"</li>
     * <li>"pNN.NN"</li>
     * </ul>
     * <p>
     * Cannot be used with <code>MathExpression</code> objects.
     * <p>
     * Default: - The statistic from the metric
     * <p>
     * @deprecated Use <code>metric.with({ statistic: ... })</code> to encode the period into the Metric object
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    default @org.jetbrains.annotations.Nullable java.lang.String getStatistic() {
        return null;
    }

    /**
     * The number of standard deviations to use for the anomaly detection band.
     * <p>
     * The higher the value, the wider the band.
     * <p>
     * <ul>
     * <li>Must be greater than 0. A value of 0 or negative values would not make sense in the context of calculating standard deviations.</li>
     * <li>There is no strict maximum value defined, as standard deviations can theoretically extend infinitely. However, in practice, values beyond 5 or 6 standard deviations are rarely used, as they would result in an extremely wide anomaly detection band, potentially missing significant anomalies.</li>
     * </ul>
     * <p>
     * Default: 2
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getStdDevs() {
        return null;
    }

    /**
     * Sets how this alarm is to handle missing data points.
     * <p>
     * Default: TreatMissingData.Missing
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.TreatMissingData getTreatMissingData() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link AnomalyDetectionAlarmProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link AnomalyDetectionAlarmProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<AnomalyDetectionAlarmProps> {
        java.lang.Number evaluationPeriods;
        software.amazon.awscdk.services.cloudwatch.IMetric metric;
        java.lang.Boolean actionsEnabled;
        java.lang.String alarmDescription;
        java.lang.String alarmName;
        software.amazon.awscdk.services.cloudwatch.ComparisonOperator comparisonOperator;
        java.lang.Number datapointsToAlarm;
        java.lang.String evaluateLowSampleCountPercentile;
        software.amazon.awscdk.Duration period;
        java.lang.String statistic;
        java.lang.Number stdDevs;
        software.amazon.awscdk.services.cloudwatch.TreatMissingData treatMissingData;

        /**
         * Sets the value of {@link AnomalyDetectionAlarmProps#getEvaluationPeriods}
         * @param evaluationPeriods The number of periods over which data is compared to the specified threshold. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder evaluationPeriods(java.lang.Number evaluationPeriods) {
            this.evaluationPeriods = evaluationPeriods;
            return this;
        }

        /**
         * Sets the value of {@link AnomalyDetectionAlarmProps#getMetric}
         * @param metric The metric to add the alarm on. This parameter is required.
         *               Metric objects can be obtained from most resources, or you can construct
         *               custom Metric objects by instantiating one.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder metric(software.amazon.awscdk.services.cloudwatch.IMetric metric) {
            this.metric = metric;
            return this;
        }

        /**
         * Sets the value of {@link AnomalyDetectionAlarmProps#getActionsEnabled}
         * @param actionsEnabled Whether the actions for this alarm are enabled.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder actionsEnabled(java.lang.Boolean actionsEnabled) {
            this.actionsEnabled = actionsEnabled;
            return this;
        }

        /**
         * Sets the value of {@link AnomalyDetectionAlarmProps#getAlarmDescription}
         * @param alarmDescription Description for the alarm.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder alarmDescription(java.lang.String alarmDescription) {
            this.alarmDescription = alarmDescription;
            return this;
        }

        /**
         * Sets the value of {@link AnomalyDetectionAlarmProps#getAlarmName}
         * @param alarmName Name of the alarm.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder alarmName(java.lang.String alarmName) {
            this.alarmName = alarmName;
            return this;
        }

        /**
         * Sets the value of {@link AnomalyDetectionAlarmProps#getComparisonOperator}
         * @param comparisonOperator Comparison operator to use to check if metric is breaching.
         *                           Must be one of the anomaly detection operators:
         *                           <p>
         *                           <ul>
         *                           <li>LESS_THAN_LOWER_OR_GREATER_THAN_UPPER_THRESHOLD</li>
         *                           <li>GREATER_THAN_UPPER_THRESHOLD</li>
         *                           <li>LESS_THAN_LOWER_THRESHOLD</li>
         *                           </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder comparisonOperator(software.amazon.awscdk.services.cloudwatch.ComparisonOperator comparisonOperator) {
            this.comparisonOperator = comparisonOperator;
            return this;
        }

        /**
         * Sets the value of {@link AnomalyDetectionAlarmProps#getDatapointsToAlarm}
         * @param datapointsToAlarm The number of datapoints that must be breaching to trigger the alarm.
         *                          This is used only if you are setting an "M
         *                          out of N" alarm. In that case, this value is the M. For more information, see Evaluating an Alarm in the Amazon
         *                          CloudWatch User Guide.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder datapointsToAlarm(java.lang.Number datapointsToAlarm) {
            this.datapointsToAlarm = datapointsToAlarm;
            return this;
        }

        /**
         * Sets the value of {@link AnomalyDetectionAlarmProps#getEvaluateLowSampleCountPercentile}
         * @param evaluateLowSampleCountPercentile Specifies whether to evaluate the data and potentially change the alarm state if there are too few data points to be statistically significant.
         *                                         Used only for alarms that are based on percentiles.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder evaluateLowSampleCountPercentile(java.lang.String evaluateLowSampleCountPercentile) {
            this.evaluateLowSampleCountPercentile = evaluateLowSampleCountPercentile;
            return this;
        }

        /**
         * Sets the value of {@link AnomalyDetectionAlarmProps#getPeriod}
         * @param period The period over which the specified statistic is applied.
         *               Cannot be used with <code>MathExpression</code> objects.
         * @return {@code this}
         * @deprecated Use `metric.with({ period: ... })` to encode the period into the Metric object
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder period(software.amazon.awscdk.Duration period) {
            this.period = period;
            return this;
        }

        /**
         * Sets the value of {@link AnomalyDetectionAlarmProps#getStatistic}
         * @param statistic What function to use for aggregating.
         *                  Can be one of the following:
         *                  <p>
         *                  <ul>
         *                  <li>"Minimum" | "min"</li>
         *                  <li>"Maximum" | "max"</li>
         *                  <li>"Average" | "avg"</li>
         *                  <li>"Sum" | "sum"</li>
         *                  <li>"SampleCount | "n"</li>
         *                  <li>"pNN.NN"</li>
         *                  </ul>
         *                  <p>
         *                  Cannot be used with <code>MathExpression</code> objects.
         * @return {@code this}
         * @deprecated Use `metric.with({ statistic: ... })` to encode the period into the Metric object
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder statistic(java.lang.String statistic) {
            this.statistic = statistic;
            return this;
        }

        /**
         * Sets the value of {@link AnomalyDetectionAlarmProps#getStdDevs}
         * @param stdDevs The number of standard deviations to use for the anomaly detection band.
         *                The higher the value, the wider the band.
         *                <p>
         *                <ul>
         *                <li>Must be greater than 0. A value of 0 or negative values would not make sense in the context of calculating standard deviations.</li>
         *                <li>There is no strict maximum value defined, as standard deviations can theoretically extend infinitely. However, in practice, values beyond 5 or 6 standard deviations are rarely used, as they would result in an extremely wide anomaly detection band, potentially missing significant anomalies.</li>
         *                </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stdDevs(java.lang.Number stdDevs) {
            this.stdDevs = stdDevs;
            return this;
        }

        /**
         * Sets the value of {@link AnomalyDetectionAlarmProps#getTreatMissingData}
         * @param treatMissingData Sets how this alarm is to handle missing data points.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder treatMissingData(software.amazon.awscdk.services.cloudwatch.TreatMissingData treatMissingData) {
            this.treatMissingData = treatMissingData;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link AnomalyDetectionAlarmProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public AnomalyDetectionAlarmProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link AnomalyDetectionAlarmProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AnomalyDetectionAlarmProps {
        private final java.lang.Number evaluationPeriods;
        private final software.amazon.awscdk.services.cloudwatch.IMetric metric;
        private final java.lang.Boolean actionsEnabled;
        private final java.lang.String alarmDescription;
        private final java.lang.String alarmName;
        private final software.amazon.awscdk.services.cloudwatch.ComparisonOperator comparisonOperator;
        private final java.lang.Number datapointsToAlarm;
        private final java.lang.String evaluateLowSampleCountPercentile;
        private final software.amazon.awscdk.Duration period;
        private final java.lang.String statistic;
        private final java.lang.Number stdDevs;
        private final software.amazon.awscdk.services.cloudwatch.TreatMissingData treatMissingData;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.evaluationPeriods = software.amazon.jsii.Kernel.get(this, "evaluationPeriods", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.metric = software.amazon.jsii.Kernel.get(this, "metric", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.IMetric.class));
            this.actionsEnabled = software.amazon.jsii.Kernel.get(this, "actionsEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.alarmDescription = software.amazon.jsii.Kernel.get(this, "alarmDescription", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.alarmName = software.amazon.jsii.Kernel.get(this, "alarmName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.comparisonOperator = software.amazon.jsii.Kernel.get(this, "comparisonOperator", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.ComparisonOperator.class));
            this.datapointsToAlarm = software.amazon.jsii.Kernel.get(this, "datapointsToAlarm", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.evaluateLowSampleCountPercentile = software.amazon.jsii.Kernel.get(this, "evaluateLowSampleCountPercentile", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.period = software.amazon.jsii.Kernel.get(this, "period", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
            this.statistic = software.amazon.jsii.Kernel.get(this, "statistic", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.stdDevs = software.amazon.jsii.Kernel.get(this, "stdDevs", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.treatMissingData = software.amazon.jsii.Kernel.get(this, "treatMissingData", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.TreatMissingData.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.evaluationPeriods = java.util.Objects.requireNonNull(builder.evaluationPeriods, "evaluationPeriods is required");
            this.metric = java.util.Objects.requireNonNull(builder.metric, "metric is required");
            this.actionsEnabled = builder.actionsEnabled;
            this.alarmDescription = builder.alarmDescription;
            this.alarmName = builder.alarmName;
            this.comparisonOperator = builder.comparisonOperator;
            this.datapointsToAlarm = builder.datapointsToAlarm;
            this.evaluateLowSampleCountPercentile = builder.evaluateLowSampleCountPercentile;
            this.period = builder.period;
            this.statistic = builder.statistic;
            this.stdDevs = builder.stdDevs;
            this.treatMissingData = builder.treatMissingData;
        }

        @Override
        public final java.lang.Number getEvaluationPeriods() {
            return this.evaluationPeriods;
        }

        @Override
        public final software.amazon.awscdk.services.cloudwatch.IMetric getMetric() {
            return this.metric;
        }

        @Override
        public final java.lang.Boolean getActionsEnabled() {
            return this.actionsEnabled;
        }

        @Override
        public final java.lang.String getAlarmDescription() {
            return this.alarmDescription;
        }

        @Override
        public final java.lang.String getAlarmName() {
            return this.alarmName;
        }

        @Override
        public final software.amazon.awscdk.services.cloudwatch.ComparisonOperator getComparisonOperator() {
            return this.comparisonOperator;
        }

        @Override
        public final java.lang.Number getDatapointsToAlarm() {
            return this.datapointsToAlarm;
        }

        @Override
        public final java.lang.String getEvaluateLowSampleCountPercentile() {
            return this.evaluateLowSampleCountPercentile;
        }

        @Override
        public final software.amazon.awscdk.Duration getPeriod() {
            return this.period;
        }

        @Override
        public final java.lang.String getStatistic() {
            return this.statistic;
        }

        @Override
        public final java.lang.Number getStdDevs() {
            return this.stdDevs;
        }

        @Override
        public final software.amazon.awscdk.services.cloudwatch.TreatMissingData getTreatMissingData() {
            return this.treatMissingData;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("evaluationPeriods", om.valueToTree(this.getEvaluationPeriods()));
            data.set("metric", om.valueToTree(this.getMetric()));
            if (this.getActionsEnabled() != null) {
                data.set("actionsEnabled", om.valueToTree(this.getActionsEnabled()));
            }
            if (this.getAlarmDescription() != null) {
                data.set("alarmDescription", om.valueToTree(this.getAlarmDescription()));
            }
            if (this.getAlarmName() != null) {
                data.set("alarmName", om.valueToTree(this.getAlarmName()));
            }
            if (this.getComparisonOperator() != null) {
                data.set("comparisonOperator", om.valueToTree(this.getComparisonOperator()));
            }
            if (this.getDatapointsToAlarm() != null) {
                data.set("datapointsToAlarm", om.valueToTree(this.getDatapointsToAlarm()));
            }
            if (this.getEvaluateLowSampleCountPercentile() != null) {
                data.set("evaluateLowSampleCountPercentile", om.valueToTree(this.getEvaluateLowSampleCountPercentile()));
            }
            if (this.getPeriod() != null) {
                data.set("period", om.valueToTree(this.getPeriod()));
            }
            if (this.getStatistic() != null) {
                data.set("statistic", om.valueToTree(this.getStatistic()));
            }
            if (this.getStdDevs() != null) {
                data.set("stdDevs", om.valueToTree(this.getStdDevs()));
            }
            if (this.getTreatMissingData() != null) {
                data.set("treatMissingData", om.valueToTree(this.getTreatMissingData()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cloudwatch.AnomalyDetectionAlarmProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            AnomalyDetectionAlarmProps.Jsii$Proxy that = (AnomalyDetectionAlarmProps.Jsii$Proxy) o;

            if (!evaluationPeriods.equals(that.evaluationPeriods)) return false;
            if (!metric.equals(that.metric)) return false;
            if (this.actionsEnabled != null ? !this.actionsEnabled.equals(that.actionsEnabled) : that.actionsEnabled != null) return false;
            if (this.alarmDescription != null ? !this.alarmDescription.equals(that.alarmDescription) : that.alarmDescription != null) return false;
            if (this.alarmName != null ? !this.alarmName.equals(that.alarmName) : that.alarmName != null) return false;
            if (this.comparisonOperator != null ? !this.comparisonOperator.equals(that.comparisonOperator) : that.comparisonOperator != null) return false;
            if (this.datapointsToAlarm != null ? !this.datapointsToAlarm.equals(that.datapointsToAlarm) : that.datapointsToAlarm != null) return false;
            if (this.evaluateLowSampleCountPercentile != null ? !this.evaluateLowSampleCountPercentile.equals(that.evaluateLowSampleCountPercentile) : that.evaluateLowSampleCountPercentile != null) return false;
            if (this.period != null ? !this.period.equals(that.period) : that.period != null) return false;
            if (this.statistic != null ? !this.statistic.equals(that.statistic) : that.statistic != null) return false;
            if (this.stdDevs != null ? !this.stdDevs.equals(that.stdDevs) : that.stdDevs != null) return false;
            return this.treatMissingData != null ? this.treatMissingData.equals(that.treatMissingData) : that.treatMissingData == null;
        }

        @Override
        public final int hashCode() {
            int result = this.evaluationPeriods.hashCode();
            result = 31 * result + (this.metric.hashCode());
            result = 31 * result + (this.actionsEnabled != null ? this.actionsEnabled.hashCode() : 0);
            result = 31 * result + (this.alarmDescription != null ? this.alarmDescription.hashCode() : 0);
            result = 31 * result + (this.alarmName != null ? this.alarmName.hashCode() : 0);
            result = 31 * result + (this.comparisonOperator != null ? this.comparisonOperator.hashCode() : 0);
            result = 31 * result + (this.datapointsToAlarm != null ? this.datapointsToAlarm.hashCode() : 0);
            result = 31 * result + (this.evaluateLowSampleCountPercentile != null ? this.evaluateLowSampleCountPercentile.hashCode() : 0);
            result = 31 * result + (this.period != null ? this.period.hashCode() : 0);
            result = 31 * result + (this.statistic != null ? this.statistic.hashCode() : 0);
            result = 31 * result + (this.stdDevs != null ? this.stdDevs.hashCode() : 0);
            result = 31 * result + (this.treatMissingData != null ? this.treatMissingData.hashCode() : 0);
            return result;
        }
    }
}
