package software.amazon.awscdk.services.cloudwatch;

/**
 * Configurable options for MathExpressions.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.*;
 * import software.amazon.awscdk.services.cloudwatch.*;
 * MathExpressionOptions mathExpressionOptions = MathExpressionOptions.builder()
 *         .color("color")
 *         .label("label")
 *         .period(Duration.minutes(30))
 *         .searchAccount("searchAccount")
 *         .searchRegion("searchRegion")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-08-06T18:14:34.131Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudwatch.MathExpressionOptions")
@software.amazon.jsii.Jsii.Proxy(MathExpressionOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface MathExpressionOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * Color for this metric when added to a Graph in a Dashboard.
     * <p>
     * Default: - Automatic color
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getColor() {
        return null;
    }

    /**
     * Label for this expression when added to a Graph in a Dashboard.
     * <p>
     * If this expression evaluates to more than one time series (for
     * example, through the use of <code>METRICS()</code> or <code>SEARCH()</code> expressions),
     * each time series will appear in the graph using a combination of the
     * expression label and the individual metric label. Specify the empty
     * string (<code>''</code>) to suppress the expression label and only keep the
     * metric label.
     * <p>
     * You can use <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/graph-dynamic-labels.html">dynamic labels</a>
     * to show summary information about the displayed time series
     * in the legend. For example, if you use:
     * <p>
     * <blockquote><pre>
     * [max: ${MAX}] MyMetric
     * </pre></blockquote>
     * <p>
     * As the metric label, the maximum value in the visible range will
     * be shown next to the time series name in the graph's legend. If the
     * math expression produces more than one time series, the maximum
     * will be shown for each individual time series produce by this
     * math expression.
     * <p>
     * Default: - Expression value is used as label
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getLabel() {
        return null;
    }

    /**
     * The period over which the math expression's statistics are applied.
     * <p>
     * This period overrides all periods in the metrics used in this
     * math expression.
     * <p>
     * Default: Duration.minutes(5)
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.Duration getPeriod() {
        return null;
    }

    /**
     * Account to evaluate search expressions within.
     * <p>
     * Specifying a searchAccount has no effect to the account used
     * for metrics within the expression (passed via usingMetrics).
     * <p>
     * Default: - Deployment account.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getSearchAccount() {
        return null;
    }

    /**
     * Region to evaluate search expressions within.
     * <p>
     * Specifying a searchRegion has no effect to the region used
     * for metrics within the expression (passed via usingMetrics).
     * <p>
     * Default: - Deployment region.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getSearchRegion() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link MathExpressionOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link MathExpressionOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<MathExpressionOptions> {
        java.lang.String color;
        java.lang.String label;
        software.amazon.awscdk.Duration period;
        java.lang.String searchAccount;
        java.lang.String searchRegion;

        /**
         * Sets the value of {@link MathExpressionOptions#getColor}
         * @param color Color for this metric when added to a Graph in a Dashboard.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder color(java.lang.String color) {
            this.color = color;
            return this;
        }

        /**
         * Sets the value of {@link MathExpressionOptions#getLabel}
         * @param label Label for this expression when added to a Graph in a Dashboard.
         *              If this expression evaluates to more than one time series (for
         *              example, through the use of <code>METRICS()</code> or <code>SEARCH()</code> expressions),
         *              each time series will appear in the graph using a combination of the
         *              expression label and the individual metric label. Specify the empty
         *              string (<code>''</code>) to suppress the expression label and only keep the
         *              metric label.
         *              <p>
         *              You can use <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/graph-dynamic-labels.html">dynamic labels</a>
         *              to show summary information about the displayed time series
         *              in the legend. For example, if you use:
         *              <p>
         *              <blockquote><pre>
         *              [max: ${MAX}] MyMetric
         *              </pre></blockquote>
         *              <p>
         *              As the metric label, the maximum value in the visible range will
         *              be shown next to the time series name in the graph's legend. If the
         *              math expression produces more than one time series, the maximum
         *              will be shown for each individual time series produce by this
         *              math expression.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder label(java.lang.String label) {
            this.label = label;
            return this;
        }

        /**
         * Sets the value of {@link MathExpressionOptions#getPeriod}
         * @param period The period over which the math expression's statistics are applied.
         *               This period overrides all periods in the metrics used in this
         *               math expression.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder period(software.amazon.awscdk.Duration period) {
            this.period = period;
            return this;
        }

        /**
         * Sets the value of {@link MathExpressionOptions#getSearchAccount}
         * @param searchAccount Account to evaluate search expressions within.
         *                      Specifying a searchAccount has no effect to the account used
         *                      for metrics within the expression (passed via usingMetrics).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder searchAccount(java.lang.String searchAccount) {
            this.searchAccount = searchAccount;
            return this;
        }

        /**
         * Sets the value of {@link MathExpressionOptions#getSearchRegion}
         * @param searchRegion Region to evaluate search expressions within.
         *                     Specifying a searchRegion has no effect to the region used
         *                     for metrics within the expression (passed via usingMetrics).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder searchRegion(java.lang.String searchRegion) {
            this.searchRegion = searchRegion;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link MathExpressionOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public MathExpressionOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link MathExpressionOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MathExpressionOptions {
        private final java.lang.String color;
        private final java.lang.String label;
        private final software.amazon.awscdk.Duration period;
        private final java.lang.String searchAccount;
        private final java.lang.String searchRegion;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.color = software.amazon.jsii.Kernel.get(this, "color", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.label = software.amazon.jsii.Kernel.get(this, "label", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.period = software.amazon.jsii.Kernel.get(this, "period", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
            this.searchAccount = software.amazon.jsii.Kernel.get(this, "searchAccount", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.searchRegion = software.amazon.jsii.Kernel.get(this, "searchRegion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.color = builder.color;
            this.label = builder.label;
            this.period = builder.period;
            this.searchAccount = builder.searchAccount;
            this.searchRegion = builder.searchRegion;
        }

        @Override
        public final java.lang.String getColor() {
            return this.color;
        }

        @Override
        public final java.lang.String getLabel() {
            return this.label;
        }

        @Override
        public final software.amazon.awscdk.Duration getPeriod() {
            return this.period;
        }

        @Override
        public final java.lang.String getSearchAccount() {
            return this.searchAccount;
        }

        @Override
        public final java.lang.String getSearchRegion() {
            return this.searchRegion;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getColor() != null) {
                data.set("color", om.valueToTree(this.getColor()));
            }
            if (this.getLabel() != null) {
                data.set("label", om.valueToTree(this.getLabel()));
            }
            if (this.getPeriod() != null) {
                data.set("period", om.valueToTree(this.getPeriod()));
            }
            if (this.getSearchAccount() != null) {
                data.set("searchAccount", om.valueToTree(this.getSearchAccount()));
            }
            if (this.getSearchRegion() != null) {
                data.set("searchRegion", om.valueToTree(this.getSearchRegion()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cloudwatch.MathExpressionOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            MathExpressionOptions.Jsii$Proxy that = (MathExpressionOptions.Jsii$Proxy) o;

            if (this.color != null ? !this.color.equals(that.color) : that.color != null) return false;
            if (this.label != null ? !this.label.equals(that.label) : that.label != null) return false;
            if (this.period != null ? !this.period.equals(that.period) : that.period != null) return false;
            if (this.searchAccount != null ? !this.searchAccount.equals(that.searchAccount) : that.searchAccount != null) return false;
            return this.searchRegion != null ? this.searchRegion.equals(that.searchRegion) : that.searchRegion == null;
        }

        @Override
        public final int hashCode() {
            int result = this.color != null ? this.color.hashCode() : 0;
            result = 31 * result + (this.label != null ? this.label.hashCode() : 0);
            result = 31 * result + (this.period != null ? this.period.hashCode() : 0);
            result = 31 * result + (this.searchAccount != null ? this.searchAccount.hashCode() : 0);
            result = 31 * result + (this.searchRegion != null ? this.searchRegion.hashCode() : 0);
            return result;
        }
    }
}
