package software.amazon.awscdk.services.cloudwatch.actions;

/**
 * Properties for Lambda Alarm Action.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.cloudwatch.actions.*;
 * LambdaActionProps lambdaActionProps = LambdaActionProps.builder()
 *         .useUniquePermissionId(false)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-08-06T18:14:34.167Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudwatch_actions.LambdaActionProps")
@software.amazon.jsii.Jsii.Proxy(LambdaActionProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface LambdaActionProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Whether to generate unique Lambda Permission id.
     * <p>
     * Use this parameter to resolve id collision in case of multiple alarms triggering the same action
     * <p>
     * Default: - false
     * <p>
     * @see <a href="https://github.com/aws/aws-cdk/issues/33958">https://github.com/aws/aws-cdk/issues/33958</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getUseUniquePermissionId() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link LambdaActionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link LambdaActionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<LambdaActionProps> {
        java.lang.Boolean useUniquePermissionId;

        /**
         * Sets the value of {@link LambdaActionProps#getUseUniquePermissionId}
         * @param useUniquePermissionId Whether to generate unique Lambda Permission id.
         *                              Use this parameter to resolve id collision in case of multiple alarms triggering the same action
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder useUniquePermissionId(java.lang.Boolean useUniquePermissionId) {
            this.useUniquePermissionId = useUniquePermissionId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link LambdaActionProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public LambdaActionProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link LambdaActionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LambdaActionProps {
        private final java.lang.Boolean useUniquePermissionId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.useUniquePermissionId = software.amazon.jsii.Kernel.get(this, "useUniquePermissionId", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.useUniquePermissionId = builder.useUniquePermissionId;
        }

        @Override
        public final java.lang.Boolean getUseUniquePermissionId() {
            return this.useUniquePermissionId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getUseUniquePermissionId() != null) {
                data.set("useUniquePermissionId", om.valueToTree(this.getUseUniquePermissionId()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cloudwatch_actions.LambdaActionProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            LambdaActionProps.Jsii$Proxy that = (LambdaActionProps.Jsii$Proxy) o;

            return this.useUniquePermissionId != null ? this.useUniquePermissionId.equals(that.useUniquePermissionId) : that.useUniquePermissionId == null;
        }

        @Override
        public final int hashCode() {
            int result = this.useUniquePermissionId != null ? this.useUniquePermissionId.hashCode() : 0;
            return result;
        }
    }
}
