package software.amazon.awscdk.services.codepipeline.actions;

/**
 * CodePipeline invoke action that uses AWS InspectorScan for ECR images.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.ecr.*;
 * Pipeline pipeline;
 * IRepository repository;
 * Artifact scanOutput = new Artifact();
 * InspectorEcrImageScanAction scanAction = InspectorEcrImageScanAction.Builder.create()
 *         .actionName("InspectorEcrImageScanAction")
 *         .output(scanOutput)
 *         .repository(repository)
 *         .build();
 * pipeline.addStage(StageOptions.builder()
 *         .stageName("Scan")
 *         .actions(List.of(scanAction))
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-08-06T18:14:34.628Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codepipeline_actions.InspectorEcrImageScanAction")
public class InspectorEcrImageScanAction extends software.amazon.awscdk.services.codepipeline.actions.InspectorScanActionBase {

    protected InspectorEcrImageScanAction(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected InspectorEcrImageScanAction(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public InspectorEcrImageScanAction(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codepipeline.actions.InspectorEcrImageScanActionProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * This is a renamed version of the <code>IAction.bind</code> method.
     * <p>
     * @param scope This parameter is required.
     * @param stage This parameter is required.
     * @param options This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codepipeline.ActionConfig bound(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codepipeline.IStage stage, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codepipeline.ActionBindOptions options) {
        return software.amazon.jsii.Kernel.call(this, "bound", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codepipeline.ActionConfig.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(stage, "stage is required"), java.util.Objects.requireNonNull(options, "options is required") });
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderActionConfiguration() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderActionConfiguration", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.codepipeline.actions.InspectorEcrImageScanAction}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.codepipeline.actions.InspectorEcrImageScanAction> {
        /**
         * @return a new instance of {@link Builder}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create() {
            return new Builder();
        }

        private final software.amazon.awscdk.services.codepipeline.actions.InspectorEcrImageScanActionProps.Builder props;

        private Builder() {
            this.props = new software.amazon.awscdk.services.codepipeline.actions.InspectorEcrImageScanActionProps.Builder();
        }

        /**
         * The physical, human-readable name of the Action.
         * <p>
         * Note that Action names must be unique within a single Stage.
         * <p>
         * @return {@code this}
         * @param actionName The physical, human-readable name of the Action. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder actionName(final java.lang.String actionName) {
            this.props.actionName(actionName);
            return this;
        }

        /**
         * The runOrder property for this Action.
         * <p>
         * RunOrder determines the relative order in which multiple Actions in the same Stage execute.
         * <p>
         * Default: 1
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/codepipeline/latest/userguide/reference-pipeline-structure.html">https://docs.aws.amazon.com/codepipeline/latest/userguide/reference-pipeline-structure.html</a>
         * @param runOrder The runOrder property for this Action. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder runOrder(final java.lang.Number runOrder) {
            this.props.runOrder(runOrder);
            return this;
        }

        /**
         * The name of the namespace to use for variables emitted by this action.
         * <p>
         * Default: - a name will be generated, based on the stage and action names,
         * if any of the action's variables were referenced - otherwise,
         * no namespace will be set
         * <p>
         * @return {@code this}
         * @param variablesNamespace The name of the namespace to use for variables emitted by this action. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder variablesNamespace(final java.lang.String variablesNamespace) {
            this.props.variablesNamespace(variablesNamespace);
            return this;
        }

        /**
         * The Role in which context's this Action will be executing in.
         * <p>
         * The Pipeline's Role will assume this Role
         * (the required permissions for that will be granted automatically)
         * right before executing this Action.
         * This Action will be passed into your <code>IAction.bind</code>
         * method in the <code>ActionBindOptions.role</code> property.
         * <p>
         * Default: a new Role will be generated
         * <p>
         * @return {@code this}
         * @param role The Role in which context's this Action will be executing in. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder role(final software.amazon.awscdk.services.iam.IRole role) {
            this.props.role(role);
            return this;
        }

        /**
         * Vulnerability details of your source in the form of a Software Bill of Materials (SBOM) file.
         * <p>
         * @return {@code this}
         * @param output Vulnerability details of your source in the form of a Software Bill of Materials (SBOM) file. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder output(final software.amazon.awscdk.services.codepipeline.Artifact output) {
            this.props.output(output);
            return this;
        }

        /**
         * The number of critical severity vulnerabilities found in your source beyond which CodePipeline should fail the action.
         * <p>
         * Default: - no threshold
         * <p>
         * @return {@code this}
         * @param criticalThreshold The number of critical severity vulnerabilities found in your source beyond which CodePipeline should fail the action. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder criticalThreshold(final java.lang.Number criticalThreshold) {
            this.props.criticalThreshold(criticalThreshold);
            return this;
        }

        /**
         * The number of high severity vulnerabilities found in your source beyond which CodePipeline should fail the action.
         * <p>
         * Default: - no threshold
         * <p>
         * @return {@code this}
         * @param highThreshold The number of high severity vulnerabilities found in your source beyond which CodePipeline should fail the action. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder highThreshold(final java.lang.Number highThreshold) {
            this.props.highThreshold(highThreshold);
            return this;
        }

        /**
         * The number of low severity vulnerabilities found in your source beyond which CodePipeline should fail the action.
         * <p>
         * Default: - no threshold
         * <p>
         * @return {@code this}
         * @param lowThreshold The number of low severity vulnerabilities found in your source beyond which CodePipeline should fail the action. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder lowThreshold(final java.lang.Number lowThreshold) {
            this.props.lowThreshold(lowThreshold);
            return this;
        }

        /**
         * The number of medium severity vulnerabilities found in your source beyond which CodePipeline should fail the action.
         * <p>
         * Default: - no threshold
         * <p>
         * @return {@code this}
         * @param mediumThreshold The number of medium severity vulnerabilities found in your source beyond which CodePipeline should fail the action. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder mediumThreshold(final java.lang.Number mediumThreshold) {
            this.props.mediumThreshold(mediumThreshold);
            return this;
        }

        /**
         * The Amazon ECR repository where the image is pushed.
         * <p>
         * @return {@code this}
         * @param repository The Amazon ECR repository where the image is pushed. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder repository(final software.amazon.awscdk.services.ecr.IRepository repository) {
            this.props.repository(repository);
            return this;
        }

        /**
         * The tag used for the image.
         * <p>
         * Default: 'latest'
         * <p>
         * @return {@code this}
         * @param imageTag The tag used for the image. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder imageTag(final java.lang.String imageTag) {
            this.props.imageTag(imageTag);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.codepipeline.actions.InspectorEcrImageScanAction}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.codepipeline.actions.InspectorEcrImageScanAction build() {
            return new software.amazon.awscdk.services.codepipeline.actions.InspectorEcrImageScanAction(
                this.props.build()
            );
        }
    }
}
