package software.amazon.awscdk.services.codepipeline.actions;

/**
 * A class representing Jenkins providers.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * JenkinsProvider jenkinsProvider = JenkinsProvider.Builder.create(this, "JenkinsProvider")
 *         .providerName("MyJenkinsProvider")
 *         .serverUrl("http://my-jenkins.com:8080")
 *         .version("2")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href=" #import"> #import</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-08-06T18:14:34.634Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codepipeline_actions.JenkinsProvider")
public class JenkinsProvider extends software.amazon.awscdk.services.codepipeline.actions.BaseJenkinsProvider {

    protected JenkinsProvider(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected JenkinsProvider(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public JenkinsProvider(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codepipeline.actions.JenkinsProviderProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Import a Jenkins provider registered either outside the CDK, or in a different CDK Stack.
     * <p>
     * @return a new Construct representing a reference to an existing Jenkins provider
     * @param scope the parent Construct for the new provider. This parameter is required.
     * @param id the identifier of the new provider Construct. This parameter is required.
     * @param attrs the properties used to identify the existing provider. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codepipeline.actions.IJenkinsProvider fromJenkinsProviderAttributes(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codepipeline.actions.JenkinsProviderAttributes attrs) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.codepipeline.actions.JenkinsProvider.class, "fromJenkinsProviderAttributes", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codepipeline.actions.IJenkinsProvider.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(attrs, "attrs is required") });
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getProviderName() {
        return software.amazon.jsii.Kernel.get(this, "providerName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getServerUrl() {
        return software.amazon.jsii.Kernel.get(this, "serverUrl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.codepipeline.actions.JenkinsProvider}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.codepipeline.actions.JenkinsProvider> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.codepipeline.actions.JenkinsProviderProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.codepipeline.actions.JenkinsProviderProps.Builder();
        }

        /**
         * The name of the Jenkins provider that you set in the AWS CodePipeline plugin configuration of your Jenkins project.
         * <p>
         * Example:
         * <p>
         * <blockquote><pre>
         * "MyJenkinsProvider";
         * </pre></blockquote>
         * <p>
         * @return {@code this}
         * @param providerName The name of the Jenkins provider that you set in the AWS CodePipeline plugin configuration of your Jenkins project. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder providerName(final java.lang.String providerName) {
            this.props.providerName(providerName);
            return this;
        }

        /**
         * The base URL of your Jenkins server.
         * <p>
         * Example:
         * <p>
         * <blockquote><pre>
         * "http://myjenkins.com:8080";
         * </pre></blockquote>
         * <p>
         * @return {@code this}
         * @param serverUrl The base URL of your Jenkins server. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serverUrl(final java.lang.String serverUrl) {
            this.props.serverUrl(serverUrl);
            return this;
        }

        /**
         * Whether to immediately register a Jenkins Provider for the build category.
         * <p>
         * The Provider will always be registered if you create a <code>JenkinsAction</code>.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param forBuild Whether to immediately register a Jenkins Provider for the build category. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder forBuild(final java.lang.Boolean forBuild) {
            this.props.forBuild(forBuild);
            return this;
        }

        /**
         * Whether to immediately register a Jenkins Provider for the test category.
         * <p>
         * The Provider will always be registered if you create a <code>JenkinsTestAction</code>.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param forTest Whether to immediately register a Jenkins Provider for the test category. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder forTest(final java.lang.Boolean forTest) {
            this.props.forTest(forTest);
            return this;
        }

        /**
         * The version of your provider.
         * <p>
         * Default: '1'
         * <p>
         * @return {@code this}
         * @param version The version of your provider. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder version(final java.lang.String version) {
            this.props.version(version);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.codepipeline.actions.JenkinsProvider}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.codepipeline.actions.JenkinsProvider build() {
            return new software.amazon.awscdk.services.codepipeline.actions.JenkinsProvider(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
