package software.amazon.awscdk.services.cognito;

/**
 * Configuration for Cognito sending emails via Amazon SES.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * UserPool.Builder.create(this, "myuserpool")
 *         .email(UserPoolEmail.withSES(UserPoolSESOptions.builder()
 *                 .fromEmail("noreply&#64;myawesomeapp.com")
 *                 .fromName("Awesome App")
 *                 .replyTo("support&#64;myawesomeapp.com")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-08-06T18:14:34.858Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cognito.UserPoolSESOptions")
@software.amazon.jsii.Jsii.Proxy(UserPoolSESOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface UserPoolSESOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * The verified Amazon SES email address that Cognito should use to send emails.
     * <p>
     * The email address used must be a verified email address
     * in Amazon SES and must be configured to allow Cognito to
     * send emails.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-email.html">https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-email.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getFromEmail();

    /**
     * The name of a configuration set in Amazon SES that should be applied to emails sent via Cognito.
     * <p>
     * Default: - no configuration set
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpool-emailconfiguration.html#cfn-cognito-userpool-emailconfiguration-configurationset">https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpool-emailconfiguration.html#cfn-cognito-userpool-emailconfiguration-configurationset</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getConfigurationSetName() {
        return null;
    }

    /**
     * An optional name that should be used as the sender's name along with the email.
     * <p>
     * Default: - no name
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getFromName() {
        return null;
    }

    /**
     * The destination to which the receiver of the email should reply to.
     * <p>
     * Default: - same as the fromEmail
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getReplyTo() {
        return null;
    }

    /**
     * Required if the UserPool region is different than the SES region.
     * <p>
     * If sending emails with a Amazon SES verified email address,
     * and the region that SES is configured is different than the
     * region in which the UserPool is deployed, you must specify that
     * region here.
     * <p>
     * Default: - The same region as the Cognito UserPool
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getSesRegion() {
        return null;
    }

    /**
     * SES Verified custom domain to be used to verify the identity.
     * <p>
     * Default: - no domain
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getSesVerifiedDomain() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link UserPoolSESOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link UserPoolSESOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<UserPoolSESOptions> {
        java.lang.String fromEmail;
        java.lang.String configurationSetName;
        java.lang.String fromName;
        java.lang.String replyTo;
        java.lang.String sesRegion;
        java.lang.String sesVerifiedDomain;

        /**
         * Sets the value of {@link UserPoolSESOptions#getFromEmail}
         * @param fromEmail The verified Amazon SES email address that Cognito should use to send emails. This parameter is required.
         *                  The email address used must be a verified email address
         *                  in Amazon SES and must be configured to allow Cognito to
         *                  send emails.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fromEmail(java.lang.String fromEmail) {
            this.fromEmail = fromEmail;
            return this;
        }

        /**
         * Sets the value of {@link UserPoolSESOptions#getConfigurationSetName}
         * @param configurationSetName The name of a configuration set in Amazon SES that should be applied to emails sent via Cognito.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder configurationSetName(java.lang.String configurationSetName) {
            this.configurationSetName = configurationSetName;
            return this;
        }

        /**
         * Sets the value of {@link UserPoolSESOptions#getFromName}
         * @param fromName An optional name that should be used as the sender's name along with the email.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fromName(java.lang.String fromName) {
            this.fromName = fromName;
            return this;
        }

        /**
         * Sets the value of {@link UserPoolSESOptions#getReplyTo}
         * @param replyTo The destination to which the receiver of the email should reply to.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder replyTo(java.lang.String replyTo) {
            this.replyTo = replyTo;
            return this;
        }

        /**
         * Sets the value of {@link UserPoolSESOptions#getSesRegion}
         * @param sesRegion Required if the UserPool region is different than the SES region.
         *                  If sending emails with a Amazon SES verified email address,
         *                  and the region that SES is configured is different than the
         *                  region in which the UserPool is deployed, you must specify that
         *                  region here.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sesRegion(java.lang.String sesRegion) {
            this.sesRegion = sesRegion;
            return this;
        }

        /**
         * Sets the value of {@link UserPoolSESOptions#getSesVerifiedDomain}
         * @param sesVerifiedDomain SES Verified custom domain to be used to verify the identity.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sesVerifiedDomain(java.lang.String sesVerifiedDomain) {
            this.sesVerifiedDomain = sesVerifiedDomain;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link UserPoolSESOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public UserPoolSESOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link UserPoolSESOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements UserPoolSESOptions {
        private final java.lang.String fromEmail;
        private final java.lang.String configurationSetName;
        private final java.lang.String fromName;
        private final java.lang.String replyTo;
        private final java.lang.String sesRegion;
        private final java.lang.String sesVerifiedDomain;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.fromEmail = software.amazon.jsii.Kernel.get(this, "fromEmail", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.configurationSetName = software.amazon.jsii.Kernel.get(this, "configurationSetName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.fromName = software.amazon.jsii.Kernel.get(this, "fromName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.replyTo = software.amazon.jsii.Kernel.get(this, "replyTo", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.sesRegion = software.amazon.jsii.Kernel.get(this, "sesRegion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.sesVerifiedDomain = software.amazon.jsii.Kernel.get(this, "sesVerifiedDomain", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.fromEmail = java.util.Objects.requireNonNull(builder.fromEmail, "fromEmail is required");
            this.configurationSetName = builder.configurationSetName;
            this.fromName = builder.fromName;
            this.replyTo = builder.replyTo;
            this.sesRegion = builder.sesRegion;
            this.sesVerifiedDomain = builder.sesVerifiedDomain;
        }

        @Override
        public final java.lang.String getFromEmail() {
            return this.fromEmail;
        }

        @Override
        public final java.lang.String getConfigurationSetName() {
            return this.configurationSetName;
        }

        @Override
        public final java.lang.String getFromName() {
            return this.fromName;
        }

        @Override
        public final java.lang.String getReplyTo() {
            return this.replyTo;
        }

        @Override
        public final java.lang.String getSesRegion() {
            return this.sesRegion;
        }

        @Override
        public final java.lang.String getSesVerifiedDomain() {
            return this.sesVerifiedDomain;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("fromEmail", om.valueToTree(this.getFromEmail()));
            if (this.getConfigurationSetName() != null) {
                data.set("configurationSetName", om.valueToTree(this.getConfigurationSetName()));
            }
            if (this.getFromName() != null) {
                data.set("fromName", om.valueToTree(this.getFromName()));
            }
            if (this.getReplyTo() != null) {
                data.set("replyTo", om.valueToTree(this.getReplyTo()));
            }
            if (this.getSesRegion() != null) {
                data.set("sesRegion", om.valueToTree(this.getSesRegion()));
            }
            if (this.getSesVerifiedDomain() != null) {
                data.set("sesVerifiedDomain", om.valueToTree(this.getSesVerifiedDomain()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cognito.UserPoolSESOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            UserPoolSESOptions.Jsii$Proxy that = (UserPoolSESOptions.Jsii$Proxy) o;

            if (!fromEmail.equals(that.fromEmail)) return false;
            if (this.configurationSetName != null ? !this.configurationSetName.equals(that.configurationSetName) : that.configurationSetName != null) return false;
            if (this.fromName != null ? !this.fromName.equals(that.fromName) : that.fromName != null) return false;
            if (this.replyTo != null ? !this.replyTo.equals(that.replyTo) : that.replyTo != null) return false;
            if (this.sesRegion != null ? !this.sesRegion.equals(that.sesRegion) : that.sesRegion != null) return false;
            return this.sesVerifiedDomain != null ? this.sesVerifiedDomain.equals(that.sesVerifiedDomain) : that.sesVerifiedDomain == null;
        }

        @Override
        public final int hashCode() {
            int result = this.fromEmail.hashCode();
            result = 31 * result + (this.configurationSetName != null ? this.configurationSetName.hashCode() : 0);
            result = 31 * result + (this.fromName != null ? this.fromName.hashCode() : 0);
            result = 31 * result + (this.replyTo != null ? this.replyTo.hashCode() : 0);
            result = 31 * result + (this.sesRegion != null ? this.sesRegion.hashCode() : 0);
            result = 31 * result + (this.sesVerifiedDomain != null ? this.sesVerifiedDomain.hashCode() : 0);
            return result;
        }
    }
}
