package software.amazon.awscdk.services.cognito.identitypool;

/**
 * Login Provider for identity federation using Twitter credentials.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * IdentityPool.Builder.create(this, "myidentitypool")
 *         .identityPoolName("myidentitypool")
 *         .authenticationProviders(IdentityPoolAuthenticationProviders.builder()
 *                 .amazon(IdentityPoolAmazonLoginProvider.builder()
 *                         .appId("amzn1.application.12312k3j234j13rjiwuenf")
 *                         .build())
 *                 .facebook(IdentityPoolFacebookLoginProvider.builder()
 *                         .appId("1234567890123")
 *                         .build())
 *                 .google(IdentityPoolGoogleLoginProvider.builder()
 *                         .clientId("12345678012.apps.googleusercontent.com")
 *                         .build())
 *                 .apple(IdentityPoolAppleLoginProvider.builder()
 *                         .servicesId("com.myappleapp.auth")
 *                         .build())
 *                 .twitter(IdentityPoolTwitterLoginProvider.builder()
 *                         .consumerKey("my-twitter-id")
 *                         .consumerSecret("my-twitter-secret")
 *                         .build())
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-08-06T18:14:34.882Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cognito_identitypool.IdentityPoolTwitterLoginProvider")
@software.amazon.jsii.Jsii.Proxy(IdentityPoolTwitterLoginProvider.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface IdentityPoolTwitterLoginProvider extends software.amazon.jsii.JsiiSerializable {

    /**
     * Consumer key for Twitter identity federation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getConsumerKey();

    /**
     * Consumer secret for identity federation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getConsumerSecret();

    /**
     * @return a {@link Builder} of {@link IdentityPoolTwitterLoginProvider}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link IdentityPoolTwitterLoginProvider}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<IdentityPoolTwitterLoginProvider> {
        java.lang.String consumerKey;
        java.lang.String consumerSecret;

        /**
         * Sets the value of {@link IdentityPoolTwitterLoginProvider#getConsumerKey}
         * @param consumerKey Consumer key for Twitter identity federation. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder consumerKey(java.lang.String consumerKey) {
            this.consumerKey = consumerKey;
            return this;
        }

        /**
         * Sets the value of {@link IdentityPoolTwitterLoginProvider#getConsumerSecret}
         * @param consumerSecret Consumer secret for identity federation. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder consumerSecret(java.lang.String consumerSecret) {
            this.consumerSecret = consumerSecret;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link IdentityPoolTwitterLoginProvider}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public IdentityPoolTwitterLoginProvider build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link IdentityPoolTwitterLoginProvider}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements IdentityPoolTwitterLoginProvider {
        private final java.lang.String consumerKey;
        private final java.lang.String consumerSecret;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.consumerKey = software.amazon.jsii.Kernel.get(this, "consumerKey", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.consumerSecret = software.amazon.jsii.Kernel.get(this, "consumerSecret", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.consumerKey = java.util.Objects.requireNonNull(builder.consumerKey, "consumerKey is required");
            this.consumerSecret = java.util.Objects.requireNonNull(builder.consumerSecret, "consumerSecret is required");
        }

        @Override
        public final java.lang.String getConsumerKey() {
            return this.consumerKey;
        }

        @Override
        public final java.lang.String getConsumerSecret() {
            return this.consumerSecret;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("consumerKey", om.valueToTree(this.getConsumerKey()));
            data.set("consumerSecret", om.valueToTree(this.getConsumerSecret()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cognito_identitypool.IdentityPoolTwitterLoginProvider"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            IdentityPoolTwitterLoginProvider.Jsii$Proxy that = (IdentityPoolTwitterLoginProvider.Jsii$Proxy) o;

            if (!consumerKey.equals(that.consumerKey)) return false;
            return this.consumerSecret.equals(that.consumerSecret);
        }

        @Override
        public final int hashCode() {
            int result = this.consumerKey.hashCode();
            result = 31 * result + (this.consumerSecret.hashCode());
            return result;
        }
    }
}
