package software.amazon.awscdk.services.config;

/**
 * Checks whether the active access keys are rotated within the number of days specified in <code>maxAge</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // compliant if access keys have been rotated within the last 90 days
 * // compliant if access keys have been rotated within the last 90 days
 * new AccessKeysRotated(this, "AccessKeyRotated");
 * </pre></blockquote>
 * <p>
 * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/access-keys-rotated.html">https://docs.aws.amazon.com/config/latest/developerguide/access-keys-rotated.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-08-06T18:14:34.901Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_config.AccessKeysRotated")
public class AccessKeysRotated extends software.amazon.awscdk.services.config.ManagedRule {

    protected AccessKeysRotated(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected AccessKeysRotated(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        PROPERTY_INJECTION_ID = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.AccessKeysRotated.class, "PROPERTY_INJECTION_ID", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public AccessKeysRotated(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.config.AccessKeysRotatedProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public AccessKeysRotated(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Uniquely identifies this class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String PROPERTY_INJECTION_ID;

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.config.AccessKeysRotated}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.config.AccessKeysRotated> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.services.config.AccessKeysRotatedProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * A name for the AWS Config rule.
         * <p>
         * Default: - CloudFormation generated name
         * <p>
         * @return {@code this}
         * @param configRuleName A name for the AWS Config rule. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder configRuleName(final java.lang.String configRuleName) {
            this.props().configRuleName(configRuleName);
            return this;
        }

        /**
         * A description about this AWS Config rule.
         * <p>
         * Default: - No description
         * <p>
         * @return {@code this}
         * @param description A description about this AWS Config rule. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props().description(description);
            return this;
        }

        /**
         * The modes the AWS Config rule can be evaluated in.
         * <p>
         * The valid values are distinct objects.
         * <p>
         * Default: - Detective evaluation mode only
         * <p>
         * @return {@code this}
         * @param evaluationModes The modes the AWS Config rule can be evaluated in. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder evaluationModes(final software.amazon.awscdk.services.config.EvaluationMode evaluationModes) {
            this.props().evaluationModes(evaluationModes);
            return this;
        }

        /**
         * Input parameter values that are passed to the AWS Config rule.
         * <p>
         * Default: - No input parameters
         * <p>
         * @return {@code this}
         * @param inputParameters Input parameter values that are passed to the AWS Config rule. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder inputParameters(final java.util.Map<java.lang.String, ? extends java.lang.Object> inputParameters) {
            this.props().inputParameters(inputParameters);
            return this;
        }

        /**
         * The maximum frequency at which the AWS Config rule runs evaluations.
         * <p>
         * Default: MaximumExecutionFrequency.TWENTY_FOUR_HOURS
         * <p>
         * @return {@code this}
         * @param maximumExecutionFrequency The maximum frequency at which the AWS Config rule runs evaluations. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maximumExecutionFrequency(final software.amazon.awscdk.services.config.MaximumExecutionFrequency maximumExecutionFrequency) {
            this.props().maximumExecutionFrequency(maximumExecutionFrequency);
            return this;
        }

        /**
         * Defines which resources trigger an evaluation for an AWS Config rule.
         * <p>
         * Default: - evaluations for the rule are triggered when any resource in the recording group changes.
         * <p>
         * @return {@code this}
         * @param ruleScope Defines which resources trigger an evaluation for an AWS Config rule. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ruleScope(final software.amazon.awscdk.services.config.RuleScope ruleScope) {
            this.props().ruleScope(ruleScope);
            return this;
        }

        /**
         * The maximum number of days within which the access keys must be rotated.
         * <p>
         * Default: Duration.days(90)
         * <p>
         * @return {@code this}
         * @param maxAge The maximum number of days within which the access keys must be rotated. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxAge(final software.amazon.awscdk.Duration maxAge) {
            this.props().maxAge(maxAge);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.config.AccessKeysRotated}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.config.AccessKeysRotated build() {
            return new software.amazon.awscdk.services.config.AccessKeysRotated(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.config.AccessKeysRotatedProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.config.AccessKeysRotatedProps.Builder();
            }
            return this.props;
        }
    }
}
