package software.amazon.awscdk.services.config;

/**
 * Construction properties for a CloudFormationStackDriftDetectionCheck.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // compliant if stack's status is 'IN_SYNC'
 * // non-compliant if the stack's drift status is 'DRIFTED'
 * // compliant if stack's status is 'IN_SYNC'
 * // non-compliant if the stack's drift status is 'DRIFTED'
 * CloudFormationStackDriftDetectionCheck.Builder.create(this, "Drift")
 *         .ownStackOnly(true)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-08-06T18:14:34.957Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_config.CloudFormationStackDriftDetectionCheckProps")
@software.amazon.jsii.Jsii.Proxy(CloudFormationStackDriftDetectionCheckProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CloudFormationStackDriftDetectionCheckProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.config.RuleProps {

    /**
     * Whether to check only the stack where this rule is deployed.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getOwnStackOnly() {
        return null;
    }

    /**
     * The IAM role to use for this rule.
     * <p>
     * It must have permissions to detect drift
     * for AWS CloudFormation stacks. Ensure to attach <code>config.amazonaws.com</code> trusted
     * permissions and <code>ReadOnlyAccess</code> policy permissions. For specific policy permissions,
     * refer to https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift.html.
     * <p>
     * Default: - A role will be created
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.IRole getRole() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CloudFormationStackDriftDetectionCheckProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CloudFormationStackDriftDetectionCheckProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CloudFormationStackDriftDetectionCheckProps> {
        java.lang.Boolean ownStackOnly;
        software.amazon.awscdk.services.iam.IRole role;
        java.lang.String configRuleName;
        java.lang.String description;
        software.amazon.awscdk.services.config.EvaluationMode evaluationModes;
        java.util.Map<java.lang.String, java.lang.Object> inputParameters;
        software.amazon.awscdk.services.config.MaximumExecutionFrequency maximumExecutionFrequency;
        software.amazon.awscdk.services.config.RuleScope ruleScope;

        /**
         * Sets the value of {@link CloudFormationStackDriftDetectionCheckProps#getOwnStackOnly}
         * @param ownStackOnly Whether to check only the stack where this rule is deployed.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ownStackOnly(java.lang.Boolean ownStackOnly) {
            this.ownStackOnly = ownStackOnly;
            return this;
        }

        /**
         * Sets the value of {@link CloudFormationStackDriftDetectionCheckProps#getRole}
         * @param role The IAM role to use for this rule.
         *             It must have permissions to detect drift
         *             for AWS CloudFormation stacks. Ensure to attach <code>config.amazonaws.com</code> trusted
         *             permissions and <code>ReadOnlyAccess</code> policy permissions. For specific policy permissions,
         *             refer to https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift.html.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder role(software.amazon.awscdk.services.iam.IRole role) {
            this.role = role;
            return this;
        }

        /**
         * Sets the value of {@link CloudFormationStackDriftDetectionCheckProps#getConfigRuleName}
         * @param configRuleName A name for the AWS Config rule.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder configRuleName(java.lang.String configRuleName) {
            this.configRuleName = configRuleName;
            return this;
        }

        /**
         * Sets the value of {@link CloudFormationStackDriftDetectionCheckProps#getDescription}
         * @param description A description about this AWS Config rule.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CloudFormationStackDriftDetectionCheckProps#getEvaluationModes}
         * @param evaluationModes The modes the AWS Config rule can be evaluated in.
         *                        The valid values are distinct objects.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder evaluationModes(software.amazon.awscdk.services.config.EvaluationMode evaluationModes) {
            this.evaluationModes = evaluationModes;
            return this;
        }

        /**
         * Sets the value of {@link CloudFormationStackDriftDetectionCheckProps#getInputParameters}
         * @param inputParameters Input parameter values that are passed to the AWS Config rule.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder inputParameters(java.util.Map<java.lang.String, ? extends java.lang.Object> inputParameters) {
            this.inputParameters = (java.util.Map<java.lang.String, java.lang.Object>)inputParameters;
            return this;
        }

        /**
         * Sets the value of {@link CloudFormationStackDriftDetectionCheckProps#getMaximumExecutionFrequency}
         * @param maximumExecutionFrequency The maximum frequency at which the AWS Config rule runs evaluations.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maximumExecutionFrequency(software.amazon.awscdk.services.config.MaximumExecutionFrequency maximumExecutionFrequency) {
            this.maximumExecutionFrequency = maximumExecutionFrequency;
            return this;
        }

        /**
         * Sets the value of {@link CloudFormationStackDriftDetectionCheckProps#getRuleScope}
         * @param ruleScope Defines which resources trigger an evaluation for an AWS Config rule.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ruleScope(software.amazon.awscdk.services.config.RuleScope ruleScope) {
            this.ruleScope = ruleScope;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CloudFormationStackDriftDetectionCheckProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CloudFormationStackDriftDetectionCheckProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CloudFormationStackDriftDetectionCheckProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CloudFormationStackDriftDetectionCheckProps {
        private final java.lang.Boolean ownStackOnly;
        private final software.amazon.awscdk.services.iam.IRole role;
        private final java.lang.String configRuleName;
        private final java.lang.String description;
        private final software.amazon.awscdk.services.config.EvaluationMode evaluationModes;
        private final java.util.Map<java.lang.String, java.lang.Object> inputParameters;
        private final software.amazon.awscdk.services.config.MaximumExecutionFrequency maximumExecutionFrequency;
        private final software.amazon.awscdk.services.config.RuleScope ruleScope;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.ownStackOnly = software.amazon.jsii.Kernel.get(this, "ownStackOnly", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.role = software.amazon.jsii.Kernel.get(this, "role", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
            this.configRuleName = software.amazon.jsii.Kernel.get(this, "configRuleName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.evaluationModes = software.amazon.jsii.Kernel.get(this, "evaluationModes", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.EvaluationMode.class));
            this.inputParameters = software.amazon.jsii.Kernel.get(this, "inputParameters", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)));
            this.maximumExecutionFrequency = software.amazon.jsii.Kernel.get(this, "maximumExecutionFrequency", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.MaximumExecutionFrequency.class));
            this.ruleScope = software.amazon.jsii.Kernel.get(this, "ruleScope", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.RuleScope.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.ownStackOnly = builder.ownStackOnly;
            this.role = builder.role;
            this.configRuleName = builder.configRuleName;
            this.description = builder.description;
            this.evaluationModes = builder.evaluationModes;
            this.inputParameters = (java.util.Map<java.lang.String, java.lang.Object>)builder.inputParameters;
            this.maximumExecutionFrequency = builder.maximumExecutionFrequency;
            this.ruleScope = builder.ruleScope;
        }

        @Override
        public final java.lang.Boolean getOwnStackOnly() {
            return this.ownStackOnly;
        }

        @Override
        public final software.amazon.awscdk.services.iam.IRole getRole() {
            return this.role;
        }

        @Override
        public final java.lang.String getConfigRuleName() {
            return this.configRuleName;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final software.amazon.awscdk.services.config.EvaluationMode getEvaluationModes() {
            return this.evaluationModes;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.Object> getInputParameters() {
            return this.inputParameters;
        }

        @Override
        public final software.amazon.awscdk.services.config.MaximumExecutionFrequency getMaximumExecutionFrequency() {
            return this.maximumExecutionFrequency;
        }

        @Override
        public final software.amazon.awscdk.services.config.RuleScope getRuleScope() {
            return this.ruleScope;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getOwnStackOnly() != null) {
                data.set("ownStackOnly", om.valueToTree(this.getOwnStackOnly()));
            }
            if (this.getRole() != null) {
                data.set("role", om.valueToTree(this.getRole()));
            }
            if (this.getConfigRuleName() != null) {
                data.set("configRuleName", om.valueToTree(this.getConfigRuleName()));
            }
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getEvaluationModes() != null) {
                data.set("evaluationModes", om.valueToTree(this.getEvaluationModes()));
            }
            if (this.getInputParameters() != null) {
                data.set("inputParameters", om.valueToTree(this.getInputParameters()));
            }
            if (this.getMaximumExecutionFrequency() != null) {
                data.set("maximumExecutionFrequency", om.valueToTree(this.getMaximumExecutionFrequency()));
            }
            if (this.getRuleScope() != null) {
                data.set("ruleScope", om.valueToTree(this.getRuleScope()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_config.CloudFormationStackDriftDetectionCheckProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CloudFormationStackDriftDetectionCheckProps.Jsii$Proxy that = (CloudFormationStackDriftDetectionCheckProps.Jsii$Proxy) o;

            if (this.ownStackOnly != null ? !this.ownStackOnly.equals(that.ownStackOnly) : that.ownStackOnly != null) return false;
            if (this.role != null ? !this.role.equals(that.role) : that.role != null) return false;
            if (this.configRuleName != null ? !this.configRuleName.equals(that.configRuleName) : that.configRuleName != null) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.evaluationModes != null ? !this.evaluationModes.equals(that.evaluationModes) : that.evaluationModes != null) return false;
            if (this.inputParameters != null ? !this.inputParameters.equals(that.inputParameters) : that.inputParameters != null) return false;
            if (this.maximumExecutionFrequency != null ? !this.maximumExecutionFrequency.equals(that.maximumExecutionFrequency) : that.maximumExecutionFrequency != null) return false;
            return this.ruleScope != null ? this.ruleScope.equals(that.ruleScope) : that.ruleScope == null;
        }

        @Override
        public final int hashCode() {
            int result = this.ownStackOnly != null ? this.ownStackOnly.hashCode() : 0;
            result = 31 * result + (this.role != null ? this.role.hashCode() : 0);
            result = 31 * result + (this.configRuleName != null ? this.configRuleName.hashCode() : 0);
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.evaluationModes != null ? this.evaluationModes.hashCode() : 0);
            result = 31 * result + (this.inputParameters != null ? this.inputParameters.hashCode() : 0);
            result = 31 * result + (this.maximumExecutionFrequency != null ? this.maximumExecutionFrequency.hashCode() : 0);
            result = 31 * result + (this.ruleScope != null ? this.ruleScope.hashCode() : 0);
            return result;
        }
    }
}
