package software.amazon.awscdk.services.databrew;

/**
 * Specifies a new DataBrew job.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.databrew.*;
 * CfnJob cfnJob = CfnJob.Builder.create(this, "MyCfnJob")
 *         .name("name")
 *         .roleArn("roleArn")
 *         .type("type")
 *         // the properties below are optional
 *         .databaseOutputs(List.of(DatabaseOutputProperty.builder()
 *                 .databaseOptions(DatabaseTableOutputOptionsProperty.builder()
 *                         .tableName("tableName")
 *                         // the properties below are optional
 *                         .tempDirectory(S3LocationProperty.builder()
 *                                 .bucket("bucket")
 *                                 // the properties below are optional
 *                                 .bucketOwner("bucketOwner")
 *                                 .key("key")
 *                                 .build())
 *                         .build())
 *                 .glueConnectionName("glueConnectionName")
 *                 // the properties below are optional
 *                 .databaseOutputMode("databaseOutputMode")
 *                 .build()))
 *         .dataCatalogOutputs(List.of(DataCatalogOutputProperty.builder()
 *                 .databaseName("databaseName")
 *                 .tableName("tableName")
 *                 // the properties below are optional
 *                 .catalogId("catalogId")
 *                 .databaseOptions(DatabaseTableOutputOptionsProperty.builder()
 *                         .tableName("tableName")
 *                         // the properties below are optional
 *                         .tempDirectory(S3LocationProperty.builder()
 *                                 .bucket("bucket")
 *                                 // the properties below are optional
 *                                 .bucketOwner("bucketOwner")
 *                                 .key("key")
 *                                 .build())
 *                         .build())
 *                 .overwrite(false)
 *                 .s3Options(S3TableOutputOptionsProperty.builder()
 *                         .location(S3LocationProperty.builder()
 *                                 .bucket("bucket")
 *                                 // the properties below are optional
 *                                 .bucketOwner("bucketOwner")
 *                                 .key("key")
 *                                 .build())
 *                         .build())
 *                 .build()))
 *         .datasetName("datasetName")
 *         .encryptionKeyArn("encryptionKeyArn")
 *         .encryptionMode("encryptionMode")
 *         .jobSample(JobSampleProperty.builder()
 *                 .mode("mode")
 *                 .size(123)
 *                 .build())
 *         .logSubscription("logSubscription")
 *         .maxCapacity(123)
 *         .maxRetries(123)
 *         .outputLocation(OutputLocationProperty.builder()
 *                 .bucket("bucket")
 *                 // the properties below are optional
 *                 .bucketOwner("bucketOwner")
 *                 .key("key")
 *                 .build())
 *         .outputs(List.of(OutputProperty.builder()
 *                 .location(S3LocationProperty.builder()
 *                         .bucket("bucket")
 *                         // the properties below are optional
 *                         .bucketOwner("bucketOwner")
 *                         .key("key")
 *                         .build())
 *                 // the properties below are optional
 *                 .compressionFormat("compressionFormat")
 *                 .format("format")
 *                 .formatOptions(OutputFormatOptionsProperty.builder()
 *                         .csv(CsvOutputOptionsProperty.builder()
 *                                 .delimiter("delimiter")
 *                                 .build())
 *                         .build())
 *                 .maxOutputFiles(123)
 *                 .overwrite(false)
 *                 .partitionColumns(List.of("partitionColumns"))
 *                 .build()))
 *         .profileConfiguration(ProfileConfigurationProperty.builder()
 *                 .columnStatisticsConfigurations(List.of(ColumnStatisticsConfigurationProperty.builder()
 *                         .statistics(StatisticsConfigurationProperty.builder()
 *                                 .includedStatistics(List.of("includedStatistics"))
 *                                 .overrides(List.of(StatisticOverrideProperty.builder()
 *                                         .parameters(Map.of(
 *                                                 "parametersKey", "parameters"))
 *                                         .statistic("statistic")
 *                                         .build()))
 *                                 .build())
 *                         // the properties below are optional
 *                         .selectors(List.of(ColumnSelectorProperty.builder()
 *                                 .name("name")
 *                                 .regex("regex")
 *                                 .build()))
 *                         .build()))
 *                 .datasetStatisticsConfiguration(StatisticsConfigurationProperty.builder()
 *                         .includedStatistics(List.of("includedStatistics"))
 *                         .overrides(List.of(StatisticOverrideProperty.builder()
 *                                 .parameters(Map.of(
 *                                         "parametersKey", "parameters"))
 *                                 .statistic("statistic")
 *                                 .build()))
 *                         .build())
 *                 .entityDetectorConfiguration(EntityDetectorConfigurationProperty.builder()
 *                         .entityTypes(List.of("entityTypes"))
 *                         // the properties below are optional
 *                         .allowedStatistics(AllowedStatisticsProperty.builder()
 *                                 .statistics(List.of("statistics"))
 *                                 .build())
 *                         .build())
 *                 .profileColumns(List.of(ColumnSelectorProperty.builder()
 *                         .name("name")
 *                         .regex("regex")
 *                         .build()))
 *                 .build())
 *         .projectName("projectName")
 *         .recipe(RecipeProperty.builder()
 *                 .name("name")
 *                 // the properties below are optional
 *                 .version("version")
 *                 .build())
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .timeout(123)
 *         .validationConfigurations(List.of(ValidationConfigurationProperty.builder()
 *                 .rulesetArn("rulesetArn")
 *                 // the properties below are optional
 *                 .validationMode("validationMode")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-databrew-job.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-databrew-job.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-08-06T18:14:35.209Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_databrew.CfnJob")
public class CfnJob extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.ITaggable {

    protected CfnJob(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnJob(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.databrew.CfnJob.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnJob(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.databrew.CfnJobProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * The unique name of the job.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The unique name of the job.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "name", java.util.Objects.requireNonNull(value, "name is required"));
    }

    /**
     * The Amazon Resource Name (ARN) of the role to be assumed for this job.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getRoleArn() {
        return software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Amazon Resource Name (ARN) of the role to be assumed for this job.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRoleArn(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "roleArn", java.util.Objects.requireNonNull(value, "roleArn is required"));
    }

    /**
     * The job type of the job, which must be one of the following:.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getType() {
        return software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The job type of the job, which must be one of the following:.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setType(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "type", java.util.Objects.requireNonNull(value, "type is required"));
    }

    /**
     * Represents a list of JDBC database output objects which defines the output destination for a DataBrew recipe job to write into.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getDatabaseOutputs() {
        return software.amazon.jsii.Kernel.get(this, "databaseOutputs", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Represents a list of JDBC database output objects which defines the output destination for a DataBrew recipe job to write into.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDatabaseOutputs(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "databaseOutputs", value);
    }

    /**
     * Represents a list of JDBC database output objects which defines the output destination for a DataBrew recipe job to write into.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDatabaseOutputs(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.databrew.CfnJob.DatabaseOutputProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.databrew.CfnJob.DatabaseOutputProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "databaseOutputs", value);
    }

    /**
     * One or more artifacts that represent the AWS Glue Data Catalog output from running the job.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getDataCatalogOutputs() {
        return software.amazon.jsii.Kernel.get(this, "dataCatalogOutputs", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * One or more artifacts that represent the AWS Glue Data Catalog output from running the job.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDataCatalogOutputs(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "dataCatalogOutputs", value);
    }

    /**
     * One or more artifacts that represent the AWS Glue Data Catalog output from running the job.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDataCatalogOutputs(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.databrew.CfnJob.DataCatalogOutputProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.databrew.CfnJob.DataCatalogOutputProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "dataCatalogOutputs", value);
    }

    /**
     * A dataset that the job is to process.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDatasetName() {
        return software.amazon.jsii.Kernel.get(this, "datasetName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A dataset that the job is to process.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDatasetName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "datasetName", value);
    }

    /**
     * The Amazon Resource Name (ARN) of an encryption key that is used to protect the job output.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getEncryptionKeyArn() {
        return software.amazon.jsii.Kernel.get(this, "encryptionKeyArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Amazon Resource Name (ARN) of an encryption key that is used to protect the job output.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEncryptionKeyArn(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "encryptionKeyArn", value);
    }

    /**
     * The encryption mode for the job, which can be one of the following:.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getEncryptionMode() {
        return software.amazon.jsii.Kernel.get(this, "encryptionMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The encryption mode for the job, which can be one of the following:.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEncryptionMode(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "encryptionMode", value);
    }

    /**
     * A sample configuration for profile jobs only, which determines the number of rows on which the profile job is run.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getJobSample() {
        return software.amazon.jsii.Kernel.get(this, "jobSample", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A sample configuration for profile jobs only, which determines the number of rows on which the profile job is run.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setJobSample(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "jobSample", value);
    }

    /**
     * A sample configuration for profile jobs only, which determines the number of rows on which the profile job is run.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setJobSample(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.databrew.CfnJob.JobSampleProperty value) {
        software.amazon.jsii.Kernel.set(this, "jobSample", value);
    }

    /**
     * The current status of Amazon CloudWatch logging for the job.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getLogSubscription() {
        return software.amazon.jsii.Kernel.get(this, "logSubscription", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The current status of Amazon CloudWatch logging for the job.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLogSubscription(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "logSubscription", value);
    }

    /**
     * The maximum number of nodes that can be consumed when the job processes data.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getMaxCapacity() {
        return software.amazon.jsii.Kernel.get(this, "maxCapacity", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The maximum number of nodes that can be consumed when the job processes data.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMaxCapacity(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "maxCapacity", value);
    }

    /**
     * The maximum number of times to retry the job after a job run fails.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getMaxRetries() {
        return software.amazon.jsii.Kernel.get(this, "maxRetries", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The maximum number of times to retry the job after a job run fails.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMaxRetries(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "maxRetries", value);
    }

    /**
     * The location in Amazon S3 where the job writes its output.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getOutputLocation() {
        return software.amazon.jsii.Kernel.get(this, "outputLocation", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The location in Amazon S3 where the job writes its output.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setOutputLocation(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "outputLocation", value);
    }

    /**
     * The location in Amazon S3 where the job writes its output.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setOutputLocation(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.databrew.CfnJob.OutputLocationProperty value) {
        software.amazon.jsii.Kernel.set(this, "outputLocation", value);
    }

    /**
     * One or more artifacts that represent output from running the job.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getOutputs() {
        return software.amazon.jsii.Kernel.get(this, "outputs", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * One or more artifacts that represent output from running the job.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setOutputs(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "outputs", value);
    }

    /**
     * One or more artifacts that represent output from running the job.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setOutputs(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.databrew.CfnJob.OutputProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.databrew.CfnJob.OutputProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "outputs", value);
    }

    /**
     * Configuration for profile jobs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getProfileConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "profileConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Configuration for profile jobs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setProfileConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "profileConfiguration", value);
    }

    /**
     * Configuration for profile jobs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setProfileConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.databrew.CfnJob.ProfileConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "profileConfiguration", value);
    }

    /**
     * The name of the project that the job is associated with.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getProjectName() {
        return software.amazon.jsii.Kernel.get(this, "projectName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the project that the job is associated with.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setProjectName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "projectName", value);
    }

    /**
     * A series of data transformation steps that the job runs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getRecipe() {
        return software.amazon.jsii.Kernel.get(this, "recipe", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A series of data transformation steps that the job runs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRecipe(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "recipe", value);
    }

    /**
     * A series of data transformation steps that the job runs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRecipe(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.databrew.CfnJob.RecipeProperty value) {
        software.amazon.jsii.Kernel.set(this, "recipe", value);
    }

    /**
     * Metadata tags that have been applied to the job.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTagsRaw() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tagsRaw", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * Metadata tags that have been applied to the job.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTagsRaw(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tagsRaw", value);
    }

    /**
     * The job's timeout in minutes.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getTimeout() {
        return software.amazon.jsii.Kernel.get(this, "timeout", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The job's timeout in minutes.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTimeout(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "timeout", value);
    }

    /**
     * List of validation configurations that are applied to the profile job.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getValidationConfigurations() {
        return software.amazon.jsii.Kernel.get(this, "validationConfigurations", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * List of validation configurations that are applied to the profile job.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setValidationConfigurations(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "validationConfigurations", value);
    }

    /**
     * List of validation configurations that are applied to the profile job.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setValidationConfigurations(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.databrew.CfnJob.ValidationConfigurationProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.databrew.CfnJob.ValidationConfigurationProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "validationConfigurations", value);
    }
    /**
     * Configuration of statistics that are allowed to be run on columns that contain detected entities.
     * <p>
     * When undefined, no statistics will be computed on columns that contain detected entities.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.databrew.*;
     * AllowedStatisticsProperty allowedStatisticsProperty = AllowedStatisticsProperty.builder()
     *         .statistics(List.of("statistics"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-job-allowedstatistics.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-job-allowedstatistics.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_databrew.CfnJob.AllowedStatisticsProperty")
    @software.amazon.jsii.Jsii.Proxy(AllowedStatisticsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AllowedStatisticsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * One or more column statistics to allow for columns that contain detected entities.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-job-allowedstatistics.html#cfn-databrew-job-allowedstatistics-statistics">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-job-allowedstatistics.html#cfn-databrew-job-allowedstatistics-statistics</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getStatistics();

        /**
         * @return a {@link Builder} of {@link AllowedStatisticsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AllowedStatisticsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AllowedStatisticsProperty> {
            java.util.List<java.lang.String> statistics;

            /**
             * Sets the value of {@link AllowedStatisticsProperty#getStatistics}
             * @param statistics One or more column statistics to allow for columns that contain detected entities. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder statistics(java.util.List<java.lang.String> statistics) {
                this.statistics = statistics;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AllowedStatisticsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AllowedStatisticsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AllowedStatisticsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AllowedStatisticsProperty {
            private final java.util.List<java.lang.String> statistics;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.statistics = software.amazon.jsii.Kernel.get(this, "statistics", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.statistics = java.util.Objects.requireNonNull(builder.statistics, "statistics is required");
            }

            @Override
            public final java.util.List<java.lang.String> getStatistics() {
                return this.statistics;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("statistics", om.valueToTree(this.getStatistics()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_databrew.CfnJob.AllowedStatisticsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AllowedStatisticsProperty.Jsii$Proxy that = (AllowedStatisticsProperty.Jsii$Proxy) o;

                return this.statistics.equals(that.statistics);
            }

            @Override
            public final int hashCode() {
                int result = this.statistics.hashCode();
                return result;
            }
        }
    }
    /**
     * Selector of a column from a dataset for profile job configuration.
     * <p>
     * One selector includes either a column name or a regular expression.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.databrew.*;
     * ColumnSelectorProperty columnSelectorProperty = ColumnSelectorProperty.builder()
     *         .name("name")
     *         .regex("regex")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-job-columnselector.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-job-columnselector.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_databrew.CfnJob.ColumnSelectorProperty")
    @software.amazon.jsii.Jsii.Proxy(ColumnSelectorProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ColumnSelectorProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of a column from a dataset.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-job-columnselector.html#cfn-databrew-job-columnselector-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-job-columnselector.html#cfn-databrew-job-columnselector-name</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getName() {
            return null;
        }

        /**
         * A regular expression for selecting a column from a dataset.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-job-columnselector.html#cfn-databrew-job-columnselector-regex">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-job-columnselector.html#cfn-databrew-job-columnselector-regex</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getRegex() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ColumnSelectorProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ColumnSelectorProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ColumnSelectorProperty> {
            java.lang.String name;
            java.lang.String regex;

            /**
             * Sets the value of {@link ColumnSelectorProperty#getName}
             * @param name The name of a column from a dataset.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link ColumnSelectorProperty#getRegex}
             * @param regex A regular expression for selecting a column from a dataset.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder regex(java.lang.String regex) {
                this.regex = regex;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ColumnSelectorProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ColumnSelectorProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ColumnSelectorProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ColumnSelectorProperty {
            private final java.lang.String name;
            private final java.lang.String regex;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.regex = software.amazon.jsii.Kernel.get(this, "regex", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.name = builder.name;
                this.regex = builder.regex;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.String getRegex() {
                return this.regex;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getName() != null) {
                    data.set("name", om.valueToTree(this.getName()));
                }
                if (this.getRegex() != null) {
                    data.set("regex", om.valueToTree(this.getRegex()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_databrew.CfnJob.ColumnSelectorProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ColumnSelectorProperty.Jsii$Proxy that = (ColumnSelectorProperty.Jsii$Proxy) o;

                if (this.name != null ? !this.name.equals(that.name) : that.name != null) return false;
                return this.regex != null ? this.regex.equals(that.regex) : that.regex == null;
            }

            @Override
            public final int hashCode() {
                int result = this.name != null ? this.name.hashCode() : 0;
                result = 31 * result + (this.regex != null ? this.regex.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Configuration for column evaluations for a profile job.
     * <p>
     * ColumnStatisticsConfiguration can be used to select evaluations and override parameters of evaluations for particular columns.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.databrew.*;
     * ColumnStatisticsConfigurationProperty columnStatisticsConfigurationProperty = ColumnStatisticsConfigurationProperty.builder()
     *         .statistics(StatisticsConfigurationProperty.builder()
     *                 .includedStatistics(List.of("includedStatistics"))
     *                 .overrides(List.of(StatisticOverrideProperty.builder()
     *                         .parameters(Map.of(
     *                                 "parametersKey", "parameters"))
     *                         .statistic("statistic")
     *                         .build()))
     *                 .build())
     *         // the properties below are optional
     *         .selectors(List.of(ColumnSelectorProperty.builder()
     *                 .name("name")
     *                 .regex("regex")
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-job-columnstatisticsconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-job-columnstatisticsconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_databrew.CfnJob.ColumnStatisticsConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(ColumnStatisticsConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ColumnStatisticsConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Configuration for evaluations.
         * <p>
         * Statistics can be used to select evaluations and override parameters of evaluations.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-job-columnstatisticsconfiguration.html#cfn-databrew-job-columnstatisticsconfiguration-statistics">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-job-columnstatisticsconfiguration.html#cfn-databrew-job-columnstatisticsconfiguration-statistics</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getStatistics();

        /**
         * List of column selectors.
         * <p>
         * Selectors can be used to select columns from the dataset. When selectors are undefined, configuration will be applied to all supported columns.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-job-columnstatisticsconfiguration.html#cfn-databrew-job-columnstatisticsconfiguration-selectors">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-job-columnstatisticsconfiguration.html#cfn-databrew-job-columnstatisticsconfiguration-selectors</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSelectors() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ColumnStatisticsConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ColumnStatisticsConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ColumnStatisticsConfigurationProperty> {
            java.lang.Object statistics;
            java.lang.Object selectors;

            /**
             * Sets the value of {@link ColumnStatisticsConfigurationProperty#getStatistics}
             * @param statistics Configuration for evaluations. This parameter is required.
             *                   Statistics can be used to select evaluations and override parameters of evaluations.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder statistics(software.amazon.awscdk.IResolvable statistics) {
                this.statistics = statistics;
                return this;
            }

            /**
             * Sets the value of {@link ColumnStatisticsConfigurationProperty#getStatistics}
             * @param statistics Configuration for evaluations. This parameter is required.
             *                   Statistics can be used to select evaluations and override parameters of evaluations.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder statistics(software.amazon.awscdk.services.databrew.CfnJob.StatisticsConfigurationProperty statistics) {
                this.statistics = statistics;
                return this;
            }

            /**
             * Sets the value of {@link ColumnStatisticsConfigurationProperty#getSelectors}
             * @param selectors List of column selectors.
             *                  Selectors can be used to select columns from the dataset. When selectors are undefined, configuration will be applied to all supported columns.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder selectors(software.amazon.awscdk.IResolvable selectors) {
                this.selectors = selectors;
                return this;
            }

            /**
             * Sets the value of {@link ColumnStatisticsConfigurationProperty#getSelectors}
             * @param selectors List of column selectors.
             *                  Selectors can be used to select columns from the dataset. When selectors are undefined, configuration will be applied to all supported columns.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder selectors(java.util.List<? extends java.lang.Object> selectors) {
                this.selectors = selectors;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ColumnStatisticsConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ColumnStatisticsConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ColumnStatisticsConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ColumnStatisticsConfigurationProperty {
            private final java.lang.Object statistics;
            private final java.lang.Object selectors;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.statistics = software.amazon.jsii.Kernel.get(this, "statistics", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.selectors = software.amazon.jsii.Kernel.get(this, "selectors", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.statistics = java.util.Objects.requireNonNull(builder.statistics, "statistics is required");
                this.selectors = builder.selectors;
            }

            @Override
            public final java.lang.Object getStatistics() {
                return this.statistics;
            }

            @Override
            public final java.lang.Object getSelectors() {
                return this.selectors;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("statistics", om.valueToTree(this.getStatistics()));
                if (this.getSelectors() != null) {
                    data.set("selectors", om.valueToTree(this.getSelectors()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_databrew.CfnJob.ColumnStatisticsConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ColumnStatisticsConfigurationProperty.Jsii$Proxy that = (ColumnStatisticsConfigurationProperty.Jsii$Proxy) o;

                if (!statistics.equals(that.statistics)) return false;
                return this.selectors != null ? this.selectors.equals(that.selectors) : that.selectors == null;
            }

            @Override
            public final int hashCode() {
                int result = this.statistics.hashCode();
                result = 31 * result + (this.selectors != null ? this.selectors.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Represents a set of options that define how DataBrew will write a comma-separated value (CSV) file.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.databrew.*;
     * CsvOutputOptionsProperty csvOutputOptionsProperty = CsvOutputOptionsProperty.builder()
     *         .delimiter("delimiter")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-job-csvoutputoptions.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-job-csvoutputoptions.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_databrew.CfnJob.CsvOutputOptionsProperty")
    @software.amazon.jsii.Jsii.Proxy(CsvOutputOptionsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CsvOutputOptionsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A single character that specifies the delimiter used to create CSV job output.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-job-csvoutputoptions.html#cfn-databrew-job-csvoutputoptions-delimiter">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-job-csvoutputoptions.html#cfn-databrew-job-csvoutputoptions-delimiter</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDelimiter() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CsvOutputOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CsvOutputOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CsvOutputOptionsProperty> {
            java.lang.String delimiter;

            /**
             * Sets the value of {@link CsvOutputOptionsProperty#getDelimiter}
             * @param delimiter A single character that specifies the delimiter used to create CSV job output.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder delimiter(java.lang.String delimiter) {
                this.delimiter = delimiter;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CsvOutputOptionsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CsvOutputOptionsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CsvOutputOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CsvOutputOptionsProperty {
            private final java.lang.String delimiter;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.delimiter = software.amazon.jsii.Kernel.get(this, "delimiter", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.delimiter = builder.delimiter;
            }

            @Override
            public final java.lang.String getDelimiter() {
                return this.delimiter;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDelimiter() != null) {
                    data.set("delimiter", om.valueToTree(this.getDelimiter()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_databrew.CfnJob.CsvOutputOptionsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CsvOutputOptionsProperty.Jsii$Proxy that = (CsvOutputOptionsProperty.Jsii$Proxy) o;

                return this.delimiter != null ? this.delimiter.equals(that.delimiter) : that.delimiter == null;
            }

            @Override
            public final int hashCode() {
                int result = this.delimiter != null ? this.delimiter.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Represents options that specify how and where in the AWS Glue Data Catalog DataBrew writes the output generated by recipe jobs.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.databrew.*;
     * DataCatalogOutputProperty dataCatalogOutputProperty = DataCatalogOutputProperty.builder()
     *         .databaseName("databaseName")
     *         .tableName("tableName")
     *         // the properties below are optional
     *         .catalogId("catalogId")
     *         .databaseOptions(DatabaseTableOutputOptionsProperty.builder()
     *                 .tableName("tableName")
     *                 // the properties below are optional
     *                 .tempDirectory(S3LocationProperty.builder()
     *                         .bucket("bucket")
     *                         // the properties below are optional
     *                         .bucketOwner("bucketOwner")
     *                         .key("key")
     *                         .build())
     *                 .build())
     *         .overwrite(false)
     *         .s3Options(S3TableOutputOptionsProperty.builder()
     *                 .location(S3LocationProperty.builder()
     *                         .bucket("bucket")
     *                         // the properties below are optional
     *                         .bucketOwner("bucketOwner")
     *                         .key("key")
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-job-datacatalogoutput.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-job-datacatalogoutput.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_databrew.CfnJob.DataCatalogOutputProperty")
    @software.amazon.jsii.Jsii.Proxy(DataCatalogOutputProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DataCatalogOutputProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of a database in the Data Catalog.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-job-datacatalogoutput.html#cfn-databrew-job-datacatalogoutput-databasename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-job-datacatalogoutput.html#cfn-databrew-job-datacatalogoutput-databasename</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDatabaseName();

        /**
         * The name of a table in the Data Catalog.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-job-datacatalogoutput.html#cfn-databrew-job-datacatalogoutput-tablename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-job-datacatalogoutput.html#cfn-databrew-job-datacatalogoutput-tablename</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getTableName();

        /**
         * The unique identifier of the AWS account that holds the Data Catalog that stores the data.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-job-datacatalogoutput.html#cfn-databrew-job-datacatalogoutput-catalogid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-job-datacatalogoutput.html#cfn-databrew-job-datacatalogoutput-catalogid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCatalogId() {
            return null;
        }

        /**
         * Represents options that specify how and where DataBrew writes the database output generated by recipe jobs.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-job-datacatalogoutput.html#cfn-databrew-job-datacatalogoutput-databaseoptions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-job-datacatalogoutput.html#cfn-databrew-job-datacatalogoutput-databaseoptions</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDatabaseOptions() {
            return null;
        }

        /**
         * A value that, if true, means that any data in the location specified for output is overwritten with new output.
         * <p>
         * Not supported with DatabaseOptions.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-job-datacatalogoutput.html#cfn-databrew-job-datacatalogoutput-overwrite">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-job-datacatalogoutput.html#cfn-databrew-job-datacatalogoutput-overwrite</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getOverwrite() {
            return null;
        }

        /**
         * Represents options that specify how and where DataBrew writes the Amazon S3 output generated by recipe jobs.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-job-datacatalogoutput.html#cfn-databrew-job-datacatalogoutput-s3options">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-job-datacatalogoutput.html#cfn-databrew-job-datacatalogoutput-s3options</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getS3Options() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DataCatalogOutputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DataCatalogOutputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DataCatalogOutputProperty> {
            java.lang.String databaseName;
            java.lang.String tableName;
            java.lang.String catalogId;
            java.lang.Object databaseOptions;
            java.lang.Object overwrite;
            java.lang.Object s3Options;

            /**
             * Sets the value of {@link DataCatalogOutputProperty#getDatabaseName}
             * @param databaseName The name of a database in the Data Catalog. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder databaseName(java.lang.String databaseName) {
                this.databaseName = databaseName;
                return this;
            }

            /**
             * Sets the value of {@link DataCatalogOutputProperty#getTableName}
             * @param tableName The name of a table in the Data Catalog. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tableName(java.lang.String tableName) {
                this.tableName = tableName;
                return this;
            }

            /**
             * Sets the value of {@link DataCatalogOutputProperty#getCatalogId}
             * @param catalogId The unique identifier of the AWS account that holds the Data Catalog that stores the data.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder catalogId(java.lang.String catalogId) {
                this.catalogId = catalogId;
                return this;
            }

            /**
             * Sets the value of {@link DataCatalogOutputProperty#getDatabaseOptions}
             * @param databaseOptions Represents options that specify how and where DataBrew writes the database output generated by recipe jobs.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder databaseOptions(software.amazon.awscdk.IResolvable databaseOptions) {
                this.databaseOptions = databaseOptions;
                return this;
            }

            /**
             * Sets the value of {@link DataCatalogOutputProperty#getDatabaseOptions}
             * @param databaseOptions Represents options that specify how and where DataBrew writes the database output generated by recipe jobs.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder databaseOptions(software.amazon.awscdk.services.databrew.CfnJob.DatabaseTableOutputOptionsProperty databaseOptions) {
                this.databaseOptions = databaseOptions;
                return this;
            }

            /**
             * Sets the value of {@link DataCatalogOutputProperty#getOverwrite}
             * @param overwrite A value that, if true, means that any data in the location specified for output is overwritten with new output.
             *                  Not supported with DatabaseOptions.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder overwrite(java.lang.Boolean overwrite) {
                this.overwrite = overwrite;
                return this;
            }

            /**
             * Sets the value of {@link DataCatalogOutputProperty#getOverwrite}
             * @param overwrite A value that, if true, means that any data in the location specified for output is overwritten with new output.
             *                  Not supported with DatabaseOptions.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder overwrite(software.amazon.awscdk.IResolvable overwrite) {
                this.overwrite = overwrite;
                return this;
            }

            /**
             * Sets the value of {@link DataCatalogOutputProperty#getS3Options}
             * @param s3Options Represents options that specify how and where DataBrew writes the Amazon S3 output generated by recipe jobs.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3Options(software.amazon.awscdk.IResolvable s3Options) {
                this.s3Options = s3Options;
                return this;
            }

            /**
             * Sets the value of {@link DataCatalogOutputProperty#getS3Options}
             * @param s3Options Represents options that specify how and where DataBrew writes the Amazon S3 output generated by recipe jobs.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3Options(software.amazon.awscdk.services.databrew.CfnJob.S3TableOutputOptionsProperty s3Options) {
                this.s3Options = s3Options;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DataCatalogOutputProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DataCatalogOutputProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DataCatalogOutputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DataCatalogOutputProperty {
            private final java.lang.String databaseName;
            private final java.lang.String tableName;
            private final java.lang.String catalogId;
            private final java.lang.Object databaseOptions;
            private final java.lang.Object overwrite;
            private final java.lang.Object s3Options;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.databaseName = software.amazon.jsii.Kernel.get(this, "databaseName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.tableName = software.amazon.jsii.Kernel.get(this, "tableName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.catalogId = software.amazon.jsii.Kernel.get(this, "catalogId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.databaseOptions = software.amazon.jsii.Kernel.get(this, "databaseOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.overwrite = software.amazon.jsii.Kernel.get(this, "overwrite", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.s3Options = software.amazon.jsii.Kernel.get(this, "s3Options", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.databaseName = java.util.Objects.requireNonNull(builder.databaseName, "databaseName is required");
                this.tableName = java.util.Objects.requireNonNull(builder.tableName, "tableName is required");
                this.catalogId = builder.catalogId;
                this.databaseOptions = builder.databaseOptions;
                this.overwrite = builder.overwrite;
                this.s3Options = builder.s3Options;
            }

            @Override
            public final java.lang.String getDatabaseName() {
                return this.databaseName;
            }

            @Override
            public final java.lang.String getTableName() {
                return this.tableName;
            }

            @Override
            public final java.lang.String getCatalogId() {
                return this.catalogId;
            }

            @Override
            public final java.lang.Object getDatabaseOptions() {
                return this.databaseOptions;
            }

            @Override
            public final java.lang.Object getOverwrite() {
                return this.overwrite;
            }

            @Override
            public final java.lang.Object getS3Options() {
                return this.s3Options;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("databaseName", om.valueToTree(this.getDatabaseName()));
                data.set("tableName", om.valueToTree(this.getTableName()));
                if (this.getCatalogId() != null) {
                    data.set("catalogId", om.valueToTree(this.getCatalogId()));
                }
                if (this.getDatabaseOptions() != null) {
                    data.set("databaseOptions", om.valueToTree(this.getDatabaseOptions()));
                }
                if (this.getOverwrite() != null) {
                    data.set("overwrite", om.valueToTree(this.getOverwrite()));
                }
                if (this.getS3Options() != null) {
                    data.set("s3Options", om.valueToTree(this.getS3Options()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_databrew.CfnJob.DataCatalogOutputProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DataCatalogOutputProperty.Jsii$Proxy that = (DataCatalogOutputProperty.Jsii$Proxy) o;

                if (!databaseName.equals(that.databaseName)) return false;
                if (!tableName.equals(that.tableName)) return false;
                if (this.catalogId != null ? !this.catalogId.equals(that.catalogId) : that.catalogId != null) return false;
                if (this.databaseOptions != null ? !this.databaseOptions.equals(that.databaseOptions) : that.databaseOptions != null) return false;
                if (this.overwrite != null ? !this.overwrite.equals(that.overwrite) : that.overwrite != null) return false;
                return this.s3Options != null ? this.s3Options.equals(that.s3Options) : that.s3Options == null;
            }

            @Override
            public final int hashCode() {
                int result = this.databaseName.hashCode();
                result = 31 * result + (this.tableName.hashCode());
                result = 31 * result + (this.catalogId != null ? this.catalogId.hashCode() : 0);
                result = 31 * result + (this.databaseOptions != null ? this.databaseOptions.hashCode() : 0);
                result = 31 * result + (this.overwrite != null ? this.overwrite.hashCode() : 0);
                result = 31 * result + (this.s3Options != null ? this.s3Options.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Represents a JDBC database output object which defines the output destination for a DataBrew recipe job to write into.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.databrew.*;
     * DatabaseOutputProperty databaseOutputProperty = DatabaseOutputProperty.builder()
     *         .databaseOptions(DatabaseTableOutputOptionsProperty.builder()
     *                 .tableName("tableName")
     *                 // the properties below are optional
     *                 .tempDirectory(S3LocationProperty.builder()
     *                         .bucket("bucket")
     *                         // the properties below are optional
     *                         .bucketOwner("bucketOwner")
     *                         .key("key")
     *                         .build())
     *                 .build())
     *         .glueConnectionName("glueConnectionName")
     *         // the properties below are optional
     *         .databaseOutputMode("databaseOutputMode")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-job-databaseoutput.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-job-databaseoutput.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_databrew.CfnJob.DatabaseOutputProperty")
    @software.amazon.jsii.Jsii.Proxy(DatabaseOutputProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DatabaseOutputProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Represents options that specify how and where DataBrew writes the database output generated by recipe jobs.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-job-databaseoutput.html#cfn-databrew-job-databaseoutput-databaseoptions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-job-databaseoutput.html#cfn-databrew-job-databaseoutput-databaseoptions</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getDatabaseOptions();

        /**
         * The AWS Glue connection that stores the connection information for the target database.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-job-databaseoutput.html#cfn-databrew-job-databaseoutput-glueconnectionname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-job-databaseoutput.html#cfn-databrew-job-databaseoutput-glueconnectionname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getGlueConnectionName();

        /**
         * The output mode to write into the database.
         * <p>
         * Currently supported option: NEW_TABLE.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-job-databaseoutput.html#cfn-databrew-job-databaseoutput-databaseoutputmode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-job-databaseoutput.html#cfn-databrew-job-databaseoutput-databaseoutputmode</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDatabaseOutputMode() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DatabaseOutputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DatabaseOutputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DatabaseOutputProperty> {
            java.lang.Object databaseOptions;
            java.lang.String glueConnectionName;
            java.lang.String databaseOutputMode;

            /**
             * Sets the value of {@link DatabaseOutputProperty#getDatabaseOptions}
             * @param databaseOptions Represents options that specify how and where DataBrew writes the database output generated by recipe jobs. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder databaseOptions(software.amazon.awscdk.IResolvable databaseOptions) {
                this.databaseOptions = databaseOptions;
                return this;
            }

            /**
             * Sets the value of {@link DatabaseOutputProperty#getDatabaseOptions}
             * @param databaseOptions Represents options that specify how and where DataBrew writes the database output generated by recipe jobs. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder databaseOptions(software.amazon.awscdk.services.databrew.CfnJob.DatabaseTableOutputOptionsProperty databaseOptions) {
                this.databaseOptions = databaseOptions;
                return this;
            }

            /**
             * Sets the value of {@link DatabaseOutputProperty#getGlueConnectionName}
             * @param glueConnectionName The AWS Glue connection that stores the connection information for the target database. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder glueConnectionName(java.lang.String glueConnectionName) {
                this.glueConnectionName = glueConnectionName;
                return this;
            }

            /**
             * Sets the value of {@link DatabaseOutputProperty#getDatabaseOutputMode}
             * @param databaseOutputMode The output mode to write into the database.
             *                           Currently supported option: NEW_TABLE.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder databaseOutputMode(java.lang.String databaseOutputMode) {
                this.databaseOutputMode = databaseOutputMode;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DatabaseOutputProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DatabaseOutputProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DatabaseOutputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DatabaseOutputProperty {
            private final java.lang.Object databaseOptions;
            private final java.lang.String glueConnectionName;
            private final java.lang.String databaseOutputMode;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.databaseOptions = software.amazon.jsii.Kernel.get(this, "databaseOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.glueConnectionName = software.amazon.jsii.Kernel.get(this, "glueConnectionName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.databaseOutputMode = software.amazon.jsii.Kernel.get(this, "databaseOutputMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.databaseOptions = java.util.Objects.requireNonNull(builder.databaseOptions, "databaseOptions is required");
                this.glueConnectionName = java.util.Objects.requireNonNull(builder.glueConnectionName, "glueConnectionName is required");
                this.databaseOutputMode = builder.databaseOutputMode;
            }

            @Override
            public final java.lang.Object getDatabaseOptions() {
                return this.databaseOptions;
            }

            @Override
            public final java.lang.String getGlueConnectionName() {
                return this.glueConnectionName;
            }

            @Override
            public final java.lang.String getDatabaseOutputMode() {
                return this.databaseOutputMode;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("databaseOptions", om.valueToTree(this.getDatabaseOptions()));
                data.set("glueConnectionName", om.valueToTree(this.getGlueConnectionName()));
                if (this.getDatabaseOutputMode() != null) {
                    data.set("databaseOutputMode", om.valueToTree(this.getDatabaseOutputMode()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_databrew.CfnJob.DatabaseOutputProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DatabaseOutputProperty.Jsii$Proxy that = (DatabaseOutputProperty.Jsii$Proxy) o;

                if (!databaseOptions.equals(that.databaseOptions)) return false;
                if (!glueConnectionName.equals(that.glueConnectionName)) return false;
                return this.databaseOutputMode != null ? this.databaseOutputMode.equals(that.databaseOutputMode) : that.databaseOutputMode == null;
            }

            @Override
            public final int hashCode() {
                int result = this.databaseOptions.hashCode();
                result = 31 * result + (this.glueConnectionName.hashCode());
                result = 31 * result + (this.databaseOutputMode != null ? this.databaseOutputMode.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Represents options that specify how and where DataBrew writes the database output generated by recipe jobs.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.databrew.*;
     * DatabaseTableOutputOptionsProperty databaseTableOutputOptionsProperty = DatabaseTableOutputOptionsProperty.builder()
     *         .tableName("tableName")
     *         // the properties below are optional
     *         .tempDirectory(S3LocationProperty.builder()
     *                 .bucket("bucket")
     *                 // the properties below are optional
     *                 .bucketOwner("bucketOwner")
     *                 .key("key")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-job-databasetableoutputoptions.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-job-databasetableoutputoptions.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_databrew.CfnJob.DatabaseTableOutputOptionsProperty")
    @software.amazon.jsii.Jsii.Proxy(DatabaseTableOutputOptionsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DatabaseTableOutputOptionsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A prefix for the name of a table DataBrew will create in the database.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-job-databasetableoutputoptions.html#cfn-databrew-job-databasetableoutputoptions-tablename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-job-databasetableoutputoptions.html#cfn-databrew-job-databasetableoutputoptions-tablename</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getTableName();

        /**
         * Represents an Amazon S3 location (bucket name and object key) where DataBrew can store intermediate results.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-job-databasetableoutputoptions.html#cfn-databrew-job-databasetableoutputoptions-tempdirectory">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-job-databasetableoutputoptions.html#cfn-databrew-job-databasetableoutputoptions-tempdirectory</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTempDirectory() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DatabaseTableOutputOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DatabaseTableOutputOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DatabaseTableOutputOptionsProperty> {
            java.lang.String tableName;
            java.lang.Object tempDirectory;

            /**
             * Sets the value of {@link DatabaseTableOutputOptionsProperty#getTableName}
             * @param tableName A prefix for the name of a table DataBrew will create in the database. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tableName(java.lang.String tableName) {
                this.tableName = tableName;
                return this;
            }

            /**
             * Sets the value of {@link DatabaseTableOutputOptionsProperty#getTempDirectory}
             * @param tempDirectory Represents an Amazon S3 location (bucket name and object key) where DataBrew can store intermediate results.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tempDirectory(software.amazon.awscdk.IResolvable tempDirectory) {
                this.tempDirectory = tempDirectory;
                return this;
            }

            /**
             * Sets the value of {@link DatabaseTableOutputOptionsProperty#getTempDirectory}
             * @param tempDirectory Represents an Amazon S3 location (bucket name and object key) where DataBrew can store intermediate results.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tempDirectory(software.amazon.awscdk.services.databrew.CfnJob.S3LocationProperty tempDirectory) {
                this.tempDirectory = tempDirectory;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DatabaseTableOutputOptionsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DatabaseTableOutputOptionsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DatabaseTableOutputOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DatabaseTableOutputOptionsProperty {
            private final java.lang.String tableName;
            private final java.lang.Object tempDirectory;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.tableName = software.amazon.jsii.Kernel.get(this, "tableName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.tempDirectory = software.amazon.jsii.Kernel.get(this, "tempDirectory", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.tableName = java.util.Objects.requireNonNull(builder.tableName, "tableName is required");
                this.tempDirectory = builder.tempDirectory;
            }

            @Override
            public final java.lang.String getTableName() {
                return this.tableName;
            }

            @Override
            public final java.lang.Object getTempDirectory() {
                return this.tempDirectory;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("tableName", om.valueToTree(this.getTableName()));
                if (this.getTempDirectory() != null) {
                    data.set("tempDirectory", om.valueToTree(this.getTempDirectory()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_databrew.CfnJob.DatabaseTableOutputOptionsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DatabaseTableOutputOptionsProperty.Jsii$Proxy that = (DatabaseTableOutputOptionsProperty.Jsii$Proxy) o;

                if (!tableName.equals(that.tableName)) return false;
                return this.tempDirectory != null ? this.tempDirectory.equals(that.tempDirectory) : that.tempDirectory == null;
            }

            @Override
            public final int hashCode() {
                int result = this.tableName.hashCode();
                result = 31 * result + (this.tempDirectory != null ? this.tempDirectory.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Configuration of entity detection for a profile job.
     * <p>
     * When undefined, entity detection is disabled.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.databrew.*;
     * EntityDetectorConfigurationProperty entityDetectorConfigurationProperty = EntityDetectorConfigurationProperty.builder()
     *         .entityTypes(List.of("entityTypes"))
     *         // the properties below are optional
     *         .allowedStatistics(AllowedStatisticsProperty.builder()
     *                 .statistics(List.of("statistics"))
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-job-entitydetectorconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-job-entitydetectorconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_databrew.CfnJob.EntityDetectorConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(EntityDetectorConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EntityDetectorConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Entity types to detect. Can be any of the following:.
         * <p>
         * <ul>
         * <li>USA_SSN</li>
         * <li>EMAIL</li>
         * <li>USA_ITIN</li>
         * <li>USA_PASSPORT_NUMBER</li>
         * <li>PHONE_NUMBER</li>
         * <li>USA_DRIVING_LICENSE</li>
         * <li>BANK_ACCOUNT</li>
         * <li>CREDIT_CARD</li>
         * <li>IP_ADDRESS</li>
         * <li>MAC_ADDRESS</li>
         * <li>USA_DEA_NUMBER</li>
         * <li>USA_HCPCS_CODE</li>
         * <li>USA_NATIONAL_PROVIDER_IDENTIFIER</li>
         * <li>USA_NATIONAL_DRUG_CODE</li>
         * <li>USA_HEALTH_INSURANCE_CLAIM_NUMBER</li>
         * <li>USA_MEDICARE_BENEFICIARY_IDENTIFIER</li>
         * <li>USA_CPT_CODE</li>
         * <li>PERSON_NAME</li>
         * <li>DATE</li>
         * </ul>
         * <p>
         * The Entity type group USA_ALL is also supported, and includes all of the above entity types except PERSON_NAME and DATE.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-job-entitydetectorconfiguration.html#cfn-databrew-job-entitydetectorconfiguration-entitytypes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-job-entitydetectorconfiguration.html#cfn-databrew-job-entitydetectorconfiguration-entitytypes</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getEntityTypes();

        /**
         * Configuration of statistics that are allowed to be run on columns that contain detected entities.
         * <p>
         * When undefined, no statistics will be computed on columns that contain detected entities.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-job-entitydetectorconfiguration.html#cfn-databrew-job-entitydetectorconfiguration-allowedstatistics">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-job-entitydetectorconfiguration.html#cfn-databrew-job-entitydetectorconfiguration-allowedstatistics</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAllowedStatistics() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link EntityDetectorConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EntityDetectorConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EntityDetectorConfigurationProperty> {
            java.util.List<java.lang.String> entityTypes;
            java.lang.Object allowedStatistics;

            /**
             * Sets the value of {@link EntityDetectorConfigurationProperty#getEntityTypes}
             * @param entityTypes Entity types to detect. Can be any of the following:. This parameter is required.
             *                    <ul>
             *                    <li>USA_SSN</li>
             *                    <li>EMAIL</li>
             *                    <li>USA_ITIN</li>
             *                    <li>USA_PASSPORT_NUMBER</li>
             *                    <li>PHONE_NUMBER</li>
             *                    <li>USA_DRIVING_LICENSE</li>
             *                    <li>BANK_ACCOUNT</li>
             *                    <li>CREDIT_CARD</li>
             *                    <li>IP_ADDRESS</li>
             *                    <li>MAC_ADDRESS</li>
             *                    <li>USA_DEA_NUMBER</li>
             *                    <li>USA_HCPCS_CODE</li>
             *                    <li>USA_NATIONAL_PROVIDER_IDENTIFIER</li>
             *                    <li>USA_NATIONAL_DRUG_CODE</li>
             *                    <li>USA_HEALTH_INSURANCE_CLAIM_NUMBER</li>
             *                    <li>USA_MEDICARE_BENEFICIARY_IDENTIFIER</li>
             *                    <li>USA_CPT_CODE</li>
             *                    <li>PERSON_NAME</li>
             *                    <li>DATE</li>
             *                    </ul>
             *                    <p>
             *                    The Entity type group USA_ALL is also supported, and includes all of the above entity types except PERSON_NAME and DATE.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder entityTypes(java.util.List<java.lang.String> entityTypes) {
                this.entityTypes = entityTypes;
                return this;
            }

            /**
             * Sets the value of {@link EntityDetectorConfigurationProperty#getAllowedStatistics}
             * @param allowedStatistics Configuration of statistics that are allowed to be run on columns that contain detected entities.
             *                          When undefined, no statistics will be computed on columns that contain detected entities.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder allowedStatistics(software.amazon.awscdk.IResolvable allowedStatistics) {
                this.allowedStatistics = allowedStatistics;
                return this;
            }

            /**
             * Sets the value of {@link EntityDetectorConfigurationProperty#getAllowedStatistics}
             * @param allowedStatistics Configuration of statistics that are allowed to be run on columns that contain detected entities.
             *                          When undefined, no statistics will be computed on columns that contain detected entities.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder allowedStatistics(software.amazon.awscdk.services.databrew.CfnJob.AllowedStatisticsProperty allowedStatistics) {
                this.allowedStatistics = allowedStatistics;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EntityDetectorConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EntityDetectorConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EntityDetectorConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EntityDetectorConfigurationProperty {
            private final java.util.List<java.lang.String> entityTypes;
            private final java.lang.Object allowedStatistics;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.entityTypes = software.amazon.jsii.Kernel.get(this, "entityTypes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.allowedStatistics = software.amazon.jsii.Kernel.get(this, "allowedStatistics", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.entityTypes = java.util.Objects.requireNonNull(builder.entityTypes, "entityTypes is required");
                this.allowedStatistics = builder.allowedStatistics;
            }

            @Override
            public final java.util.List<java.lang.String> getEntityTypes() {
                return this.entityTypes;
            }

            @Override
            public final java.lang.Object getAllowedStatistics() {
                return this.allowedStatistics;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("entityTypes", om.valueToTree(this.getEntityTypes()));
                if (this.getAllowedStatistics() != null) {
                    data.set("allowedStatistics", om.valueToTree(this.getAllowedStatistics()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_databrew.CfnJob.EntityDetectorConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EntityDetectorConfigurationProperty.Jsii$Proxy that = (EntityDetectorConfigurationProperty.Jsii$Proxy) o;

                if (!entityTypes.equals(that.entityTypes)) return false;
                return this.allowedStatistics != null ? this.allowedStatistics.equals(that.allowedStatistics) : that.allowedStatistics == null;
            }

            @Override
            public final int hashCode() {
                int result = this.entityTypes.hashCode();
                result = 31 * result + (this.allowedStatistics != null ? this.allowedStatistics.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A sample configuration for profile jobs only, which determines the number of rows on which the profile job is run.
     * <p>
     * If a <code>JobSample</code> value isn't provided, the default is used. The default value is CUSTOM_ROWS for the mode parameter and 20,000 for the size parameter.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.databrew.*;
     * JobSampleProperty jobSampleProperty = JobSampleProperty.builder()
     *         .mode("mode")
     *         .size(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-job-jobsample.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-job-jobsample.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_databrew.CfnJob.JobSampleProperty")
    @software.amazon.jsii.Jsii.Proxy(JobSampleProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface JobSampleProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A value that determines whether the profile job is run on the entire dataset or a specified number of rows.
         * <p>
         * This value must be one of the following:
         * <p>
         * <ul>
         * <li>FULL_DATASET - The profile job is run on the entire dataset.</li>
         * <li>CUSTOM_ROWS - The profile job is run on the number of rows specified in the <code>Size</code> parameter.</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-job-jobsample.html#cfn-databrew-job-jobsample-mode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-job-jobsample.html#cfn-databrew-job-jobsample-mode</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getMode() {
            return null;
        }

        /**
         * The <code>Size</code> parameter is only required when the mode is CUSTOM_ROWS.
         * <p>
         * The profile job is run on the specified number of rows. The maximum value for size is Long.MAX_VALUE.
         * <p>
         * Long.MAX_VALUE = 9223372036854775807
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-job-jobsample.html#cfn-databrew-job-jobsample-size">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-job-jobsample.html#cfn-databrew-job-jobsample-size</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getSize() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link JobSampleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link JobSampleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<JobSampleProperty> {
            java.lang.String mode;
            java.lang.Number size;

            /**
             * Sets the value of {@link JobSampleProperty#getMode}
             * @param mode A value that determines whether the profile job is run on the entire dataset or a specified number of rows.
             *             This value must be one of the following:
             *             <p>
             *             <ul>
             *             <li>FULL_DATASET - The profile job is run on the entire dataset.</li>
             *             <li>CUSTOM_ROWS - The profile job is run on the number of rows specified in the <code>Size</code> parameter.</li>
             *             </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder mode(java.lang.String mode) {
                this.mode = mode;
                return this;
            }

            /**
             * Sets the value of {@link JobSampleProperty#getSize}
             * @param size The <code>Size</code> parameter is only required when the mode is CUSTOM_ROWS.
             *             The profile job is run on the specified number of rows. The maximum value for size is Long.MAX_VALUE.
             *             <p>
             *             Long.MAX_VALUE = 9223372036854775807
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder size(java.lang.Number size) {
                this.size = size;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link JobSampleProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public JobSampleProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link JobSampleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements JobSampleProperty {
            private final java.lang.String mode;
            private final java.lang.Number size;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.mode = software.amazon.jsii.Kernel.get(this, "mode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.size = software.amazon.jsii.Kernel.get(this, "size", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.mode = builder.mode;
                this.size = builder.size;
            }

            @Override
            public final java.lang.String getMode() {
                return this.mode;
            }

            @Override
            public final java.lang.Number getSize() {
                return this.size;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getMode() != null) {
                    data.set("mode", om.valueToTree(this.getMode()));
                }
                if (this.getSize() != null) {
                    data.set("size", om.valueToTree(this.getSize()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_databrew.CfnJob.JobSampleProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                JobSampleProperty.Jsii$Proxy that = (JobSampleProperty.Jsii$Proxy) o;

                if (this.mode != null ? !this.mode.equals(that.mode) : that.mode != null) return false;
                return this.size != null ? this.size.equals(that.size) : that.size == null;
            }

            @Override
            public final int hashCode() {
                int result = this.mode != null ? this.mode.hashCode() : 0;
                result = 31 * result + (this.size != null ? this.size.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Represents a set of options that define the structure of comma-separated (CSV) job output.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.databrew.*;
     * OutputFormatOptionsProperty outputFormatOptionsProperty = OutputFormatOptionsProperty.builder()
     *         .csv(CsvOutputOptionsProperty.builder()
     *                 .delimiter("delimiter")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-job-outputformatoptions.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-job-outputformatoptions.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_databrew.CfnJob.OutputFormatOptionsProperty")
    @software.amazon.jsii.Jsii.Proxy(OutputFormatOptionsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface OutputFormatOptionsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Represents a set of options that define the structure of comma-separated value (CSV) job output.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-job-outputformatoptions.html#cfn-databrew-job-outputformatoptions-csv">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-job-outputformatoptions.html#cfn-databrew-job-outputformatoptions-csv</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCsv() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link OutputFormatOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link OutputFormatOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<OutputFormatOptionsProperty> {
            java.lang.Object csv;

            /**
             * Sets the value of {@link OutputFormatOptionsProperty#getCsv}
             * @param csv Represents a set of options that define the structure of comma-separated value (CSV) job output.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder csv(software.amazon.awscdk.IResolvable csv) {
                this.csv = csv;
                return this;
            }

            /**
             * Sets the value of {@link OutputFormatOptionsProperty#getCsv}
             * @param csv Represents a set of options that define the structure of comma-separated value (CSV) job output.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder csv(software.amazon.awscdk.services.databrew.CfnJob.CsvOutputOptionsProperty csv) {
                this.csv = csv;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link OutputFormatOptionsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public OutputFormatOptionsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link OutputFormatOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements OutputFormatOptionsProperty {
            private final java.lang.Object csv;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.csv = software.amazon.jsii.Kernel.get(this, "csv", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.csv = builder.csv;
            }

            @Override
            public final java.lang.Object getCsv() {
                return this.csv;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCsv() != null) {
                    data.set("csv", om.valueToTree(this.getCsv()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_databrew.CfnJob.OutputFormatOptionsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                OutputFormatOptionsProperty.Jsii$Proxy that = (OutputFormatOptionsProperty.Jsii$Proxy) o;

                return this.csv != null ? this.csv.equals(that.csv) : that.csv == null;
            }

            @Override
            public final int hashCode() {
                int result = this.csv != null ? this.csv.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * The location in Amazon S3 or AWS Glue Data Catalog where the job writes its output.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.databrew.*;
     * OutputLocationProperty outputLocationProperty = OutputLocationProperty.builder()
     *         .bucket("bucket")
     *         // the properties below are optional
     *         .bucketOwner("bucketOwner")
     *         .key("key")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-job-outputlocation.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-job-outputlocation.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_databrew.CfnJob.OutputLocationProperty")
    @software.amazon.jsii.Jsii.Proxy(OutputLocationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface OutputLocationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon S3 bucket name.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-job-outputlocation.html#cfn-databrew-job-outputlocation-bucket">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-job-outputlocation.html#cfn-databrew-job-outputlocation-bucket</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getBucket();

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-job-outputlocation.html#cfn-databrew-job-outputlocation-bucketowner">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-job-outputlocation.html#cfn-databrew-job-outputlocation-bucketowner</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getBucketOwner() {
            return null;
        }

        /**
         * The unique name of the object in the bucket.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-job-outputlocation.html#cfn-databrew-job-outputlocation-key">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-job-outputlocation.html#cfn-databrew-job-outputlocation-key</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getKey() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link OutputLocationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link OutputLocationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<OutputLocationProperty> {
            java.lang.String bucket;
            java.lang.String bucketOwner;
            java.lang.String key;

            /**
             * Sets the value of {@link OutputLocationProperty#getBucket}
             * @param bucket The Amazon S3 bucket name. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bucket(java.lang.String bucket) {
                this.bucket = bucket;
                return this;
            }

            /**
             * Sets the value of {@link OutputLocationProperty#getBucketOwner}
             * @param bucketOwner the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bucketOwner(java.lang.String bucketOwner) {
                this.bucketOwner = bucketOwner;
                return this;
            }

            /**
             * Sets the value of {@link OutputLocationProperty#getKey}
             * @param key The unique name of the object in the bucket.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder key(java.lang.String key) {
                this.key = key;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link OutputLocationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public OutputLocationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link OutputLocationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements OutputLocationProperty {
            private final java.lang.String bucket;
            private final java.lang.String bucketOwner;
            private final java.lang.String key;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.bucket = software.amazon.jsii.Kernel.get(this, "bucket", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.bucketOwner = software.amazon.jsii.Kernel.get(this, "bucketOwner", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.key = software.amazon.jsii.Kernel.get(this, "key", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.bucket = java.util.Objects.requireNonNull(builder.bucket, "bucket is required");
                this.bucketOwner = builder.bucketOwner;
                this.key = builder.key;
            }

            @Override
            public final java.lang.String getBucket() {
                return this.bucket;
            }

            @Override
            public final java.lang.String getBucketOwner() {
                return this.bucketOwner;
            }

            @Override
            public final java.lang.String getKey() {
                return this.key;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("bucket", om.valueToTree(this.getBucket()));
                if (this.getBucketOwner() != null) {
                    data.set("bucketOwner", om.valueToTree(this.getBucketOwner()));
                }
                if (this.getKey() != null) {
                    data.set("key", om.valueToTree(this.getKey()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_databrew.CfnJob.OutputLocationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                OutputLocationProperty.Jsii$Proxy that = (OutputLocationProperty.Jsii$Proxy) o;

                if (!bucket.equals(that.bucket)) return false;
                if (this.bucketOwner != null ? !this.bucketOwner.equals(that.bucketOwner) : that.bucketOwner != null) return false;
                return this.key != null ? this.key.equals(that.key) : that.key == null;
            }

            @Override
            public final int hashCode() {
                int result = this.bucket.hashCode();
                result = 31 * result + (this.bucketOwner != null ? this.bucketOwner.hashCode() : 0);
                result = 31 * result + (this.key != null ? this.key.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Represents options that specify how and where in Amazon S3 DataBrew writes the output generated by recipe jobs or profile jobs.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.databrew.*;
     * OutputProperty outputProperty = OutputProperty.builder()
     *         .location(S3LocationProperty.builder()
     *                 .bucket("bucket")
     *                 // the properties below are optional
     *                 .bucketOwner("bucketOwner")
     *                 .key("key")
     *                 .build())
     *         // the properties below are optional
     *         .compressionFormat("compressionFormat")
     *         .format("format")
     *         .formatOptions(OutputFormatOptionsProperty.builder()
     *                 .csv(CsvOutputOptionsProperty.builder()
     *                         .delimiter("delimiter")
     *                         .build())
     *                 .build())
     *         .maxOutputFiles(123)
     *         .overwrite(false)
     *         .partitionColumns(List.of("partitionColumns"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-job-output.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-job-output.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_databrew.CfnJob.OutputProperty")
    @software.amazon.jsii.Jsii.Proxy(OutputProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface OutputProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The location in Amazon S3 where the job writes its output.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-job-output.html#cfn-databrew-job-output-location">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-job-output.html#cfn-databrew-job-output-location</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getLocation();

        /**
         * The compression algorithm used to compress the output text of the job.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-job-output.html#cfn-databrew-job-output-compressionformat">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-job-output.html#cfn-databrew-job-output-compressionformat</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCompressionFormat() {
            return null;
        }

        /**
         * The data format of the output of the job.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-job-output.html#cfn-databrew-job-output-format">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-job-output.html#cfn-databrew-job-output-format</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getFormat() {
            return null;
        }

        /**
         * Represents options that define how DataBrew formats job output files.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-job-output.html#cfn-databrew-job-output-formatoptions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-job-output.html#cfn-databrew-job-output-formatoptions</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getFormatOptions() {
            return null;
        }

        /**
         * The maximum number of files to be generated by the job and written to the output folder.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-job-output.html#cfn-databrew-job-output-maxoutputfiles">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-job-output.html#cfn-databrew-job-output-maxoutputfiles</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMaxOutputFiles() {
            return null;
        }

        /**
         * A value that, if true, means that any data in the location specified for output is overwritten with new output.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-job-output.html#cfn-databrew-job-output-overwrite">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-job-output.html#cfn-databrew-job-output-overwrite</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getOverwrite() {
            return null;
        }

        /**
         * The names of one or more partition columns for the output of the job.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-job-output.html#cfn-databrew-job-output-partitioncolumns">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-job-output.html#cfn-databrew-job-output-partitioncolumns</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getPartitionColumns() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link OutputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link OutputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<OutputProperty> {
            java.lang.Object location;
            java.lang.String compressionFormat;
            java.lang.String format;
            java.lang.Object formatOptions;
            java.lang.Number maxOutputFiles;
            java.lang.Object overwrite;
            java.util.List<java.lang.String> partitionColumns;

            /**
             * Sets the value of {@link OutputProperty#getLocation}
             * @param location The location in Amazon S3 where the job writes its output. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder location(software.amazon.awscdk.IResolvable location) {
                this.location = location;
                return this;
            }

            /**
             * Sets the value of {@link OutputProperty#getLocation}
             * @param location The location in Amazon S3 where the job writes its output. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder location(software.amazon.awscdk.services.databrew.CfnJob.S3LocationProperty location) {
                this.location = location;
                return this;
            }

            /**
             * Sets the value of {@link OutputProperty#getCompressionFormat}
             * @param compressionFormat The compression algorithm used to compress the output text of the job.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder compressionFormat(java.lang.String compressionFormat) {
                this.compressionFormat = compressionFormat;
                return this;
            }

            /**
             * Sets the value of {@link OutputProperty#getFormat}
             * @param format The data format of the output of the job.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder format(java.lang.String format) {
                this.format = format;
                return this;
            }

            /**
             * Sets the value of {@link OutputProperty#getFormatOptions}
             * @param formatOptions Represents options that define how DataBrew formats job output files.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder formatOptions(software.amazon.awscdk.IResolvable formatOptions) {
                this.formatOptions = formatOptions;
                return this;
            }

            /**
             * Sets the value of {@link OutputProperty#getFormatOptions}
             * @param formatOptions Represents options that define how DataBrew formats job output files.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder formatOptions(software.amazon.awscdk.services.databrew.CfnJob.OutputFormatOptionsProperty formatOptions) {
                this.formatOptions = formatOptions;
                return this;
            }

            /**
             * Sets the value of {@link OutputProperty#getMaxOutputFiles}
             * @param maxOutputFiles The maximum number of files to be generated by the job and written to the output folder.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maxOutputFiles(java.lang.Number maxOutputFiles) {
                this.maxOutputFiles = maxOutputFiles;
                return this;
            }

            /**
             * Sets the value of {@link OutputProperty#getOverwrite}
             * @param overwrite A value that, if true, means that any data in the location specified for output is overwritten with new output.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder overwrite(java.lang.Boolean overwrite) {
                this.overwrite = overwrite;
                return this;
            }

            /**
             * Sets the value of {@link OutputProperty#getOverwrite}
             * @param overwrite A value that, if true, means that any data in the location specified for output is overwritten with new output.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder overwrite(software.amazon.awscdk.IResolvable overwrite) {
                this.overwrite = overwrite;
                return this;
            }

            /**
             * Sets the value of {@link OutputProperty#getPartitionColumns}
             * @param partitionColumns The names of one or more partition columns for the output of the job.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder partitionColumns(java.util.List<java.lang.String> partitionColumns) {
                this.partitionColumns = partitionColumns;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link OutputProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public OutputProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link OutputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements OutputProperty {
            private final java.lang.Object location;
            private final java.lang.String compressionFormat;
            private final java.lang.String format;
            private final java.lang.Object formatOptions;
            private final java.lang.Number maxOutputFiles;
            private final java.lang.Object overwrite;
            private final java.util.List<java.lang.String> partitionColumns;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.location = software.amazon.jsii.Kernel.get(this, "location", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.compressionFormat = software.amazon.jsii.Kernel.get(this, "compressionFormat", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.format = software.amazon.jsii.Kernel.get(this, "format", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.formatOptions = software.amazon.jsii.Kernel.get(this, "formatOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.maxOutputFiles = software.amazon.jsii.Kernel.get(this, "maxOutputFiles", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.overwrite = software.amazon.jsii.Kernel.get(this, "overwrite", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.partitionColumns = software.amazon.jsii.Kernel.get(this, "partitionColumns", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.location = java.util.Objects.requireNonNull(builder.location, "location is required");
                this.compressionFormat = builder.compressionFormat;
                this.format = builder.format;
                this.formatOptions = builder.formatOptions;
                this.maxOutputFiles = builder.maxOutputFiles;
                this.overwrite = builder.overwrite;
                this.partitionColumns = builder.partitionColumns;
            }

            @Override
            public final java.lang.Object getLocation() {
                return this.location;
            }

            @Override
            public final java.lang.String getCompressionFormat() {
                return this.compressionFormat;
            }

            @Override
            public final java.lang.String getFormat() {
                return this.format;
            }

            @Override
            public final java.lang.Object getFormatOptions() {
                return this.formatOptions;
            }

            @Override
            public final java.lang.Number getMaxOutputFiles() {
                return this.maxOutputFiles;
            }

            @Override
            public final java.lang.Object getOverwrite() {
                return this.overwrite;
            }

            @Override
            public final java.util.List<java.lang.String> getPartitionColumns() {
                return this.partitionColumns;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("location", om.valueToTree(this.getLocation()));
                if (this.getCompressionFormat() != null) {
                    data.set("compressionFormat", om.valueToTree(this.getCompressionFormat()));
                }
                if (this.getFormat() != null) {
                    data.set("format", om.valueToTree(this.getFormat()));
                }
                if (this.getFormatOptions() != null) {
                    data.set("formatOptions", om.valueToTree(this.getFormatOptions()));
                }
                if (this.getMaxOutputFiles() != null) {
                    data.set("maxOutputFiles", om.valueToTree(this.getMaxOutputFiles()));
                }
                if (this.getOverwrite() != null) {
                    data.set("overwrite", om.valueToTree(this.getOverwrite()));
                }
                if (this.getPartitionColumns() != null) {
                    data.set("partitionColumns", om.valueToTree(this.getPartitionColumns()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_databrew.CfnJob.OutputProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                OutputProperty.Jsii$Proxy that = (OutputProperty.Jsii$Proxy) o;

                if (!location.equals(that.location)) return false;
                if (this.compressionFormat != null ? !this.compressionFormat.equals(that.compressionFormat) : that.compressionFormat != null) return false;
                if (this.format != null ? !this.format.equals(that.format) : that.format != null) return false;
                if (this.formatOptions != null ? !this.formatOptions.equals(that.formatOptions) : that.formatOptions != null) return false;
                if (this.maxOutputFiles != null ? !this.maxOutputFiles.equals(that.maxOutputFiles) : that.maxOutputFiles != null) return false;
                if (this.overwrite != null ? !this.overwrite.equals(that.overwrite) : that.overwrite != null) return false;
                return this.partitionColumns != null ? this.partitionColumns.equals(that.partitionColumns) : that.partitionColumns == null;
            }

            @Override
            public final int hashCode() {
                int result = this.location.hashCode();
                result = 31 * result + (this.compressionFormat != null ? this.compressionFormat.hashCode() : 0);
                result = 31 * result + (this.format != null ? this.format.hashCode() : 0);
                result = 31 * result + (this.formatOptions != null ? this.formatOptions.hashCode() : 0);
                result = 31 * result + (this.maxOutputFiles != null ? this.maxOutputFiles.hashCode() : 0);
                result = 31 * result + (this.overwrite != null ? this.overwrite.hashCode() : 0);
                result = 31 * result + (this.partitionColumns != null ? this.partitionColumns.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Configuration for profile jobs.
     * <p>
     * Configuration can be used to select columns, do evaluations, and override default parameters of evaluations. When configuration is undefined, the profile job will apply default settings to all supported columns.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.databrew.*;
     * ProfileConfigurationProperty profileConfigurationProperty = ProfileConfigurationProperty.builder()
     *         .columnStatisticsConfigurations(List.of(ColumnStatisticsConfigurationProperty.builder()
     *                 .statistics(StatisticsConfigurationProperty.builder()
     *                         .includedStatistics(List.of("includedStatistics"))
     *                         .overrides(List.of(StatisticOverrideProperty.builder()
     *                                 .parameters(Map.of(
     *                                         "parametersKey", "parameters"))
     *                                 .statistic("statistic")
     *                                 .build()))
     *                         .build())
     *                 // the properties below are optional
     *                 .selectors(List.of(ColumnSelectorProperty.builder()
     *                         .name("name")
     *                         .regex("regex")
     *                         .build()))
     *                 .build()))
     *         .datasetStatisticsConfiguration(StatisticsConfigurationProperty.builder()
     *                 .includedStatistics(List.of("includedStatistics"))
     *                 .overrides(List.of(StatisticOverrideProperty.builder()
     *                         .parameters(Map.of(
     *                                 "parametersKey", "parameters"))
     *                         .statistic("statistic")
     *                         .build()))
     *                 .build())
     *         .entityDetectorConfiguration(EntityDetectorConfigurationProperty.builder()
     *                 .entityTypes(List.of("entityTypes"))
     *                 // the properties below are optional
     *                 .allowedStatistics(AllowedStatisticsProperty.builder()
     *                         .statistics(List.of("statistics"))
     *                         .build())
     *                 .build())
     *         .profileColumns(List.of(ColumnSelectorProperty.builder()
     *                 .name("name")
     *                 .regex("regex")
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-job-profileconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-job-profileconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_databrew.CfnJob.ProfileConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(ProfileConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ProfileConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * List of configurations for column evaluations.
         * <p>
         * ColumnStatisticsConfigurations are used to select evaluations and override parameters of evaluations for particular columns. When ColumnStatisticsConfigurations is undefined, the profile job will profile all supported columns and run all supported evaluations.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-job-profileconfiguration.html#cfn-databrew-job-profileconfiguration-columnstatisticsconfigurations">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-job-profileconfiguration.html#cfn-databrew-job-profileconfiguration-columnstatisticsconfigurations</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getColumnStatisticsConfigurations() {
            return null;
        }

        /**
         * Configuration for inter-column evaluations.
         * <p>
         * Configuration can be used to select evaluations and override parameters of evaluations. When configuration is undefined, the profile job will run all supported inter-column evaluations.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-job-profileconfiguration.html#cfn-databrew-job-profileconfiguration-datasetstatisticsconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-job-profileconfiguration.html#cfn-databrew-job-profileconfiguration-datasetstatisticsconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDatasetStatisticsConfiguration() {
            return null;
        }

        /**
         * Configuration of entity detection for a profile job.
         * <p>
         * When undefined, entity detection is disabled.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-job-profileconfiguration.html#cfn-databrew-job-profileconfiguration-entitydetectorconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-job-profileconfiguration.html#cfn-databrew-job-profileconfiguration-entitydetectorconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEntityDetectorConfiguration() {
            return null;
        }

        /**
         * List of column selectors.
         * <p>
         * ProfileColumns can be used to select columns from the dataset. When ProfileColumns is undefined, the profile job will profile all supported columns.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-job-profileconfiguration.html#cfn-databrew-job-profileconfiguration-profilecolumns">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-job-profileconfiguration.html#cfn-databrew-job-profileconfiguration-profilecolumns</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getProfileColumns() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ProfileConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ProfileConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ProfileConfigurationProperty> {
            java.lang.Object columnStatisticsConfigurations;
            java.lang.Object datasetStatisticsConfiguration;
            java.lang.Object entityDetectorConfiguration;
            java.lang.Object profileColumns;

            /**
             * Sets the value of {@link ProfileConfigurationProperty#getColumnStatisticsConfigurations}
             * @param columnStatisticsConfigurations List of configurations for column evaluations.
             *                                       ColumnStatisticsConfigurations are used to select evaluations and override parameters of evaluations for particular columns. When ColumnStatisticsConfigurations is undefined, the profile job will profile all supported columns and run all supported evaluations.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder columnStatisticsConfigurations(software.amazon.awscdk.IResolvable columnStatisticsConfigurations) {
                this.columnStatisticsConfigurations = columnStatisticsConfigurations;
                return this;
            }

            /**
             * Sets the value of {@link ProfileConfigurationProperty#getColumnStatisticsConfigurations}
             * @param columnStatisticsConfigurations List of configurations for column evaluations.
             *                                       ColumnStatisticsConfigurations are used to select evaluations and override parameters of evaluations for particular columns. When ColumnStatisticsConfigurations is undefined, the profile job will profile all supported columns and run all supported evaluations.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder columnStatisticsConfigurations(java.util.List<? extends java.lang.Object> columnStatisticsConfigurations) {
                this.columnStatisticsConfigurations = columnStatisticsConfigurations;
                return this;
            }

            /**
             * Sets the value of {@link ProfileConfigurationProperty#getDatasetStatisticsConfiguration}
             * @param datasetStatisticsConfiguration Configuration for inter-column evaluations.
             *                                       Configuration can be used to select evaluations and override parameters of evaluations. When configuration is undefined, the profile job will run all supported inter-column evaluations.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder datasetStatisticsConfiguration(software.amazon.awscdk.IResolvable datasetStatisticsConfiguration) {
                this.datasetStatisticsConfiguration = datasetStatisticsConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link ProfileConfigurationProperty#getDatasetStatisticsConfiguration}
             * @param datasetStatisticsConfiguration Configuration for inter-column evaluations.
             *                                       Configuration can be used to select evaluations and override parameters of evaluations. When configuration is undefined, the profile job will run all supported inter-column evaluations.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder datasetStatisticsConfiguration(software.amazon.awscdk.services.databrew.CfnJob.StatisticsConfigurationProperty datasetStatisticsConfiguration) {
                this.datasetStatisticsConfiguration = datasetStatisticsConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link ProfileConfigurationProperty#getEntityDetectorConfiguration}
             * @param entityDetectorConfiguration Configuration of entity detection for a profile job.
             *                                    When undefined, entity detection is disabled.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder entityDetectorConfiguration(software.amazon.awscdk.IResolvable entityDetectorConfiguration) {
                this.entityDetectorConfiguration = entityDetectorConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link ProfileConfigurationProperty#getEntityDetectorConfiguration}
             * @param entityDetectorConfiguration Configuration of entity detection for a profile job.
             *                                    When undefined, entity detection is disabled.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder entityDetectorConfiguration(software.amazon.awscdk.services.databrew.CfnJob.EntityDetectorConfigurationProperty entityDetectorConfiguration) {
                this.entityDetectorConfiguration = entityDetectorConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link ProfileConfigurationProperty#getProfileColumns}
             * @param profileColumns List of column selectors.
             *                       ProfileColumns can be used to select columns from the dataset. When ProfileColumns is undefined, the profile job will profile all supported columns.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder profileColumns(software.amazon.awscdk.IResolvable profileColumns) {
                this.profileColumns = profileColumns;
                return this;
            }

            /**
             * Sets the value of {@link ProfileConfigurationProperty#getProfileColumns}
             * @param profileColumns List of column selectors.
             *                       ProfileColumns can be used to select columns from the dataset. When ProfileColumns is undefined, the profile job will profile all supported columns.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder profileColumns(java.util.List<? extends java.lang.Object> profileColumns) {
                this.profileColumns = profileColumns;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ProfileConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ProfileConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ProfileConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ProfileConfigurationProperty {
            private final java.lang.Object columnStatisticsConfigurations;
            private final java.lang.Object datasetStatisticsConfiguration;
            private final java.lang.Object entityDetectorConfiguration;
            private final java.lang.Object profileColumns;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.columnStatisticsConfigurations = software.amazon.jsii.Kernel.get(this, "columnStatisticsConfigurations", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.datasetStatisticsConfiguration = software.amazon.jsii.Kernel.get(this, "datasetStatisticsConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.entityDetectorConfiguration = software.amazon.jsii.Kernel.get(this, "entityDetectorConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.profileColumns = software.amazon.jsii.Kernel.get(this, "profileColumns", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.columnStatisticsConfigurations = builder.columnStatisticsConfigurations;
                this.datasetStatisticsConfiguration = builder.datasetStatisticsConfiguration;
                this.entityDetectorConfiguration = builder.entityDetectorConfiguration;
                this.profileColumns = builder.profileColumns;
            }

            @Override
            public final java.lang.Object getColumnStatisticsConfigurations() {
                return this.columnStatisticsConfigurations;
            }

            @Override
            public final java.lang.Object getDatasetStatisticsConfiguration() {
                return this.datasetStatisticsConfiguration;
            }

            @Override
            public final java.lang.Object getEntityDetectorConfiguration() {
                return this.entityDetectorConfiguration;
            }

            @Override
            public final java.lang.Object getProfileColumns() {
                return this.profileColumns;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getColumnStatisticsConfigurations() != null) {
                    data.set("columnStatisticsConfigurations", om.valueToTree(this.getColumnStatisticsConfigurations()));
                }
                if (this.getDatasetStatisticsConfiguration() != null) {
                    data.set("datasetStatisticsConfiguration", om.valueToTree(this.getDatasetStatisticsConfiguration()));
                }
                if (this.getEntityDetectorConfiguration() != null) {
                    data.set("entityDetectorConfiguration", om.valueToTree(this.getEntityDetectorConfiguration()));
                }
                if (this.getProfileColumns() != null) {
                    data.set("profileColumns", om.valueToTree(this.getProfileColumns()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_databrew.CfnJob.ProfileConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ProfileConfigurationProperty.Jsii$Proxy that = (ProfileConfigurationProperty.Jsii$Proxy) o;

                if (this.columnStatisticsConfigurations != null ? !this.columnStatisticsConfigurations.equals(that.columnStatisticsConfigurations) : that.columnStatisticsConfigurations != null) return false;
                if (this.datasetStatisticsConfiguration != null ? !this.datasetStatisticsConfiguration.equals(that.datasetStatisticsConfiguration) : that.datasetStatisticsConfiguration != null) return false;
                if (this.entityDetectorConfiguration != null ? !this.entityDetectorConfiguration.equals(that.entityDetectorConfiguration) : that.entityDetectorConfiguration != null) return false;
                return this.profileColumns != null ? this.profileColumns.equals(that.profileColumns) : that.profileColumns == null;
            }

            @Override
            public final int hashCode() {
                int result = this.columnStatisticsConfigurations != null ? this.columnStatisticsConfigurations.hashCode() : 0;
                result = 31 * result + (this.datasetStatisticsConfiguration != null ? this.datasetStatisticsConfiguration.hashCode() : 0);
                result = 31 * result + (this.entityDetectorConfiguration != null ? this.entityDetectorConfiguration.hashCode() : 0);
                result = 31 * result + (this.profileColumns != null ? this.profileColumns.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Represents one or more actions to be performed on a DataBrew dataset.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.databrew.*;
     * RecipeProperty recipeProperty = RecipeProperty.builder()
     *         .name("name")
     *         // the properties below are optional
     *         .version("version")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-job-recipe.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-job-recipe.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_databrew.CfnJob.RecipeProperty")
    @software.amazon.jsii.Jsii.Proxy(RecipeProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RecipeProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The unique name for the recipe.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-job-recipe.html#cfn-databrew-job-recipe-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-job-recipe.html#cfn-databrew-job-recipe-name</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * The identifier for the version for the recipe.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-job-recipe.html#cfn-databrew-job-recipe-version">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-job-recipe.html#cfn-databrew-job-recipe-version</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getVersion() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link RecipeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RecipeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RecipeProperty> {
            java.lang.String name;
            java.lang.String version;

            /**
             * Sets the value of {@link RecipeProperty#getName}
             * @param name The unique name for the recipe. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link RecipeProperty#getVersion}
             * @param version The identifier for the version for the recipe.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder version(java.lang.String version) {
                this.version = version;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RecipeProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RecipeProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RecipeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RecipeProperty {
            private final java.lang.String name;
            private final java.lang.String version;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.version = software.amazon.jsii.Kernel.get(this, "version", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
                this.version = builder.version;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.String getVersion() {
                return this.version;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("name", om.valueToTree(this.getName()));
                if (this.getVersion() != null) {
                    data.set("version", om.valueToTree(this.getVersion()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_databrew.CfnJob.RecipeProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RecipeProperty.Jsii$Proxy that = (RecipeProperty.Jsii$Proxy) o;

                if (!name.equals(that.name)) return false;
                return this.version != null ? this.version.equals(that.version) : that.version == null;
            }

            @Override
            public final int hashCode() {
                int result = this.name.hashCode();
                result = 31 * result + (this.version != null ? this.version.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Represents an Amazon S3 location (bucket name, bucket owner, and object key) where DataBrew can read input data, or write output from a job.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.databrew.*;
     * S3LocationProperty s3LocationProperty = S3LocationProperty.builder()
     *         .bucket("bucket")
     *         // the properties below are optional
     *         .bucketOwner("bucketOwner")
     *         .key("key")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-job-s3location.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-job-s3location.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_databrew.CfnJob.S3LocationProperty")
    @software.amazon.jsii.Jsii.Proxy(S3LocationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface S3LocationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon S3 bucket name.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-job-s3location.html#cfn-databrew-job-s3location-bucket">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-job-s3location.html#cfn-databrew-job-s3location-bucket</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getBucket();

        /**
         * The AWS account ID of the bucket owner.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-job-s3location.html#cfn-databrew-job-s3location-bucketowner">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-job-s3location.html#cfn-databrew-job-s3location-bucketowner</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getBucketOwner() {
            return null;
        }

        /**
         * The unique name of the object in the bucket.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-job-s3location.html#cfn-databrew-job-s3location-key">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-job-s3location.html#cfn-databrew-job-s3location-key</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getKey() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link S3LocationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link S3LocationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<S3LocationProperty> {
            java.lang.String bucket;
            java.lang.String bucketOwner;
            java.lang.String key;

            /**
             * Sets the value of {@link S3LocationProperty#getBucket}
             * @param bucket The Amazon S3 bucket name. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bucket(java.lang.String bucket) {
                this.bucket = bucket;
                return this;
            }

            /**
             * Sets the value of {@link S3LocationProperty#getBucketOwner}
             * @param bucketOwner The AWS account ID of the bucket owner.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bucketOwner(java.lang.String bucketOwner) {
                this.bucketOwner = bucketOwner;
                return this;
            }

            /**
             * Sets the value of {@link S3LocationProperty#getKey}
             * @param key The unique name of the object in the bucket.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder key(java.lang.String key) {
                this.key = key;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link S3LocationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public S3LocationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link S3LocationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements S3LocationProperty {
            private final java.lang.String bucket;
            private final java.lang.String bucketOwner;
            private final java.lang.String key;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.bucket = software.amazon.jsii.Kernel.get(this, "bucket", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.bucketOwner = software.amazon.jsii.Kernel.get(this, "bucketOwner", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.key = software.amazon.jsii.Kernel.get(this, "key", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.bucket = java.util.Objects.requireNonNull(builder.bucket, "bucket is required");
                this.bucketOwner = builder.bucketOwner;
                this.key = builder.key;
            }

            @Override
            public final java.lang.String getBucket() {
                return this.bucket;
            }

            @Override
            public final java.lang.String getBucketOwner() {
                return this.bucketOwner;
            }

            @Override
            public final java.lang.String getKey() {
                return this.key;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("bucket", om.valueToTree(this.getBucket()));
                if (this.getBucketOwner() != null) {
                    data.set("bucketOwner", om.valueToTree(this.getBucketOwner()));
                }
                if (this.getKey() != null) {
                    data.set("key", om.valueToTree(this.getKey()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_databrew.CfnJob.S3LocationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                S3LocationProperty.Jsii$Proxy that = (S3LocationProperty.Jsii$Proxy) o;

                if (!bucket.equals(that.bucket)) return false;
                if (this.bucketOwner != null ? !this.bucketOwner.equals(that.bucketOwner) : that.bucketOwner != null) return false;
                return this.key != null ? this.key.equals(that.key) : that.key == null;
            }

            @Override
            public final int hashCode() {
                int result = this.bucket.hashCode();
                result = 31 * result + (this.bucketOwner != null ? this.bucketOwner.hashCode() : 0);
                result = 31 * result + (this.key != null ? this.key.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Represents options that specify how and where DataBrew writes the Amazon S3 output generated by recipe jobs.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.databrew.*;
     * S3TableOutputOptionsProperty s3TableOutputOptionsProperty = S3TableOutputOptionsProperty.builder()
     *         .location(S3LocationProperty.builder()
     *                 .bucket("bucket")
     *                 // the properties below are optional
     *                 .bucketOwner("bucketOwner")
     *                 .key("key")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-job-s3tableoutputoptions.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-job-s3tableoutputoptions.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_databrew.CfnJob.S3TableOutputOptionsProperty")
    @software.amazon.jsii.Jsii.Proxy(S3TableOutputOptionsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface S3TableOutputOptionsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Represents an Amazon S3 location (bucket name and object key) where DataBrew can write output from a job.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-job-s3tableoutputoptions.html#cfn-databrew-job-s3tableoutputoptions-location">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-job-s3tableoutputoptions.html#cfn-databrew-job-s3tableoutputoptions-location</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getLocation();

        /**
         * @return a {@link Builder} of {@link S3TableOutputOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link S3TableOutputOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<S3TableOutputOptionsProperty> {
            java.lang.Object location;

            /**
             * Sets the value of {@link S3TableOutputOptionsProperty#getLocation}
             * @param location Represents an Amazon S3 location (bucket name and object key) where DataBrew can write output from a job. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder location(software.amazon.awscdk.IResolvable location) {
                this.location = location;
                return this;
            }

            /**
             * Sets the value of {@link S3TableOutputOptionsProperty#getLocation}
             * @param location Represents an Amazon S3 location (bucket name and object key) where DataBrew can write output from a job. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder location(software.amazon.awscdk.services.databrew.CfnJob.S3LocationProperty location) {
                this.location = location;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link S3TableOutputOptionsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public S3TableOutputOptionsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link S3TableOutputOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements S3TableOutputOptionsProperty {
            private final java.lang.Object location;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.location = software.amazon.jsii.Kernel.get(this, "location", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.location = java.util.Objects.requireNonNull(builder.location, "location is required");
            }

            @Override
            public final java.lang.Object getLocation() {
                return this.location;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("location", om.valueToTree(this.getLocation()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_databrew.CfnJob.S3TableOutputOptionsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                S3TableOutputOptionsProperty.Jsii$Proxy that = (S3TableOutputOptionsProperty.Jsii$Proxy) o;

                return this.location.equals(that.location);
            }

            @Override
            public final int hashCode() {
                int result = this.location.hashCode();
                return result;
            }
        }
    }
    /**
     * Override of a particular evaluation for a profile job.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.databrew.*;
     * StatisticOverrideProperty statisticOverrideProperty = StatisticOverrideProperty.builder()
     *         .parameters(Map.of(
     *                 "parametersKey", "parameters"))
     *         .statistic("statistic")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-job-statisticoverride.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-job-statisticoverride.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_databrew.CfnJob.StatisticOverrideProperty")
    @software.amazon.jsii.Jsii.Proxy(StatisticOverrideProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface StatisticOverrideProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A map that includes overrides of an evaluation’s parameters.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-job-statisticoverride.html#cfn-databrew-job-statisticoverride-parameters">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-job-statisticoverride.html#cfn-databrew-job-statisticoverride-parameters</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getParameters();

        /**
         * The name of an evaluation.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-job-statisticoverride.html#cfn-databrew-job-statisticoverride-statistic">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-job-statisticoverride.html#cfn-databrew-job-statisticoverride-statistic</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getStatistic();

        /**
         * @return a {@link Builder} of {@link StatisticOverrideProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link StatisticOverrideProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<StatisticOverrideProperty> {
            java.lang.Object parameters;
            java.lang.String statistic;

            /**
             * Sets the value of {@link StatisticOverrideProperty#getParameters}
             * @param parameters A map that includes overrides of an evaluation’s parameters. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder parameters(java.util.Map<java.lang.String, java.lang.String> parameters) {
                this.parameters = parameters;
                return this;
            }

            /**
             * Sets the value of {@link StatisticOverrideProperty#getParameters}
             * @param parameters A map that includes overrides of an evaluation’s parameters. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder parameters(software.amazon.awscdk.IResolvable parameters) {
                this.parameters = parameters;
                return this;
            }

            /**
             * Sets the value of {@link StatisticOverrideProperty#getStatistic}
             * @param statistic The name of an evaluation. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder statistic(java.lang.String statistic) {
                this.statistic = statistic;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link StatisticOverrideProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public StatisticOverrideProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link StatisticOverrideProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements StatisticOverrideProperty {
            private final java.lang.Object parameters;
            private final java.lang.String statistic;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.parameters = software.amazon.jsii.Kernel.get(this, "parameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.statistic = software.amazon.jsii.Kernel.get(this, "statistic", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.parameters = java.util.Objects.requireNonNull(builder.parameters, "parameters is required");
                this.statistic = java.util.Objects.requireNonNull(builder.statistic, "statistic is required");
            }

            @Override
            public final java.lang.Object getParameters() {
                return this.parameters;
            }

            @Override
            public final java.lang.String getStatistic() {
                return this.statistic;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("parameters", om.valueToTree(this.getParameters()));
                data.set("statistic", om.valueToTree(this.getStatistic()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_databrew.CfnJob.StatisticOverrideProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                StatisticOverrideProperty.Jsii$Proxy that = (StatisticOverrideProperty.Jsii$Proxy) o;

                if (!parameters.equals(that.parameters)) return false;
                return this.statistic.equals(that.statistic);
            }

            @Override
            public final int hashCode() {
                int result = this.parameters.hashCode();
                result = 31 * result + (this.statistic.hashCode());
                return result;
            }
        }
    }
    /**
     * Configuration of evaluations for a profile job.
     * <p>
     * This configuration can be used to select evaluations and override the parameters of selected evaluations.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.databrew.*;
     * StatisticsConfigurationProperty statisticsConfigurationProperty = StatisticsConfigurationProperty.builder()
     *         .includedStatistics(List.of("includedStatistics"))
     *         .overrides(List.of(StatisticOverrideProperty.builder()
     *                 .parameters(Map.of(
     *                         "parametersKey", "parameters"))
     *                 .statistic("statistic")
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-job-statisticsconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-job-statisticsconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_databrew.CfnJob.StatisticsConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(StatisticsConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface StatisticsConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * List of included evaluations.
         * <p>
         * When the list is undefined, all supported evaluations will be included.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-job-statisticsconfiguration.html#cfn-databrew-job-statisticsconfiguration-includedstatistics">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-job-statisticsconfiguration.html#cfn-databrew-job-statisticsconfiguration-includedstatistics</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getIncludedStatistics() {
            return null;
        }

        /**
         * List of overrides for evaluations.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-job-statisticsconfiguration.html#cfn-databrew-job-statisticsconfiguration-overrides">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-job-statisticsconfiguration.html#cfn-databrew-job-statisticsconfiguration-overrides</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getOverrides() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link StatisticsConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link StatisticsConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<StatisticsConfigurationProperty> {
            java.util.List<java.lang.String> includedStatistics;
            java.lang.Object overrides;

            /**
             * Sets the value of {@link StatisticsConfigurationProperty#getIncludedStatistics}
             * @param includedStatistics List of included evaluations.
             *                           When the list is undefined, all supported evaluations will be included.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder includedStatistics(java.util.List<java.lang.String> includedStatistics) {
                this.includedStatistics = includedStatistics;
                return this;
            }

            /**
             * Sets the value of {@link StatisticsConfigurationProperty#getOverrides}
             * @param overrides List of overrides for evaluations.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder overrides(software.amazon.awscdk.IResolvable overrides) {
                this.overrides = overrides;
                return this;
            }

            /**
             * Sets the value of {@link StatisticsConfigurationProperty#getOverrides}
             * @param overrides List of overrides for evaluations.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder overrides(java.util.List<? extends java.lang.Object> overrides) {
                this.overrides = overrides;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link StatisticsConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public StatisticsConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link StatisticsConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements StatisticsConfigurationProperty {
            private final java.util.List<java.lang.String> includedStatistics;
            private final java.lang.Object overrides;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.includedStatistics = software.amazon.jsii.Kernel.get(this, "includedStatistics", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.overrides = software.amazon.jsii.Kernel.get(this, "overrides", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.includedStatistics = builder.includedStatistics;
                this.overrides = builder.overrides;
            }

            @Override
            public final java.util.List<java.lang.String> getIncludedStatistics() {
                return this.includedStatistics;
            }

            @Override
            public final java.lang.Object getOverrides() {
                return this.overrides;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getIncludedStatistics() != null) {
                    data.set("includedStatistics", om.valueToTree(this.getIncludedStatistics()));
                }
                if (this.getOverrides() != null) {
                    data.set("overrides", om.valueToTree(this.getOverrides()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_databrew.CfnJob.StatisticsConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                StatisticsConfigurationProperty.Jsii$Proxy that = (StatisticsConfigurationProperty.Jsii$Proxy) o;

                if (this.includedStatistics != null ? !this.includedStatistics.equals(that.includedStatistics) : that.includedStatistics != null) return false;
                return this.overrides != null ? this.overrides.equals(that.overrides) : that.overrides == null;
            }

            @Override
            public final int hashCode() {
                int result = this.includedStatistics != null ? this.includedStatistics.hashCode() : 0;
                result = 31 * result + (this.overrides != null ? this.overrides.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Configuration for data quality validation.
     * <p>
     * Used to select the Rulesets and Validation Mode to be used in the profile job. When ValidationConfiguration is null, the profile job will run without data quality validation.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.databrew.*;
     * ValidationConfigurationProperty validationConfigurationProperty = ValidationConfigurationProperty.builder()
     *         .rulesetArn("rulesetArn")
     *         // the properties below are optional
     *         .validationMode("validationMode")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-job-validationconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-job-validationconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_databrew.CfnJob.ValidationConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(ValidationConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ValidationConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon Resource Name (ARN) for the ruleset to be validated in the profile job.
         * <p>
         * The TargetArn of the selected ruleset should be the same as the Amazon Resource Name (ARN) of the dataset that is associated with the profile job.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-job-validationconfiguration.html#cfn-databrew-job-validationconfiguration-rulesetarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-job-validationconfiguration.html#cfn-databrew-job-validationconfiguration-rulesetarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getRulesetArn();

        /**
         * Mode of data quality validation.
         * <p>
         * Default mode is “CHECK_ALL” which verifies all rules defined in the selected ruleset.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-job-validationconfiguration.html#cfn-databrew-job-validationconfiguration-validationmode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-job-validationconfiguration.html#cfn-databrew-job-validationconfiguration-validationmode</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getValidationMode() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ValidationConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ValidationConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ValidationConfigurationProperty> {
            java.lang.String rulesetArn;
            java.lang.String validationMode;

            /**
             * Sets the value of {@link ValidationConfigurationProperty#getRulesetArn}
             * @param rulesetArn The Amazon Resource Name (ARN) for the ruleset to be validated in the profile job. This parameter is required.
             *                   The TargetArn of the selected ruleset should be the same as the Amazon Resource Name (ARN) of the dataset that is associated with the profile job.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rulesetArn(java.lang.String rulesetArn) {
                this.rulesetArn = rulesetArn;
                return this;
            }

            /**
             * Sets the value of {@link ValidationConfigurationProperty#getValidationMode}
             * @param validationMode Mode of data quality validation.
             *                       Default mode is “CHECK_ALL” which verifies all rules defined in the selected ruleset.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder validationMode(java.lang.String validationMode) {
                this.validationMode = validationMode;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ValidationConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ValidationConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ValidationConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ValidationConfigurationProperty {
            private final java.lang.String rulesetArn;
            private final java.lang.String validationMode;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.rulesetArn = software.amazon.jsii.Kernel.get(this, "rulesetArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.validationMode = software.amazon.jsii.Kernel.get(this, "validationMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.rulesetArn = java.util.Objects.requireNonNull(builder.rulesetArn, "rulesetArn is required");
                this.validationMode = builder.validationMode;
            }

            @Override
            public final java.lang.String getRulesetArn() {
                return this.rulesetArn;
            }

            @Override
            public final java.lang.String getValidationMode() {
                return this.validationMode;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("rulesetArn", om.valueToTree(this.getRulesetArn()));
                if (this.getValidationMode() != null) {
                    data.set("validationMode", om.valueToTree(this.getValidationMode()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_databrew.CfnJob.ValidationConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ValidationConfigurationProperty.Jsii$Proxy that = (ValidationConfigurationProperty.Jsii$Proxy) o;

                if (!rulesetArn.equals(that.rulesetArn)) return false;
                return this.validationMode != null ? this.validationMode.equals(that.validationMode) : that.validationMode == null;
            }

            @Override
            public final int hashCode() {
                int result = this.rulesetArn.hashCode();
                result = 31 * result + (this.validationMode != null ? this.validationMode.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.databrew.CfnJob}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.databrew.CfnJob> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.databrew.CfnJobProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.databrew.CfnJobProps.Builder();
        }

        /**
         * The unique name of the job.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-databrew-job.html#cfn-databrew-job-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-databrew-job.html#cfn-databrew-job-name</a>
         * @param name The unique name of the job. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props.name(name);
            return this;
        }

        /**
         * The Amazon Resource Name (ARN) of the role to be assumed for this job.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-databrew-job.html#cfn-databrew-job-rolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-databrew-job.html#cfn-databrew-job-rolearn</a>
         * @param roleArn The Amazon Resource Name (ARN) of the role to be assumed for this job. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder roleArn(final java.lang.String roleArn) {
            this.props.roleArn(roleArn);
            return this;
        }

        /**
         * The job type of the job, which must be one of the following:.
         * <p>
         * <ul>
         * <li><code>PROFILE</code> - A job to analyze a dataset, to determine its size, data types, data distribution, and more.</li>
         * <li><code>RECIPE</code> - A job to apply one or more transformations to a dataset.</li>
         * </ul>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-databrew-job.html#cfn-databrew-job-type">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-databrew-job.html#cfn-databrew-job-type</a>
         * @param type The job type of the job, which must be one of the following:. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder type(final java.lang.String type) {
            this.props.type(type);
            return this;
        }

        /**
         * Represents a list of JDBC database output objects which defines the output destination for a DataBrew recipe job to write into.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-databrew-job.html#cfn-databrew-job-databaseoutputs">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-databrew-job.html#cfn-databrew-job-databaseoutputs</a>
         * @param databaseOutputs Represents a list of JDBC database output objects which defines the output destination for a DataBrew recipe job to write into. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder databaseOutputs(final software.amazon.awscdk.IResolvable databaseOutputs) {
            this.props.databaseOutputs(databaseOutputs);
            return this;
        }
        /**
         * Represents a list of JDBC database output objects which defines the output destination for a DataBrew recipe job to write into.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-databrew-job.html#cfn-databrew-job-databaseoutputs">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-databrew-job.html#cfn-databrew-job-databaseoutputs</a>
         * @param databaseOutputs Represents a list of JDBC database output objects which defines the output destination for a DataBrew recipe job to write into. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder databaseOutputs(final java.util.List<? extends java.lang.Object> databaseOutputs) {
            this.props.databaseOutputs(databaseOutputs);
            return this;
        }

        /**
         * One or more artifacts that represent the AWS Glue Data Catalog output from running the job.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-databrew-job.html#cfn-databrew-job-datacatalogoutputs">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-databrew-job.html#cfn-databrew-job-datacatalogoutputs</a>
         * @param dataCatalogOutputs One or more artifacts that represent the AWS Glue Data Catalog output from running the job. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dataCatalogOutputs(final software.amazon.awscdk.IResolvable dataCatalogOutputs) {
            this.props.dataCatalogOutputs(dataCatalogOutputs);
            return this;
        }
        /**
         * One or more artifacts that represent the AWS Glue Data Catalog output from running the job.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-databrew-job.html#cfn-databrew-job-datacatalogoutputs">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-databrew-job.html#cfn-databrew-job-datacatalogoutputs</a>
         * @param dataCatalogOutputs One or more artifacts that represent the AWS Glue Data Catalog output from running the job. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dataCatalogOutputs(final java.util.List<? extends java.lang.Object> dataCatalogOutputs) {
            this.props.dataCatalogOutputs(dataCatalogOutputs);
            return this;
        }

        /**
         * A dataset that the job is to process.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-databrew-job.html#cfn-databrew-job-datasetname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-databrew-job.html#cfn-databrew-job-datasetname</a>
         * @param datasetName A dataset that the job is to process. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder datasetName(final java.lang.String datasetName) {
            this.props.datasetName(datasetName);
            return this;
        }

        /**
         * The Amazon Resource Name (ARN) of an encryption key that is used to protect the job output.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/databrew/latest/dg/encryption-security-configuration.html">Encrypting data written by DataBrew jobs</a>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-databrew-job.html#cfn-databrew-job-encryptionkeyarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-databrew-job.html#cfn-databrew-job-encryptionkeyarn</a>
         * @param encryptionKeyArn The Amazon Resource Name (ARN) of an encryption key that is used to protect the job output. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder encryptionKeyArn(final java.lang.String encryptionKeyArn) {
            this.props.encryptionKeyArn(encryptionKeyArn);
            return this;
        }

        /**
         * The encryption mode for the job, which can be one of the following:.
         * <p>
         * <ul>
         * <li><code>SSE-KMS</code> - Server-side encryption with keys managed by AWS KMS .</li>
         * <li><code>SSE-S3</code> - Server-side encryption with keys managed by Amazon S3.</li>
         * </ul>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-databrew-job.html#cfn-databrew-job-encryptionmode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-databrew-job.html#cfn-databrew-job-encryptionmode</a>
         * @param encryptionMode The encryption mode for the job, which can be one of the following:. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder encryptionMode(final java.lang.String encryptionMode) {
            this.props.encryptionMode(encryptionMode);
            return this;
        }

        /**
         * A sample configuration for profile jobs only, which determines the number of rows on which the profile job is run.
         * <p>
         * If a <code>JobSample</code> value isn't provided, the default value is used. The default value is CUSTOM_ROWS for the mode parameter and 20,000 for the size parameter.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-databrew-job.html#cfn-databrew-job-jobsample">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-databrew-job.html#cfn-databrew-job-jobsample</a>
         * @param jobSample A sample configuration for profile jobs only, which determines the number of rows on which the profile job is run. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder jobSample(final software.amazon.awscdk.IResolvable jobSample) {
            this.props.jobSample(jobSample);
            return this;
        }
        /**
         * A sample configuration for profile jobs only, which determines the number of rows on which the profile job is run.
         * <p>
         * If a <code>JobSample</code> value isn't provided, the default value is used. The default value is CUSTOM_ROWS for the mode parameter and 20,000 for the size parameter.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-databrew-job.html#cfn-databrew-job-jobsample">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-databrew-job.html#cfn-databrew-job-jobsample</a>
         * @param jobSample A sample configuration for profile jobs only, which determines the number of rows on which the profile job is run. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder jobSample(final software.amazon.awscdk.services.databrew.CfnJob.JobSampleProperty jobSample) {
            this.props.jobSample(jobSample);
            return this;
        }

        /**
         * The current status of Amazon CloudWatch logging for the job.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-databrew-job.html#cfn-databrew-job-logsubscription">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-databrew-job.html#cfn-databrew-job-logsubscription</a>
         * @param logSubscription The current status of Amazon CloudWatch logging for the job. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logSubscription(final java.lang.String logSubscription) {
            this.props.logSubscription(logSubscription);
            return this;
        }

        /**
         * The maximum number of nodes that can be consumed when the job processes data.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-databrew-job.html#cfn-databrew-job-maxcapacity">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-databrew-job.html#cfn-databrew-job-maxcapacity</a>
         * @param maxCapacity The maximum number of nodes that can be consumed when the job processes data. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxCapacity(final java.lang.Number maxCapacity) {
            this.props.maxCapacity(maxCapacity);
            return this;
        }

        /**
         * The maximum number of times to retry the job after a job run fails.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-databrew-job.html#cfn-databrew-job-maxretries">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-databrew-job.html#cfn-databrew-job-maxretries</a>
         * @param maxRetries The maximum number of times to retry the job after a job run fails. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxRetries(final java.lang.Number maxRetries) {
            this.props.maxRetries(maxRetries);
            return this;
        }

        /**
         * The location in Amazon S3 where the job writes its output.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-databrew-job.html#cfn-databrew-job-outputlocation">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-databrew-job.html#cfn-databrew-job-outputlocation</a>
         * @param outputLocation The location in Amazon S3 where the job writes its output. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder outputLocation(final software.amazon.awscdk.IResolvable outputLocation) {
            this.props.outputLocation(outputLocation);
            return this;
        }
        /**
         * The location in Amazon S3 where the job writes its output.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-databrew-job.html#cfn-databrew-job-outputlocation">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-databrew-job.html#cfn-databrew-job-outputlocation</a>
         * @param outputLocation The location in Amazon S3 where the job writes its output. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder outputLocation(final software.amazon.awscdk.services.databrew.CfnJob.OutputLocationProperty outputLocation) {
            this.props.outputLocation(outputLocation);
            return this;
        }

        /**
         * One or more artifacts that represent output from running the job.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-databrew-job.html#cfn-databrew-job-outputs">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-databrew-job.html#cfn-databrew-job-outputs</a>
         * @param outputs One or more artifacts that represent output from running the job. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder outputs(final software.amazon.awscdk.IResolvable outputs) {
            this.props.outputs(outputs);
            return this;
        }
        /**
         * One or more artifacts that represent output from running the job.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-databrew-job.html#cfn-databrew-job-outputs">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-databrew-job.html#cfn-databrew-job-outputs</a>
         * @param outputs One or more artifacts that represent output from running the job. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder outputs(final java.util.List<? extends java.lang.Object> outputs) {
            this.props.outputs(outputs);
            return this;
        }

        /**
         * Configuration for profile jobs.
         * <p>
         * Configuration can be used to select columns, do evaluations, and override default parameters of evaluations. When configuration is undefined, the profile job will apply default settings to all supported columns.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-databrew-job.html#cfn-databrew-job-profileconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-databrew-job.html#cfn-databrew-job-profileconfiguration</a>
         * @param profileConfiguration Configuration for profile jobs. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder profileConfiguration(final software.amazon.awscdk.IResolvable profileConfiguration) {
            this.props.profileConfiguration(profileConfiguration);
            return this;
        }
        /**
         * Configuration for profile jobs.
         * <p>
         * Configuration can be used to select columns, do evaluations, and override default parameters of evaluations. When configuration is undefined, the profile job will apply default settings to all supported columns.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-databrew-job.html#cfn-databrew-job-profileconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-databrew-job.html#cfn-databrew-job-profileconfiguration</a>
         * @param profileConfiguration Configuration for profile jobs. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder profileConfiguration(final software.amazon.awscdk.services.databrew.CfnJob.ProfileConfigurationProperty profileConfiguration) {
            this.props.profileConfiguration(profileConfiguration);
            return this;
        }

        /**
         * The name of the project that the job is associated with.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-databrew-job.html#cfn-databrew-job-projectname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-databrew-job.html#cfn-databrew-job-projectname</a>
         * @param projectName The name of the project that the job is associated with. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder projectName(final java.lang.String projectName) {
            this.props.projectName(projectName);
            return this;
        }

        /**
         * A series of data transformation steps that the job runs.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-databrew-job.html#cfn-databrew-job-recipe">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-databrew-job.html#cfn-databrew-job-recipe</a>
         * @param recipe A series of data transformation steps that the job runs. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder recipe(final software.amazon.awscdk.IResolvable recipe) {
            this.props.recipe(recipe);
            return this;
        }
        /**
         * A series of data transformation steps that the job runs.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-databrew-job.html#cfn-databrew-job-recipe">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-databrew-job.html#cfn-databrew-job-recipe</a>
         * @param recipe A series of data transformation steps that the job runs. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder recipe(final software.amazon.awscdk.services.databrew.CfnJob.RecipeProperty recipe) {
            this.props.recipe(recipe);
            return this;
        }

        /**
         * Metadata tags that have been applied to the job.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-databrew-job.html#cfn-databrew-job-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-databrew-job.html#cfn-databrew-job-tags</a>
         * @param tags Metadata tags that have been applied to the job. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * The job's timeout in minutes.
         * <p>
         * A job that attempts to run longer than this timeout period ends with a status of <code>TIMEOUT</code> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-databrew-job.html#cfn-databrew-job-timeout">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-databrew-job.html#cfn-databrew-job-timeout</a>
         * @param timeout The job's timeout in minutes. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder timeout(final java.lang.Number timeout) {
            this.props.timeout(timeout);
            return this;
        }

        /**
         * List of validation configurations that are applied to the profile job.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-databrew-job.html#cfn-databrew-job-validationconfigurations">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-databrew-job.html#cfn-databrew-job-validationconfigurations</a>
         * @param validationConfigurations List of validation configurations that are applied to the profile job. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder validationConfigurations(final software.amazon.awscdk.IResolvable validationConfigurations) {
            this.props.validationConfigurations(validationConfigurations);
            return this;
        }
        /**
         * List of validation configurations that are applied to the profile job.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-databrew-job.html#cfn-databrew-job-validationconfigurations">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-databrew-job.html#cfn-databrew-job-validationconfigurations</a>
         * @param validationConfigurations List of validation configurations that are applied to the profile job. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder validationConfigurations(final java.util.List<? extends java.lang.Object> validationConfigurations) {
            this.props.validationConfigurations(validationConfigurations);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.databrew.CfnJob}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.databrew.CfnJob build() {
            return new software.amazon.awscdk.services.databrew.CfnJob(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
