package software.amazon.awscdk.services.deadline;

/**
 * Properties for defining a <code>CfnQueue</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.deadline.*;
 * CfnQueueProps cfnQueueProps = CfnQueueProps.builder()
 *         .displayName("displayName")
 *         .farmId("farmId")
 *         // the properties below are optional
 *         .allowedStorageProfileIds(List.of("allowedStorageProfileIds"))
 *         .defaultBudgetAction("defaultBudgetAction")
 *         .description("description")
 *         .jobAttachmentSettings(JobAttachmentSettingsProperty.builder()
 *                 .rootPrefix("rootPrefix")
 *                 .s3BucketName("s3BucketName")
 *                 .build())
 *         .jobRunAsUser(JobRunAsUserProperty.builder()
 *                 .runAs("runAs")
 *                 // the properties below are optional
 *                 .posix(PosixUserProperty.builder()
 *                         .group("group")
 *                         .user("user")
 *                         .build())
 *                 .windows(WindowsUserProperty.builder()
 *                         .passwordArn("passwordArn")
 *                         .user("user")
 *                         .build())
 *                 .build())
 *         .requiredFileSystemLocationNames(List.of("requiredFileSystemLocationNames"))
 *         .roleArn("roleArn")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-deadline-queue.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-deadline-queue.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-08-06T18:14:35.456Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_deadline.CfnQueueProps")
@software.amazon.jsii.Jsii.Proxy(CfnQueueProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnQueueProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The display name of the queue summary to update.
     * <p>
     * <blockquote>
     * <p>
     * This field can store any content. Escape or encode this content before displaying it on a webpage or any other system that might interpret the content of this field.
     * <p>
     * </blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-deadline-queue.html#cfn-deadline-queue-displayname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-deadline-queue.html#cfn-deadline-queue-displayname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDisplayName();

    /**
     * The farm ID.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-deadline-queue.html#cfn-deadline-queue-farmid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-deadline-queue.html#cfn-deadline-queue-farmid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getFarmId();

    /**
     * The identifiers of the storage profiles that this queue can use to share assets between workers using different operating systems.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-deadline-queue.html#cfn-deadline-queue-allowedstorageprofileids">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-deadline-queue.html#cfn-deadline-queue-allowedstorageprofileids</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getAllowedStorageProfileIds() {
        return null;
    }

    /**
     * The default action taken on a queue summary if a budget wasn't configured.
     * <p>
     * Default: - "NONE"
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-deadline-queue.html#cfn-deadline-queue-defaultbudgetaction">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-deadline-queue.html#cfn-deadline-queue-defaultbudgetaction</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDefaultBudgetAction() {
        return null;
    }

    /**
     * A description of the queue that helps identify what the queue is used for.
     * <p>
     * <blockquote>
     * <p>
     * This field can store any content. Escape or encode this content before displaying it on a webpage or any other system that might interpret the content of this field.
     * <p>
     * </blockquote>
     * <p>
     * Default: - ""
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-deadline-queue.html#cfn-deadline-queue-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-deadline-queue.html#cfn-deadline-queue-description</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * The job attachment settings.
     * <p>
     * These are the Amazon S3 bucket name and the Amazon S3 prefix.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-deadline-queue.html#cfn-deadline-queue-jobattachmentsettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-deadline-queue.html#cfn-deadline-queue-jobattachmentsettings</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getJobAttachmentSettings() {
        return null;
    }

    /**
     * Identifies the user for a job.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-deadline-queue.html#cfn-deadline-queue-jobrunasuser">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-deadline-queue.html#cfn-deadline-queue-jobrunasuser</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getJobRunAsUser() {
        return null;
    }

    /**
     * The file system location that the queue uses.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-deadline-queue.html#cfn-deadline-queue-requiredfilesystemlocationnames">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-deadline-queue.html#cfn-deadline-queue-requiredfilesystemlocationnames</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getRequiredFileSystemLocationNames() {
        return null;
    }

    /**
     * The Amazon Resource Name (ARN) of the IAM role that workers use when running jobs in this queue.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-deadline-queue.html#cfn-deadline-queue-rolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-deadline-queue.html#cfn-deadline-queue-rolearn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getRoleArn() {
        return null;
    }

    /**
     * The tags to add to your queue.
     * <p>
     * Each tag consists of a tag key and a tag value. Tag keys and values are both required, but tag values can be empty strings.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-deadline-queue.html#cfn-deadline-queue-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-deadline-queue.html#cfn-deadline-queue-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnQueueProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnQueueProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnQueueProps> {
        java.lang.String displayName;
        java.lang.String farmId;
        java.util.List<java.lang.String> allowedStorageProfileIds;
        java.lang.String defaultBudgetAction;
        java.lang.String description;
        java.lang.Object jobAttachmentSettings;
        java.lang.Object jobRunAsUser;
        java.util.List<java.lang.String> requiredFileSystemLocationNames;
        java.lang.String roleArn;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnQueueProps#getDisplayName}
         * @param displayName The display name of the queue summary to update. This parameter is required.
         *                    <blockquote>
         *                    <p>
         *                    This field can store any content. Escape or encode this content before displaying it on a webpage or any other system that might interpret the content of this field.
         *                    <p>
         *                    </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder displayName(java.lang.String displayName) {
            this.displayName = displayName;
            return this;
        }

        /**
         * Sets the value of {@link CfnQueueProps#getFarmId}
         * @param farmId The farm ID. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder farmId(java.lang.String farmId) {
            this.farmId = farmId;
            return this;
        }

        /**
         * Sets the value of {@link CfnQueueProps#getAllowedStorageProfileIds}
         * @param allowedStorageProfileIds The identifiers of the storage profiles that this queue can use to share assets between workers using different operating systems.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder allowedStorageProfileIds(java.util.List<java.lang.String> allowedStorageProfileIds) {
            this.allowedStorageProfileIds = allowedStorageProfileIds;
            return this;
        }

        /**
         * Sets the value of {@link CfnQueueProps#getDefaultBudgetAction}
         * @param defaultBudgetAction The default action taken on a queue summary if a budget wasn't configured.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultBudgetAction(java.lang.String defaultBudgetAction) {
            this.defaultBudgetAction = defaultBudgetAction;
            return this;
        }

        /**
         * Sets the value of {@link CfnQueueProps#getDescription}
         * @param description A description of the queue that helps identify what the queue is used for.
         *                    <blockquote>
         *                    <p>
         *                    This field can store any content. Escape or encode this content before displaying it on a webpage or any other system that might interpret the content of this field.
         *                    <p>
         *                    </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CfnQueueProps#getJobAttachmentSettings}
         * @param jobAttachmentSettings The job attachment settings.
         *                              These are the Amazon S3 bucket name and the Amazon S3 prefix.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder jobAttachmentSettings(software.amazon.awscdk.IResolvable jobAttachmentSettings) {
            this.jobAttachmentSettings = jobAttachmentSettings;
            return this;
        }

        /**
         * Sets the value of {@link CfnQueueProps#getJobAttachmentSettings}
         * @param jobAttachmentSettings The job attachment settings.
         *                              These are the Amazon S3 bucket name and the Amazon S3 prefix.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder jobAttachmentSettings(software.amazon.awscdk.services.deadline.CfnQueue.JobAttachmentSettingsProperty jobAttachmentSettings) {
            this.jobAttachmentSettings = jobAttachmentSettings;
            return this;
        }

        /**
         * Sets the value of {@link CfnQueueProps#getJobRunAsUser}
         * @param jobRunAsUser Identifies the user for a job.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder jobRunAsUser(software.amazon.awscdk.IResolvable jobRunAsUser) {
            this.jobRunAsUser = jobRunAsUser;
            return this;
        }

        /**
         * Sets the value of {@link CfnQueueProps#getJobRunAsUser}
         * @param jobRunAsUser Identifies the user for a job.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder jobRunAsUser(software.amazon.awscdk.services.deadline.CfnQueue.JobRunAsUserProperty jobRunAsUser) {
            this.jobRunAsUser = jobRunAsUser;
            return this;
        }

        /**
         * Sets the value of {@link CfnQueueProps#getRequiredFileSystemLocationNames}
         * @param requiredFileSystemLocationNames The file system location that the queue uses.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder requiredFileSystemLocationNames(java.util.List<java.lang.String> requiredFileSystemLocationNames) {
            this.requiredFileSystemLocationNames = requiredFileSystemLocationNames;
            return this;
        }

        /**
         * Sets the value of {@link CfnQueueProps#getRoleArn}
         * @param roleArn The Amazon Resource Name (ARN) of the IAM role that workers use when running jobs in this queue.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder roleArn(java.lang.String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnQueueProps#getTags}
         * @param tags The tags to add to your queue.
         *             Each tag consists of a tag key and a tag value. Tag keys and values are both required, but tag values can be empty strings.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnQueueProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnQueueProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnQueueProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnQueueProps {
        private final java.lang.String displayName;
        private final java.lang.String farmId;
        private final java.util.List<java.lang.String> allowedStorageProfileIds;
        private final java.lang.String defaultBudgetAction;
        private final java.lang.String description;
        private final java.lang.Object jobAttachmentSettings;
        private final java.lang.Object jobRunAsUser;
        private final java.util.List<java.lang.String> requiredFileSystemLocationNames;
        private final java.lang.String roleArn;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.displayName = software.amazon.jsii.Kernel.get(this, "displayName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.farmId = software.amazon.jsii.Kernel.get(this, "farmId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.allowedStorageProfileIds = software.amazon.jsii.Kernel.get(this, "allowedStorageProfileIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.defaultBudgetAction = software.amazon.jsii.Kernel.get(this, "defaultBudgetAction", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.jobAttachmentSettings = software.amazon.jsii.Kernel.get(this, "jobAttachmentSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.jobRunAsUser = software.amazon.jsii.Kernel.get(this, "jobRunAsUser", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.requiredFileSystemLocationNames = software.amazon.jsii.Kernel.get(this, "requiredFileSystemLocationNames", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.roleArn = software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.displayName = java.util.Objects.requireNonNull(builder.displayName, "displayName is required");
            this.farmId = java.util.Objects.requireNonNull(builder.farmId, "farmId is required");
            this.allowedStorageProfileIds = builder.allowedStorageProfileIds;
            this.defaultBudgetAction = builder.defaultBudgetAction;
            this.description = builder.description;
            this.jobAttachmentSettings = builder.jobAttachmentSettings;
            this.jobRunAsUser = builder.jobRunAsUser;
            this.requiredFileSystemLocationNames = builder.requiredFileSystemLocationNames;
            this.roleArn = builder.roleArn;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.String getDisplayName() {
            return this.displayName;
        }

        @Override
        public final java.lang.String getFarmId() {
            return this.farmId;
        }

        @Override
        public final java.util.List<java.lang.String> getAllowedStorageProfileIds() {
            return this.allowedStorageProfileIds;
        }

        @Override
        public final java.lang.String getDefaultBudgetAction() {
            return this.defaultBudgetAction;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.Object getJobAttachmentSettings() {
            return this.jobAttachmentSettings;
        }

        @Override
        public final java.lang.Object getJobRunAsUser() {
            return this.jobRunAsUser;
        }

        @Override
        public final java.util.List<java.lang.String> getRequiredFileSystemLocationNames() {
            return this.requiredFileSystemLocationNames;
        }

        @Override
        public final java.lang.String getRoleArn() {
            return this.roleArn;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("displayName", om.valueToTree(this.getDisplayName()));
            data.set("farmId", om.valueToTree(this.getFarmId()));
            if (this.getAllowedStorageProfileIds() != null) {
                data.set("allowedStorageProfileIds", om.valueToTree(this.getAllowedStorageProfileIds()));
            }
            if (this.getDefaultBudgetAction() != null) {
                data.set("defaultBudgetAction", om.valueToTree(this.getDefaultBudgetAction()));
            }
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getJobAttachmentSettings() != null) {
                data.set("jobAttachmentSettings", om.valueToTree(this.getJobAttachmentSettings()));
            }
            if (this.getJobRunAsUser() != null) {
                data.set("jobRunAsUser", om.valueToTree(this.getJobRunAsUser()));
            }
            if (this.getRequiredFileSystemLocationNames() != null) {
                data.set("requiredFileSystemLocationNames", om.valueToTree(this.getRequiredFileSystemLocationNames()));
            }
            if (this.getRoleArn() != null) {
                data.set("roleArn", om.valueToTree(this.getRoleArn()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_deadline.CfnQueueProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnQueueProps.Jsii$Proxy that = (CfnQueueProps.Jsii$Proxy) o;

            if (!displayName.equals(that.displayName)) return false;
            if (!farmId.equals(that.farmId)) return false;
            if (this.allowedStorageProfileIds != null ? !this.allowedStorageProfileIds.equals(that.allowedStorageProfileIds) : that.allowedStorageProfileIds != null) return false;
            if (this.defaultBudgetAction != null ? !this.defaultBudgetAction.equals(that.defaultBudgetAction) : that.defaultBudgetAction != null) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.jobAttachmentSettings != null ? !this.jobAttachmentSettings.equals(that.jobAttachmentSettings) : that.jobAttachmentSettings != null) return false;
            if (this.jobRunAsUser != null ? !this.jobRunAsUser.equals(that.jobRunAsUser) : that.jobRunAsUser != null) return false;
            if (this.requiredFileSystemLocationNames != null ? !this.requiredFileSystemLocationNames.equals(that.requiredFileSystemLocationNames) : that.requiredFileSystemLocationNames != null) return false;
            if (this.roleArn != null ? !this.roleArn.equals(that.roleArn) : that.roleArn != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.displayName.hashCode();
            result = 31 * result + (this.farmId.hashCode());
            result = 31 * result + (this.allowedStorageProfileIds != null ? this.allowedStorageProfileIds.hashCode() : 0);
            result = 31 * result + (this.defaultBudgetAction != null ? this.defaultBudgetAction.hashCode() : 0);
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.jobAttachmentSettings != null ? this.jobAttachmentSettings.hashCode() : 0);
            result = 31 * result + (this.jobRunAsUser != null ? this.jobRunAsUser.hashCode() : 0);
            result = 31 * result + (this.requiredFileSystemLocationNames != null ? this.requiredFileSystemLocationNames.hashCode() : 0);
            result = 31 * result + (this.roleArn != null ? this.roleArn.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
