package software.amazon.awscdk.services.dynamodb;

/**
 * Represents the amount of read and write operations supported by a DynamoDB table.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.*;
 * App app = new App();
 * Stack stack = Stack.Builder.create(app, "Stack").env(Environment.builder().region("us-west-2").build()).build();
 * TableV2 globalTable = TableV2.Builder.create(stack, "GlobalTable")
 *         .partitionKey(Attribute.builder().name("pk").type(AttributeType.STRING).build())
 *         .billing(Billing.provisioned(ThroughputProps.builder()
 *                 .readCapacity(Capacity.fixed(10))
 *                 .writeCapacity(Capacity.autoscaled(AutoscaledCapacityOptions.builder().maxCapacity(15).build()))
 *                 .build()))
 *         .replicas(List.of(ReplicaTableProps.builder()
 *                 .region("us-east-1")
 *                 .build(), ReplicaTableProps.builder()
 *                 .region("us-east-2")
 *                 .readCapacity(Capacity.autoscaled(AutoscaledCapacityOptions.builder().maxCapacity(20).targetUtilizationPercent(50).build()))
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-08-06T18:14:35.711Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_dynamodb.Capacity")
public abstract class Capacity extends software.amazon.jsii.JsiiObject {

    protected Capacity(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Capacity(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * Dynamically adjusts provisioned throughput capacity on your behalf in response to actual traffic patterns.
     * <p>
     * @param options options used to configure autoscaled capacity mode. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.dynamodb.Capacity autoscaled(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.dynamodb.AutoscaledCapacityOptions options) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.dynamodb.Capacity.class, "autoscaled", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.dynamodb.Capacity.class), new Object[] { java.util.Objects.requireNonNull(options, "options is required") });
    }

    /**
     * Provisioned throughput capacity is configured with fixed capacity units.
     * <p>
     * Note: You cannot configure write capacity using fixed capacity mode.
     * <p>
     * @param iops the number of I/O operations per second. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.dynamodb.Capacity fixed(final @org.jetbrains.annotations.NotNull java.lang.Number iops) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.dynamodb.Capacity.class, "fixed", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.dynamodb.Capacity.class), new Object[] { java.util.Objects.requireNonNull(iops, "iops is required") });
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.dynamodb.CapacityMode getMode() {
        return software.amazon.jsii.Kernel.get(this, "mode", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.dynamodb.CapacityMode.class));
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    @software.amazon.jsii.Internal
    private static final class Jsii$Proxy extends software.amazon.awscdk.services.dynamodb.Capacity {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }
    }
}
