package software.amazon.awscdk.services.dynamodb;

/**
 * A DynamoDB Table.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.*;
 * App app = new App();
 * Stack stack = Stack.Builder.create(app, "Stack").env(Environment.builder().region("us-west-2").build()).build();
 * TableV2 globalTable = TableV2.Builder.create(stack, "GlobalTable")
 *         .partitionKey(Attribute.builder().name("pk").type(AttributeType.STRING).build())
 *         // applies to all replicas, i.e., us-west-2, us-east-1, us-east-2
 *         .removalPolicy(RemovalPolicy.DESTROY)
 *         .replicas(List.of(ReplicaTableProps.builder().region("us-east-1").build(), ReplicaTableProps.builder().region("us-east-2").build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-08-06T18:14:35.795Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_dynamodb.TableV2")
public class TableV2 extends software.amazon.awscdk.services.dynamodb.TableBaseV2 {

    protected TableV2(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected TableV2(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        PROPERTY_INJECTION_ID = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.dynamodb.TableV2.class, "PROPERTY_INJECTION_ID", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public TableV2(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.dynamodb.TablePropsV2 props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Creates a Table construct that represents an external table via table ARN.
     * <p>
     * @param scope the parent creating construct (usually <code>this</code>). This parameter is required.
     * @param id the construct's name. This parameter is required.
     * @param tableArn the table's ARN. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.dynamodb.ITableV2 fromTableArn(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String tableArn) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.dynamodb.TableV2.class, "fromTableArn", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.dynamodb.ITableV2.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(tableArn, "tableArn is required") });
    }

    /**
     * Creates a Table construct that represents an external table.
     * <p>
     * @param scope the parent creating construct (usually <code>this</code>). This parameter is required.
     * @param id the construct's name. This parameter is required.
     * @param attrs attributes of the table. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.dynamodb.ITableV2 fromTableAttributes(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.dynamodb.TableAttributesV2 attrs) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.dynamodb.TableV2.class, "fromTableAttributes", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.dynamodb.ITableV2.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(attrs, "attrs is required") });
    }

    /**
     * Creates a Table construct that represents an external table via table name.
     * <p>
     * @param scope the parent creating construct (usually <code>this</code>). This parameter is required.
     * @param id the construct's name. This parameter is required.
     * @param tableName the table's name. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.dynamodb.ITableV2 fromTableName(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String tableName) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.dynamodb.TableV2.class, "fromTableName", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.dynamodb.ITableV2.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(tableName, "tableName is required") });
    }

    /**
     * Add a global secondary index to the table.
     * <p>
     * Note: Global secondary indexes will be inherited by all replica tables.
     * <p>
     * @param props the properties of the global secondary index. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addGlobalSecondaryIndex(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.dynamodb.GlobalSecondaryIndexPropsV2 props) {
        software.amazon.jsii.Kernel.call(this, "addGlobalSecondaryIndex", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Add a local secondary index to the table.
     * <p>
     * Note: Local secondary indexes will be inherited by all replica tables.
     * <p>
     * @param props the properties of the local secondary index. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addLocalSecondaryIndex(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.dynamodb.LocalSecondaryIndexProps props) {
        software.amazon.jsii.Kernel.call(this, "addLocalSecondaryIndex", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Add a replica table.
     * <p>
     * Note: Adding a replica table will allow you to use your table as a global table.
     * <p>
     * @param props the properties of the replica table to add. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addReplica(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.dynamodb.ReplicaTableProps props) {
        software.amazon.jsii.Kernel.call(this, "addReplica", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Retrieve a replica table.
     * <p>
     * Note: Replica tables are not supported in a region agnostic stack.
     * <p>
     * @param region the region of the replica table. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.dynamodb.ITableV2 replica(final @org.jetbrains.annotations.NotNull java.lang.String region) {
        return software.amazon.jsii.Kernel.call(this, "replica", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.dynamodb.ITableV2.class), new Object[] { java.util.Objects.requireNonNull(region, "region is required") });
    }

    /**
     * Uniquely identifies this class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String PROPERTY_INJECTION_ID;

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.lang.Boolean getHasIndex() {
        return software.amazon.jsii.Kernel.get(this, "hasIndex", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.lang.String getRegion() {
        return software.amazon.jsii.Kernel.get(this, "region", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ARN of the table.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getTableArn() {
        return software.amazon.jsii.Kernel.get(this, "tableArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the table.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getTableName() {
        return software.amazon.jsii.Kernel.get(this, "tableName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * The KMS encryption key for the table.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.kms.IKey getEncryptionKey() {
        return software.amazon.jsii.Kernel.get(this, "encryptionKey", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kms.IKey.class));
    }

    /**
     * The ID of the table.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getTableId() {
        return software.amazon.jsii.Kernel.get(this, "tableId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The stream ARN of the table.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getTableStreamArn() {
        return software.amazon.jsii.Kernel.get(this, "tableStreamArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The resource policy for the table.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.PolicyDocument getResourcePolicy() {
        return software.amazon.jsii.Kernel.get(this, "resourcePolicy", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.PolicyDocument.class));
    }

    /**
     * The resource policy for the table.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setResourcePolicy(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.PolicyDocument value) {
        software.amazon.jsii.Kernel.set(this, "resourcePolicy", value);
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.dynamodb.TableV2}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.dynamodb.TableV2> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.dynamodb.TablePropsV2.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.dynamodb.TablePropsV2.Builder();
        }

        /**
         * Whether CloudWatch contributor insights is enabled.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param contributorInsights Whether CloudWatch contributor insights is enabled. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder contributorInsights(final java.lang.Boolean contributorInsights) {
            this.props.contributorInsights(contributorInsights);
            return this;
        }

        /**
         * Whether deletion protection is enabled.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param deletionProtection Whether deletion protection is enabled. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deletionProtection(final java.lang.Boolean deletionProtection) {
            this.props.deletionProtection(deletionProtection);
            return this;
        }

        /**
         * Kinesis Data Stream to capture item level changes.
         * <p>
         * Default: - no Kinesis Data Stream
         * <p>
         * @return {@code this}
         * @param kinesisStream Kinesis Data Stream to capture item level changes. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kinesisStream(final software.amazon.awscdk.services.kinesis.IStream kinesisStream) {
            this.props.kinesisStream(kinesisStream);
            return this;
        }

        /**
         * (deprecated) Whether point-in-time recovery is enabled.
         * <p>
         * Default: false - point in time recovery is not enabled.
         * <p>
         * @return {@code this}
         * @deprecated use <code>pointInTimeRecoverySpecification</code> instead
         * @param pointInTimeRecovery Whether point-in-time recovery is enabled. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder pointInTimeRecovery(final java.lang.Boolean pointInTimeRecovery) {
            this.props.pointInTimeRecovery(pointInTimeRecovery);
            return this;
        }

        /**
         * Whether point-in-time recovery is enabled and recoveryPeriodInDays is set.
         * <p>
         * Default: - point in time recovery is not enabled.
         * <p>
         * @return {@code this}
         * @param pointInTimeRecoverySpecification Whether point-in-time recovery is enabled and recoveryPeriodInDays is set. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder pointInTimeRecoverySpecification(final software.amazon.awscdk.services.dynamodb.PointInTimeRecoverySpecification pointInTimeRecoverySpecification) {
            this.props.pointInTimeRecoverySpecification(pointInTimeRecoverySpecification);
            return this;
        }

        /**
         * Resource policy to assign to DynamoDB Table.
         * <p>
         * Default: - No resource policy statements are added to the created table.
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-replicaspecification.html#cfn-dynamodb-globaltable-replicaspecification-resourcepolicy">https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-replicaspecification.html#cfn-dynamodb-globaltable-replicaspecification-resourcepolicy</a>
         * @param resourcePolicy Resource policy to assign to DynamoDB Table. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resourcePolicy(final software.amazon.awscdk.services.iam.PolicyDocument resourcePolicy) {
            this.props.resourcePolicy(resourcePolicy);
            return this;
        }

        /**
         * The table class.
         * <p>
         * Default: TableClass.STANDARD
         * <p>
         * @return {@code this}
         * @param tableClass The table class. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tableClass(final software.amazon.awscdk.services.dynamodb.TableClass tableClass) {
            this.props.tableClass(tableClass);
            return this;
        }

        /**
         * Tags to be applied to the primary table (default replica table).
         * <p>
         * Default: - no tags
         * <p>
         * @return {@code this}
         * @param tags Tags to be applied to the primary table (default replica table). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * Partition key attribute definition.
         * <p>
         * @return {@code this}
         * @param partitionKey Partition key attribute definition. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder partitionKey(final software.amazon.awscdk.services.dynamodb.Attribute partitionKey) {
            this.props.partitionKey(partitionKey);
            return this;
        }

        /**
         * The billing mode and capacity settings to apply to the table.
         * <p>
         * Default: Billing.onDemand()
         * <p>
         * @return {@code this}
         * @param billing The billing mode and capacity settings to apply to the table. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder billing(final software.amazon.awscdk.services.dynamodb.Billing billing) {
            this.props.billing(billing);
            return this;
        }

        /**
         * When an item in the table is modified, StreamViewType determines what information is written to the stream.
         * <p>
         * Default: - streams are disabled if replicas are not configured and this property is
         * not specified. If this property is not specified when replicas are configured, then
         * NEW_AND_OLD_IMAGES will be the StreamViewType for all replicas
         * <p>
         * @return {@code this}
         * @param dynamoStream When an item in the table is modified, StreamViewType determines what information is written to the stream. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dynamoStream(final software.amazon.awscdk.services.dynamodb.StreamViewType dynamoStream) {
            this.props.dynamoStream(dynamoStream);
            return this;
        }

        /**
         * The server-side encryption.
         * <p>
         * Default: TableEncryptionV2.dynamoOwnedKey()
         * <p>
         * @return {@code this}
         * @param encryption The server-side encryption. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder encryption(final software.amazon.awscdk.services.dynamodb.TableEncryptionV2 encryption) {
            this.props.encryption(encryption);
            return this;
        }

        /**
         * Global secondary indexes.
         * <p>
         * Note: You can provide a maximum of 20 global secondary indexes.
         * <p>
         * Default: - no global secondary indexes
         * <p>
         * @return {@code this}
         * @param globalSecondaryIndexes Global secondary indexes. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder globalSecondaryIndexes(final java.util.List<? extends software.amazon.awscdk.services.dynamodb.GlobalSecondaryIndexPropsV2> globalSecondaryIndexes) {
            this.props.globalSecondaryIndexes(globalSecondaryIndexes);
            return this;
        }

        /**
         * Local secondary indexes.
         * <p>
         * Note: You can only provide a maximum of 5 local secondary indexes.
         * <p>
         * Default: - no local secondary indexes
         * <p>
         * @return {@code this}
         * @param localSecondaryIndexes Local secondary indexes. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder localSecondaryIndexes(final java.util.List<? extends software.amazon.awscdk.services.dynamodb.LocalSecondaryIndexProps> localSecondaryIndexes) {
            this.props.localSecondaryIndexes(localSecondaryIndexes);
            return this;
        }

        /**
         * The removal policy applied to the table.
         * <p>
         * Default: RemovalPolicy.RETAIN
         * <p>
         * @return {@code this}
         * @param removalPolicy The removal policy applied to the table. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder removalPolicy(final software.amazon.awscdk.RemovalPolicy removalPolicy) {
            this.props.removalPolicy(removalPolicy);
            return this;
        }

        /**
         * Replica tables to deploy with the primary table.
         * <p>
         * Note: Adding replica tables allows you to use your table as a global table. You
         * cannot specify a replica table in the region that the primary table will be deployed
         * to. Replica tables will only be supported if the stack deployment region is defined.
         * <p>
         * Default: - no replica tables
         * <p>
         * @return {@code this}
         * @param replicas Replica tables to deploy with the primary table. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder replicas(final java.util.List<? extends software.amazon.awscdk.services.dynamodb.ReplicaTableProps> replicas) {
            this.props.replicas(replicas);
            return this;
        }

        /**
         * Sort key attribute definition.
         * <p>
         * Default: - no sort key
         * <p>
         * @return {@code this}
         * @param sortKey Sort key attribute definition. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sortKey(final software.amazon.awscdk.services.dynamodb.Attribute sortKey) {
            this.props.sortKey(sortKey);
            return this;
        }

        /**
         * The name of the table.
         * <p>
         * Default: - generated by CloudFormation
         * <p>
         * @return {@code this}
         * @param tableName The name of the table. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tableName(final java.lang.String tableName) {
            this.props.tableName(tableName);
            return this;
        }

        /**
         * The name of the TTL attribute.
         * <p>
         * Default: - TTL is disabled
         * <p>
         * @return {@code this}
         * @param timeToLiveAttribute The name of the TTL attribute. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder timeToLiveAttribute(final java.lang.String timeToLiveAttribute) {
            this.props.timeToLiveAttribute(timeToLiveAttribute);
            return this;
        }

        /**
         * The warm throughput configuration for the table.
         * <p>
         * Default: - no warm throughput is configured
         * <p>
         * @return {@code this}
         * @param warmThroughput The warm throughput configuration for the table. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder warmThroughput(final software.amazon.awscdk.services.dynamodb.WarmThroughput warmThroughput) {
            this.props.warmThroughput(warmThroughput);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.dynamodb.TableV2}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.dynamodb.TableV2 build() {
            return new software.amazon.awscdk.services.dynamodb.TableV2(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
