package software.amazon.awscdk.services.ec2;

/**
 * Amazon Linux 2 kernel versions.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Vpc vpc;
 * InstanceType instanceType;
 * // Amazon Linux 2
 * // Amazon Linux 2
 * Instance.Builder.create(this, "Instance2")
 *         .vpc(vpc)
 *         .instanceType(instanceType)
 *         .machineImage(MachineImage.latestAmazonLinux2())
 *         .build();
 * // Amazon Linux 2 with kernel 5.x
 * // Amazon Linux 2 with kernel 5.x
 * Instance.Builder.create(this, "Instance3")
 *         .vpc(vpc)
 *         .instanceType(instanceType)
 *         .machineImage(MachineImage.latestAmazonLinux2(AmazonLinux2ImageSsmParameterProps.builder()
 *                 .kernel(AmazonLinux2Kernel.KERNEL_5_10)
 *                 .build()))
 *         .build();
 * // Amazon Linux 2023
 * // Amazon Linux 2023
 * Instance.Builder.create(this, "Instance4")
 *         .vpc(vpc)
 *         .instanceType(instanceType)
 *         .machineImage(MachineImage.latestAmazonLinux2023())
 *         .build();
 * // Graviton 3 Processor
 * // Graviton 3 Processor
 * Instance.Builder.create(this, "Instance5")
 *         .vpc(vpc)
 *         .instanceType(InstanceType.of(InstanceClass.C7G, InstanceSize.LARGE))
 *         .machineImage(MachineImage.latestAmazonLinux2023(AmazonLinux2023ImageSsmParameterProps.builder()
 *                 .cpuType(AmazonLinuxCpuType.ARM_64)
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-08-06T18:14:35.857Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ec2.AmazonLinux2Kernel")
public class AmazonLinux2Kernel extends software.amazon.jsii.JsiiObject {

    protected AmazonLinux2Kernel(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected AmazonLinux2Kernel(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CDK_LATEST = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.AmazonLinux2Kernel.class, "CDK_LATEST", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.AmazonLinux2Kernel.class));
        DEFAULT = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.AmazonLinux2Kernel.class, "DEFAULT", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.AmazonLinux2Kernel.class));
        KERNEL_5_10 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.AmazonLinux2Kernel.class, "KERNEL_5_10", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.AmazonLinux2Kernel.class));
    }

    /**
     * @param version This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public AmazonLinux2Kernel(final @org.jetbrains.annotations.NotNull java.lang.String version) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(version, "version is required") });
    }

    /**
     * Generate a string representation of the kernel.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String toString() {
        return software.amazon.jsii.Kernel.call(this, "toString", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The latest kernel version currently available in a published AMI.
     * <p>
     * When a new kernel version is available for an amzn2 AMI this will be
     * updated to contain the latest kernel version and will cause your instances
     * to be replaced. Do not store stateful information on the instance if you are
     * using this version.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.AmazonLinux2Kernel CDK_LATEST;

    /**
     * The default kernel version for Amazon Linux 2 is 4.14 and Linux 4.14.311-233.529.amzn2.x86_64 the SSM parameter does not include it in the name (i.e. /aws/service/ami-amazon-linux-latest/amzn2-ami-hvm-x86_64-gp2).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.AmazonLinux2Kernel DEFAULT;

    /**
     * Kernel version 5.10.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.AmazonLinux2Kernel KERNEL_5_10;
}
