package software.amazon.awscdk.services.ec2;

/**
 * Properties for defining a <code>CfnNetworkInsightsPath</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ec2.*;
 * CfnNetworkInsightsPathProps cfnNetworkInsightsPathProps = CfnNetworkInsightsPathProps.builder()
 *         .protocol("protocol")
 *         .source("source")
 *         // the properties below are optional
 *         .destination("destination")
 *         .destinationIp("destinationIp")
 *         .destinationPort(123)
 *         .filterAtDestination(PathFilterProperty.builder()
 *                 .destinationAddress("destinationAddress")
 *                 .destinationPortRange(FilterPortRangeProperty.builder()
 *                         .fromPort(123)
 *                         .toPort(123)
 *                         .build())
 *                 .sourceAddress("sourceAddress")
 *                 .sourcePortRange(FilterPortRangeProperty.builder()
 *                         .fromPort(123)
 *                         .toPort(123)
 *                         .build())
 *                 .build())
 *         .filterAtSource(PathFilterProperty.builder()
 *                 .destinationAddress("destinationAddress")
 *                 .destinationPortRange(FilterPortRangeProperty.builder()
 *                         .fromPort(123)
 *                         .toPort(123)
 *                         .build())
 *                 .sourceAddress("sourceAddress")
 *                 .sourcePortRange(FilterPortRangeProperty.builder()
 *                         .fromPort(123)
 *                         .toPort(123)
 *                         .build())
 *                 .build())
 *         .sourceIp("sourceIp")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-networkinsightspath.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-networkinsightspath.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-08-06T18:14:36.119Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ec2.CfnNetworkInsightsPathProps")
@software.amazon.jsii.Jsii.Proxy(CfnNetworkInsightsPathProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnNetworkInsightsPathProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The protocol.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-networkinsightspath.html#cfn-ec2-networkinsightspath-protocol">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-networkinsightspath.html#cfn-ec2-networkinsightspath-protocol</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getProtocol();

    /**
     * The ID or ARN of the source.
     * <p>
     * If the resource is in another account, you must specify an ARN.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-networkinsightspath.html#cfn-ec2-networkinsightspath-source">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-networkinsightspath.html#cfn-ec2-networkinsightspath-source</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getSource();

    /**
     * The ID or ARN of the destination.
     * <p>
     * If the resource is in another account, you must specify an ARN.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-networkinsightspath.html#cfn-ec2-networkinsightspath-destination">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-networkinsightspath.html#cfn-ec2-networkinsightspath-destination</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDestination() {
        return null;
    }

    /**
     * The IP address of the destination.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-networkinsightspath.html#cfn-ec2-networkinsightspath-destinationip">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-networkinsightspath.html#cfn-ec2-networkinsightspath-destinationip</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDestinationIp() {
        return null;
    }

    /**
     * The destination port.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-networkinsightspath.html#cfn-ec2-networkinsightspath-destinationport">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-networkinsightspath.html#cfn-ec2-networkinsightspath-destinationport</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getDestinationPort() {
        return null;
    }

    /**
     * Scopes the analysis to network paths that match specific filters at the destination.
     * <p>
     * If you specify this parameter, you can't specify the parameter for the destination IP address.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-networkinsightspath.html#cfn-ec2-networkinsightspath-filteratdestination">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-networkinsightspath.html#cfn-ec2-networkinsightspath-filteratdestination</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getFilterAtDestination() {
        return null;
    }

    /**
     * Scopes the analysis to network paths that match specific filters at the source.
     * <p>
     * If you specify this parameter, you can't specify the parameters for the source IP address or the destination port.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-networkinsightspath.html#cfn-ec2-networkinsightspath-filteratsource">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-networkinsightspath.html#cfn-ec2-networkinsightspath-filteratsource</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getFilterAtSource() {
        return null;
    }

    /**
     * The IP address of the source.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-networkinsightspath.html#cfn-ec2-networkinsightspath-sourceip">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-networkinsightspath.html#cfn-ec2-networkinsightspath-sourceip</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getSourceIp() {
        return null;
    }

    /**
     * The tags to add to the path.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-networkinsightspath.html#cfn-ec2-networkinsightspath-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-networkinsightspath.html#cfn-ec2-networkinsightspath-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnNetworkInsightsPathProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnNetworkInsightsPathProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnNetworkInsightsPathProps> {
        java.lang.String protocol;
        java.lang.String source;
        java.lang.String destination;
        java.lang.String destinationIp;
        java.lang.Number destinationPort;
        java.lang.Object filterAtDestination;
        java.lang.Object filterAtSource;
        java.lang.String sourceIp;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnNetworkInsightsPathProps#getProtocol}
         * @param protocol The protocol. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder protocol(java.lang.String protocol) {
            this.protocol = protocol;
            return this;
        }

        /**
         * Sets the value of {@link CfnNetworkInsightsPathProps#getSource}
         * @param source The ID or ARN of the source. This parameter is required.
         *               If the resource is in another account, you must specify an ARN.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder source(java.lang.String source) {
            this.source = source;
            return this;
        }

        /**
         * Sets the value of {@link CfnNetworkInsightsPathProps#getDestination}
         * @param destination The ID or ARN of the destination.
         *                    If the resource is in another account, you must specify an ARN.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder destination(java.lang.String destination) {
            this.destination = destination;
            return this;
        }

        /**
         * Sets the value of {@link CfnNetworkInsightsPathProps#getDestinationIp}
         * @param destinationIp The IP address of the destination.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder destinationIp(java.lang.String destinationIp) {
            this.destinationIp = destinationIp;
            return this;
        }

        /**
         * Sets the value of {@link CfnNetworkInsightsPathProps#getDestinationPort}
         * @param destinationPort The destination port.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder destinationPort(java.lang.Number destinationPort) {
            this.destinationPort = destinationPort;
            return this;
        }

        /**
         * Sets the value of {@link CfnNetworkInsightsPathProps#getFilterAtDestination}
         * @param filterAtDestination Scopes the analysis to network paths that match specific filters at the destination.
         *                            If you specify this parameter, you can't specify the parameter for the destination IP address.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder filterAtDestination(software.amazon.awscdk.IResolvable filterAtDestination) {
            this.filterAtDestination = filterAtDestination;
            return this;
        }

        /**
         * Sets the value of {@link CfnNetworkInsightsPathProps#getFilterAtDestination}
         * @param filterAtDestination Scopes the analysis to network paths that match specific filters at the destination.
         *                            If you specify this parameter, you can't specify the parameter for the destination IP address.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder filterAtDestination(software.amazon.awscdk.services.ec2.CfnNetworkInsightsPath.PathFilterProperty filterAtDestination) {
            this.filterAtDestination = filterAtDestination;
            return this;
        }

        /**
         * Sets the value of {@link CfnNetworkInsightsPathProps#getFilterAtSource}
         * @param filterAtSource Scopes the analysis to network paths that match specific filters at the source.
         *                       If you specify this parameter, you can't specify the parameters for the source IP address or the destination port.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder filterAtSource(software.amazon.awscdk.IResolvable filterAtSource) {
            this.filterAtSource = filterAtSource;
            return this;
        }

        /**
         * Sets the value of {@link CfnNetworkInsightsPathProps#getFilterAtSource}
         * @param filterAtSource Scopes the analysis to network paths that match specific filters at the source.
         *                       If you specify this parameter, you can't specify the parameters for the source IP address or the destination port.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder filterAtSource(software.amazon.awscdk.services.ec2.CfnNetworkInsightsPath.PathFilterProperty filterAtSource) {
            this.filterAtSource = filterAtSource;
            return this;
        }

        /**
         * Sets the value of {@link CfnNetworkInsightsPathProps#getSourceIp}
         * @param sourceIp The IP address of the source.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourceIp(java.lang.String sourceIp) {
            this.sourceIp = sourceIp;
            return this;
        }

        /**
         * Sets the value of {@link CfnNetworkInsightsPathProps#getTags}
         * @param tags The tags to add to the path.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnNetworkInsightsPathProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnNetworkInsightsPathProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnNetworkInsightsPathProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnNetworkInsightsPathProps {
        private final java.lang.String protocol;
        private final java.lang.String source;
        private final java.lang.String destination;
        private final java.lang.String destinationIp;
        private final java.lang.Number destinationPort;
        private final java.lang.Object filterAtDestination;
        private final java.lang.Object filterAtSource;
        private final java.lang.String sourceIp;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.protocol = software.amazon.jsii.Kernel.get(this, "protocol", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.source = software.amazon.jsii.Kernel.get(this, "source", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.destination = software.amazon.jsii.Kernel.get(this, "destination", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.destinationIp = software.amazon.jsii.Kernel.get(this, "destinationIp", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.destinationPort = software.amazon.jsii.Kernel.get(this, "destinationPort", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.filterAtDestination = software.amazon.jsii.Kernel.get(this, "filterAtDestination", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.filterAtSource = software.amazon.jsii.Kernel.get(this, "filterAtSource", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.sourceIp = software.amazon.jsii.Kernel.get(this, "sourceIp", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.protocol = java.util.Objects.requireNonNull(builder.protocol, "protocol is required");
            this.source = java.util.Objects.requireNonNull(builder.source, "source is required");
            this.destination = builder.destination;
            this.destinationIp = builder.destinationIp;
            this.destinationPort = builder.destinationPort;
            this.filterAtDestination = builder.filterAtDestination;
            this.filterAtSource = builder.filterAtSource;
            this.sourceIp = builder.sourceIp;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.String getProtocol() {
            return this.protocol;
        }

        @Override
        public final java.lang.String getSource() {
            return this.source;
        }

        @Override
        public final java.lang.String getDestination() {
            return this.destination;
        }

        @Override
        public final java.lang.String getDestinationIp() {
            return this.destinationIp;
        }

        @Override
        public final java.lang.Number getDestinationPort() {
            return this.destinationPort;
        }

        @Override
        public final java.lang.Object getFilterAtDestination() {
            return this.filterAtDestination;
        }

        @Override
        public final java.lang.Object getFilterAtSource() {
            return this.filterAtSource;
        }

        @Override
        public final java.lang.String getSourceIp() {
            return this.sourceIp;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("protocol", om.valueToTree(this.getProtocol()));
            data.set("source", om.valueToTree(this.getSource()));
            if (this.getDestination() != null) {
                data.set("destination", om.valueToTree(this.getDestination()));
            }
            if (this.getDestinationIp() != null) {
                data.set("destinationIp", om.valueToTree(this.getDestinationIp()));
            }
            if (this.getDestinationPort() != null) {
                data.set("destinationPort", om.valueToTree(this.getDestinationPort()));
            }
            if (this.getFilterAtDestination() != null) {
                data.set("filterAtDestination", om.valueToTree(this.getFilterAtDestination()));
            }
            if (this.getFilterAtSource() != null) {
                data.set("filterAtSource", om.valueToTree(this.getFilterAtSource()));
            }
            if (this.getSourceIp() != null) {
                data.set("sourceIp", om.valueToTree(this.getSourceIp()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ec2.CfnNetworkInsightsPathProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnNetworkInsightsPathProps.Jsii$Proxy that = (CfnNetworkInsightsPathProps.Jsii$Proxy) o;

            if (!protocol.equals(that.protocol)) return false;
            if (!source.equals(that.source)) return false;
            if (this.destination != null ? !this.destination.equals(that.destination) : that.destination != null) return false;
            if (this.destinationIp != null ? !this.destinationIp.equals(that.destinationIp) : that.destinationIp != null) return false;
            if (this.destinationPort != null ? !this.destinationPort.equals(that.destinationPort) : that.destinationPort != null) return false;
            if (this.filterAtDestination != null ? !this.filterAtDestination.equals(that.filterAtDestination) : that.filterAtDestination != null) return false;
            if (this.filterAtSource != null ? !this.filterAtSource.equals(that.filterAtSource) : that.filterAtSource != null) return false;
            if (this.sourceIp != null ? !this.sourceIp.equals(that.sourceIp) : that.sourceIp != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.protocol.hashCode();
            result = 31 * result + (this.source.hashCode());
            result = 31 * result + (this.destination != null ? this.destination.hashCode() : 0);
            result = 31 * result + (this.destinationIp != null ? this.destinationIp.hashCode() : 0);
            result = 31 * result + (this.destinationPort != null ? this.destinationPort.hashCode() : 0);
            result = 31 * result + (this.filterAtDestination != null ? this.filterAtDestination.hashCode() : 0);
            result = 31 * result + (this.filterAtSource != null ? this.filterAtSource.hashCode() : 0);
            result = 31 * result + (this.sourceIp != null ? this.sourceIp.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
