package software.amazon.awscdk.services.ec2;

/**
 * Properties for defining a <code>CfnVPCEndpoint</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ec2.*;
 * Object policyDocument;
 * CfnVPCEndpointProps cfnVPCEndpointProps = CfnVPCEndpointProps.builder()
 *         .vpcId("vpcId")
 *         // the properties below are optional
 *         .dnsOptions(DnsOptionsSpecificationProperty.builder()
 *                 .dnsRecordIpType("dnsRecordIpType")
 *                 .privateDnsOnlyForInboundResolverEndpoint("privateDnsOnlyForInboundResolverEndpoint")
 *                 .build())
 *         .ipAddressType("ipAddressType")
 *         .policyDocument(policyDocument)
 *         .privateDnsEnabled(false)
 *         .resourceConfigurationArn("resourceConfigurationArn")
 *         .routeTableIds(List.of("routeTableIds"))
 *         .securityGroupIds(List.of("securityGroupIds"))
 *         .serviceName("serviceName")
 *         .serviceNetworkArn("serviceNetworkArn")
 *         .serviceRegion("serviceRegion")
 *         .subnetIds(List.of("subnetIds"))
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .vpcEndpointType("vpcEndpointType")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpoint.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpoint.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-08-06T18:14:36.274Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ec2.CfnVPCEndpointProps")
@software.amazon.jsii.Jsii.Proxy(CfnVPCEndpointProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnVPCEndpointProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ID of the VPC.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpoint.html#cfn-ec2-vpcendpoint-vpcid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpoint.html#cfn-ec2-vpcendpoint-vpcid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getVpcId();

    /**
     * Describes the DNS options for an endpoint.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpoint.html#cfn-ec2-vpcendpoint-dnsoptions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpoint.html#cfn-ec2-vpcendpoint-dnsoptions</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getDnsOptions() {
        return null;
    }

    /**
     * The supported IP address types.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpoint.html#cfn-ec2-vpcendpoint-ipaddresstype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpoint.html#cfn-ec2-vpcendpoint-ipaddresstype</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getIpAddressType() {
        return null;
    }

    /**
     * An endpoint policy, which controls access to the service from the VPC.
     * <p>
     * The default endpoint policy allows full access to the service. Endpoint policies are supported only for gateway and interface endpoints.
     * <p>
     * For CloudFormation templates in YAML, you can provide the policy in JSON or YAML format. For example, if you have a JSON policy, you can convert it to YAML before including it in the YAML template, and AWS CloudFormation converts the policy to JSON format before calling the API actions for AWS PrivateLink . Alternatively, you can include the JSON directly in the YAML, as shown in the following <code>Properties</code> section:
     * <p>
     * <code>Properties: VpcEndpointType: 'Interface' ServiceName: !Sub 'com.amazonaws.${AWS::Region}.logs' PolicyDocument: '{ "Version":"2012-10-17", "Statement": [{ "Effect":"Allow", "Principal":"*", "Action":["logs:Describe*","logs:Get*","logs:List*","logs:FilterLogEvents"], "Resource":"*" }] }'</code>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpoint.html#cfn-ec2-vpcendpoint-policydocument">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpoint.html#cfn-ec2-vpcendpoint-policydocument</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getPolicyDocument() {
        return null;
    }

    /**
     * Indicate whether to associate a private hosted zone with the specified VPC.
     * <p>
     * The private hosted zone contains a record set for the default public DNS name for the service for the Region (for example, <code>kinesis.us-east-1.amazonaws.com</code> ), which resolves to the private IP addresses of the endpoint network interfaces in the VPC. This enables you to make requests to the default public DNS name for the service instead of the public DNS names that are automatically generated by the VPC endpoint service.
     * <p>
     * To use a private hosted zone, you must set the following VPC attributes to <code>true</code> : <code>enableDnsHostnames</code> and <code>enableDnsSupport</code> .
     * <p>
     * This property is supported only for interface endpoints.
     * <p>
     * Default: <code>false</code>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpoint.html#cfn-ec2-vpcendpoint-privatednsenabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpoint.html#cfn-ec2-vpcendpoint-privatednsenabled</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getPrivateDnsEnabled() {
        return null;
    }

    /**
     * The Amazon Resource Name (ARN) of the resource configuration.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpoint.html#cfn-ec2-vpcendpoint-resourceconfigurationarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpoint.html#cfn-ec2-vpcendpoint-resourceconfigurationarn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getResourceConfigurationArn() {
        return null;
    }

    /**
     * The IDs of the route tables.
     * <p>
     * Routing is supported only for gateway endpoints.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpoint.html#cfn-ec2-vpcendpoint-routetableids">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpoint.html#cfn-ec2-vpcendpoint-routetableids</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getRouteTableIds() {
        return null;
    }

    /**
     * The IDs of the security groups to associate with the endpoint network interfaces.
     * <p>
     * If this parameter is not specified, we use the default security group for the VPC. Security groups are supported only for interface endpoints.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpoint.html#cfn-ec2-vpcendpoint-securitygroupids">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpoint.html#cfn-ec2-vpcendpoint-securitygroupids</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getSecurityGroupIds() {
        return null;
    }

    /**
     * The name of the endpoint service.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpoint.html#cfn-ec2-vpcendpoint-servicename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpoint.html#cfn-ec2-vpcendpoint-servicename</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getServiceName() {
        return null;
    }

    /**
     * The Amazon Resource Name (ARN) of the service network.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpoint.html#cfn-ec2-vpcendpoint-servicenetworkarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpoint.html#cfn-ec2-vpcendpoint-servicenetworkarn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getServiceNetworkArn() {
        return null;
    }

    /**
     * Describes a Region.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpoint.html#cfn-ec2-vpcendpoint-serviceregion">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpoint.html#cfn-ec2-vpcendpoint-serviceregion</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getServiceRegion() {
        return null;
    }

    /**
     * The IDs of the subnets in which to create endpoint network interfaces.
     * <p>
     * You must specify this property for an interface endpoint or a Gateway Load Balancer endpoint. You can't specify this property for a gateway endpoint. For a Gateway Load Balancer endpoint, you can specify only one subnet.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpoint.html#cfn-ec2-vpcendpoint-subnetids">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpoint.html#cfn-ec2-vpcendpoint-subnetids</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getSubnetIds() {
        return null;
    }

    /**
     * The tags to associate with the endpoint.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpoint.html#cfn-ec2-vpcendpoint-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpoint.html#cfn-ec2-vpcendpoint-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * The type of endpoint.
     * <p>
     * Default: Gateway
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpoint.html#cfn-ec2-vpcendpoint-vpcendpointtype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpoint.html#cfn-ec2-vpcendpoint-vpcendpointtype</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getVpcEndpointType() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnVPCEndpointProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnVPCEndpointProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnVPCEndpointProps> {
        java.lang.String vpcId;
        java.lang.Object dnsOptions;
        java.lang.String ipAddressType;
        java.lang.Object policyDocument;
        java.lang.Object privateDnsEnabled;
        java.lang.String resourceConfigurationArn;
        java.util.List<java.lang.String> routeTableIds;
        java.util.List<java.lang.String> securityGroupIds;
        java.lang.String serviceName;
        java.lang.String serviceNetworkArn;
        java.lang.String serviceRegion;
        java.util.List<java.lang.String> subnetIds;
        java.util.List<software.amazon.awscdk.CfnTag> tags;
        java.lang.String vpcEndpointType;

        /**
         * Sets the value of {@link CfnVPCEndpointProps#getVpcId}
         * @param vpcId The ID of the VPC. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcId(java.lang.String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        /**
         * Sets the value of {@link CfnVPCEndpointProps#getDnsOptions}
         * @param dnsOptions Describes the DNS options for an endpoint.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dnsOptions(software.amazon.awscdk.IResolvable dnsOptions) {
            this.dnsOptions = dnsOptions;
            return this;
        }

        /**
         * Sets the value of {@link CfnVPCEndpointProps#getDnsOptions}
         * @param dnsOptions Describes the DNS options for an endpoint.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dnsOptions(software.amazon.awscdk.services.ec2.CfnVPCEndpoint.DnsOptionsSpecificationProperty dnsOptions) {
            this.dnsOptions = dnsOptions;
            return this;
        }

        /**
         * Sets the value of {@link CfnVPCEndpointProps#getIpAddressType}
         * @param ipAddressType The supported IP address types.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ipAddressType(java.lang.String ipAddressType) {
            this.ipAddressType = ipAddressType;
            return this;
        }

        /**
         * Sets the value of {@link CfnVPCEndpointProps#getPolicyDocument}
         * @param policyDocument An endpoint policy, which controls access to the service from the VPC.
         *                       The default endpoint policy allows full access to the service. Endpoint policies are supported only for gateway and interface endpoints.
         *                       <p>
         *                       For CloudFormation templates in YAML, you can provide the policy in JSON or YAML format. For example, if you have a JSON policy, you can convert it to YAML before including it in the YAML template, and AWS CloudFormation converts the policy to JSON format before calling the API actions for AWS PrivateLink . Alternatively, you can include the JSON directly in the YAML, as shown in the following <code>Properties</code> section:
         *                       <p>
         *                       <code>Properties: VpcEndpointType: 'Interface' ServiceName: !Sub 'com.amazonaws.${AWS::Region}.logs' PolicyDocument: '{ "Version":"2012-10-17", "Statement": [{ "Effect":"Allow", "Principal":"*", "Action":["logs:Describe*","logs:Get*","logs:List*","logs:FilterLogEvents"], "Resource":"*" }] }'</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder policyDocument(java.lang.Object policyDocument) {
            this.policyDocument = policyDocument;
            return this;
        }

        /**
         * Sets the value of {@link CfnVPCEndpointProps#getPrivateDnsEnabled}
         * @param privateDnsEnabled Indicate whether to associate a private hosted zone with the specified VPC.
         *                          The private hosted zone contains a record set for the default public DNS name for the service for the Region (for example, <code>kinesis.us-east-1.amazonaws.com</code> ), which resolves to the private IP addresses of the endpoint network interfaces in the VPC. This enables you to make requests to the default public DNS name for the service instead of the public DNS names that are automatically generated by the VPC endpoint service.
         *                          <p>
         *                          To use a private hosted zone, you must set the following VPC attributes to <code>true</code> : <code>enableDnsHostnames</code> and <code>enableDnsSupport</code> .
         *                          <p>
         *                          This property is supported only for interface endpoints.
         *                          <p>
         *                          Default: <code>false</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder privateDnsEnabled(java.lang.Boolean privateDnsEnabled) {
            this.privateDnsEnabled = privateDnsEnabled;
            return this;
        }

        /**
         * Sets the value of {@link CfnVPCEndpointProps#getPrivateDnsEnabled}
         * @param privateDnsEnabled Indicate whether to associate a private hosted zone with the specified VPC.
         *                          The private hosted zone contains a record set for the default public DNS name for the service for the Region (for example, <code>kinesis.us-east-1.amazonaws.com</code> ), which resolves to the private IP addresses of the endpoint network interfaces in the VPC. This enables you to make requests to the default public DNS name for the service instead of the public DNS names that are automatically generated by the VPC endpoint service.
         *                          <p>
         *                          To use a private hosted zone, you must set the following VPC attributes to <code>true</code> : <code>enableDnsHostnames</code> and <code>enableDnsSupport</code> .
         *                          <p>
         *                          This property is supported only for interface endpoints.
         *                          <p>
         *                          Default: <code>false</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder privateDnsEnabled(software.amazon.awscdk.IResolvable privateDnsEnabled) {
            this.privateDnsEnabled = privateDnsEnabled;
            return this;
        }

        /**
         * Sets the value of {@link CfnVPCEndpointProps#getResourceConfigurationArn}
         * @param resourceConfigurationArn The Amazon Resource Name (ARN) of the resource configuration.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resourceConfigurationArn(java.lang.String resourceConfigurationArn) {
            this.resourceConfigurationArn = resourceConfigurationArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnVPCEndpointProps#getRouteTableIds}
         * @param routeTableIds The IDs of the route tables.
         *                      Routing is supported only for gateway endpoints.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder routeTableIds(java.util.List<java.lang.String> routeTableIds) {
            this.routeTableIds = routeTableIds;
            return this;
        }

        /**
         * Sets the value of {@link CfnVPCEndpointProps#getSecurityGroupIds}
         * @param securityGroupIds The IDs of the security groups to associate with the endpoint network interfaces.
         *                         If this parameter is not specified, we use the default security group for the VPC. Security groups are supported only for interface endpoints.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder securityGroupIds(java.util.List<java.lang.String> securityGroupIds) {
            this.securityGroupIds = securityGroupIds;
            return this;
        }

        /**
         * Sets the value of {@link CfnVPCEndpointProps#getServiceName}
         * @param serviceName The name of the endpoint service.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serviceName(java.lang.String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        /**
         * Sets the value of {@link CfnVPCEndpointProps#getServiceNetworkArn}
         * @param serviceNetworkArn The Amazon Resource Name (ARN) of the service network.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serviceNetworkArn(java.lang.String serviceNetworkArn) {
            this.serviceNetworkArn = serviceNetworkArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnVPCEndpointProps#getServiceRegion}
         * @param serviceRegion Describes a Region.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serviceRegion(java.lang.String serviceRegion) {
            this.serviceRegion = serviceRegion;
            return this;
        }

        /**
         * Sets the value of {@link CfnVPCEndpointProps#getSubnetIds}
         * @param subnetIds The IDs of the subnets in which to create endpoint network interfaces.
         *                  You must specify this property for an interface endpoint or a Gateway Load Balancer endpoint. You can't specify this property for a gateway endpoint. For a Gateway Load Balancer endpoint, you can specify only one subnet.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subnetIds(java.util.List<java.lang.String> subnetIds) {
            this.subnetIds = subnetIds;
            return this;
        }

        /**
         * Sets the value of {@link CfnVPCEndpointProps#getTags}
         * @param tags The tags to associate with the endpoint.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Sets the value of {@link CfnVPCEndpointProps#getVpcEndpointType}
         * @param vpcEndpointType The type of endpoint.
         *                        Default: Gateway
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcEndpointType(java.lang.String vpcEndpointType) {
            this.vpcEndpointType = vpcEndpointType;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnVPCEndpointProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnVPCEndpointProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnVPCEndpointProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnVPCEndpointProps {
        private final java.lang.String vpcId;
        private final java.lang.Object dnsOptions;
        private final java.lang.String ipAddressType;
        private final java.lang.Object policyDocument;
        private final java.lang.Object privateDnsEnabled;
        private final java.lang.String resourceConfigurationArn;
        private final java.util.List<java.lang.String> routeTableIds;
        private final java.util.List<java.lang.String> securityGroupIds;
        private final java.lang.String serviceName;
        private final java.lang.String serviceNetworkArn;
        private final java.lang.String serviceRegion;
        private final java.util.List<java.lang.String> subnetIds;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;
        private final java.lang.String vpcEndpointType;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.vpcId = software.amazon.jsii.Kernel.get(this, "vpcId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.dnsOptions = software.amazon.jsii.Kernel.get(this, "dnsOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.ipAddressType = software.amazon.jsii.Kernel.get(this, "ipAddressType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.policyDocument = software.amazon.jsii.Kernel.get(this, "policyDocument", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.privateDnsEnabled = software.amazon.jsii.Kernel.get(this, "privateDnsEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.resourceConfigurationArn = software.amazon.jsii.Kernel.get(this, "resourceConfigurationArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.routeTableIds = software.amazon.jsii.Kernel.get(this, "routeTableIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.securityGroupIds = software.amazon.jsii.Kernel.get(this, "securityGroupIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.serviceName = software.amazon.jsii.Kernel.get(this, "serviceName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.serviceNetworkArn = software.amazon.jsii.Kernel.get(this, "serviceNetworkArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.serviceRegion = software.amazon.jsii.Kernel.get(this, "serviceRegion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.subnetIds = software.amazon.jsii.Kernel.get(this, "subnetIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
            this.vpcEndpointType = software.amazon.jsii.Kernel.get(this, "vpcEndpointType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.vpcId = java.util.Objects.requireNonNull(builder.vpcId, "vpcId is required");
            this.dnsOptions = builder.dnsOptions;
            this.ipAddressType = builder.ipAddressType;
            this.policyDocument = builder.policyDocument;
            this.privateDnsEnabled = builder.privateDnsEnabled;
            this.resourceConfigurationArn = builder.resourceConfigurationArn;
            this.routeTableIds = builder.routeTableIds;
            this.securityGroupIds = builder.securityGroupIds;
            this.serviceName = builder.serviceName;
            this.serviceNetworkArn = builder.serviceNetworkArn;
            this.serviceRegion = builder.serviceRegion;
            this.subnetIds = builder.subnetIds;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
            this.vpcEndpointType = builder.vpcEndpointType;
        }

        @Override
        public final java.lang.String getVpcId() {
            return this.vpcId;
        }

        @Override
        public final java.lang.Object getDnsOptions() {
            return this.dnsOptions;
        }

        @Override
        public final java.lang.String getIpAddressType() {
            return this.ipAddressType;
        }

        @Override
        public final java.lang.Object getPolicyDocument() {
            return this.policyDocument;
        }

        @Override
        public final java.lang.Object getPrivateDnsEnabled() {
            return this.privateDnsEnabled;
        }

        @Override
        public final java.lang.String getResourceConfigurationArn() {
            return this.resourceConfigurationArn;
        }

        @Override
        public final java.util.List<java.lang.String> getRouteTableIds() {
            return this.routeTableIds;
        }

        @Override
        public final java.util.List<java.lang.String> getSecurityGroupIds() {
            return this.securityGroupIds;
        }

        @Override
        public final java.lang.String getServiceName() {
            return this.serviceName;
        }

        @Override
        public final java.lang.String getServiceNetworkArn() {
            return this.serviceNetworkArn;
        }

        @Override
        public final java.lang.String getServiceRegion() {
            return this.serviceRegion;
        }

        @Override
        public final java.util.List<java.lang.String> getSubnetIds() {
            return this.subnetIds;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        public final java.lang.String getVpcEndpointType() {
            return this.vpcEndpointType;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("vpcId", om.valueToTree(this.getVpcId()));
            if (this.getDnsOptions() != null) {
                data.set("dnsOptions", om.valueToTree(this.getDnsOptions()));
            }
            if (this.getIpAddressType() != null) {
                data.set("ipAddressType", om.valueToTree(this.getIpAddressType()));
            }
            if (this.getPolicyDocument() != null) {
                data.set("policyDocument", om.valueToTree(this.getPolicyDocument()));
            }
            if (this.getPrivateDnsEnabled() != null) {
                data.set("privateDnsEnabled", om.valueToTree(this.getPrivateDnsEnabled()));
            }
            if (this.getResourceConfigurationArn() != null) {
                data.set("resourceConfigurationArn", om.valueToTree(this.getResourceConfigurationArn()));
            }
            if (this.getRouteTableIds() != null) {
                data.set("routeTableIds", om.valueToTree(this.getRouteTableIds()));
            }
            if (this.getSecurityGroupIds() != null) {
                data.set("securityGroupIds", om.valueToTree(this.getSecurityGroupIds()));
            }
            if (this.getServiceName() != null) {
                data.set("serviceName", om.valueToTree(this.getServiceName()));
            }
            if (this.getServiceNetworkArn() != null) {
                data.set("serviceNetworkArn", om.valueToTree(this.getServiceNetworkArn()));
            }
            if (this.getServiceRegion() != null) {
                data.set("serviceRegion", om.valueToTree(this.getServiceRegion()));
            }
            if (this.getSubnetIds() != null) {
                data.set("subnetIds", om.valueToTree(this.getSubnetIds()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getVpcEndpointType() != null) {
                data.set("vpcEndpointType", om.valueToTree(this.getVpcEndpointType()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ec2.CfnVPCEndpointProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnVPCEndpointProps.Jsii$Proxy that = (CfnVPCEndpointProps.Jsii$Proxy) o;

            if (!vpcId.equals(that.vpcId)) return false;
            if (this.dnsOptions != null ? !this.dnsOptions.equals(that.dnsOptions) : that.dnsOptions != null) return false;
            if (this.ipAddressType != null ? !this.ipAddressType.equals(that.ipAddressType) : that.ipAddressType != null) return false;
            if (this.policyDocument != null ? !this.policyDocument.equals(that.policyDocument) : that.policyDocument != null) return false;
            if (this.privateDnsEnabled != null ? !this.privateDnsEnabled.equals(that.privateDnsEnabled) : that.privateDnsEnabled != null) return false;
            if (this.resourceConfigurationArn != null ? !this.resourceConfigurationArn.equals(that.resourceConfigurationArn) : that.resourceConfigurationArn != null) return false;
            if (this.routeTableIds != null ? !this.routeTableIds.equals(that.routeTableIds) : that.routeTableIds != null) return false;
            if (this.securityGroupIds != null ? !this.securityGroupIds.equals(that.securityGroupIds) : that.securityGroupIds != null) return false;
            if (this.serviceName != null ? !this.serviceName.equals(that.serviceName) : that.serviceName != null) return false;
            if (this.serviceNetworkArn != null ? !this.serviceNetworkArn.equals(that.serviceNetworkArn) : that.serviceNetworkArn != null) return false;
            if (this.serviceRegion != null ? !this.serviceRegion.equals(that.serviceRegion) : that.serviceRegion != null) return false;
            if (this.subnetIds != null ? !this.subnetIds.equals(that.subnetIds) : that.subnetIds != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            return this.vpcEndpointType != null ? this.vpcEndpointType.equals(that.vpcEndpointType) : that.vpcEndpointType == null;
        }

        @Override
        public final int hashCode() {
            int result = this.vpcId.hashCode();
            result = 31 * result + (this.dnsOptions != null ? this.dnsOptions.hashCode() : 0);
            result = 31 * result + (this.ipAddressType != null ? this.ipAddressType.hashCode() : 0);
            result = 31 * result + (this.policyDocument != null ? this.policyDocument.hashCode() : 0);
            result = 31 * result + (this.privateDnsEnabled != null ? this.privateDnsEnabled.hashCode() : 0);
            result = 31 * result + (this.resourceConfigurationArn != null ? this.resourceConfigurationArn.hashCode() : 0);
            result = 31 * result + (this.routeTableIds != null ? this.routeTableIds.hashCode() : 0);
            result = 31 * result + (this.securityGroupIds != null ? this.securityGroupIds.hashCode() : 0);
            result = 31 * result + (this.serviceName != null ? this.serviceName.hashCode() : 0);
            result = 31 * result + (this.serviceNetworkArn != null ? this.serviceNetworkArn.hashCode() : 0);
            result = 31 * result + (this.serviceRegion != null ? this.serviceRegion.hashCode() : 0);
            result = 31 * result + (this.subnetIds != null ? this.subnetIds.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.vpcEndpointType != null ? this.vpcEndpointType.hashCode() : 0);
            return result;
        }
    }
}
