package software.amazon.awscdk.services.ec2;

/**
 * Properties for defining a <code>CfnVPNGatewayRoutePropagation</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ec2.*;
 * CfnVPNGatewayRoutePropagationProps cfnVPNGatewayRoutePropagationProps = CfnVPNGatewayRoutePropagationProps.builder()
 *         .routeTableIds(List.of("routeTableIds"))
 *         .vpnGatewayId("vpnGatewayId")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpngatewayroutepropagation.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpngatewayroutepropagation.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-08-06T18:14:36.305Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ec2.CfnVPNGatewayRoutePropagationProps")
@software.amazon.jsii.Jsii.Proxy(CfnVPNGatewayRoutePropagationProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnVPNGatewayRoutePropagationProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ID of the route table.
     * <p>
     * The routing table must be associated with the same VPC that the virtual private gateway is attached to.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpngatewayroutepropagation.html#cfn-ec2-vpngatewayroutepropagation-routetableids">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpngatewayroutepropagation.html#cfn-ec2-vpngatewayroutepropagation-routetableids</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getRouteTableIds();

    /**
     * The ID of the virtual private gateway that is attached to a VPC.
     * <p>
     * The virtual private gateway must be attached to the same VPC that the routing tables are associated with.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpngatewayroutepropagation.html#cfn-ec2-vpngatewayroutepropagation-vpngatewayid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpngatewayroutepropagation.html#cfn-ec2-vpngatewayroutepropagation-vpngatewayid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getVpnGatewayId();

    /**
     * @return a {@link Builder} of {@link CfnVPNGatewayRoutePropagationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnVPNGatewayRoutePropagationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnVPNGatewayRoutePropagationProps> {
        java.util.List<java.lang.String> routeTableIds;
        java.lang.String vpnGatewayId;

        /**
         * Sets the value of {@link CfnVPNGatewayRoutePropagationProps#getRouteTableIds}
         * @param routeTableIds The ID of the route table. This parameter is required.
         *                      The routing table must be associated with the same VPC that the virtual private gateway is attached to.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder routeTableIds(java.util.List<java.lang.String> routeTableIds) {
            this.routeTableIds = routeTableIds;
            return this;
        }

        /**
         * Sets the value of {@link CfnVPNGatewayRoutePropagationProps#getVpnGatewayId}
         * @param vpnGatewayId The ID of the virtual private gateway that is attached to a VPC. This parameter is required.
         *                     The virtual private gateway must be attached to the same VPC that the routing tables are associated with.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpnGatewayId(java.lang.String vpnGatewayId) {
            this.vpnGatewayId = vpnGatewayId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnVPNGatewayRoutePropagationProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnVPNGatewayRoutePropagationProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnVPNGatewayRoutePropagationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnVPNGatewayRoutePropagationProps {
        private final java.util.List<java.lang.String> routeTableIds;
        private final java.lang.String vpnGatewayId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.routeTableIds = software.amazon.jsii.Kernel.get(this, "routeTableIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.vpnGatewayId = software.amazon.jsii.Kernel.get(this, "vpnGatewayId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.routeTableIds = java.util.Objects.requireNonNull(builder.routeTableIds, "routeTableIds is required");
            this.vpnGatewayId = java.util.Objects.requireNonNull(builder.vpnGatewayId, "vpnGatewayId is required");
        }

        @Override
        public final java.util.List<java.lang.String> getRouteTableIds() {
            return this.routeTableIds;
        }

        @Override
        public final java.lang.String getVpnGatewayId() {
            return this.vpnGatewayId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("routeTableIds", om.valueToTree(this.getRouteTableIds()));
            data.set("vpnGatewayId", om.valueToTree(this.getVpnGatewayId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ec2.CfnVPNGatewayRoutePropagationProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnVPNGatewayRoutePropagationProps.Jsii$Proxy that = (CfnVPNGatewayRoutePropagationProps.Jsii$Proxy) o;

            if (!routeTableIds.equals(that.routeTableIds)) return false;
            return this.vpnGatewayId.equals(that.vpnGatewayId);
        }

        @Override
        public final int hashCode() {
            int result = this.routeTableIds.hashCode();
            result = 31 * result + (this.vpnGatewayId.hashCode());
            return result;
        }
    }
}
