package software.amazon.awscdk.services.ec2;

/**
 * A VPC flow log.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * CfnTransitGateway tgw;
 * FlowLog.Builder.create(this, "TransitGatewayFlowLog")
 *         .resourceType(FlowLogResourceType.fromTransitGatewayId(tgw.getRef()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-08-06T18:14:36.365Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ec2.FlowLog")
public class FlowLog extends software.amazon.awscdk.Resource implements software.amazon.awscdk.services.ec2.IFlowLog {

    protected FlowLog(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected FlowLog(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        PROPERTY_INJECTION_ID = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.FlowLog.class, "PROPERTY_INJECTION_ID", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public FlowLog(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.FlowLogProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Import a Flow Log by it's Id.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param flowLogId This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.IFlowLog fromFlowLogId(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String flowLogId) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ec2.FlowLog.class, "fromFlowLogId", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.IFlowLog.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(flowLogId, "flowLogId is required") });
    }

    /**
     * Uniquely identifies this class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String PROPERTY_INJECTION_ID;

    /**
     * The Id of the VPC Flow Log.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getFlowLogId() {
        return software.amazon.jsii.Kernel.get(this, "flowLogId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The S3 bucket to publish flow logs to.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.s3.IBucket getBucket() {
        return software.amazon.jsii.Kernel.get(this, "bucket", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.s3.IBucket.class));
    }

    /**
     * The ARN of the Amazon Data Firehose delivery stream to publish flow logs to.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDeliveryStreamArn() {
        return software.amazon.jsii.Kernel.get(this, "deliveryStreamArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The iam role used to publish logs to CloudWatch.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.IRole getIamRole() {
        return software.amazon.jsii.Kernel.get(this, "iamRole", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
    }

    /**
     * S3 bucket key prefix to publish the flow logs under.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getKeyPrefix() {
        return software.amazon.jsii.Kernel.get(this, "keyPrefix", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The CloudWatch Logs LogGroup to publish flow logs to.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.logs.ILogGroup getLogGroup() {
        return software.amazon.jsii.Kernel.get(this, "logGroup", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.ILogGroup.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.ec2.FlowLog}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.ec2.FlowLog> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.ec2.FlowLogProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.ec2.FlowLogProps.Builder();
        }

        /**
         * Specifies the type of destination to which the flow log data is to be published.
         * <p>
         * Flow log data can be published to CloudWatch Logs or Amazon S3
         * <p>
         * Default: FlowLogDestinationType.toCloudWatchLogs()
         * <p>
         * @return {@code this}
         * @param destination Specifies the type of destination to which the flow log data is to be published. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder destination(final software.amazon.awscdk.services.ec2.FlowLogDestination destination) {
            this.props.destination(destination);
            return this;
        }

        /**
         * The fields to include in the flow log record, in the order in which they should appear.
         * <p>
         * If multiple fields are specified, they will be separated by spaces. For full control over the literal log format
         * string, pass a single field constructed with <code>LogFormat.custom()</code>.
         * <p>
         * See https://docs.aws.amazon.com/vpc/latest/userguide/flow-logs.html#flow-log-records
         * <p>
         * Default: - default log format is used.
         * <p>
         * @return {@code this}
         * @param logFormat The fields to include in the flow log record, in the order in which they should appear. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logFormat(final java.util.List<? extends software.amazon.awscdk.services.ec2.LogFormat> logFormat) {
            this.props.logFormat(logFormat);
            return this;
        }

        /**
         * The maximum interval of time during which a flow of packets is captured and aggregated into a flow log record.
         * <p>
         * When creating flow logs for a Transit Gateway or Transit Gateway Attachment,
         * this property must be ONE_MINUTES.
         * <p>
         * Default: - FlowLogMaxAggregationInterval.ONE_MINUTES if creating flow logs for Transit Gateway, otherwise FlowLogMaxAggregationInterval.TEN_MINUTES.
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-flowlog.html#cfn-ec2-flowlog-maxaggregationinterval">https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-flowlog.html#cfn-ec2-flowlog-maxaggregationinterval</a>
         * @param maxAggregationInterval The maximum interval of time during which a flow of packets is captured and aggregated into a flow log record. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxAggregationInterval(final software.amazon.awscdk.services.ec2.FlowLogMaxAggregationInterval maxAggregationInterval) {
            this.props.maxAggregationInterval(maxAggregationInterval);
            return this;
        }

        /**
         * The type of traffic to log.
         * <p>
         * You can log traffic that the resource accepts or rejects, or all traffic.
         * When the target is either <code>TransitGateway</code> or <code>TransitGatewayAttachment</code>, setting the traffic type is not possible.
         * <p>
         * Default: ALL
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/vpc/latest/tgw/working-with-flow-logs.html">https://docs.aws.amazon.com/vpc/latest/tgw/working-with-flow-logs.html</a>
         * @param trafficType The type of traffic to log. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder trafficType(final software.amazon.awscdk.services.ec2.FlowLogTrafficType trafficType) {
            this.props.trafficType(trafficType);
            return this;
        }

        /**
         * The type of resource for which to create the flow log.
         * <p>
         * @return {@code this}
         * @param resourceType The type of resource for which to create the flow log. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resourceType(final software.amazon.awscdk.services.ec2.FlowLogResourceType resourceType) {
            this.props.resourceType(resourceType);
            return this;
        }

        /**
         * The name of the FlowLog.
         * <p>
         * Since the FlowLog resource doesn't support providing a physical name, the value provided here will be recorded in the <code>Name</code> tag.
         * <p>
         * Default: CDK generated name
         * <p>
         * @return {@code this}
         * @param flowLogName The name of the FlowLog. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder flowLogName(final java.lang.String flowLogName) {
            this.props.flowLogName(flowLogName);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.ec2.FlowLog}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.ec2.FlowLog build() {
            return new software.amazon.awscdk.services.ec2.FlowLog(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
