package software.amazon.awscdk.services.ec2;

/**
 * Customize subnets that are selected for placement of ENIs.
 * <p>
 * Constructs that allow customization of VPC placement use parameters of this
 * type to provide placement settings.
 * <p>
 * By default, the instances are placed in the private subnets.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Vpc vpc;
 * DatabaseCluster cluster = DatabaseCluster.Builder.create(this, "Database")
 *         .masterUser(Login.builder()
 *                 .username("myuser")
 *                 .build())
 *         .instanceType(InstanceType.of(InstanceClass.MEMORY5, InstanceSize.LARGE))
 *         .vpcSubnets(SubnetSelection.builder()
 *                 .subnetType(SubnetType.PUBLIC)
 *                 .build())
 *         .vpc(vpc)
 *         .removalPolicy(RemovalPolicy.SNAPSHOT)
 *         .instanceRemovalPolicy(RemovalPolicy.RETAIN)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-08-06T18:14:36.512Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ec2.SubnetSelection")
@software.amazon.jsii.Jsii.Proxy(SubnetSelection.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface SubnetSelection extends software.amazon.jsii.JsiiSerializable {

    /**
     * Select subnets only in the given AZs.
     * <p>
     * Default: no filtering on AZs is done
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getAvailabilityZones() {
        return null;
    }

    /**
     * If true, return at most one subnet per AZ.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getOnePerAz() {
        return null;
    }

    /**
     * List of provided subnet filters.
     * <p>
     * Default: - none
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.ec2.SubnetFilter> getSubnetFilters() {
        return null;
    }

    /**
     * Select the subnet group with the given name.
     * <p>
     * Select the subnet group with the given name. This only needs
     * to be used if you have multiple subnet groups of the same type
     * and you need to distinguish between them. Otherwise, prefer
     * <code>subnetType</code>.
     * <p>
     * This field does not select individual subnets, it selects all subnets that
     * share the given subnet group name. This is the name supplied in
     * <code>subnetConfiguration</code>.
     * <p>
     * At most one of <code>subnetType</code> and <code>subnetGroupName</code> can be supplied.
     * <p>
     * Default: - Selection by type instead of by name
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getSubnetGroupName() {
        return null;
    }

    /**
     * Explicitly select individual subnets.
     * <p>
     * Use this if you don't want to automatically use all subnets in
     * a group, but have a need to control selection down to
     * individual subnets.
     * <p>
     * Cannot be specified together with <code>subnetType</code> or <code>subnetGroupName</code>.
     * <p>
     * Default: - Use all subnets in a selected group (all private subnets by default)
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.ec2.ISubnet> getSubnets() {
        return null;
    }

    /**
     * Select all subnets of the given type.
     * <p>
     * At most one of <code>subnetType</code> and <code>subnetGroupName</code> can be supplied.
     * <p>
     * Default: SubnetType.PRIVATE_WITH_EGRESS (or ISOLATED or PUBLIC if there are no PRIVATE_WITH_EGRESS subnets)
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.SubnetType getSubnetType() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link SubnetSelection}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link SubnetSelection}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<SubnetSelection> {
        java.util.List<java.lang.String> availabilityZones;
        java.lang.Boolean onePerAz;
        java.util.List<software.amazon.awscdk.services.ec2.SubnetFilter> subnetFilters;
        java.lang.String subnetGroupName;
        java.util.List<software.amazon.awscdk.services.ec2.ISubnet> subnets;
        software.amazon.awscdk.services.ec2.SubnetType subnetType;

        /**
         * Sets the value of {@link SubnetSelection#getAvailabilityZones}
         * @param availabilityZones Select subnets only in the given AZs.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder availabilityZones(java.util.List<java.lang.String> availabilityZones) {
            this.availabilityZones = availabilityZones;
            return this;
        }

        /**
         * Sets the value of {@link SubnetSelection#getOnePerAz}
         * @param onePerAz If true, return at most one subnet per AZ.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder onePerAz(java.lang.Boolean onePerAz) {
            this.onePerAz = onePerAz;
            return this;
        }

        /**
         * Sets the value of {@link SubnetSelection#getSubnetFilters}
         * @param subnetFilters List of provided subnet filters.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder subnetFilters(java.util.List<? extends software.amazon.awscdk.services.ec2.SubnetFilter> subnetFilters) {
            this.subnetFilters = (java.util.List<software.amazon.awscdk.services.ec2.SubnetFilter>)subnetFilters;
            return this;
        }

        /**
         * Sets the value of {@link SubnetSelection#getSubnetGroupName}
         * @param subnetGroupName Select the subnet group with the given name.
         *                        Select the subnet group with the given name. This only needs
         *                        to be used if you have multiple subnet groups of the same type
         *                        and you need to distinguish between them. Otherwise, prefer
         *                        <code>subnetType</code>.
         *                        <p>
         *                        This field does not select individual subnets, it selects all subnets that
         *                        share the given subnet group name. This is the name supplied in
         *                        <code>subnetConfiguration</code>.
         *                        <p>
         *                        At most one of <code>subnetType</code> and <code>subnetGroupName</code> can be supplied.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subnetGroupName(java.lang.String subnetGroupName) {
            this.subnetGroupName = subnetGroupName;
            return this;
        }

        /**
         * Sets the value of {@link SubnetSelection#getSubnets}
         * @param subnets Explicitly select individual subnets.
         *                Use this if you don't want to automatically use all subnets in
         *                a group, but have a need to control selection down to
         *                individual subnets.
         *                <p>
         *                Cannot be specified together with <code>subnetType</code> or <code>subnetGroupName</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder subnets(java.util.List<? extends software.amazon.awscdk.services.ec2.ISubnet> subnets) {
            this.subnets = (java.util.List<software.amazon.awscdk.services.ec2.ISubnet>)subnets;
            return this;
        }

        /**
         * Sets the value of {@link SubnetSelection#getSubnetType}
         * @param subnetType Select all subnets of the given type.
         *                   At most one of <code>subnetType</code> and <code>subnetGroupName</code> can be supplied.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subnetType(software.amazon.awscdk.services.ec2.SubnetType subnetType) {
            this.subnetType = subnetType;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link SubnetSelection}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public SubnetSelection build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link SubnetSelection}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SubnetSelection {
        private final java.util.List<java.lang.String> availabilityZones;
        private final java.lang.Boolean onePerAz;
        private final java.util.List<software.amazon.awscdk.services.ec2.SubnetFilter> subnetFilters;
        private final java.lang.String subnetGroupName;
        private final java.util.List<software.amazon.awscdk.services.ec2.ISubnet> subnets;
        private final software.amazon.awscdk.services.ec2.SubnetType subnetType;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.availabilityZones = software.amazon.jsii.Kernel.get(this, "availabilityZones", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.onePerAz = software.amazon.jsii.Kernel.get(this, "onePerAz", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.subnetFilters = software.amazon.jsii.Kernel.get(this, "subnetFilters", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.SubnetFilter.class)));
            this.subnetGroupName = software.amazon.jsii.Kernel.get(this, "subnetGroupName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.subnets = software.amazon.jsii.Kernel.get(this, "subnets", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.ISubnet.class)));
            this.subnetType = software.amazon.jsii.Kernel.get(this, "subnetType", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.SubnetType.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.availabilityZones = builder.availabilityZones;
            this.onePerAz = builder.onePerAz;
            this.subnetFilters = (java.util.List<software.amazon.awscdk.services.ec2.SubnetFilter>)builder.subnetFilters;
            this.subnetGroupName = builder.subnetGroupName;
            this.subnets = (java.util.List<software.amazon.awscdk.services.ec2.ISubnet>)builder.subnets;
            this.subnetType = builder.subnetType;
        }

        @Override
        public final java.util.List<java.lang.String> getAvailabilityZones() {
            return this.availabilityZones;
        }

        @Override
        public final java.lang.Boolean getOnePerAz() {
            return this.onePerAz;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.ec2.SubnetFilter> getSubnetFilters() {
            return this.subnetFilters;
        }

        @Override
        public final java.lang.String getSubnetGroupName() {
            return this.subnetGroupName;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.ec2.ISubnet> getSubnets() {
            return this.subnets;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.SubnetType getSubnetType() {
            return this.subnetType;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getAvailabilityZones() != null) {
                data.set("availabilityZones", om.valueToTree(this.getAvailabilityZones()));
            }
            if (this.getOnePerAz() != null) {
                data.set("onePerAz", om.valueToTree(this.getOnePerAz()));
            }
            if (this.getSubnetFilters() != null) {
                data.set("subnetFilters", om.valueToTree(this.getSubnetFilters()));
            }
            if (this.getSubnetGroupName() != null) {
                data.set("subnetGroupName", om.valueToTree(this.getSubnetGroupName()));
            }
            if (this.getSubnets() != null) {
                data.set("subnets", om.valueToTree(this.getSubnets()));
            }
            if (this.getSubnetType() != null) {
                data.set("subnetType", om.valueToTree(this.getSubnetType()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ec2.SubnetSelection"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            SubnetSelection.Jsii$Proxy that = (SubnetSelection.Jsii$Proxy) o;

            if (this.availabilityZones != null ? !this.availabilityZones.equals(that.availabilityZones) : that.availabilityZones != null) return false;
            if (this.onePerAz != null ? !this.onePerAz.equals(that.onePerAz) : that.onePerAz != null) return false;
            if (this.subnetFilters != null ? !this.subnetFilters.equals(that.subnetFilters) : that.subnetFilters != null) return false;
            if (this.subnetGroupName != null ? !this.subnetGroupName.equals(that.subnetGroupName) : that.subnetGroupName != null) return false;
            if (this.subnets != null ? !this.subnets.equals(that.subnets) : that.subnets != null) return false;
            return this.subnetType != null ? this.subnetType.equals(that.subnetType) : that.subnetType == null;
        }

        @Override
        public final int hashCode() {
            int result = this.availabilityZones != null ? this.availabilityZones.hashCode() : 0;
            result = 31 * result + (this.onePerAz != null ? this.onePerAz.hashCode() : 0);
            result = 31 * result + (this.subnetFilters != null ? this.subnetFilters.hashCode() : 0);
            result = 31 * result + (this.subnetGroupName != null ? this.subnetGroupName.hashCode() : 0);
            result = 31 * result + (this.subnets != null ? this.subnets.hashCode() : 0);
            result = 31 * result + (this.subnetType != null ? this.subnetType.hashCode() : 0);
            return result;
        }
    }
}
